package com.beagle.base.common.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

/**
 * @author wuwanli
 */
@Configuration
public class RestTemplateConfig {

    @Bean
    public RestTemplate restTemplate(ClientHttpRequestFactory factory) {
        return new RestTemplate(factory);
    }

    @Bean
    public ClientHttpRequestFactory simpleClientHttpRequestFactory() {
        SkipSslVerificationHttpRequestFactory factory = new SkipSslVerificationHttpRequestFactory();
        // 将响应超时时间设置大点
        factory.setReadTimeout(30000);
        factory.setConnectTimeout(15000);
        return factory;
    }

}
