package com.beagle.base.common.exception;

import com.beagle.base.common.contant.CodeEnum;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * @author wuwanli
 */
@Data
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class BeagleException extends RuntimeException {
    /**
     * 错误码
     */
    protected String errorCode;
    /**
     * 错误信息
     */
    protected String errorMsg;

    public BeagleException(String errorMsg) {
        super(errorMsg);
        this.errorMsg = errorMsg;
    }

    public BeagleException(String errorCode, String errorMsg) {
        super(errorMsg);
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
    }

    public BeagleException(CodeEnum codeEnum) {
        super(codeEnum.getDesc());
        this.errorCode = codeEnum.getCode();
        this.errorMsg = codeEnum.getDesc();
    }

    public BeagleException(String errorMsg, Throwable cause) {
        super(errorMsg, cause);
    }

    public BeagleException(String errorCode, String errorMsg, Throwable cause) {
        super(errorCode, cause);
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
    }
}
