package com.beagle.base.common.util;

import cn.hutool.core.text.CharSequenceUtil;
import com.rtdb.service.impl.*;
import com.rtdb.service.inter.Base;
import com.rtdb.service.inter.Historian;
import com.rtdb.service.inter.Snapshot;

public class CommonUtil {
    private static final String IP = CharSequenceUtil.blankToDefault(System.getenv("GOLDEN_IP"), "10.253.1.97");
    private static final Integer PORT = Integer.parseInt(CharSequenceUtil.blankToDefault(System.getenv("GOLDEN_PORT"), "6327"));
    private static final String USER = CharSequenceUtil.blankToDefault(System.getenv("GOLDEN_USER"), "sa");
    private static final String PASSWORD = CharSequenceUtil.blankToDefault(System.getenv("GOLDEN_PASSWORD"), "golden") ;
    private static Historian his;
    private static Base base;
    private static Snapshot snap;

    private static ServerImpl server;

    private static ServerImplPool pool;

    static {
        try {
            pool = new ServerImplPool(IP, PORT, USER, PASSWORD, 5, 10);
            server = pool.getServerImpl();
            his = new HistorianImpl(server);
            base = new BaseImpl(server);
            snap = new SnapshotImpl(server);
        }catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Historian getHisImpl() {
        return his;
    }

    public static Base getBaseImpl() {
        return base;
    }

    public static Snapshot getSnapshotImpl() {
        return snap;
    }
}
