/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.api.impl;

import com.rtdb.api.callbackInter.RSDataChange;
import com.rtdb.api.callbackInter.RSDataChangeEx;
import com.rtdb.api.enums.RtdbError;
import com.rtdb.api.enums.RtdbGlobalEnum;
import com.rtdb.api.enums.RtdbMsgID;
import com.rtdb.api.exception.EncodePacketErrorException;
import com.rtdb.api.exception.InvalidParameterException;
import com.rtdb.api.exception.NoAuthorityException;
import com.rtdb.api.exception.UnexpectedMethodException;
import com.rtdb.api.impl.Rtdb;
import com.rtdb.api.inter.IServer;
import com.rtdb.api.inter.IServerable;
import com.rtdb.api.inter.ISnapshot;
import com.rtdb.api.inter.msg.SnapshotMessage;
import com.rtdb.api.model.DateTimeNS;
import com.rtdb.api.model.RtdbBlobData;
import com.rtdb.api.model.RtdbDatetimeData;
import com.rtdb.api.model.RtdbEntity;
import com.rtdb.api.model.RtdbField;
import com.rtdb.api.model.RtdbNamedTypeData;
import com.rtdb.api.model.ValueData;
import com.rtdb.api.msg.SnapshotProtocol21;
import com.rtdb.api.msg.SnapshotProtocol30;
import com.rtdb.api.protocol.DatagramSnapshots;
import com.rtdb.api.util.DateUtil;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class RtdbSnapshotImpl
extends Rtdb
implements ISnapshot {
    private IServerable rtdbServer;
    private String version = "3";
    private SnapshotMessage proto;

    public RtdbSnapshotImpl(IServerable rtdbServer) {
        this.rtdbServer = rtdbServer;
        this.init();
    }

    private void init() {
        this.version = this.rtdbServer.getConnection().getApiVersion();
        this.proto = this.version.equals("3") ? SnapshotProtocol30.getInstance() : SnapshotProtocol21.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSnapshots_ns(int count, int[] ids, Date[] datetimes, double[] values, long[] states, short[] qualities, int[] errors, int[] nanosecond) throws UnexpectedMethodException, InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_SNAPSHOTS, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            List<RtdbField> wFields = this.proto.msgGetSnapshotsFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(wFields, false);
            List<RtdbField> rFields = this.proto.msgGetSnapshotsRespFields(count, ids, datetimes, values, states, qualities, errors);
            this.rtdbServer.getConnection().receivePacket(rFields, false);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK && ret != RtdbError.GoE_FALSE) {
                throw new Exception(ret.getErrmsg());
            }
            if (this.version.equals("3")) {
                DatagramSnapshots.datagram_get_snapshots_resp.Builder build = DatagramSnapshots.datagram_get_snapshots_resp.newBuilder();
                RtdbField p = rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                build.mergeFrom(buf, 4, buf.length - 8);
                for (int i = 0; i < count; ++i) {
                    datetimes[i] = DateUtil.getDate(build.getDatetimes(i), 0);
                    values[i] = build.getValues(i);
                    states[i] = build.getStates(i);
                    qualities[i] = (short)build.getQualities(i);
                    errors[i] = build.getErrors(i);
                    nanosecond[i] = build.getMs(i);
                }
            }
            count = this.getCount(rFields);
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSnapshots(int count, int[] ids, Date[] datetimes, double[] values, long[] states, short[] qualities, int[] errors) throws UnexpectedMethodException, InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_SNAPSHOTS, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            List<RtdbField> wFields = this.proto.msgGetSnapshotsFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(wFields, false);
            List<RtdbField> rFields = this.proto.msgGetSnapshotsRespFields(count, ids, datetimes, values, states, qualities, errors);
            this.rtdbServer.getConnection().receivePacket(rFields, false);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK && ret != RtdbError.GoE_FALSE) {
                throw new Exception(ret.getErrmsg());
            }
            if (this.version.equals("3")) {
                DatagramSnapshots.datagram_get_snapshots_resp.Builder build = DatagramSnapshots.datagram_get_snapshots_resp.newBuilder();
                RtdbField p = rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                build.mergeFrom(buf, 4, buf.length - 8);
                for (int i = 0; i < count; ++i) {
                    datetimes[i] = DateUtil.getDate(build.getDatetimes(i), (short)build.getMs(i));
                    values[i] = build.getValues(i);
                    states[i] = build.getStates(i);
                    qualities[i] = (short)build.getQualities(i);
                    errors[i] = build.getErrors(i);
                }
            }
            count = this.getCount(rFields);
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ValueData> getSnapshot(int[] ids) throws InvalidParameterException, NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876");
        }
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_SNAPSHOTS, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        int count = ids.length;
        Date[] datetimes = new Date[count];
        double[] values = new double[count];
        long[] states = new long[count];
        short[] qualities = new short[count];
        int[] errors = new int[count];
        ArrayList<ValueData> list = new ArrayList<ValueData>(ids.length);
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            List<RtdbField> wFields = this.proto.msgGetSnapshotsFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(wFields, false);
            List<RtdbField> rFields = this.proto.msgGetSnapshotsRespFields(count, ids, datetimes, values, states, qualities, errors);
            this.rtdbServer.getConnection().receivePacket(rFields, false);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK && ret != RtdbError.GoE_FALSE) {
                throw new Exception(ret.getErrmsg());
            }
            DatagramSnapshots.datagram_get_snapshots_resp.Builder build = DatagramSnapshots.datagram_get_snapshots_resp.newBuilder();
            RtdbField p = rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])p.getData();
            build.mergeFrom(buf, 4, buf.length - 8);
            for (int i = 0; i < count; ++i) {
                ValueData r = new ValueData();
                r.setId(ids[i]);
                r.setDate(DateUtil.getDate(build.getDatetimes(i), build.getMs(i)));
                r.setQuality((short)build.getQualities(i));
                r.setState(build.getStates(i));
                r.setValue(build.getValues(i));
                r.setError(build.getErrors(i));
                list.add(r);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ValueData> getSnapshot_ns(int[] ids) throws InvalidParameterException, NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876");
        }
        if (ids == null || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_SNAPSHOTS, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        int count = ids.length;
        Date[] datetimes = new Date[count];
        double[] values = new double[count];
        long[] states = new long[count];
        short[] qualities = new short[count];
        int[] errors = new int[count];
        ArrayList<ValueData> list = new ArrayList<ValueData>(ids.length);
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            List<RtdbField> wFields = this.proto.msgGetSnapshotsFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(wFields, false);
            List<RtdbField> rFields = this.proto.msgGetSnapshotsRespFields(count, ids, datetimes, values, states, qualities, errors);
            this.rtdbServer.getConnection().receivePacket(rFields, false);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK && ret != RtdbError.GoE_FALSE) {
                throw new Exception(ret.getErrmsg());
            }
            DatagramSnapshots.datagram_get_snapshots_resp.Builder build = DatagramSnapshots.datagram_get_snapshots_resp.newBuilder();
            RtdbField p = rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])p.getData();
            build.mergeFrom(buf, 4, buf.length - 8);
            for (int i = 0; i < count; ++i) {
                ValueData r = new ValueData();
                r.setId(ids[i]);
                r.setDate(DateUtil.getDate(build.getDatetimes(i), 0));
                r.setQuality((short)build.getQualities(i));
                r.setState(build.getStates(i));
                r.setValue(build.getValues(i));
                r.setError(build.getErrors(i));
                r.setNanosecond(build.getMs(i));
                list.add(r);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int putSnapshots(int count, int[] ids, Object[] datetimes, double[] values, long[] states, short[] qualities, int[] errors) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (count == 0 || ids == null || datetimes == null || values == null || states == null || qualities == null) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_PUT_SNAPSHOTS, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            int[] datetimes_temp = new int[datetimes.length];
            int[] ms_temp = new int[datetimes.length];
            for (int i = 0; i < datetimes.length; ++i) {
                if (datetimes[i].getClass().equals(Date.class)) {
                    datetimes_temp[i] = DateUtil.getSecond((Date)datetimes[i]);
                    ms_temp[i] = DateUtil.getMilSecond((Date)datetimes[i]);
                    continue;
                }
                if (!datetimes[i].getClass().equals(DateTimeNS.class)) continue;
                datetimes_temp[i] = DateUtil.getSecond(((DateTimeNS)datetimes[i]).getDatetime());
                ms_temp[i] = ((DateTimeNS)datetimes[i]).getNanosecond();
            }
            List<RtdbField> fields = this.proto.msgPutSnapshotsFields(count, ids, datetimes_temp, ms_temp, values, states, qualities);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgPutSnapshotsRespFields(count, errors);
            this.rtdbServer.getConnection().receivePacket(fields, false);
            RtdbError ret = this.getRet(fields);
            int successCount = 0;
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.getErrmsg());
            }
            if (this.version.equals("3")) {
                DatagramSnapshots.datagram_put_snapshots_resp.Builder rb = DatagramSnapshots.datagram_put_snapshots_resp.newBuilder();
                byte[] data = (byte[])fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum()).getData();
                rb.mergeFrom(data, 4, data.length - 8);
                List<Integer> errorsList = rb.getErrorsList();
                for (int i = 0; i < errorsList.size(); ++i) {
                    errors[i] = errorsList.get(i);
                }
            }
            successCount = this.getCount(fields);
            return successCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int fixSnapshots(int count, int[] ids, Object[] datetimes, double[] values, long[] states, short[] qualities, int[] errors) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (count <= 0 || ids == null || datetimes == null || values == null || states == null || states == null || qualities == null || errors == null) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_FIX_SNAPSHOTS, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        int[] datetimesVal = new int[datetimes.length];
        int[] msVal = new int[datetimes.length];
        for (int i = 0; i < datetimes.length; ++i) {
            if (datetimes[i].getClass().equals(Date.class)) {
                datetimesVal[i] = DateUtil.getSecond((Date)datetimes[i]);
                msVal[i] = DateUtil.getMilSecond((Date)datetimes[i]);
                continue;
            }
            if (!datetimes[i].getClass().equals(DateTimeNS.class)) continue;
            datetimesVal[i] = DateUtil.getSecond(((DateTimeNS)datetimes[i]).getDatetime());
            msVal[i] = ((DateTimeNS)datetimes[i]).getNanosecond();
        }
        List<RtdbField> fields = this.proto.msgFixSnapshotsFields(count, ids, datetimesVal, msVal, values, states, qualities);
        List<RtdbField> rFields = this.proto.msgFixSnapshotsRespFields(0, 0, 0, errors);
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            this.rtdbServer.getConnection().sendPacket(fields, false);
            this.rtdbServer.getConnection().receivePacket(rFields, true);
        }
        RtdbError ret = this.getRet(rFields);
        if (ret != RtdbError.GoE_OK && ret != RtdbError.GoE_FALSE) {
            throw new Exception(ret.getErrmsg());
        }
        if (this.version.equals("3")) {
            DatagramSnapshots.datagram_fix_snapshots_resp.Builder builder = DatagramSnapshots.datagram_fix_snapshots_resp.newBuilder();
            byte[] data = (byte[])rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum()).getData();
            builder.mergeFrom(data, 4, data.length - 8);
            int count_resp = builder.getErrorsCount();
            for (int i = 0; i < count_resp; ++i) {
                errors[i] = builder.getErrors(i);
            }
        }
        count = this.getCount(rFields);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCoorSnapshots(int count, int[] ids, Date[] datetimes, float[] x, float[] y, short[] qualities, int[] errors) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        if (count <= 0 || ids == null || datetimes == null || x == null || y == null || qualities == null || errors == null) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_COOR_SNAPSHOTS, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        List<RtdbField> fields = this.proto.msgGetCoorSnapshotsFields(count, ids);
        int[] datetimesVal = new int[count];
        int[] msVal = new int[count];
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetCoorSnapshotsRespFields(0, 0, datetimesVal, msVal, x, y, qualities, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
        }
        RtdbError ret = this.getRet(fields);
        if (ret != RtdbError.GoE_OK && ret != RtdbError.GoE_FALSE) {
            throw new Exception(ret.getErrmsg());
        }
        if (this.version.equals("3")) {
            DatagramSnapshots.datagram_get_coor_snapshots_resp.Builder builder = DatagramSnapshots.datagram_get_coor_snapshots_resp.newBuilder();
            RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])p.getData();
            builder.mergeFrom(buf, 4, buf.length - 8);
            int resultCount = builder.getDatetimesCount();
            if (builder.getDatetimesCount() > 0) {
                for (int i = 0; i < resultCount; ++i) {
                    datetimes[i] = DateUtil.getDate(builder.getDatetimes(i), builder.getMs(i));
                    x[i] = builder.getX(i);
                    y[i] = builder.getY(i);
                    qualities[i] = (short)builder.getQualities(i);
                    errors[i] = builder.getErrors(i);
                }
            }
        } else {
            DateUtil.getDate(datetimes, datetimesVal, msVal);
        }
        count = this.getCount(fields);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCoorSnapshots_ns(int count, int[] ids, Date[] datetimes, float[] x, float[] y, short[] qualities, int[] errors, int[] nanosecond) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        if (count <= 0 || ids == null || datetimes == null || x == null || y == null || qualities == null || errors == null) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_COOR_SNAPSHOTS, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        List<RtdbField> fields = this.proto.msgGetCoorSnapshotsFields(count, ids);
        int[] datetimesVal = new int[count];
        int[] msVal = new int[count];
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetCoorSnapshotsRespFields(0, 0, datetimesVal, msVal, x, y, qualities, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
        }
        RtdbError ret = this.getRet(fields);
        if (ret != RtdbError.GoE_OK && ret != RtdbError.GoE_FALSE) {
            throw new Exception(ret.getErrmsg());
        }
        if (this.version.equals("3")) {
            DatagramSnapshots.datagram_get_coor_snapshots_resp.Builder builder = DatagramSnapshots.datagram_get_coor_snapshots_resp.newBuilder();
            RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])p.getData();
            builder.mergeFrom(buf, 4, buf.length - 8);
            int resultCount = builder.getDatetimesCount();
            if (builder.getDatetimesCount() > 0) {
                for (int i = 0; i < resultCount; ++i) {
                    datetimes[i] = DateUtil.getDate(builder.getDatetimes(i), 0);
                    x[i] = builder.getX(i);
                    y[i] = builder.getY(i);
                    qualities[i] = (short)builder.getQualities(i);
                    errors[i] = builder.getErrors(i);
                    nanosecond[i] = builder.getMs(i);
                }
            }
        } else {
            DateUtil.getDate(datetimes, datetimesVal, msVal);
        }
        count = this.getCount(fields);
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int putCoorSnapshots(int count, int[] ids, Object[] datetimes, float[] x, float[] y, short[] qualities, int[] errors) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (count <= 0 || ids == null || datetimes == null || x == null || y == null || qualities == null || errors == null) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_PUT_COOR_SNAPSHOTS, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        int[] datetimesVal = new int[datetimes.length];
        int[] msVal = new int[datetimes.length];
        for (int i = 0; i < datetimes.length; ++i) {
            if (datetimes[i].getClass().equals(Date.class)) {
                datetimesVal[i] = DateUtil.getSecond((Date)datetimes[i]);
                msVal[i] = DateUtil.getMilSecond((Date)datetimes[i]);
                continue;
            }
            if (!datetimes[i].getClass().equals(DateTimeNS.class)) continue;
            datetimesVal[i] = DateUtil.getSecond(((DateTimeNS)datetimes[i]).getDatetime());
            msVal[i] = ((DateTimeNS)datetimes[i]).getNanosecond();
        }
        List<RtdbField> fields = this.proto.msgPutCoorSnapshotsFields(count, ids, datetimesVal, msVal, x, y, qualities);
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            this.rtdbServer.getConnection().sendPacket(fields, false);
            List<RtdbField> rFields = this.proto.msgPutCoorSnapshotsRespFields(0, 0, 0, errors);
            this.rtdbServer.getConnection().receivePacket(rFields, false);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK && ret != RtdbError.GoE_FALSE) {
                throw new Exception(ret.getErrmsg());
            }
            if (this.version.equals("3")) {
                DatagramSnapshots.datagram_put_coor_snapshots_resp.Builder builder = DatagramSnapshots.datagram_put_coor_snapshots_resp.newBuilder();
                byte[] data = (byte[])rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum()).getData();
                builder.mergeFrom(data, 4, data.length - 8);
                int count_resp = builder.getErrorsCount();
                for (int i = 0; i < count_resp; ++i) {
                    errors[i] = builder.getErrors(i);
                }
            }
            count = this.getCount(rFields);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int fixCoorSnapshots(int count, int[] ids, Object[] datetimes, float[] x, float[] y, short[] qualities, int[] errors) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (count <= 0 || ids == null || datetimes == null || x == null || y == null || qualities == null || errors == null) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_FIX_COOR_SNAPSHOTS, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            int[] datetimesVal = new int[datetimes.length];
            int[] msVal = new int[datetimes.length];
            for (int i = 0; i < datetimes.length; ++i) {
                if (datetimes[i].getClass().equals(Date.class)) {
                    datetimesVal[i] = DateUtil.getSecond((Date)datetimes[i]);
                    msVal[i] = DateUtil.getMilSecond((Date)datetimes[i]);
                    continue;
                }
                if (!datetimes[i].getClass().equals(DateTimeNS.class)) continue;
                datetimesVal[i] = DateUtil.getSecond(((DateTimeNS)datetimes[i]).getDatetime());
                msVal[i] = ((DateTimeNS)datetimes[i]).getNanosecond();
            }
            List<RtdbField> fields = this.proto.msgFixCoorSnapshotsFields(count, ids, datetimesVal, msVal, x, y, qualities);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            List<RtdbField> rFields = this.proto.msgFixCoorSnapshotsRespFields(0, 0, 0, errors);
            this.rtdbServer.getConnection().receivePacket(rFields, false);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK && ret != RtdbError.GoE_FALSE) {
                throw new Exception(ret.getErrmsg());
            }
            if (this.version.equals("3")) {
                DatagramSnapshots.datagram_fix_coor_snapshots_resp.Builder builder = DatagramSnapshots.datagram_fix_coor_snapshots_resp.newBuilder();
                RtdbField p = rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builder.mergeFrom(buf, 4, buf.length - 8);
                count = builder.getErrorsCount();
                for (int i = 0; i < ids.length; ++i) {
                    errors[i] = builder.getErrors(i);
                }
            }
            count = this.getCount(rFields);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbBlobData getBlobSnapshot(int id) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (id <= 0) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_BLOB_SNAPSHOT, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            byte[] blob = new byte[2048];
            List<RtdbField> fields = this.proto.msgGetBlobSnapshotFields(id, blob.length);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetBlobSnapshotRespFields(0, 0, (short)0, (short)0, blob, (short)0);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            RtdbBlobData data = new RtdbBlobData();
            if (this.version.equals("3")) {
                DatagramSnapshots.datagram_get_blob_snapshot_resp.Builder builder = DatagramSnapshots.datagram_get_blob_snapshot_resp.newBuilder();
                RtdbField gf16 = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])gf16.getData();
                builder.mergeFrom(buf, 4, buf.length - 8);
                int dateVal = builder.getDatetime();
                int msVal = builder.getMs();
                Date datetime = DateUtil.getDate(dateVal, (short)msVal);
                byte[] byteArray = builder.getBlob().toByteArray();
                data.setBlob(byteArray);
                data.setDatetime(datetime);
                data.setId(id);
                int quality = builder.getQuality();
                data.setQuality((short)quality);
            } else {
                int field_dt = 16;
                int field_ms = 17;
                int field_q = 18;
                int dateVal = (int)fields.get(field_dt).getIvalue();
                int msVal = (int)fields.get(field_ms).getIvalue();
                short quality = (short)fields.get(field_q).getIvalue();
                Date datetime = DateUtil.getDate(dateVal, msVal);
                int count = this.getCount(fields);
                byte[] tempBlob = new byte[count];
                System.arraycopy(blob, 0, tempBlob, 0, count);
                data.setBlob(tempBlob);
                data.setDatetime(datetime);
                data.setId(id);
                data.setQuality(quality);
            }
            return data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbBlobData getBlobSnapshot_ns(int id) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (id <= 0) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_BLOB_SNAPSHOT, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            byte[] blob = new byte[2048];
            List<RtdbField> fields = this.proto.msgGetBlobSnapshotFields(id, blob.length);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetBlobSnapshotRespFields(0, 0, (short)0, (short)0, blob, (short)0);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            RtdbBlobData data = new RtdbBlobData();
            if (this.version.equals("3")) {
                DatagramSnapshots.datagram_get_blob_snapshot_resp.Builder builder = DatagramSnapshots.datagram_get_blob_snapshot_resp.newBuilder();
                RtdbField gf16 = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])gf16.getData();
                builder.mergeFrom(buf, 4, buf.length - 8);
                int dateVal = builder.getDatetime();
                int msVal = builder.getMs();
                Date datetime = DateUtil.getDate(dateVal, 0);
                byte[] byteArray = builder.getBlob().toByteArray();
                data.setBlob(byteArray);
                data.setDatetime(datetime);
                data.setId(id);
                int quality = builder.getQuality();
                data.setQuality((short)quality);
                data.setNanosecond(msVal);
            }
            return data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBlobSnapshots(int count, int[] ids, Date[] datetimes, byte[][] blobs, short[] qualities, int[] errors, short[] lens) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (count <= 0 || ids == null || datetimes == null || blobs == null || qualities == null || errors == null) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_BLOB_SNAPSHOTS, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            for (int i = 0; i < lens.length; ++i) {
                lens[i] = (short)blobs[i].length;
            }
            List<RtdbField> fields = this.proto.msgGetBolbSnapshotsFields(count, ids, lens);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] datetimesVal = new int[count];
            int[] msVal = new int[count];
            fields = this.proto.msgGetBlobSnapshotsRespFields(0, 0, 0, datetimesVal, msVal, lens, blobs, qualities, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            DateUtil.getDate(datetimes, datetimesVal, msVal);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK && ret != RtdbError.GoE_FALSE) {
                throw new Exception(ret.getErrmsg());
            }
            if (this.version.equals("3")) {
                DatagramSnapshots.datagram_get_blob_snapshots_resp.Builder builder = DatagramSnapshots.datagram_get_blob_snapshots_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builder.mergeFrom(buf, 4, buf.length - 8);
                int resultCount = builder.getDatetimesCount();
                if (resultCount > 0) {
                    for (int i = 0; i < resultCount; ++i) {
                        datetimes[i] = DateUtil.getDate(builder.getDatetimes(i), builder.getMs(i));
                        blobs[i] = builder.getBlobs(i).toByteArray();
                        qualities[i] = (short)builder.getQualities(i);
                        errors[i] = builder.getErrors(i);
                    }
                }
            }
            count = this.getCount(fields);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBlobSnapshots_ns(int count, int[] ids, Date[] datetimes, byte[][] blobs, short[] qualities, int[] errors, short[] lens, int[] nanosecond) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (count <= 0 || ids == null || datetimes == null || blobs == null || qualities == null || errors == null) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_BLOB_SNAPSHOTS, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            for (int i = 0; i < lens.length; ++i) {
                lens[i] = (short)blobs[i].length;
            }
            List<RtdbField> fields = this.proto.msgGetBolbSnapshotsFields(count, ids, lens);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] datetimesVal = new int[count];
            int[] msVal = new int[count];
            fields = this.proto.msgGetBlobSnapshotsRespFields(0, 0, 0, datetimesVal, msVal, lens, blobs, qualities, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            DateUtil.getDate(datetimes, datetimesVal);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK && ret != RtdbError.GoE_FALSE) {
                throw new Exception(ret.getErrmsg());
            }
            if (this.version.equals("3")) {
                DatagramSnapshots.datagram_get_blob_snapshots_resp.Builder builder = DatagramSnapshots.datagram_get_blob_snapshots_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builder.mergeFrom(buf, 4, buf.length - 8);
                int resultCount = builder.getDatetimesCount();
                if (resultCount > 0) {
                    for (int i = 0; i < resultCount; ++i) {
                        datetimes[i] = DateUtil.getDate(builder.getDatetimes(i), 0);
                        blobs[i] = builder.getBlobs(i).toByteArray();
                        qualities[i] = (short)builder.getQualities(i);
                        errors[i] = builder.getErrors(i);
                        nanosecond[i] = builder.getMs(i);
                    }
                }
            }
            count = this.getCount(fields);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putBlobSnapshot(int id, Object datetime, byte[] blob, short quality) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        boolean f = false;
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (id <= 0 || datetime == null || blob == null || quality < 0) {
                throw new InvalidParameterException();
            }
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_PUT_BLOB_SNAPSHOT, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            int dateVal = 0;
            int msVal = 0;
            if (datetime.getClass().equals(Date.class)) {
                dateVal = DateUtil.getSecond((Date)datetime);
                msVal = DateUtil.getMilSecond((Date)datetime);
            } else if (datetime.getClass().equals(DateTimeNS.class)) {
                dateVal = DateUtil.getSecond(((DateTimeNS)datetime).getDatetime());
                msVal = ((DateTimeNS)datetime).getNanosecond();
            }
            List<RtdbField> fields = this.proto.msgPutBlobSnapshotFields(id, dateVal, msVal, (short)blob.length, blob, quality);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgPutBlobSnapshotRespFields(0);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            f = true;
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int putBlobSnapshots(int count, int[] ids, Object[] datetimes, byte[][] blobs, short[] qualities, int[] errors) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (count <= 0 || ids == null || datetimes == null || blobs == null || qualities == null || errors == null) {
                throw new InvalidParameterException();
            }
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_BLOB_SNAPSHOTS, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            int totalCount = 0;
            short[] lens = new short[blobs.length];
            for (int i = 0; i < lens.length; ++i) {
                lens[i] = (short)blobs[i].length;
                totalCount += lens[i];
            }
            int[] datetimesVal = new int[datetimes.length];
            int[] msVal = new int[datetimes.length];
            for (int i = 0; i < datetimes.length; ++i) {
                if (datetimes[i].getClass().equals(Date.class)) {
                    datetimesVal[i] = DateUtil.getSecond((Date)datetimes[i]);
                    msVal[i] = DateUtil.getMilSecond((Date)datetimes[i]);
                    continue;
                }
                if (!datetimes[i].getClass().equals(DateTimeNS.class)) continue;
                datetimesVal[i] = DateUtil.getSecond(((DateTimeNS)datetimes[i]).getDatetime());
                msVal[i] = ((DateTimeNS)datetimes[i]).getNanosecond();
            }
            List<RtdbField> fields = this.proto.msgPutBlobSnapshotsFields(true, totalCount, count, ids, datetimesVal, msVal, lens, blobs, qualities);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgPutBlobSnapshotsRespFields(0, totalCount, 0, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK && ret != RtdbError.GoE_FALSE) {
                throw new Exception(ret.getErrmsg());
            }
            count = this.getCount(fields);
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int subscribeSnapshots(int count, int[] ids, RSDataChange callback, int[] errors) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (count <= 0 || ids == null || callback == null || errors == null) {
            throw new InvalidParameterException();
        }
        if (count > 1000) {
            // empty if block
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_SUBSCRIBE_SNAPSHOTS, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            this.rtdbServer.getConnection().lock();
            List<RtdbField> fields = this.proto.msgSubscribeSnapshotsFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgSubscribeSnapshotsRespFields(0, 0, 0, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            this.rtdbServer.getConnection().subscribeSnaps(callback);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int subscribeSnapshotsEx(Object param, int[] ids, RSDataChangeEx callback, int[] errors) throws NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (ids == null || callback == null) {
            throw new InvalidParameterException();
        }
        int count_ = ids.length;
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_SUBSCRIBE_SNAPSHOTS, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            this.rtdbServer.getConnection().lock();
            List<RtdbField> fields = this.proto.msgSubscribeSnapshotsFields(count_, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            List<RtdbField> receiveField = this.proto.msgSubscribeSnapshotsRespFields(0, 0, 0, errors);
            this.rtdbServer.getConnection().receivePacket(receiveField, true);
            RtdbError ret = this.getRet(receiveField);
            if (null != ret && ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            this.rtdbServer.getConnection().subscribeSnapsEx(param, callback);
        }
        return count_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelSubscribeSnapshots() throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (null == this.rtdbServer.getConnection() || this.rtdbServer.getConnection().getThread() == null) {
            return;
        }
        this.rtdbServer.getConnection().cancelSubscribe();
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_CANCEL_SUBSCRIBE_SNAPSHOTS, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> sfields = this.proto.msgCancelSnapshotsSubscribeFields();
            this.rtdbServer.getConnection().sendPacket(sfields, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbEntity<RtdbDatetimeData> getDateTimeSnapshots(int[] ids) throws Exception {
        if (ids == null || ids.length == 0) {
            throw new InvalidParameterException();
        }
        int count = ids.length;
        RtdbEntity<RtdbDatetimeData> result = null;
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_DATETIME_SNAPSHOTS, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgGetDateTimeSnapshotsFields(ids, count);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] dateTimes = new int[count];
            int[] ms = new int[count];
            double[] values = new double[count];
            long[] states = new long[count];
            short[] qualities = new short[count];
            int[] errors = new int[count];
            int[] types = new int[count];
            for (int i = 0; i < count; ++i) {
                types[i] = 0;
            }
            fields = this.proto.msgGetDateTimeSnapshotsRespFields(count, dateTimes, ms, values, states, qualities, errors, types);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            if (this.version.equals("3")) {
                DatagramSnapshots.datagram_get_datetime_snapshots_resp.Builder builder = DatagramSnapshots.datagram_get_datetime_snapshots_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builder.mergeFrom(buf, 4, buf.length - 8);
                result = new RtdbEntity();
                ArrayList<RtdbDatetimeData> list = new ArrayList<RtdbDatetimeData>(ids.length);
                for (int i = 0; i < count; ++i) {
                    RtdbDatetimeData date = new RtdbDatetimeData();
                    date.setDate(DateUtil.getDate(builder.getDatetimes(i), builder.getMs(i)));
                    date.setId(ids[i]);
                    date.setQuality((short)builder.getQualities(i));
                    long states2 = builder.getStates(i);
                    date.setValue(new Date(states2));
                    date.setMs(builder.getMs(i));
                    date.setError(builder.getErrors(i));
                    list.add(date);
                }
                result.setList(list);
            } else {
                result = this.makeRtdbDateTimeData(ids, dateTimes, ms, states, qualities, errors);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbEntity<RtdbDatetimeData> getDateTimeSnapshots_ns(int[] ids) throws Exception {
        if (ids == null || ids.length == 0) {
            throw new InvalidParameterException();
        }
        int count = ids.length;
        RtdbEntity<RtdbDatetimeData> result = null;
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_DATETIME_SNAPSHOTS, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgGetDateTimeSnapshotsFields(ids, count);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] dateTimes = new int[count];
            int[] ms = new int[count];
            double[] values = new double[count];
            long[] states = new long[count];
            short[] qualities = new short[count];
            int[] errors = new int[count];
            int[] types = new int[count];
            for (int i = 0; i < count; ++i) {
                types[i] = 0;
            }
            fields = this.proto.msgGetDateTimeSnapshotsRespFields(count, dateTimes, ms, values, states, qualities, errors, types);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            if (this.version.equals("3")) {
                DatagramSnapshots.datagram_get_datetime_snapshots_resp.Builder builder = DatagramSnapshots.datagram_get_datetime_snapshots_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builder.mergeFrom(buf, 4, buf.length - 8);
                result = new RtdbEntity();
                ArrayList<RtdbDatetimeData> list = new ArrayList<RtdbDatetimeData>(ids.length);
                for (int i = 0; i < count; ++i) {
                    RtdbDatetimeData date = new RtdbDatetimeData();
                    date.setDate(DateUtil.getDate(builder.getDatetimes(i), 0));
                    date.setId(ids[i]);
                    date.setQuality((short)builder.getQualities(i));
                    long states2 = builder.getStates(i);
                    date.setValue(new Date(states2));
                    date.setMs(0);
                    date.setNanosecond(builder.getMs(i));
                    date.setError(builder.getErrors(i));
                    list.add(date);
                }
                result.setList(list);
            } else {
                result = this.makeRtdbDateTimeData(ids, dateTimes, ms, states, qualities, errors);
            }
        }
        return result;
    }

    private RtdbEntity<RtdbDatetimeData> makeRtdbDateTimeData(int[] ids, int[] dateTimes, int[] ms, long[] states, short[] qualities, int[] errors) {
        int count = ids.length;
        int sucCount = 0;
        ArrayList<RtdbDatetimeData> list = new ArrayList<RtdbDatetimeData>(count);
        for (int i = 0; i < count; ++i) {
            if (errors[i] != 0) continue;
            RtdbDatetimeData model = new RtdbDatetimeData();
            list.add(model);
            model.setError(0);
            model.setDate(DateUtil.getDate(dateTimes[i], ms[i]));
            model.setId(ids[i]);
            model.setQuality(qualities[i]);
            model.setMs(ms[i]);
            long temp = states[i];
            model.setValue(DateUtil.getDate((int)(temp / 1000L), (short)(temp % 1000L)));
            ++sucCount;
        }
        RtdbEntity<RtdbDatetimeData> result = new RtdbEntity<RtdbDatetimeData>();
        result.setList(list);
        result.setSucCount(sucCount);
        return result;
    }

    @Override
    public RtdbEntity<RtdbDatetimeData> putDatetimeSnapshots(List<RtdbDatetimeData> list) throws NoAuthorityException, Exception {
        if (list == null || list.size() == 0) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_PUT_DATETIME_SNAPSHOTS, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        int count = list.size();
        int[] ids = new int[count];
        int[] datetimes = new int[count];
        int[] ms = new int[count];
        double[] values = new double[count];
        long[] states = new long[count];
        short[] qualities = new short[count];
        int[] errors = new int[count];
        for (int i = 0; i < count; ++i) {
            RtdbDatetimeData temp = list.get(i);
            ids[i] = temp.getId();
            Date date = null;
            if (temp.getDate().getClass().equals(Date.class)) {
                date = (Date)temp.getDate();
                datetimes[i] = DateUtil.getSecond(date);
                ms[i] = DateUtil.getMilSecond(date);
            } else if (temp.getDate().getClass().equals(DateTimeNS.class)) {
                datetimes[i] = DateUtil.getSecond(((DateTimeNS)temp.getDate()).getDatetime());
                ms[i] = ((DateTimeNS)temp.getDate()).getNanosecond();
            }
            date = temp.getValue();
            errors[i] = temp.getError();
            values[i] = 0.0;
            states[i] = (long)DateUtil.getSecond(date) * 1000L + (long)temp.getMs();
            qualities[i] = temp.getQuality().getNum();
        }
        List<RtdbField> fields = this.proto.msgPutDateTimeSnapsHotsFields(ids, datetimes, ms, values, states, qualities);
        this.rtdbServer.getConnection().sendPacket(fields, false);
        fields = this.proto.msgPutDateTimeSnapsHotsRespFields(errors);
        this.rtdbServer.getConnection().receivePacket(fields, true);
        RtdbError ret = this.getRet(fields);
        if (ret != RtdbError.GoE_OK) {
            throw new Exception(ret.getErrmsg());
        }
        RtdbEntity<RtdbDatetimeData> result = new RtdbEntity<RtdbDatetimeData>();
        if (this.version.equals("3")) {
            DatagramSnapshots.datagram_put_datetime_snapshots_resp.Builder builder = DatagramSnapshots.datagram_put_datetime_snapshots_resp.newBuilder();
            byte[] data = (byte[])fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum()).getData();
            builder.mergeFrom(data, 4, data.length - 8);
            builder.build();
            int count_resp = builder.getErrorsCount();
            ArrayList<RtdbDatetimeData> li = new ArrayList<RtdbDatetimeData>(list.size());
            for (int i = 0; i < count_resp; ++i) {
                RtdbDatetimeData d = new RtdbDatetimeData();
                d.setId(ids[i]);
                d.setError(builder.getErrors(i));
                li.add(d);
            }
            result.setList(li);
        } else {
            ArrayList<RtdbDatetimeData> errorList = new ArrayList<RtdbDatetimeData>(list.size());
            int sucCount = 0;
            for (int i = 0; i < count; ++i) {
                if (errors[i] != 0) {
                    list.get(i).setError(errors[i]);
                    errorList.add(list.get(i));
                    continue;
                }
                ++sucCount;
            }
            result.setList(errorList);
            result.setSucCount(sucCount);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] flushCachedValues(int[] ids) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (0 == ids.length) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_FLUSH_SNAPSHOT_VALUES, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            List<RtdbField> fields = this.proto.msgFlushCachedValuesFields(ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] counts = new int[ids.length];
            fields = this.proto.msgFlushCachedValuesRespFields(counts);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            return counts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbNamedTypeData getNamedTypeSnapshot(int id, int length) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876");
        }
        if (id <= 0) {
            throw new InvalidParameterException();
        }
        Object result = null;
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_NAMED_TYPE_SNAPSHOT, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgGetNamedTypeSnapshotFields(id, (short)length);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            byte[] obj = new byte[length];
            List<RtdbField> respField = this.proto.msgGetNamedTypeSnapshotRespFields((short)length);
            this.rtdbServer.getConnection().receivePacket(respField, true);
            RtdbError ret = this.getRet(respField);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            DatagramSnapshots.datagram_get_named_type_snapshot_resp.Builder builder = DatagramSnapshots.datagram_get_named_type_snapshot_resp.newBuilder();
            RtdbField p = respField.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])p.getData();
            builder.mergeFrom(buf, 4, buf.length - 8);
            RtdbNamedTypeData model = new RtdbNamedTypeData();
            model.setError(0);
            model.setDatetime(DateUtil.getDate(builder.getDatetime(), (short)builder.getMs()));
            model.setId(id);
            model.setMs((short)builder.getMs());
            model.setQuality((short)builder.getQuality());
            model.setValue(builder.getObject().toByteArray());
            return model;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbNamedTypeData getNamedTypeSnapshot_ns(int id, int length) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876");
        }
        if (id <= 0) {
            throw new InvalidParameterException();
        }
        Object result = null;
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_NAMED_TYPE_SNAPSHOT, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgGetNamedTypeSnapshotFields(id, (short)length);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            byte[] obj = new byte[length];
            List<RtdbField> respField = this.proto.msgGetNamedTypeSnapshotRespFields((short)length);
            this.rtdbServer.getConnection().receivePacket(respField, true);
            RtdbError ret = this.getRet(respField);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            DatagramSnapshots.datagram_get_named_type_snapshot_resp.Builder builder = DatagramSnapshots.datagram_get_named_type_snapshot_resp.newBuilder();
            RtdbField p = respField.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])p.getData();
            builder.mergeFrom(buf, 4, buf.length - 8);
            RtdbNamedTypeData model = new RtdbNamedTypeData();
            model.setError(0);
            model.setDatetime(DateUtil.getDate(builder.getDatetime(), 0));
            model.setId(id);
            model.setMs((short)0);
            model.setNanosecond(builder.getMs());
            model.setQuality((short)builder.getQuality());
            model.setValue(builder.getObject().toByteArray());
            return model;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbEntity<RtdbNamedTypeData> getNamedTypeSnapshots(int[] ids, short[] lengths) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876");
        }
        if (ids == null || ids.length == 0 || lengths == null || lengths.length == 0 || ids.length != lengths.length) {
            throw new InvalidParameterException();
        }
        int count = ids.length;
        Object result = null;
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_NAMED_TYPE_SNAPSHOTS, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgGetNamedTypeSnapshotsFields(ids, lengths);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetNamedTypeSnapshotsRespFields();
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK && ret != RtdbError.GoE_FALSE) {
                throw new Exception(ret.getErrmsg());
            }
            DatagramSnapshots.datagram_get_named_type_snapshots_resp.Builder builder = DatagramSnapshots.datagram_get_named_type_snapshots_resp.newBuilder();
            RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])p.getData();
            builder.mergeFrom(buf, 4, buf.length - 8);
            int sucCount = 0;
            ArrayList<RtdbNamedTypeData> namedTypeDatas = new ArrayList<RtdbNamedTypeData>(ids.length);
            int countResult = builder.getDatetimesCount();
            for (int i = 0; i < countResult; ++i) {
                RtdbNamedTypeData model = new RtdbNamedTypeData();
                model.setError(builder.getErrors(i));
                model.setDatetime(DateUtil.getDate(builder.getDatetimes(i), (short)builder.getMs(i)));
                model.setId(ids[i]);
                model.setMs((short)builder.getMs(i));
                model.setQuality((short)builder.getQualities(i));
                model.setValue(builder.getObjects(i).toByteArray());
                namedTypeDatas.add(model);
                ++sucCount;
            }
            RtdbEntity<RtdbNamedTypeData> entity = new RtdbEntity<RtdbNamedTypeData>();
            entity.setList(namedTypeDatas);
            entity.setSucCount(sucCount);
            return entity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbEntity<RtdbNamedTypeData> getNamedTypeSnapshots_ns(int[] ids, short[] lengths) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876");
        }
        if (ids == null || ids.length == 0 || lengths == null || lengths.length == 0 || ids.length != lengths.length) {
            throw new InvalidParameterException();
        }
        int count = ids.length;
        Object result = null;
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_NAMED_TYPE_SNAPSHOTS, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgGetNamedTypeSnapshotsFields(ids, lengths);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetNamedTypeSnapshotsRespFields();
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK && ret != RtdbError.GoE_FALSE) {
                throw new Exception(ret.getErrmsg());
            }
            DatagramSnapshots.datagram_get_named_type_snapshots_resp.Builder builder = DatagramSnapshots.datagram_get_named_type_snapshots_resp.newBuilder();
            RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])p.getData();
            builder.mergeFrom(buf, 4, buf.length - 8);
            int sucCount = 0;
            ArrayList<RtdbNamedTypeData> namedTypeDatas = new ArrayList<RtdbNamedTypeData>(ids.length);
            int countResult = builder.getDatetimesCount();
            for (int i = 0; i < countResult; ++i) {
                RtdbNamedTypeData model = new RtdbNamedTypeData();
                model.setError(builder.getErrors(i));
                model.setDatetime(DateUtil.getDate(builder.getDatetimes(i), 0));
                model.setId(ids[i]);
                model.setMs((short)0);
                model.setNanosecond(builder.getMs(i));
                model.setQuality((short)builder.getQualities(i));
                model.setValue(builder.getObjects(i).toByteArray());
                namedTypeDatas.add(model);
                ++sucCount;
            }
            RtdbEntity<RtdbNamedTypeData> entity = new RtdbEntity<RtdbNamedTypeData>();
            entity.setList(namedTypeDatas);
            entity.setSucCount(sucCount);
            return entity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putNamedTypeSnapshot(RtdbNamedTypeData named) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876");
        }
        if (named == null) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_PUT_NAMED_TYPE_SNAPSHOT, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            int id = named.getId();
            Object date = named.getDatetime();
            int datetime = 0;
            int ms = 0;
            if (date.getClass().equals(Date.class)) {
                datetime = DateUtil.getSecond((Date)date);
                ms = DateUtil.getMilSecond((Date)date);
            } else if (date.getClass().equals(DateTimeNS.class)) {
                datetime = DateUtil.getSecond(((DateTimeNS)date).getDatetime());
                ms = ((DateTimeNS)date).getNanosecond();
            }
            short length = (short)named.getValue().length;
            byte[] bytes = named.getValue();
            short quality = named.getQuality().getNum();
            List<RtdbField> fields = this.proto.msgPutNamedTypeSnapshotFields(id, datetime, ms, length, bytes, quality);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgPutNamedTypeSnapshotRespFields();
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbEntity<RtdbNamedTypeData> putNamedTypeSnapshots(List<RtdbNamedTypeData> list) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876");
        }
        if (list == null || list.size() == 0) {
            throw new InvalidParameterException();
        }
        int count = list.size();
        RtdbEntity<RtdbNamedTypeData> result = null;
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_PUT_NAMED_TYPE_SNAPSHOTS, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgPutNamedTypeSnapshotsFields(list);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] errors = new int[count];
            fields = this.proto.msgPutNamedTypeSnapshotsRespFields(errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK && ret != RtdbError.GoE_FALSE) {
                throw new Exception(ret.getErrmsg());
            }
            ArrayList<RtdbNamedTypeData> errorList = new ArrayList<RtdbNamedTypeData>(list.size());
            int sucCount = 0;
            for (int i = 0; i < count; ++i) {
                if (errors[i] != 0) {
                    RtdbNamedTypeData model = list.get(i);
                    model.setError(errors[i]);
                    errorList.add(model);
                    continue;
                }
                ++sucCount;
            }
            result = new RtdbEntity<RtdbNamedTypeData>();
            result.setList(errorList);
            result.setSucCount(sucCount);
        }
        return result;
    }

    @Override
    public int getStringSnapshots(int count, int[] ids, Date[] datetimes, byte[][] blobs, short[] qualities, int[] errors) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        return count;
    }
}

