/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.api.model;

import com.rtdb.api.enums.RTDBClass;
import com.rtdb.api.enums.RtdbType;
import com.rtdb.api.model.MemoryStream;
import com.rtdb.api.util.BytesConvertUtil;
import com.rtdb.api.util.DateUtil;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;

public class RtdbBasePoint
implements Serializable {
    private static final long serialVersionUID = 1L;
    String tag = "";
    int id;
    RtdbType type = RtdbType.RTDB_REAL32;
    int table;
    String desc = "";
    String unit = "";
    boolean archive;
    short digits;
    boolean shutdown;
    double lowlimit;
    double highlimit;
    boolean step;
    double typical;
    boolean compress;
    double compdev;
    double compdevpercent;
    int comptimemax;
    int comptimemin;
    double excdev;
    double excdevpercent;
    int exctimemax;
    int exctimemin;
    RTDBClass classof;
    Date changedate;
    String changer = "";
    Date createdate;
    String creator = "";
    boolean mirror;
    boolean microsecond;
    int scanindex;
    int calcindex;
    int alarmindex;
    String table_dot_tag = "";
    boolean summary = false;
    byte[] padding = new byte[5];

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag.length() > 79 ? tag.substring(0, 78).trim() : tag.trim();
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public RtdbType getType() {
        return this.type;
    }

    public void setType(RtdbType type) {
        this.type = type;
    }

    public int getTable() {
        return this.table;
    }

    public void setTable(int table) {
        this.table = table;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc.length() > 99 ? desc.substring(0, 98) : desc;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit.length() > 19 ? unit.substring(0, 18) : unit;
    }

    public boolean getArchive() {
        return this.archive;
    }

    public void setArchive(boolean archive) {
        this.archive = archive;
    }

    public short getDigits() {
        return this.digits;
    }

    public void setDigits(short digits) {
        this.digits = digits;
    }

    public boolean getShutdown() {
        return this.shutdown;
    }

    public void setShutdown(boolean shutdown) {
        this.shutdown = shutdown;
    }

    public double getLowlimit() {
        return this.lowlimit;
    }

    public void setLowlimit(double lowlimit) {
        this.lowlimit = lowlimit;
    }

    public double getHighlimit() {
        return this.highlimit;
    }

    public void setHighlimit(double highlimit) {
        this.highlimit = highlimit;
    }

    public boolean getStep() {
        return this.step;
    }

    public void setStep(boolean step) {
        this.step = step;
    }

    public double getTypical() {
        return this.typical;
    }

    public void setTypical(double typical) {
        this.typical = typical;
    }

    public boolean getCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public double getCompdev() {
        return this.compdev;
    }

    public void setCompdev(double compdev) {
        this.compdev = compdev;
    }

    public double getCompdevpercent() {
        return this.compdevpercent;
    }

    public void setCompdevpercent(double compdevpercent) {
        this.compdevpercent = compdevpercent;
    }

    public int getComptimemax() {
        return this.comptimemax;
    }

    public void setComptimemax(int comptimemax) {
        this.comptimemax = comptimemax;
    }

    public int getComptimemin() {
        return this.comptimemin;
    }

    public void setComptimemin(int comptimemin) {
        this.comptimemin = comptimemin;
    }

    public double getExcdev() {
        return this.excdev;
    }

    public void setExcdev(double excdev) {
        this.excdev = excdev;
    }

    public double getExcdevpercent() {
        return this.excdevpercent;
    }

    public void setExcdevpercent(double excdevpercent) {
        this.excdevpercent = excdevpercent;
    }

    public int getExctimemax() {
        return this.exctimemax;
    }

    public void setExctimemax(int exctimemax) {
        this.exctimemax = exctimemax;
    }

    public int getExctimemin() {
        return this.exctimemin;
    }

    public void setExctimemin(int exctimemin) {
        this.exctimemin = exctimemin;
    }

    public RTDBClass getClassof() {
        return this.classof;
    }

    public void setClassof(RTDBClass classof) {
        this.classof = classof;
    }

    public Date getChangedate() {
        return this.changedate;
    }

    public void setChangedate(Date changedate) {
        this.changedate = changedate;
    }

    public String getChanger() {
        return this.changer;
    }

    public void setChanger(String changer) {
        this.changer = changer.length() > 19 ? changer.substring(0, 18) : changer;
    }

    public Date getCreatedate() {
        return this.createdate;
    }

    public void setCreatedate(Date createdate) {
        this.createdate = createdate;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator.length() > 19 ? creator.substring(0, 18) : creator;
    }

    public boolean getMirror() {
        return this.mirror;
    }

    public void setMirror(boolean mirror) {
        this.mirror = mirror;
    }

    public boolean getMicrosecond() {
        return this.microsecond;
    }

    public void setMicrosecond(boolean microsecond) {
        this.microsecond = microsecond;
    }

    public int getScanindex() {
        return this.scanindex;
    }

    public void setScanindex(int scanindex) {
        this.scanindex = scanindex;
    }

    public int getCalcindex() {
        return this.calcindex;
    }

    public void setCalcindex(int calcindex) {
        this.calcindex = calcindex;
    }

    public int getAlarmindex() {
        return this.alarmindex;
    }

    public void setAlarmindex(int alarmindex) {
        this.alarmindex = alarmindex;
    }

    public String getTable_dot_tag() {
        return this.table_dot_tag;
    }

    public void setTable_dot_tag(String table_dot_tag) {
        this.table_dot_tag = table_dot_tag;
    }

    public boolean getSummary() {
        return this.summary;
    }

    public void setSummary(boolean summary) {
        this.summary = summary;
    }

    public byte[] getPadding() {
        return this.padding;
    }

    public void setPadding(byte[] padding) {
        this.padding = padding;
    }

    public static RtdbBasePoint bytesToBasePoint(byte[] bytes) throws UnsupportedEncodingException {
        RtdbBasePoint base = new RtdbBasePoint();
        MemoryStream stream = new MemoryStream(bytes);
        base.setTag(stream.readString(80).trim());
        int r = stream.readInt();
        base.setId(r);
        int e = stream.readInt();
        base.setType(RtdbType.parse(e));
        base.setTable(stream.readInt());
        String readString = stream.readString(100);
        int idx = readString.indexOf("\u0000");
        String desc = readString.substring(0, idx);
        base.setDesc(desc.trim());
        base.setUnit(stream.readString(20).trim());
        base.setArchive(stream.readShort() > 0);
        base.setDigits(stream.readShort());
        base.setShutdown(stream.readInt() > 0);
        base.setLowlimit(stream.readFloat());
        base.setHighlimit(stream.readFloat());
        base.setStep(stream.readInt() > 0);
        base.setTypical(stream.readFloat());
        base.setCompress(stream.readInt() > 0);
        base.setCompdev(stream.readFloat());
        base.setCompdevpercent(stream.readFloat());
        base.setComptimemax(stream.readInt());
        base.setComptimemin(stream.readInt());
        base.setExcdev(stream.readFloat());
        base.setExcdevpercent(stream.readFloat());
        base.setExctimemax(stream.readInt());
        base.setExctimemin(stream.readInt());
        int readOf = stream.readInt();
        if (base.getType() == RtdbType.RTDB_INT64 && readOf > RTDBClass.RTDB_ALARM.getNum()) {
            base.setType(RtdbType.RTDB_DateTime);
        }
        readOf = readOf >= 16 ? readOf - 16 : readOf;
        base.setClassof(RTDBClass.parse(readOf));
        base.setChangedate(DateUtil.getDate(stream.readInt(), 0));
        base.setChanger(stream.readString(20).trim());
        base.setCreatedate(DateUtil.getDate(stream.readInt(), 0));
        base.setCreator(stream.readString(20).trim());
        base.setMirror(stream.readByte() > 0);
        base.setMicrosecond(stream.readByte() > 0);
        base.setScanindex(stream.readInt());
        base.setCalcindex(stream.readInt());
        base.setAlarmindex(stream.readInt());
        base.setTable_dot_tag(stream.readString(160).trim());
        base.setSummary(stream.readByte() > 0);
        return base;
    }

    public static byte[] basePointToByte(RtdbBasePoint point) throws Exception {
        MemoryStream stream = new MemoryStream();
        if (point != null) {
            // empty if block
        }
        byte[] btag = point.getTag().getBytes("GBK");
        byte[] nbtag = new byte[80];
        System.arraycopy(btag, 0, nbtag, 0, btag.length);
        int classofValue = point.getClassof().getNum();
        int typeValue = point.getType().getNum();
        if (typeValue == RtdbType.RTDB_DateTime.getNum()) {
            typeValue = RtdbType.RTDB_INT64.getNum();
            classofValue += RtdbType.RTDB_DateTime.getNum();
        }
        stream.writeBytes(nbtag);
        stream.writeBytes(BytesConvertUtil.intToBytes(point.getId()));
        stream.writeBytes(BytesConvertUtil.intToBytes(typeValue));
        stream.writeBytes(BytesConvertUtil.intToBytes(point.getTable()));
        byte[] bdesc = point.getDesc().getBytes("GBK");
        byte[] nbdesc = new byte[100];
        System.arraycopy(bdesc, 0, nbdesc, 0, bdesc.length);
        stream.writeBytes(nbdesc);
        byte[] bunit = point.getUnit().getBytes("GBK");
        byte[] nbunit = new byte[20];
        System.arraycopy(bunit, 0, nbunit, 0, bunit.length);
        stream.writeBytes(nbunit);
        stream.writeBytes(BytesConvertUtil.shortToBytes(point.getArchive() ? (short)1 : 0));
        stream.writeBytes(BytesConvertUtil.shortToBytes(point.getDigits()));
        stream.writeBytes(BytesConvertUtil.intToBytes(point.getShutdown() ? 1 : 0));
        stream.writeBytes(BytesConvertUtil.floatToBytes((float)point.getLowlimit(), 0));
        stream.writeBytes(BytesConvertUtil.floatToBytes((float)point.getHighlimit(), 0));
        stream.writeBytes(BytesConvertUtil.intToBytes(point.getStep() ? 1 : 0));
        stream.writeBytes(BytesConvertUtil.floatToBytes((float)point.getTypical(), 0));
        stream.writeBytes(BytesConvertUtil.intToBytes(point.getCompress() ? 1 : 0));
        stream.writeBytes(BytesConvertUtil.floatToBytes((float)point.getCompdev(), 0));
        stream.writeBytes(BytesConvertUtil.floatToBytes((float)point.getCompdevpercent(), 0));
        stream.writeBytes(BytesConvertUtil.intToBytes(point.getComptimemax()));
        stream.writeBytes(BytesConvertUtil.intToBytes(point.getComptimemin()));
        stream.writeBytes(BytesConvertUtil.floatToBytes((float)point.getExcdev(), 0));
        stream.writeBytes(BytesConvertUtil.floatToBytes((float)point.getExcdevpercent(), 0));
        stream.writeBytes(BytesConvertUtil.intToBytes(point.getExctimemax()));
        stream.writeBytes(BytesConvertUtil.intToBytes(point.getExctimemin()));
        stream.writeBytes(BytesConvertUtil.intToBytes(classofValue));
        stream.writeBytes(BytesConvertUtil.fillBytes(4));
        byte[] bchanger = point.getChanger().getBytes("GBK");
        byte[] nbchanger = new byte[20];
        System.arraycopy(bchanger, 0, nbchanger, 0, bchanger.length);
        stream.writeBytes(nbchanger);
        byte[] bcreator = point.getCreator().getBytes("GBK");
        byte[] nbcreator = new byte[20];
        System.arraycopy(bcreator, 0, nbcreator, 0, bcreator.length);
        stream.writeBytes(nbcreator);
        stream.writeBytes(BytesConvertUtil.fillBytes(4));
        stream.writeBytes(BytesConvertUtil.booleanToBytes(point.getMirror()));
        stream.writeBytes(BytesConvertUtil.booleanToBytes(point.getMicrosecond()));
        stream.writeBytes(BytesConvertUtil.fillBytes(2));
        stream.writeBytes(BytesConvertUtil.intToBytes(point.getScanindex()));
        stream.writeBytes(BytesConvertUtil.intToBytes(point.getCalcindex()));
        stream.writeBytes(BytesConvertUtil.intToBytes(point.getAlarmindex()));
        byte[] by = point.getTable_dot_tag().getBytes("GBK");
        byte[] newBy = new byte[79];
        System.arraycopy(by, 0, newBy, 0, by.length);
        stream.writeBytes(newBy);
        stream.writeBytes(BytesConvertUtil.fillBytes(160 - point.getTable_dot_tag().length()));
        stream.writeBytes(BytesConvertUtil.booleanToBytes(point.getSummary()));
        stream.writeBytes(BytesConvertUtil.fillBytes(11));
        byte[] bytetag = stream.toByteArray();
        return bytetag;
    }
}

