/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.service.impl;

import com.rtdb.api.callbackInter.RSDataChange;
import com.rtdb.api.callbackInter.RSDataChangeEx;
import com.rtdb.api.enums.HisMode;
import com.rtdb.api.enums.RTDBClass;
import com.rtdb.api.enums.RtdbError;
import com.rtdb.api.enums.RtdbQuality;
import com.rtdb.api.enums.RtdbType;
import com.rtdb.api.exception.EncodePacketErrorException;
import com.rtdb.api.exception.InvalidParameterException;
import com.rtdb.api.exception.NoAuthorityException;
import com.rtdb.api.exception.UnexpectedMethodException;
import com.rtdb.api.impl.RtdbBaseImpl;
import com.rtdb.api.impl.RtdbHistorianImpl;
import com.rtdb.api.impl.RtdbSnapshotImpl;
import com.rtdb.api.inter.IBase;
import com.rtdb.api.inter.IHistorian;
import com.rtdb.api.inter.ISnapshot;
import com.rtdb.api.model.DateTimeNS;
import com.rtdb.api.model.RtdbBlobData;
import com.rtdb.api.model.RtdbDatetimeData;
import com.rtdb.api.model.RtdbEntity;
import com.rtdb.api.model.RtdbNamedTypeData;
import com.rtdb.api.model.ValueData;
import com.rtdb.enums.Quality;
import com.rtdb.model.BlobData;
import com.rtdb.model.CoorData;
import com.rtdb.model.DatetimeData;
import com.rtdb.model.DoubleData;
import com.rtdb.model.Entity;
import com.rtdb.model.IntData;
import com.rtdb.model.NamedTypeData;
import com.rtdb.service.impl.ServerImpl;
import com.rtdb.service.inter.Snapshot;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SnapshotImpl
implements Snapshot {
    private ServerImpl server;
    private ISnapshot snapshot;
    private IHistorian historian;
    private IBase base;

    public SnapshotImpl(ServerImpl server) throws UnknownHostException, IOException, Exception {
        this.server = server;
        if (null != this.server) {
            this.snapshot = new RtdbSnapshotImpl(server);
            this.historian = new RtdbHistorianImpl(server);
            this.base = new RtdbBaseImpl(server);
        }
    }

    @Override
    public void close() throws IOException, InterruptedException {
        this.server.isRemoveFromPool = true;
        this.server.close();
    }

    @Override
    public Entity<IntData> getIntSnapshots(int[] ids) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, UnexpectedMethodException, Exception {
        Entity<IntData> entity = new Entity<IntData>();
        ArrayList<IntData> list = new ArrayList<IntData>(ids.length);
        StringBuffer sb = new StringBuffer();
        int errCount = 0;
        IntData ie = null;
        int length = ids.length;
        Date[] datetime = new Date[length];
        double[] values = new double[length];
        long[] states = new long[length];
        short[] qualities = new short[length];
        int[] errors = new int[length];
        this.snapshot.getSnapshots(length, ids, datetime, values, states, qualities, errors);
        for (int i = 0; i < length; ++i) {
            ie = new IntData(ids[i], datetime[i], values[i], states[i], qualities[i], errors[i]);
            list.add(ie);
            if (errors[i] == 0) continue;
            ++errCount;
            sb.append("\u7b2c [" + (i + 1) + "] \u4e2a\u6807\u7b7e\u70b9id\u64cd\u4f5c\u5931\u8d25");
        }
        if (errCount == 0) {
            sb.append("\u64cd\u4f5c\u6210\u529f\uff01");
        }
        entity.setList(list);
        entity.setSucCount(length - errCount);
        entity.setRetInfo(sb);
        return entity;
    }

    @Override
    public Entity<IntData> getIntSnapshots_ns(int[] ids) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, UnexpectedMethodException, Exception {
        Entity<IntData> entity = new Entity<IntData>();
        ArrayList<IntData> list = new ArrayList<IntData>(ids.length);
        StringBuffer sb = new StringBuffer();
        int errCount = 0;
        IntData ie = null;
        int length = ids.length;
        Date[] datetime = new Date[length];
        int[] nanosecond = new int[length];
        double[] values = new double[length];
        long[] states = new long[length];
        short[] qualities = new short[length];
        int[] errors = new int[length];
        this.snapshot.getSnapshots_ns(length, ids, datetime, values, states, qualities, errors, nanosecond);
        for (int i = 0; i < length; ++i) {
            ie = new IntData(ids[i], datetime[i], values[i], states[i], qualities[i], errors[i], nanosecond[i]);
            list.add(ie);
            if (errors[i] == 0) continue;
            ++errCount;
            sb.append("\u7b2c [" + (i + 1) + "] \u4e2a\u6807\u7b7e\u70b9id\u64cd\u4f5c\u5931\u8d25");
        }
        if (errCount == 0) {
            sb.append("\u64cd\u4f5c\u6210\u529f\uff01");
        }
        entity.setList(list);
        entity.setSucCount(length - errCount);
        entity.setRetInfo(sb);
        return entity;
    }

    @Override
    public Entity<DoubleData> getDoubleSnapshots(int[] ids) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, UnexpectedMethodException, Exception {
        Entity<DoubleData> entity = new Entity<DoubleData>();
        ArrayList<DoubleData> list = new ArrayList<DoubleData>(ids.length);
        StringBuffer sb = new StringBuffer();
        int errCount = 0;
        DoubleData ie = null;
        int length = ids.length;
        Date[] datetime = new Date[length];
        double[] values = new double[length];
        long[] states = new long[length];
        short[] qualities = new short[length];
        int[] errors = new int[length];
        this.snapshot.getSnapshots(length, ids, datetime, values, states, qualities, errors);
        for (int i = 0; i < length; ++i) {
            ie = new DoubleData(ids[i], datetime[i], values[i], qualities[i], errors[i]);
            list.add(ie);
            if (errors[i] == 0) continue;
            ++errCount;
            sb.append("\u7b2c [" + (i + 1) + "] \u4e2a\u6807\u7b7e\u70b9id\u64cd\u4f5c\u5931\u8d25");
        }
        if (errCount == 0) {
            sb.append("\u64cd\u4f5c\u6210\u529f\uff01");
        }
        entity.setList(list);
        entity.setSucCount(length - errCount);
        entity.setRetInfo(sb);
        return entity;
    }

    @Override
    public Entity<DoubleData> getDoubleSnapshots_ns(int[] ids) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, UnexpectedMethodException, Exception {
        Entity<DoubleData> entity = new Entity<DoubleData>();
        ArrayList<DoubleData> list = new ArrayList<DoubleData>(ids.length);
        StringBuffer sb = new StringBuffer();
        int errCount = 0;
        DoubleData ie = null;
        int length = ids.length;
        Date[] datetime = new Date[length];
        int[] nanosecond = new int[length];
        double[] values = new double[length];
        long[] states = new long[length];
        short[] qualities = new short[length];
        int[] errors = new int[length];
        this.snapshot.getSnapshots_ns(length, ids, datetime, values, states, qualities, errors, nanosecond);
        for (int i = 0; i < length; ++i) {
            ie = new DoubleData(ids[i], datetime[i], values[i], qualities[i], errors[i], nanosecond[i]);
            list.add(ie);
            if (errors[i] == 0) continue;
            ++errCount;
            sb.append("\u7b2c [" + (i + 1) + "] \u4e2a\u6807\u7b7e\u70b9id\u64cd\u4f5c\u5931\u8d25");
        }
        if (errCount == 0) {
            sb.append("\u64cd\u4f5c\u6210\u529f\uff01");
        }
        entity.setList(list);
        entity.setSucCount(length - errCount);
        entity.setRetInfo(sb);
        return entity;
    }

    @Override
    public int putIntSnapshots(List<IntData> intDataList) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        int count = intDataList.size();
        int[] ids = new int[count];
        Object[] dateTimes = new Object[count];
        double[] values = new double[count];
        long[] states = new long[count];
        short[] qualities = new short[count];
        int[] errors = new int[count];
        for (int i = 0; i < count; ++i) {
            ids[i] = intDataList.get(i).getId();
            dateTimes[i] = intDataList.get(i).dateTimeObj();
            values[i] = intDataList.get(i).getValue();
            states[i] = intDataList.get(i).getState();
            qualities[i] = intDataList.get(i).getQuality();
        }
        int sucCount = this.snapshot.putSnapshots(count, ids, dateTimes, values, states, qualities, errors);
        for (int i = 0; i < ids.length; ++i) {
            intDataList.get(i).setId(ids[i]);
            intDataList.get(i).setError(errors[i]);
        }
        return sucCount;
    }

    @Override
    public int putDoubleSnapshots(List<DoubleData> doubleDataList) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        int count = doubleDataList.size();
        int[] ids = new int[count];
        Object[] dateTimes = new Object[count];
        double[] values = new double[count];
        long[] states = new long[count];
        short[] qualities = new short[count];
        int[] errors = new int[count];
        for (int i = 0; i < count; ++i) {
            ids[i] = doubleDataList.get(i).getId();
            dateTimes[i] = doubleDataList.get(i).dateTimeObj();
            values[i] = doubleDataList.get(i).getValue();
            qualities[i] = doubleDataList.get(i).getQuality();
            errors[i] = doubleDataList.get(i).getError();
        }
        int sucCount = this.snapshot.putSnapshots(count, ids, dateTimes, values, states, qualities, errors);
        for (int i = 0; i < count; ++i) {
            if (doubleDataList.get(i).dateTimeObj().getClass().equals(Date.class)) {
                doubleDataList.get(i).setDateTime((Date)dateTimes[i]);
                doubleDataList.get(i).setNanosecond(0);
            } else if (doubleDataList.get(i).dateTimeObj().getClass().equals(DateTimeNS.class)) {
                doubleDataList.get(i).setDateTime(((DateTimeNS)dateTimes[i]).getDatetime());
                doubleDataList.get(i).setNanosecond(((DateTimeNS)dateTimes[i]).getNanosecond());
            }
            doubleDataList.get(i).setError(errors[i]);
            doubleDataList.get(i).setId(ids[i]);
            doubleDataList.get(i).setQuality(qualities[i]);
            doubleDataList.get(i).setValue(values[i]);
        }
        return sucCount;
    }

    @Override
    public int fixIntSnapshot(List<IntData> intDataList) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        int count = intDataList.size();
        int[] ids = new int[count];
        Object[] dateTimes = new Object[count];
        double[] values = new double[count];
        long[] states = new long[count];
        short[] qualities = new short[count];
        int[] errors = new int[count];
        for (int i = 0; i < count; ++i) {
            ids[i] = intDataList.get(i).getId();
            dateTimes[i] = intDataList.get(i).dateTimeObj();
            double value = intDataList.get(i).getValue();
            values[i] = 0.0;
            states[i] = (long)value;
            qualities[i] = intDataList.get(i).getQuality();
        }
        int sucCount = this.snapshot.fixSnapshots(count, ids, dateTimes, values, states, qualities, errors);
        for (int i = 0; i < errors.length; ++i) {
            intDataList.get(i).setError(errors[i]);
        }
        return sucCount;
    }

    @Override
    public int fixDoubleSnapshot(List<DoubleData> doubleDataList) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        int count = doubleDataList.size();
        int[] ids = new int[count];
        Object[] dateTimes = new Object[count];
        double[] values = new double[count];
        long[] states = new long[count];
        short[] qualities = new short[count];
        int[] errors = new int[count];
        for (int i = 0; i < count; ++i) {
            ids[i] = doubleDataList.get(i).getId();
            dateTimes[i] = doubleDataList.get(i).dateTimeObj();
            values[i] = doubleDataList.get(i).getValue();
            qualities[i] = doubleDataList.get(i).getQuality();
            states[i] = (long)doubleDataList.get(i).getValue();
        }
        int sucCount = this.snapshot.fixSnapshots(count, ids, dateTimes, values, states, qualities, errors);
        for (int i = 0; i < errors.length; ++i) {
            doubleDataList.get(i).setError(errors[i]);
        }
        return sucCount;
    }

    @Override
    public Entity<CoorData> getCoorSnapshots(int[] ids) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        Entity<CoorData> entity = new Entity<CoorData>();
        ArrayList<CoorData> list = new ArrayList<CoorData>(ids.length);
        StringBuffer sb = new StringBuffer();
        int errCount = 0;
        CoorData ie = null;
        int length = ids.length;
        Date[] datetime = new Date[length];
        float[] x = new float[length];
        float[] y = new float[length];
        short[] qualities = new short[length];
        int[] errors = new int[length];
        this.snapshot.getCoorSnapshots(length, ids, datetime, x, y, qualities, errors);
        for (int i = 0; i < length; ++i) {
            ie = new CoorData(ids[i], datetime[i], x[i], y[i], qualities[i], errors[i]);
            list.add(ie);
            if (errors[i] == 0) continue;
            ++errCount;
            sb.append("\u7b2c [" + (i + 1) + "] \u4e2a\u6807\u7b7e\u70b9id\u64cd\u4f5c\u5931\u8d25");
        }
        if (errCount == 0) {
            sb.append("\u64cd\u4f5c\u6210\u529f\uff01");
        }
        entity.setList(list);
        entity.setSucCount(length - errCount);
        entity.setRetInfo(sb);
        return entity;
    }

    @Override
    public Entity<CoorData> getCoorSnapshots_ns(int[] ids) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        Entity<CoorData> entity = new Entity<CoorData>();
        ArrayList<CoorData> list = new ArrayList<CoorData>(ids.length);
        StringBuffer sb = new StringBuffer();
        int errCount = 0;
        CoorData ie = null;
        int length = ids.length;
        Date[] datetime = new Date[length];
        int[] nanosecond = new int[length];
        float[] x = new float[length];
        float[] y = new float[length];
        short[] qualities = new short[length];
        int[] errors = new int[length];
        this.snapshot.getCoorSnapshots_ns(length, ids, datetime, x, y, qualities, errors, nanosecond);
        for (int i = 0; i < length; ++i) {
            ie = new CoorData(ids[i], datetime[i], x[i], y[i], qualities[i], errors[i], nanosecond[i]);
            list.add(ie);
            if (errors[i] == 0) continue;
            ++errCount;
            sb.append("\u7b2c [" + (i + 1) + "] \u4e2a\u6807\u7b7e\u70b9id\u64cd\u4f5c\u5931\u8d25");
        }
        if (errCount == 0) {
            sb.append("\u64cd\u4f5c\u6210\u529f\uff01");
        }
        entity.setList(list);
        entity.setSucCount(length - errCount);
        entity.setRetInfo(sb);
        return entity;
    }

    @Override
    public int putCoorSnapshots(List<CoorData> coorDataList) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        int count = coorDataList.size();
        int[] ids = new int[count];
        Object[] dateTimes = new Object[count];
        float[] x = new float[count];
        float[] y = new float[count];
        short[] qualities = new short[count];
        int[] errors = new int[count];
        for (int i = 0; i < count; ++i) {
            ids[i] = coorDataList.get(i).getId();
            dateTimes[i] = coorDataList.get(i).dateTimeObj();
            x[i] = coorDataList.get(i).getX();
            y[i] = coorDataList.get(i).getY();
            qualities[i] = coorDataList.get(i).getQuality();
        }
        int sucCount = this.snapshot.putCoorSnapshots(count, ids, dateTimes, x, y, qualities, errors);
        for (int i = 0; i < errors.length; ++i) {
            coorDataList.get(i).setId(ids[i]);
            coorDataList.get(i).setError(errors[i]);
        }
        return sucCount;
    }

    @Override
    public int fixCoorSnapshots(List<CoorData> coorDataList) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        int count = coorDataList.size();
        int[] ids = new int[count];
        Object[] dateTimes = new Object[count];
        float[] x = new float[count];
        float[] y = new float[count];
        short[] qualities = new short[count];
        int[] errors = new int[count];
        for (int i = 0; i < count; ++i) {
            ids[i] = coorDataList.get(i).getId();
            dateTimes[i] = coorDataList.get(i).dateTimeObj();
            x[i] = coorDataList.get(i).getX();
            y[i] = coorDataList.get(i).getY();
            qualities[i] = coorDataList.get(i).getQuality();
        }
        int sucCount = this.snapshot.fixCoorSnapshots(count, ids, dateTimes, x, y, qualities, errors);
        for (int i = 0; i < errors.length; ++i) {
            coorDataList.get(i).setError(errors[i]);
        }
        return sucCount;
    }

    @Override
    public Entity<BlobData> getBlobSnapshots(int[] ids) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        Entity<BlobData> entity = new Entity<BlobData>();
        ArrayList<BlobData> list = new ArrayList<BlobData>(ids.length);
        StringBuffer sb = new StringBuffer();
        int errCount = 0;
        int length = ids.length;
        Date[] datetime = new Date[length];
        byte[][] blobs = new byte[length][];
        short[] lens = new short[length];
        for (int i = 0; i < blobs.length; ++i) {
            blobs[i] = new byte[512];
        }
        short[] qualities = new short[length];
        int[] errors = new int[length];
        this.snapshot.getBlobSnapshots(length, ids, datetime, blobs, qualities, errors, lens);
        BlobData ie = null;
        for (int i = 0; i < length; ++i) {
            ie = new BlobData();
            ie.setId(ids[i]);
            ie.setDatetime(datetime[i]);
            if (blobs[i][0] == 32 && blobs[i][1] == 0) {
                if (errors[i] == RtdbError.GoE_OK.getErrcode() && qualities[i] == RtdbQuality.RTDB_Q_CREATED.getNum()) {
                    RtdbBlobData data = this.historian.getSingleBlobValue(ids[i], datetime[i], HisMode.EXACT, lens[i]);
                    ie.setBlob(data.getBlob());
                }
            } else {
                ie.setBlob(blobs[i]);
            }
            ie.setQuality(Quality.getQuality(qualities[i]));
            ie.setError(errors[i]);
            list.add(ie);
            if (errors[i] == 0) continue;
            ++errCount;
            sb.append("\u7b2c [" + (i + 1) + "] \u4e2a\u6807\u7b7e\u70b9id\u64cd\u4f5c\u5931\u8d25");
        }
        if (errCount == 0) {
            sb.append("\u64cd\u4f5c\u6210\u529f\uff01");
        }
        entity.setList(list);
        entity.setSucCount(length - errCount);
        entity.setRetInfo(sb);
        return entity;
    }

    @Override
    public Entity<BlobData> getBlobSnapshots_ns(int[] ids) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        Entity<BlobData> entity = new Entity<BlobData>();
        ArrayList<BlobData> list = new ArrayList<BlobData>(ids.length);
        StringBuffer sb = new StringBuffer();
        int errCount = 0;
        int length = ids.length;
        Date[] datetime = new Date[length];
        int[] nanosecond = new int[length];
        byte[][] blobs = new byte[length][];
        short[] lens = new short[length];
        for (int i = 0; i < blobs.length; ++i) {
            blobs[i] = new byte[512];
        }
        short[] qualities = new short[length];
        int[] errors = new int[length];
        this.snapshot.getBlobSnapshots_ns(length, ids, datetime, blobs, qualities, errors, lens, nanosecond);
        BlobData ie = null;
        for (int i = 0; i < length; ++i) {
            ie = new BlobData();
            ie.setId(ids[i]);
            ie.setDatetime(datetime[i]);
            ie.setNanosecond(nanosecond[i]);
            if (blobs[i][0] == 32 && blobs[i][1] == 0) {
                if (errors[i] == RtdbError.GoE_OK.getErrcode() && qualities[i] == RtdbQuality.RTDB_Q_CREATED.getNum()) {
                    DateTimeNS timeNS = new DateTimeNS(datetime[i], nanosecond[i]);
                    RtdbBlobData data = this.historian.getSingleBlobValue(ids[i], timeNS, HisMode.EXACT, lens[i]);
                    ie.setBlob(data.getBlob());
                }
            } else {
                ie.setBlob(blobs[i]);
            }
            ie.setQuality(Quality.getQuality(qualities[i]));
            ie.setError(errors[i]);
            list.add(ie);
            if (errors[i] == 0) continue;
            ++errCount;
            sb.append("\u7b2c [" + (i + 1) + "] \u4e2a\u6807\u7b7e\u70b9id\u64cd\u4f5c\u5931\u8d25");
        }
        if (errCount == 0) {
            sb.append("\u64cd\u4f5c\u6210\u529f\uff01");
        }
        entity.setList(list);
        entity.setSucCount(length - errCount);
        entity.setRetInfo(sb);
        return entity;
    }

    @Override
    public int putBlobSnapshots(List<BlobData> blobDataList) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        int count = blobDataList.size();
        int[] ids = new int[count];
        Object[] dateTimes = new Object[count];
        byte[][] blobs = new byte[count][];
        short[] qualities = new short[count];
        int[] errors = new int[count];
        for (int i = 0; i < count; ++i) {
            ids[i] = blobDataList.get(i).getId();
            dateTimes[i] = blobDataList.get(i).datetimeObj();
            blobs[i] = blobDataList.get(i).getBlob();
            qualities[i] = blobDataList.get(i).getQuality().getNum();
        }
        int sucCount = this.snapshot.putBlobSnapshots(count, ids, dateTimes, blobs, qualities, errors);
        for (int i = 0; i < sucCount; ++i) {
            blobDataList.get(i).setId(ids[i]);
            if (dateTimes[i].getClass().equals(Date.class)) {
                blobDataList.get(i).setDatetime((Date)dateTimes[i]);
                blobDataList.get(i).setNanosecond(0);
            } else if (dateTimes[i].getClass().equals(DateTimeNS.class)) {
                blobDataList.get(i).setDatetime(((DateTimeNS)dateTimes[i]).getDatetime());
                blobDataList.get(i).setNanosecond(((DateTimeNS)dateTimes[i]).getNanosecond());
            }
            blobDataList.get(i).setError(errors[i]);
        }
        return sucCount;
    }

    @Override
    public boolean putBlobSnapshot(BlobData blobData) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        if (blobData == null) {
            return false;
        }
        return this.snapshot.putBlobSnapshot(blobData.getId(), blobData.datetimeObj(), blobData.getBlob(), blobData.getQuality().getNum());
    }

    @Override
    public BlobData getBlobSnapshot(int id) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        BlobData data = new BlobData();
        RtdbBlobData blobRtdb = this.snapshot.getBlobSnapshot(id);
        if (blobRtdb == null) {
            return null;
        }
        int pointId = blobRtdb.getId();
        Date time = blobRtdb.getDatetime();
        data.setId(pointId);
        data.setDatetime(time);
        byte[] blobs = blobRtdb.getBlob();
        if (blobs[0] == 32 && blobs[1] == 0) {
            if (blobRtdb.getQuality() == RtdbQuality.RTDB_Q_CREATED) {
                RtdbBlobData blobdata = this.historian.getSingleBlobValue(pointId, time, HisMode.EXACT, (short)2048);
                data.setBlob(blobdata.getBlob());
            }
        } else {
            data.setBlob(blobs);
        }
        data.setQuality(Quality.getQuality(blobRtdb.getQuality().getNum()));
        return data;
    }

    @Override
    public BlobData getBlobSnapshot_ns(int id) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        BlobData data = new BlobData();
        RtdbBlobData blobRtdb = this.snapshot.getBlobSnapshot_ns(id);
        if (blobRtdb == null) {
            return null;
        }
        int pointId = blobRtdb.getId();
        Date time = blobRtdb.getDatetime();
        data.setId(pointId);
        data.setDatetime(time);
        DateTimeNS timeNS = new DateTimeNS(time, blobRtdb.getNanosecond());
        byte[] blobs = blobRtdb.getBlob();
        if (blobs[0] == 32 && blobs[1] == 0) {
            if (blobRtdb.getQuality() == RtdbQuality.RTDB_Q_CREATED) {
                RtdbBlobData blobdata = this.historian.getSingleBlobValue(pointId, timeNS, HisMode.EXACT, (short)2048);
                data.setBlob(blobdata.getBlob());
            }
        } else {
            data.setBlob(blobs);
        }
        data.setNanosecond(blobRtdb.getNanosecond());
        data.setQuality(Quality.getQuality(blobRtdb.getQuality().getNum()));
        return data;
    }

    @Override
    public int subscribeSnapshots(int[] ids, RSDataChange callback) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        int count = ids.length;
        int[] error = new int[count];
        int sucCount = this.snapshot.subscribeSnapshots(count, ids, callback, error);
        return sucCount;
    }

    @Override
    public int subscribeSnapshotsEx(Object param, int[] ids, RSDataChangeEx callback, int[] errors) throws NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        int sucCount = this.snapshot.subscribeSnapshotsEx(param, ids, callback, errors);
        return sucCount;
    }

    @Override
    public void cancelSubscribeSnapshots() throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        this.snapshot.cancelSubscribeSnapshots();
    }

    @Override
    public Entity<DatetimeData> getDateTimeSnapshots(int[] ids) throws InvalidParameterException, Exception {
        RtdbEntity<RtdbDatetimeData> dateTimeSnapshots = this.snapshot.getDateTimeSnapshots(ids);
        List<RtdbDatetimeData> list2 = dateTimeSnapshots.getList();
        Entity<DatetimeData> data = new Entity<DatetimeData>();
        List list = data.getList();
        for (RtdbDatetimeData reData : list2) {
            DatetimeData d = new DatetimeData();
            d.setDateTime(reData.getDate());
            d.setError(reData.getError());
            d.setId(reData.getId());
            d.setMs(reData.getMs());
            RtdbQuality quality = reData.getQuality();
            d.setQuality(quality.getNum());
            d.setValue(reData.getValue());
            list.add(d);
        }
        data.setList(list);
        return data;
    }

    @Override
    public Entity<DatetimeData> getDateTimeSnapshots_ns(int[] ids) throws InvalidParameterException, Exception {
        RtdbEntity<RtdbDatetimeData> dateTimeSnapshots = this.snapshot.getDateTimeSnapshots_ns(ids);
        List<RtdbDatetimeData> list2 = dateTimeSnapshots.getList();
        Entity<DatetimeData> data = new Entity<DatetimeData>();
        List list = data.getList();
        for (RtdbDatetimeData reData : list2) {
            DatetimeData d = new DatetimeData();
            d.setDateTime(reData.getDate());
            d.setError(reData.getError());
            d.setId(reData.getId());
            d.setMs(reData.getMs());
            RtdbQuality quality = reData.getQuality();
            d.setQuality(quality.getNum());
            d.setValue(reData.getValue());
            d.setNanosecond(reData.getNanosecond());
            list.add(d);
        }
        data.setList(list);
        return data;
    }

    @Override
    public Entity<DatetimeData> putDatetimeSnapshots(List<DatetimeData> list) throws InvalidParameterException, NoAuthorityException, Exception {
        if (list == null || list.size() == 0) {
            throw new InvalidParameterException();
        }
        ArrayList<RtdbDatetimeData> listRtdb = new ArrayList<RtdbDatetimeData>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            DatetimeData date = list.get(i);
            RtdbDatetimeData rtdb = new RtdbDatetimeData();
            rtdb.setDate(date.dateTimeObj());
            rtdb.setError(date.getError());
            rtdb.setId(date.getId());
            rtdb.setMs(date.getMs());
            rtdb.setQuality(date.getQuality());
            rtdb.setValue(date.getValue());
            listRtdb.add(rtdb);
        }
        RtdbEntity<RtdbDatetimeData> putDatetimeSnapshots = this.snapshot.putDatetimeSnapshots(listRtdb);
        Entity<DatetimeData> results = new Entity<DatetimeData>();
        ArrayList<DatetimeData> datas = null;
        for (RtdbDatetimeData rtdbDatetimeData : putDatetimeSnapshots.getList()) {
            datas = new ArrayList<DatetimeData>();
            DatetimeData data = new DatetimeData();
            data.setDateTime(rtdbDatetimeData.getDate());
            data.setError(rtdbDatetimeData.getError());
            data.setId(rtdbDatetimeData.getId());
            data.setMs(rtdbDatetimeData.getMs());
            data.setValue(rtdbDatetimeData.getValue());
            datas.add(data);
            results.setList(datas);
        }
        return results;
    }

    @Override
    public Entity<IntData> getIntSnapshots(String[] tagNames) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, UnexpectedMethodException, Exception {
        if (tagNames == null || tagNames.length == 0) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(tagNames);
        return this.getIntSnapshots(ids);
    }

    @Override
    public Entity<IntData> getIntSnapshots_ns(String[] tagNames) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, UnexpectedMethodException, Exception {
        if (tagNames == null || tagNames.length == 0) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(tagNames);
        return this.getIntSnapshots_ns(ids);
    }

    @Override
    public Entity<DoubleData> getDoubleSnapshots(String[] tagNames) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, UnexpectedMethodException, Exception {
        if (tagNames == null || tagNames.length == 0) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(tagNames);
        return this.getDoubleSnapshots(ids);
    }

    @Override
    public Entity<DoubleData> getDoubleSnapshots_ns(String[] tagNames) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, UnexpectedMethodException, Exception {
        if (tagNames == null || tagNames.length == 0) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(tagNames);
        return this.getDoubleSnapshots_ns(ids);
    }

    @Override
    public Entity<CoorData> getCoorSnapshots(String[] tagNames) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        if (tagNames == null || tagNames.length == 0) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(tagNames);
        return this.getCoorSnapshots(ids);
    }

    @Override
    public Entity<CoorData> getCoorSnapshots_ns(String[] tagNames) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        if (tagNames == null || tagNames.length == 0) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(tagNames);
        return this.getCoorSnapshots_ns(ids);
    }

    @Override
    public BlobData getBlobSnapshot(String tagName) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        if (tagName == null || tagName.isEmpty()) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(new String[]{tagName});
        if (ids[0] > 0) {
            return this.getBlobSnapshot(ids[0]);
        }
        return null;
    }

    @Override
    public BlobData getBlobSnapshot_ns(String tagName) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        if (tagName == null || tagName.isEmpty()) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(new String[]{tagName});
        if (ids[0] > 0) {
            return this.getBlobSnapshot_ns(ids[0]);
        }
        return null;
    }

    @Override
    public Entity<BlobData> getBlobSnapshots(String[] tagNames) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        if (tagNames == null || tagNames.length == 0) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(tagNames);
        return this.getBlobSnapshots(ids);
    }

    @Override
    public Entity<BlobData> getBlobSnapshots_ns(String[] tagNames) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        if (tagNames == null || tagNames.length == 0) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(tagNames);
        return this.getBlobSnapshots_ns(ids);
    }

    @Override
    public int subscribeSnapshots(String[] tagNames, RSDataChange callback) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (tagNames == null || tagNames.length == 0) {
            return 0;
        }
        int[] ids = this.getIdsByTagNames(tagNames);
        return this.subscribeSnapshots(ids, callback);
    }

    @Override
    public Entity<DatetimeData> getDateTimeSnapshots(String[] tagNames) throws InvalidParameterException, Exception {
        if (tagNames == null || tagNames.length == 0) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(tagNames);
        return this.getDateTimeSnapshots(ids);
    }

    @Override
    public Entity<DatetimeData> getDateTimeSnapshots_ns(String[] tagNames) throws InvalidParameterException, Exception {
        if (tagNames == null || tagNames.length == 0) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(tagNames);
        return this.getDateTimeSnapshots_ns(ids);
    }

    private int[] getIdsByTagNames(String[] tableTags) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        int count = tableTags.length;
        int[] ids = new int[count];
        RtdbType[] types = new RtdbType[count];
        RTDBClass[] classof = new RTDBClass[count];
        boolean[] useMs = new boolean[count];
        this.base.findPoints(count, tableTags, ids, types, classof, useMs);
        return ids;
    }

    @Override
    public NamedTypeData getNamedTypeSnapshot(int id, int length) throws InvalidParameterException, NoAuthorityException, Exception {
        RtdbNamedTypeData namedType1 = this.snapshot.getNamedTypeSnapshot(id, length);
        NamedTypeData result = null;
        if (namedType1 == null) {
            return result;
        }
        result = new NamedTypeData(namedType1.getId(), namedType1.getValue(), (Object)((Date)namedType1.getDatetime()), namedType1.getMs(), (int)namedType1.getLen(), namedType1.getQuality());
        return result;
    }

    @Override
    public NamedTypeData getNamedTypeSnapshot_ns(int id, int length) throws InvalidParameterException, NoAuthorityException, Exception {
        RtdbNamedTypeData namedType1 = this.snapshot.getNamedTypeSnapshot_ns(id, length);
        NamedTypeData result = null;
        if (namedType1 == null) {
            return result;
        }
        result = new NamedTypeData(namedType1.getId(), namedType1.getValue(), namedType1.getDatetime(), namedType1.getMs(), namedType1.getLen(), namedType1.getQuality(), namedType1.getNanosecond());
        return result;
    }

    @Override
    public Entity<NamedTypeData> getNamedTypeSnapshots(int[] ids, short[] lengths) throws InvalidParameterException, NoAuthorityException, Exception {
        RtdbEntity<RtdbNamedTypeData> entity = this.snapshot.getNamedTypeSnapshots(ids, lengths);
        Entity<NamedTypeData> result = null;
        if (entity == null) {
            return result;
        }
        result = new Entity<NamedTypeData>();
        List<RtdbNamedTypeData> listRtdb = entity.getList();
        ArrayList<NamedTypeData> listData = new ArrayList<NamedTypeData>(entity.getSucCount());
        for (int i = 0; i < listRtdb.size(); ++i) {
            RtdbNamedTypeData rtdb = listRtdb.get(i);
            NamedTypeData date = new NamedTypeData(rtdb.getId(), rtdb.getValue(), (Object)((Date)rtdb.getDatetime()), rtdb.getMs(), (int)rtdb.getLen(), rtdb.getQuality());
            listData.add(date);
        }
        result.setSucCount(entity.getSucCount());
        result.setList(listData);
        return result;
    }

    @Override
    public Entity<NamedTypeData> getNamedTypeSnapshots_ns(int[] ids, short[] lengths) throws InvalidParameterException, NoAuthorityException, Exception {
        RtdbEntity<RtdbNamedTypeData> entity = this.snapshot.getNamedTypeSnapshots_ns(ids, lengths);
        Entity<NamedTypeData> result = null;
        if (entity == null) {
            return result;
        }
        result = new Entity<NamedTypeData>();
        List<RtdbNamedTypeData> listRtdb = entity.getList();
        ArrayList<NamedTypeData> listData = new ArrayList<NamedTypeData>(entity.getSucCount());
        for (int i = 0; i < listRtdb.size(); ++i) {
            RtdbNamedTypeData rtdb = listRtdb.get(i);
            NamedTypeData date = new NamedTypeData(rtdb.getId(), rtdb.getValue(), rtdb.getDatetime(), rtdb.getMs(), rtdb.getLen(), rtdb.getQuality(), rtdb.getNanosecond());
            listData.add(date);
        }
        result.setSucCount(entity.getSucCount());
        result.setList(listData);
        return result;
    }

    @Override
    public boolean putNamedTypeSnapshot(NamedTypeData named) throws NoAuthorityException, Exception {
        if (named == null) {
            throw new InvalidParameterException();
        }
        RtdbNamedTypeData model = new RtdbNamedTypeData(named.getId(), named.getValue(), named.datetimeObj(), named.getMs(), (int)named.getLen(), named.getQuality());
        return this.snapshot.putNamedTypeSnapshot(model);
    }

    @Override
    public Entity<NamedTypeData> putNamedTypeSnapshots(List<NamedTypeData> list) throws InvalidParameterException, NoAuthorityException, Exception {
        if (list == null || list.size() == 0) {
            throw new InvalidParameterException();
        }
        List<RtdbNamedTypeData> listRtdb = new ArrayList<RtdbNamedTypeData>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            NamedTypeData data = list.get(i);
            RtdbNamedTypeData rtdb = new RtdbNamedTypeData(data.getId(), data.getValue(), data.datetimeObj(), data.getMs(), (int)data.getLen(), data.getQuality());
            listRtdb.add(rtdb);
        }
        RtdbEntity<RtdbNamedTypeData> entity = this.snapshot.putNamedTypeSnapshots(listRtdb);
        Entity<NamedTypeData> result = null;
        if (entity == null) {
            return result;
        }
        result = new Entity<NamedTypeData>();
        listRtdb = entity.getList();
        list = new ArrayList<NamedTypeData>(listRtdb.size());
        for (int i = 0; i < listRtdb.size(); ++i) {
            RtdbNamedTypeData rtdb = listRtdb.get(i);
            NamedTypeData date = new NamedTypeData(rtdb.getId(), rtdb.getValue(), (Object)((Date)rtdb.getDatetime()), rtdb.getMs(), (int)rtdb.getLen(), rtdb.getQuality());
            date.setError(rtdb.getError());
            list.add(date);
        }
        result.setSucCount(entity.getSucCount());
        result.setList(list);
        return result;
    }

    @Override
    public int[] flushCachedValues(int[] ids) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (0 == ids.length) {
            throw new InvalidParameterException();
        }
        return this.snapshot.flushCachedValues(ids);
    }

    @Override
    public List<ValueData> getSnapshots(int[] ids) throws InvalidParameterException, NoAuthorityException, Exception {
        return this.snapshot.getSnapshot(ids);
    }

    @Override
    public List<ValueData> getSnapshots_ns(int[] ids) throws InvalidParameterException, NoAuthorityException, Exception {
        return this.snapshot.getSnapshot_ns(ids);
    }
}

