package com.beagle.base.common.util;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson2.JSON;
import com.beagle.base.bean.vo.*;
import com.rtdb.model.*;
import io.swagger.models.auth.In;
import lombok.extern.slf4j.Slf4j;

import java.util.ArrayList;
import java.util.List;
@Slf4j
public class SnapshotUtil {

    public static List<DoubleData> getDoubleSnapshots(SnapshotDoubleParam param) {
        List<DoubleData> res = new ArrayList<>();
        try {
            Entity<DoubleData> d = CommonUtil.getSnapshotImpl().getDoubleSnapshots(param.getIds());
            if (d != null && CollUtil.isNotEmpty(d.getList())) {
                res = d.getList();
            }
            return res;
        }catch (Exception e) {
            log.error("base 获取getDoubleSnapshots接口异常，请求参数为：{}", JSON.toJSONString(param), e);
            return res;
        }
    }

    public static List<IntData> getIntSnapshots(SnapshotIntParam param) {
        List<IntData> res = new ArrayList<>();
        try {
            Entity<IntData> intSnapshots = CommonUtil.getSnapshotImpl().getIntSnapshots(param.getIds());
            if (intSnapshots != null && CollUtil.isNotEmpty(intSnapshots.getList())) {
                res = intSnapshots.getList();
            }
            return res;
        }catch (Exception e) {
            log.error("base 获取getIntSnapshots接口异常，请求参数为：{}", JSON.toJSONString(param), e);
            return res;
        }
    }

    public static List<BlobData> getBlobSnapshots(SnapshotBlobParam param) {
        List<BlobData> res = new ArrayList<>();
        try {
            Entity<BlobData> blobSnapshots = CommonUtil.getSnapshotImpl().getBlobSnapshots(param.getIds());
            if (blobSnapshots != null && CollUtil.isNotEmpty(blobSnapshots.getList())) {
                res = blobSnapshots.getList();
            }
            return res;
        }catch (Exception e) {
            log.error("base 获取getBlobSnapshots接口异常，请求参数为：{}", JSON.toJSONString(param), e);
            return res;
        }
    }

    public static List<CoorData> getCoorSnapshots(SnapshotCoorParam param) {
        List<CoorData> res = new ArrayList<>();
        try {
            Entity<CoorData> coorSnapshots = CommonUtil.getSnapshotImpl().getCoorSnapshots(param.getIds());
            if (coorSnapshots != null && CollUtil.isNotEmpty(coorSnapshots.getList())) {
                res = coorSnapshots.getList();
            }
            return res;
        }catch (Exception e) {
            log.error("base 获取getCoorSnapshots接口异常，请求参数为：{}", JSON.toJSONString(param), e);
            return res;
        }
    }

    public static Integer putIntSnapshots(SnapshotPutIntParam param) {
        Integer count = 0;
        try {
            count = CommonUtil.getSnapshotImpl().putIntSnapshots(param.getIntDataList());
            return count;
        }catch (Exception e) {
            log.error("base 获取putIntSnapshots接口异常，请求参数为：{}", JSON.toJSONString(param), e);
            return count;
        }
    }

    public static Integer putDoubleSnapshots(SnapshotPutDoubleParam param) {
        Integer count = 0;
        try {
            count = CommonUtil.getSnapshotImpl().putDoubleSnapshots(param.getDoubleDataList());
            return count;
        }catch (Exception e) {
            log.error("base 获取putDoubleSnapshots接口异常，请求参数为：{}", JSON.toJSONString(param), e);
            return count;
        }
    }
}
