package com.beagle.base.service.impl;

import cn.hutool.core.util.NumberUtil;
import com.beagle.base.bean.vo.BaseCacheByIdParam;
import com.beagle.base.bean.vo.BaseCacheByTagParam;
import com.beagle.base.bean.vo.BasePointVO;
import com.beagle.base.common.contant.CacheConstants;
import com.beagle.base.service.CacheService;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.rtdb.model.FullPoint;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

@Service
public class CacheServiceImpl implements CacheService {

    @Resource
    @Qualifier(value= "loadingCache")
    private LoadingCache<Object, Object> cache;

    @Override
    public Integer getBaseIdByTag(BaseCacheByTagParam param) {
        // 从缓存中获取
        return NumberUtil.parseInt(cache.get(CacheConstants.TAG_PREFIX + param.getTag()) + "");
    }

    @Override
    public BasePointVO getBasePointById(BaseCacheByIdParam param) {
        // 从缓存中获取
        // 从缓存中获取
        return (BasePointVO) cache.get(CacheConstants.POINT_PREFIX + param.getId());
    }
}
