package com.beagle.base.service.impl;


import com.beagle.base.bean.vo.HistorianDoubleArchivedValuesParam;
import com.beagle.base.bean.vo.HistorianFloatArchivedValuesFiltParam;
import com.beagle.base.bean.vo.HistorianFloatInterpoValuesParam;
import com.beagle.base.bean.vo.HistorianFloatIntervalValuesParam;
import com.beagle.base.common.util.HistorianUtil;
import com.beagle.base.service.HistorianService;
import com.rtdb.model.DoubleData;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @author lzz
 */
@Service
@Slf4j
public class HistorianServiceImpl implements HistorianService {

    @Override
    public List<DoubleData> getFloatIntervalValues(HistorianFloatIntervalValuesParam param) {
        return HistorianUtil.getFloatIntervalValues(param);
    }

    @Override
    public List<DoubleData> getFloatInterpoValues(HistorianFloatInterpoValuesParam param) {
        return HistorianUtil.getFloatInterpoValues(param);
    }

    @Override
    public List<DoubleData> getFloatArchivedValuesFilt(HistorianFloatArchivedValuesFiltParam param) {
        return HistorianUtil.getFloatArchivedValuesFilt(param);
    }

    @Override
    public List<DoubleData> getDoubleArchivedValues(HistorianDoubleArchivedValuesParam param) {
        return HistorianUtil.getDoubleArchivedValues(param);
    }
}
