package com.beagle.base.service.impl;


import com.beagle.base.bean.vo.*;
import com.beagle.base.common.util.SnapshotUtil;
import com.beagle.base.service.SnapshotService;
import com.rtdb.model.BlobData;
import com.rtdb.model.CoorData;
import com.rtdb.model.DoubleData;
import com.rtdb.model.IntData;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author lzz
 */
@Service
@Slf4j
public class SnapshotServiceImpl implements SnapshotService {

    @Override
    public List<DoubleData> getDoubleSnapshots(SnapshotDoubleParam param) {
        return SnapshotUtil.getDoubleSnapshots(param);
    }

    @Override
    public List<IntData> getIntSnapshots(SnapshotIntParam param) {
        return SnapshotUtil.getIntSnapshots(param);
    }

    @Override
    public List<BlobData> getBlobSnapshots(SnapshotBlobParam param) {
        return SnapshotUtil.getBlobSnapshots(param);
    }

    @Override
    public List<CoorData> getCoorSnapshots(SnapshotCoorParam param) {
        return SnapshotUtil.getCoorSnapshots(param);
    }

    @Override
    public Integer putIntSnapshots(SnapshotPutIntParam param) {
        return SnapshotUtil.putIntSnapshots(param);
    }

    @Override
    public Integer putDoubleSnapshots(SnapshotPutDoubleParam param) {
        return SnapshotUtil.putDoubleSnapshots(param);

    }
}

