/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.api.common;

import com.rtdb.api.enums.RtdbError;
import java.util.HashMap;
import java.util.Map;

public class RtdbErrorParse {
    private static Map<String, RtdbError> errorMap = null;

    public static RtdbError getRtdbError(long errcode) {
        String key = Integer.toHexString((int)errcode);
        key = key.equals("0") ? "0x00000000" : "0x" + key.toUpperCase();
        return errorMap.get(key);
    }

    static {
        errorMap = new HashMap<String, RtdbError>();
        errorMap.put("0xFFFFFFFF", RtdbError.GoE_UNKNOWN_ERROR);
        errorMap.put("0xFFFFC022", RtdbError.GoE_UNABLE_NETWORK_CONNECTION);
        errorMap.put("0x00000000", RtdbError.GoE_OK);
        errorMap.put("0xFFF00000", RtdbError.GoE_WINDOWS_ERROR);
        errorMap.put("0xFFFF0000", RtdbError.GoE_WINDOWS_ERROR_MAX);
        errorMap.put("0xFFFF0001", RtdbError.GoE_INVALID_OPENMODE);
        errorMap.put("0xFFFF0002", RtdbError.GoE_OPENFILE_FAILED);
        errorMap.put("0xFFFF0003", RtdbError.GoE_MOVETOEND_FAILED);
        errorMap.put("0xFFFF0004", RtdbError.GoE_DIFFER_READBYTES);
        errorMap.put("0xFFFF0005", RtdbError.GoE_GETFILEPOS_FAILED);
        errorMap.put("0xFFFF0006", RtdbError.GoE_FLUSHFILE_FAILED);
        errorMap.put("0xFFFF0007", RtdbError.GoE_SETSIZE_FAILED);
        errorMap.put("0xFFFF0008", RtdbError.GoE_FILE_NOT_CLOSED);
        errorMap.put("0xFFFF0009", RtdbError.GoE_FILE_UNKNOWN);
        errorMap.put("0xFFFF000A", RtdbError.GoE_INVALID_HEADER);
        errorMap.put("0xFFFF000B", RtdbError.GoE_DISABLED_FILE);
        errorMap.put("0xFFFF000C", RtdbError.GoE_FILE_NOT_OPENED);
        errorMap.put("0xFFFF000D", RtdbError.GoE_POINT_NOT_FOUND);
        errorMap.put("0xFFFF000E", RtdbError.GoE_READYBLOCK_NOT_FOUND);
        errorMap.put("0xFFFF000F", RtdbError.GoE_FILE_IS_INCULT);
        errorMap.put("0xFFFF0010", RtdbError.GoE_FILE_IS_FULL);
        errorMap.put("0xFFFF0011", RtdbError.GoE_FILEEX_IS_FULL);
        errorMap.put("0xFFFF0012", RtdbError.GoE_INVALID_DATA_TYPE);
        errorMap.put("0xFFFF0013", RtdbError.GoE_DATABLOCK_NOT_FOUND);
        errorMap.put("0xFFFF0014", RtdbError.GoE_DATA_BETWEEN_BLOCK);
        errorMap.put("0xFFFF0015", RtdbError.GoE_CANT_MODIFY_EXIST_VALUE);
        errorMap.put("0xFFFF0016", RtdbError.GoE_WRONGDATA_IN_BLOCK);
        errorMap.put("0xFFFF0017", RtdbError.GoE_DATATIME_NOT_IN);
        errorMap.put("0xFFFF0018", RtdbError.GoE_NULL_ARCHIVE_PATH);
        errorMap.put("0xFFFF0019", RtdbError.GoE_REG_ARCHIVE_PATH);
        errorMap.put("0xFFFF001A", RtdbError.GoE_UNREG_ARCHIVE_PATH);
        errorMap.put("0xFFFF001B", RtdbError.GoE_FILE_INEXISTENCE);
        errorMap.put("0xFFFF001C", RtdbError.GoE_DATA_TYPE_NOT_MATCH);
        errorMap.put("0xFFFF001D", RtdbError.GoE_FILE_IS_READONLY);
        errorMap.put("0xFFFF001E", RtdbError.GoE_TOMANY_ARCHIVE_FILE);
        errorMap.put("0xFFFF001F", RtdbError.GoE_NO_POINTS_LIST);
        errorMap.put("0xFFFF0020", RtdbError.GoE_NO_ACTIVED_ARCHIVE);
        errorMap.put("0xFFFF0021", RtdbError.GoE_NO_ARCHIVE_FILE);
        errorMap.put("0xFFFF0022", RtdbError.GoE_NEED_ACTIVED_ARCHIVE);
        errorMap.put("0xFFFF0023", RtdbError.GoE_INVALID_TIMESTAMP);
        errorMap.put("0xFFFF0024", RtdbError.GoE_NEED_MORE_WRITABLE);
        errorMap.put("0xFFFF0025", RtdbError.GoE_NO_ARCHIVE_FOR_PUT);
        errorMap.put("0xFFFF0026", RtdbError.GoE_INVALID_VALUE_MODE);
        errorMap.put("0xFFFF0027", RtdbError.GoE_DATA_NOT_FOUND);
        errorMap.put("0xFFFF0028", RtdbError.GoE_INVALID_PARAMETER);
        errorMap.put("0xFFFF0029", RtdbError.GoE_REDUPLICATE_TAG);
        errorMap.put("0xFFFF002A", RtdbError.GoE_REDUPLICATE_TABNAME);
        errorMap.put("0xFFFF002B", RtdbError.GoE_REDUPLICATE_TABID);
        errorMap.put("0xFFFF002C", RtdbError.GoE_TABLE_NOT_FOUND);
        errorMap.put("0xFFFF002D", RtdbError.GoE_UNSUPPORTED_CLASSOF);
        errorMap.put("0xFFFF002E", RtdbError.GoE_WRONG_OR_DUPLIC_TAG);
        errorMap.put("0xFFFF002F", RtdbError.GoE_REDUPLICATE_PT);
        errorMap.put("0xFFFF0030", RtdbError.GoE_POINT_LICENSE_FULL);
        errorMap.put("0xFFFF0031", RtdbError.GoE_TABLE_LICENSE_FULL);
        errorMap.put("0xFFFF0032", RtdbError.GoE_WRONG_OR_DUPLIC_TABNAME);
        errorMap.put("0xFFFF0033", RtdbError.GoE_INVALID_FILE_FORMAT);
        errorMap.put("0xFFFF0034", RtdbError.GoE_WRONG_TABNAME);
        errorMap.put("0xFFFF0035", RtdbError.GoE_WRONG_TAG);
        errorMap.put("0xFFFF0036", RtdbError.GoE_NOT_IN_SCOPE);
        errorMap.put("0xFFFF0037", RtdbError.GoE_CANT_LOAD_BASE);
        errorMap.put("0xFFFF0038", RtdbError.GoE_CANT_LOAD_SNAPSHOT);
        errorMap.put("0xFFFF0039", RtdbError.GoE_CANT_LOAD_HISTORY);
        errorMap.put("0xFFFF003A", RtdbError.GoE_CANT_LOAD_EQUATION);
        errorMap.put("0xFFFF003B", RtdbError.GoE_ARRAY_SIZE_NOT_MATCH);
        errorMap.put("0xFFFF003C", RtdbError.GoE_INVALID_HOST_ADDRESS);
        errorMap.put("0xFFFF003D", RtdbError.GoE_CONNECT_FALSE);
        errorMap.put("0xFFFF003E", RtdbError.GoE_TOOMANY_BYTES_RECVED);
        errorMap.put("0xFFFF003F", RtdbError.GoE_REQID_RESPID_NOT_MATCH);
        errorMap.put("0xFFFF0040", RtdbError.GoE_LESS_BYTES_RECVED);
        errorMap.put("0xFFFF0041", RtdbError.GoE_UNSUPPORTED_CALC_MODE);
        errorMap.put("0xFFFF0042", RtdbError.GoE_UNSUPPORTED_DATA_TYPE);
        errorMap.put("0xFFFF0043", RtdbError.GoE_INVALID_EXPRESSION);
        errorMap.put("0xFFFF0044", RtdbError.GoE_INCOND_DATA_NOT_FOUND);
        errorMap.put("0xFFFF0045", RtdbError.GoE_VALID_DATA_NOT_FOUND);
        errorMap.put("0xFFFF0046", RtdbError.GoE_VALUE_OR_STATE_IS_NAN);
        errorMap.put("0xFFFF0047", RtdbError.GoE_CREATE_MUTEX_FAILED);
        errorMap.put("0xFFFF0048", RtdbError.GoE_TLSALLOCFAIL);
        errorMap.put("0xFFFF0049", RtdbError.GoE_TO_MANY_POINTS);
        errorMap.put("0xFFFF004A", RtdbError.GoE_LIC_INFO_ERROR);
        errorMap.put("0xFFFF004B", RtdbError.GoE_ARCHIVE_BUFFER_FULL);
        errorMap.put("0xFFFF004C", RtdbError.GoE_USER_NOT_EXIST);
        errorMap.put("0xFFFF004D", RtdbError.GoE_USER_IS_DISABLED);
        errorMap.put("0xFFFF004E", RtdbError.GoE_WRONG_PASSWORD);
        errorMap.put("0xFFFF004F", RtdbError.GoE_ACCESS_IS_DENIED);
        errorMap.put("0xFFFF0050", RtdbError.GoE_HAVE_NOT_LOGIN);
        errorMap.put("0xFFFF0051", RtdbError.GoE_USER_IS_DELETED);
        errorMap.put("0xFFFF0052", RtdbError.GoE_USER_ALREADY_EXIST);
        errorMap.put("0xFFFF0053", RtdbError.GoE_WRONG_CREATE_TABNAME);
        errorMap.put("0xFFFF0054", RtdbError.GoE_WRONG_FIELD_VALUE);
        errorMap.put("0xFFFF0055", RtdbError.GoE_INVALID_TAG_ID);
        errorMap.put("0xFFFF0056", RtdbError.GoE_CHECK_NAMED_TYPE_NAME_ERROR);
        errorMap.put("0xFFFF1001", RtdbError.GoE_NO_FREE_TABLE_ID);
        errorMap.put("0xFFFF1002", RtdbError.GoE_NO_FREE_TAG_POSITION);
        errorMap.put("0xFFFF1003", RtdbError.GoE_NO_FREE_SCAN_TAG_POSITION);
        errorMap.put("0xFFFF1004", RtdbError.GoE_NO_FREE_CALC_TAG_POSITION);
        errorMap.put("0xFFFF1005", RtdbError.GoE_INVALID_IPC_POSITION);
        errorMap.put("0xFFFF1006", RtdbError.GoE_WRONG_IPC_POSITION);
        errorMap.put("0xFFFF1007", RtdbError.GoE_IPC_ACCESS_EXCEPTION);
        errorMap.put("0xFFFF1008", RtdbError.GoE_ARV_PAGE_NOT_READY);
        errorMap.put("0xFFFF1009", RtdbError.GoE_ARVEX_PAGE_NOT_READY);
        errorMap.put("0xFFFF100A", RtdbError.GoE_INVALID_POSITION_FROM_ID);
        errorMap.put("0xFFFF100B", RtdbError.GoE_NO_ACTIVE_PAGE_ALLOCATOR);
        errorMap.put("0xFFFF100C", RtdbError.GoE_MAP_IS_NOT_READY);
        errorMap.put("0xFFFF100D", RtdbError.GoE_FILE_MAP_FAILED);
        errorMap.put("0xFFFF100E", RtdbError.GoE_TIME_RANGE_NOT_ALLOWED);
        errorMap.put("0xFFFF100F", RtdbError.GoE_NO_DATA_FOR_SUMMARY);
        errorMap.put("0xFFFF1010", RtdbError.GoE_CANT_OPERATE_ON_ACTIVED);
        errorMap.put("0xFFFF1011", RtdbError.GoE_SCAN_POINT_LICENSE_FULL);
        errorMap.put("0xFFFF1012", RtdbError.GoE_CALC_POINT_LICENSE_FULL);
        errorMap.put("0xFFFF1013", RtdbError.GoE_HISTORIAN_IS_SHUTTINGDOWN);
        errorMap.put("0xFFFF1014", RtdbError.GoE_SNAPSHOT_IS_SHUTTINGDOWN);
        errorMap.put("0xFFFF1015", RtdbError.GoE_EQUATION_IS_SHUTTINGDOWN);
        errorMap.put("0xFFFF1016", RtdbError.GoE_BASE_IS_SHUTTINGDOWN);
        errorMap.put("0xFFFF1017", RtdbError.GoE_SERVER_IS_SHUTTINGDOWN);
        errorMap.put("0xFFFF1018", RtdbError.GoE_OUT_OF_MEMORY);
        errorMap.put("0xFFFF1019", RtdbError.GoE_INVALID_PAGE);
        errorMap.put("0xFFFF101A", RtdbError.GoE_PAGE_IS_EMPTY);
        errorMap.put("0xFFFF101B", RtdbError.GoE_STR_OR_BLOB_TOO_LONG);
        errorMap.put("0xFFFF101C", RtdbError.GoE_CREATED_OR_OVERDUE);
        errorMap.put("0xFFFF101D", RtdbError.GoE_ARCHIVE_INFO_NOT_MATCHING);
        errorMap.put("0xFFFF101E", RtdbError.GoE_TIME_RANGE_OVERLAPPING);
        errorMap.put("0xFFFF101F", RtdbError.GoE_CANNOT_SHIFT_TO_ACTIVED);
        errorMap.put("0xFFFF1020", RtdbError.GoE_INDEX_NOT_READY);
        errorMap.put("0xFFFF1021", RtdbError.GoE_INDEX_NODE_NOT_MATCH);
        errorMap.put("0xFFFF1022", RtdbError.GoE_CAN_NOT_CREATE_INDEX);
        errorMap.put("0xFFFF1023", RtdbError.GoE_CAN_NOT_REMOVE_INDEX);
        errorMap.put("0xFFFF1024", RtdbError.GoE_INVALID_FILTER_EXPRESS);
        errorMap.put("0xFFFF1025", RtdbError.GoE_MORE_VAR_IN_FILTER_EXP);
        errorMap.put("0xFFFF1026", RtdbError.GoE_INVALID_ARV_PAGE_ALLOCATE);
        errorMap.put("0xFFFF1027", RtdbError.GoE_INVALID_ARVEX_PAGE_ALLOCATE);
        errorMap.put("0xFFFF1028", RtdbError.GoE_BIG_JOB_IS_NOT_DONE);
        errorMap.put("0xFFFF1029", RtdbError.GoE_DATABASE_NEED_RESTART);
        errorMap.put("0xFFFF102A", RtdbError.GoE_INVALID_TIME_FORMAT);
        errorMap.put("0xFFFF102B", RtdbError.GoE_DATA_PLAYBACK_DONE);
        errorMap.put("0xFFFF102C", RtdbError.GoE_BAD_EQUATION);
        errorMap.put("0xFFFF102D", RtdbError.GoE_NOT_ENOUGH_SAPCE);
        errorMap.put("0xFFFF102E", RtdbError.GoE_ACTIVED_ARCHIVE_EXIST);
        errorMap.put("0xFFFF102F", RtdbError.GoE_ARCHIVE_HAVE_EX_FILES);
        errorMap.put("0xFFFF1030", RtdbError.GoE_ARCHIVE_IS_NOT_LATEST);
        errorMap.put("0xFFFF1031", RtdbError.GoE_DB_SYSTEM_NOT_RUNNING);
        errorMap.put("0xFFFF1032", RtdbError.GoE_ARCHIVE_IS_ALTERED);
        errorMap.put("0xFFFF1033", RtdbError.GoE_ARCHIVE_IS_TOO_SMALL);
        errorMap.put("0xFFFF1034", RtdbError.GoE_INVALID_INDEX_NODE);
        errorMap.put("0xFFFF1035", RtdbError.GoE_MODIFY_SNAPSHOT_NOT_ALLOWED);
        errorMap.put("0xFFFF1036", RtdbError.GoE_SEARCH_INTERRUPTED);
        errorMap.put("0xFFFF1037", RtdbError.GoE_RECYCLE_SHUTDOWN);
        errorMap.put("0xFFFF1038", RtdbError.GoE_NEED_TO_REINDEX);
        errorMap.put("0xFFFF1039", RtdbError.GoE_INVALID_QUALITY);
        errorMap.put("0xFFFF103A", RtdbError.GoE_EQUATION_NOT_READY);
        errorMap.put("0xFFFF103B", RtdbError.GoE_ARCHIVES_LICENSE_FULL);
        errorMap.put("0xFFFF103C", RtdbError.GoE_RECYCLED_LICENSE_FULL);
        errorMap.put("0xFFFF103D", RtdbError.GoE_STR_BLOB_LICENSE_FULL);
        errorMap.put("0xFFFF103E", RtdbError.GoE_NOT_SUPPORT_WHEN_DEBUG);
        errorMap.put("0xFFFF103F", RtdbError.GoE_MAPPING_ALREADY_LOADED);
        errorMap.put("0xFFFF1040", RtdbError.GoE_ARCHIVE_IS_MODIFIED);
        errorMap.put("0xFFFF1041", RtdbError.GoE_ACTIVE_ARCHIVE_FULL);
        errorMap.put("0xFFFF1042", RtdbError.GoE_SPLIT_NO_DATA);
        errorMap.put("0xFFFF1043", RtdbError.GoE_INVALID_DIRECTORY);
        errorMap.put("0xFFFF1044", RtdbError.GoE_ARCHIVE_LACK_EX_FILES);
        errorMap.put("0xFFFF1045", RtdbError.GoE_BIG_JOB_IS_CANCELED);
        errorMap.put("0xFFFF1046", RtdbError.GoE_ARVEX_BLOB_PAGE_NOT_READY);
        errorMap.put("0xFFFF1047", RtdbError.GoE_INVALID_ARVEX_BLOB_PAGE_ALLOCATE);
        errorMap.put("0xFFFF1048", RtdbError.GoE_TIMESTAMP_EQUALTO_SNAPSHOT);
        errorMap.put("0xFFFF1049", RtdbError.GoE_TIMESTAMP_NOT_GREATER_THAN_SNAPSHOT);
        errorMap.put("0xFFFF104A", RtdbError.GoE_TIMESTAMP_GREATER_THAN_ALLOW);
        errorMap.put("0xFFFF104B", RtdbError.GoE_TIMESTAMP_BEGINTIME_GREAGER_THAN_ENDTIME);
        errorMap.put("0xFFFF104C", RtdbError.GoE_TIMESTAMP_BEGINTIME_EQUALTO_ENDTIME);
        errorMap.put("0xFFFF104D", RtdbError.GoE_INVALID_COUNT);
        errorMap.put("0xFFFF104E", RtdbError.GoE_INVALID_CAPACITY);
        errorMap.put("0xFFFF104F", RtdbError.GoE_INVALID_PATH);
        errorMap.put("0xFFFF1050", RtdbError.GoE_INVALID_POSITION);
        errorMap.put("0xFFFF1051", RtdbError.GoE_INVALID_ARV_PAGE);
        errorMap.put("0xFFFF1053", RtdbError.GoE_INVALID_INTERVAL);
        errorMap.put("0xFFFF1054", RtdbError.GoE_INVALID_LENGTH);
        errorMap.put("0xFFFF1055", RtdbError.GoE_INVALID_SERACH_MODE);
        errorMap.put("0xFFFF1056", RtdbError.GoE_INVALID_FILE_ID);
        errorMap.put("0xFFFF1057", RtdbError.GoE_INVALID_MILLISECOND);
        errorMap.put("0xFFFF1058", RtdbError.GoE_INVALID_DEADLINE);
        errorMap.put("0xFFFF1059", RtdbError.GoE_INVALID_JOBNAME);
        errorMap.put("0xFFFF105A", RtdbError.GoE_INVALID_JOBSTATE);
        errorMap.put("0xFFFF105B", RtdbError.GoE_INVALID_PROCESS_RATE);
        errorMap.put("0xFFFF105C", RtdbError.GoE_INVALID_TABLE_ID);
        errorMap.put("0xFFFF105D", RtdbError.GoE_INVALID_DATA_SOURCE);
        errorMap.put("0xFFFF105E", RtdbError.GoE_INVALID_TRIGGER_METHOD);
        errorMap.put("0xFFFF105F", RtdbError.GoE_INVALID_CALC_TIME_RES);
        errorMap.put("0xFFFF1060", RtdbError.GoE_INVALID_TRIGGER_TIMER);
        errorMap.put("0xFFFF1061", RtdbError.GoE_INVALID_LIMIT);
        errorMap.put("0xFFFF1062", RtdbError.GoE_INVALID_COMP_TIME);
        errorMap.put("0xFFFF1063", RtdbError.GoE_INVALID_EXT_TIME);
        errorMap.put("0xFFFF1064", RtdbError.GoE_INVALID_DIGITS);
        errorMap.put("0xFFFF1065", RtdbError.GoE_INVALID_FULL_TAG_NAME);
        errorMap.put("0xFFFF1066", RtdbError.GoE_INVALID_TABLE_DESC);
        errorMap.put("0xFFFF1067", RtdbError.GoE_INVALID_USER_COUNT);
        errorMap.put("0xFFFF1068", RtdbError.GoE_INVALID_BLACKLIST_COUNT);
        errorMap.put("0xFFFF1069", RtdbError.GoE_INVALID_AUTHORIZATION_COUNT);
        errorMap.put("0xFFFF106A", RtdbError.GoE_INVALID_BIG_JOB_TYPE);
        errorMap.put("0xFFFF106B", RtdbError.GoE_INVALID_SYS_PARAM);
        errorMap.put("0xFFFF106C", RtdbError.GoE_INVALID_FILE_PARAM);
        errorMap.put("0xFFFF106D", RtdbError.GoE_INVALID_FILE_SIZE);
        errorMap.put("0xFFFF106E", RtdbError.GoE_INVALID_TAG_TYPE);
        errorMap.put("0xFFFF106F", RtdbError.GoE_INVALID_RECY_STRUCT_POS);
        errorMap.put("0xFFFF1070", RtdbError.GoE_INVALID_RECYCLE_FILE);
        errorMap.put("0xFFFF1071", RtdbError.GoE_INVALID_SUFFIX_NAME);
        errorMap.put("0xFFFF1072", RtdbError.GoE_INSERT_STRING_FALSE);
        errorMap.put("0xFFFF1073", RtdbError.GoE_BLOB_PAGE_FULL);
        errorMap.put("0xFFFF1074", RtdbError.GoE_INVALID_STRING_ITERATOR_POINTER);
        errorMap.put("0xFFFF1075", RtdbError.GoE_NOT_EQUAL_TAGID);
        errorMap.put("0xFFFF1076", RtdbError.GoE_PATHS_OF_ARCHIVE_AND_AUTOBACK_ARE_SAME);
        errorMap.put("0xFFFF1077", RtdbError.GoE_XML_PARSE_FAIL);
        errorMap.put("0xFFFF1078", RtdbError.GoE_XML_ELEMENTS_ABSENT);
        errorMap.put("0xFFFF1079", RtdbError.GoE_XML_MISMATCH_ON_NAME);
        errorMap.put("0xFFFF107A", RtdbError.GoE_XML_MISMATCH_ON_VERSION);
        errorMap.put("0xFFFF107B", RtdbError.GoE_XML_MISMATCH_ON_DATASIZE);
        errorMap.put("0xFFFF107C", RtdbError.GoE_XML_MISMATCH_ON_FILEINFO);
        errorMap.put("0xFFFF107D", RtdbError.GoE_XML_MISMATCH_ON_WINDOW);
        errorMap.put("0xFFFF107F", RtdbError.GoE_XML_MISMATCH_ON_TYPECOUNT);
        errorMap.put("0xFFFF1080", RtdbError.GoE_XML_MISMATCH_ON_FIELDCOUNT);
        errorMap.put("0xFFFF1081", RtdbError.GoE_XML_FIELD_MUST_IN_TYPE);
        errorMap.put("0xFFFF1082", RtdbError.GoE_INVALID_NAMED_TYPE_FIELD_COUNT);
        errorMap.put("0xFFFF1083", RtdbError.GoE_REDUPLICATE_FIELD_NAME);
        errorMap.put("0xFFFF1084", RtdbError.GoE_INVALID_NAMED_TYPE_NAME);
        errorMap.put("0xFFFF1085", RtdbError.GoE_REDUPLICATE_NAMED_TYPE);
        errorMap.put("0xFFFF1086", RtdbError.GoE_NOT_EXIST_NAMED_TYPE);
        errorMap.put("0xFFFF1087", RtdbError.GoE_UPDATE_XML_FAILED);
        errorMap.put("0xFFFF1088", RtdbError.GoE_NAMED_TYPE_USED_WITH_POINT);
        errorMap.put("0xFFFF1089", RtdbError.GoE_NAMED_TYPE_UNSUPPORT_CALC_POINT);
        errorMap.put("0xFFFF1090", RtdbError.GoE_XML_MISMATCH_ON_MAX_ID);
        errorMap.put("0xFFFF1091", RtdbError.GoE_NAMED_TYPE_LICENSE_FULL);
        errorMap.put("0xFFFF1092", RtdbError.GoE_NO_FREE_NAMED_TYPE_ID);
        errorMap.put("0xFFFF1093", RtdbError.GoE_INVALID_NAMED_TYPE_ID);
        errorMap.put("0xFFFF1094", RtdbError.GoE_INVALID_NAMED_TYPE_FIELD_NAME);
        errorMap.put("0xFFFF1095", RtdbError.GoE_NAMED_TYPE_USED_WITH_RECYCLE_POINT);
        errorMap.put("0xFFFF1096", RtdbError.GoE_NAMED_TYPE_NAME_TOO_LONG);
        errorMap.put("0xFFFF1097", RtdbError.GoE_NAMED_TYPE_FIELD_NAME_TOO_LONG);
        errorMap.put("0xFFFF1098", RtdbError.GoE_INVALID_NAMED_TYPE_FIELD_LENGTH);
        errorMap.put("0xFFFF1099", RtdbError.GoE_INVALID_SEARCH_MASK);
        errorMap.put("0xFFFF109A", RtdbError.GoE_RECYCLED_SPACE_NOT_ENOUGH);
        errorMap.put("0xFFFF109B", RtdbError.GoE_DYNAMIC_LOADED_MEMORY_NOT_INIT);
        errorMap.put("0xFFFF109C", RtdbError.GoE_CANT_LOAD_MEMORYDB);
        errorMap.put("0xFFFF109D", RtdbError.GoE_QUERY_IN_WHITEDB);
        errorMap.put("0xFFFF109E", RtdbError.GoE_NO_DATABASE_MEMORYDB);
        errorMap.put("0xFFFF109F", RtdbError.GoE_RECORD_NOT_GET);
        errorMap.put("0xFFFF10a0", RtdbError.GoE_MEMORY_ALLOC_ERR);
        errorMap.put("0xFFFF10a1", RtdbError.GoE_EVENT_CREATE_FAILED);
        errorMap.put("0xFFFF10a2", RtdbError.GoE_GET_POINT_FAILED);
        errorMap.put("0xFFFF10a3", RtdbError.GoE_MEMORY_INIT_FAILED);
        errorMap.put("0xFFFF10a4", RtdbError.GoE_DATATYPE_NOT_MATCH);
        errorMap.put("0xFFFF10a5", RtdbError.GoE_GET_FIELD_ERR);
        errorMap.put("0xFFFF10a6", RtdbError.GoE_MEMORYDB_INTERNAL_ERR);
        errorMap.put("0xFFFF10a7", RtdbError.GoE_MEMORYDB_RECORD_CREATED_FAILED);
        errorMap.put("0xFFFF10a8", RtdbError.GoE_PARSE_NORMAL_TYPE_SNAPSHOT_ERR);
        errorMap.put("0xFFFF10a9", RtdbError.GoE_PARSE_NAMED_TYPE_SNAPSHOT_ERR);
        errorMap.put("0xFFFF10AA", RtdbError.GoE_STRING_BLOB_TYPE_UNSUPPORT_CALC_POINT);
        errorMap.put("0xFFFF10AB", RtdbError.GoE_COOR_TYPE_UNSUPPORT_CALC_POINT);
        errorMap.put("0xFFFF2001", RtdbError.GoE_PROTOCOLNOTIMPL);
        errorMap.put("0xFFFF2002", RtdbError.GoE_CRCERROR);
        errorMap.put("0xFFFF2003", RtdbError.GoE_WRONG_USERPW);
        errorMap.put("0xFFFF2004", RtdbError.GoE_CHANGE_USERPW);
        errorMap.put("0xFFFF2005", RtdbError.GoE_INVALID_HANDLE);
        errorMap.put("0xFFFF2006", RtdbError.GoE_INVALID_SOCKET_HANDLE);
        errorMap.put("0xFFFF2007", RtdbError.GoE_FALSE);
        errorMap.put("0xFFFF2008", RtdbError.GoE_SCAN_POINT_NOT_FOUND);
        errorMap.put("0xFFFF2009", RtdbError.GoE_CALC_POINT_NOT_FOUND);
        errorMap.put("0xFFFF200A", RtdbError.GoE_REDUPLICATE_ID);
        errorMap.put("0xFFFF200B", RtdbError.GoE_HANDLE_SUBSCRIBED);
        errorMap.put("0xFFFF200C", RtdbError.GoE_OTHER_SDK_DOING);
        errorMap.put("0xFFFF200D", RtdbError.GoE_BATCH_END);
        errorMap.put("0xFFFF200E", RtdbError.GoE_AUTH_NOT_FOUND);
        errorMap.put("0xFFFF200F", RtdbError.GoE_AUTH_EXIST);
        errorMap.put("0xFFFF2010", RtdbError.GoE_AUTH_FULL);
        errorMap.put("0xFFFF2011", RtdbError.GoE_USER_FULL);
        errorMap.put("0xFFFF2012", RtdbError.GoE_VERSION_UNMATCH);
        errorMap.put("0xFFFF2013", RtdbError.GoE_INVALID_PRIV);
        errorMap.put("0xFFFF2014", RtdbError.GoE_INVALID_MASK);
        errorMap.put("0xFFFF2015", RtdbError.GoE_INVALID_USERNAME);
        errorMap.put("0xFFFF2016", RtdbError.GoE_INVALID_MARK);
        errorMap.put("0xFFFF2017", RtdbError.GoE_UNEXPECTED_METHOD);
        errorMap.put("0xFFFF2018", RtdbError.GoE_INVALID_PARAM_INDEX);
        errorMap.put("0xFFFF2019", RtdbError.GoE_DECODE_PACKET_ERROR);
        errorMap.put("0xFFFF201A", RtdbError.GoE_ENCODE_PACKET_ERROR);
        errorMap.put("0xFFFF201B", RtdbError.GoE_BLACKLIST_FULL);
        errorMap.put("0xFFFF201C", RtdbError.GoE_BLACKLIST_EXIST);
        errorMap.put("0xFFFF201D", RtdbError.GoE_BLACKLIST_NOT_FOUND);
        errorMap.put("0xFFFF201E", RtdbError.GoE_IN_BLACKLIST);
        errorMap.put("0xFFFF201F", RtdbError.GoE_INCREASE_FILE_FAILED);
        errorMap.put("0xFFFF2020", RtdbError.GoE_RPC_INTERFACE_FAILED);
        errorMap.put("0xFFFF2021", RtdbError.GoE_CONNECTION_FULL);
        errorMap.put("0xFFFF2022", RtdbError.GoE_ONE_CLIENT_CONNECTION_FULL);
        errorMap.put("0xFFFF2023", RtdbError.GoE_SERVER_CLUTTER_POOL_NOT_ENOUGH);
        errorMap.put("0xFFFF2024", RtdbError.GoE_EQUATION_CLUTTER_POOL_NOT_ENOUGH);
        errorMap.put("0xFFFF2025", RtdbError.GoE_NAMED_TYPE_NAME_LEN_ERROR);
        errorMap.put("0xFFFF2026", RtdbError.GoE_NAMED_TYPE_LENGTH_NOT_MATCH);
        errorMap.put("0xFFFF7000", RtdbError.GoE_NET_ERROR);
        errorMap.put("0xFFFF7004", RtdbError.GoE_SOCK_WSAEINTR);
        errorMap.put("0xFFFF700D", RtdbError.GoE_SOCK_WSAEACCES);
        errorMap.put("0xFFFF700E", RtdbError.GoE_SOCK_WSAEFAULT);
        errorMap.put("0xFFFF7018", RtdbError.GoE_SOCK_WSAEMFILE);
        errorMap.put("0xFFFF7023", RtdbError.GoE_SOCK_WSAEWOULDBLOCK);
        errorMap.put("0xFFFF7024", RtdbError.GoE_SOCK_WSAEINPROGRESS);
        errorMap.put("0xFFFF7025", RtdbError.GoE_SOCK_WSAEALREADY);
        errorMap.put("0xFFFF7026", RtdbError.GoE_SOCK_WSAENOTSOCK);
        errorMap.put("0xFFFF7027", RtdbError.GoE_SOCK_WSAEDESTADDRREQ);
        errorMap.put("0xFFFF7028", RtdbError.GoE_SOCK_WSAEMSGSIZE);
        errorMap.put("0xFFFF7029", RtdbError.GoE_SOCK_WSAEPROTOTYPE);
        errorMap.put("0xFFFF702B", RtdbError.GoE_SOCK_WSAEPROTONOSUPPORT);
        errorMap.put("0xFFFF702C", RtdbError.GoE_SOCK_WSAESOCKTNOSUPPORT);
        errorMap.put("0xFFFF702D", RtdbError.GoE_SOCK_WSAEOPNOTSUPP);
        errorMap.put("0xFFFF702F", RtdbError.GoE_SOCK_WSAEAFNOSUPPORT);
        errorMap.put("0xFFFF7030", RtdbError.GoE_SOCK_WSAEADDRINUSE);
        errorMap.put("0xFFFF7031", RtdbError.GoE_SOCK_WSAEADDRNOTAVAIL);
        errorMap.put("0xFFFF7032", RtdbError.GoE_SOCK_WSAENETDOWN);
        errorMap.put("0xFFFF7033", RtdbError.GoE_SOCK_WSAENETUNREACH);
        errorMap.put("0xFFFF7034", RtdbError.GoE_SOCK_WSAENETRESET);
        errorMap.put("0xFFFF7035", RtdbError.GoE_SOCK_WSAECONNABORTED);
        errorMap.put("0xFFFF7036", RtdbError.GoE_SOCK_WSAECONNRESET);
        errorMap.put("0xFFFF7037", RtdbError.GoE_SOCK_WSAENOBUFS);
        errorMap.put("0xFFFF7038", RtdbError.GoE_SOCK_WSAEISCONN);
        errorMap.put("0xFFFF7039", RtdbError.GoE_SOCK_WSAENOTCONN);
        errorMap.put("0xFFFF703A", RtdbError.GoE_SOCK_WSAESHUTDOWN);
        errorMap.put("0xFFFF703C", RtdbError.GoE_SOCK_WSAETIMEDOUT);
        errorMap.put("0xFFFF703D", RtdbError.GoE_SOCK_WSAECONNREFUSED);
        errorMap.put("0xFFFF703E", RtdbError.GoE_SOCK_WSAECLOSE);
        errorMap.put("0xFFFF705D", RtdbError.GoE_SOCK_WSANOTINITIALISED);
        errorMap.put("0xFFFF8000", RtdbError.GoE_C_ERRNO_ERROR);
    }
}

