/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.api.impl;

import com.rtdb.api.common.RtdbErrorParse;
import com.rtdb.api.enums.RTDBClass;
import com.rtdb.api.enums.RtdbError;
import com.rtdb.api.enums.RtdbGlobalEnum;
import com.rtdb.api.enums.RtdbMsgID;
import com.rtdb.api.enums.RtdbNumType;
import com.rtdb.api.enums.RtdbPrivGroup;
import com.rtdb.api.enums.RtdbType;
import com.rtdb.api.exception.DataTypeNotMatchException;
import com.rtdb.api.inter.IServer;
import com.rtdb.api.model.JobField;
import com.rtdb.api.model.Login;
import com.rtdb.api.model.NamedDataTypeField;
import com.rtdb.api.model.RtdbBasePoint;
import com.rtdb.api.model.RtdbCalcPoint;
import com.rtdb.api.model.RtdbField;
import com.rtdb.api.model.RtdbScanPoint;
import com.rtdb.api.util.DataTypeUtil;
import com.rtdb.api.util.DateUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Rtdb {
    private static Map<String, JobField> mapJobField = new HashMap<String, JobField>(270);
    protected Object object_lock = new Object();

    protected RtdbError getRet(List<RtdbField> returnFields) {
        long longRet = returnFields.get(RtdbGlobalEnum.FIELD_RET.getNum()).getIvalue();
        RtdbError ret = RtdbErrorParse.getRtdbError(longRet);
        return ret;
    }

    protected int getCount(List<RtdbField> returnFields) {
        int count = (int)returnFields.get(RtdbGlobalEnum.FIELD_CNT.getNum()).getIvalue();
        return count;
    }

    protected List<RtdbField> msgCommonFields(RtdbMsgID msgCommon, int subver) {
        List<RtdbField> wFields = this.getMsgHeader2(msgCommon, subver, 0, 0, 1, 0);
        wFields.add(this.getMsgTail());
        return wFields;
    }

    protected List<RtdbField> msgCommonRespFields(RtdbMsgID method, int subver, int ret) {
        List<RtdbField> fields = this.getMsgHeader2(method, subver, ret, 0, 1, 1);
        fields.add(this.getMsgTail());
        return fields;
    }

    protected List<RtdbField> msgCommonRespFields1(RtdbMsgID method, int subver, int ret) {
        List<RtdbField> list = this.getMsgHeader(method, subver, ret, 0, 1);
        list.add(this.getMsgTail());
        return list;
    }

    protected void msgAddString(List<RtdbField> list, String value, String lenName, String name) throws UnsupportedEncodingException {
        list.add(new RtdbField(2, value.getBytes("GBK").length + 1, 0.0, null, 1, lenName));
        list.add(new RtdbField(0, 0L, 0.0, value, -1, name));
    }

    protected void msgAddString(List<RtdbField> list, String value, int length, String name) {
        list.add(new RtdbField(0, 0L, 0.0, value, length, name));
    }

    protected void msgAddBoolean(List<RtdbField> list, boolean value, String name) {
        list.add(new RtdbField(1, value ? 1L : 0L, 0.0, null, 1, name));
    }

    protected void msgAddShort(List<RtdbField> list, short value, String name) {
        list.add(new RtdbField(2, value, 0.0, null, 1, name));
    }

    protected void msgAddInt(List<RtdbField> list, int value, String name) {
        list.add(new RtdbField(3, value, 0.0, null, 1, name));
    }

    protected void msgAddLong(List<RtdbField> list, long value, String name) {
        list.add(new RtdbField(4, value, 0.0, null, 1, name));
    }

    protected void msgAddFloat(List<RtdbField> list, float value, String name) {
        list.add(new RtdbField(5, 0L, value, null, 1, name));
    }

    protected void msgAddDouble(List<RtdbField> list, double value, String name) {
        list.add(new RtdbField(6, 0L, value, null, 1, name));
    }

    protected void msgAddEmptyPointer(List<RtdbField> list, int type, String name) {
        list.add(new RtdbField(type, 0L, 0.0, -1431655766, 1, name));
    }

    protected void msgAddEmptyPointer(List<RtdbField> list, int type, int length, String name) {
        list.add(new RtdbField(type, 0L, 0.0, -1431655766, length, name));
    }

    protected void msgAddEmptyString(List<RtdbField> list, String lenName, String name) {
        list.add(new RtdbField(2, 1L, 0.0, null, 1, lenName));
        list.add(new RtdbField(0, 0L, 0.0, -1431655766, -1, name));
    }

    protected void msgAddBytes(List<RtdbField> list, byte[] array, String lenName, String name) {
        list.add(new RtdbField(1, 0L, 0.0, array, array != null ? array.length : 0, name));
    }

    protected void msgAddBytes1(List<RtdbField> list, byte[] array, String lenName, String name) {
        list.add(new RtdbField(2, array.length, 0.0, null, 1, lenName));
        list.add(new RtdbField(1, 0L, 0.0, array, -1, name));
    }

    protected void msgAddBytesLong(List<RtdbField> list, byte[] array, String lenName, String name) {
        list.add(new RtdbField(3, array.length, 0.0, null, 1, lenName));
        list.add(new RtdbField(1, 0L, 0.0, array, -1, name));
    }

    protected void msgAddByteArray(List<RtdbField> list, byte[] array, String name) {
        list.add(new RtdbField(1, 0L, 0.0, array, -1, name));
    }

    protected void msgAddShortArray(List<RtdbField> list, short[] array, String name) {
        list.add(new RtdbField(2, 0L, 0.0, array, 1, name));
    }

    protected void msgAddIntArray(List<RtdbField> list, int[] array, String name) {
        list.add(new RtdbField(3, 0L, 0.0, array, 1, name));
    }

    protected void msgAddLongArray(List<RtdbField> list, long[] array, String name) {
        list.add(new RtdbField(4, 0L, 0.0, array, 1, name));
    }

    protected void msgAddFloatArray(List<RtdbField> list, float[] array, String name) {
        list.add(new RtdbField(5, 0L, 0.0, array, 1, name));
    }

    protected void msgAddDoubleArray(List<RtdbField> list, double[] array, String name) {
        list.add(new RtdbField(6, 0L, 0.0, array, 1, name));
    }

    protected void msgAddStringArray(List<RtdbField> list, String[] array, String lenName, String name) throws UnsupportedEncodingException {
        short[] lens = new short[array.length];
        if (array[0] != null) {
            for (int i = 0; i < array.length; ++i) {
                lens[i] = (short)((short)array[i].getBytes("GBK").length + 1);
            }
        }
        list.add(new RtdbField(2, 0L, 0.0, lens, 1, lenName));
        list.add(new RtdbField(0, 0L, 0.0, array, -3, name));
    }

    protected void msgAddStringArrayFixedLength(List<RtdbField> list, String[] array, int length, String name) {
        list.add(new RtdbField(0, 0L, 0.0, array, length, name));
    }

    protected void msgAddBytesArray(List<RtdbField> list, byte[][] array, String lenName, String name) {
        short[] lens = new short[array.length];
        if (array[0] != null) {
            for (int i = 0; i < array.length; ++i) {
                lens[i] = (short)array[i].length;
            }
        }
        list.add(new RtdbField(2, 0L, 0.0, lens, 1, lenName));
        list.add(new RtdbField(1, 0L, 0.0, array, -3, name));
    }

    protected void msgAddBasePointI(List<RtdbField> list, RtdbBasePoint base, boolean onsend) {
        int value = 0;
        if (onsend) {
            value = -4;
        }
        list.add(new RtdbField(7, value, 0.0, base, 1, "base"));
    }

    protected void msgAddBasePointI(List<RtdbField> list, RtdbBasePoint[] base, boolean onsend) {
        int value = 0;
        if (onsend) {
            value = -4;
        }
        list.add(new RtdbField(7, value, 0.0, base, 1, "base"));
    }

    protected void msgAddBasePointG(List<RtdbField> list, RtdbBasePoint base, boolean onsend) {
        int value = 0;
        if (onsend) {
            value = -4;
        }
        list.add(new RtdbField(9, value, 0.0, base, 1, "base"));
    }

    protected void msgAddBasePointG(List<RtdbField> list, RtdbBasePoint[] base, boolean onsend) {
        int value = 0;
        if (onsend) {
            value = -4;
        }
        list.add(new RtdbField(9, value, 0.0, base, 1, "base"));
    }

    protected void msgAddBasePointU(List<RtdbField> list, RtdbBasePoint base, boolean onsend) {
        int value = 0;
        if (onsend) {
            value = -4;
        }
        list.add(new RtdbField(8, value, 0.0, base, 1, "base"));
    }

    protected void msgAddBasePointU(List<RtdbField> list, RtdbBasePoint[] base, boolean onsend) {
        int value = 0;
        if (onsend) {
            value = -4;
        }
        list.add(new RtdbField(8, value, 0.0, base, 1, "base"));
    }

    protected void msgAddScanPoint(List<RtdbField> list, RtdbScanPoint scan, boolean onsend) {
        int value = 0;
        if (onsend) {
            value = -4;
        }
        if (scan == null) {
            list.add(new RtdbField(10, value, 0.0, -1431655766, 1, "scan"));
        } else {
            list.add(new RtdbField(10, value, 0.0, scan, 1, "scan"));
        }
    }

    protected void msgAddScanPoint(List<RtdbField> list, RtdbScanPoint[] scan, boolean onsend) {
        int value = 0;
        if (onsend) {
            value = -4;
        }
        if (scan == null) {
            list.add(new RtdbField(10, value, 0.0, -1431655766, 1, "scan"));
        } else {
            list.add(new RtdbField(10, value, 0.0, scan, 1, "scan"));
        }
    }

    protected void msgAddCalcPoint(List<RtdbField> list, RtdbCalcPoint calc, boolean onsend) {
        int value = 0;
        if (onsend) {
            value = -4;
        }
        if (calc == null) {
            list.add(new RtdbField(10, value, 0.0, -1431655766, 1, "calc"));
        } else {
            list.add(new RtdbField(11, value, 0.0, calc, 1, "calc"));
        }
    }

    protected void msgAddCalcPoint(List<RtdbField> list, RtdbCalcPoint[] calc, boolean onsend) {
        int value = 0;
        if (onsend) {
            value = -4;
        }
        if (calc == null) {
            list.add(new RtdbField(10, value, 0.0, -1431655766, 1, "calc"));
        } else {
            list.add(new RtdbField(11, value, 0.0, calc, 1, "calc"));
        }
    }

    protected List<RtdbField> getMsgHeader(RtdbMsgID method, int subver, int ret, int cnt, int dim) {
        ArrayList list = new ArrayList(32);
        List<RtdbField> fields = Collections.synchronizedList(list);
        fields.add(new RtdbField(3, -1431655766L, 0.0, null, 1, "hmark"));
        fields.add(new RtdbField(3, method.getNum(), 0.0, null, 1, "method"));
        fields.add(new RtdbField(3, 0L, 0.0, null, 1, "bsize"));
        fields.add(new RtdbField(3, DataTypeUtil.makeLong(3, subver), 0.0, null, 1, "ver"));
        fields.add(new RtdbField(3, ret, 0.0, null, 1, "ret"));
        fields.add(new RtdbField(3, 1445581701L, 0.0, null, 1, "stamp"));
        fields.add(new RtdbField(3, cnt, 0.0, null, 1, "cnt"));
        fields.add(new RtdbField(3, dim, 0.0, null, 1, "dim"));
        fields.add(new RtdbField(4, 0L, 0.0, null, 1, "int1"));
        fields.add(new RtdbField(4, 0L, 0.0, null, 1, "int2"));
        fields.add(new RtdbField(4, 0L, 0.0, null, 1, "int3"));
        fields.add(new RtdbField(4, 0L, 0.0, null, 1, "int4"));
        fields.add(new RtdbField(6, 0L, 0.0, null, 1, "real1"));
        fields.add(new RtdbField(6, 0L, 0.0, null, 1, "real2"));
        fields.add(new RtdbField(3, 0L, 0.0, null, 1, "hcrc"));
        fields.add(new RtdbField(3, -858993460L, 0.0, null, 1, "bmark"));
        return fields;
    }

    protected List<RtdbField> getMsgHeader2(RtdbMsgID method, int subver, int ret, int cnt, int dim, int bsize) {
        ArrayList list = new ArrayList(32);
        List<RtdbField> fields = Collections.synchronizedList(list);
        fields.add(new RtdbField(3, -1431655766L, 0.0, null, 1, "hmark"));
        fields.add(new RtdbField(3, method.getNum(), 0.0, null, 1, "method"));
        fields.add(new RtdbField(3, 0L, 0.0, null, bsize, "bsize"));
        fields.add(new RtdbField(3, DataTypeUtil.makeLong(3, subver), 0.0, null, 1, "ver"));
        fields.add(new RtdbField(3, ret, 0.0, null, 1, "ret"));
        fields.add(new RtdbField(3, 1445581701L, 0.0, null, 1, "stamp"));
        fields.add(new RtdbField(3, cnt, 0.0, null, 1, "cnt"));
        fields.add(new RtdbField(3, dim, 0.0, null, 1, "dim"));
        fields.add(new RtdbField(4, 0L, 0.0, null, 1, "int1"));
        fields.add(new RtdbField(4, 0L, 0.0, null, 1, "int2"));
        fields.add(new RtdbField(4, 0L, 0.0, null, 1, "int3"));
        fields.add(new RtdbField(4, 0L, 0.0, null, 1, "int4"));
        fields.add(new RtdbField(6, 0L, 0.0, null, 1, "real1"));
        fields.add(new RtdbField(6, 0L, 0.0, null, 1, "real2"));
        fields.add(new RtdbField(3, 0L, 0.0, null, 1, "hcrc"));
        fields.add(new RtdbField(3, -858993460L, 0.0, null, 1, "bmark"));
        return fields;
    }

    protected RtdbField getMsgTail() {
        return new RtdbField(3, 0L, 0.0, null, 1, "bcrc");
    }

    protected List<RtdbField> baseUSegmentFields(RtdbBasePoint base) throws UnsupportedEncodingException {
        ArrayList list1 = new ArrayList(32);
        List<RtdbField> list = Collections.synchronizedList(list1);
        if (base != null) {
            this.msgAddString(list, base.getTag(), "len1", "tag");
            this.msgAddInt(list, base.getId(), "id");
            this.msgAddString(list, base.getDesc(), "len2", "desc");
            this.msgAddString(list, base.getUnit(), "len3", "unit");
            this.msgAddBoolean(list, base.getArchive(), "archive");
            this.msgAddShort(list, base.getDigits(), "digits");
            this.msgAddBoolean(list, base.getShutdown(), "shutdown");
            this.msgAddFloat(list, (float)base.getLowlimit(), "low");
            this.msgAddFloat(list, (float)base.getHighlimit(), "high");
            this.msgAddBoolean(list, base.getStep(), "step");
            this.msgAddFloat(list, (float)base.getTypical(), "typical");
            this.msgAddBoolean(list, base.getCompress(), "compress");
            this.msgAddFloat(list, (float)base.getCompdev(), "compdev");
            this.msgAddFloat(list, (float)base.getCompdevpercent(), "compdevpercent");
            this.msgAddInt(list, base.getComptimemax(), "compmax");
            this.msgAddInt(list, base.getComptimemin(), "compmin");
            this.msgAddFloat(list, (float)base.getExcdev(), "excdev");
            this.msgAddFloat(list, (float)base.getExcdevpercent(), "excdevpercent");
            this.msgAddInt(list, base.getExctimemax(), "excmax");
            this.msgAddInt(list, base.getExctimemin(), "excmin");
            this.msgAddInt(list, base.getClassof().getNum(), "classof");
            this.msgAddBoolean(list, base.getMirror(), "mirror");
            this.msgAddBoolean(list, base.getSummary(), "summary");
        } else {
            this.msgAddEmptyString(list, "len1", "tag");
            this.msgAddEmptyPointer(list, 3, "id");
            this.msgAddEmptyString(list, "len2", "desc");
            this.msgAddEmptyString(list, "len3", "unit");
            this.msgAddEmptyPointer(list, 1, "archive");
            this.msgAddEmptyPointer(list, 2, "digits");
            this.msgAddEmptyPointer(list, 1, "shutdown");
            this.msgAddEmptyPointer(list, 5, "low");
            this.msgAddEmptyPointer(list, 5, "high");
            this.msgAddEmptyPointer(list, 1, "step");
            this.msgAddEmptyPointer(list, 5, "typical");
            this.msgAddEmptyPointer(list, 1, "compress");
            this.msgAddEmptyPointer(list, 5, "compdev");
            this.msgAddEmptyPointer(list, 5, "comdevpercent");
            this.msgAddEmptyPointer(list, 3, "compmax");
            this.msgAddEmptyPointer(list, 3, "compmin");
            this.msgAddEmptyPointer(list, 5, "excdev");
            this.msgAddEmptyPointer(list, 5, "excdevpercent");
            this.msgAddEmptyPointer(list, 3, "excmax");
            this.msgAddEmptyPointer(list, 3, "excmin");
            this.msgAddEmptyPointer(list, 3, "classof");
            this.msgAddEmptyPointer(list, 1, "mirror");
            this.msgAddEmptyPointer(list, 1, "summary");
        }
        return list;
    }

    protected void fieldsToBaseSegmentU(List<RtdbField> fields, RtdbBasePoint base) {
        if (base == null) {
            return;
        }
        int index = 1;
        base.setTag((String)fields.get(index).getData());
        base.setId((int)fields.get(++index).getIvalue());
        base.setDesc((String)fields.get(index += 2).getData());
        base.setUnit((String)fields.get(index += 2).getData());
        base.setArchive(fields.get(++index).getIvalue() != 0L);
        base.setDigits((short)fields.get(++index).getIvalue());
        base.setShutdown(fields.get(++index).getIvalue() != 0L);
        base.setLowlimit((float)fields.get(++index).getFvalue());
        base.setHighlimit((float)fields.get(++index).getFvalue());
        base.setStep((byte)fields.get(++index).getIvalue() != 0);
        base.setTypical(fields.get(++index).getFvalue());
        base.setCompress((byte)fields.get(++index).getIvalue() != 0);
        base.setCompdev(fields.get(++index).getFvalue());
        base.setCompdevpercent(fields.get(++index).getFvalue());
        base.setComptimemax((int)fields.get(++index).getIvalue());
        base.setComptimemin((int)fields.get(++index).getIvalue());
        base.setExcdev(fields.get(++index).getFvalue());
        base.setExcdevpercent(fields.get(++index).getFvalue());
        base.setExctimemax((int)fields.get(++index).getIvalue());
        base.setExctimemin((int)fields.get(++index).getIvalue());
        base.setClassof(RTDBClass.parse((int)fields.get(++index).getIvalue()));
        base.setMirror((byte)fields.get(++index).getIvalue() != 0);
        base.setSummary(fields.get(++index).getIvalue() != 0L);
    }

    protected List<RtdbField> baseISegmentFields(RtdbBasePoint base) throws UnsupportedEncodingException {
        ArrayList list1 = new ArrayList(32);
        List<RtdbField> list = Collections.synchronizedList(list1);
        if (base != null) {
            this.msgAddString(list, base.getTag(), "len1", "tag");
            this.msgAddInt(list, base.getType().getNum(), "type");
            this.msgAddInt(list, base.getTable(), "tabid");
            this.msgAddString(list, base.getDesc(), "len2", "desc");
            this.msgAddString(list, base.getUnit(), "len3", "unit");
            this.msgAddBoolean(list, base.getArchive(), "archive");
            this.msgAddShort(list, base.getDigits(), "digits");
            this.msgAddBoolean(list, base.getShutdown(), "shutdown");
            this.msgAddFloat(list, (float)base.getLowlimit(), "low");
            this.msgAddFloat(list, (float)base.getHighlimit(), "high");
            this.msgAddBoolean(list, base.getStep(), "step");
            this.msgAddFloat(list, (float)base.getTypical(), "typical");
            this.msgAddBoolean(list, base.getCompress(), "compress");
            this.msgAddFloat(list, (float)base.getCompdev(), "compdev");
            this.msgAddFloat(list, (float)base.getCompdevpercent(), "compdevpercent");
            this.msgAddInt(list, base.getComptimemax(), "compmax");
            this.msgAddInt(list, base.getComptimemin(), "compmin");
            this.msgAddFloat(list, (float)base.getExcdev(), "excdev");
            this.msgAddFloat(list, (float)base.getExcdevpercent(), "excdevpercent");
            this.msgAddInt(list, base.getExctimemax(), "excmax");
            this.msgAddInt(list, base.getExctimemin(), "excmin");
            this.msgAddInt(list, base.getClassof().getNum(), "classof");
            this.msgAddBoolean(list, base.getMirror(), "mirror");
            this.msgAddBoolean(list, base.getMicrosecond(), "ms");
            this.msgAddBoolean(list, base.getSummary(), "summary");
        } else {
            this.msgAddEmptyString(list, "len1", "tag");
            this.msgAddEmptyPointer(list, 3, "type");
            this.msgAddEmptyPointer(list, 3, "tabid");
            this.msgAddEmptyString(list, "len2", "desc");
            this.msgAddEmptyString(list, "len3", "unit");
            this.msgAddEmptyPointer(list, 1, "archive");
            this.msgAddEmptyPointer(list, 2, "digits");
            this.msgAddEmptyPointer(list, 1, "shutdown");
            this.msgAddEmptyPointer(list, 5, "low");
            this.msgAddEmptyPointer(list, 5, "high");
            this.msgAddEmptyPointer(list, 1, "step");
            this.msgAddEmptyPointer(list, 5, "typical");
            this.msgAddEmptyPointer(list, 1, "compress");
            this.msgAddEmptyPointer(list, 5, "compdev");
            this.msgAddEmptyPointer(list, 5, "comdevpercent");
            this.msgAddEmptyPointer(list, 3, "compmax");
            this.msgAddEmptyPointer(list, 3, "compmin");
            this.msgAddEmptyPointer(list, 5, "excdev");
            this.msgAddEmptyPointer(list, 5, "excdevpercent");
            this.msgAddEmptyPointer(list, 3, "excmax");
            this.msgAddEmptyPointer(list, 3, "excmin");
            this.msgAddEmptyPointer(list, 3, "classof");
            this.msgAddEmptyPointer(list, 1, "mirror");
            this.msgAddEmptyPointer(list, 1, "ms");
            this.msgAddEmptyPointer(list, 1, "summary");
        }
        return list;
    }

    protected void fieldsToBaseSegmentI(List<RtdbField> fields, RtdbBasePoint base) {
        if (base == null) {
            return;
        }
        int index = 1;
        base.setTag((String)fields.get(index).getData());
        base.setType(RtdbType.parse((int)fields.get(++index).getIvalue()));
        base.setTable((int)fields.get(++index).getIvalue());
        base.setDesc((String)fields.get(index += 2).getData());
        base.setUnit((String)fields.get(index += 2).getData());
        base.setArchive((byte)fields.get(++index).getIvalue() != 0);
        base.setDigits((short)fields.get(++index).getIvalue());
        base.setShutdown((byte)fields.get(++index).getIvalue() != 0);
        base.setLowlimit((float)fields.get(++index).getFvalue());
        base.setHighlimit((float)fields.get(++index).getFvalue());
        base.setStep((byte)fields.get(++index).getIvalue() != 0);
        base.setTypical(fields.get(++index).getFvalue());
        base.setCompress((byte)fields.get(++index).getIvalue() != 0);
        base.setCompdev(fields.get(++index).getFvalue());
        base.setCompdevpercent(fields.get(++index).getFvalue());
        base.setComptimemax((int)fields.get(++index).getIvalue());
        base.setComptimemin((int)fields.get(++index).getIvalue());
        base.setExcdev(fields.get(++index).getFvalue());
        base.setExcdevpercent(fields.get(++index).getFvalue());
        base.setExctimemax((int)fields.get(++index).getIvalue());
        base.setExctimemin((int)fields.get(++index).getIvalue());
        base.setClassof(RTDBClass.parse((int)fields.get(++index).getIvalue()));
        base.setMirror((byte)fields.get(++index).getIvalue() != 0);
        base.setMicrosecond((byte)fields.get(++index).getIvalue() != 0);
        base.setSummary(fields.get(++index).getIvalue() != 0L);
    }

    protected List<RtdbField> baseGSegmentFields(RtdbBasePoint base) throws UnsupportedEncodingException {
        ArrayList list1 = new ArrayList(36);
        List<RtdbField> list = Collections.synchronizedList(list1);
        if (base != null) {
            this.msgAddString(list, base.getTag(), "len1", "tag");
            this.msgAddInt(list, base.getId(), "id");
            this.msgAddInt(list, 0, "type");
            this.msgAddInt(list, base.getTable(), "tabid");
            this.msgAddString(list, base.getDesc(), "len2", "desc");
            this.msgAddString(list, base.getUnit(), "len3", "unit");
            this.msgAddBoolean(list, base.getArchive(), "archive");
            this.msgAddShort(list, base.getDigits(), "digits");
            this.msgAddBoolean(list, base.getShutdown(), "shutdown");
            this.msgAddFloat(list, (float)base.getLowlimit(), "low");
            this.msgAddFloat(list, (float)base.getHighlimit(), "high");
            this.msgAddBoolean(list, base.getStep(), "step");
            this.msgAddFloat(list, (float)base.getTypical(), "typical");
            this.msgAddBoolean(list, base.getCompress(), "compress");
            this.msgAddFloat(list, (float)base.getCompdev(), "compdev");
            this.msgAddFloat(list, (float)base.getCompdevpercent(), "compdevpercent");
            this.msgAddInt(list, base.getComptimemax(), "compmax");
            this.msgAddInt(list, base.getComptimemin(), "compmin");
            this.msgAddFloat(list, (float)base.getExcdev(), "excdev");
            this.msgAddFloat(list, (float)base.getExcdevpercent(), "excdevpercent");
            this.msgAddInt(list, base.getExctimemax(), "excmax");
            this.msgAddInt(list, base.getExctimemin(), "excmin");
            this.msgAddInt(list, base.getClassof() == null ? 0 : base.getClassof().getNum(), "classof");
            this.msgAddInt(list, 0, "changedate");
            this.msgAddString(list, base.getChanger(), "len4", "changer");
            this.msgAddInt(list, 0, "createdate");
            this.msgAddString(list, base.getCreator(), "len5", "creater");
            this.msgAddBoolean(list, base.getMirror(), "mirror");
            this.msgAddBoolean(list, base.getMicrosecond(), "ms");
            this.msgAddString(list, base.getTable_dot_tag(), "len6", "tab.tag");
            this.msgAddBoolean(list, base.getSummary(), "summary");
        } else {
            this.msgAddEmptyString(list, "len1", "tag");
            this.msgAddEmptyPointer(list, 3, "id");
            this.msgAddEmptyPointer(list, 3, "type");
            this.msgAddEmptyPointer(list, 3, "tabid");
            this.msgAddEmptyString(list, "len2", "desc");
            this.msgAddEmptyString(list, "len3", "unit");
            this.msgAddEmptyPointer(list, 1, "archive");
            this.msgAddEmptyPointer(list, 2, "digits");
            this.msgAddEmptyPointer(list, 1, "shutdown");
            this.msgAddEmptyPointer(list, 5, "low");
            this.msgAddEmptyPointer(list, 5, "high");
            this.msgAddEmptyPointer(list, 1, "step");
            this.msgAddEmptyPointer(list, 5, "typical");
            this.msgAddEmptyPointer(list, 1, "compress");
            this.msgAddEmptyPointer(list, 5, "compdev");
            this.msgAddEmptyPointer(list, 5, "comdevpercent");
            this.msgAddEmptyPointer(list, 3, "compmax");
            this.msgAddEmptyPointer(list, 3, "compmin");
            this.msgAddEmptyPointer(list, 5, "excdev");
            this.msgAddEmptyPointer(list, 5, "excdevpercent");
            this.msgAddEmptyPointer(list, 3, "excmax");
            this.msgAddEmptyPointer(list, 3, "excmin");
            this.msgAddEmptyPointer(list, 3, "classof");
            this.msgAddEmptyPointer(list, 3, "changedate");
            this.msgAddEmptyString(list, "len4", "changer");
            this.msgAddEmptyPointer(list, 3, "createdate");
            this.msgAddEmptyString(list, "len5", "creater");
            this.msgAddEmptyPointer(list, 1, "mirror");
            this.msgAddEmptyPointer(list, 1, "ms");
            this.msgAddEmptyString(list, "len6", "tab.tag");
            this.msgAddEmptyPointer(list, 1, "summary");
        }
        return list;
    }

    protected void fieldsToBaseSegmentG(List<RtdbField> fields, RtdbBasePoint base) {
        if (base == null) {
            return;
        }
        int index = 1;
        base.setTag((String)fields.get(index).getData());
        base.setId((int)fields.get(++index).getIvalue());
        base.setType(RtdbType.parse((int)fields.get(++index).getIvalue()));
        base.setTable((int)fields.get(++index).getIvalue());
        base.setDesc((String)fields.get(index += 2).getData());
        base.setUnit((String)fields.get(index += 2).getData());
        base.setArchive((byte)fields.get(++index).getIvalue() != 0);
        base.setDigits((short)fields.get(++index).getIvalue());
        base.setShutdown((byte)fields.get(++index).getIvalue() != 0);
        base.setLowlimit((float)fields.get(++index).getFvalue());
        base.setHighlimit((float)fields.get(++index).getFvalue());
        base.setStep((byte)fields.get(++index).getIvalue() != 0);
        base.setTypical(fields.get(++index).getFvalue());
        base.setCompress((byte)fields.get(++index).getIvalue() != 0);
        base.setCompdev(fields.get(++index).getFvalue());
        base.setCompdevpercent(fields.get(++index).getFvalue());
        base.setComptimemax((int)fields.get(++index).getIvalue());
        base.setComptimemin((int)fields.get(++index).getIvalue());
        base.setExcdev(fields.get(++index).getFvalue());
        base.setExcdevpercent(fields.get(++index).getFvalue());
        base.setExctimemax((int)fields.get(++index).getIvalue());
        base.setExctimemin((int)fields.get(++index).getIvalue());
        base.setClassof(RTDBClass.parse((int)fields.get(++index).getIvalue()));
        base.setChangedate(DateUtil.getDate((int)fields.get(++index).getIvalue(), 0));
        base.setChanger((String)fields.get(index += 2).getData());
        base.setCreatedate(DateUtil.getDate((int)fields.get(++index).getIvalue(), 0));
        base.setCreator((String)fields.get(index += 2).getData());
        base.setMirror((byte)fields.get(++index).getIvalue() != 0);
        base.setMicrosecond((byte)fields.get(++index).getIvalue() != 0);
        base.setSummary(fields.get(++index).getIvalue() != 0L);
    }

    protected static Map<String, JobField> initJobField() {
        return mapJobField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean apiPre(IServer server, RtdbMsgID method, Login login) throws Exception {
        Object object = this.object_lock;
        synchronized (object) {
            int loginPriv = login.getPriv();
            boolean satisfy = true;
            JobField jobField = Rtdb.initJobField().get(method.toString());
            int priv = jobField.getPriv();
            switch (priv) {
                case -1: {
                    satisfy = true;
                    break;
                }
                case 0: {
                    satisfy = loginPriv >= RtdbPrivGroup.RTDB_RO.getNum() && loginPriv <= RtdbPrivGroup.RTDB_SA.getNum();
                    break;
                }
                case 1: {
                    satisfy = loginPriv == RtdbPrivGroup.RTDB_DW.getNum() || loginPriv == RtdbPrivGroup.RTDB_SA.getNum();
                    break;
                }
                case 2: {
                    satisfy = loginPriv == RtdbPrivGroup.RTDB_TA.getNum() || loginPriv == RtdbPrivGroup.RTDB_SA.getNum();
                    break;
                }
                case 3: {
                    satisfy = loginPriv == RtdbPrivGroup.RTDB_SA.getNum();
                    break;
                }
                default: {
                    satisfy = false;
                }
            }
            if (!satisfy) {
                return satisfy;
            }
            if ((server.getMethod() == RtdbMsgID.MSG_SUBSCRIBE_SNAPSHOTS_CALLBACK && method != RtdbMsgID.MSG_CANCEL_SUBSCRIBE_SNAPSHOTS || server.getMethod() == RtdbMsgID.MSG_SUBSCRIBE_TAGS_CALLBACK && method != RtdbMsgID.MSG_CANCEL_SUBSCRIBE_TAGS || server.getMethod() == RtdbMsgID.MSG_SUBSCRIBE_NAMED_TYPE_CREATE_CALLBACK && method != RtdbMsgID.MSG_CANCEL_SUBSCRIBE_NAMED_TYPE_CREATE || server.getMethod() == RtdbMsgID.MSG_SUBSCRIBE_NAMED_TYPE_REMOVE_CALLBACK && method != RtdbMsgID.MSG_CANCEL_SUBSCRIBE_NAMED_TYPE_REMOVE) && server.getLock() > 0) {
                throw new Exception(RtdbError.GoE_OTHER_SDK_DOING.getErrmsg());
            }
            server.setMethod(method);
            return true;
        }
    }

    protected String getJobMsg(RtdbMsgID method) {
        return Rtdb.initJobField().get(method.toString()).getMsg();
    }

    protected String subString(String str, int length) throws UnsupportedEncodingException {
        byte[] bytes = str.getBytes("GBK");
        if (bytes.length > length) {
            return new String(bytes, 0, length, "GBK");
        }
        return str;
    }

    protected void ensureRetSuccess(RtdbError ret) throws Exception {
        if (ret != RtdbError.GoE_OK) {
            throw new Exception(ret.getErrmsg());
        }
    }

    protected RtdbNumType getNumberType(RtdbType rtdbType) throws UnknownHostException, IOException, DataTypeNotMatchException, Exception {
        switch (rtdbType.getNum()) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return RtdbNumType.LongNumber;
            }
            case 9: 
            case 10: 
            case 11: {
                return RtdbNumType.DoubleNumber;
            }
        }
        throw new DataTypeNotMatchException();
    }

    protected void msgAddNamedTypeField(List<RtdbField> list, NamedDataTypeField[] namedFields, boolean onsend) {
        int value = 0;
        if (onsend) {
            value = -4;
        }
        if (namedFields == null) {
            list.add(new RtdbField(12, value, 0.0, -1431655766, 1, "namedFields"));
        } else {
            list.add(new RtdbField(12, value, 0.0, namedFields, namedFields.length, "namedFields"));
        }
    }

    protected void msgAddNamedTypeField(List<RtdbField> list, NamedDataTypeField namedField, boolean onsend) {
        int value = 0;
        if (onsend) {
            value = -4;
        }
        if (namedField == null) {
            list.add(new RtdbField(12, value, 0.0, -1431655766, 1, "namedFields"));
        } else {
            list.add(new RtdbField(12, value, 0.0, namedField, 1, "namedFields"));
        }
    }

    static {
        mapJobField.put("MSG_NULL", new JobField(RtdbMsgID.MSG_NULL.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u7ecc\u70d8\u79f7\u93ad\ufffd"));
        mapJobField.put("MSG_COMMON", new JobField(RtdbMsgID.MSG_COMMON.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u95ab\u6c31\u6564\u5a11\u581f\u4f05"));
        mapJobField.put("MSG_CONNECT", new JobField(RtdbMsgID.MSG_CONNECT.getNum(), -1, "\u9422\u3126\u57db\u6769\u70b4\u5e34"));
        mapJobField.put("MSG_CONNECT_COUNT", new JobField(RtdbMsgID.MSG_CONNECT_COUNT.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u9359\u6827\u7df1\u7f03\u6220\u7cb6\u93c8\u5d85\u59df\u9363\u3125\u7d8b\u9353\u5d88\u7e5b\u93ba\u30e4\u91dc\u93c1\ufffd"));
        mapJobField.put("MSG_GET_CONNECTIONS", new JobField(RtdbMsgID.MSG_GET_CONNECTIONS.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u9352\u6940\u56ad\u93c8\u5d85\u59df\u9363\u3127\u6b91\u93b5\ufffd\u93c8\u590e\u7e5b\u93ba\u30e5\u5f5e\u93cc\ufffd"));
        mapJobField.put("MSG_GET_CONNECTION_INFO", new JobField(RtdbMsgID.MSG_GET_CONNECTION_INFO.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u7039\u3221\u57db\u7ed4\ue21d\ue1d7\u95c2\ue1bd\u6e47\u9354\u00a4\u7e5b\u93ba\u30e8\ue1db\u93af\ufffd"));
        mapJobField.put("MSG_GET_CONNECTION_INFO_IPV6", new JobField(RtdbMsgID.MSG_GET_CONNECTION_INFO_IPV6.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u7039\u3221\u57db\u7ed4\ue21d\ue1d7\u95c2\ue1bd\u6e47\u9354\u00a4\u7e5b\u93ba\u30e8\ue1db\u93af\u5322PV6\u9417\ufffd"));
        mapJobField.put("MSG_DISCONNECT", new JobField(RtdbMsgID.MSG_DISCONNECT.getNum(), -1, "\u7039\u3221\u57db\u7ed4\ue21b\u67c7\u5bee\ufffd\u6d93\u5ea2\u6e47\u9354\u2033\u6ad2\u6769\u70b4\u5e34"));
        mapJobField.put("MSG_LOGIN", new JobField(RtdbMsgID.MSG_LOGIN.getNum(), -1, "\u9422\u3126\u57db\u9427\u8bf2\u7d8d"));
        mapJobField.put("MSG_CHANGE_PASSWORD", new JobField(RtdbMsgID.MSG_CHANGE_PASSWORD.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u7ee0\uff04\u608a\u935b\u6a39\u6168\u93c0\u572d\u6564\u93b4\u5cf0\u7611\u942e\ufffd"));
        mapJobField.put("MSG_CHANGE_PRIV", new JobField(RtdbMsgID.MSG_CHANGE_PRIV.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u7ee0\uff04\u608a\u935b\u6a39\u6168\u93c0\u572d\u6564\u93b4\u950b\u6f48\u95c4\ufffd "));
        mapJobField.put("MSG_ADD_USER", new JobField(RtdbMsgID.MSG_ADD_USER.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u5a23\u8bf2\u59de\u9422\u3126\u57db"));
        mapJobField.put("MSG_REMOVE_USER", new JobField(RtdbMsgID.MSG_REMOVE_USER.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u9352\u72bb\u6ace\u9422\u3126\u57db"));
        mapJobField.put("MSG_GET_USERS", new JobField(RtdbMsgID.MSG_GET_USERS.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u947e\u5cf0\u7df1\u93b5\ufffd\u93c8\u590c\u6564\u93b4\ufffd"));
        mapJobField.put("MSG_ADD_AUTHORIZATION", new JobField(RtdbMsgID.MSG_ADD_AUTHORIZATION.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u5a23\u8bf2\u59de\u6dc7\u2032\u6362\u6769\u70b4\u5e34\u5a08\ufffd"));
        mapJobField.put("MSG_REMOVE_AUTHORIZATION", new JobField(RtdbMsgID.MSG_REMOVE_AUTHORIZATION.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u9352\u72bb\u6ace\u6dc7\u2032\u6362\u6769\u70b4\u5e34\u5a08\ufffd"));
        mapJobField.put("MSG_GET_AUTHORIZATIONS", new JobField(RtdbMsgID.MSG_GET_AUTHORIZATIONS.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u947e\u5cf0\u7df1\u93b5\ufffd\u93c8\u5909\u4fca\u6d60\u660f\u7e5b\u93ba\u30e6\ue18c"));
        mapJobField.put("MSG_HOST_TIME", new JobField(RtdbMsgID.MSG_HOST_TIME.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u7039\u3221\u57db\u7ed4\ue21d\ue1d7\u95c2\ue1bd\u6e47\u9354\u2033\u6ad2\u93c3\u5815\u68ff"));
        mapJobField.put("MSG_SET_TIMEOUT", new JobField(RtdbMsgID.MSG_SET_TIMEOUT.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u7481\u5267\u7586\u6769\u70b4\u5e34\u74d2\u546e\u6902\u93c3\u5815\u68ff "));
        mapJobField.put("MSG_GET_OWN_CONNECTION", new JobField(RtdbMsgID.MSG_GET_OWN_CONNECTION.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u947e\u5cf0\u5f47\u8930\u64b3\u58a0\u6769\u70b4\u5e34\u9428\u5246ocket\u9359\u30e6\u713a"));
        mapJobField.put("MSG_GET_TIMEOUT", new JobField(RtdbMsgID.MSG_GET_TIMEOUT.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u947e\u5cf0\u5f47\u6769\u70b4\u5e34\u74d2\u546e\u6902\u93c3\u5815\u68ff "));
        mapJobField.put("MSG_KILL_CONNECTION", new JobField(RtdbMsgID.MSG_KILL_CONNECTION.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u93c2\ue15e\u7d11\u6769\u70b4\u5e34"));
        mapJobField.put("MSG_GET_LOGICAL_DRIVERS", new JobField(RtdbMsgID.MSG_GET_LOGICAL_DRIVERS.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u7df1\u95ab\u660f\u7deb\u9429\u6a3c\ue0c1"));
        mapJobField.put("MSG_OPEN_PATH", new JobField(RtdbMsgID.MSG_OPEN_PATH.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93b5\u64b3\u7d11\u93c2\u56e6\u6b22\u74ba\ue21a\u7dde"));
        mapJobField.put("MSG_READ_PATH", new JobField(RtdbMsgID.MSG_READ_PATH.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93cb\u6c2b\u5987\u93c2\u56e6\u6b22"));
        mapJobField.put("MSG_CLOSE_PATH", new JobField(RtdbMsgID.MSG_CLOSE_PATH.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u934f\u62bd\u68f4\u93c2\u56e6\u6b22\u74ba\ue21a\u7dde"));
        mapJobField.put("MSG_MKDIR", new JobField(RtdbMsgID.MSG_MKDIR.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u9352\u6d98\u7f13\u9429\ue1bc\u7d8d"));
        mapJobField.put("MSG_GET_FILE_SIZE", new JobField(RtdbMsgID.MSG_GET_FILE_SIZE.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u7df1\u93c2\u56e6\u6b22\u6fb6\u0443\u76ac"));
        mapJobField.put("MSG_READ_FILE", new JobField(RtdbMsgID.MSG_READ_FILE.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u7487\u8bf2\u5f47\u93c2\u56e6\u6b22\u9350\u546d\ue190"));
        mapJobField.put("MSG_CHANGE_MY_PASSWORD", new JobField(RtdbMsgID.MSG_CHANGE_MY_PASSWORD.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u9422\u3126\u57db\u6dc7\ue1bd\u657c\u9477\ue044\u7e41\u7035\u55d9\u721c"));
        mapJobField.put("MSG_UPDATE_AUTHORIZATION", new JobField(RtdbMsgID.MSG_UPDATE_AUTHORIZATION.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u93c7\u5b58\u67ca\u6dc7\u2032\u6362\u6769\u70b4\u5e34\u5a08\ufffd"));
        mapJobField.put("MSG_GET_DB_INFO_STR", new JobField(RtdbMsgID.MSG_GET_DB_INFO_STR.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u7df1\u701b\u6943\ue0c1\u6d93\u63d2\u7037\u7eef\u8364\u7cba\u9359\u509b\u669f"));
        mapJobField.put("MSG_GET_DB_INFO_INT", new JobField(RtdbMsgID.MSG_GET_DB_INFO_INT.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u7df1\u93c1\u6751\u7037\u7eef\u8364\u7cba\u9359\u509b\u669f"));
        mapJobField.put("MSG_SET_DB_INFO_STR", new JobField(RtdbMsgID.MSG_SET_DB_INFO_STR.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u7481\u5267\u7586\u701b\u6943\ue0c1\u6d93\u63d2\u7037\u7eef\u8364\u7cba\u9359\u509b\u669f"));
        mapJobField.put("MSG_SET_DB_INFO_INT", new JobField(RtdbMsgID.MSG_SET_DB_INFO_INT.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u7481\u5267\u7586\u93c1\u6751\u7037\u7eef\u8364\u7cba\u9359\u509b\u669f"));
        mapJobField.put("MSG_ADD_BLACKLIST", new JobField(RtdbMsgID.MSG_ADD_BLACKLIST.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u5a23\u8bf2\u59de\u95c3\u7ed8\ue11b\u6769\u70b4\u5e34\u5a08\ufffd"));
        mapJobField.put("MSG_UPDATE_BLACKLIST", new JobField(RtdbMsgID.MSG_UPDATE_BLACKLIST.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u93c7\u5b58\u67ca\u95c3\u7ed8\ue11b\u6769\u70b4\u5e34\u5a08\ufffd"));
        mapJobField.put("MSG_REMOVE_BLACKLIST", new JobField(RtdbMsgID.MSG_REMOVE_BLACKLIST.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u9352\u72bb\u6ace\u95c3\u7ed8\ue11b\u6769\u70b4\u5e34\u5a08\ufffd"));
        mapJobField.put("MSG_GET_BLACKLIST", new JobField(RtdbMsgID.MSG_GET_BLACKLIST.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u947e\u5cf0\u7df1\u6769\u70b4\u5e34\u5a08\u7538\u7ca6\u935a\u5d85\u5d1f"));
        mapJobField.put("MSG_GET_PRIV", new JobField(RtdbMsgID.MSG_GET_PRIV.getNum(), RtdbPrivGroup.RTDB_NO.getNum(), "\u9359\u6827\u7df1\u6769\u70b4\u5e34\u93c9\u51ae\u6aba"));
        mapJobField.put("MSG_APPEND_TABLE", new JobField(RtdbMsgID.MSG_APPEND_TABLE.getNum(), RtdbPrivGroup.RTDB_TA.getNum(), "\u9352\u6d98\u7f13\u93cd\u56e9\ue137\u9410\u7845\u3003"));
        mapJobField.put("MSG_TABLES_COUNT", new JobField(RtdbMsgID.MSG_TABLES_COUNT.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u741b\u3124\u91dc\u93c1\ufffd"));
        mapJobField.put("MSG_GET_TABLES", new JobField(RtdbMsgID.MSG_GET_TABLES.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u9352\u6940\u56ad\u93b5\ufffd\u93c8\u590e\u3003\u9428\u51e6D"));
        mapJobField.put("MSG_GET_TABLE_SIZE_BY_ID", new JobField(RtdbMsgID.MSG_GET_TABLE_SIZE_BY_ID.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93cd\u89c4\u5d41ID\u947e\u5cf0\u5f47\u93b8\u56e7\u757e\u741b\u3124\u8151\u9356\u546d\u60c8\u9428\u52ec\u7223\u7edb\u5267\u5063\u93c1\u4f34\u567a"));
        mapJobField.put("MSG_GET_TABLE_REAL_SIZE_BY_ID", new JobField(RtdbMsgID.MSG_GET_TABLE_REAL_SIZE_BY_ID.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93cd\u89c4\u5d41ID\u947e\u5cf0\u5f47\u93b8\u56e7\u757e\u741b\u3124\u8151\u9356\u546d\u60c8\u9428\u52ec\u7223\u7edb\u5267\u5063\u942a\u71b7\u7584\u93c1\u4f34\u567a\u951b\u5c7d\u7180\u6d5c\u5ea1\u7d13\u59dd\u30e5\u7f13\u741b\ufffd"));
        mapJobField.put("MSG_GET_TABLE_SIZE_BY_NAME", new JobField(RtdbMsgID.MSG_GET_TABLE_SIZE_BY_NAME.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93cd\u89c4\u5d41\u935a\u5d87\u041e\u947e\u5cf0\u5f47\u93b8\u56e7\u757e\u741b\u3124\u8151\u9356\u546d\u60c8\u9428\u52ec\u7223\u7edb\u5267\u5063\u93c1\u4f34\u567a"));
        mapJobField.put("MSG_GET_TABLE_PROP_BY_ID", new JobField(RtdbMsgID.MSG_GET_TABLE_PROP_BY_ID.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93cd\u89c4\u5d41ID\u947e\u5cf0\u5f47\u741b\u3125\u7758\u93ac\ufffd"));
        mapJobField.put("MSG_GET_TABLE_PROP_BY_NAME", new JobField(RtdbMsgID.MSG_GET_TABLE_PROP_BY_NAME.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93cd\u89c4\u5d41\u935a\u5d87\u041e\u947e\u5cf0\u5f47\u741b\u3125\u7758\u93ac\ufffd"));
        mapJobField.put("MSG_INSERT_POINT", new JobField(RtdbMsgID.MSG_INSERT_POINT.getNum(), RtdbPrivGroup.RTDB_TA.getNum(), "\u6d63\u8de8\u6564\u7039\u5c7e\u66a3\u9428\u52eb\u7758\u93ac\u0447\u6ce6\u93c9\u30e5\u57b1\u5be4\u70d8\u67ca\u9428\u52ec\u7223\u7edb\u5267\u5063"));
        mapJobField.put("MSG_INSERT_MAX_POINT", new JobField(RtdbMsgID.MSG_INSERT_MAX_POINT.getNum(), RtdbPrivGroup.RTDB_TA.getNum(), "\u6d63\u8de8\u6564\u7039\u5c7e\u66a3\u9428\u52ec\u6e36\u6fb6\u0443\u7758\u93ac\u0447\u6ce6\u93c9\u30e5\u57b1\u5be4\u70d8\u67ca\u9428\u52ec\u7223\u7edb\u5267\u5063"));
        mapJobField.put("MSG_INSERT_MIN_POINT", new JobField(RtdbMsgID.MSG_INSERT_MIN_POINT.getNum(), RtdbPrivGroup.RTDB_TA.getNum(), "\u6d63\u8de8\u6564\u7039\u5c7e\u66a3\u9428\u52ec\u6e36\u704f\u5fd3\u7758\u93ac\u0447\u6ce6\u93c9\u30e5\u57b1\u5be4\u70d8\u67ca\u9428\u52ec\u7223\u7edb\u5267\u5063"));
        mapJobField.put("MSG_INSERT_BASE_POINT", new JobField(RtdbMsgID.MSG_INSERT_BASE_POINT.getNum(), RtdbPrivGroup.RTDB_TA.getNum(), "\u6d63\u8de8\u6564\u934f\u62bd\u656d\u9428\u52eb\u7758\u93ac\u0447\u6ce6\u93c9\u30e5\u57b1\u5be4\u70d8\u67ca\u9428\u52ec\u7223\u7edb\u5267\u5063"));
        mapJobField.put("MSG_REMOVE_POINT_BY_ID", new JobField(RtdbMsgID.MSG_REMOVE_POINT_BY_ID.getNum(), RtdbPrivGroup.RTDB_TA.getNum(), "\u93cd\u89c4\u5d41ID\u9352\u72bb\u6ace\u93cd\u56e9\ue137\u9410\ufffd"));
        mapJobField.put("MSG_REMOVE_POINT_BY_NAME", new JobField(RtdbMsgID.MSG_REMOVE_POINT_BY_NAME.getNum(), RtdbPrivGroup.RTDB_TA.getNum(), "\u93cd\u89c4\u5d41\u935a\u5d87\u041e\u9352\u72bb\u6ace\u93cd\u56e9\ue137\u9410\ufffd"));
        mapJobField.put("MSG_GET_POINTS_PROP", new JobField(RtdbMsgID.MSG_GET_POINTS_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93b5\u5f52\u567a\u947e\u5cf0\u5f47\u93cd\u56e9\ue137\u9410\u7470\u7758\u93ac\ufffd"));
        mapJobField.put("MSG_GET_MAX_POINTS_PROP", new JobField(RtdbMsgID.MSG_GET_MAX_POINTS_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93b8\u590b\u6e36\u6fb6\u0443\ufffd\u517c\u58d2\u95b2\u5fda\u5e4f\u9359\u6828\u7974\u9410\u7470\u7758\u93ac\ufffd"));
        mapJobField.put("MSG_SEARCH", new JobField(RtdbMsgID.MSG_SEARCH.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93bc\u6ec5\u50a8\u7ed7\ufe40\u608e\u93c9\u2032\u6b22\u9428\u52ec\u7223\u7edb\u5267\u5063"));
        mapJobField.put("MSG_REMOVE_TABLE_BY_ID", new JobField(RtdbMsgID.MSG_REMOVE_TABLE_BY_ID.getNum(), RtdbPrivGroup.RTDB_TA.getNum(), "\u93cd\u89c4\u5d41ID\u9352\u72bb\u6ace\u741b\ufffd"));
        mapJobField.put("MSG_REMOVE_TABLE_BY_NAME", new JobField(RtdbMsgID.MSG_REMOVE_TABLE_BY_NAME.getNum(), RtdbPrivGroup.RTDB_TA.getNum(), "\u93cd\u89c4\u5d41\u935a\u5d87\u041e\u9352\u72bb\u6ace\u741b\ufffd"));
        mapJobField.put("MSG_UPDATE_POINT_PROP", new JobField(RtdbMsgID.MSG_UPDATE_POINT_PROP.getNum(), RtdbPrivGroup.RTDB_TA.getNum(), "\u93c7\u5b58\u67ca\u93cd\u56e9\ue137\u9410\u7470\u7758\u93ac\ufffd"));
        mapJobField.put("MSG_FIND_POINTS", new JobField(RtdbMsgID.MSG_FIND_POINTS.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93cd\u89c4\u5d41\u93cd\u56e9\ue137\u9410\u7470\u53cf\u935a\u5d86\u7161\u93b5\u70ac\u7223\u7edb\u5267\u5063"));
        mapJobField.put("MSG_RECOVER_POINT", new JobField(RtdbMsgID.MSG_RECOVER_POINT.getNum(), RtdbPrivGroup.RTDB_TA.getNum(), "\u93ad\u3220\ue632\u93cd\u56e9\ue137\u9410\ufffd"));
        mapJobField.put("MSG_PURGE_POINT", new JobField(RtdbMsgID.MSG_PURGE_POINT.getNum(), RtdbPrivGroup.RTDB_TA.getNum(), "\u8930\u8bf2\u7c33\u9352\u72bb\u6ace\u93cd\u56e9\ue137\u9410\ufffd"));
        mapJobField.put("MSG_GET_RECYCLED_POINTS_COUNT", new JobField(RtdbMsgID.MSG_GET_RECYCLED_POINTS_COUNT.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u9359\ue21a\u6d16\u93c0\u8235\u7223\u7edb\u5267\u5063\u6d93\ue045\u669f"));
        mapJobField.put("MSG_GET_RECYCLED_POINTS", new JobField(RtdbMsgID.MSG_GET_RECYCLED_POINTS.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u9352\u6940\u56ad\u9359\ue21a\u6d16\u93c0\u8235\u7223\u7edb\u5267\u5063ID"));
        mapJobField.put("MSG_GET_RECYCLED_POINT_PROP", new JobField(RtdbMsgID.MSG_GET_RECYCLED_POINT_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93cd\u89c4\u5d41ID\u947e\u5cf0\u5f47\u9359\ue21a\u6d16\u93c0\u8235\u7223\u7edb\u5267\u5063\u9428\u52eb\u7758\u93ac\ufffd"));
        mapJobField.put("MSG_SUBSCRIBE_TAGS", new JobField(RtdbMsgID.MSG_SUBSCRIBE_TAGS.getNum(), RtdbPrivGroup.RTDB_TA.getNum(), "\u7481\u3224\u69c4\u93cd\u56e9\ue137\u9410\ufffd"));
        mapJobField.put("MSG_CANCEL_SUBSCRIBE_TAGS", new JobField(RtdbMsgID.MSG_CANCEL_SUBSCRIBE_TAGS.getNum(), RtdbPrivGroup.RTDB_TA.getNum(), "\u9359\u6828\u79f7\u7481\u3224\u69c4\u93cd\u56e9\ue137\u9410\ufffd"));
        mapJobField.put("MSG_SUBSCRIBE_TAGS_CALLBACK", new JobField(RtdbMsgID.MSG_SUBSCRIBE_TAGS_CALLBACK.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93cd\u56e9\ue137\u9410\u7470\u7758\u93ac\u0444\u6d3f\u93c0\u5f52\ufffd\u6c31\u7161\u7039\u3221\u57db\u7ed4\ufffd"));
        mapJobField.put("MSG_SEARCH_RECYCLED", new JobField(RtdbMsgID.MSG_SEARCH_RECYCLED.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93bc\u6ec5\u50a8\u7ed7\ufe40\u608e\u93c9\u2032\u6b22\u9428\u52eb\u5f72\u9365\u70b4\u6579\u93cd\u56e9\ue137\u9410\ufffd"));
        mapJobField.put("MSG_CLEAR_RECYCLER", new JobField(RtdbMsgID.MSG_CLEAR_RECYCLER.getNum(), RtdbPrivGroup.RTDB_TA.getNum(), "\u5a13\u546f\u2516\u93cd\u56e9\ue137\u9410\u7470\u6d16\u93c0\u5241\u73ef"));
        mapJobField.put("MSG_SEARCH_IN_BATCHES", new JobField(RtdbMsgID.MSG_SEARCH_IN_BATCHES.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u9352\u55d8\u58d2\u93bc\u6ec5\u50a8\u7ed7\ufe40\u608e\u93c9\u2032\u6b22\u9428\u52ec\u7974\u9410\ufffd"));
        mapJobField.put("MSG_SEARCH_RECYCLED_IN_BATCHES", new JobField(RtdbMsgID.MSG_SEARCH_RECYCLED_IN_BATCHES.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u9352\u55d8\u58d2\u93bc\u6ec5\u50a8\u7ed7\ufe40\u608e\u93c9\u2032\u6b22\u9428\u52eb\u5f72\u9365\u70b4\u6579\u93cd\u56e9\ue137\u9410\ufffd"));
        mapJobField.put("MSG_SORT_POINTS", new JobField(RtdbMsgID.MSG_SORT_POINTS.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93cd\u89c4\u5d41\u93cd\u56e9\ue137\u705e\u70b4\ufffd\u0443\u74e7\u5a08\u975b\ue1ee\u93cd\u56e9\ue137\u9410\u89c4\u7223\u7487\u55da\u7e58\u741b\u5c7e\u5e13\u6434\ufffd"));
        mapJobField.put("MSG_UPDATE_TABLE_NAME", new JobField(RtdbMsgID.MSG_UPDATE_TABLE_NAME.getNum(), RtdbPrivGroup.RTDB_TA.getNum(), "\u93cd\u89c4\u5d41\u741b\ufffd ID \u93c7\u5b58\u67ca\u741b\u3125\u6095\u7ec9\ufffd"));
        mapJobField.put("MSG_UPDATE_TABLE_DESC_BY_ID", new JobField(RtdbMsgID.MSG_UPDATE_TABLE_DESC_BY_ID.getNum(), RtdbPrivGroup.RTDB_TA.getNum(), "\u93cd\u89c4\u5d41\u741b\ufffd ID \u93c7\u5b58\u67ca\u741b\u3126\u5f3f\u6769\ufffd"));
        mapJobField.put("MSG_UPDATE_TABLE_DESC_BY_NAME", new JobField(RtdbMsgID.MSG_UPDATE_TABLE_DESC_BY_NAME.getNum(), RtdbPrivGroup.RTDB_TA.getNum(), "\u93cd\u89c4\u5d41\u741b\u3125\u6095\u7ec9\u7248\u6d3f\u93c2\u62cc\u3003\u93bb\u5fda\u582a"));
        mapJobField.put("MSG_CREATE_NAMED_TYPE", new JobField(RtdbMsgID.MSG_CREATE_NAMED_TYPE.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u9352\u6d98\u7f13\u9477\ue044\u757e\u6d94\u590c\u88ab\u9368\ufffd"));
        mapJobField.put("MSG_GET_NAMED_TYPE", new JobField(RtdbMsgID.MSG_GET_NAMED_TYPE.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u947e\u5cf0\u5f47\u9477\ue044\u757e\u6d94\u590c\u88ab\u9368\u5b2c\u6b91\u93b5\ufffd\u93c8\u590a\u74e7\u5a08\ufffd"));
        mapJobField.put("MSG_REMOVE_NAMED_TYPE", new JobField(RtdbMsgID.MSG_REMOVE_NAMED_TYPE.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u93cd\u89c4\u5d41\u7eeb\u8bf2\u7037\u935a\u5d87\u041e\u9352\u72bb\u6ace\u5bb8\u832c\u7ca1\u7039\u6c2b\u7b9f\u9428\u52ee\u569c\u7039\u6c2b\u7b9f\u7eeb\u8bf2\u7037"));
        mapJobField.put("MSG_SUBSCRIBE_NAMED_TYPE_CREATE", new JobField(RtdbMsgID.MSG_SUBSCRIBE_NAMED_TYPE_CREATE.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u9352\u6d98\u7f13\u9477\ue044\u757e\u6d94\u590c\u88ab\u9368\u5b2d\ue179\u95c3\ufffd"));
        mapJobField.put("MSG_GET_RECYCLED_NAMED_TYPE_NAMES_PROP", new JobField(RtdbMsgID.MSG_GET_RECYCLED_NAMED_TYPE_NAMES_PROP.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u6d60\u5ea1\u702e\u9366\u5267\ue188\u6d93\ue161\u5e4f\u9359\u682c\u569c\u7039\u6c2b\u7b9f\u7eeb\u8bf2\u7037\u705e\u70b4\ufffd\ufffd"));
        mapJobField.put("MSG_GET_NAMED_TYPE_NAMES_PROP", new JobField(RtdbMsgID.MSG_GET_NAMED_TYPE_NAMES_PROP.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u93cd\u89c4\u5d41\u5a34\u5b2c\u5063id\u947e\u5cf0\u5f47\u9477\ue044\u757e\u6d94\u590c\u88ab\u9368\u5b2c\u6b91\u705e\u70b4\ufffd\ufffd"));
        mapJobField.put("MSG_QUERY_NEED_MEMORY_SIZE", new JobField(RtdbMsgID.MSG_QUERY_NEED_MEMORY_SIZE.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u947e\u5cf0\u5f47\u9354\u72ba\u6d47\u9352\u677f\u5534\u701b\u6a39\u8151\u5a34\u5b2c\u5063\u705e\u70b4\ufffd\u0444\u588d\u7455\u4f78\u5d30\u9428\u52eb\u74e7\u947a\u509b\u669f"));
        mapJobField.put("MSG_SET_LOAD_MEMORY", new JobField(RtdbMsgID.MSG_SET_LOAD_MEMORY.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u704f\u55d8\u7974\u9410\u7470\u7758\u93ac\u0443\u59de\u675e\u85c9\u57cc\u9350\u546d\u74e8\u6d93\ufffd"));
        mapJobField.put("MSG_QUERY_LOAD_MEMORY", new JobField(RtdbMsgID.MSG_QUERY_LOAD_MEMORY.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u947e\u5cf0\u5f47\u9354\u72ba\u6d47\u9352\u677f\u5534\u701b\u6a39\u8151\u9428\u52ec\u7974\u9410\u7470\u7758\u93ac\ufffd"));
        mapJobField.put("MSG_GET_NAMED_TYPES_COUNT", new JobField(RtdbMsgID.MSG_GET_NAMED_TYPES_COUNT.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u947e\u5cf0\u5f47\u9477\ue044\u757e\u6d94\u590c\u88ab\u9368\u5b2c\u6b91\u6d93\ue045\u669f"));
        mapJobField.put("MSG_GET_PERIODS_PROP", new JobField(RtdbMsgID.MSG_GET_PERIODS_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93cd\u89c4\u5d41ids\u93b5\u5f52\u567a\u947e\u5cf0\u5f47\u93cd\u56e9\ue137\u9410\u7845\ue178\u7ee0\u6940\u61c6\u93c8\u71c2\u7d19\u9357\u66da\u7d85\u951b\u6c31\ue757\u951b\ufffd"));
        mapJobField.put("MSG_GET_TIMECOPYS_PROP", new JobField(RtdbMsgID.MSG_GET_TIMECOPYS_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93cd\u89c4\u5d41ids\u93b5\u5f52\u567a\u947e\u5cf0\u5f47\u7481\uff04\u757b\u7f01\u64b4\u7049\u93c3\u5815\u68ff\u93b4\u7b79\u7d19\u7f01\u64b4\u7049\u6d93\ufffd0\u93cd\u56e9\u305a\u95b2\u56e9\u6564\u7481\uff04\u757b\u93c3\u5815\u68ff\u6d63\u6ec0\u8d1f\u7481\uff04\u757b\u7f01\u64b4\u7049\u93c3\u5815\u68ff\u93b4\u7b79\u7d1d\u6d93\ufffd1\u93cd\u56e9\u305a\u95b2\u56e9\u6564\u6748\u64b3\u53c6\u93cd\u56e9\ue137\u9410\u901b\u8151\u93c8\ufffd\u93c5\u6c2d\u6902\u95c2\u7fe0\u7d94\u6d93\u9e3f\ue178\u7ee0\u6943\u7ca8\u93cb\u6ec4\u6902\u95c2\u5b58\u57d1\u951b\u5c7c\u8d1f2\u741b\u3127\u305a\u95b2\u56e9\u6564\u6748\u64b3\u53c6\u93cd\u56e9\ue137\u9410\u901b\u8151\u9428\u52ec\u6e36\u93c3\u2542\u6902\u95c2\u7fe0\u7d94\u6d93\u9e3f\ue178\u7ee0\u6943\u7ca8\u93cb\u6ec4\u6902\u95c2\u5b58\u57d1\u951b\ufffd"));
        mapJobField.put("MSG_SEARCH_EX", new JobField(RtdbMsgID.MSG_SEARCH_EX.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u9366\u3128\u3003\u6d93\ue15f\u60b3\u7ef1\u3222\ue0c1\u935a\u581f\u6f6f\u6d60\u5241\u6b91\u93cd\u56e9\ue137\u9410\u7678\u7d1d\u6d63\u8de8\u6564\u93cd\u56e9\ue137\u9410\u7470\u6095\u93c3\u8235\u656e\u93b8\u4f80\ufffd\u6c36\u53a4\u7ed7\ufffd"));
        mapJobField.put("MSG_GET_TRIGGERS_PROP", new JobField(RtdbMsgID.MSG_GET_TRIGGERS_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93cd\u89c4\u5d41ids\u93b5\u5f52\u567a\u947e\u5cf0\u5f47\u7481\uff04\u757b\u7459\ufe40\u5f42\u93c2\u7470\u7d21"));
        mapJobField.put("MSG_GET_EQUATIONS_PROP", new JobField(RtdbMsgID.MSG_GET_EQUATIONS_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93cd\u89c4\u5d41ids\u93b5\u5f52\u567a\u947e\u5cf0\u5f47\u7039\u70b4\u6902\u93c2\u572d\u25bc\u5bee\ufffd"));
        mapJobField.put("MSG_GET_EQUATION_GRAPH_COUNT", new JobField(RtdbMsgID.MSG_GET_EQUATION_GRAPH_COUNT.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93cd\u89c4\u5d41\u93cd\u56e9\ue137\u9410\u7b3dD\u5bf0\u6940\u57cc\u934f\u5ba0\u4ec8\u93c2\u572d\u25bc\u5bee\u5fdb\u656d\u934a\u714e\ue1ee\u93c1\u4f34\u567a"));
        mapJobField.put("MSG_GET_EQUATION_GRAPH_DATAS", new JobField(RtdbMsgID.MSG_GET_EQUATION_GRAPH_DATAS.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93cd\u89c4\u5d41\u93cd\u56e9\ue137\u9410\u7b3dD\u5bf0\u6940\u57cc\u934f\u5ba0\u4ec8\u93c2\u572d\u25bc\u5bee\u5fdb\u656d\u934a\u80a9\u6b91\u934a\ufffd"));
        mapJobField.put("MSG_SEARCH_POINTS_COUNT", new JobField(RtdbMsgID.MSG_SEARCH_POINTS_COUNT.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u93cd\u89c4\u5d41\u59af\uff04\u7866\u93bc\u6ec5\u50a8\u9428\u52ec\u6f6f\u6d60\u60f0\u5e4f\u9359\u6828\u7223\u7edb\u5267\u5063\u9428\u52ec\u669f\u95b2\ufffd"));
        mapJobField.put("MSG_INSERT_NAMED_TYPE_POINT", new JobField(RtdbMsgID.MSG_INSERT_NAMED_TYPE_POINT.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u9352\u6d98\u7f13\u9477\ue044\u757e\u6d94\u590c\u88ab\u9368\u5b2b\u7223\u7edb\u5267\u5063"));
        mapJobField.put("MSG_GET_ALL_NAMED_TYPES", new JobField(RtdbMsgID.MSG_GET_ALL_NAMED_TYPES.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u947e\u5cf0\u5f47\u93b5\ufffd\u93c8\u590c\u6b91\u9477\ue044\u757e\u6d94\u590c\u88ab\u9368\ufffd"));
        mapJobField.put("MSG_GET_EXCDEVPERCENTS_PROP", new JobField(RtdbMsgID.MSG_GET_EXCDEVPERCENTS_PROP.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u93cd\u89c4\u5d41ids\u947e\u5cf0\u5f47\u6e1a\u5b2a\ue63b\u934b\u5fd3\u6a0a\u9427\u60e7\u578e\u59e3\ufffd"));
        mapJobField.put("MSG_GET_NAMED_TYPES_POINTS_COUNT", new JobField(RtdbMsgID.MSG_GET_NAMED_TYPES_POINTS_COUNT.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u947e\u5cf0\u5f47\u9477\ue044\u757e\u6d94\u590c\u88ab\u9368\u5b2b\u7223\u7edb\u5267\u6b91\u6d93\ue045\u669f"));
        mapJobField.put("MSG_MODIFY_NAMED_TYPE", new JobField(RtdbMsgID.MSG_MODIFY_NAMED_TYPE.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u6dc7\ue1bd\u657c\u9477\ue044\u757e\u6d94\u590c\u88ab\u9368\u5b2a\u6095\u7ec9\ufffd,\u93bb\u5fda\u582a\u6dc7\u2103\u4f05,\u701b\u6941\ue18c\u935a\u5d87\u041e\u9359\u5a42\u74e7\u5a08\u57ab\u5f3f\u6769\ufffd"));
        mapJobField.put("MSG_GET_BASE_TYPE_POINTS_COUNT", new JobField(RtdbMsgID.MSG_GET_BASE_TYPE_POINTS_COUNT.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u947e\u5cf0\u5f47\u9350\u546f\u7586\u9428\u52eb\u7180\u93c8\ue102\u88ab\u9368\u5b2b\u7223\u7edb\u5267\u5063\u9428\u52ea\u91dc\u93c1\ufffd"));
        mapJobField.put("MSG_SUBSCRIBE_NAMED_TYPE_CREATE_CALLBACK", new JobField(RtdbMsgID.MSG_SUBSCRIBE_NAMED_TYPE_CREATE_CALLBACK.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u9477\ue044\u757e\u6d94\u590c\u88ab\u9368\u5b2a\u57b1\u5be4\u8f70\u7c28\u6d60\u60f0\ue179\u95c3\ufffd"));
        mapJobField.put("MSG_CANCEL_SUBSCRIBE_NAMED_TYPE_CREATE", new JobField(RtdbMsgID.MSG_CANCEL_SUBSCRIBE_NAMED_TYPE_CREATE.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u9359\u6828\u79f7\u9352\u6d98\u7f13\u9477\ue044\u757e\u6d94\u590c\u88ab\u9368\u5b2d\ue179\u95c3\ufffd"));
        mapJobField.put("MSG_SUBSCRIBE_NAMED_TYPE_REMOVE", new JobField(RtdbMsgID.MSG_SUBSCRIBE_NAMED_TYPE_REMOVE.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u9352\u72bb\u6ace\u9477\ue044\u757e\u6d94\u590c\u88ab\u9368\u5b2d\ue179\u95c3\ufffd"));
        mapJobField.put("MSG_CANCEL_SUBSCRIBE_NAMED_TYPE_REMOVE", new JobField(RtdbMsgID.MSG_CANCEL_SUBSCRIBE_NAMED_TYPE_REMOVE.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u9359\u6828\u79f7\u9352\u72bb\u6ace\u9477\ue044\u757e\u6d94\u590c\u88ab\u9368\u5b2d\ue179\u95c3\ufffd"));
        mapJobField.put("MSG_SUBSCRIBE_NAMED_TYPE_REMOVE_CALLBACK", new JobField(RtdbMsgID.MSG_SUBSCRIBE_NAMED_TYPE_REMOVE_CALLBACK.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u9352\u72bb\u6ace\u9477\ue044\u757e\u6d94\u590c\u88ab\u9368\u5b2d\ue179\u95c3\ufffd"));
        mapJobField.put("MSG_GET_USERREAL1S_PROP", new JobField(RtdbMsgID.MSG_GET_USERREAL1S_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93cd\u89c4\u5d41ids\u93b5\u5f52\u567a\u947e\u5cf0\u5f47\u9477\ue044\u757e\u6d94\u590a\u7d8b\u7eee\u60e7\u5bb3\u5a34\ue1be\u5063\u93c1\u9881\u7af4\u9428\u52eb\ufffd\ufffd"));
        mapJobField.put("MSG_GET_USERREAL2S_PROP", new JobField(RtdbMsgID.MSG_GET_USERREAL2S_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93cd\u89c4\u5d41ids\u93b5\u5f52\u567a\u947e\u5cf0\u5f47\u9477\ue044\u757e\u6d94\u590a\u7d8b\u7eee\u60e7\u5bb3\u5a34\ue1be\u5063\u93c1\u9881\u7c29\u9428\u52eb\ufffd\ufffd"));
        mapJobField.put("MSG_GET_USERINT1S_PROP", new JobField(RtdbMsgID.MSG_GET_USERINT1S_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u9477\ue044\u757e\u6d94\u590b\u66a3\u93c1\u9881\u7af4\u9428\u52eb\ufffd\ufffd"));
        mapJobField.put("MSG_GET_USERINT2S_PROP", new JobField(RtdbMsgID.MSG_GET_USERINT2S_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u9477\ue044\u757e\u6d94\u590b\u66a3\u93c1\u9881\u7c29\u9428\u52eb\ufffd\ufffd"));
        mapJobField.put("MSG_GET_LOCATION1S_PROP", new JobField(RtdbMsgID.MSG_GET_LOCATION1S_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u93b5\u2541\u774d\u705e\u70b4\ufffd\u0442\u7af4\u9428\u52eb\ufffd\ufffd"));
        mapJobField.put("MSG_GET_LOCATION2S_PROP", new JobField(RtdbMsgID.MSG_GET_LOCATION2S_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u93b5\u2541\u774d\u705e\u70b4\ufffd\u0442\u7c29\u9428\u52eb\ufffd\ufffd"));
        mapJobField.put("MSG_GET_LOCATION3S_PROP", new JobField(RtdbMsgID.MSG_GET_LOCATION3S_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u93b5\u2541\u774d\u705e\u70b4\ufffd\u0442\u7b01\u9428\u52eb\ufffd\ufffd"));
        mapJobField.put("MSG_GET_LOCATION4S_PROP", new JobField(RtdbMsgID.MSG_GET_LOCATION4S_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u93b5\u2541\u774d\u705e\u70b4\ufffd\u0443\u6d13\u9428\u52eb\ufffd\ufffd"));
        mapJobField.put("MSG_GET_LOCATION5S_PROP", new JobField(RtdbMsgID.MSG_GET_LOCATION5S_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u93b5\u2541\u774d\u705e\u70b4\ufffd\u0442\u7c32\u9428\u52eb\ufffd\ufffd"));
        mapJobField.put("MSG_GET_INSTRUMENTS_PROP", new JobField(RtdbMsgID.MSG_GET_INSTRUMENTS_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u7481\u60e7\ue62c\u93cd\u56e9\ue137"));
        mapJobField.put("MSG_GET_SCANS_PROP", new JobField(RtdbMsgID.MSG_GET_SCANS_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u93cd\u56e9\ue137\u9410\u89c4\u69f8\u935a\ufe40\u6e6a\u95b2\u56ec\u6ce6\u93c1\u7248\u5d41"));
        mapJobField.put("MSG_GET_SOURCES_PROP", new JobField(RtdbMsgID.MSG_GET_SOURCES_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u93c1\u626e\u7c8d\u5a67\u6136\u7d1d\u704f\u55d8\u7223\u7edb\u5267\u5063\u935a\u5c7e\u7147\u6d5c\u6d99\u5e34\u9359\uff46\u57a8\u93cc\u612a\u7c3a\u59af\u2033\u6f61\u9429\u7a3f\u53e7\u9471\ufffd"));
        mapJobField.put("MSG_GET_COMPDEVPERCENTS_PROP", new JobField(RtdbMsgID.MSG_GET_COMPDEVPERCENTS_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u9358\u5b2c\u7f09\u934b\u5fd3\u6a0a\u9427\u60e7\u578e\u59e3\ufffd"));
        mapJobField.put("MSG_GET_DIGITS_PROP", new JobField(RtdbMsgID.MSG_GET_DIGITS_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u93cd\u56e9\ue137\u9410\u572d\u6b91\u93c1\u677f\ufffd\u95f4\u7d85\u93c1\u5e2e\u7d1d\u9422\u3126\u6f75\u93ba\u0443\u57d7\u93c1\u677f\ufffd\u80a9\u6b91\u93c4\u5267\u305a\u93cd\u714e\u7d21(Digit\u934a\u714e\ue629\u6d5c\ufffd-20\u9352\ufffd10\u6d94\u5b2e\u68ff)"));
        mapJobField.put("MSG_GET_CREATEDATES_PROP", new JobField(RtdbMsgID.MSG_GET_CREATEDATES_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u93cd\u56e9\ue137\u9410\u7845\ue766\u9352\u6d98\u7f13\u9428\u52ec\u6902\u95c2\ufffd"));
        mapJobField.put("MSG_GET_CHANGEDATES_PROP", new JobField(RtdbMsgID.MSG_GET_CHANGEDATES_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u93cd\u56e9\ue137\u9410\u89c4\u6e36\u935a\u5e9d\u7af4\u5a06\u00a4\ue766\u6dc7\ue1bd\u657c\u9428\u52ec\u6902\u95c2\ufffd"));
        mapJobField.put("MSG_GET_LOWLIMITS_PROP", new JobField(RtdbMsgID.MSG_GET_LOWLIMITS_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u93cd\u56e9\ue137\u9410\u572d\u6b91\u95b2\u5fd5\u25bc\u6d93\u5b2e\u6aba"));
        mapJobField.put("MSG_GET_HIGHLIMITS_PROP", new JobField(RtdbMsgID.MSG_GET_HIGHLIMITS_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u93cd\u56e9\ue137\u9410\u572d\u6b91\u95b2\u5fd5\u25bc\u6d93\u5a47\u6aba"));
        mapJobField.put("MSG_GET_TYPICALS_PROP", new JobField(RtdbMsgID.MSG_GET_TYPICALS_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u93cd\u56e9\ue137\u9410\u7845\ue195\u7f03\ue1be\u6b91\u934f\u7a3f\u7037\u934a\ufffd"));
        mapJobField.put("MSG_GET_TABLE_DOT_TAGS_PROP", new JobField(RtdbMsgID.MSG_GET_TABLE_DOT_TAGS_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u5a34\u5b2c\u5063\u934f\u3125\u6095\u7ec9\ufffd"));
        mapJobField.put("MSG_GET_DESCS_PROP", new JobField(RtdbMsgID.MSG_GET_DESCS_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u5a34\u5b2c\u5063\u9428\u52ec\u5f3f\u6769\ufffd"));
        mapJobField.put("MSG_GET_UNITS_PROP", new JobField(RtdbMsgID.MSG_GET_UNITS_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u59f9\u509a\u5f47\u5a34\u5b2c\u5063\u9428\u52eb\u4f10\u7ecb\u5b2b\u5f3f\u6769\ufffd"));
        mapJobField.put("MSG_GET_CHANGERS_PROP", new JobField(RtdbMsgID.MSG_GET_CHANGERS_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u93cd\u56e9\ue137\u9410\u89c4\u6e36\u935a\u5e9d\u7af4\u5a06\u00a4\ue766\u6dc7\ue1bd\u657c\u9428\u52ed\u6564\u93b4\u5cf0\u6095"));
        mapJobField.put("MSG_GET_CREATORS_PROP", new JobField(RtdbMsgID.MSG_GET_CREATORS_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u93cd\u56e9\ue137\u9410\u7470\u57b1\u5be4\u9e3f\ufffd\u546f\u6b91\u9422\u3126\u57db\u935a\ufffd"));
        mapJobField.put("MSG_GET_MIRRORS_PROP", new JobField(RtdbMsgID.MSG_GET_MIRRORS_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93cd\u89c4\u5d41id\u947e\u5cf0\u5f47\u93c4\ue21a\u60c1\u95c0\u6ec3\u511a\u9428\u52eb\u7758\u93ac\ufffd(Mirror=0\u741b\u3127\u305aOFF\u951b\u5b67irror=1\u93cd\u56e9\u305aON"));
        mapJobField.put("MSG_GET_COMPRESS_PROP", new JobField(RtdbMsgID.MSG_GET_COMPRESS_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93cd\u89c4\u5d41ids\u947e\u5cf0\u5f47\u93cd\u56e9\ue137\u9410\u7470\u5e07\u7f02\u2541\u7758\u93ac\u0443\ufffd\ufffd(Compress=0\u741b\u3127\u305aOFF,Compress=1\u741b\u3127\u305aON)"));
        mapJobField.put("MSG_GET_STEPS_PROP", new JobField(RtdbMsgID.MSG_GET_STEPS_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93cd\u89c4\u5d41ids\u947e\u5cf0\u5f47\u93cd\u56e9\ue137\u9410\u5f52\u6a01\u74ba\u51a8\u7758\u93ac\u0443\ufffd\ufffd(Step=0\u741b\u3127\u305aOFF,Step=1\u741b\u3127\u305aON)"));
        mapJobField.put("MSG_GET_SHUTDOWNS_PROP", new JobField(RtdbMsgID.MSG_GET_SHUTDOWNS_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93cd\u89c4\u5d41ids\u947e\u5cf0\u5f47\u93cd\u56e9\ue137\u9410\u7470\u4ee0\u93c8\u8679\u59f8\u93ac\u4f78\u74e7"));
        mapJobField.put("MSG_GET_ARCHIVES_PROP", new JobField(RtdbMsgID.MSG_GET_ARCHIVES_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93cd\u89c4\u5d41ids\u947e\u5cf0\u5f47\u93cd\u56e9\ue137\u9410\u89c4\u669f\u93b9\ue1bd\u69f8\u935a\ufe42\u6e36\u7455\u4f78\u74e8\u5997\ufffd(Archive=1\u741b\u3127\u305a\u701b\u6a3b\u3002ON\u951b\u5b49rchive=0\u741b\u3127\u305a\u701b\u6a3b\u3002OFF)"));
        mapJobField.put("MSG_GET_TAGS_PROP", new JobField(RtdbMsgID.MSG_GET_TAGS_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93b5\u5f52\u567a\u947e\u5cf0\u5f47\u93cd\u56e9\ue137\u9410\u572d\u6b91\u935a\u5d87\u041e\u705e\u70b4\ufffd\ufffd"));
        mapJobField.put("MSG_GET_MS_PROP", new JobField(RtdbMsgID.MSG_GET_MS_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93b5\u5f52\u567a\u947e\u5cf0\u5f47\u93cd\u56e9\ue137\u9410\u572d\u6b91\u93c4\ue21a\u60c1\u59e3\ue0a4\ue757\u705e\u70b4\ufffd\ufffd"));
        mapJobField.put("MSG_GET_TYPES_PROP", new JobField(RtdbMsgID.MSG_GET_TYPES_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93b5\u5f52\u567a\u947e\u5cf0\u5f47\u93cd\u56e9\ue137\u9410\u572d\u6b91\u93c1\u677f\ufffd\u80a9\u88ab\u9368\u5b2a\u7758\u93ac\ufffd"));
        mapJobField.put("MSG_GET_COMPDEVS_PROP", new JobField(RtdbMsgID.MSG_GET_COMPDEVS_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93b5\u5f52\u567a\u947e\u5cf0\u5f47\u93cd\u56e9\ue137\u9410\u572d\u6b91\u9358\u5b2c\u7f09\u934b\u5fd3\u6a0a\u705e\u70b4\ufffd\ufffd"));
        mapJobField.put("MSG_GET_COMPMAXS_PROP", new JobField(RtdbMsgID.MSG_GET_COMPMAXS_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93b5\u5f52\u567a\u947e\u5cf0\u5f47\u93cd\u56e9\ue137\u9410\u572d\u6b91\u93c8\ufffd\u6fb6\u0443\u5e07\u7f02\u2545\u68ff\u95c5\u65bf\u7758\u93ac\ufffd"));
        mapJobField.put("MSG_GET_COMPMINS_PROP", new JobField(RtdbMsgID.MSG_GET_COMPMINS_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93b5\u5f52\u567a\u947e\u5cf0\u5f47\u93cd\u56e9\ue137\u9410\u572d\u6b91\u93c8\ufffd\u704f\u5fd3\u5e07\u7f02\u2545\u68ff\u95c5\u65bf\u7758\u93ac\ufffd"));
        mapJobField.put("MSG_GET_EXCDEVS_PROP", new JobField(RtdbMsgID.MSG_GET_EXCDEVS_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93b5\u5f52\u567a\u947e\u5cf0\u5f47\u93cd\u56e9\ue137\u9410\u572d\u6b91\u6e1a\u5b2a\ue63b\u934b\u5fd3\u6a0a\u705e\u70b4\ufffd\ufffd"));
        mapJobField.put("MSG_GET_EXCMAXS_PROP", new JobField(RtdbMsgID.MSG_GET_EXCMAXS_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93b5\u5f52\u567a\u947e\u5cf0\u5f47\u93cd\u56e9\ue137\u9410\u572d\u6b91\u93c8\ufffd\u6fb6\u0442\u7de5\u6fb6\u682d\u68ff\u95c5\u65bf\u7758\u93ac\ufffd"));
        mapJobField.put("MSG_GET_EXCMINS_PROP", new JobField(RtdbMsgID.MSG_GET_EXCMINS_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93cd\u89c4\u5d41ids\u93c1\u626e\u7c8d\u947e\u5cf0\u5f47\u93c8\ufffd\u942d\ue15d\u7de5\u6fb6\u682d\u68ff\u95c5\ufffd"));
        mapJobField.put("MSG_GET_CLASSOFS_PROP", new JobField(RtdbMsgID.MSG_GET_CLASSOFS_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u5a34\u5b2c\u5063\u7eeb\u8bf2\u7037"));
        mapJobField.put("MSG_GET_TABLES_PROP", new JobField(RtdbMsgID.MSG_GET_TABLES_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u5a34\u5b2c\u5063\u93b5\ufffd\u705e\u70b5\u6b91table\u9428\u522cd"));
        mapJobField.put("MSG_GET_SUMMARYS_PROP", new JobField(RtdbMsgID.MSG_GET_SUMMARYS_PROP.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93cd\u89c4\u5d41ids\u947e\u5cf0\u5f47\u93c4\ue21a\u60c1\u9354\u72bb\ufffd\u71b7\u5dfb\u9359\u53c9\u669f\u93b9\ue1be\u7cba\u7481\uff04\u6b91\u705e\u70b4\ufffd\u0443\ufffd\ufffd"));
        mapJobField.put("MSG_GET_SNAPSHOTS", new JobField(RtdbMsgID.MSG_GET_SNAPSHOTS.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93b5\u5f52\u567a\u947e\u5cf0\u5f47\u7039\u70b4\u6902\u93c1\u7248\u5d41"));
        mapJobField.put("MSG_PUT_SNAPSHOTS", new JobField(RtdbMsgID.MSG_PUT_SNAPSHOTS.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u93b5\u5f52\u567a\u9350\u6b0f\u53c6\u7039\u70b4\u6902\u93c1\u7248\u5d41"));
        mapJobField.put("MSG_GET_COOR_SNAPSHOTS", new JobField(RtdbMsgID.MSG_GET_COOR_SNAPSHOTS.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93b5\u5f52\u567a\u7487\u8bf2\u5f47\u9367\u612d\u7223\u7eeb\u8bf2\u7037\u7039\u70b4\u6902\u93c1\u7248\u5d41"));
        mapJobField.put("MSG_PUT_COOR_SNAPSHOTS", new JobField(RtdbMsgID.MSG_PUT_COOR_SNAPSHOTS.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u93b5\u5f52\u567a\u9350\u6b0f\u53c6\u9367\u612d\u7223\u7eeb\u8bf2\u7037\u7039\u70b4\u6902\u93c1\u7248\u5d41"));
        mapJobField.put("MSG_GET_BLOB_SNAPSHOT", new JobField(RtdbMsgID.MSG_GET_BLOB_SNAPSHOT.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u7487\u8bf2\u5f47\u6d5c\u5c83\u7e58\u9352\ufffd/\u701b\u6943\ue0c1\u6d93\u63d2\u7584\u93c3\u8235\u669f\u93b9\ufffd"));
        mapJobField.put("MSG_PUT_BLOB_SNAPSHOT", new JobField(RtdbMsgID.MSG_PUT_BLOB_SNAPSHOT.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u9350\u6b0f\u53c6\u6d5c\u5c83\u7e58\u9352\ufffd/\u701b\u6943\ue0c1\u6d93\u63d2\u7584\u93c3\u8235\u669f\u93b9\ufffd"));
        mapJobField.put("MSG_SUBSCRIBE_SNAPSHOTS", new JobField(RtdbMsgID.MSG_SUBSCRIBE_SNAPSHOTS.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u7481\u3224\u69c4\u7039\u70b4\u6902\u93c1\u7248\u5d41"));
        mapJobField.put("MSG_CANCEL_SUBSCRIBE_SNAPSHOTS", new JobField(RtdbMsgID.MSG_CANCEL_SUBSCRIBE_SNAPSHOTS.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u9359\u6828\u79f7\u7481\u3224\u69c4\u7039\u70b4\u6902\u93c1\u7248\u5d41"));
        mapJobField.put("MSG_SUBSCRIBE_SNAPSHOTS_CALLBACK", new JobField(RtdbMsgID.MSG_SUBSCRIBE_SNAPSHOTS_CALLBACK.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u7039\u70b4\u6902\u93c1\u7248\u5d41\u93c7\u5b58\u657c\u95ab\u6c31\u7161\u7039\u3221\u57db\u7ed4\ufffd"));
        mapJobField.put("MSG_MIRROR_PUT_SNAPSHOTS", new JobField(RtdbMsgID.MSG_MIRROR_PUT_SNAPSHOTS.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u93b5\u5f52\u567a\u9350\u6b0f\u53c6\u95c0\u6ec3\u511a\u7039\u70b4\u6902\u93c1\u7248\u5d41"));
        mapJobField.put("MSG_FIX_SNAPSHOTS", new JobField(RtdbMsgID.MSG_FIX_SNAPSHOTS.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u93b5\u5f52\u567a\u93c7\u630e\u5d32\u7039\u70b4\u6902\u93c1\u7248\u5d41"));
        mapJobField.put("MSG_FIX_COOR_SNAPSHOTS", new JobField(RtdbMsgID.MSG_FIX_COOR_SNAPSHOTS.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u93b5\u5f52\u567a\u93c7\u630e\u5d32\u9367\u612d\u7223\u7eeb\u8bf2\u7037\u7039\u70b4\u6902\u93c1\u7248\u5d41"));
        mapJobField.put("MSG_GET_BLOB_SNAPSHOTS", new JobField(RtdbMsgID.MSG_GET_BLOB_SNAPSHOTS.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93b5\u5f52\u567a\u7487\u8bf2\u5f47\u6d5c\u5c83\u7e58\u9352\ufffd/\u701b\u6943\ue0c1\u6d93\u63d2\u7584\u93c3\u8235\u669f\u93b9\ufffd"));
        mapJobField.put("MSG_PUT_BLOB_SNAPSHOTS", new JobField(RtdbMsgID.MSG_PUT_BLOB_SNAPSHOTS.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u93b5\u5f52\u567a\u9350\u6b0f\u53c6\u6d5c\u5c83\u7e58\u9352\ufffd/\u701b\u6943\ue0c1\u6d93\u63d2\u7584\u93c3\u8235\u669f\u93b9\ufffd"));
        mapJobField.put("MSG_GET_ARCHIVES_COUNT", new JobField(RtdbMsgID.MSG_GET_ARCHIVES_COUNT.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u701b\u6a3b\u3002\u93c2\u56e6\u6b22\u93c1\u4f34\u567a"));
        mapJobField.put("MSG_CREATE_ARCHIVE", new JobField(RtdbMsgID.MSG_CREATE_ARCHIVE.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u9352\u6d98\u7f13\u701b\u6a3b\u3002\u93c2\u56e6\u6b22"));
        mapJobField.put("MSG_CREATE_RANGED_ARCHIVE", new JobField(RtdbMsgID.MSG_CREATE_RANGED_ARCHIVE.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u93cd\u89c4\u5d41\u93c3\u5815\u68ff\u947c\u51a8\u6d3f\u9352\u6d98\u7f13\u701b\u6a3b\u3002\u93c2\u56e6\u6b22"));
        mapJobField.put("MSG_APPEND_ARCHIVE", new JobField(RtdbMsgID.MSG_APPEND_ARCHIVE.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u6769\u85c9\u59de\u701b\u6a3b\u3002\u93c2\u56e6\u6b22"));
        mapJobField.put("MSG_REMOVE_ARCHIVE", new JobField(RtdbMsgID.MSG_REMOVE_ARCHIVE.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u7ec9\u5a5a\u6ace\u701b\u6a3b\u3002\u93c2\u56e6\u6b22"));
        mapJobField.put("MSG_SHIFT_ACTIVED", new JobField(RtdbMsgID.MSG_SHIFT_ACTIVED.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u9352\u56e8\u5d32\u5a32\u8bf2\u59e9\u701b\u6a3b\u3002\u93c2\u56e6\u6b22"));
        mapJobField.put("MSG_GET_FIRST_ARCHIVE", new JobField(RtdbMsgID.MSG_GET_FIRST_ARCHIVE.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u68e3\u6826\u91dc\u701b\u6a3b\u3002\u93c2\u56e6\u6b22\u9428\u52ee\u77fe\u5bf0\u52e9\ufffd\u4f78\u6095\u7ec9\u822c\ufffd\u4f7a\u59f8\u93ac\u4f78\u62f0\u93c8\ufffd\u93c3\u2541\u5391\u7481\u7a3f\u5553\u934f\u30e6\u6902\u95c2\ufffd"));
        mapJobField.put("MSG_GET_NEXT_ARCHIVE", new JobField(RtdbMsgID.MSG_GET_NEXT_ARCHIVE.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u6d93\u5b29\u91dc\u701b\u6a3b\u3002\u93c2\u56e6\u6b22\u9428\u52ee\u77fe\u5bf0\u52e9\ufffd\u4f78\u6095\u7ec9\u822c\ufffd\u4f7a\u59f8\u93ac\u4f78\u62f0\u93c8\ufffd\u93c3\u2541\u5391\u7481\u7a3f\u5553\u934f\u30e6\u6902\u95c2\ufffd"));
        mapJobField.put("MSG_GET_ARCHIVE_INFO", new JobField(RtdbMsgID.MSG_GET_ARCHIVE_INFO.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u701b\u6a3b\u3002\u93c2\u56e6\u6b22\u9428\u52ee\ue1db\u93af\ufffd"));
        mapJobField.put("MSG_MERGE_ARCHIVE", new JobField(RtdbMsgID.MSG_MERGE_ARCHIVE.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u935a\u581d\u82df\u701b\u6a3b\u3002\u93c2\u56e6\u6b22"));
        mapJobField.put("MSG_ARRANGE_ARCHIVE", new JobField(RtdbMsgID.MSG_ARRANGE_ARCHIVE.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u93c1\u5bf8\u608a\u701b\u6a3b\u3002\u93c2\u56e6\u6b22"));
        mapJobField.put("MSG_REINDEX_ARCHIVE", new JobField(RtdbMsgID.MSG_REINDEX_ARCHIVE.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u95b2\u5d85\u7f13\u701b\u6a3b\u3002\u93c2\u56e6\u6b22\u7ef1\u3220\u7d29"));
        mapJobField.put("MSG_QUERY_BIG_JOB", new JobField(RtdbMsgID.MSG_QUERY_BIG_JOB.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93cc\u30e8\ue1d7\u935a\u5ea1\u5f74\u6d60\u8bf2\u59df\u9428\u52ed\u59f8\u93ac\u4f78\u62f0\u6769\u6d98\u5bb3"));
        mapJobField.put("MSG_CANCEL_BIG_JOB", new JobField(RtdbMsgID.MSG_CANCEL_BIG_JOB.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u7f01\u64b4\u6f6b\u935a\u5ea1\u5f74\u6d60\u8bf2\u59df\u9428\u52ed\u59f8\u93ac\u4f78\u62f0\u6769\u6d98\u5bb3"));
        mapJobField.put("MSG_BACKUP_ARCHIVE", new JobField(RtdbMsgID.MSG_BACKUP_ARCHIVE.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u6fb6\u56e6\u5524\u701b\u6a3b\u3002\u93c2\u56e6\u6b22"));
        mapJobField.put("MSG_UPDATE_ARCHIVE", new JobField(RtdbMsgID.MSG_UPDATE_ARCHIVE.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u6dc7\ue1bd\u657c\u701b\u6a3b\u3002\u93c2\u56e6\u6b22\u9359\ue21e\u53a4\u7f03\ue1c0\u300d"));
        mapJobField.put("MSG_REACTIVE_ARCHIVE", new JobField(RtdbMsgID.MSG_REACTIVE_ARCHIVE.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u5a75\ufffd\u5a32\u7ed8\u5bda\u7039\u6c2c\u74e8\u5997\uff46\u6783\u6d60\ufffd"));
        mapJobField.put("MSG_ARCHIVED_VALUES_COUNT", new JobField(RtdbMsgID.MSG_ARCHIVED_VALUES_COUNT.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u6d93\ufffd\u5a08\u57ab\u6902\u95c2\u6751\u5534\u9428\u52eb\u74e8\u934c\u3125\ufffd\u517c\u669f\u95b2\ufffd"));
        mapJobField.put("MSG_GET_ARCHIVED_VALUES", new JobField(RtdbMsgID.MSG_GET_ARCHIVED_VALUES.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u7487\u8bf2\u5f47\u6d93\ufffd\u5a08\u57ab\u6902\u95c2\u6751\u5534\u9428\u52eb\u74e8\u934c\u3125\ufffd\ufffd"));
        mapJobField.put("MSG_GET_ARCHIVED_COOR_VALUES", new JobField(RtdbMsgID.MSG_GET_ARCHIVED_COOR_VALUES.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u6d93\ufffd\u5a08\u57ab\u6902\u95c2\u6751\u5534\u9367\u612d\u7223\u7eeb\u8bf2\u7037\u9428\u52eb\u74e8\u934c\u3125\ufffd\ufffd"));
        mapJobField.put("MSG_GET_ARCHIVED_VALUES_IN_BATCHES", new JobField(RtdbMsgID.MSG_GET_ARCHIVED_VALUES_IN_BATCHES.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u5bee\ufffd\u6fee\u5b2a\u578e\u93b5\u7845\u7e51\u9365\u70b0\u7af4\u5a08\u57ab\u6902\u95c2\u6751\u5534\u9428\u52eb\u74e8\u934c\u3125\ufffd\ufffd"));
        mapJobField.put("MSG_GET_NEXT_ARCHIVED_VALUES", new JobField(RtdbMsgID.MSG_GET_NEXT_ARCHIVED_VALUES.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u6769\u65bf\u6d16\u6d93\u5b29\u7af4\u93b5\u7470\u74e8\u934c\u3125\ufffd\ufffd"));
        mapJobField.put("MSG_GET_TIMED_VALUES", new JobField(RtdbMsgID.MSG_GET_TIMED_VALUES.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u6d93\ufffd\u5a08\u975b\u5d1f\u748b\u51ae\ufffd\u6391\ue583\u93c3\u5815\u68ff\u6434\u5fd3\u57aa\u9428\u52ec\u5f43\u934a\ufffd"));
        mapJobField.put("MSG_GET_TIMED_COOR_VALUES", new JobField(RtdbMsgID.MSG_GET_TIMED_COOR_VALUES.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u9367\u612d\u7223\u7eeb\u8bf2\u7037\u6d93\ufffd\u5a08\u975b\u5d1f\u748b\u51ae\ufffd\u6391\ue583\u93c3\u5815\u68ff\u6434\u5fd3\u57aa\u9428\u52ec\u5f43\u934a\ufffd"));
        mapJobField.put("MSG_GET_INTERPO_VALUES", new JobField(RtdbMsgID.MSG_GET_INTERPO_VALUES.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u6d93\ufffd\u5a08\u57ab\u6902\u95c2\u6751\u5534\u9428\u52ed\u74d1\u95c2\u64ae\u6ba7\u93bb\u6391\ufffd\ufffd"));
        mapJobField.put("MSG_GET_INTERVAL_VALUES", new JobField(RtdbMsgID.MSG_GET_INTERVAL_VALUES.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u93cc\u612a\u91dc\u93c3\u8dfa\u57e2\u5bf0\ufffd\u935a\u5ea3\u6b91\u7edb\u5910\u68ff\u95c5\u65c0\u5f43\u934a\ufffd"));
        mapJobField.put("MSG_GET_SINGLE_VALUE", new JobField(RtdbMsgID.MSG_GET_SINGLE_VALUE.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u7487\u8bf2\u5f47\u93cc\u612a\u91dc\u93c3\u8dfa\u57e2\u9428\u52eb\u5dfb\u9359\u53c9\u669f\u93b9\ufffd"));
        mapJobField.put("MSG_GET_SINGLE_COOR_VALUE", new JobField(RtdbMsgID.MSG_GET_SINGLE_COOR_VALUE.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u7487\u8bf2\u5f47\u9367\u612d\u7223\u7eeb\u8bf2\u7037\u93cc\u612a\u91dc\u93c3\u8dfa\u57e2\u9428\u52eb\u5dfb\u9359\u53c9\u669f\u93b9\ufffd"));
        mapJobField.put("MSG_GET_SINGLE_BLOB_VALUE", new JobField(RtdbMsgID.MSG_GET_SINGLE_BLOB_VALUE.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u7487\u8bf2\u5f47\u6d5c\u5c83\u7e58\u9352\ufffd/\u701b\u6943\ue0c1\u6d93\u53c9\u7147\u6d93\ue045\u6902\u9352\u8364\u6b91\u9358\u55d7\u5f76\u93c1\u7248\u5d41"));
        mapJobField.put("MSG_SUMMARY", new JobField(RtdbMsgID.MSG_SUMMARY.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u6d93\ufffd\u5a08\u57ab\u6902\u95c2\u6751\u5534\u9428\u52ed\u7cba\u7481\u2103\u669f\u93b9\ufffd"));
        mapJobField.put("MSG_GET_PLOT_VALUES", new JobField(RtdbMsgID.MSG_GET_PLOT_VALUES.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u6d93\ufffd\u5a08\u57ab\u6902\u95c2\u6751\u5534\u9422\u3124\u7c2c\u7f01\u6a3a\u6d58\u9428\u52eb\u5dfb\u9359\u53c9\u669f\u93b9\ufffd"));
        mapJobField.put("MSG_GET_CROSS_SECTION_VALUES", new JobField(RtdbMsgID.MSG_GET_CROSS_SECTION_VALUES.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u6d93\ufffd\u93b5\u89c4\u7223\u7edb\u5267\u5063\u93cc\u612a\u91dc\u93c3\u8dfa\u57e2\u9428\u52ec\u67c7\u95c8\u3221\u669f\u93b9\ufffd"));
        mapJobField.put("MSG_SUBSCRIBE_PLAYBACK", new JobField(RtdbMsgID.MSG_SUBSCRIBE_PLAYBACK.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u7481\u3224\u69c4\u9358\u55d7\u5f76\u93c1\u7248\u5d41\u9365\u70b4\u6581"));
        mapJobField.put("MSG_STOP_PLAYBACK", new JobField(RtdbMsgID.MSG_STOP_PLAYBACK.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u934b\u6ec4\ue11b\u9358\u55d7\u5f76\u93c1\u7248\u5d41\u9365\u70b4\u6581"));
        mapJobField.put("MSG_GET_ARCHIVED_VALUES_FILT", new JobField(RtdbMsgID.MSG_GET_ARCHIVED_VALUES_FILT.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93b8\u590b\u6f6f\u6d60\u60f0\u5e4f\u9359\u6826\u7af4\u5a08\u57ab\u6902\u95c2\u6751\u5534\u9428\u52eb\u74e8\u934c\u3125\ufffd\ufffd"));
        mapJobField.put("MSG_GET_INTERVAL_VALUES_FILT", new JobField(RtdbMsgID.MSG_GET_INTERVAL_VALUES_FILT.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93b8\u590b\u6f6f\u6d60\u60f0\u5e4f\u9359\u6828\u7147\u6d93\ue045\u6902\u9352\u8bf2\u7dda\u935a\u5ea3\u6b91\u7edb\u5910\u68ff\u95c5\u65c0\u5f43\u934a\ufffd"));
        mapJobField.put("MSG_GET_INTERPO_VALUES_FILT", new JobField(RtdbMsgID.MSG_GET_INTERPO_VALUES_FILT.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93b8\u590b\u6f6f\u6d60\u60f0\u5e4f\u9359\u6826\u7af4\u5a08\u57ab\u6902\u95c2\u6751\u5534\u9428\u52ed\u74d1\u95c2\u64ae\u6ba7\u93bb\u6391\ufffd\ufffd"));
        mapJobField.put("MSG_SUMMARY_FILT", new JobField(RtdbMsgID.MSG_SUMMARY_FILT.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93b8\u590b\u6f6f\u6d60\u60f0\u5e4f\u9359\u6826\u7af4\u5a08\u57ab\u6902\u95c2\u6751\u5534\u9428\u52ed\u7cba\u7481\u2103\u669f\u93b9\ufffd"));
        mapJobField.put("MSG_SUMMARY_FILT_IN_BATCHES", new JobField(RtdbMsgID.MSG_SUMMARY_FILT_IN_BATCHES.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u93b8\u590b\u6f6f\u6d60\u8dfa\u578e\u93b5\u7845\u5e4f\u9359\u6826\u7af4\u5a08\u57ab\u6902\u95c2\u6751\u5534\u9428\u52ed\u7cba\u7481\u2103\u669f\u93b9\ufffd"));
        mapJobField.put("MSG_UPDATE_VALUE", new JobField(RtdbMsgID.MSG_UPDATE_VALUE.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u93c7\u5b58\u67ca\u701b\u6a3a\u504d\u934a\ufffd"));
        mapJobField.put("MSG_UPDATE_COOR_VALUE", new JobField(RtdbMsgID.MSG_UPDATE_COOR_VALUE.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u93c7\u5b58\u67ca\u9367\u612d\u7223\u7eeb\u8bf2\u7037\u701b\u6a3a\u504d\u934a\ufffd"));
        mapJobField.put("MSG_REMOVE_VALUE", new JobField(RtdbMsgID.MSG_REMOVE_VALUE.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u9352\u72bb\u6ace\u93cc\u612a\u91dc\u93c3\u8dfa\u57e2\u9428\u52eb\u5dfb\u9359\u53c9\u669f\u93b9\ufffd"));
        mapJobField.put("MSG_REMOVE_VALUES", new JobField(RtdbMsgID.MSG_REMOVE_VALUES.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u9352\u72bb\u6ace\u6d93\ufffd\u5a08\u57ab\u6902\u95c2\u6751\u5534\u9428\u52eb\u5dfb\u9359\u53c9\u669f\u93b9\ufffd"));
        mapJobField.put("MSG_PUT_SINGLE_VALUE", new JobField(RtdbMsgID.MSG_PUT_SINGLE_VALUE.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u93bb\u6391\u53c6\u9357\u66da\u91dc\u9358\u55d7\u5f76\u93c1\u7248\u5d41"));
        mapJobField.put("MSG_PUT_SINGLE_COOR_VALUE", new JobField(RtdbMsgID.MSG_PUT_SINGLE_COOR_VALUE.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u93bb\u6391\u53c6\u9367\u612d\u7223\u7eeb\u8bf2\u7037\u9357\u66da\u91dc\u9358\u55d7\u5f76\u93c1\u7248\u5d41"));
        mapJobField.put("MSG_PUT_ARCHIVED_VALUES", new JobField(RtdbMsgID.MSG_PUT_ARCHIVED_VALUES.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u93b5\u5f52\u567a\u93bb\u6391\u53c6\u9358\u55d7\u5f76\u93c1\u7248\u5d41"));
        mapJobField.put("MSG_PUT_ARCHIVED_COOR_VALUES", new JobField(RtdbMsgID.MSG_PUT_ARCHIVED_COOR_VALUES.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u93b5\u5f52\u567a\u93bb\u6391\u53c6\u9367\u612d\u7223\u7eeb\u8bf2\u7037\u9358\u55d7\u5f76\u93c1\u7248\u5d41"));
        mapJobField.put("MSG_SUMMARY_IN_BATCHES", new JobField(RtdbMsgID.MSG_SUMMARY_IN_BATCHES.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u9352\u55d8\u58d2\u947e\u5cf0\u5f47\u6d93\ufffd\u5a08\u57ab\u6902\u95c2\u6751\u5534\u9428\u52ed\u7cba\u7481\u2103\u669f\u93b9\ufffd"));
        mapJobField.put("MSG_GET_ARCHIVED_VALUES_BACKWARD", new JobField(RtdbMsgID.MSG_GET_ARCHIVED_VALUES_BACKWARD.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u95ab\u55d7\u609c\u7487\u8bf2\u5f47\u6d93\ufffd\u5a08\u57ab\u6902\u95c2\u6751\u5534\u9428\u52eb\u504d\u701b\u6a3a\ufffd\ufffd"));
        mapJobField.put("MSG_GET_ARCHIVED_COOR_VALUES_BACKWARD", new JobField(RtdbMsgID.MSG_GET_ARCHIVED_COOR_VALUES_BACKWARD.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u95ab\u55d7\u609c\u7487\u8bf2\u5f47\u9367\u612d\u7223\u7eeb\u8bf2\u7037\u6d93\ufffd\u5a08\u57ab\u6902\u95c2\u6751\u5534\u9428\u52eb\u504d\u701b\u6a3a\ufffd\ufffd"));
        mapJobField.put("MSG_PUT_SINGLE_BLOB_VALUE", new JobField(RtdbMsgID.MSG_PUT_SINGLE_BLOB_VALUE.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u93bb\u6391\u53c6\u6d5c\u5c83\u7e58\u9352\ufffd/\u701b\u6943\ue0c1\u6d93\u63d2\u5d1f\u6d93\ue044\u5dfb\u9359\u53c9\u669f\u93b9\ufffd"));
        mapJobField.put("MSG_FLUSH_ARCHIVED_VALUES", new JobField(RtdbMsgID.MSG_FLUSH_ARCHIVED_VALUES.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u704f\u55d8\u7223\u7edb\u5267\u5063\u93c8\ue044\u5553\u5a4a\uff04\u6b91\u741b\u30e5\u5dfb\u9359\u832c\u7d26\u701b\u6a40\u3009\u9350\u6b0f\u53c6\u701b\u6a3b\u3002\u93c2\u56e6\u6b22\u6d93\ufffd"));
        mapJobField.put("MSG_COMPUTE_HISTORY", new JobField(RtdbMsgID.MSG_COMPUTE_HISTORY.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u93b5\u5f52\u567a\u95b2\u5d87\u757b\u93b4\u682c\u02c9\u7ee0\u6944\ue178\u7ee0\u6941\u7223\u7edb\u5267\u5063\u9358\u55d7\u5f76\u93c1\u7248\u5d41"));
        mapJobField.put("MSG_GET_ARCHIVED_BLOB_VALUES", new JobField(RtdbMsgID.MSG_GET_ARCHIVED_BLOB_VALUES.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u93b5\u5f52\u567a\u7487\u8bf2\u5f47\u6d5c\u5c83\u7e58\u9352\u8235\u7223\u7edb\u5267\u5063\u9358\u55d7\u5f76\u93c1\u7248\u5d41"));
        mapJobField.put("MSG_GET_MAX_BLOB_LEN", new JobField(RtdbMsgID.MSG_GET_MAX_BLOB_LEN.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u6769\u65bf\u6d16\u934f\u4f7d\ue18fblob\u9286\u4e7btr\u9428\u52ec\u6e36\u6fb6\u0447\u66b1\u6434\ufffd"));
        mapJobField.put("MSG_GET_ARCHIVES_STATUS", new JobField(RtdbMsgID.MSG_GET_ARCHIVES_STATUS.getNum(), RtdbPrivGroup.RTDB_RO.getNum(), "\u947e\u5cf0\u5f47\u701b\u6a3b\u3002\u93c2\u56e6\u6b22\u9428\u52ea\u4fca\u93ad\ufffd"));
        mapJobField.put("MSG_LOCK_USER", new JobField(RtdbMsgID.MSG_LOCK_USER.getNum(), RtdbPrivGroup.RTDB_SA.getNum(), "\u935a\ue21c\u6564\u93b4\u682b\ue6e6\u9422\u3127\u6564\u93b4\ufffd"));
        mapJobField.put("MSG_PUT_ARCHIVED_BLOB_VALUES", new JobField(RtdbMsgID.MSG_PUT_ARCHIVED_BLOB_VALUES.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u93b5\u5f52\u567a\u741b\u30e5\u5553string\u9286\u4e65lob\u7eeb\u8bf2\u7037\u9428\u52eb\u5dfb\u9359\u53c9\u669f\u93b9\ufffd"));
        mapJobField.put("MSG_GET_SINGLE_DATETIME_VALUE", new JobField(RtdbMsgID.MSG_GET_SINGLE_DATETIME_VALUE.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u947e\u5cf0\u5f47\u9357\u66da\u91dcdatetime\u7eeb\u8bf2\u7037\u93cd\u56e9\ue137\u9410\ufffd"));
        mapJobField.put("MSG_GET_ARCHIVED_DATETIME_VALUES", new JobField(RtdbMsgID.MSG_GET_ARCHIVED_DATETIME_VALUES.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u93b5\u5f52\u567a\u947e\u5cf0\u5f47datetime\u7eeb\u8bf2\u7037\u93cd\u56e9\ue137\u9410\ufffd"));
        mapJobField.put("MSG_PUT_SINGLE_DATETIME_VALUE", new JobField(RtdbMsgID.MSG_PUT_SINGLE_DATETIME_VALUE.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u9357\u66da\u91dcdatetime\u7eeb\u8bf2\u7037\u93cd\u56e9\ue137\u9410\ufffd"));
        mapJobField.put("MSG_PUT_ARCHIVED_DATETIME_VALUES", new JobField(RtdbMsgID.MSG_PUT_ARCHIVED_DATETIME_VALUES.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u93b5\u5f52\u567a\u947e\u5cf0\u5f47datetime\u7eeb\u8bf2\u7037\u93cd\u56e9\ue137\u9410\ufffd"));
        mapJobField.put("MSG_GET_SINGLE_NAMED_TYPE_VALUE", new JobField(RtdbMsgID.MSG_GET_SINGLE_NAMED_TYPE_VALUE.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u7487\u8bf2\u5f47\u9357\u66da\u91dc\u93c3\u5815\u68ff\u9410\u572d\u6b91\u9477\ue044\u757e\u6d94\u590c\u88ab\u9368\u5b2c\u6b91\u9358\u55d7\u5f76\u934a\ufffd"));
        mapJobField.put("MSG_PUT_SINGLE_NAMED_TYPE_VALUE", new JobField(RtdbMsgID.MSG_PUT_SINGLE_NAMED_TYPE_VALUE.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u9350\u6b0f\u53c6\u9357\u66da\u91dc\u93c3\u5815\u68ff\u9410\u572d\u6b91\u9477\ue044\u757e\u6d94\u590c\u88ab\u9368\u5b2c\u6b91\u9358\u55d7\u5f76\u934a\ufffd"));
        mapJobField.put("MSG_GET_ARCHIVED_NAMED_TYPE_VALUES", new JobField(RtdbMsgID.MSG_GET_ARCHIVED_NAMED_TYPE_VALUES.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u7487\u8bf2\u5f47\u9357\u66da\u91dc\u9477\ue044\u757e\u6d94\u590c\u88ab\u9368\u5b2b\u7223\u7edb\u5267\u5063\u6d93\ufffd\u5a08\u57ab\u6902\u95c2\u5bf8\u6b91\u9358\u55d7\u5f76\u934a\ufffd"));
        mapJobField.put("MSG_PUT_ARCHIVED_NAMED_TYPE_VALUES", new JobField(RtdbMsgID.MSG_PUT_ARCHIVED_NAMED_TYPE_VALUES.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u9350\u6b0f\u53c6\u9357\u66da\u91dc\u9477\ue044\u757e\u6d94\u590c\u88ab\u9368\u5b2b\u7223\u7edb\u5267\u5063\u6d93\ufffd\u5a08\u57ab\u6902\u95c2\u5bf8\u6b91\u9358\u55d7\u5f76\u934a\ufffd"));
        mapJobField.put("MSG_GET_RECYCLED_MAX_POINT_PROP", new JobField(RtdbMsgID.MSG_GET_RECYCLED_MAX_POINT_PROP.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u93b8\u590b\u6e36\u6fb6\u0447\u66b1\u6434\ufe41\u5e4f\u9359\u6827\u5f72\u9365\u70b4\u6579\u93cd\u56e9\ue137\u9410\u572d\u6b91\u705e\u70b4\ufffd\ufffd"));
        mapJobField.put("MSG_GET_DATETIME_SNAPSHOTS", new JobField(RtdbMsgID.MSG_GET_DATETIME_SNAPSHOTS.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u93b5\u5f52\u567a\u7487\u8bf2\u5f47datetime\u7039\u70b4\u6902\u93c1\u7248\u5d41"));
        mapJobField.put("MSG_PUT_DATETIME_SNAPSHOTS", new JobField(RtdbMsgID.MSG_PUT_DATETIME_SNAPSHOTS.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u93b5\u5f52\u567a\u9350\u6b0f\u53c6datetime\u7039\u70b4\u6902\u93c1\u7248\u5d41"));
        mapJobField.put("MSG_GET_NAMED_TYPE_SNAPSHOT", new JobField(RtdbMsgID.MSG_GET_NAMED_TYPE_SNAPSHOT.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u7487\u8bf2\u5f47\u9477\ue044\u757e\u6d94\u590c\u88ab\u9368\u5b2a\u7584\u93c3\u8dfa\ufffd\ufffd"));
        mapJobField.put("MSG_PUT_NAMED_TYPE_SNAPSHOT", new JobField(RtdbMsgID.MSG_PUT_NAMED_TYPE_SNAPSHOT.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u9350\u6b0f\u53c6\u9477\ue044\u757e\u6d94\u590c\u88ab\u9368\u5b2a\u7584\u93c3\u8dfa\ufffd\ufffd"));
        mapJobField.put("MSG_GET_NAMED_TYPE_SNAPSHOTS", new JobField(RtdbMsgID.MSG_GET_NAMED_TYPE_SNAPSHOTS.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u93b5\u5f52\u567a\u7487\u8bf2\u5f47\u9477\ue044\u757e\u6d94\u590c\u88ab\u9368\u5b2a\u7584\u93c3\u8dfa\ufffd\ufffd"));
        mapJobField.put("MSG_PUT_NAMED_TYPE_SNAPSHOTS", new JobField(RtdbMsgID.MSG_PUT_NAMED_TYPE_SNAPSHOTS.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u93b5\u5f52\u567a\u9350\u6b0f\u53c6\u9477\ue044\u757e\u6d94\u590c\u88ab\u9368\u5b2a\u7584\u93c3\u8dfa\ufffd\ufffd"));
        mapJobField.put("MSG_ARCHIVED_VALUES_REAL_COUNT", new JobField(RtdbMsgID.MSG_ARCHIVED_VALUES_REAL_COUNT.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u947e\u5cf0\u5f47\u9357\u66da\u91dc\u93cd\u56e9\ue137\u9410\u7470\u6e6a\u6d93\ufffd\u5a08\u57ab\u6902\u95c2\u78cb\u5bd6\u9365\u6751\u5534\u9428\u52ed\u6e61\u7039\u70b5\u6b91\u701b\u6a3a\u504d\u934a\u517c\u669f\u95b2\ufffd"));
        mapJobField.put("MSG_GET_ARCHIVES", new JobField(RtdbMsgID.MSG_GET_ARCHIVES.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u93b5\u5f52\u567a\u947e\u5cf0\u5f47\u701b\u6a3b\u3002\u93c2\u56e6\u6b22\u9428\u52ee\u77fe\u5bf0\ufffd,\u935a\u5d87\u041e,\u9418\u8235\ufffd\u4f78\u62f0\u93c8\ufffd\u93c3\u2541\u5391\u7481\u7a3f\u5553\u934f\u30e6\u6902\u95c2\ufffd"));
        mapJobField.put("MSG_GET_ARCHIVES_PERF_DATA", new JobField(RtdbMsgID.MSG_GET_ARCHIVES_PERF_DATA.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u947e\u5cf0\u5f47\u701b\u6a3b\u3002\u93c2\u56e6\u6b22\u9428\u52ec\ufffd\u0446\u5158\u7481\u2103\u669f"));
        mapJobField.put("MSG_GET_EQUATION_BY_FILE_NAME", new JobField(RtdbMsgID.MSG_GET_EQUATION_BY_FILE_NAME.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u93cd\u89c4\u5d41\u93c2\u56e6\u6b22\u935a\u5d88\u5e4f\u9359\u6828\u67df\u7ecb\u5b2a\u7d21"));
        mapJobField.put("MSG_GET_EQUATION_BY_ID", new JobField(RtdbMsgID.MSG_GET_EQUATION_BY_ID.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u93cd\u89c4\u5d41ID\u947e\u5cf0\u5f47\u93c2\u572d\u25bc\u5bee\ufffd"));
        mapJobField.put("MSG_CONVERT_INDEX", new JobField(RtdbMsgID.MSG_CONVERT_INDEX.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u6d93\u54c4\u74e8\u5997\uff46\u6783\u6d60\u60f0\u6d46\u93b9\u3222\u50a8\u5bee\u66df\u7278\u5bee\ufffd"));
        mapJobField.put("MSG_GET_ARCHIVES_INFO", new JobField(RtdbMsgID.MSG_GET_ARCHIVES_INFO.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u947e\u5cf0\u5f47\u701b\u6a3b\u3002\u93c2\u56e6\u6b22\u9428\u52ea\u4fca\u93ad\ufffd"));
        mapJobField.put("MSG_GET_PERF_TAGS_COUNT", new JobField(RtdbMsgID.MSG_GET_PERF_TAGS_COUNT.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u947e\u5cf0\u5f47\u93ac\u0446\u5158\u7481\u2103\u669f\u9410\u572d\u6b91\u93c1\u4f34\u567a"));
        mapJobField.put("MSG_GET_PERF_TAGS_INFO", new JobField(RtdbMsgID.MSG_GET_PERF_TAGS_INFO.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u947e\u5cf0\u5f47\u93ac\u0446\u5158\u7481\u2103\u669f\u9410\u572d\u6b91\u6dc7\u2103\u4f05"));
        mapJobField.put("MSG_GET_PERF_VALUES", new JobField(RtdbMsgID.MSG_GET_PERF_VALUES.getNum(), RtdbPrivGroup.RTDB_DW.getNum(), "\u947e\u5cf0\u5f47\u93ac\u0446\u5158\u7481\u2103\u669f\u9428\u52ec\u669f\u93b9\ufffd"));
        mapJobField.put("RTDB_RO", new JobField(-1, RtdbPrivGroup.RTDB_RO.getNum(), "job list end"));
    }
}

