/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.api.impl;

import com.google.protobuf.ByteString;
import com.rtdb.api.common.RtdbErrorParse;
import com.rtdb.api.enums.HisMode;
import com.rtdb.api.enums.RtdbError;
import com.rtdb.api.enums.RtdbGlobalEnum;
import com.rtdb.api.enums.RtdbMsgID;
import com.rtdb.api.enums.RtdbNumType;
import com.rtdb.api.enums.RtdbSingleValueEnum;
import com.rtdb.api.enums.RtdbType;
import com.rtdb.api.exception.DataTypeNotMatchException;
import com.rtdb.api.exception.EncodePacketErrorException;
import com.rtdb.api.exception.InvalidParameterException;
import com.rtdb.api.exception.NoAuthorityException;
import com.rtdb.api.exception.UnexpectedMethodException;
import com.rtdb.api.impl.Rtdb;
import com.rtdb.api.inter.IHistorian;
import com.rtdb.api.inter.IServer;
import com.rtdb.api.inter.IServerable;
import com.rtdb.api.inter.msg.HistorianMessage;
import com.rtdb.api.model.DateTimeNS;
import com.rtdb.api.model.RtdbBlobData;
import com.rtdb.api.model.RtdbCoorData;
import com.rtdb.api.model.RtdbData;
import com.rtdb.api.model.RtdbDatetimeData;
import com.rtdb.api.model.RtdbField;
import com.rtdb.api.model.RtdbNamedTypeData;
import com.rtdb.api.model.RtdbSummaryData;
import com.rtdb.api.msg.HistorianProtocol21;
import com.rtdb.api.msg.HistorianProtocol30;
import com.rtdb.api.protocol.DatagramHistorian;
import com.rtdb.api.util.DateUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class RtdbHistorianImpl
extends Rtdb
implements IHistorian {
    private IServerable rtdbServer;
    private HistorianMessage proto;
    private String version = "3";

    public RtdbHistorianImpl(IServerable rtdbServer) {
        this.rtdbServer = rtdbServer;
        this.init();
    }

    private void init() {
        this.version = this.rtdbServer.getConnection().getApiVersion();
        this.proto = this.version.equals("3") ? HistorianProtocol30.getInstance() : HistorianProtocol21.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getArchivedValuesCount(int id, Object beginTime, Object endTime) throws UnexpectedMethodException, Exception {
        if (id == 0) {
            throw new InvalidParameterException();
        }
        if (!beginTime.getClass().equals(Date.class) && !beginTime.getClass().equals(DateTimeNS.class) || !endTime.getClass().equals(Date.class) && !endTime.getClass().equals(DateTimeNS.class) || !beginTime.getClass().equals(endTime.getClass())) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_ARCHIVED_VALUES_COUNT, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            List<RtdbField> fields = this.proto.msgArchivedValuesCountFields(id, beginTime, endTime);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            List<RtdbField> rFields = this.proto.msgArchivedValuesCountRespFields(0, 0);
            this.rtdbServer.getConnection().receivePacket(rFields, false);
            long longRet = rFields.get(RtdbGlobalEnum.FIELD_RET.getNum()).getIvalue();
            RtdbError ret = RtdbErrorParse.getRtdbError(longRet);
            int count = 0;
            if (ret.equals(RtdbError.GoE_OK)) {
                count = (int)rFields.get(RtdbGlobalEnum.FIELD_CNT.getNum()).getIvalue();
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbData getSingleValue(int id, RtdbType rtdbType, Object time, HisMode rtdbHisMode) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        int mode = rtdbHisMode.getNum();
        if (id <= 0 || time == null || mode < 0) {
            throw new InvalidParameterException();
        }
        if (!time.getClass().equals(Date.class) && !time.getClass().equals(DateTimeNS.class)) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_SINGLE_VALUE, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            List<RtdbField> fields = this.proto.msgGetSingleValueFields(id, time, mode);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetSingleValueRespFields(0, 0, 0, 0, 0, 0);
            this.rtdbServer.getConnection().receivePacket(fields, false);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            RtdbData rtdbData = new RtdbData();
            boolean flag = true;
            if (time.getClass().equals(DateTimeNS.class)) {
                flag = false;
            }
            if (this.version.equals("3")) {
                DatagramHistorian.datagram_get_single_value_resp.Builder build = DatagramHistorian.datagram_get_single_value_resp.newBuilder();
                RtdbField rfield = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] bts = (byte[])rfield.getData();
                build.mergeFrom(bts, 4, bts.length - 8);
                rtdbData.setId(id);
                rtdbData.setRtdbType(rtdbType);
                if (flag) {
                    rtdbData.setDate(DateUtil.getDate(build.getDatetime(), build.getMillisecond()));
                    rtdbData.setNanosecond(0);
                } else {
                    rtdbData.setDate(DateUtil.getDate(build.getDatetime(), 0));
                    rtdbData.setNanosecond(build.getMillisecond());
                }
                rtdbData.setQuality((short)build.getQuality());
                RtdbNumType numType = this.getNumberType(rtdbType);
                if (numType == RtdbNumType.DoubleNumber) {
                    rtdbData.setValue(build.getValue());
                } else if (numType == RtdbNumType.LongNumber) {
                    rtdbData.setValue(build.getState());
                }
            } else {
                int datetime_second = (int)fields.get(RtdbSingleValueEnum.FIELD_DT.getNum()).getIvalue();
                short mil_second = (short)fields.get(RtdbSingleValueEnum.FIELD_MS.getNum()).getIvalue();
                Date date = DateUtil.getDate(datetime_second, mil_second);
                rtdbData.setDate(date);
                double fvalue = fields.get(RtdbSingleValueEnum.FIELD_VAL.getNum()).getFvalue();
                long ivalue = fields.get(RtdbSingleValueEnum.FIELD_STA.getNum()).getIvalue();
                RtdbNumType numType = this.getNumberType(rtdbType);
                if (numType == RtdbNumType.DoubleNumber) {
                    rtdbData.setValue(fvalue);
                } else if (numType == RtdbNumType.LongNumber) {
                    rtdbData.setValue(ivalue);
                }
                short quality = (short)fields.get(RtdbSingleValueEnum.FIELD_Q.getNum()).getIvalue();
                rtdbData.setQuality(quality);
                rtdbData.setNanosecond(0);
            }
            return rtdbData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int putSingleValue(RtdbData rtdbData, RtdbType rtdbType) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        int id = rtdbData.getId();
        if (id <= 0) {
            throw new InvalidParameterException();
        }
        if (!rtdbData.getDate().getClass().equals(Date.class) && !rtdbData.getDate().getClass().equals(DateTimeNS.class)) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_PUT_SINGLE_VALUE, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            Date dateObj = rtdbData.getDate();
            int datetime = 0;
            int ms = 0;
            if (dateObj.getClass().equals(Date.class)) {
                datetime = DateUtil.getSecond(dateObj);
                ms = DateUtil.getMilSecond(dateObj);
            } else {
                datetime = DateUtil.getSecond(((DateTimeNS)((Object)dateObj)).getDatetime());
                ms = ((DateTimeNS)((Object)dateObj)).getNanosecond();
            }
            double value = 0.0;
            long state = 0L;
            short quality = rtdbData.getQuality();
            RtdbNumType numType = this.getNumberType(rtdbType);
            if (numType == RtdbNumType.DoubleNumber) {
                value = (Double)rtdbData.getValue();
            } else if (numType == RtdbNumType.LongNumber) {
                state = (Long)rtdbData.getState();
            }
            List<RtdbField> fields = this.proto.msgPutSingleValueFields(id, datetime, ms, value, state, quality);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgPutSingleValueRespFields();
            this.rtdbServer.getConnection().receivePacket(fields, false);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbData[] getArchivedValues(int id, int count, RtdbType rtdbType, Object dateStart, Object dateEnd) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (id <= 0 || count <= 0 || dateStart == null) {
            throw new InvalidParameterException();
        }
        if (!dateStart.getClass().equals(Date.class) && !dateStart.getClass().equals(DateTimeNS.class) || !dateEnd.getClass().equals(Date.class) && !dateEnd.getClass().equals(DateTimeNS.class) || !dateStart.getClass().equals(dateEnd.getClass())) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_ARCHIVED_VALUES, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        int datetime1 = 0;
        int datetime2 = 0;
        int ms1 = 0;
        int ms2 = 0;
        boolean flag = true;
        if (dateStart.getClass().equals(Date.class)) {
            datetime1 = DateUtil.getSecond((Date)dateStart);
            ms1 = DateUtil.getMilSecond((Date)dateStart);
            if (dateEnd != null && dateEnd.getClass().equals(Date.class)) {
                datetime2 = DateUtil.getSecond((Date)dateEnd);
                ms2 = DateUtil.getMilSecond((Date)dateEnd);
            }
        } else {
            datetime1 = DateUtil.getSecond(((DateTimeNS)dateStart).getDatetime());
            ms1 = ((DateTimeNS)dateStart).getNanosecond();
            if (dateEnd != null && dateEnd.getClass().equals(DateTimeNS.class)) {
                datetime2 = DateUtil.getSecond(((DateTimeNS)dateEnd).getDatetime());
                ms2 = ((DateTimeNS)dateEnd).getNanosecond();
            }
            flag = false;
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            List<RtdbField> fields = this.proto.msgGetArchivedValuesFields(id, count, datetime1, ms1, datetime2, ms2);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] datetimes = new int[count];
            int[] ms = new int[count];
            double[] values = new double[count];
            long[] states = new long[count];
            short[] qualities = new short[count];
            fields = this.proto.msgGetArchivedValuesRespFields(count, datetimes, ms, values, states, qualities);
            this.rtdbServer.getConnection().receivePacket(fields, false);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            count = this.getCount(fields);
            RtdbData[] rtdbDatas = new RtdbData[count];
            if (this.version.equals("3")) {
                DatagramHistorian.datagram_get_archived_values_resp.Builder builder = DatagramHistorian.datagram_get_archived_values_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builder.mergeFrom(buf, 4, buf.length - 8);
                RtdbNumType numType = this.getNumberType(rtdbType);
                List<Integer> datetimesl = builder.getDatetimesList();
                List<Double> valuesl = builder.getValuesList();
                List<Long> statesl = builder.getStatesList();
                List<Integer> quantitiesl = builder.getQualitiesList();
                List<Integer> msl = builder.getMillisecondsList();
                RtdbData rtdbData = null;
                if (flag) {
                    if (numType == RtdbNumType.DoubleNumber) {
                        for (int i = 0; i < valuesl.size(); ++i) {
                            rtdbData = new RtdbData();
                            rtdbData.setId(id);
                            rtdbData.setRtdbType(rtdbType);
                            rtdbData.setValue(valuesl.get(i));
                            rtdbData.setDate(DateUtil.getDate(datetimesl.get(i), msl.get(i)));
                            short shortValue = quantitiesl.get(i).shortValue();
                            rtdbData.setQuality(shortValue);
                            rtdbData.setNanosecond(0);
                            rtdbDatas[i] = rtdbData;
                        }
                    } else if (numType == RtdbNumType.LongNumber) {
                        for (int i = 0; i < count; ++i) {
                            rtdbData = new RtdbData();
                            rtdbData.setId(id);
                            rtdbData.setRtdbType(rtdbType);
                            rtdbData.setValue(statesl.get(i));
                            rtdbData.setDate(DateUtil.getDate(datetimesl.get(i), msl.get(i)));
                            rtdbData.setQuality(quantitiesl.get(i).shortValue());
                            rtdbData.setNanosecond(0);
                            rtdbDatas[i] = rtdbData;
                        }
                    }
                } else if (numType == RtdbNumType.DoubleNumber) {
                    for (int i = 0; i < valuesl.size(); ++i) {
                        rtdbData = new RtdbData();
                        rtdbData.setId(id);
                        rtdbData.setRtdbType(rtdbType);
                        rtdbData.setValue(valuesl.get(i));
                        rtdbData.setDate(DateUtil.getDate(datetimesl.get(i), 0));
                        short shortValue = quantitiesl.get(i).shortValue();
                        rtdbData.setQuality(shortValue);
                        rtdbData.setNanosecond(msl.get(i));
                        rtdbDatas[i] = rtdbData;
                    }
                } else if (numType == RtdbNumType.LongNumber) {
                    for (int i = 0; i < count; ++i) {
                        rtdbData = new RtdbData();
                        rtdbData.setId(id);
                        rtdbData.setRtdbType(rtdbType);
                        rtdbData.setValue(statesl.get(i));
                        rtdbData.setDate(DateUtil.getDate(datetimesl.get(i), 0));
                        rtdbData.setQuality(quantitiesl.get(i).shortValue());
                        rtdbData.setNanosecond(msl.get(i));
                        rtdbDatas[i] = rtdbData;
                    }
                }
            } else {
                RtdbNumType numType = this.getNumberType(rtdbType);
                count = this.getCount(fields);
                Date[] dates = new Date[count];
                DateUtil.getDate(dates, datetimes, ms);
                RtdbData rtdbData = null;
                if (numType == RtdbNumType.DoubleNumber) {
                    for (int i = 0; i < count; ++i) {
                        rtdbData = new RtdbData();
                        rtdbData.setDate(dates[i]);
                        rtdbData.setValue(values[i]);
                        rtdbData.setQuality(qualities[i]);
                        rtdbData.setNanosecond(0);
                        rtdbDatas[i] = rtdbData;
                    }
                } else if (numType == RtdbNumType.LongNumber) {
                    for (int i = 0; i < count; ++i) {
                        rtdbData = new RtdbData();
                        rtdbData.setDate(dates[i]);
                        rtdbData.setValue(states[i]);
                        rtdbData.setQuality(qualities[i]);
                        rtdbData.setNanosecond(0);
                        rtdbDatas[i] = rtdbData;
                    }
                }
            }
            return rtdbDatas;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbData[] getArchivedValuesBackward(int id, int count, RtdbType rtdbType, Object dateStart, Object dateEnd) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (id <= 0 || count <= 0 || dateStart == null) {
            throw new InvalidParameterException();
        }
        if (!dateStart.getClass().equals(Date.class) && !dateStart.getClass().equals(DateTimeNS.class) || !dateEnd.getClass().equals(Date.class) && !dateEnd.getClass().equals(DateTimeNS.class) || !dateStart.getClass().equals(dateEnd.getClass())) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_ARCHIVED_VALUES_BACKWARD, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        int datetime1 = 0;
        int datetime2 = 0;
        int ms1 = 0;
        int ms2 = 0;
        boolean flag = true;
        if (dateStart.getClass().equals(Date.class)) {
            datetime1 = DateUtil.getSecond((Date)dateStart);
            ms1 = DateUtil.getMilSecond((Date)dateStart);
            if (dateEnd != null && dateEnd.getClass().equals(Date.class)) {
                datetime2 = DateUtil.getSecond((Date)dateEnd);
                ms2 = DateUtil.getMilSecond((Date)dateEnd);
            }
        } else {
            datetime1 = DateUtil.getSecond(((DateTimeNS)dateStart).getDatetime());
            ms1 = ((DateTimeNS)dateStart).getNanosecond();
            if (dateEnd != null && dateEnd.getClass().equals(DateTimeNS.class)) {
                datetime2 = DateUtil.getSecond(((DateTimeNS)dateEnd).getDatetime());
                ms2 = ((DateTimeNS)dateStart).getNanosecond();
            }
            flag = false;
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            List<RtdbField> fields = this.proto.msgGetArchivedValuesBackwardFields(count, id, datetime1, ms1, datetime2, ms2);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] datetimes = new int[count];
            int[] ms = new int[count];
            double[] values = new double[count];
            long[] states = new long[count];
            short[] qualities = new short[count];
            fields = this.proto.msgGetArchivedValuesBackwardRespFields(datetimes, ms, values, states, qualities);
            this.rtdbServer.getConnection().receivePacket(fields, false);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            RtdbNumType numType = this.getNumberType(rtdbType);
            count = this.getCount(fields);
            RtdbData[] rtdbDatas = new RtdbData[count];
            if (this.version.equals("3")) {
                DatagramHistorian.datagram_get_archived_values_backward_resp.Builder build = DatagramHistorian.datagram_get_archived_values_backward_resp.newBuilder();
                RtdbField rfield = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] bts = (byte[])rfield.getData();
                build.mergeFrom(bts, 4, bts.length - 8);
                if (flag) {
                    if (numType == RtdbNumType.DoubleNumber) {
                        for (int i = 0; i < count; ++i) {
                            RtdbData gd = new RtdbData();
                            gd.setDate(DateUtil.getDate(build.getDatetimesList().get(i), build.getMillisecondsList().get(i)));
                            gd.setValue(build.getValuesList().get(i));
                            gd.setQuality(build.getQualitiesList().get(i).shortValue());
                            gd.setNanosecond(0);
                            rtdbDatas[i] = gd;
                        }
                    } else if (numType == RtdbNumType.LongNumber) {
                        for (int i = 0; i < count; ++i) {
                            RtdbData gd = new RtdbData();
                            gd.setDate(DateUtil.getDate(build.getDatetimesList().get(i), build.getMillisecondsList().get(i)));
                            gd.setValue(build.getStatesList().get(i));
                            gd.setQuality(build.getQualitiesList().get(i).shortValue());
                            gd.setNanosecond(0);
                            rtdbDatas[i] = gd;
                        }
                    }
                } else if (numType == RtdbNumType.DoubleNumber) {
                    for (int i = 0; i < count; ++i) {
                        RtdbData gd = new RtdbData();
                        gd.setDate(DateUtil.getDate(build.getDatetimesList().get(i), 0));
                        gd.setValue(build.getValuesList().get(i));
                        gd.setQuality(build.getQualitiesList().get(i).shortValue());
                        gd.setNanosecond(build.getMillisecondsList().get(i));
                        rtdbDatas[i] = gd;
                    }
                } else if (numType == RtdbNumType.LongNumber) {
                    for (int i = 0; i < count; ++i) {
                        RtdbData gd = new RtdbData();
                        gd.setDate(DateUtil.getDate(build.getDatetimesList().get(i), 0));
                        gd.setValue(build.getStatesList().get(i));
                        gd.setQuality(build.getQualitiesList().get(i).shortValue());
                        gd.setNanosecond(build.getMillisecondsList().get(i));
                        rtdbDatas[i] = gd;
                    }
                }
            } else {
                Date[] dates = new Date[count];
                DateUtil.getDate(dates, datetimes, ms);
                RtdbData rtdbData = null;
                if (numType == RtdbNumType.DoubleNumber) {
                    for (int i = 0; i < count; ++i) {
                        rtdbData = new RtdbData();
                        rtdbData.setDate(dates[i]);
                        rtdbData.setValue(values[i]);
                        rtdbData.setQuality(qualities[i]);
                        rtdbData.setNanosecond(0);
                        rtdbDatas[i] = rtdbData;
                    }
                } else if (numType == RtdbNumType.LongNumber) {
                    for (int i = 0; i < count; ++i) {
                        rtdbData = new RtdbData();
                        rtdbData.setDate(dates[i]);
                        rtdbData.setValue(states[i]);
                        rtdbData.setQuality(qualities[i]);
                        rtdbData.setNanosecond(0);
                        rtdbDatas[i] = rtdbData;
                    }
                }
            }
            return rtdbDatas;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbCoorData[] getArchivedCoorValues(int id, int count, Object dateStart, Object dateEnd) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (id <= 0 || count <= 0 || dateStart == null) {
            throw new InvalidParameterException();
        }
        if (!dateStart.getClass().equals(Date.class) && !dateStart.getClass().equals(DateTimeNS.class) || !dateEnd.getClass().equals(Date.class) && !dateEnd.getClass().equals(DateTimeNS.class) || !dateStart.getClass().equals(dateEnd.getClass())) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_ARCHIVED_COOR_VALUES, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            int datetime1 = 0;
            int datetime2 = 0;
            int ms1 = 0;
            int ms2 = 0;
            boolean flag = true;
            if (dateStart.getClass().equals(Date.class)) {
                datetime1 = DateUtil.getSecond((Date)dateStart);
                ms1 = DateUtil.getMilSecond((Date)dateStart);
                if (dateEnd != null && dateEnd.getClass().equals(Date.class)) {
                    datetime2 = DateUtil.getSecond((Date)dateEnd);
                    ms2 = DateUtil.getMilSecond((Date)dateEnd);
                }
            } else if (dateStart.getClass().equals(DateTimeNS.class)) {
                datetime1 = DateUtil.getSecond(((DateTimeNS)dateStart).getDatetime());
                ms1 = ((DateTimeNS)dateStart).getNanosecond();
                if (dateEnd != null && dateEnd.getClass().equals(DateTimeNS.class)) {
                    datetime2 = DateUtil.getSecond(((DateTimeNS)dateEnd).getDatetime());
                    ms2 = ((DateTimeNS)dateEnd).getNanosecond();
                }
                flag = false;
            }
            List<RtdbField> fields = this.proto.msgGetArchivedCoorValuesFields(count, id, datetime1, ms1, datetime2, ms2);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] datetimes = new int[count];
            int[] ms = new int[count];
            float[] x = new float[count];
            float[] y = new float[count];
            short[] qualities = new short[count];
            fields = this.proto.msgGetArchivedCoorValuesRespFields(datetimes, ms, x, y, qualities);
            this.rtdbServer.getConnection().receivePacket(fields, false);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            count = this.getCount(fields);
            RtdbCoorData[] rtdbCoorDatas = new RtdbCoorData[count];
            RtdbCoorData rtdbCoorData = null;
            if (this.version.equals("3")) {
                DatagramHistorian.datagram_get_archived_coor_values_resp.Builder build = DatagramHistorian.datagram_get_archived_coor_values_resp.newBuilder();
                RtdbField rfield = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] bts = (byte[])rfield.getData();
                build.mergeFrom(bts, 4, bts.length - 8);
                if (flag) {
                    for (int i = 0; i < count; ++i) {
                        rtdbCoorData = new RtdbCoorData();
                        rtdbCoorData.setDate(DateUtil.getDate(build.getDatetimesList().get(i), build.getMillisecondsList().get(i)));
                        rtdbCoorData.setX(build.getXValuesList().get(i).floatValue());
                        rtdbCoorData.setY(build.getYValuesList().get(i).floatValue());
                        rtdbCoorData.setQuality(build.getQualitiesList().get(i).shortValue());
                        rtdbCoorData.setNanosecond(0);
                        rtdbCoorDatas[i] = rtdbCoorData;
                    }
                } else {
                    for (int i = 0; i < count; ++i) {
                        rtdbCoorData = new RtdbCoorData();
                        rtdbCoorData.setDate(DateUtil.getDate(build.getDatetimesList().get(i), 0));
                        rtdbCoorData.setX(build.getXValuesList().get(i).floatValue());
                        rtdbCoorData.setY(build.getYValuesList().get(i).floatValue());
                        rtdbCoorData.setQuality(build.getQualitiesList().get(i).shortValue());
                        rtdbCoorData.setNanosecond(build.getMillisecondsList().get(i));
                        rtdbCoorDatas[i] = rtdbCoorData;
                    }
                }
            } else {
                Date[] dates = new Date[count];
                DateUtil.getDate(dates, datetimes, ms);
                for (int i = 0; i < count; ++i) {
                    rtdbCoorData = new RtdbCoorData();
                    rtdbCoorData.setDate(dates[i]);
                    rtdbCoorData.setX(x[i]);
                    rtdbCoorData.setY(y[i]);
                    rtdbCoorData.setQuality(qualities[i]);
                    rtdbCoorData.setNanosecond(0);
                    rtdbCoorDatas[i] = rtdbCoorData;
                }
            }
            return rtdbCoorDatas;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public RtdbCoorData[] getArchivedCoorValuesBackward(int id, int count, Object dateStart, Object dateEnd) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (id <= 0 || count <= 0 || dateStart == null || dateEnd == null) {
            throw new InvalidParameterException();
        }
        if (!dateStart.getClass().equals(Date.class) && !dateStart.getClass().equals(DateTimeNS.class) || !dateEnd.getClass().equals(Date.class) && !dateEnd.getClass().equals(DateTimeNS.class) || !dateStart.getClass().equals(dateEnd.getClass())) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_ARCHIVED_COOR_VALUES_BACKWARD, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            int datetime1 = 0;
            int ms1 = 0;
            int datetime2 = 0;
            int ms2 = 0;
            boolean flag = true;
            if (dateStart.getClass().equals(Date.class) && dateEnd.getClass().equals(Date.class)) {
                datetime1 = DateUtil.getSecond((Date)dateStart);
                ms1 = DateUtil.getMilSecond((Date)dateStart);
                datetime2 = DateUtil.getSecond((Date)dateEnd);
                ms2 = DateUtil.getMilSecond((Date)dateEnd);
            } else if (dateStart.getClass().equals(DateTimeNS.class) && dateEnd.getClass().equals(DateTimeNS.class)) {
                datetime1 = DateUtil.getSecond(((DateTimeNS)dateStart).getDatetime());
                ms1 = ((DateTimeNS)dateStart).getNanosecond();
                datetime2 = DateUtil.getSecond(((DateTimeNS)dateEnd).getDatetime());
                ms2 = ((DateTimeNS)dateStart).getNanosecond();
                flag = false;
            } else {
                throw new InvalidParameterException();
            }
            List<RtdbField> fields = this.proto.msgGetArchivedCoorValuesBackwardFields(count, id, datetime1, ms1, datetime2, ms2);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] datetimes = new int[count];
            int[] ms = new int[count];
            float[] x = new float[count];
            float[] y = new float[count];
            short[] qualities = new short[count];
            fields = this.proto.msgGetArchivedCoorValuesBackwardRespFields(count, datetimes, ms, x, y, qualities);
            this.rtdbServer.getConnection().receivePacket(fields, false);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            count = this.getCount(fields);
            RtdbCoorData[] rtdbCoorDatas = new RtdbCoorData[count];
            RtdbCoorData rtdbCoorData = null;
            if (this.version.equals("3")) {
                DatagramHistorian.datagram_get_archived_coor_values_backward_resp.Builder build = DatagramHistorian.datagram_get_archived_coor_values_backward_resp.newBuilder();
                RtdbField rfield = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] bts = (byte[])rfield.getData();
                build.mergeFrom(bts, 4, bts.length - 8);
                if (flag) {
                    for (int i = 0; i < count; ++i) {
                        rtdbCoorData = new RtdbCoorData();
                        rtdbCoorData.setDate(DateUtil.getDate(build.getDatetimes(i), build.getMilliseconds(i)));
                        rtdbCoorData.setX(build.getXValues(i));
                        rtdbCoorData.setY(build.getYValues(i));
                        rtdbCoorData.setQuality((short)build.getQualities(i));
                        rtdbCoorData.setNanosecond(0);
                        rtdbCoorDatas[i] = rtdbCoorData;
                    }
                } else {
                    for (int i = 0; i < count; ++i) {
                        rtdbCoorData = new RtdbCoorData();
                        rtdbCoorData.setDate(DateUtil.getDate(build.getDatetimes(i), 0));
                        rtdbCoorData.setX(build.getXValues(i));
                        rtdbCoorData.setY(build.getYValues(i));
                        rtdbCoorData.setQuality((short)build.getQualities(i));
                        rtdbCoorData.setNanosecond(build.getMilliseconds(i));
                        rtdbCoorDatas[i] = rtdbCoorData;
                    }
                }
            } else {
                Date[] dates = new Date[count];
                DateUtil.getDate(dates, datetimes, ms);
                for (int i = 0; i < count; ++i) {
                    rtdbCoorData = new RtdbCoorData();
                    rtdbCoorData.setDate(dates[i]);
                    rtdbCoorData.setX(x[i]);
                    rtdbCoorData.setY(y[i]);
                    rtdbCoorData.setQuality(qualities[i]);
                    rtdbCoorData.setNanosecond(0);
                    rtdbCoorDatas[i] = rtdbCoorData;
                }
            }
            return rtdbCoorDatas;
        }
    }

    @Override
    public int getArchivedValuesBatchCount(int id, Object dateStart, Object dateEnd) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (id == 0) {
            throw new InvalidParameterException();
        }
        if (!dateStart.getClass().equals(Date.class) && !dateStart.getClass().equals(DateTimeNS.class) || !dateEnd.getClass().equals(Date.class) && !dateEnd.getClass().equals(DateTimeNS.class) || !dateStart.getClass().equals(dateEnd.getClass())) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_ARCHIVED_VALUES_IN_BATCHES, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            int datetime1_temp = 0;
            int ms1_temp = 0;
            int datetime2_temp = 0;
            int ms2_temp = 0;
            if (dateStart != null) {
                if (dateStart.getClass().equals(Date.class)) {
                    datetime1_temp = DateUtil.getSecond((Date)dateStart);
                    ms1_temp = DateUtil.getMilSecond((Date)dateStart);
                } else {
                    datetime1_temp = DateUtil.getSecond(((DateTimeNS)dateStart).getDatetime());
                    ms1_temp = ((DateTimeNS)dateStart).getNanosecond();
                }
            }
            if (dateEnd != null) {
                if (dateEnd.getClass().equals(Date.class)) {
                    datetime2_temp = DateUtil.getSecond((Date)dateEnd);
                    ms2_temp = DateUtil.getMilSecond((Date)dateEnd);
                } else {
                    datetime2_temp = DateUtil.getSecond(((DateTimeNS)dateEnd).getDatetime());
                    ms2_temp = ((DateTimeNS)dateEnd).getNanosecond();
                }
            }
            List<RtdbField> fields = this.proto.msgGetArchivedValuesBatchCountFields(id, datetime1_temp, ms1_temp, datetime2_temp, ms2_temp);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetArchivedValuesBatchCountRespFields(0);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret.equals(RtdbError.GoE_OK)) {
                return (int)fields.get(RtdbGlobalEnum.FIELD_CNT.getNum()).getIvalue();
            }
            throw new Exception(ret.toString());
        }
    }

    @Override
    public RtdbData[] getNextArchivedValues(int id, int count, RtdbType rtdbType) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (id == 0 || count == 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_NEXT_ARCHIVED_VALUES, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgGetNextArchivedValuesFields(count, id);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] datetimes = new int[count];
            int[] ms = new int[count];
            double[] values = new double[count];
            long[] states = new long[count];
            short[] qualities = new short[count];
            fields = this.proto.msgGetNextArchivedValuesRespFields(count, datetimes, ms, values, states, qualities);
            this.rtdbServer.getConnection().receivePacket(fields, false);
            RtdbError ret = this.getRet(fields);
            if (ret.equals(RtdbError.GoE_OK) || ret.equals(RtdbError.GoE_BATCH_END)) {
                count = this.getCount(fields);
                Date[] dates = new Date[count];
                DateUtil.getDate(dates, datetimes, ms);
                RtdbData[] rtdbDatas = new RtdbData[count];
                RtdbData rtdbData = null;
                RtdbNumType numType = this.getNumberType(rtdbType);
                if (numType == RtdbNumType.DoubleNumber) {
                    for (int i = 0; i < count; ++i) {
                        rtdbData = new RtdbData();
                        rtdbData.setValue(values[i]);
                        rtdbData.setQuality(qualities[i]);
                        rtdbData.setDate(dates[i]);
                        rtdbData.setNanosecond(0);
                        rtdbData.setRtdbType(rtdbType);
                        rtdbDatas[i] = rtdbData;
                    }
                } else if (numType == RtdbNumType.LongNumber) {
                    for (int i = 0; i < count; ++i) {
                        rtdbData = new RtdbData();
                        rtdbData.setValue(states[i]);
                        rtdbData.setQuality(qualities[i]);
                        rtdbData.setDate(dates[i]);
                        rtdbData.setNanosecond(0);
                        rtdbData.setRtdbType(rtdbType);
                        rtdbDatas[i] = rtdbData;
                    }
                }
                return rtdbDatas;
            }
            throw new Exception(ret.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbCoorData getSingleCoorValue(int id, Object date, HisMode rtdbHisMode) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        int mode = rtdbHisMode.getNum();
        if (id == 0 || mode < HisMode.NEXT.getNum() || mode > HisMode.INTER.getNum() || date == null) {
            throw new InvalidParameterException();
        }
        if (!date.getClass().equals(Date.class) && !date.getClass().equals(DateTimeNS.class)) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_SINGLE_COOR_VALUE, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            int datetime = 0;
            int ms = 0;
            boolean flag = true;
            if (date.getClass().equals(Date.class)) {
                datetime = DateUtil.getSecond((Date)date);
                ms = DateUtil.getMilSecond((Date)date);
            } else {
                datetime = DateUtil.getSecond(((DateTimeNS)date).getDatetime());
                ms = ((DateTimeNS)date).getNanosecond();
                flag = false;
            }
            List<RtdbField> fields = this.proto.msgGetSingleCoorValueFields(id, mode, datetime, ms);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetSingleCoorValueRespFields();
            this.rtdbServer.getConnection().receivePacket(fields, true);
            int field_dt = RtdbGlobalEnum.FIELD_NEXT.getNum();
            int field_ms = field_dt + 1;
            int field_x = field_ms + 1;
            int field_y = field_x + 1;
            int field_q = field_y + 1;
            RtdbError ret = this.getRet(fields);
            RtdbCoorData rtdbCoorData = new RtdbCoorData();
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            if (this.version.equals("3")) {
                DatagramHistorian.datagram_get_single_coor_value_resp.Builder build = DatagramHistorian.datagram_get_single_coor_value_resp.newBuilder();
                RtdbField rfield = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] bts = (byte[])rfield.getData();
                build.mergeFrom(bts, 4, bts.length - 8);
                if (flag) {
                    rtdbCoorData.setDate(DateUtil.getDate(build.getDatetime(), build.getMillisecond()));
                    rtdbCoorData.setX(build.getXValue());
                    rtdbCoorData.setY(build.getYValue());
                    rtdbCoorData.setQuality((short)build.getQuality());
                    rtdbCoorData.setNanosecond(0);
                } else {
                    rtdbCoorData.setDate(DateUtil.getDate(build.getDatetime(), build.getMillisecond()));
                    rtdbCoorData.setX(build.getXValue());
                    rtdbCoorData.setY(build.getYValue());
                    rtdbCoorData.setQuality((short)build.getQuality());
                    rtdbCoorData.setNanosecond(build.getMillisecond());
                }
            } else {
                int datetime_second = (int)fields.get(field_dt).getIvalue();
                short mil_sencond = (short)fields.get(field_ms).getIvalue();
                date = DateUtil.getDate(datetime_second, mil_sencond);
                rtdbCoorData.setDate((Date)date);
                rtdbCoorData.setX((float)fields.get(field_x).getFvalue());
                rtdbCoorData.setY((float)fields.get(field_y).getFvalue());
                rtdbCoorData.setQuality((short)fields.get(field_q).getIvalue());
                rtdbCoorData.setNanosecond(0);
            }
            return rtdbCoorData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbBlobData getSingleBlobValue(int id, Object date, HisMode rtdbHisMode, short len) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        int mode = rtdbHisMode.getNum();
        if (id == 0 || date == null || mode < HisMode.NEXT.getNum() || mode > HisMode.EXACT.getNum() || date == null || len == 0) {
            throw new InvalidParameterException();
        }
        if (!date.getClass().equals(Date.class) && !date.getClass().equals(DateTimeNS.class)) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_SINGLE_BLOB_VALUE, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            RtdbBlobData rtdbRtdbBlobData;
            int datetime = 0;
            int ms = 0;
            boolean flag = true;
            if (date.getClass().equals(Date.class)) {
                datetime = DateUtil.getSecond((Date)date);
                ms = DateUtil.getMilSecond((Date)date);
            } else {
                datetime = DateUtil.getSecond(((DateTimeNS)date).getDatetime());
                ms = ((DateTimeNS)date).getNanosecond();
                flag = false;
            }
            List<RtdbField> fields = this.proto.msgGetSingleBlobValueFields(len, id, mode, datetime, ms);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            byte[] blob = new byte[len];
            fields = this.proto.msgGetSingleBlobValueRespFields(blob);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            if (this.version.equals("3")) {
                DatagramHistorian.datagram_get_single_blob_value_resp.Builder build = DatagramHistorian.datagram_get_single_blob_value_resp.newBuilder();
                RtdbField rfield = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                rtdbRtdbBlobData = new RtdbBlobData(this.getCount(fields));
                byte[] bts = (byte[])rfield.getData();
                build.mergeFrom(bts, 4, bts.length - 8);
                if (flag) {
                    rtdbRtdbBlobData.setBlob(build.getBlob().toByteArray());
                    rtdbRtdbBlobData.setId(id);
                    rtdbRtdbBlobData.setDatetime(DateUtil.getDate(build.getDatetime(), build.getMillisecond()));
                    rtdbRtdbBlobData.setQuality((short)build.getQuality());
                    rtdbRtdbBlobData.setNanosecond(0);
                } else {
                    rtdbRtdbBlobData.setBlob(build.getBlob().toByteArray());
                    rtdbRtdbBlobData.setId(id);
                    rtdbRtdbBlobData.setDatetime(DateUtil.getDate(build.getDatetime(), 0));
                    rtdbRtdbBlobData.setQuality((short)build.getQuality());
                    rtdbRtdbBlobData.setNanosecond(build.getMillisecond());
                }
            } else {
                int field_dt = RtdbGlobalEnum.FIELD_NEXT.getNum();
                int field_ms = field_dt + 1;
                int field_blob = field_ms + 1;
                int field_q = field_blob + 1;
                short len_ret = (short)this.getCount(fields);
                rtdbRtdbBlobData = new RtdbBlobData(len_ret);
                byte[] blob_ret = new byte[len_ret];
                System.arraycopy(blob, 0, blob_ret, 0, len_ret);
                rtdbRtdbBlobData.setBlob(blob);
                rtdbRtdbBlobData.setId(id);
                int datetime_second = (int)fields.get(field_dt).getIvalue();
                short mil_second = (short)fields.get(field_ms).getIvalue();
                rtdbRtdbBlobData.setDatetime(DateUtil.getDate(datetime_second, mil_second));
                rtdbRtdbBlobData.setQuality((short)fields.get(field_q).getIvalue());
                rtdbRtdbBlobData.setLen(len_ret);
                rtdbRtdbBlobData.setNanosecond(0);
            }
            return rtdbRtdbBlobData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbData[] getTimedValues(int id, RtdbType rtdbType, int count, Object[] datetimes) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (id == 0 || count == 0 || datetimes.length != count) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_TIMED_VALUES, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            RtdbData[] rtdbDatas;
            int[] datetime = new int[datetimes.length];
            int[] ms = new int[datetimes.length];
            boolean flag = true;
            if (datetimes[0].getClass().equals(Date.class)) {
                datetime = DateUtil.getSecond((Date[])datetimes);
                ms = DateUtil.getMilSecond((Date[])datetimes);
            } else if (datetimes[0].getClass().equals(DateTimeNS.class)) {
                for (int i = 0; i < datetimes.length; ++i) {
                    datetime[i] = DateUtil.getSecond(((DateTimeNS[])datetimes)[i].getDatetime());
                    ms[i] = ((DateTimeNS[])datetimes)[i].getNanosecond();
                }
                flag = false;
            } else {
                throw new InvalidParameterException();
            }
            List<RtdbField> fields = this.proto.msgGetTimedValuesFields(count, id, datetime, ms);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            double[] values = new double[count];
            long[] states = new long[count];
            short[] qualities = new short[count];
            fields = this.proto.msgGetTimedValuesRespFields(values, states, qualities);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            if (this.version.equals("3")) {
                DatagramHistorian.datagram_get_timed_values_resp.Builder build = DatagramHistorian.datagram_get_timed_values_resp.newBuilder();
                RtdbField rField = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] bts = (byte[])rField.getData();
                build.mergeFrom(bts, 4, bts.length - 8);
                rtdbDatas = new RtdbData[count];
                RtdbData rtdbData = null;
                if (flag) {
                    for (int i = 0; i < count; ++i) {
                        rtdbData = new RtdbData();
                        rtdbData.setId(id);
                        rtdbData.setDate(datetimes[i]);
                        rtdbData.setQuality(build.getQualitiesList().get(i).shortValue());
                        rtdbData.setValue(build.getValuesList().get(i));
                        rtdbData.setState(build.getStatesList().get(i));
                        rtdbData.setNanosecond(0);
                        rtdbDatas[i] = rtdbData;
                    }
                } else {
                    for (int i = 0; i < count; ++i) {
                        rtdbData = new RtdbData();
                        rtdbData.setId(id);
                        rtdbData.setDate(((DateTimeNS)datetimes[i]).getDatetime());
                        rtdbData.setQuality(build.getQualitiesList().get(i).shortValue());
                        rtdbData.setValue(build.getValuesList().get(i));
                        rtdbData.setState(build.getStatesList().get(i));
                        rtdbData.setNanosecond(ms[i]);
                        rtdbDatas[i] = rtdbData;
                    }
                }
            } else {
                rtdbDatas = new RtdbData[count];
                RtdbData rtdbData = null;
                RtdbNumType numType = this.getNumberType(rtdbType);
                if (numType == RtdbNumType.DoubleNumber) {
                    for (int i = 0; i < count; ++i) {
                        rtdbData = new RtdbData();
                        rtdbData.setDate(datetimes[i]);
                        rtdbData.setQuality(qualities[i]);
                        rtdbData.setValue(values[i]);
                        rtdbData.setNanosecond(0);
                        rtdbDatas[i] = rtdbData;
                    }
                } else if (numType == RtdbNumType.LongNumber) {
                    for (int i = 0; i < count; ++i) {
                        rtdbData = new RtdbData();
                        rtdbData.setDate(datetimes[i]);
                        rtdbData.setQuality(qualities[i]);
                        rtdbData.setValue(states[i]);
                        rtdbData.setNanosecond(0);
                        rtdbDatas[i] = rtdbData;
                    }
                }
            }
            return rtdbDatas;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbCoorData[] getTimedCoorValues(int id, Object[] datetimes) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (id == 0 || datetimes == null) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_TIMED_COOR_VALUES, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        int count = datetimes.length;
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            RtdbCoorData[] datas;
            int[] datetime = new int[count];
            int[] ms = new int[count];
            boolean flag = true;
            if (datetimes[0].getClass().equals(Date.class)) {
                datetime = DateUtil.getSecond((Date[])datetimes);
                ms = DateUtil.getMilSecond((Date[])datetimes);
            } else if (datetimes[0].getClass().equals(DateTimeNS.class)) {
                for (int i = 0; i < ((DateTimeNS[])datetimes).length; ++i) {
                    datetime[i] = DateUtil.getSecond(((DateTimeNS[])datetimes)[i].getDatetime());
                    ms[i] = ((DateTimeNS[])datetimes)[i].getNanosecond();
                }
                flag = false;
            } else {
                throw new InvalidParameterException();
            }
            List<RtdbField> fields = this.proto.msgGetTimedCoorValuesFields(count, id, datetime, ms);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            float[] x = new float[count];
            float[] y = new float[count];
            short[] qualities = new short[count];
            fields = this.proto.msgGetTimedCoorValuesRespFields(count, x, y, qualities);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            if (this.version.equals("3")) {
                DatagramHistorian.datagram_get_timed_coor_values_resp.Builder build = DatagramHistorian.datagram_get_timed_coor_values_resp.newBuilder();
                RtdbField rField = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] bts = (byte[])rField.getData();
                build.mergeFrom(bts, 4, bts.length - 8);
                datas = new RtdbCoorData[count];
                RtdbCoorData data = null;
                if (flag) {
                    for (int i = 0; i < count; ++i) {
                        data = new RtdbCoorData();
                        data.setId(id);
                        data.setDate((Date)datetimes[i]);
                        data.setX(build.getXValues(i));
                        data.setY(build.getYValues(i));
                        data.setQuality((short)build.getQualities(i));
                        data.setNanosecond(0);
                        datas[i] = data;
                    }
                } else {
                    for (int i = 0; i < count; ++i) {
                        data = new RtdbCoorData();
                        data.setId(id);
                        data.setDate(((DateTimeNS)datetimes[i]).getDatetime());
                        data.setX(build.getXValues(i));
                        data.setY(build.getYValues(i));
                        data.setQuality((short)build.getQualities(i));
                        data.setNanosecond(ms[i]);
                        datas[i] = data;
                    }
                }
            } else {
                datas = new RtdbCoorData[count];
                RtdbCoorData data = null;
                for (int i = 0; i < count; ++i) {
                    data = new RtdbCoorData();
                    data.setDate((Date)datetimes[i]);
                    data.setX(x[i]);
                    data.setY(y[i]);
                    data.setQuality(qualities[i]);
                    data.setNanosecond(0);
                    datas[i] = data;
                }
            }
            return datas;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbData[] getInterpoValues(int id, RtdbType rtdbType, int count, Object dateStart, Object dateEnd) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (id == 0 || rtdbType == null || count == 0 || dateStart == null) {
            throw new InvalidParameterException();
        }
        if (!dateStart.getClass().equals(Date.class) && !dateStart.getClass().equals(DateTimeNS.class) || !dateEnd.getClass().equals(Date.class) && !dateEnd.getClass().equals(DateTimeNS.class) || !dateStart.getClass().equals(dateEnd.getClass())) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_INTERPO_VALUES, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            int datetime1 = 0;
            int ms1 = 0;
            int datetime2 = 0;
            int ms2 = 0;
            boolean flag = true;
            if (dateStart.getClass().equals(Date.class)) {
                datetime1 = DateUtil.getSecond((Date)dateStart);
                ms1 = DateUtil.getMilSecond((Date)dateStart);
                if (dateEnd != null && dateEnd.getClass().equals(Date.class)) {
                    datetime2 = DateUtil.getSecond((Date)dateEnd);
                    ms2 = DateUtil.getMilSecond((Date)dateEnd);
                }
            } else {
                datetime1 = DateUtil.getSecond(((DateTimeNS)dateStart).getDatetime());
                ms1 = ((DateTimeNS)dateStart).getNanosecond();
                if (dateEnd != null && dateEnd.getClass().equals(DateTimeNS.class)) {
                    datetime2 = DateUtil.getSecond(((DateTimeNS)dateEnd).getDatetime());
                    ms2 = ((DateTimeNS)dateEnd).getNanosecond();
                }
                flag = false;
            }
            List<RtdbField> fields = this.proto.msgGetInterPoValuesFields(count, id, datetime1, ms1, datetime2, ms2);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] datetimes = new int[count];
            int[] ms = new int[count];
            double[] values = new double[count];
            long[] states = new long[count];
            short[] qualities = new short[count];
            fields = this.proto.msgGetInterPoValuesRespFields(datetimes, ms, values, states, qualities);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            count = this.getCount(fields);
            RtdbData[] datas = new RtdbData[count];
            if (this.version.equals("3")) {
                DatagramHistorian.datagram_get_interpo_values_resp.Builder build = DatagramHistorian.datagram_get_interpo_values_resp.newBuilder();
                RtdbField rfield = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] bts = (byte[])rfield.getData();
                build.mergeFrom(bts, 4, bts.length - 8);
                RtdbData data = null;
                RtdbNumType rtdbNumType = this.getNumberType(rtdbType);
                if (flag) {
                    if (rtdbNumType == RtdbNumType.DoubleNumber) {
                        for (int i = 0; i < count; ++i) {
                            data = new RtdbData();
                            data.setDate(DateUtil.getDate(build.getDatetimesList().get(i), build.getMillisecondsList().get(i).shortValue()));
                            data.setQuality(build.getQualitiesList().get(i).shortValue());
                            data.setValue(build.getValuesList().get(i));
                            data.setNanosecond(0);
                            datas[i] = data;
                        }
                    } else if (rtdbNumType == RtdbNumType.LongNumber) {
                        for (int i = 0; i < count; ++i) {
                            data = new RtdbData();
                            data.setDate(DateUtil.getDate(build.getDatetimesList().get(i), build.getMillisecondsList().get(i)));
                            data.setQuality(build.getQualitiesList().get(i).shortValue());
                            data.setState(build.getStatesList().get(i));
                            data.setValue(build.getStatesList().get(i));
                            data.setNanosecond(0);
                            datas[i] = data;
                        }
                    }
                } else if (rtdbNumType == RtdbNumType.DoubleNumber) {
                    for (int i = 0; i < count; ++i) {
                        data = new RtdbData();
                        data.setDate(DateUtil.getDate(build.getDatetimesList().get(i), 0));
                        data.setQuality(build.getQualitiesList().get(i).shortValue());
                        data.setValue(build.getValuesList().get(i));
                        data.setNanosecond(build.getMillisecondsList().get(i));
                        datas[i] = data;
                    }
                } else if (rtdbNumType == RtdbNumType.LongNumber) {
                    for (int i = 0; i < count; ++i) {
                        data = new RtdbData();
                        data.setDate(DateUtil.getDate(build.getDatetimesList().get(i), 0));
                        data.setQuality(build.getQualitiesList().get(i).shortValue());
                        data.setState(build.getStatesList().get(i));
                        data.setValue(build.getStatesList().get(i));
                        data.setNanosecond(build.getMillisecondsList().get(i));
                        datas[i] = data;
                    }
                }
            } else {
                Date[] dates = new Date[count];
                DateUtil.getDate(dates, datetimes, ms);
                double[] values_ret = new double[count];
                long[] states_ret = new long[count];
                short[] qualities_ret = new short[count];
                System.arraycopy(values, 0, values_ret, 0, count);
                System.arraycopy(states, 0, states_ret, 0, count);
                System.arraycopy(qualities, 0, qualities_ret, 0, count);
                RtdbData data = null;
                RtdbNumType rtdbNumType = this.getNumberType(rtdbType);
                if (rtdbNumType == RtdbNumType.DoubleNumber) {
                    for (int i = 0; i < count; ++i) {
                        data = new RtdbData();
                        data.setDate(dates[i]);
                        data.setQuality(qualities[i]);
                        data.setValue(values_ret[i]);
                        data.setNanosecond(0);
                        datas[i] = data;
                    }
                } else if (rtdbNumType == RtdbNumType.LongNumber) {
                    for (int i = 0; i < count; ++i) {
                        data = new RtdbData();
                        data.setDate(dates[i]);
                        data.setQuality(qualities[i]);
                        data.setValue(states_ret[i]);
                        data.setNanosecond(0);
                        datas[i] = data;
                    }
                }
            }
            return datas;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbData[] getIntervalValues(int id, RtdbType rtdbType, long interval, int count, Object date) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (id == 0 || rtdbType == null || interval == 0L || count == 0 || date == null) {
            throw new InvalidParameterException();
        }
        if (!date.getClass().equals(Date.class) && !date.getClass().equals(DateTimeNS.class)) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_INTERVAL_VALUES, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            int datetime = 0;
            int ms = 0;
            boolean flag = true;
            if (date.getClass().equals(Date.class)) {
                datetime = DateUtil.getSecond((Date)date);
                ms = DateUtil.getMilSecond((Date)date);
            } else {
                datetime = DateUtil.getSecond(((DateTimeNS)date).getDatetime());
                ms = ((DateTimeNS)date).getNanosecond();
                flag = false;
            }
            List<RtdbField> fields = this.proto.msgGetIntervalValuesFields(count, id, interval, datetime, ms);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] datetimes = new int[count];
            int[] mss = new int[count];
            double[] values = new double[count];
            long[] states = new long[count];
            short[] qualities = new short[count];
            fields = this.proto.msgGetIntervalValuesRespFields(count, datetimes, mss, values, states, qualities);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            count = this.getCount(fields);
            RtdbData[] datas = new RtdbData[count];
            if (this.version.equals("3")) {
                DatagramHistorian.datagram_get_interval_values_resp.Builder build = DatagramHistorian.datagram_get_interval_values_resp.newBuilder();
                RtdbField rfield = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] bts = (byte[])rfield.getData();
                build.mergeFrom(bts, 4, bts.length - 8);
                RtdbData data = null;
                RtdbNumType rtdbNumType = this.getNumberType(rtdbType);
                if (flag) {
                    if (rtdbNumType == RtdbNumType.DoubleNumber) {
                        for (int i = 0; i < count; ++i) {
                            data = new RtdbData();
                            data.setDate(DateUtil.getDate(build.getDatetimesList().get(i), build.getMillisecondsList().get(i)));
                            data.setQuality(build.getQualitiesList().get(i).shortValue());
                            data.setValue(build.getValuesList().get(i));
                            data.setNanosecond(0);
                            datas[i] = data;
                        }
                    } else if (rtdbNumType == RtdbNumType.LongNumber) {
                        for (int i = 0; i < count; ++i) {
                            data = new RtdbData();
                            data.setDate(DateUtil.getDate(build.getDatetimesList().get(i), build.getMillisecondsList().get(i)));
                            data.setQuality(build.getQualitiesList().get(i).shortValue());
                            data.setValue(build.getStatesList().get(i));
                            data.setNanosecond(0);
                            datas[i] = data;
                        }
                    }
                } else if (rtdbNumType == RtdbNumType.DoubleNumber) {
                    for (int i = 0; i < count; ++i) {
                        data = new RtdbData();
                        data.setDate(DateUtil.getDate(build.getDatetimesList().get(i), 0));
                        data.setQuality(build.getQualitiesList().get(i).shortValue());
                        data.setValue(build.getValuesList().get(i));
                        data.setNanosecond(build.getMillisecondsList().get(i));
                        datas[i] = data;
                    }
                } else if (rtdbNumType == RtdbNumType.LongNumber) {
                    for (int i = 0; i < count; ++i) {
                        data = new RtdbData();
                        data.setDate(DateUtil.getDate(build.getDatetimesList().get(i), 0));
                        data.setQuality(build.getQualitiesList().get(i).shortValue());
                        data.setValue(build.getStatesList().get(i));
                        data.setNanosecond(build.getMillisecondsList().get(i));
                        datas[i] = data;
                    }
                }
            } else {
                Date[] dates = new Date[count];
                DateUtil.getDate(dates, datetimes, mss);
                double[] values_ret = new double[count];
                long[] states_ret = new long[count];
                short[] qualities_ret = new short[count];
                System.arraycopy(values, 0, values_ret, 0, count);
                System.arraycopy(states, 0, states_ret, 0, count);
                System.arraycopy(qualities, 0, qualities_ret, 0, count);
                RtdbData data = null;
                RtdbNumType rtdbNumType = this.getNumberType(rtdbType);
                if (rtdbNumType == RtdbNumType.DoubleNumber) {
                    for (int i = 0; i < count; ++i) {
                        data = new RtdbData();
                        data.setDate(dates[i]);
                        data.setQuality(qualities[i]);
                        data.setValue(values_ret[i]);
                        data.setNanosecond(0);
                        datas[i] = data;
                    }
                } else if (rtdbNumType == RtdbNumType.LongNumber) {
                    for (int i = 0; i < count; ++i) {
                        data = new RtdbData();
                        data.setDate(dates[i]);
                        data.setQuality(qualities[i]);
                        data.setValue(states_ret[i]);
                        data.setNanosecond(0);
                        datas[i] = data;
                    }
                }
            }
            return datas;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbSummaryData getSummary(int id, Object beginTime, Object endTime) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (id <= 0) {
            throw new InvalidParameterException();
        }
        if (!beginTime.getClass().equals(Date.class) && !beginTime.getClass().equals(DateTimeNS.class) || !endTime.getClass().equals(Date.class) && !endTime.getClass().equals(DateTimeNS.class) || !beginTime.getClass().equals(endTime.getClass())) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_SUMMARY, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        int datetime1 = 0;
        int ms1 = 0;
        int datetime2 = 0;
        int ms2 = 0;
        boolean flag = true;
        if (beginTime != null) {
            if (beginTime.getClass().equals(Date.class)) {
                datetime1 = DateUtil.getSecond((Date)beginTime);
                ms1 = DateUtil.getMilSecond((Date)beginTime);
            } else {
                datetime1 = DateUtil.getSecond(((DateTimeNS)beginTime).getDatetime());
                ms1 = ((DateTimeNS)beginTime).getNanosecond();
                flag = false;
            }
        }
        if (endTime != null) {
            if (endTime.getClass().equals(Date.class)) {
                datetime2 = DateUtil.getSecond((Date)endTime);
                ms2 = DateUtil.getMilSecond((Date)endTime);
            } else {
                datetime2 = DateUtil.getSecond(((DateTimeNS)endTime).getDatetime());
                ms2 = ((DateTimeNS)endTime).getNanosecond();
                flag = false;
            }
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            List<RtdbField> fields = this.proto.msgSummaryFields(id, datetime1, ms1, datetime2, ms2);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgSummaryRespFields(0, 0, (short)0, 0, (short)0, 0.0, 0.0, 0.0, 0.0, 0.0);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            RtdbSummaryData data = new RtdbSummaryData();
            if (this.version.equals("3")) {
                DatagramHistorian.datagram_summary_resp.Builder build = DatagramHistorian.datagram_summary_resp.newBuilder();
                RtdbField rfield = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] bts = (byte[])rfield.getData();
                build.mergeFrom(bts, 4, bts.length - 8);
                if (flag) {
                    data.setMaxValueTime(DateUtil.getDate(build.getBeginDatetime(), build.getBeginMillisecond()));
                    data.setMinValueTime(DateUtil.getDate(build.getEndDatetime(), build.getEndMillisecond()));
                    data.setMaxValue(build.getMaxValue());
                    data.setMinValue(build.getMinValue());
                    data.setTotalValue(build.getTotolValue());
                    data.setCalcAvg(build.getCalcAvg());
                    data.setPowerAvg(build.getPowerAvg());
                    data.setMaxValueNanosecond(0);
                    data.setMinValueNanosecond(0);
                } else {
                    data.setMaxValueTime(DateUtil.getDate(build.getBeginDatetime(), 0));
                    data.setMinValueTime(DateUtil.getDate(build.getEndDatetime(), 0));
                    data.setMaxValue(build.getMaxValue());
                    data.setMinValue(build.getMinValue());
                    data.setTotalValue(build.getTotolValue());
                    data.setCalcAvg(build.getCalcAvg());
                    data.setPowerAvg(build.getPowerAvg());
                    data.setMaxValueNanosecond(build.getBeginMillisecond());
                    data.setMinValueNanosecond(build.getEndMillisecond());
                }
            } else {
                int field_dt1 = 16;
                int field_ms1 = 17;
                int field_dt2 = 18;
                int field_ms2 = 19;
                int field_max = 20;
                int field_min = 21;
                int field_total = 22;
                int field_calc = 23;
                int field_power = 24;
                datetime1 = (int)fields.get(field_dt1).getIvalue();
                ms1 = (short)fields.get(field_ms1).getIvalue();
                datetime2 = (int)fields.get(field_dt2).getIvalue();
                ms2 = (short)fields.get(field_ms2).getIvalue();
                data.setMaxValueTime(DateUtil.getDate(datetime1, ms1));
                data.setMinValueTime(DateUtil.getDate(datetime2, ms2));
                data.setMaxValue(fields.get(field_max).getFvalue());
                data.setMinValue(fields.get(field_min).getFvalue());
                data.setTotalValue(fields.get(field_total).getFvalue());
                data.setCalcAvg(fields.get(field_calc).getFvalue());
                data.setPowerAvg(fields.get(field_power).getFvalue());
                data.setMaxValueNanosecond(0);
                data.setMinValueNanosecond(0);
            }
            return data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbSummaryData getSummaryEx(int id, Date beginTime, Date endTime) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (id <= 0) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_SUMMARY_EX, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        int datetime1 = 0;
        short ms1 = 0;
        int datetime2 = 0;
        short ms2 = 0;
        if (beginTime != null) {
            datetime1 = DateUtil.getSecond(beginTime);
            ms1 = DateUtil.getMilSecond(beginTime);
        }
        if (endTime != null) {
            datetime2 = DateUtil.getSecond(endTime);
            ms2 = DateUtil.getMilSecond(endTime);
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            List<RtdbField> fields = this.proto.msgSummaryExFields(id, datetime1, ms1, datetime2, ms2);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgSummaryExRespFields(0, 0, (short)0, 0, (short)0, 0.0, 0.0, 0.0, 0.0, 0.0, 0L);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            int field_dt1 = 16;
            int field_ms1 = 17;
            int field_dt2 = 18;
            int field_ms2 = 19;
            int field_max = 20;
            int field_min = 21;
            int field_total = 22;
            int field_calc = 23;
            int field_power = 24;
            datetime1 = (int)fields.get(field_dt1).getIvalue();
            ms1 = (short)fields.get(field_ms1).getIvalue();
            datetime2 = (int)fields.get(field_dt2).getIvalue();
            ms2 = (short)fields.get(field_ms2).getIvalue();
            RtdbSummaryData data = new RtdbSummaryData();
            data.setMaxValueTime(DateUtil.getDate(datetime1, ms1));
            data.setMinValueTime(DateUtil.getDate(datetime2, ms2));
            data.setMaxValue(fields.get(field_max).getFvalue());
            data.setMinValue(fields.get(field_min).getFvalue());
            data.setTotalValue(fields.get(field_total).getFvalue());
            data.setCalcAvg(fields.get(field_calc).getFvalue());
            data.setPowerAvg(fields.get(field_power).getFvalue());
            return data;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbSummaryData[] getSummaryInBatches(int id, int count, long interval, Object dateStart, Object dateEnd) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        if (id <= 0 || count <= 0 || interval <= 0L) {
            throw new InvalidParameterException();
        }
        if (!dateStart.getClass().equals(Date.class) && !dateStart.getClass().equals(DateTimeNS.class) || !dateEnd.getClass().equals(Date.class) && !dateEnd.getClass().equals(DateTimeNS.class) || !dateStart.getClass().equals(dateEnd.getClass())) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_SUMMARY_IN_BATCHES, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        int datetime1 = 0;
        int ms1 = 0;
        int datetime2 = 0;
        int ms2 = 0;
        boolean flag = true;
        if (dateStart != null) {
            if (dateStart.getClass().equals(Date.class)) {
                datetime1 = DateUtil.getSecond((Date)dateStart);
                ms1 = DateUtil.getMilSecond((Date)dateStart);
            } else {
                datetime1 = DateUtil.getSecond(((DateTimeNS)dateStart).getDatetime());
                ms1 = ((DateTimeNS)dateStart).getNanosecond();
                flag = false;
            }
        }
        if (dateEnd != null) {
            if (dateEnd.getClass().equals(Date.class)) {
                datetime2 = DateUtil.getSecond((Date)dateEnd);
                ms2 = DateUtil.getMilSecond((Date)dateEnd);
            } else {
                datetime2 = DateUtil.getSecond(((DateTimeNS)dateEnd).getDatetime());
                ms2 = ((DateTimeNS)dateEnd).getNanosecond();
                flag = false;
            }
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            List<RtdbField> fields = this.proto.msgSummaryInBatchField(id, count, interval, datetime1, ms1, datetime2, ms2);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] datetimes1 = new int[count];
            int[] ms1_ret = new int[count];
            int[] datetimes2 = new int[count];
            int[] ms2_ret = new int[count];
            double[] max_values = new double[count];
            double[] min_values = new double[count];
            double[] total_values = new double[count];
            double[] calc_avgs = new double[count];
            double[] power_avgs = new double[count];
            int[] errors = new int[count];
            fields = this.proto.msgSummaryInBatchRespFields(0, 0, datetimes1, ms1_ret, datetimes2, ms2_ret, max_values, min_values, total_values, calc_avgs, power_avgs, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            count = this.getCount(fields);
            RtdbSummaryData[] rtdbSummaryDatas = new RtdbSummaryData[count];
            if (this.version.equals("3")) {
                DatagramHistorian.datagram_summary_in_batches_resp.Builder build = DatagramHistorian.datagram_summary_in_batches_resp.newBuilder();
                RtdbField rfield = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] bts = (byte[])rfield.getData();
                build.mergeFrom(bts, 4, bts.length - 8);
                RtdbSummaryData rtdbSummaryData = null;
                if (flag) {
                    for (int i = 0; i < count; ++i) {
                        rtdbSummaryData = new RtdbSummaryData();
                        rtdbSummaryData.setMaxValueTime(DateUtil.getDate(build.getBeginDatetimes(i), build.getBeginMilliseconds(i)));
                        rtdbSummaryData.setMinValueTime(DateUtil.getDate(build.getEndDatetimes(i), build.getEndMilliseconds(i)));
                        rtdbSummaryData.setMaxValue(build.getMaxValues(i));
                        rtdbSummaryData.setMinValue(build.getMinValues(i));
                        rtdbSummaryData.setTotalValue(build.getTotalValues(i));
                        rtdbSummaryData.setCalcAvg(build.getCalcAvgs(i));
                        rtdbSummaryData.setPowerAvg(build.getPowerAvgs(i));
                        rtdbSummaryData.setErrors(build.getErrors(i));
                        rtdbSummaryData.setMaxValueNanosecond(0);
                        rtdbSummaryData.setMinValueNanosecond(0);
                        rtdbSummaryDatas[i] = rtdbSummaryData;
                    }
                } else {
                    for (int i = 0; i < count; ++i) {
                        rtdbSummaryData = new RtdbSummaryData();
                        rtdbSummaryData.setMaxValueTime(DateUtil.getDate(build.getBeginDatetimes(i), 0));
                        rtdbSummaryData.setMinValueTime(DateUtil.getDate(build.getEndDatetimes(i), 0));
                        rtdbSummaryData.setMaxValue(build.getMaxValues(i));
                        rtdbSummaryData.setMinValue(build.getMinValues(i));
                        rtdbSummaryData.setTotalValue(build.getTotalValues(i));
                        rtdbSummaryData.setCalcAvg(build.getCalcAvgs(i));
                        rtdbSummaryData.setPowerAvg(build.getPowerAvgs(i));
                        rtdbSummaryData.setErrors(build.getErrors(i));
                        rtdbSummaryData.setMaxValueNanosecond(build.getBeginMilliseconds(i));
                        rtdbSummaryData.setMinValueNanosecond(build.getEndMilliseconds(i));
                        rtdbSummaryDatas[i] = rtdbSummaryData;
                    }
                }
            } else {
                Date[] dates1 = new Date[count];
                DateUtil.getDate(dates1, datetimes1, ms1_ret);
                Date[] dates2 = new Date[count];
                DateUtil.getDate(dates2, datetimes2, ms2_ret);
                RtdbSummaryData rtdbSummaryData = null;
                for (int i = 0; i < count; ++i) {
                    rtdbSummaryData = new RtdbSummaryData();
                    rtdbSummaryData.setMaxValueTime(dates1[i]);
                    rtdbSummaryData.setMinValueTime(dates2[i]);
                    rtdbSummaryData.setMaxValue(max_values[i]);
                    rtdbSummaryData.setMinValue(min_values[i]);
                    rtdbSummaryData.setTotalValue(total_values[i]);
                    rtdbSummaryData.setCalcAvg(calc_avgs[i]);
                    rtdbSummaryData.setPowerAvg(power_avgs[i]);
                    rtdbSummaryData.setMaxValueNanosecond(0);
                    rtdbSummaryData.setMinValueNanosecond(0);
                    rtdbSummaryDatas[i] = rtdbSummaryData;
                }
            }
            return rtdbSummaryDatas;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbData[] getPlotValues(int id, RtdbType rtdbType, int interval, int count, Object dateStart, Object dateEnd) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        if (id <= 0 || interval <= 0 || count <= 0 || dateStart == null) {
            throw new InvalidParameterException();
        }
        if (!dateStart.getClass().equals(Date.class) && !dateStart.getClass().equals(DateTimeNS.class) || !dateEnd.getClass().equals(Date.class) && !dateEnd.getClass().equals(DateTimeNS.class) || !dateStart.getClass().equals(dateEnd.getClass())) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_PLOT_VALUES, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        double[] values = new double[count];
        long[] states = new long[count];
        short[] qualities = new short[count];
        int datetime1 = 0;
        int ms1 = 0;
        int datetime2 = 0;
        int ms2 = 0;
        boolean flag = true;
        if (dateStart.getClass().equals(Date.class)) {
            datetime1 = DateUtil.getSecond((Date)dateStart);
            ms1 = DateUtil.getMilSecond((Date)dateStart);
            if (dateEnd != null && dateEnd.getClass().equals(Date.class)) {
                datetime2 = DateUtil.getSecond((Date)dateEnd);
                ms2 = DateUtil.getMilSecond((Date)dateEnd);
            }
        } else {
            datetime1 = DateUtil.getSecond(((DateTimeNS)dateStart).getDatetime());
            ms1 = ((DateTimeNS)dateStart).getNanosecond();
            if (dateEnd != null && dateEnd.getClass().equals(DateTimeNS.class)) {
                datetime2 = DateUtil.getSecond(((DateTimeNS)dateEnd).getDatetime());
                ms2 = ((DateTimeNS)dateStart).getNanosecond();
            }
            flag = false;
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            List<RtdbField> fields = this.proto.msgGetPlotValuesFields(id, interval, count, datetime1, ms1, datetime2, ms2);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] datetimes_ret = new int[count];
            int[] ms_ret = new int[count];
            fields = this.proto.msgGetPlotValuesRespFields(0, 0, datetimes_ret, ms_ret, values, states, qualities);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            int tempCount = this.getCount(fields);
            if (tempCount < count) {
                count = tempCount;
            }
            RtdbData[] rtdbDatas = new RtdbData[count];
            if (this.version.equals("3")) {
                DatagramHistorian.datagram_get_plot_values_resp.Builder build = DatagramHistorian.datagram_get_plot_values_resp.newBuilder();
                RtdbField rfield = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] bts = (byte[])rfield.getData();
                build.mergeFrom(bts, 4, bts.length - 8);
                RtdbNumType rtdbNumType = this.getNumberType(rtdbType);
                RtdbData rtdbData = null;
                if (flag) {
                    if (rtdbNumType == RtdbNumType.DoubleNumber) {
                        for (int i = 0; i < count; ++i) {
                            rtdbData = new RtdbData();
                            rtdbData.setDate(DateUtil.getDate(build.getDatetimesList().get(i), build.getMillisecondsList().get(i)));
                            rtdbData.setQuality(build.getQualitiesList().get(i).shortValue());
                            rtdbData.setValue(build.getValuesList().get(i));
                            rtdbData.setNanosecond(0);
                            rtdbDatas[i] = rtdbData;
                        }
                    } else if (rtdbNumType == RtdbNumType.LongNumber) {
                        for (int i = 0; i < count; ++i) {
                            rtdbData = new RtdbData();
                            rtdbData.setDate(DateUtil.getDate(build.getDatetimesList().get(i), build.getMillisecondsList().get(i)));
                            rtdbData.setQuality(build.getQualitiesList().get(i).shortValue());
                            rtdbData.setValue(build.getStatesList().get(i));
                            rtdbData.setNanosecond(0);
                            rtdbDatas[i] = rtdbData;
                        }
                    }
                } else if (rtdbNumType == RtdbNumType.DoubleNumber) {
                    for (int i = 0; i < count; ++i) {
                        rtdbData = new RtdbData();
                        rtdbData.setDate(DateUtil.getDate(build.getDatetimesList().get(i), 0));
                        rtdbData.setQuality(build.getQualitiesList().get(i).shortValue());
                        rtdbData.setValue(build.getValuesList().get(i));
                        rtdbData.setNanosecond(build.getMillisecondsList().get(i));
                        rtdbDatas[i] = rtdbData;
                    }
                } else if (rtdbNumType == RtdbNumType.LongNumber) {
                    for (int i = 0; i < count; ++i) {
                        rtdbData = new RtdbData();
                        rtdbData.setDate(DateUtil.getDate(build.getDatetimesList().get(i), 0));
                        rtdbData.setQuality(build.getQualitiesList().get(i).shortValue());
                        rtdbData.setValue(build.getStatesList().get(i));
                        rtdbData.setNanosecond(build.getMillisecondsList().get(i));
                        rtdbDatas[i] = rtdbData;
                    }
                }
            } else {
                RtdbNumType rtdbNumType = this.getNumberType(rtdbType);
                RtdbData rtdbData = null;
                Date[] dates = new Date[count];
                DateUtil.getDate(dates, datetimes_ret, ms_ret);
                if (rtdbNumType == RtdbNumType.DoubleNumber) {
                    for (int i = 0; i < count; ++i) {
                        rtdbData = new RtdbData();
                        rtdbData.setDate(dates[i]);
                        rtdbData.setValue(values[i]);
                        rtdbData.setQuality(qualities[i]);
                        rtdbData.setNanosecond(0);
                        rtdbDatas[i] = rtdbData;
                    }
                } else if (rtdbNumType == RtdbNumType.LongNumber) {
                    for (int i = 0; i < count; ++i) {
                        rtdbData = new RtdbData();
                        rtdbData.setDate(dates[i]);
                        rtdbData.setValue(states[i]);
                        rtdbData.setQuality(qualities[i]);
                        rtdbData.setNanosecond(0);
                        rtdbDatas[i] = rtdbData;
                    }
                }
            }
            return rtdbDatas;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCrossSectionValues(RtdbData[] rtdbDatas, HisMode rtdbMode, RtdbType rtdbType) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_CROSS_SECTION_VALUES, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        int count = rtdbDatas.length;
        int[] ids = new int[count];
        Date[] datetimes = new Date[count];
        int[] dateVal = new int[count];
        int[] msVal = new int[count];
        boolean[] flag = new boolean[count];
        for (int i = 0; i < rtdbDatas.length; ++i) {
            if (rtdbDatas[i].dateObj().getClass().equals(Date.class)) {
                ids[i] = rtdbDatas[i].getId();
                datetimes[i] = (Date)rtdbDatas[i].dateObj();
                dateVal[i] = DateUtil.getSecond(rtdbDatas[i].getDate());
                msVal[i] = DateUtil.getMilSecond(rtdbDatas[i].getDate());
                flag[i] = true;
                continue;
            }
            if (!rtdbDatas[i].dateObj().getClass().equals(DateTimeNS.class)) continue;
            ids[i] = rtdbDatas[i].getId();
            datetimes[i] = ((DateTimeNS)rtdbDatas[i].dateObj()).getDatetime();
            dateVal[i] = DateUtil.getSecond(datetimes[i]);
            msVal[i] = ((DateTimeNS)rtdbDatas[i].dateObj()).getNanosecond();
            flag[i] = false;
        }
        double[] values = new double[count];
        long[] states = new long[count];
        short[] qualities = new short[count];
        int[] errors = new int[count];
        int mode = rtdbMode.getNum();
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            List<RtdbField> fields = this.proto.msgGetCrossSectionValuesFields(mode, count, ids, dateVal, msVal);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetCrossSectionValuesRespFields(0, 0, dateVal, msVal, values, states, qualities, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            int successCount = 0;
            if (this.version.equals("3")) {
                DatagramHistorian.datagram_get_cross_section_values_resp.Builder build = DatagramHistorian.datagram_get_cross_section_values_resp.newBuilder();
                RtdbField rfield = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] bts = (byte[])rfield.getData();
                build.mergeFrom(bts, 4, bts.length - 8);
                RtdbData rtdbData = null;
                RtdbNumType numType = this.getNumberType(rtdbType);
                for (int k = 0; k < count; ++k) {
                    int i;
                    if (flag[k]) {
                        if (numType == RtdbNumType.DoubleNumber) {
                            for (i = 0; i < count; ++i) {
                                rtdbData = new RtdbData();
                                rtdbData.setId(ids[i]);
                                rtdbData.setDate(DateUtil.getDate(build.getDatetimes(i), build.getMilliseconds(i)));
                                rtdbData.setQuality((short)build.getQualities(i));
                                rtdbData.setValue(build.getValues(i));
                                rtdbData.setError(build.getErrors(i));
                                rtdbData.setNanosecond(0);
                                if (build.getErrors(i) == 0) {
                                    ++successCount;
                                }
                                rtdbDatas[i] = rtdbData;
                            }
                            continue;
                        }
                        if (numType != RtdbNumType.LongNumber) continue;
                        for (i = 0; i < count; ++i) {
                            rtdbData = new RtdbData();
                            rtdbData.setId(ids[i]);
                            rtdbData.setDate(DateUtil.getDate(build.getDatetimes(i), build.getMilliseconds(i)));
                            rtdbData.setQuality((short)build.getQualities(i));
                            rtdbData.setValue(build.getStates(i));
                            rtdbData.setError(build.getErrors(i));
                            rtdbData.setNanosecond(0);
                            if (build.getErrors(i) == 0) {
                                ++successCount;
                            }
                            rtdbDatas[i] = rtdbData;
                        }
                        continue;
                    }
                    if (numType == RtdbNumType.DoubleNumber) {
                        for (i = 0; i < count; ++i) {
                            rtdbData = new RtdbData();
                            rtdbData.setId(ids[i]);
                            rtdbData.setDate(DateUtil.getDate(build.getDatetimes(i), 0));
                            rtdbData.setQuality((short)build.getQualities(i));
                            rtdbData.setValue(build.getValues(i));
                            rtdbData.setError(build.getErrors(i));
                            rtdbData.setNanosecond(build.getMilliseconds(i));
                            if (build.getErrors(i) == 0) {
                                ++successCount;
                            }
                            rtdbDatas[i] = rtdbData;
                        }
                        continue;
                    }
                    if (numType != RtdbNumType.LongNumber) continue;
                    for (i = 0; i < count; ++i) {
                        rtdbData = new RtdbData();
                        rtdbData.setId(ids[i]);
                        rtdbData.setDate(DateUtil.getDate(build.getDatetimes(i), 0));
                        rtdbData.setQuality((short)build.getQualities(i));
                        rtdbData.setValue(build.getStates(i));
                        rtdbData.setError(build.getErrors(i));
                        rtdbData.setNanosecond(build.getMilliseconds(i));
                        if (build.getErrors(i) == 0) {
                            ++successCount;
                        }
                        rtdbDatas[i] = rtdbData;
                    }
                }
            } else {
                RtdbData rtdbData = null;
                RtdbNumType numType = this.getNumberType(rtdbType);
                Date date = null;
                if (numType == RtdbNumType.DoubleNumber) {
                    for (int i = 0; i < count; ++i) {
                        rtdbData = rtdbDatas[i];
                        rtdbData.setId(ids[i]);
                        rtdbData.setValue(values[i]);
                        date = DateUtil.getDate(dateVal[i], msVal[i]);
                        rtdbData.setDate(date);
                        rtdbData.setQuality(qualities[i]);
                        rtdbData.setError(errors[i]);
                        rtdbData.setNanosecond(0);
                        if (errors[i] != 0) continue;
                        ++successCount;
                    }
                } else if (numType == RtdbNumType.LongNumber) {
                    for (int i = 0; i < count; ++i) {
                        rtdbData = rtdbDatas[i];
                        rtdbData.setId(ids[i]);
                        rtdbData.setValue(states[i]);
                        date = DateUtil.getDate(dateVal[i], msVal[i]);
                        rtdbData.setDate(date);
                        rtdbData.setQuality(qualities[i]);
                        rtdbData.setError(errors[i]);
                        rtdbData.setNanosecond(0);
                        if (errors[i] != 0) continue;
                        ++successCount;
                    }
                }
            }
            return successCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbData[] getArchivedValuesFilt(int id, RtdbType rtdbType, String filter, int count, Object dateStart, Object dateEnd) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (id == 0 || count == 0 || filter.isEmpty() || filter.length() > 2035) {
            throw new InvalidParameterException();
        }
        if (!dateStart.getClass().equals(Date.class) && !dateStart.getClass().equals(DateTimeNS.class) || !dateEnd.getClass().equals(Date.class) && !dateEnd.getClass().equals(DateTimeNS.class) || !dateStart.getClass().equals(dateEnd.getClass())) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_ARCHIVED_VALUES_FILT, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            int datetime1 = 0;
            int datetime2 = 0;
            int ms1 = 0;
            int ms2 = 0;
            boolean flag = true;
            if (dateStart != null) {
                if (dateStart.getClass().equals(Date.class)) {
                    datetime1 = DateUtil.getSecond((Date)dateStart);
                    ms1 = DateUtil.getMilSecond((Date)dateStart);
                } else {
                    datetime1 = DateUtil.getSecond(((DateTimeNS)dateStart).getDatetime());
                    ms1 = ((DateTimeNS)dateStart).getNanosecond();
                    flag = false;
                }
            }
            if (dateEnd != null) {
                if (dateEnd.getClass().equals(Date.class)) {
                    datetime2 = DateUtil.getSecond((Date)dateEnd);
                    ms2 = DateUtil.getMilSecond((Date)dateEnd);
                } else {
                    datetime2 = DateUtil.getSecond(((DateTimeNS)dateEnd).getDatetime());
                    ms2 = ((DateTimeNS)dateEnd).getNanosecond();
                    flag = false;
                }
            }
            List<RtdbField> fields = this.proto.msgGetArchivedValuesFiltFields(count, id, datetime1, ms1, datetime2, ms2, filter);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] datetimes = new int[count];
            int[] ms = new int[count];
            double[] values = new double[count];
            long[] states = new long[count];
            short[] qualities = new short[count];
            fields = this.proto.msgGetArchivedValuesFiltRespFields(count, datetimes, ms, values, states, qualities);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            count = this.getCount(fields);
            RtdbData[] rtdbDatas = new RtdbData[count];
            if (this.version.equals("3")) {
                DatagramHistorian.datagram_get_archived_values_filt_resp.Builder build = DatagramHistorian.datagram_get_archived_values_filt_resp.newBuilder();
                RtdbField rField = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] bts = (byte[])rField.getData();
                build.mergeFrom(bts, 4, bts.length - 8);
                if (flag) {
                    for (int i = 0; i < count; ++i) {
                        RtdbData rtdbData = new RtdbData();
                        rtdbData.setDate(DateUtil.getDate(build.getDatetimesList().get(i), build.getMillisecondsList().get(i)));
                        RtdbNumType numType = this.getNumberType(rtdbType);
                        if (numType == RtdbNumType.DoubleNumber) {
                            rtdbData.setValue(build.getValuesList().get(i));
                        } else if (numType == RtdbNumType.LongNumber) {
                            rtdbData.setValue(build.getStatesList().get(i));
                        }
                        rtdbData.setNanosecond(0);
                        rtdbData.setQuality(build.getQualitiesList().get(i).shortValue());
                        rtdbDatas[i] = rtdbData;
                    }
                } else {
                    for (int i = 0; i < count; ++i) {
                        RtdbData rtdbData = new RtdbData();
                        rtdbData.setDate(DateUtil.getDate(build.getDatetimesList().get(i), 0));
                        RtdbNumType numType = this.getNumberType(rtdbType);
                        if (numType == RtdbNumType.DoubleNumber) {
                            rtdbData.setValue(build.getValuesList().get(i));
                        } else if (numType == RtdbNumType.LongNumber) {
                            rtdbData.setValue(build.getStatesList().get(i));
                        }
                        rtdbData.setNanosecond(build.getMillisecondsList().get(i));
                        rtdbData.setQuality(build.getQualitiesList().get(i).shortValue());
                        rtdbDatas[i] = rtdbData;
                    }
                }
            } else {
                RtdbData rtdbData = null;
                Date date = null;
                RtdbNumType numType = null;
                for (int i = 0; i < count; ++i) {
                    rtdbData = new RtdbData();
                    date = DateUtil.getDate(datetimes[i], ms[i]);
                    rtdbData.setDate(date);
                    numType = this.getNumberType(rtdbType);
                    if (numType == RtdbNumType.DoubleNumber) {
                        rtdbData.setValue(values[i]);
                    } else if (numType == RtdbNumType.LongNumber) {
                        rtdbData.setValue(states[i]);
                    }
                    rtdbData.setNanosecond(0);
                    rtdbData.setQuality(qualities[i]);
                    rtdbDatas[i] = rtdbData;
                }
            }
            return rtdbDatas;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbSummaryData getSummaryFilt(int id, String filter, Object dateStart, Object dateEnd) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (id == 0 || filter.isEmpty() || filter.length() > 2035) {
            throw new InvalidParameterException();
        }
        if (!dateStart.getClass().equals(Date.class) && !dateStart.getClass().equals(DateTimeNS.class) || !dateEnd.getClass().equals(Date.class) && !dateEnd.getClass().equals(DateTimeNS.class) || !dateStart.getClass().equals(dateEnd.getClass())) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_SUMMARY_FILT, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            int datetime1 = 0;
            int datetime2 = 0;
            int ms1 = 0;
            int ms2 = 0;
            boolean flag = true;
            if (dateStart != null) {
                if (dateStart.getClass().equals(Date.class)) {
                    datetime1 = DateUtil.getSecond((Date)dateStart);
                    ms1 = DateUtil.getMilSecond((Date)dateStart);
                } else {
                    datetime1 = DateUtil.getSecond(((DateTimeNS)dateStart).getDatetime());
                    ms1 = ((DateTimeNS)dateStart).getNanosecond();
                    flag = false;
                }
            }
            if (dateEnd != null) {
                if (dateEnd.getClass().equals(Date.class)) {
                    datetime2 = DateUtil.getSecond((Date)dateEnd);
                    ms2 = DateUtil.getMilSecond((Date)dateEnd);
                } else {
                    datetime2 = DateUtil.getSecond(((DateTimeNS)dateEnd).getDatetime());
                    ms2 = ((DateTimeNS)dateEnd).getNanosecond();
                    flag = false;
                }
            }
            List<RtdbField> fields = this.proto.msgGetSummaryFiltFields(id, datetime1, ms1, datetime2, ms2, filter);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetSummaryFiltRespFields();
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            RtdbSummaryData rtdbSummaryData = new RtdbSummaryData();
            if (this.version.equals("3")) {
                DatagramHistorian.datagram_summary_filt_resp.Builder build = DatagramHistorian.datagram_summary_filt_resp.newBuilder();
                RtdbField rField = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] bts = (byte[])rField.getData();
                build.mergeFrom(bts, 4, bts.length - 8);
                if (flag) {
                    rtdbSummaryData.setMaxValueTime(DateUtil.getDate(build.getBeginDatetime(), build.getBeginMillisecond()));
                    rtdbSummaryData.setMinValueTime(DateUtil.getDate(build.getEndDatetime(), build.getEndMillisecond()));
                    rtdbSummaryData.setMaxValue(build.getMaxValue());
                    rtdbSummaryData.setMinValue(build.getMinValue());
                    rtdbSummaryData.setTotalValue(build.getTotolValue());
                    rtdbSummaryData.setCalcAvg(build.getCalcAvg());
                    rtdbSummaryData.setPowerAvg(build.getPowerAvg());
                    rtdbSummaryData.setMaxValueNanosecond(0);
                    rtdbSummaryData.setMinValueNanosecond(0);
                } else {
                    rtdbSummaryData.setMaxValueTime(DateUtil.getDate(build.getBeginDatetime(), 0));
                    rtdbSummaryData.setMinValueTime(DateUtil.getDate(build.getEndDatetime(), 0));
                    rtdbSummaryData.setMaxValue(build.getMaxValue());
                    rtdbSummaryData.setMinValue(build.getMinValue());
                    rtdbSummaryData.setTotalValue(build.getTotolValue());
                    rtdbSummaryData.setCalcAvg(build.getCalcAvg());
                    rtdbSummaryData.setPowerAvg(build.getPowerAvg());
                    rtdbSummaryData.setMaxValueNanosecond(build.getBeginMillisecond());
                    rtdbSummaryData.setMinValueNanosecond(build.getEndMillisecond());
                }
            } else {
                int field_dt1 = RtdbGlobalEnum.FIELD_NEXT.getNum();
                int field_ms1 = field_dt1 + 1;
                int field_dt2 = field_ms1 + 1;
                int field_ms2 = field_dt2 + 1;
                int field_max = field_ms2 + 1;
                int field_min = field_max + 1;
                int field_total = field_min + 1;
                int field_calc = field_total + 1;
                int field_power = field_calc + 1;
                int datetime_second = (int)fields.get(field_dt1).getIvalue();
                short mil_second = (short)fields.get(field_ms1).getIvalue();
                Date maxValueTime = DateUtil.getDate(datetime_second, mil_second);
                datetime_second = (int)fields.get(field_dt2).getIvalue();
                mil_second = (short)fields.get(field_ms2).getIvalue();
                Date minValueTime = DateUtil.getDate(datetime_second, mil_second);
                double maxValue = fields.get(field_max).getFvalue();
                double minValue = fields.get(field_min).getFvalue();
                double totalValue = fields.get(field_total).getFvalue();
                double calcValue = fields.get(field_calc).getFvalue();
                double powerValue = fields.get(field_power).getFvalue();
                rtdbSummaryData.setMaxValueTime(maxValueTime);
                rtdbSummaryData.setMinValueTime(minValueTime);
                rtdbSummaryData.setMaxValue(maxValue);
                rtdbSummaryData.setMinValue(minValue);
                rtdbSummaryData.setTotalValue(totalValue);
                rtdbSummaryData.setCalcAvg(calcValue);
                rtdbSummaryData.setPowerAvg(powerValue);
                rtdbSummaryData.setMaxValueNanosecond(0);
                rtdbSummaryData.setMinValueNanosecond(0);
            }
            return rtdbSummaryData;
        }
    }

    @Override
    public RtdbSummaryData getSummaryFiltEx(int id, String filter, Date dateStart, Date dateEnd) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (id == 0 || filter.isEmpty() || filter.length() > 2035) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_SUMMARY_FILT_EX, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            int datetime1 = 0;
            int datetime2 = 0;
            short ms1 = 0;
            short ms2 = 0;
            if (dateStart != null) {
                datetime1 = DateUtil.getSecond(dateStart);
                ms1 = DateUtil.getMilSecond(dateStart);
            }
            if (dateEnd != null) {
                datetime2 = DateUtil.getSecond(dateEnd);
                ms2 = DateUtil.getMilSecond(dateEnd);
            }
            List<RtdbField> fields = this.proto.msgGetSummaryFiltExFields(id, datetime1, ms1, datetime2, ms2, filter);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetSummaryFiltExRespFields();
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret.equals(RtdbError.GoE_OK)) {
                int field_dt1 = RtdbGlobalEnum.FIELD_NEXT.getNum();
                int field_ms1 = field_dt1 + 1;
                int field_dt2 = field_ms1 + 1;
                int field_ms2 = field_dt2 + 1;
                int field_max = field_ms2 + 1;
                int field_min = field_max + 1;
                int field_total = field_min + 1;
                int field_calc = field_total + 1;
                int field_power = field_calc + 1;
                RtdbSummaryData rtdbSummaryData = new RtdbSummaryData();
                int datetime_second = (int)fields.get(field_dt1).getIvalue();
                short mil_second = (short)fields.get(field_ms1).getIvalue();
                Date maxValueTime = DateUtil.getDate(datetime_second, mil_second);
                datetime_second = (int)fields.get(field_dt2).getIvalue();
                mil_second = (short)fields.get(field_ms2).getIvalue();
                Date minValueTime = DateUtil.getDate(datetime_second, mil_second);
                double maxValue = fields.get(field_max).getFvalue();
                double minValue = fields.get(field_min).getFvalue();
                double totalValue = fields.get(field_total).getFvalue();
                double calcValue = fields.get(field_calc).getFvalue();
                double powerValue = fields.get(field_power).getFvalue();
                rtdbSummaryData.setMaxValueTime(maxValueTime);
                rtdbSummaryData.setMinValueTime(minValueTime);
                rtdbSummaryData.setMaxValue(maxValue);
                rtdbSummaryData.setMinValue(minValue);
                rtdbSummaryData.setTotalValue(totalValue);
                rtdbSummaryData.setCalcAvg(calcValue);
                rtdbSummaryData.setPowerAvg(powerValue);
                return rtdbSummaryData;
            }
            throw new Exception(ret.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbSummaryData[] getSummaryFiltInBatches(int id, String filter, int count, long interval, Object dateStart, Object dateEnd) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (id == 0 || count == 0 || interval == 0L || filter.isEmpty() || filter.length() > 2035) {
            throw new InvalidParameterException();
        }
        if (!dateStart.getClass().equals(Date.class) && !dateStart.getClass().equals(DateTimeNS.class) || !dateEnd.getClass().equals(Date.class) && !dateEnd.getClass().equals(DateTimeNS.class) || !dateStart.getClass().equals(dateEnd.getClass())) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_SUMMARY_FILT_IN_BATCHES, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        int datetime1 = 0;
        int datetime2 = 0;
        int ms1 = 0;
        int ms2 = 0;
        boolean flag = true;
        if (dateStart != null) {
            if (dateStart.getClass().equals(Date.class)) {
                datetime1 = DateUtil.getSecond((Date)dateStart);
                ms1 = DateUtil.getMilSecond((Date)dateStart);
            } else {
                datetime1 = DateUtil.getSecond(((DateTimeNS)dateStart).getDatetime());
                ms1 = ((DateTimeNS)dateStart).getNanosecond();
                flag = false;
            }
        }
        if (dateEnd != null) {
            if (dateEnd.getClass().equals(Date.class)) {
                datetime2 = DateUtil.getSecond((Date)dateEnd);
                ms2 = DateUtil.getMilSecond((Date)dateEnd);
            } else {
                datetime2 = DateUtil.getSecond(((DateTimeNS)dateEnd).getDatetime());
                ms2 = ((DateTimeNS)dateEnd).getNanosecond();
                flag = false;
            }
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            List<RtdbField> fields = this.proto.msgGetSummaryFiltInBatchesFields(count, id, interval, datetime1, ms1, datetime2, ms2, filter);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] datetimes1 = new int[count];
            int[] ms1_ret = new int[count];
            int[] datetimes2 = new int[count];
            int[] ms2_ret = new int[count];
            double[] max_values = new double[count];
            double[] min_values = new double[count];
            double[] total_values = new double[count];
            double[] calc_avgs = new double[count];
            double[] power_avgs = new double[count];
            int[] errors = new int[count];
            fields = this.proto.msgGetSummaryFiltInBatchesRespFields(count, datetimes1, ms1_ret, datetimes2, ms2_ret, max_values, min_values, total_values, calc_avgs, power_avgs, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK) && ret != RtdbError.GoE_FALSE) {
                throw new Exception(ret.toString());
            }
            count = this.getCount(fields);
            RtdbSummaryData[] rtdbSummaryDatas = new RtdbSummaryData[count];
            if (this.version.equals("3")) {
                DatagramHistorian.datagram_summary_filt_in_batches_resp.Builder build = DatagramHistorian.datagram_summary_filt_in_batches_resp.newBuilder();
                RtdbField rfield = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] bts = (byte[])rfield.getData();
                build.mergeFrom(bts, 4, bts.length - 8);
                count = this.getCount(fields);
                RtdbSummaryData rtdbSummaryData = null;
                if (flag) {
                    for (int i = 0; i < count; ++i) {
                        rtdbSummaryData = new RtdbSummaryData();
                        rtdbSummaryData.setMaxValueTime(DateUtil.getDate(build.getEndDatetimes(i), 0));
                        rtdbSummaryData.setMinValueTime(DateUtil.getDate(build.getBeginDatetimes(i), 0));
                        rtdbSummaryData.setMaxValue(build.getMaxValues(i));
                        rtdbSummaryData.setMinValue(build.getMinValues(i));
                        rtdbSummaryData.setTotalValue(build.getTotalValues(i));
                        rtdbSummaryData.setCalcAvg(build.getCalcAvgs(i));
                        rtdbSummaryData.setPowerAvg(build.getPowerAvgs(i));
                        rtdbSummaryData.setMaxValueNanosecond(0);
                        rtdbSummaryData.setMinValueNanosecond(0);
                        rtdbSummaryDatas[i] = rtdbSummaryData;
                    }
                } else {
                    for (int i = 0; i < count; ++i) {
                        rtdbSummaryData = new RtdbSummaryData();
                        rtdbSummaryData.setMaxValueTime(DateUtil.getDate(build.getEndDatetimes(i), 0));
                        rtdbSummaryData.setMinValueTime(DateUtil.getDate(build.getBeginDatetimes(i), 0));
                        rtdbSummaryData.setMaxValue(build.getMaxValues(i));
                        rtdbSummaryData.setMinValue(build.getMinValues(i));
                        rtdbSummaryData.setTotalValue(build.getTotalValues(i));
                        rtdbSummaryData.setCalcAvg(build.getCalcAvgs(i));
                        rtdbSummaryData.setPowerAvg(build.getPowerAvgs(i));
                        rtdbSummaryData.setMaxValueNanosecond(build.getBeginMilliseconds(i));
                        rtdbSummaryData.setMinValueNanosecond(build.getEndMilliseconds(i));
                        rtdbSummaryDatas[i] = rtdbSummaryData;
                    }
                }
            } else {
                Date[] dates1 = new Date[count];
                DateUtil.getDate(dates1, datetimes1, ms1_ret);
                Date[] dates2 = new Date[count];
                DateUtil.getDate(dates2, datetimes2, ms2_ret);
                RtdbSummaryData rtdbSummaryData = null;
                for (int i = 0; i < count; ++i) {
                    rtdbSummaryData = new RtdbSummaryData();
                    rtdbSummaryData.setMaxValueTime(dates1[i]);
                    rtdbSummaryData.setMinValueTime(dates2[i]);
                    rtdbSummaryData.setMaxValue(max_values[i]);
                    rtdbSummaryData.setMinValue(min_values[i]);
                    rtdbSummaryData.setTotalValue(total_values[i]);
                    rtdbSummaryData.setCalcAvg(calc_avgs[i]);
                    rtdbSummaryData.setPowerAvg(power_avgs[i]);
                    rtdbSummaryData.setMaxValueNanosecond(0);
                    rtdbSummaryData.setMinValueNanosecond(0);
                    rtdbSummaryDatas[i] = rtdbSummaryData;
                }
            }
            return rtdbSummaryDatas;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateValue(int id, RtdbType rtdbType, RtdbData rtdbData) throws ParseException, InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (id == 0 || rtdbType == null || rtdbData == null) {
            throw new InvalidParameterException();
        }
        if (!rtdbData.dateObj().getClass().equals(Date.class) && !rtdbData.dateObj().getClass().equals(DateTimeNS.class)) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_UPDATE_VALUE, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        int datetime = 0;
        int ms = 0;
        if (rtdbData.dateObj().getClass().equals(Date.class)) {
            datetime = DateUtil.getSecond((Date)rtdbData.dateObj());
            ms = DateUtil.getMilSecond((Date)rtdbData.dateObj());
        } else {
            datetime = DateUtil.getSecond(((DateTimeNS)rtdbData.dateObj()).getDatetime());
            ms = ((DateTimeNS)rtdbData.dateObj()).getNanosecond();
        }
        double value = 0.0;
        long state = 0L;
        RtdbNumType rtdbNumType = this.getNumberType(rtdbType);
        if (rtdbNumType == RtdbNumType.DoubleNumber) {
            int value2 = (Integer)rtdbData.getValue();
            value = value2;
        } else {
            Object state2 = rtdbData.getState();
            Integer i = (Integer)state2;
            state = i.intValue();
        }
        short quality = rtdbData.getQuality();
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            List<RtdbField> fields = this.proto.msgUpdateValueFields(id, datetime, ms, value, state, quality);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgUpdateValueRespFields();
            this.rtdbServer.getConnection().receivePacket(fields, false);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateCoorValue(int id, RtdbCoorData rtdbCoorData) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (id == 0 || rtdbCoorData == null) {
            throw new InvalidParameterException();
        }
        if (!rtdbCoorData.dateObj().getClass().equals(Date.class) && !rtdbCoorData.dateObj().getClass().equals(DateTimeNS.class)) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_UPDATE_COOR_VALUE, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            Object date = rtdbCoorData.dateObj();
            int datetime = 0;
            int ms = 0;
            if (date.getClass().equals(Date.class)) {
                datetime = DateUtil.getSecond((Date)date);
                ms = DateUtil.getMilSecond((Date)date);
            } else {
                datetime = DateUtil.getSecond(((DateTimeNS)date).getDatetime());
                ms = ((DateTimeNS)date).getNanosecond();
            }
            float x = rtdbCoorData.getX();
            float y = rtdbCoorData.getY();
            short quality = rtdbCoorData.getQuality().getNum();
            List<RtdbField> fields = this.proto.msgUpdateCoorValueFields(id, datetime, ms, x, y, quality);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgUpdateCoorValueRespFields();
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeValue(int id, Date date) throws UnexpectedMethodException, Exception {
        if (this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u7eeb\u8bf2\u7037");
        }
        if (id == 0 || date == null) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_REMOVE_VALUE, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            int datetime = DateUtil.getSecond(date);
            short ms = DateUtil.getMilSecond(date);
            List<RtdbField> fields = this.proto.msgRemoveValueFields(id, datetime, ms);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgRemoveValueRespFields();
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeValues(int id, Object dateStart, Object dateEnd) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (id == 0) {
            throw new InvalidParameterException();
        }
        if (!dateStart.getClass().equals(Date.class) && !dateStart.getClass().equals(DateTimeNS.class) || !dateEnd.getClass().equals(Date.class) && !dateEnd.getClass().equals(DateTimeNS.class) || !dateStart.getClass().equals(dateEnd.getClass())) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_REMOVE_VALUES, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        int date1_temp = 0;
        int date2_temp = 0;
        int ms1_temp = 0;
        int ms2_temp = 0;
        if (dateStart != null) {
            if (dateStart.getClass().equals(Date.class)) {
                date1_temp = DateUtil.getSecond((Date)dateStart);
                ms1_temp = DateUtil.getMilSecond((Date)dateStart);
            } else {
                date1_temp = DateUtil.getSecond(((DateTimeNS)dateStart).getDatetime());
                ms1_temp = ((DateTimeNS)dateStart).getNanosecond();
            }
        }
        if (dateEnd != null) {
            if (dateEnd.getClass().equals(Date.class)) {
                date2_temp = DateUtil.getSecond((Date)dateEnd);
                ms2_temp = DateUtil.getMilSecond((Date)dateEnd);
            } else {
                date2_temp = DateUtil.getSecond(((DateTimeNS)dateEnd).getDatetime());
                ms2_temp = ((DateTimeNS)dateEnd).getNanosecond();
            }
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            List<RtdbField> fields = this.proto.msgRemoveValuesFields(id, date1_temp, ms1_temp, date2_temp, ms2_temp);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int count = 0;
            fields = this.proto.msgRemoveValuesRespFields(count);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int putSingleCoorValue(RtdbCoorData rtdbCoorData) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (rtdbCoorData == null) {
            throw new InvalidParameterException();
        }
        if (!rtdbCoorData.dateObj().getClass().equals(Date.class) && !rtdbCoorData.dateObj().getClass().equals(DateTimeNS.class)) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_PUT_SINGLE_COOR_VALUE, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            Object date = rtdbCoorData.dateObj();
            int id = rtdbCoorData.getId();
            int datetime = 0;
            int ms = 0;
            if (date.getClass().equals(Date.class)) {
                datetime = DateUtil.getSecond((Date)date);
                ms = DateUtil.getMilSecond((Date)date);
            } else {
                datetime = DateUtil.getSecond(((DateTimeNS)date).getDatetime());
                ms = ((DateTimeNS)date).getNanosecond();
            }
            float x = rtdbCoorData.getX();
            float y = rtdbCoorData.getY();
            short quality = rtdbCoorData.getQuality().getNum();
            List<RtdbField> fields = this.proto.msgPutSingleCoorValueFields(id, datetime, ms, x, y, quality);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgPutSingleCoorValueRespFields();
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int putSingleBlobValue(RtdbBlobData rtdbRtdbBlobData) throws ParseException, InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (rtdbRtdbBlobData == null) {
            throw new InvalidParameterException();
        }
        if (!rtdbRtdbBlobData.datetimeObj().getClass().equals(Date.class) && !rtdbRtdbBlobData.datetimeObj().getClass().equals(DateTimeNS.class)) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_PUT_SINGLE_BLOB_VALUE, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            Object date = rtdbRtdbBlobData.datetimeObj();
            int id = rtdbRtdbBlobData.getId();
            int datetime = 0;
            int ms = 0;
            if (date.getClass().equals(Date.class)) {
                datetime = DateUtil.getSecond((Date)date);
                ms = DateUtil.getMilSecond((Date)date);
            } else {
                datetime = DateUtil.getSecond(((DateTimeNS)date).getDatetime());
                ms = ((DateTimeNS)date).getNanosecond();
            }
            byte[] blob = rtdbRtdbBlobData.getBlob();
            short quality = rtdbRtdbBlobData.getQuality().getNum();
            short len = rtdbRtdbBlobData.getLen();
            List<RtdbField> fields = this.proto.msgPutSingleBlobValueFields(len, id, datetime, ms, blob, quality);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgPutSingleBlobValueRespFields();
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int putArchivedValues(RtdbData[] rtdbDatas) throws UnknownHostException, IOException, DataTypeNotMatchException, InvalidParameterException, NoAuthorityException, ParseException, UnknownHostException, IOException, DataTypeNotMatchException, EncodePacketErrorException, Exception {
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_PUT_ARCHIVED_VALUES, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        int count = rtdbDatas.length;
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            int[] ids = new int[count];
            int[] datetimes = new int[count];
            int[] ms = new int[count];
            double[] values = new double[count];
            long[] states = new long[count];
            short[] qualities = new short[count];
            RtdbNumType numType = null;
            for (int i = 0; i < count; ++i) {
                ids[i] = rtdbDatas[i].getId();
                if (rtdbDatas[i].getDate() != null) {
                    if (rtdbDatas[i].dateObj().getClass().equals(Date.class)) {
                        datetimes[i] = DateUtil.getSecond((Date)rtdbDatas[i].dateObj());
                        ms[i] = DateUtil.getMilSecond((Date)rtdbDatas[i].dateObj());
                    } else if (rtdbDatas[i].dateObj().getClass().equals(DateTimeNS.class)) {
                        datetimes[i] = DateUtil.getSecond(((DateTimeNS)rtdbDatas[i].dateObj()).getDatetime());
                        ms[i] = ((DateTimeNS)rtdbDatas[i].dateObj()).getNanosecond();
                    } else {
                        throw new InvalidParameterException();
                    }
                }
                if ((numType = this.getNumberType(rtdbDatas[i].getRtdbType())) == RtdbNumType.DoubleNumber) {
                    values[i] = Double.parseDouble(rtdbDatas[i].getValue().toString());
                } else if (numType == RtdbNumType.LongNumber) {
                    states[i] = Long.parseLong(rtdbDatas[i].getState().toString());
                }
                qualities[i] = rtdbDatas[i].getQuality();
            }
            List<RtdbField> fields = this.proto.msgPutArchivedValuesFields(count, ids, datetimes, ms, values, states, qualities);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] errors = new int[count];
            fields = this.proto.msgPutArchivedValuesRespFields(count, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            count = this.getCount(fields);
            if (this.version.equals("3")) {
                DatagramHistorian.datagram_put_archived_values_resp.Builder build = DatagramHistorian.datagram_put_archived_values_resp.newBuilder();
                RtdbField rfield = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] bts = (byte[])rfield.getData();
                build.mergeFrom(bts, 4, bts.length - 8);
                for (int i = 0; i < rtdbDatas.length; ++i) {
                    rtdbDatas[i].setError(build.getErrors(i));
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    rtdbDatas[i].setError(errors[i]);
                }
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int putArchivedCoorValues(RtdbCoorData[] rtdbCoordatas) throws ParseException, InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_PUT_ARCHIVED_COOR_VALUES, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        int count = rtdbCoordatas.length;
        int[] ids = new int[count];
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            int[] datetimes = new int[count];
            int[] ms = new int[count];
            float[] x = new float[count];
            float[] y = new float[count];
            short[] qualities = new short[count];
            for (int i = 0; i < count; ++i) {
                if (rtdbCoordatas[i] == null) {
                    throw new InvalidParameterException();
                }
                ids[i] = rtdbCoordatas[i].getId();
                if (rtdbCoordatas[i].dateObj().getClass().equals(Date.class)) {
                    datetimes[i] = DateUtil.getSecond((Date)rtdbCoordatas[i].dateObj());
                    ms[i] = DateUtil.getMilSecond((Date)rtdbCoordatas[i].dateObj());
                } else if (rtdbCoordatas[i].dateObj().getClass().equals(DateTimeNS.class)) {
                    datetimes[i] = DateUtil.getSecond(((DateTimeNS)rtdbCoordatas[i].dateObj()).getDatetime());
                    ms[i] = ((DateTimeNS)rtdbCoordatas[i].dateObj()).getNanosecond();
                } else {
                    throw new InvalidParameterException();
                }
                x[i] = rtdbCoordatas[i].getX();
                y[i] = rtdbCoordatas[i].getY();
                qualities[i] = rtdbCoordatas[i].getQuality().getNum();
            }
            List<RtdbField> fields = this.proto.msgPutArchivedCoorValuesFields(count, ids, datetimes, ms, x, y, qualities);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] errors = new int[count];
            fields = this.proto.msgPutArchivedCoorValuesRespFields(errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            count = this.getCount(fields);
            for (int i = 0; i < count; ++i) {
                rtdbCoordatas[i].setError(errors[i]);
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int flushArchivedValues(int id) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (id == 0) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_FLUSH_ARCHIVED_VALUES, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            List<RtdbField> fields = this.proto.msgFlushArchivedValuesFields(id);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgFlushArchivedValuesRespFields();
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            return this.getCount(fields);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getArchivedBlobValues(int id, int count, Object dateStart, Object dateEnd, byte[][] blobs, Date[] dateTimes, int[] nanosecond, short[] lens, short[] qualities) throws InvalidParameterException, NoAuthorityException, ParseException, Exception {
        if (!dateStart.getClass().equals(Date.class) && !dateStart.getClass().equals(DateTimeNS.class) || !dateEnd.getClass().equals(Date.class) && !dateEnd.getClass().equals(DateTimeNS.class) || !dateStart.getClass().equals(dateEnd.getClass())) {
            throw new InvalidParameterException();
        }
        boolean flag = true;
        if (dateStart.getClass().equals(Date.class)) {
            if (id <= 0 || count <= 0 || ((Date)dateStart).getTime() > ((Date)dateEnd).getTime()) {
                throw new InvalidParameterException();
            }
        } else {
            if (id <= 0 || count <= 0 || ((DateTimeNS)dateStart).getDatetime().getTime() > ((DateTimeNS)dateEnd).getDatetime().getTime()) {
                throw new InvalidParameterException();
            }
            flag = false;
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_ARCHIVED_BLOB_VALUES, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            int singleBlobCount = this.rtdbServer.getConnection().getMaxBlobLen();
            int datetime1 = 0;
            int ms1 = 0;
            int datetime2 = 0;
            int ms2 = 0;
            if (flag) {
                datetime1 = DateUtil.getSecond((Date)dateStart);
                ms1 = DateUtil.getMilSecond((Date)dateStart);
                datetime2 = DateUtil.getSecond((Date)dateEnd);
                ms2 = DateUtil.getMilSecond((Date)dateEnd);
            } else {
                datetime1 = DateUtil.getSecond(((DateTimeNS)dateStart).getDatetime());
                ms1 = ((DateTimeNS)dateStart).getNanosecond();
                datetime2 = DateUtil.getSecond(((DateTimeNS)dateEnd).getDatetime());
                ms2 = ((DateTimeNS)dateStart).getNanosecond();
            }
            List<RtdbField> fields = this.proto.msgGetArchivedBlobValuesFields(count, id, singleBlobCount, lens, datetime1, ms1, datetime2, ms2);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] datetimes = new int[count];
            short[] ms = new short[count];
            for (int i = 0; i < blobs.length; ++i) {
                blobs[i] = new byte[singleBlobCount];
            }
            fields = this.proto.msgGetArchivedBlobValuesRespFields(count, blobs, datetimes, ms, qualities);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            count = this.getCount(fields);
            if (this.version.equals("3")) {
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                DatagramHistorian.datagram_get_archived_blob_values_resp.Builder respBuilder = DatagramHistorian.datagram_get_archived_blob_values_resp.newBuilder();
                respBuilder.mergeFrom(buf, 4, buf.length - 8);
                List<Integer> respDateTimes = respBuilder.getDatetimesList();
                List<Integer> respMs = respBuilder.getMillisecondsList();
                List<ByteString> blobsList = respBuilder.getBlobsList();
                List<Integer> quantityList = respBuilder.getQualitiesList();
                List<Integer> lenList = respBuilder.getBlobLensList();
                count = respBuilder.getDatetimesCount();
                if (flag) {
                    for (int i = 0; i < count; ++i) {
                        dateTimes[i] = DateUtil.getDate(respDateTimes.get(i), respMs.get(i));
                        blobs[i] = blobsList.get(i).toByteArray();
                        qualities[i] = quantityList.get(i).shortValue();
                        lens[i] = lenList.get(i).shortValue();
                        nanosecond[i] = 0;
                    }
                } else {
                    for (int i = 0; i < count; ++i) {
                        dateTimes[i] = DateUtil.getDate(respDateTimes.get(i), 0);
                        blobs[i] = blobsList.get(i).toByteArray();
                        qualities[i] = quantityList.get(i).shortValue();
                        lens[i] = lenList.get(i).shortValue();
                        nanosecond[i] = respMs.get(i);
                    }
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    dateTimes[i] = DateUtil.getDate(datetimes[i], ms[i]);
                    nanosecond[i] = 0;
                }
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int putArchivedBlobValues(int count, int[] ids, Object[] datetimes, byte[][] blobs, short[] qualities, int[] errors) throws InvalidParameterException, NoAuthorityException, Exception {
        if (count <= 0 || ids == null || datetimes == null || blobs == null || qualities == null || errors == null) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_PUT_ARCHIVED_BLOB_VALUES, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            int totalCount = 0;
            for (int i = 0; i < count; ++i) {
                totalCount += blobs[i].length;
            }
            int[] datetimesVal = new int[datetimes.length];
            int[] msVal = new int[datetimes.length];
            for (int i = 0; i < datetimes.length; ++i) {
                if (datetimes[i].getClass().equals(Date.class)) {
                    datetimesVal[i] = DateUtil.getSecond((Date)datetimes[i]);
                    msVal[i] = DateUtil.getMilSecond((Date)datetimes[i]);
                    continue;
                }
                if (datetimes[i].getClass().equals(DateTimeNS.class)) {
                    datetimesVal[i] = DateUtil.getSecond(((DateTimeNS)datetimes[i]).getDatetime());
                    msVal[i] = ((DateTimeNS)datetimes[i]).getNanosecond();
                    continue;
                }
                throw new InvalidParameterException();
            }
            List<RtdbField> fields = this.proto.msgPutArchivedBlobValuesFields(totalCount, count, ids, datetimesVal, msVal, blobs, qualities);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgPutArchivedBlobValuesRespFields(0, 0, 0, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK && ret != RtdbError.GoE_FALSE) {
                throw new Exception(ret.getErrmsg());
            }
            if (this.version.equals("3")) {
                DatagramHistorian.datagram_put_archived_blob_values_resp.Builder builder = DatagramHistorian.datagram_put_archived_blob_values_resp.newBuilder();
                byte[] bufData = (byte[])fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum()).getData();
                builder.mergeFrom(bufData, 4, bufData.length - 8);
                for (int i = 0; i < ids.length; ++i) {
                    errors[i] = builder.getErrors(i);
                }
            }
            count = this.getCount(fields);
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbDatetimeData getSingleDatetimeValue(int id, Object time, HisMode rtdbHisMode) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (!time.getClass().equals(Date.class) && !time.getClass().equals(DateTimeNS.class)) {
            throw new InvalidParameterException();
        }
        int mode = rtdbHisMode.getNum();
        if (id <= 0 || time == null || mode < 0) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_SINGLE_DATETIME_VALUE, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            boolean flag = true;
            if (time.getClass().equals(DateTimeNS.class)) {
                flag = false;
            }
            List<RtdbField> sendMessage = this.proto.msgGetSingleDatetimeValueFields(id, time, mode);
            this.rtdbServer.getConnection().sendPacket(sendMessage, false);
            RtdbError ret = this.getRet(sendMessage);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            List<RtdbField> receieveMessage = this.proto.msgGetSingleDatetimeValueRESPFields(0, 0, 0, 0, 0, 0, 0);
            this.rtdbServer.getConnection().receivePacket(receieveMessage, false);
            ret = this.getRet(receieveMessage);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            RtdbDatetimeData rtdbDatetimeData = new RtdbDatetimeData();
            if (this.version.equals("3")) {
                DatagramHistorian.datagram_get_single_datetime_value_resp.Builder builderresp = DatagramHistorian.datagram_get_single_datetime_value_resp.newBuilder();
                RtdbField p = receieveMessage.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builderresp.mergeFrom(buf, 4, buf.length - 8);
                if (flag) {
                    rtdbDatetimeData.setId(id);
                    rtdbDatetimeData.setDate(DateUtil.getDate(builderresp.getDatetime(), builderresp.getMillisecond()));
                    int millisecond = builderresp.getMillisecond();
                    rtdbDatetimeData.setValue(new Date(builderresp.getState() + (long)millisecond));
                    rtdbDatetimeData.setQuality((short)builderresp.getQuality());
                    rtdbDatetimeData.setNanosecond(0);
                } else {
                    rtdbDatetimeData.setId(id);
                    rtdbDatetimeData.setDate(DateUtil.getDate(builderresp.getDatetime(), 0));
                    int millisecond = builderresp.getMillisecond();
                    rtdbDatetimeData.setValue(new Date(builderresp.getState() + (long)millisecond));
                    rtdbDatetimeData.setQuality((short)builderresp.getQuality());
                    rtdbDatetimeData.setNanosecond(builderresp.getMillisecond());
                }
            } else {
                rtdbDatetimeData.setId(id);
                int datetime_second = (int)receieveMessage.get(RtdbSingleValueEnum.FIELD_DT.getNum()).getIvalue();
                short mil_second = (short)receieveMessage.get(RtdbSingleValueEnum.FIELD_MS.getNum()).getIvalue();
                Date date = DateUtil.getDate(datetime_second, mil_second);
                rtdbDatetimeData.setDate(date);
                long state = receieveMessage.get(RtdbSingleValueEnum.FIELD_STA.getNum()).getIvalue();
                rtdbDatetimeData.setValue(new Date(state));
                short quality = (short)receieveMessage.get(RtdbSingleValueEnum.FIELD_Q.getNum()).getIvalue();
                rtdbDatetimeData.setQuality(quality);
                rtdbDatetimeData.setNanosecond(0);
            }
            return rtdbDatetimeData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int putSingleDatetimeValue(RtdbDatetimeData rtdbDatetimeData) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (rtdbDatetimeData == null) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_PUT_SINGLE_DATETIME_VALUE, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            List<RtdbField> sendMessage = this.proto.msgPutSingleDatetimeValueFields(rtdbDatetimeData.getId(), (Date)rtdbDatetimeData.getDate(), rtdbDatetimeData.getMs(), rtdbDatetimeData.getValue().getTime(), rtdbDatetimeData.getQuality().getNum(), DateUtil.getSecond(rtdbDatetimeData.getValue()));
            this.rtdbServer.getConnection().sendPacket(sendMessage, false);
            RtdbError ret = this.getRet(sendMessage);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            List<RtdbField> fields = this.proto.msgPutSingleDatetimeValueRespFilds();
            this.rtdbServer.getConnection().receivePacket(fields, true);
            ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbDatetimeData[] getArchivedDatetimeValues(int id, Object starttime, Object endtime, int count) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (id <= 0 || starttime == null || endtime == null || count == 0) {
            throw new InvalidParameterException();
        }
        if (!starttime.getClass().equals(Date.class) && !starttime.getClass().equals(DateTimeNS.class) || !endtime.getClass().equals(Date.class) && !endtime.getClass().equals(DateTimeNS.class) || !starttime.getClass().equals(endtime.getClass())) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_ARCHIVED_DATETIME_VALUES, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            int datetime1 = 0;
            int datetime2 = 0;
            int ms1 = 0;
            int ms2 = 0;
            boolean flag = true;
            if (starttime.getClass().equals(Date.class) && endtime.getClass().equals(Date.class)) {
                datetime1 = DateUtil.getSecond((Date)starttime);
                ms1 = DateUtil.getMilSecond((Date)starttime);
                datetime2 = DateUtil.getSecond((Date)endtime);
                ms2 = DateUtil.getMilSecond((Date)endtime);
            } else if (starttime.getClass().equals(DateTimeNS.class) && endtime.getClass().equals(DateTimeNS.class)) {
                datetime1 = DateUtil.getSecond(((DateTimeNS)starttime).getDatetime());
                ms1 = ((DateTimeNS)starttime).getNanosecond();
                datetime2 = DateUtil.getSecond(((DateTimeNS)endtime).getDatetime());
                ms2 = ((DateTimeNS)endtime).getNanosecond();
                flag = false;
            } else {
                throw new InvalidParameterException();
            }
            List<RtdbField> fields = this.proto.msgGetArchivedDatetimeValuesFields(count, id, datetime1, ms1, datetime2, ms2);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] datetimes = new int[count];
            int[] ms = new int[count];
            double[] values = new double[count];
            long[] states = new long[count];
            short[] qualities = new short[count];
            fields = this.proto.msgGetArchivedDatetimeValuesRespFields(datetimes, ms, values, states, qualities);
            this.rtdbServer.getConnection().receivePacket(fields, false);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            count = this.getCount(fields);
            RtdbDatetimeData[] rtdbDatas = new RtdbDatetimeData[count];
            if (this.version.equals("3")) {
                DatagramHistorian.datagram_get_archived_datetime_values_resp.Builder receiveBuilder = DatagramHistorian.datagram_get_archived_datetime_values_resp.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                receiveBuilder.mergeFrom(buf, 4, buf.length - 8);
                int tmpcount = count > 0 ? count : 10;
                List<Object> msList = new ArrayList(tmpcount);
                List<Object> datetimesList = new ArrayList(tmpcount);
                List<Object> statesList = new ArrayList(tmpcount);
                List<Object> quantitiesList = new ArrayList(tmpcount);
                datetimesList = receiveBuilder.getDatetimesList();
                statesList = receiveBuilder.getStatesList();
                quantitiesList = receiveBuilder.getQualitiesList();
                msList = receiveBuilder.getMillisecondsList();
                if (flag) {
                    for (int i = 0; i < count; ++i) {
                        RtdbDatetimeData rtdbDatetimeData = new RtdbDatetimeData();
                        rtdbDatetimeData.setId(id);
                        Date date = DateUtil.getDate((Integer)datetimesList.get(i), (Integer)msList.get(i));
                        rtdbDatetimeData.setDate(date);
                        rtdbDatetimeData.setValue(new Date((Long)statesList.get(i)));
                        rtdbDatetimeData.setQuality(((Integer)quantitiesList.get(i)).shortValue());
                        rtdbDatetimeData.setMs((Integer)msList.get(i));
                        rtdbDatetimeData.setNanosecond(0);
                        rtdbDatas[i] = rtdbDatetimeData;
                    }
                } else {
                    for (int i = 0; i < count; ++i) {
                        RtdbDatetimeData rtdbDatetimeData = new RtdbDatetimeData();
                        rtdbDatetimeData.setId(id);
                        Date date = DateUtil.getDate((Integer)datetimesList.get(i), 0);
                        rtdbDatetimeData.setDate(date);
                        rtdbDatetimeData.setValue(new Date((Long)statesList.get(i)));
                        rtdbDatetimeData.setQuality(((Integer)quantitiesList.get(i)).shortValue());
                        rtdbDatetimeData.setMs(0);
                        rtdbDatetimeData.setNanosecond((Integer)msList.get(i));
                        rtdbDatas[i] = rtdbDatetimeData;
                    }
                }
            } else {
                count = this.getCount(fields);
                Date[] dates = new Date[count];
                DateUtil.getDate(dates, datetimes, ms);
                for (int i = 0; i < count; ++i) {
                    RtdbDatetimeData rtdbDatetimeData = new RtdbDatetimeData();
                    rtdbDatetimeData.setId(id);
                    rtdbDatetimeData.setDate(dates[i]);
                    rtdbDatetimeData.setValue(new Date(states[i]));
                    rtdbDatetimeData.setQuality(qualities[i]);
                    rtdbDatetimeData.setMs(ms[i]);
                    rtdbDatetimeData.setNanosecond(0);
                    rtdbDatas[i] = rtdbDatetimeData;
                }
            }
            return rtdbDatas;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int putArchivedDatetimeValues(RtdbDatetimeData[] rtdbDatetimeDatas) throws InvalidParameterException, NoAuthorityException, ParseException, Exception {
        if (rtdbDatetimeDatas == null || rtdbDatetimeDatas.length <= 0) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_PUT_ARCHIVED_DATETIME_VALUES, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        int count = rtdbDatetimeDatas.length;
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            int[] ids = new int[count];
            int[] datetimes = new int[count];
            int[] ms = new int[count];
            double[] values = new double[count];
            long[] states = new long[count];
            short[] qualities = new short[count];
            for (int i = 0; i < count; ++i) {
                ids[i] = rtdbDatetimeDatas[i].getId();
                datetimes[i] = DateUtil.getSecond((Date)rtdbDatetimeDatas[i].getDate());
                ms[i] = rtdbDatetimeDatas[i].getMs();
                states[i] = rtdbDatetimeDatas[i].getValue().getTime();
                qualities[i] = rtdbDatetimeDatas[i].getQuality().getNum();
            }
            List<RtdbField> fields = this.proto.msgPutArchivedDatetimeValuesFields(count, ids, datetimes, ms, values, states, qualities);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] errors = new int[count];
            fields = this.proto.msgPutArchivedDatetimeValuesRespFields(count, errors);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            if (this.version.equals("3")) {
                DatagramHistorian.datagram_put_archived_datetime_values_resp.Builder build = DatagramHistorian.datagram_put_archived_datetime_values_resp.newBuilder();
                RtdbField field = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] data = (byte[])field.getData();
                build.mergeFrom(data, 4, data.length - 8);
                for (int i = 0; i < rtdbDatetimeDatas.length; ++i) {
                    rtdbDatetimeDatas[i].setError(build.getErrors(i));
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    rtdbDatetimeDatas[i].setError(errors[i]);
                }
            }
            count = this.getCount(fields);
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int archivedValuesRealCount(int id, Object startTime, Object endTime) throws NoAuthorityException, Exception {
        if (id == 0) {
            throw new InvalidParameterException();
        }
        if (!startTime.getClass().equals(Date.class) && !startTime.getClass().equals(DateTimeNS.class) || !endTime.getClass().equals(Date.class) && !endTime.getClass().equals(DateTimeNS.class) || !startTime.getClass().equals(endTime.getClass())) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_ARCHIVED_VALUES_REAL_COUNT, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            List<RtdbField> fields = this.proto.msgArchivedValuesRealCountFields(id, startTime, endTime);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgArchivedValuesRealCountRespFields(0, 0);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            long longRet = fields.get(RtdbGlobalEnum.FIELD_RET.getNum()).getIvalue();
            RtdbError ret = RtdbErrorParse.getRtdbError(longRet);
            int count = 0;
            if (ret.equals(RtdbError.GoE_OK)) {
                count = (int)fields.get(RtdbGlobalEnum.FIELD_CNT.getNum()).getIvalue();
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RtdbData> getNextArchivedValues(int id, int count) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876");
        }
        if (id == 0 || count == 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_NEXT_ARCHIVED_VALUES, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            int[] datetimes = new int[count];
            int[] ms = new int[count];
            double[] values = new double[count];
            long[] states = new long[count];
            short[] qualities = new short[count];
            int tmpCount = count;
            List<RtdbField> fields = this.proto.msgGetNextArchivedValuesFields(count, id);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetNextArchivedValuesRespFields(count, datetimes, ms, values, states, qualities);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK) && !ret.equals(RtdbError.GoE_BATCH_END)) {
                throw new Exception(ret.toString());
            }
            DatagramHistorian.datagram_get_next_archived_values_resp.Builder builder = DatagramHistorian.datagram_get_next_archived_values_resp.newBuilder();
            RtdbField rfield = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] bts = (byte[])rfield.getData();
            builder.mergeFrom(bts, 4, bts.length - 8);
            count = this.getCount(fields);
            List<Double> valuesList = builder.getValuesList();
            List<Integer> datetimesList = builder.getDatetimesList();
            List<Integer> millisecondsList = builder.getMillisecondsList();
            ArrayList<RtdbData> list = new ArrayList<RtdbData>(tmpCount);
            for (int i = 0; i < valuesList.size(); ++i) {
                RtdbData r = new RtdbData();
                r.setDate(DateUtil.getDate(datetimesList.get(i), millisecondsList.get(i)));
                r.setId(id);
                r.setState(builder.getStates(i));
                r.setValue(builder.getValues(i));
                r.setQuality((short)builder.getQualities(i));
                r.setNanosecond(0);
                r.setRtdbType(RtdbType.parse(builder.getDescriptorForType().getIndex()));
                list.add(r);
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RtdbData> getNextArchivedValues_ns(int id, int count) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876");
        }
        if (id == 0 || count == 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_NEXT_ARCHIVED_VALUES, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            int[] datetimes = new int[count];
            int[] ms = new int[count];
            double[] values = new double[count];
            long[] states = new long[count];
            short[] qualities = new short[count];
            int tmpCount = count;
            List<RtdbField> fields = this.proto.msgGetNextArchivedValuesFields(count, id);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetNextArchivedValuesRespFields(count, datetimes, ms, values, states, qualities);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK) && !ret.equals(RtdbError.GoE_BATCH_END)) {
                throw new Exception(ret.toString());
            }
            DatagramHistorian.datagram_get_next_archived_values_resp.Builder builder = DatagramHistorian.datagram_get_next_archived_values_resp.newBuilder();
            RtdbField rfield = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] bts = (byte[])rfield.getData();
            builder.mergeFrom(bts, 4, bts.length - 8);
            count = this.getCount(fields);
            List<Double> valuesList = builder.getValuesList();
            List<Integer> datetimesList = builder.getDatetimesList();
            List<Integer> millisecondsList = builder.getMillisecondsList();
            ArrayList<RtdbData> list = new ArrayList<RtdbData>(tmpCount);
            for (int i = 0; i < valuesList.size(); ++i) {
                RtdbData r = new RtdbData();
                r.setDate(DateUtil.getDate(datetimesList.get(i), 0));
                r.setId(id);
                r.setState(builder.getStates(i));
                r.setValue(builder.getValues(i));
                r.setQuality((short)builder.getQualities(i));
                r.setNanosecond(millisecondsList.get(i));
                r.setRtdbType(RtdbType.parse(builder.getDescriptorForType().getIndex()));
                list.add(r);
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getArchivedValuesInBatch(int id, Object datetime1, Object datetime2) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876!");
        }
        if (!datetime1.getClass().equals(Date.class) && !datetime1.getClass().equals(DateTimeNS.class) || !datetime2.getClass().equals(Date.class) && !datetime2.getClass().equals(DateTimeNS.class) || !datetime1.getClass().equals(datetime2.getClass())) {
            throw new InvalidParameterException();
        }
        if (id == 0) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_ARCHIVED_VALUES_IN_BATCHES, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        int beginDate = 0;
        int beginMs = 0;
        int endDate = 0;
        int endMs = 0;
        if (datetime1 != null) {
            if (datetime1.getClass().equals(Date.class)) {
                beginDate = DateUtil.getSecond((Date)datetime1);
                beginMs = DateUtil.getMilSecond((Date)datetime1);
            } else {
                beginDate = DateUtil.getSecond(((DateTimeNS)datetime1).getDatetime());
                beginMs = ((DateTimeNS)datetime1).getNanosecond();
            }
        }
        if (datetime2 != null) {
            if (datetime2.getClass().equals(Date.class)) {
                endDate = DateUtil.getSecond((Date)datetime2);
                endMs = DateUtil.getMilSecond((Date)datetime2);
            } else {
                endDate = DateUtil.getSecond(((DateTimeNS)datetime2).getDatetime());
                endMs = ((DateTimeNS)datetime2).getNanosecond();
            }
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            List<RtdbField> fields = this.proto.msgGetArchivedValuesBatchCountFields(id, beginDate, beginMs, endDate, endMs);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetArchivedValuesBatchCountRespFields(0);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            DatagramHistorian.datagram_get_archived_values_in_batches_resp.Builder builder = DatagramHistorian.datagram_get_archived_values_in_batches_resp.newBuilder();
            RtdbField rfield = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] bts = (byte[])rfield.getData();
            builder.mergeFrom(bts, 4, bts.length - 8);
            int batchesCount = (int)fields.get(RtdbGlobalEnum.FIELD_CNT.getNum()).getIvalue();
            return batchesCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbData[] getTimedValues(int id, int count, Object[] datetimes) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876\u951b\ufffd");
        }
        if (id == 0 || count == 0 || datetimes.length != count) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_TIMED_VALUES, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            int i;
            int[] dtm = new int[count];
            int[] ms = new int[count];
            boolean flag = true;
            if (datetimes[0].getClass().equals(Date.class)) {
                for (i = 0; i < datetimes.length; ++i) {
                    dtm[i] = DateUtil.getSecond((Date)datetimes[i]);
                    ms[i] = DateUtil.getMilSecond((Date)datetimes[i]);
                }
            } else if (datetimes[0].getClass().equals(DateTimeNS.class)) {
                flag = false;
                for (i = 0; i < datetimes.length; ++i) {
                    dtm[i] = DateUtil.getSecond(((DateTimeNS)datetimes[i]).getDatetime());
                    ms[i] = ((DateTimeNS)datetimes[i]).getNanosecond();
                }
            } else {
                throw new InvalidParameterException();
            }
            List<RtdbField> fields = this.proto.msgGetTimedValuesFields(count, id, dtm, ms);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            double[] values = new double[count];
            long[] states = new long[count];
            short[] qualities = new short[count];
            fields = this.proto.msgGetTimedValuesRespFields(values, states, qualities);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            DatagramHistorian.datagram_get_timed_values_resp.Builder build = DatagramHistorian.datagram_get_timed_values_resp.newBuilder();
            RtdbField rField = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] bts = (byte[])rField.getData();
            build.mergeFrom(bts, 4, bts.length - 8);
            RtdbData[] rtdbDatas = new RtdbData[count];
            RtdbData rtdbData = null;
            if (flag) {
                for (int i2 = 0; i2 < count; ++i2) {
                    rtdbData = new RtdbData();
                    rtdbData.setId(id);
                    rtdbData.setDate(datetimes[i2]);
                    rtdbData.setQuality(build.getQualitiesList().get(i2).shortValue());
                    rtdbData.setValue(build.getValuesList().get(i2));
                    rtdbData.setState(build.getStatesList().get(i2));
                    rtdbData.setNanosecond(0);
                    rtdbDatas[i2] = rtdbData;
                }
            } else {
                for (int i3 = 0; i3 < count; ++i3) {
                    rtdbData = new RtdbData();
                    rtdbData.setId(id);
                    rtdbData.setDate(((DateTimeNS)datetimes[i3]).getDatetime());
                    rtdbData.setQuality(build.getQualitiesList().get(i3).shortValue());
                    rtdbData.setValue(build.getValuesList().get(i3));
                    rtdbData.setState(build.getStatesList().get(i3));
                    rtdbData.setNanosecond(((DateTimeNS)datetimes[i3]).getNanosecond());
                    rtdbDatas[i3] = rtdbData;
                }
            }
            return rtdbDatas;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbData[] getPlotValues(int id, int interval, int count, Object dateStart, Object dateEnd) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876!");
        }
        if (!dateStart.getClass().equals(Date.class) && !dateStart.getClass().equals(DateTimeNS.class) || !dateEnd.getClass().equals(Date.class) && !dateEnd.getClass().equals(DateTimeNS.class) || !dateStart.getClass().equals(dateEnd.getClass())) {
            throw new InvalidParameterException();
        }
        if (id <= 0 || interval <= 0 || count <= 0 || dateStart == null) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_PLOT_VALUES, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        int datetime1 = 0;
        int ms1 = 0;
        int datetime2 = 0;
        int ms2 = 0;
        boolean flag = true;
        if (dateStart.getClass().equals(Date.class)) {
            datetime1 = DateUtil.getSecond((Date)dateStart);
            ms1 = DateUtil.getMilSecond((Date)dateStart);
            if (dateEnd != null) {
                datetime2 = DateUtil.getSecond((Date)dateEnd);
                ms2 = DateUtil.getMilSecond((Date)dateEnd);
            }
        } else {
            datetime1 = DateUtil.getSecond(((DateTimeNS)dateStart).getDatetime());
            ms1 = ((DateTimeNS)dateStart).getNanosecond();
            if (dateEnd != null) {
                datetime2 = DateUtil.getSecond(((DateTimeNS)dateEnd).getDatetime());
                ms2 = ((DateTimeNS)dateStart).getNanosecond();
            }
            flag = false;
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            List<RtdbField> fields = this.proto.msgGetPlotValuesFields(id, interval, count, datetime1, ms1, datetime2, ms2);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetPlotValuesRespFields(0, count, null, null, null, null, null);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            int tempCount = this.getCount(fields);
            if (tempCount < count) {
                count = tempCount;
            }
            DatagramHistorian.datagram_get_plot_values_resp.Builder build = DatagramHistorian.datagram_get_plot_values_resp.newBuilder();
            RtdbField rfield = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] bts = (byte[])rfield.getData();
            build.mergeFrom(bts, 4, bts.length - 8);
            RtdbData[] rtdbDatas = new RtdbData[count];
            RtdbData rtdbData = null;
            if (flag) {
                for (int i = 0; i < count; ++i) {
                    rtdbData = new RtdbData();
                    rtdbData.setDate(DateUtil.getDate(build.getDatetimesList().get(i), build.getMillisecondsList().get(i)));
                    rtdbData.setQuality(build.getQualitiesList().get(i).shortValue());
                    rtdbData.setValue(build.getValues(i));
                    rtdbData.setState(build.getStates(i));
                    rtdbData.setNanosecond(0);
                    rtdbDatas[i] = rtdbData;
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    rtdbData = new RtdbData();
                    rtdbData.setDate(DateUtil.getDate(build.getDatetimesList().get(i), 0));
                    rtdbData.setQuality(build.getQualitiesList().get(i).shortValue());
                    rtdbData.setValue(build.getValues(i));
                    rtdbData.setState(build.getStates(i));
                    rtdbData.setNanosecond(build.getMillisecondsList().get(i));
                    rtdbDatas[i] = rtdbData;
                }
            }
            return rtdbDatas;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RtdbData> getCrossSectionValues(int[] ids, HisMode mode, int count, Object date) throws NoAuthorityException, Exception {
        int i;
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876");
        }
        if (!date.getClass().equals(Date.class) && !date.getClass().equals(DateTimeNS.class)) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_CROSS_SECTION_VALUES, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        int[] second = new int[count];
        int[] milSecond = new int[count];
        int tmpCount = count;
        boolean flag = true;
        if (date.getClass().equals(Date.class)) {
            for (i = 0; i < count; ++i) {
                second[i] = DateUtil.getSecond((Date)date);
                milSecond[i] = DateUtil.getMilSecond((Date)date);
            }
        } else {
            for (i = 0; i < count; ++i) {
                second[i] = DateUtil.getSecond(((DateTimeNS)date).getDatetime());
                milSecond[i] = ((DateTimeNS)date).getNanosecond();
            }
            flag = false;
        }
        int modeNum = mode.getNum();
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            List<RtdbField> fields = this.proto.msgGetCrossSectionValuesFields(modeNum, count, ids, second, milSecond);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetCrossSectionValuesRespFields(0, 0, second, milSecond, null, null, null, null);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            DatagramHistorian.datagram_get_cross_section_values_resp.Builder build = DatagramHistorian.datagram_get_cross_section_values_resp.newBuilder();
            RtdbField rfield = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] bts = (byte[])rfield.getData();
            build.mergeFrom(bts, 4, bts.length - 8);
            ArrayList<RtdbData> list = new ArrayList<RtdbData>(tmpCount);
            if (flag) {
                for (int i2 = 0; i2 < count; ++i2) {
                    RtdbData rd = new RtdbData();
                    rd.setDate(DateUtil.getDate(build.getDatetimes(i2), build.getMilliseconds(i2)));
                    rd.setError(build.getErrors(i2));
                    rd.setId(ids[i2]);
                    rd.setQuality((short)build.getQualities(i2));
                    rd.setState(build.getStates(i2));
                    rd.setValue(build.getValues(i2));
                    rd.setNanosecond(0);
                    list.add(rd);
                }
            } else {
                for (int i3 = 0; i3 < count; ++i3) {
                    RtdbData rd = new RtdbData();
                    rd.setDate(DateUtil.getDate(build.getDatetimes(i3), 0));
                    rd.setError(build.getErrors(i3));
                    rd.setId(ids[i3]);
                    rd.setQuality((short)build.getQualities(i3));
                    rd.setState(build.getStates(i3));
                    rd.setValue(build.getValues(i3));
                    rd.setNanosecond(build.getMilliseconds(i3));
                    list.add(rd);
                }
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RtdbData> getArchivedValuesFilt(int id, String filter, int count, Object dateStart, Object dateEnd) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876\u951b\ufffd");
        }
        if (id == 0 || count == 0 || filter.isEmpty() || filter.length() > 2035) {
            throw new InvalidParameterException();
        }
        if (!dateStart.getClass().equals(Date.class) && !dateStart.getClass().equals(DateTimeNS.class) || !dateEnd.getClass().equals(Date.class) && !dateEnd.getClass().equals(DateTimeNS.class) || !dateStart.getClass().equals(dateEnd.getClass())) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_ARCHIVED_VALUES_FILT, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            int tmpCount = count;
            int beginDate = 0;
            int endDate = 0;
            int beginMs = 0;
            int endMs = 0;
            boolean flag = true;
            if (dateStart != null) {
                if (dateStart.getClass().equals(Date.class)) {
                    beginDate = DateUtil.getSecond((Date)dateStart);
                    beginMs = DateUtil.getMilSecond((Date)dateStart);
                } else {
                    beginDate = DateUtil.getSecond(((DateTimeNS)dateStart).getDatetime());
                    beginMs = ((DateTimeNS)dateStart).getNanosecond();
                    flag = false;
                }
            }
            if (dateEnd != null) {
                if (dateEnd.getClass().equals(Date.class)) {
                    endDate = DateUtil.getSecond((Date)dateEnd);
                    endMs = DateUtil.getMilSecond((Date)dateEnd);
                } else {
                    endDate = DateUtil.getSecond(((DateTimeNS)dateEnd).getDatetime());
                    endMs = ((DateTimeNS)dateEnd).getNanosecond();
                    flag = false;
                }
            }
            List<RtdbField> fields = this.proto.msgGetArchivedValuesFiltFields(count, id, beginDate, beginMs, endDate, endMs, filter);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetArchivedValuesFiltRespFields(count, null, null, null, null, null);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            count = this.getCount(fields);
            ArrayList<RtdbData> list = new ArrayList<RtdbData>(tmpCount);
            DatagramHistorian.datagram_get_archived_values_filt_resp.Builder build = DatagramHistorian.datagram_get_archived_values_filt_resp.newBuilder();
            RtdbField rField = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] bts = (byte[])rField.getData();
            build.mergeFrom(bts, 4, bts.length - 8);
            if (flag) {
                for (int i = 0; i < count; ++i) {
                    RtdbData rtdbData = new RtdbData();
                    rtdbData.setId(id);
                    rtdbData.setDate(DateUtil.getDate(build.getDatetimesList().get(i), build.getMillisecondsList().get(i)));
                    rtdbData.setValue(build.getValuesList().get(i));
                    rtdbData.setState(build.getStatesList().get(i));
                    rtdbData.setQuality(build.getQualitiesList().get(i).shortValue());
                    rtdbData.setNanosecond(0);
                    list.add(rtdbData);
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    RtdbData rtdbData = new RtdbData();
                    rtdbData.setId(id);
                    rtdbData.setDate(DateUtil.getDate(build.getDatetimesList().get(i), 0));
                    rtdbData.setValue(build.getValuesList().get(i));
                    rtdbData.setState(build.getStatesList().get(i));
                    rtdbData.setQuality(build.getQualitiesList().get(i).shortValue());
                    rtdbData.setNanosecond(build.getMillisecondsList().get(i));
                    list.add(rtdbData);
                }
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RtdbData> getArchivedValues(int id, int count, Object dateStart, Object dateEnd) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876\u951b\ufffd");
        }
        if (id <= 0 || count <= 0 || dateStart == null || !dateStart.getClass().equals(dateEnd.getClass())) {
            throw new InvalidParameterException();
        }
        if (!dateStart.getClass().equals(Date.class) && !dateStart.getClass().equals(DateTimeNS.class) || !dateEnd.getClass().equals(Date.class) && !dateEnd.getClass().equals(DateTimeNS.class) || !dateStart.getClass().equals(dateEnd.getClass())) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_ARCHIVED_VALUES, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        boolean flag = true;
        int beginDate = 0;
        int endDate = 0;
        int beginMs = 0;
        int endMs = 0;
        if (dateStart.getClass().equals(Date.class)) {
            beginDate = DateUtil.getSecond((Date)dateStart);
            beginMs = DateUtil.getMilSecond((Date)dateStart);
            if (dateEnd != null) {
                endDate = DateUtil.getSecond((Date)dateEnd);
                endMs = DateUtil.getMilSecond((Date)dateEnd);
            }
        } else {
            beginDate = DateUtil.getSecond(((DateTimeNS)dateStart).getDatetime());
            beginMs = ((DateTimeNS)dateStart).getNanosecond();
            if (dateEnd != null) {
                endDate = DateUtil.getSecond(((DateTimeNS)dateEnd).getDatetime());
                endMs = ((DateTimeNS)dateEnd).getNanosecond();
            }
            flag = false;
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            List<RtdbField> fields = this.proto.msgGetArchivedValuesFields(id, count, beginDate, beginMs, endDate, endMs);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            int[] datetimes = new int[count];
            int[] ms = new int[count];
            double[] values = new double[count];
            long[] states = new long[count];
            short[] qualities = new short[count];
            int tmpCount = count;
            fields = this.proto.msgGetArchivedValuesRespFields(count, datetimes, ms, values, states, qualities);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            DatagramHistorian.datagram_get_archived_values_resp.Builder builder = DatagramHistorian.datagram_get_archived_values_resp.newBuilder();
            RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])p.getData();
            builder.mergeFrom(buf, 4, buf.length - 8);
            count = this.getCount(fields);
            List<Integer> datetimes1 = builder.getDatetimesList();
            List<Double> values1 = builder.getValuesList();
            List<Long> states1 = builder.getStatesList();
            List<Integer> quantities1 = builder.getQualitiesList();
            List<Integer> ms1 = builder.getMillisecondsList();
            ArrayList<RtdbData> list = new ArrayList<RtdbData>(tmpCount);
            if (flag) {
                for (int i = 0; i < values1.size(); ++i) {
                    RtdbData rtdbData = new RtdbData();
                    rtdbData.setId(id);
                    rtdbData.setValue(values1.get(i));
                    rtdbData.setDate(DateUtil.getDate(datetimes1.get(i), ms1.get(i)));
                    rtdbData.setState(states1.get(i));
                    rtdbData.setQuality(quantities1.get(i).shortValue());
                    rtdbData.setNanosecond(0);
                    list.add(rtdbData);
                }
            } else {
                for (int i = 0; i < values1.size(); ++i) {
                    RtdbData rtdbData = new RtdbData();
                    rtdbData.setId(id);
                    rtdbData.setValue(values1.get(i));
                    rtdbData.setDate(DateUtil.getDate(datetimes1.get(i), 0));
                    rtdbData.setState(states1.get(i));
                    rtdbData.setQuality(quantities1.get(i).shortValue());
                    rtdbData.setNanosecond(ms1.get(i));
                    list.add(rtdbData);
                }
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbNamedTypeData getSingleNamedTypeValue(int id, Object date, HisMode rtdbHisMode, short len) throws NoAuthorityException, Exception {
        int mode = rtdbHisMode.getNum();
        if (id == 0 || date == null || mode < HisMode.NEXT.getNum() || mode > HisMode.EXACT.getNum() || date == null || len == 0) {
            throw new InvalidParameterException();
        }
        if (!date.getClass().equals(Date.class) && !date.getClass().equals(DateTimeNS.class)) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_SINGLE_NAMED_TYPE_VALUE, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        int datetimes = 0;
        int ms = 0;
        boolean flag = true;
        if (date.getClass().equals(Date.class)) {
            datetimes = DateUtil.getSecond((Date)date);
            ms = DateUtil.getMilSecond((Date)date);
        } else {
            datetimes = DateUtil.getSecond(((DateTimeNS)date).getDatetime());
            ms = ((DateTimeNS)date).getNanosecond();
            flag = false;
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            List<RtdbField> fields = this.proto.msgGetSingleNamedTypeValueField(id, mode, datetimes, ms, len);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetSingleNamedTypeValueRespField();
            this.rtdbServer.getConnection().receivePacket(fields, true);
            DatagramHistorian.datagram_get_single_named_type_value_resp.Builder builderresp = DatagramHistorian.datagram_get_single_named_type_value_resp.newBuilder();
            RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])p.getData();
            builderresp.mergeFrom(buf, 4, buf.length - 8);
            short len_ret = (short)this.getCount(fields);
            RtdbNamedTypeData rtdbNamedTypeData = new RtdbNamedTypeData(len_ret);
            byte[] blob_ret = new byte[len_ret];
            byte[] blob = builderresp.getObjects().toByteArray();
            System.arraycopy(blob, 0, blob_ret, 0, len_ret);
            if (flag) {
                rtdbNamedTypeData.setValue(blob_ret);
                rtdbNamedTypeData.setId(id);
                rtdbNamedTypeData.setDatetime(DateUtil.getDate(builderresp.getDatetime(), builderresp.getMillisecond()));
                rtdbNamedTypeData.setQuality((short)builderresp.getQuality());
                rtdbNamedTypeData.setNanosecond(0);
            } else {
                rtdbNamedTypeData.setValue(blob_ret);
                rtdbNamedTypeData.setId(id);
                rtdbNamedTypeData.setDatetime(DateUtil.getDate(builderresp.getDatetime(), 0));
                rtdbNamedTypeData.setQuality((short)builderresp.getQuality());
                rtdbNamedTypeData.setNanosecond(builderresp.getMillisecond());
            }
            return rtdbNamedTypeData;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int putSingleNamedTypeValue(RtdbNamedTypeData rtdbNamedTypeData) throws NoAuthorityException, Exception {
        if (rtdbNamedTypeData == null) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_PUT_SINGLE_NAMED_TYPE_VALUE, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        int datetime = 0;
        int ms = 0;
        if (rtdbNamedTypeData.getDatetime().getClass().equals(Date.class)) {
            datetime = DateUtil.getSecond((Date)rtdbNamedTypeData.getDatetime());
            ms = DateUtil.getMilSecond((Date)rtdbNamedTypeData.getDatetime());
        } else {
            datetime = DateUtil.getSecond(((DateTimeNS)rtdbNamedTypeData.getDatetime()).getDatetime());
            ms = ((DateTimeNS)rtdbNamedTypeData.getDatetime()).getNanosecond();
        }
        byte[] myByte = rtdbNamedTypeData.getValue();
        int id = rtdbNamedTypeData.getId();
        short quality = rtdbNamedTypeData.getQuality().getNum();
        short len = rtdbNamedTypeData.getLen();
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            List<RtdbField> fields = this.proto.msgPutSingleNamedTypeValueField(id, len, datetime, ms, myByte, quality);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.msgCommonFields(RtdbMsgID.MSG_PUT_SINGLE_NAMED_TYPE_VALUE, 0);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbNamedTypeData[] getArchivedNamedTypeValues(int id, Object startTime, Object endTime, int count, short len) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876!");
        }
        if (id <= 0 || startTime == null || endTime == null || count == 0 || len == 0) {
            throw new InvalidParameterException();
        }
        if (!startTime.getClass().equals(Date.class) && !startTime.getClass().equals(DateTimeNS.class) || !endTime.getClass().equals(Date.class) && !endTime.getClass().equals(DateTimeNS.class) || !startTime.getClass().equals(endTime.getClass())) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_ARCHIVED_NAMED_TYPE_VALUES, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        if (!startTime.getClass().equals(endTime.getClass())) {
            throw new InvalidParameterException();
        }
        boolean flag = true;
        if (startTime.getClass().equals(DateTimeNS.class) && endTime.getClass().equals(DateTimeNS.class)) {
            flag = false;
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            List<RtdbField> fields = this.proto.msgGetArchivedNamedTypeValuesField(id, startTime, endTime, count, len);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetArchivedNamedTypeValuesRespField(count);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            int FIELD_CNT = 6;
            int successCount = (int)fields.get(FIELD_CNT).getIvalue();
            if (successCount <= 0) {
                return null;
            }
            DatagramHistorian.datagram_get_archived_named_type_values_resp.Builder build = DatagramHistorian.datagram_get_archived_named_type_values_resp.newBuilder();
            RtdbField rfield = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] bts = (byte[])rfield.getData();
            build.mergeFrom(bts, 4, bts.length - 8);
            RtdbNamedTypeData[] rtdbNamedTypeDataCollection = new RtdbNamedTypeData[successCount];
            if (flag) {
                for (int i = 0; i < successCount; ++i) {
                    RtdbNamedTypeData data = new RtdbNamedTypeData();
                    data.setId(id);
                    data.setLen(len);
                    data.setValue(build.getObjectsList().get(i).toByteArray());
                    data.setQuality(build.getQualitiesList().get(i).shortValue());
                    data.setDatetime(DateUtil.getDate(build.getDatetimesList().get(i), build.getMillisecondsList().get(i)));
                    data.setNanosecond(0);
                    rtdbNamedTypeDataCollection[i] = data;
                }
            } else {
                for (int i = 0; i < successCount; ++i) {
                    RtdbNamedTypeData data = new RtdbNamedTypeData();
                    data.setId(id);
                    data.setLen(len);
                    data.setValue(build.getObjectsList().get(i).toByteArray());
                    data.setQuality(build.getQualitiesList().get(i).shortValue());
                    data.setDatetime(DateUtil.getDate(build.getDatetimesList().get(i), 0));
                    data.setNanosecond(build.getMillisecondsList().get(i));
                    rtdbNamedTypeDataCollection[i] = data;
                }
            }
            return rtdbNamedTypeDataCollection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int putArchivedNamedTypeValues(RtdbNamedTypeData[] rtdbNamedTypeDatas) throws NoAuthorityException, Exception {
        if (rtdbNamedTypeDatas == null || rtdbNamedTypeDatas.length <= 0) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_PUT_ARCHIVED_NAMED_TYPE_VALUES, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            List<RtdbField> fields = this.proto.msgPutArchivedNamedTypeValuesFields(rtdbNamedTypeDatas);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgPutArchivedNamedTypeValuesRespFields();
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            int count = this.getCount(fields);
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int archivedValuesCount(int id, Object startTime, Object endTime) throws NoAuthorityException, Exception {
        if (id == 0) {
            throw new InvalidParameterException();
        }
        if (!startTime.getClass().equals(Date.class) && !startTime.getClass().equals(DateTimeNS.class) || !endTime.getClass().equals(Date.class) && !endTime.getClass().equals(DateTimeNS.class) || !startTime.getClass().equals(endTime.getClass())) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_ARCHIVED_VALUES_COUNT, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            List<RtdbField> fields = this.proto.msgArchivedValuesCountFields(id, startTime, endTime);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgArchivedValuesCountRespFields(0, 0);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            long longRet = fields.get(RtdbGlobalEnum.FIELD_RET.getNum()).getIvalue();
            RtdbError ret = RtdbErrorParse.getRtdbError(longRet);
            int count = 0;
            if (ret.equals(RtdbError.GoE_OK)) {
                count = (int)fields.get(RtdbGlobalEnum.FIELD_CNT.getNum()).getIvalue();
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int updateValue(RtdbData rtdbData) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876\u951b\ufffd");
        }
        if (rtdbData.getId() == 0 || rtdbData == null) {
            throw new InvalidParameterException();
        }
        if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_UPDATE_VALUE, this.rtdbServer.getConnection().getLogin())) {
            throw new NoAuthorityException();
        }
        int id = rtdbData.getId();
        int datetime = 0;
        int ms = 0;
        if (rtdbData.dateObj().getClass().equals(Date.class)) {
            datetime = DateUtil.getSecond((Date)rtdbData.dateObj());
            ms = DateUtil.getMilSecond((Date)rtdbData.dateObj());
        } else if (rtdbData.dateObj().getClass().equals(DateTimeNS.class)) {
            datetime = DateUtil.getSecond(((DateTimeNS)rtdbData.dateObj()).getDatetime());
            ms = ((DateTimeNS)rtdbData.dateObj()).getNanosecond();
        } else {
            throw new InvalidParameterException();
        }
        double value = 0.0;
        long state = 0L;
        RtdbNumType rtdbNumType = this.getNumberType(rtdbData.getRtdbType());
        if (rtdbNumType == RtdbNumType.DoubleNumber) {
            value = (Double)rtdbData.getValue();
        } else {
            state = Long.parseLong(rtdbData.getState().toString());
        }
        short quality = rtdbData.getQuality();
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            List<RtdbField> fields = this.proto.msgUpdateValueFields(id, datetime, ms, value, state, quality);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgUpdateValueRespFields();
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.toString());
            }
            return 1;
        }
    }

    public void getIntervalValuesFilt(int id, String filter, int interval, int count, Date dateTime) {
    }

    public void getInterpoValuesFilt(int id, String filter, int count, Date dateTime) {
    }
}

