/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.api.impl;

import com.rtdb.api.enums.RtdbError;
import com.rtdb.api.enums.RtdbGlobalEnum;
import com.rtdb.api.enums.RtdbMsgID;
import com.rtdb.api.exception.NoAuthorityException;
import com.rtdb.api.impl.Rtdb;
import com.rtdb.api.inter.IPerf;
import com.rtdb.api.inter.IServer;
import com.rtdb.api.inter.IServerable;
import com.rtdb.api.inter.msg.PerfMessage;
import com.rtdb.api.model.MemoryStream;
import com.rtdb.api.model.RtdbData;
import com.rtdb.api.model.RtdbField;
import com.rtdb.api.model.RtdbPerfTagInfo;
import com.rtdb.api.msg.PerfProtocol30;
import com.rtdb.api.protocol.DatagramPerf;
import com.rtdb.api.util.DateUtil;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;

public class RtdbPerfImpl
extends Rtdb
implements IPerf {
    private IServerable rtdbServer;
    private String version = "3";
    private PerfMessage proto;

    public RtdbPerfImpl(IServerable rtdbServer) {
        this.rtdbServer = rtdbServer;
        this.init();
    }

    private void init() {
        this.version = this.rtdbServer.getConnection().getApiVersion();
        if (this.version.equals("3")) {
            this.proto = PerfProtocol30.getInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPerfTagsCount() throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876");
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_PERF_TAGS_COUNT, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgGetPerfTagsCountFields();
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetPerfTagsCountRespFields();
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            int counts = (int)fields.get(RtdbGlobalEnum.FIELD_CNT.getNum()).getIvalue();
            return counts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbPerfTagInfo getPerfTagsInfo(int ids) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876");
        }
        if (ids == 0 || ids < 0) {
            throw new InvalidParameterException();
        }
        RtdbPerfTagInfo rtdbPerfTagInfo = null;
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_PERF_TAGS_INFO, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgGetPerfTagsInfoFields(ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetPerfTagsInfoRespFields(1);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            DatagramPerf.datagram_get_perf_tags_info_resp.Builder build = DatagramPerf.datagram_get_perf_tags_info_resp.newBuilder();
            byte[] bts = (byte[])fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum()).getData();
            build.mergeFrom(bts, 4, bts.length - 8);
            byte[] byteArray = build.getTagsInfo().toByteArray();
            rtdbPerfTagInfo = new RtdbPerfTagInfo();
            MemoryStream s = new MemoryStream(byteArray);
            rtdbPerfTagInfo.setPerf_id(s.readInt());
            String tagname = s.readString(50).trim();
            rtdbPerfTagInfo.setTag_name(tagname);
            String desc = s.readString(60).trim();
            rtdbPerfTagInfo.setDesc(desc);
            rtdbPerfTagInfo.setUnit(s.readString(90).trim());
            rtdbPerfTagInfo.setType(s.readInt());
        }
        return rtdbPerfTagInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RtdbData> getPerfValues(int count, int[] ids) throws NoAuthorityException, Exception {
        if (!this.version.equals("3")) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876");
        }
        if (count == 0 || count < 0 || ids.length <= 0) {
            throw new InvalidParameterException();
        }
        IServer iServer = this.rtdbServer.getConnection();
        synchronized (iServer) {
            if (!this.apiPre(this.rtdbServer.getConnection(), RtdbMsgID.MSG_GET_PERF_VALUES, this.rtdbServer.getConnection().getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.proto.msgGetPerfValuesFields(count, ids);
            this.rtdbServer.getConnection().sendPacket(fields, false);
            fields = this.proto.msgGetPerfValuesRespFields(count);
            this.rtdbServer.getConnection().receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new Exception(ret.getErrmsg());
            }
            count = this.getCount(fields);
            DatagramPerf.datagram_get_perf_values_resp.Builder build = DatagramPerf.datagram_get_perf_values_resp.newBuilder();
            byte[] bts = (byte[])fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum()).getData();
            build.mergeFrom(bts, 4, bts.length - 8);
            List<Integer> datetimesList = build.getDatetimesList();
            List<Long> statesList = build.getStatesList();
            List<Integer> qualitiesList = build.getQualitiesList();
            List<Double> valuesList = build.getValuesList();
            List<Integer> errorsList = build.getErrorsList();
            List<Integer> millisecondsList = build.getMillisecondsList();
            ArrayList<RtdbData> lists = new ArrayList<RtdbData>(count > 0 ? count : 10);
            RtdbData rtdbData = null;
            for (int i = 0; i < count; ++i) {
                rtdbData = new RtdbData();
                rtdbData.setId(ids[i]);
                rtdbData.setState(statesList.get(i));
                rtdbData.setValue(valuesList.get(i));
                rtdbData.setDate(DateUtil.getDate(datetimesList.get(i), millisecondsList.get(i).shortValue()));
                rtdbData.setQuality(qualitiesList.get(i).shortValue());
                rtdbData.setError(errorsList.get(i));
                lists.add(rtdbData);
            }
            return lists;
        }
    }
}

