/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.api.msg;

import com.google.protobuf.ByteString;
import com.rtdb.api.enums.RtdbMsgID;
import com.rtdb.api.impl.adapter.HistorianAdapter;
import com.rtdb.api.model.DateTimeNS;
import com.rtdb.api.model.RtdbField;
import com.rtdb.api.model.RtdbNamedTypeData;
import com.rtdb.api.protocol.DatagramHistorian;
import com.rtdb.api.util.DateUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class HistorianProtocol30
extends HistorianAdapter {
    private static HistorianProtocol30 historianProtocol = null;

    private HistorianProtocol30() {
    }

    public static synchronized HistorianProtocol30 getInstance() {
        if (historianProtocol == null) {
            historianProtocol = new HistorianProtocol30();
        }
        return historianProtocol;
    }

    @Override
    public List<RtdbField> msgPutSingleDatetimeValueFields(int id, Date date, int ms, long state, short quality, long value) throws ParseException {
        DatagramHistorian.datagram_put_single_datetime_value.Builder builder = DatagramHistorian.datagram_put_single_datetime_value.newBuilder();
        int datetimes = DateUtil.getSecond(date);
        builder.setId(id);
        builder.setDatetime(datetimes);
        builder.setMillisecond(ms);
        builder.setValue(state);
        builder.setState(value * 1000L);
        builder.setQuality(quality);
        DatagramHistorian.datagram_put_single_datetime_value _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_PUT_SINGLE_DATETIME_VALUE, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgPutSingleDatetimeValueRespFilds() {
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_PUT_SINGLE_DATETIME_VALUE, 0, 0, 0, 1, 0);
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgPutSingleValueFields(int id, int datetime, int ms, double value, long state, short quality) {
        DatagramHistorian.datagram_put_single_value.Builder builder = DatagramHistorian.datagram_put_single_value.newBuilder();
        builder.setId(id);
        builder.setDatetime(datetime);
        builder.setMillisecond(ms);
        builder.setValue(value);
        builder.setState(state);
        builder.setQuality(quality);
        DatagramHistorian.datagram_put_single_value _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_PUT_SINGLE_VALUE, 0, 0, 1, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgPutSingleValueRespFields() {
        DatagramHistorian.datagram_put_single_value_resp.Builder builder = DatagramHistorian.datagram_put_single_value_resp.newBuilder();
        DatagramHistorian.datagram_put_single_value_resp _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_PUT_SINGLE_VALUE, 0, 0, 1, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetArchivedCoorValuesBackwardFields(int count, int id, int datetime1, int ms1, int datetime2, int ms2) {
        DatagramHistorian.datagram_get_archived_coor_values_backward.Builder build = DatagramHistorian.datagram_get_archived_coor_values_backward.newBuilder();
        build.setId(id);
        build.setBeginDatetime(datetime1);
        build.setBeginMillisecond(ms1);
        build.setEndDatetime(datetime2);
        build.setEndMillisecond(ms2);
        DatagramHistorian.datagram_get_archived_coor_values_backward _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_ARCHIVED_COOR_VALUES_BACKWARD, 0, 0, count, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetArchivedCoorValuesBackwardRespFields(int count, int[] datetimes, int[] ms, float[] x, float[] y, short[] qualities) {
        DatagramHistorian.datagram_get_archived_coor_values_backward_resp.Builder build = DatagramHistorian.datagram_get_archived_coor_values_backward_resp.newBuilder();
        DatagramHistorian.datagram_get_archived_coor_values_backward_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_ARCHIVED_COOR_VALUES_BACKWARD, 0, 0, count, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgArchivedValuesCountFields(int id, Object beginTime, Object endTime) throws ParseException {
        int datetime1 = 0;
        int ms1 = 0;
        int datetime2 = 0;
        int ms2 = 0;
        if (beginTime != null) {
            if (beginTime.getClass().equals(Date.class)) {
                datetime1 = DateUtil.getSecond((Date)beginTime);
                ms1 = DateUtil.getMilSecond((Date)beginTime);
            } else {
                datetime1 = DateUtil.getSecond(((DateTimeNS)beginTime).getDatetime());
                ms1 = ((DateTimeNS)beginTime).getNanosecond();
            }
        }
        if (endTime != null) {
            if (endTime.getClass().equals(Date.class)) {
                datetime2 = DateUtil.getSecond((Date)endTime);
                ms2 = DateUtil.getMilSecond((Date)endTime);
            } else {
                datetime2 = DateUtil.getSecond(((DateTimeNS)endTime).getDatetime());
                ms2 = ((DateTimeNS)endTime).getNanosecond();
            }
        }
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        DatagramHistorian.datagram_archived_values_count.Builder builder = DatagramHistorian.datagram_archived_values_count.newBuilder();
        builder.setId(id);
        builder.setBeginDatetime(datetime1);
        builder.setBeginMillisecond(ms1);
        builder.setEndDatetime(datetime2);
        builder.setEndMillisecond(ms2);
        DatagramHistorian.datagram_archived_values_count _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        list.addAll(this.getMsgHeader2(RtdbMsgID.MSG_ARCHIVED_VALUES_COUNT, 0, 0, 0, 1, bts.length));
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgArchivedValuesRealCountFields(int id, Object beginTime, Object endTime) throws ParseException {
        int datetime1 = 0;
        int ms1 = 0;
        int datetime2 = 0;
        int ms2 = 0;
        if (beginTime != null) {
            if (beginTime.getClass().equals(Date.class)) {
                datetime1 = DateUtil.getSecond((Date)beginTime);
                ms1 = DateUtil.getMilSecond((Date)beginTime);
            } else {
                datetime1 = DateUtil.getSecond(((DateTimeNS)beginTime).getDatetime());
                ms1 = ((DateTimeNS)beginTime).getNanosecond();
            }
        }
        if (endTime != null) {
            if (endTime.getClass().equals(Date.class)) {
                datetime2 = DateUtil.getSecond((Date)endTime);
                ms2 = DateUtil.getMilSecond((Date)endTime);
            } else {
                datetime2 = DateUtil.getSecond(((DateTimeNS)endTime).getDatetime());
                ms2 = ((DateTimeNS)endTime).getNanosecond();
            }
        }
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        DatagramHistorian.datagram_archived_values_real_count.Builder builder = DatagramHistorian.datagram_archived_values_real_count.newBuilder();
        builder.setId(id);
        builder.setBeginDatetime(datetime1);
        builder.setBeginMillisecond(ms1);
        builder.setEndDatetime(datetime2);
        builder.setEndMillisecond(ms2);
        DatagramHistorian.datagram_archived_values_real_count _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        list.addAll(this.getMsgHeader2(RtdbMsgID.MSG_ARCHIVED_VALUES_REAL_COUNT, 0, 0, 0, 1, bts.length));
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetArchivedValuesFields(int id, int count, int datetime1, int ms1, int datetime2, int ms2) {
        DatagramHistorian.datagram_get_archived_values.Builder build = DatagramHistorian.datagram_get_archived_values.newBuilder();
        build.setId(id);
        build.setBeginDatetime(datetime1);
        build.setBeginMillisecond(ms1);
        build.setEndDatetime(datetime2);
        build.setEndMillisecond(ms2);
        DatagramHistorian.datagram_get_archived_values _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_ARCHIVED_VALUES, 0, 0, count, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetArchivedValuesRespFields(int count, int[] datetimes, int[] ms, double[] values, long[] states, short[] qualities) {
        DatagramHistorian.datagram_get_archived_values_resp.Builder builder = DatagramHistorian.datagram_get_archived_values_resp.newBuilder();
        DatagramHistorian.datagram_get_archived_values_resp _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_ARCHIVED_VALUES, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetTimedValuesFields(int count, int id, int[] datetimes, int[] ms) {
        ArrayList<Integer> listDate = new ArrayList<Integer>();
        ArrayList<Integer> listMs = new ArrayList<Integer>();
        for (int dt : datetimes) {
            listDate.add(dt);
        }
        for (int m : ms) {
            listMs.add(m);
        }
        DatagramHistorian.datagram_get_timed_values.Builder builder = DatagramHistorian.datagram_get_timed_values.newBuilder();
        builder.setId(id);
        builder.addAllDatetimes(listDate);
        builder.addAllMilliseconds(listMs);
        DatagramHistorian.datagram_get_timed_values _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_TIMED_VALUES, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetTimedValuesRespFields(double[] values, long[] states, short[] qualities) {
        DatagramHistorian.datagram_get_timed_values_resp.Builder builder = DatagramHistorian.datagram_get_timed_values_resp.newBuilder();
        DatagramHistorian.datagram_get_timed_values_resp _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_TIMED_VALUES, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetSingleValueRespFields(int ret, int datetime, int ms, int value, int state, int quality) {
        DatagramHistorian.datagram_get_single_value_resp.Builder build = DatagramHistorian.datagram_get_single_value_resp.newBuilder();
        DatagramHistorian.datagram_get_single_value_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_SINGLE_VALUE, 0, ret, 0, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetSingleValueFields(int id, Object date, int mode) throws ParseException {
        int datetimes = 0;
        int ms = 0;
        if (date.getClass().equals(Date.class)) {
            datetimes = DateUtil.getSecond((Date)date);
            ms = DateUtil.getMilSecond((Date)date);
        } else {
            datetimes = DateUtil.getSecond(((DateTimeNS)date).getDatetime());
            ms = ((DateTimeNS)date).getNanosecond();
        }
        DatagramHistorian.datagram_get_single_value.Builder build = DatagramHistorian.datagram_get_single_value.newBuilder();
        build.setId(id);
        build.setMode(mode);
        build.setDatetime(datetimes);
        build.setMillisecond(ms);
        DatagramHistorian.datagram_get_single_value _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_SINGLE_VALUE, 0, 0, 0, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgSummaryRespFields(int ret, int datetime1, short ms1, int datetime2, short ms2, double max, double min, double total, double calc, double power) {
        DatagramHistorian.datagram_summary_resp.Builder build = DatagramHistorian.datagram_summary_resp.newBuilder();
        build.setBeginDatetime(datetime1);
        build.setBeginMillisecond(ms1);
        build.setEndDatetime(datetime2);
        build.setEndMillisecond(ms2);
        build.setMaxValue(max);
        build.setMinValue(min);
        build.setTotolValue(total);
        build.setCalcAvg(calc);
        build.setPowerAvg(power);
        DatagramHistorian.datagram_summary_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_SUMMARY, 0, ret, 0, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgSummaryInBatchField(int id, int count, long interval, int datetime1, int ms1, int datetime2, int ms2) {
        DatagramHistorian.datagram_summary_in_batches.Builder build = DatagramHistorian.datagram_summary_in_batches.newBuilder();
        build.setId(id);
        build.setInterval(interval);
        build.setBeginDatetime(datetime1);
        build.setBeginMillisecond(ms1);
        build.setEndDatetime(datetime2);
        build.setEndMillisecond(ms2);
        DatagramHistorian.datagram_summary_in_batches _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_SUMMARY_IN_BATCHES, 0, 0, count, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgSummaryInBatchRespFields(int ret, int count, int[] datetime1, int[] ms1, int[] datetime2, int[] ms2, double[] max, double[] min, double[] total, double[] calc, double[] power, int[] errors) {
        DatagramHistorian.datagram_summary_in_batches_resp.Builder build = DatagramHistorian.datagram_summary_in_batches_resp.newBuilder();
        DatagramHistorian.datagram_summary_in_batches_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_SUMMARY_IN_BATCHES, 0, ret, count, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetPlotValuesFields(int id, int interval, int count, int datetime1, int ms1, int datetime2, int ms2) {
        DatagramHistorian.datagram_get_plot_values.Builder build = DatagramHistorian.datagram_get_plot_values.newBuilder();
        build.setId(id);
        build.setInterval(interval);
        build.setBeginDatetime(datetime1);
        build.setBeginMillisecond(ms1);
        build.setEndDatetime(datetime2);
        build.setEndMillisecond(ms2);
        DatagramHistorian.datagram_get_plot_values _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_PLOT_VALUES, 0, 0, count, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetPlotValuesRespFields(int ret, int count, int[] datetimes, int[] ms, double[] values, long[] states, short[] qualities) {
        DatagramHistorian.datagram_get_plot_values_resp.Builder build = DatagramHistorian.datagram_get_plot_values_resp.newBuilder();
        DatagramHistorian.datagram_get_plot_values_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_PLOT_VALUES, 0, ret, count, count, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetCrossSectionValuesFields(int mode, int count, int[] ids, int[] datetimes, int[] ms) {
        DatagramHistorian.datagram_get_cross_section_values.Builder build = DatagramHistorian.datagram_get_cross_section_values.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>();
        ArrayList<Integer> listDatetime = new ArrayList<Integer>();
        ArrayList<Integer> listMs = new ArrayList<Integer>();
        if (ids != null && ids.length > 0) {
            for (int id : ids) {
                listIds.add(id);
            }
        }
        if (datetimes != null && datetimes.length > 0) {
            for (int dt : datetimes) {
                listDatetime.add(dt);
            }
        }
        if (ms != null && ms.length > 0) {
            for (int m : ms) {
                listMs.add(m);
            }
        }
        build.setMode(mode);
        build.addAllIds(listIds);
        build.addAllDatetimes(listDatetime);
        build.addAllMilliseconds(listMs);
        DatagramHistorian.datagram_get_cross_section_values _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_CROSS_SECTION_VALUES, 0, 0, count, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetCrossSectionValuesRespFields(int ret, int count, int[] datetimes, int[] ms, double[] values, long[] states, short[] qualities, int[] errors) {
        DatagramHistorian.datagram_get_cross_section_values_resp.Builder build = DatagramHistorian.datagram_get_cross_section_values_resp.newBuilder();
        ArrayList listErrors = new ArrayList();
        ArrayList<Integer> listDatetime = new ArrayList<Integer>();
        ArrayList<Integer> listMs = new ArrayList<Integer>();
        ArrayList listValues = new ArrayList();
        ArrayList listStates = new ArrayList();
        ArrayList listQualites = new ArrayList();
        if (datetimes != null && datetimes.length > 0) {
            for (int dt : datetimes) {
                listDatetime.add(dt);
            }
        }
        if (ms != null && ms.length > 0) {
            for (int m : ms) {
                listMs.add(m);
            }
        }
        build.addAllDatetimes(listDatetime);
        build.addAllMilliseconds(listMs);
        build.addAllValues(listValues);
        build.addAllStates(listStates);
        build.addAllQualities(listQualites);
        build.addAllErrors(listErrors);
        DatagramHistorian.datagram_get_cross_section_values_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_CROSS_SECTION_VALUES, 0, ret, count, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgSummaryFields(int id, int datetime1, int ms1, int datetime2, int ms2) {
        DatagramHistorian.datagram_summary.Builder build = DatagramHistorian.datagram_summary.newBuilder();
        build.setId(id);
        build.setBeginDatetime(datetime1);
        build.setBeginMillisecond(ms1);
        build.setEndDatetime(datetime2);
        build.setEndMillisecond(ms2);
        DatagramHistorian.datagram_summary _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_SUMMARY, 0, 0, 0, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgPutArchivedValuesFields(int count, int[] ids, int[] datetimes, int[] ms, double[] values, long[] states, short[] qualities) {
        ArrayList<Integer> listIds = new ArrayList<Integer>();
        DatagramHistorian.datagram_put_archived_values.Builder build = DatagramHistorian.datagram_put_archived_values.newBuilder();
        ArrayList<Integer> listDatetime = new ArrayList<Integer>();
        ArrayList<Integer> listMs = new ArrayList<Integer>();
        ArrayList<Double> listValues = new ArrayList<Double>();
        ArrayList<Long> listStates = new ArrayList<Long>();
        ArrayList<Integer> listQualites = new ArrayList<Integer>();
        if (ids != null && ids.length > 0) {
            for (int id : ids) {
                listIds.add(id);
            }
        }
        if (datetimes != null && datetimes.length > 0) {
            for (int dt : datetimes) {
                listDatetime.add(dt);
            }
        }
        if (ms != null && ms.length > 0) {
            for (int m : ms) {
                listMs.add(m);
            }
        }
        int dim = 0;
        if (values != null && values.length > 0) {
            for (double vl : values) {
                listValues.add(vl);
                dim += values.length;
            }
        }
        if (states != null && states.length > 0) {
            for (long st : states) {
                listStates.add(st);
            }
        }
        if (qualities != null && qualities.length > 0) {
            for (short qa : qualities) {
                listQualites.add(Integer.valueOf(qa));
            }
        }
        build.addAllIds(listIds);
        build.addAllDatetimes(listDatetime);
        build.addAllMilliseconds(listMs);
        build.addAllValues(listValues);
        build.addAllStates(listStates);
        build.addAllQualities(listQualites);
        DatagramHistorian.datagram_put_archived_values _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_PUT_ARCHIVED_VALUES, 0, 0, count, dim, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgPutArchivedValuesRespFields(int count, int[] errors) {
        DatagramHistorian.datagram_put_archived_values_resp.Builder build = DatagramHistorian.datagram_put_archived_values_resp.newBuilder();
        DatagramHistorian.datagram_put_archived_values_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_PUT_ARCHIVED_VALUES, 0, 0, count, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetArchivedValuesBackwardFields(int count, int id, int datetime1, int ms1, int datetime2, int ms2) {
        DatagramHistorian.datagram_get_archived_values_backward.Builder build = DatagramHistorian.datagram_get_archived_values_backward.newBuilder();
        build.setId(id);
        build.setBeginDatetime(datetime1);
        build.setBeginMillisecond(ms1);
        build.setEndDatetime(datetime2);
        build.setEndMillisecond(ms2);
        DatagramHistorian.datagram_get_archived_values_backward _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_ARCHIVED_VALUES_BACKWARD, 0, 0, count, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetArchivedValuesBackwardRespFields(int[] datetimes, int[] ms, double[] values, long[] states, short[] qualities) {
        DatagramHistorian.datagram_get_archived_values_backward_resp.Builder build = DatagramHistorian.datagram_get_archived_values_backward_resp.newBuilder();
        DatagramHistorian.datagram_get_archived_values_backward_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_ARCHIVED_VALUES_BACKWARD, 0, 0, 0, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetSummaryFiltFields(int id, int beginDate, int beginMs, int endDate, int endMs, String filter) {
        DatagramHistorian.datagram_summary_filt.Builder build = DatagramHistorian.datagram_summary_filt.newBuilder();
        build.setId(id);
        build.setBeginDatetime(beginDate);
        build.setBeginMillisecond(beginMs);
        build.setEndDatetime(endDate);
        build.setEndMillisecond(endMs);
        build.setFilter(ByteString.copyFromUtf8(filter));
        DatagramHistorian.datagram_summary_filt _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_SUMMARY_FILT_EX, 0, 0, 0, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetSummaryFiltRespFields() {
        DatagramHistorian.datagram_summary_filt_resp.Builder build = DatagramHistorian.datagram_summary_filt_resp.newBuilder();
        DatagramHistorian.datagram_summary_filt_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_SUMMARY_FILT, 0, 0, 1, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetArchivedValuesFiltFields(int count, int id, int datetime1, int ms1, int datetime2, int ms2, String filter) {
        DatagramHistorian.datagram_get_archived_values_filt.Builder build = DatagramHistorian.datagram_get_archived_values_filt.newBuilder();
        build.setId(id);
        build.setBeginDatetime(datetime1);
        build.setBeginMillisecond(ms1);
        build.setEndDatetime(datetime2);
        build.setEndMillisecond(ms2);
        build.setFilter(ByteString.copyFromUtf8(filter));
        DatagramHistorian.datagram_get_archived_values_filt _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_ARCHIVED_VALUES_FILT, 0, 0, count, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetArchivedValuesFiltRespFields(int count, int[] datetimes, int[] ms, double[] values, long[] states, short[] qualities) {
        DatagramHistorian.datagram_get_archived_values_filt_resp.Builder build = DatagramHistorian.datagram_get_archived_values_filt_resp.newBuilder();
        DatagramHistorian.datagram_get_archived_values_filt_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_ARCHIVED_VALUES_FILT, 0, 0, 0, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetArchivedBlobValuesFields(int count, int id, int singleBlobCount, short[] lens, int datetime1, int ms1, int datetime2, int ms2) {
        DatagramHistorian.datagram_get_archived_blob_values.Builder builder = DatagramHistorian.datagram_get_archived_blob_values.newBuilder();
        ArrayList<Integer> sendLens = new ArrayList<Integer>();
        for (int i = 0; i < lens.length; ++i) {
            sendLens.add(singleBlobCount);
        }
        builder.addAllLens(sendLens);
        builder.setId(id);
        builder.setBeginDatetime(datetime1);
        builder.setBeginMillisecond(ms1);
        builder.setEndDatetime(datetime2);
        builder.setEndMillisecond(ms2);
        DatagramHistorian.datagram_get_archived_blob_values _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_ARCHIVED_BLOB_VALUES, 0, 0, count, count * singleBlobCount, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetArchivedBlobValuesRespFields(int count, byte[][] blobs, int[] datetimes, short[] ms, short[] qualities) {
        DatagramHistorian.datagram_get_archived_blob_values_resp.Builder respBuilder = DatagramHistorian.datagram_get_archived_blob_values_resp.newBuilder();
        DatagramHistorian.datagram_get_archived_blob_values_resp _respPacket = respBuilder.build();
        byte[] respBts = _respPacket.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_ARCHIVED_BLOB_VALUES, 0, 0, 0, 1, respBts.length);
        this.msgAddBytes(fields, respBts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetIntervalValuesFields(int count, int id, long interval, int datetimes, int ms) {
        DatagramHistorian.datagram_get_interval_values.Builder build = DatagramHistorian.datagram_get_interval_values.newBuilder();
        build.setId(id);
        build.setInterval(interval);
        build.setDatetime(datetimes);
        build.setMillisecond(ms);
        DatagramHistorian.datagram_get_interval_values _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_INTERVAL_VALUES, 0, 0, count, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetIntervalValuesRespFields(int count, int[] datetimes, int[] mss, double[] values, long[] states, short[] qualities) {
        DatagramHistorian.datagram_get_interval_values_resp.Builder build = DatagramHistorian.datagram_get_interval_values_resp.newBuilder();
        DatagramHistorian.datagram_get_interval_values_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_INTERVAL_VALUES, 0, 0, count, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetInterPoValuesFields(int count, int id, int beginDate, int beginMs, int endDate, int endMs) {
        DatagramHistorian.datagram_get_interpo_values.Builder build = DatagramHistorian.datagram_get_interpo_values.newBuilder();
        build.setId(id);
        build.setBeginDatetime(beginDate);
        build.setBeginMillisecond(beginMs);
        build.setEndDatetime(endDate);
        build.setEndMillisecond(endMs);
        DatagramHistorian.datagram_get_interpo_values _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_INTERPO_VALUES, 0, 0, count, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetInterPoValuesRespFields(int[] datetimes, int[] ms, double[] values, long[] states, short[] qualities) {
        DatagramHistorian.datagram_get_interpo_values_resp.Builder build = DatagramHistorian.datagram_get_interpo_values_resp.newBuilder();
        DatagramHistorian.datagram_get_interpo_values_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_INTERPO_VALUES, 0, 0, 0, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetTimedCoorValuesFields(int count, int id, int[] datetimes, int[] ms) {
        DatagramHistorian.datagram_get_timed_coor_values.Builder build = DatagramHistorian.datagram_get_timed_coor_values.newBuilder();
        ArrayList<Integer> listDatetime = new ArrayList<Integer>();
        ArrayList<Integer> listMs = new ArrayList<Integer>();
        if (datetimes != null && datetimes.length > 0) {
            for (int dt : datetimes) {
                listDatetime.add(dt);
            }
        }
        if (ms != null && ms.length > 0) {
            for (int m : ms) {
                listMs.add(m);
            }
        }
        build.setId(id);
        build.addAllDatetimes(listDatetime);
        build.addAllMilliseconds(listMs);
        DatagramHistorian.datagram_get_timed_coor_values _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_TIMED_COOR_VALUES, 0, 0, count, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetTimedCoorValuesRespFields(int count, float[] x, float[] y, short[] qualities) {
        DatagramHistorian.datagram_get_timed_coor_values_resp.Builder build = DatagramHistorian.datagram_get_timed_coor_values_resp.newBuilder();
        DatagramHistorian.datagram_get_timed_coor_values_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_TIMED_COOR_VALUES, 0, 0, count, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<RtdbField> msgPutArchivedBlobValuesFields(int totalCount, int count, int[] ids, int[] datetimesVal, int[] msVal, byte[][] blobs, short[] qualities) {
        void var14_22;
        DatagramHistorian.datagram_put_archived_blob_values.Builder build = DatagramHistorian.datagram_put_archived_blob_values.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length);
        ArrayList<Integer> listDatetime = new ArrayList<Integer>(ids.length);
        ArrayList<Integer> listMs = new ArrayList<Integer>(ids.length);
        ArrayList<ByteString> listByteString = new ArrayList<ByteString>(blobs.length);
        ArrayList<Integer> listQualites = new ArrayList<Integer>();
        if (ids != null && ids.length > 0) {
            for (int id : ids) {
                listIds.add(id);
            }
        }
        if (datetimesVal != null && datetimesVal.length > 0) {
            for (int dt : datetimesVal) {
                listDatetime.add(dt);
            }
        }
        if (msVal != null && msVal.length > 0) {
            for (int m : msVal) {
                listMs.add(m);
            }
        }
        if (qualities != null && qualities.length > 0) {
            for (int qa : qualities) {
                listQualites.add(qa);
            }
        }
        boolean bl = false;
        if (blobs != null && blobs.length > 0) {
            for (byte[] bt : blobs) {
                if (bt == null || bt.length <= 0) continue;
                listByteString.add(ByteString.copyFrom(bt));
                var14_22 += bt.length;
            }
        }
        build.addAllIds(listIds);
        build.addAllDatetimes(listDatetime);
        build.addAllMilliseconds(listMs);
        build.addAllBlobs(listByteString);
        build.addAllQualities(listQualites);
        DatagramHistorian.datagram_put_archived_blob_values _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_PUT_ARCHIVED_BLOB_VALUES, 0, 0, count, (int)var14_22, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgPutArchivedBlobValuesRespFields(int ret, int count, int size, int[] errors) {
        DatagramHistorian.datagram_put_archived_blob_values_resp.Builder build = DatagramHistorian.datagram_put_archived_blob_values_resp.newBuilder();
        ArrayList<Integer> listErrors = new ArrayList<Integer>();
        if (errors != null && errors.length > 0) {
            for (int er : errors) {
                listErrors.add(er);
            }
        }
        build.addAllErrors(listErrors);
        DatagramHistorian.datagram_put_archived_blob_values_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_PUT_ARCHIVED_BLOB_VALUES, 0, 0, count, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgFlushArchivedValuesFields(int id) {
        DatagramHistorian.datagram_flush_archived_values.Builder build = DatagramHistorian.datagram_flush_archived_values.newBuilder();
        build.clear();
        build.setId(id);
        DatagramHistorian.datagram_flush_archived_values _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_FLUSH_ARCHIVED_VALUES, 0, 0, 1, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgFlushArchivedValuesRespFields() {
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_FLUSH_ARCHIVED_VALUES, 0, 0, 1, 1, 0);
        this.msgAddBytes(field, new byte[]{0}, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetSummaryFiltInBatchesFields(int count, int id, long interval, int beginDate, int beginMs, int endDate, int endMs, String filter) {
        DatagramHistorian.datagram_summary_filt_in_batches.Builder build = DatagramHistorian.datagram_summary_filt_in_batches.newBuilder();
        build.setId(id);
        build.setInterval(interval);
        build.setBeginDatetime(beginDate);
        build.setBeginMillisecond(beginMs);
        build.setEndDatetime(endDate);
        build.setEndMillisecond(endMs);
        DatagramHistorian.datagram_summary_filt_in_batches _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_SUMMARY_FILT_IN_BATCHES, 0, 0, count, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetSummaryFiltInBatchesRespFields(int count, int[] datetimes1, int[] ms1_ret, int[] datetimes2, int[] ms2_ret, double[] max_values, double[] min_values, double[] total_values, double[] calc_avgs, double[] power_avgs, int[] errors) {
        DatagramHistorian.datagram_summary_filt_in_batches_resp.Builder build = DatagramHistorian.datagram_summary_filt_in_batches_resp.newBuilder();
        DatagramHistorian.datagram_summary_filt_in_batches_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_SUMMARY_FILT_IN_BATCHES, 0, 0, count, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetArchivedValuesBatchCountFields(int id, int datetime1, int ms1, int datetime2, int ms2) {
        DatagramHistorian.datagram_get_archived_values_in_batches.Builder build = DatagramHistorian.datagram_get_archived_values_in_batches.newBuilder();
        build.setId(id);
        build.setBeginDatetime(datetime1);
        build.setBeginMillisecond(ms1);
        build.setEndDatetime(datetime2);
        build.setEndMillisecond(ms2);
        DatagramHistorian.datagram_get_archived_values_in_batches _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_ARCHIVED_VALUES_IN_BATCHES, 0, 0, 1, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetArchivedValuesBatchCountRespFields(int bach) {
        DatagramHistorian.datagram_get_archived_values_in_batches_resp.Builder build = DatagramHistorian.datagram_get_archived_values_in_batches_resp.newBuilder();
        build.getBatchesCount();
        DatagramHistorian.datagram_get_archived_values_in_batches_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_ARCHIVED_VALUES_IN_BATCHES, 0, 0, 1, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetNextArchivedValuesFields(int count, int id) {
        DatagramHistorian.datagram_get_next_archived_values.Builder build = DatagramHistorian.datagram_get_next_archived_values.newBuilder();
        build.setId(id);
        DatagramHistorian.datagram_get_next_archived_values _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_NEXT_ARCHIVED_VALUES, 0, 0, count, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetNextArchivedValuesRespFields(int count, int[] datetimes, int[] ms, double[] values, long[] states, short[] qualities) {
        DatagramHistorian.datagram_get_next_archived_values_resp.Builder build = DatagramHistorian.datagram_get_next_archived_values_resp.newBuilder();
        DatagramHistorian.datagram_get_next_archived_values_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_NEXT_ARCHIVED_VALUES, 0, 0, count, 0, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetSingleBlobValueFields(short len, int id, int model, int datetimes, int ms) {
        DatagramHistorian.datagram_get_single_blob_value.Builder build = DatagramHistorian.datagram_get_single_blob_value.newBuilder();
        build.setId(id);
        build.setMode(model);
        build.setDatetime(datetimes);
        build.setMillisecond(ms);
        DatagramHistorian.datagram_get_single_blob_value _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_SINGLE_BLOB_VALUE, 0, 0, len, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetSingleBlobValueRespFields(byte[] blob) {
        DatagramHistorian.datagram_get_single_blob_value_resp.Builder build = DatagramHistorian.datagram_get_single_blob_value_resp.newBuilder();
        DatagramHistorian.datagram_get_single_blob_value_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_SINGLE_BLOB_VALUE, 0, 0, 0, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetArchivedNamedTypeValuesField(int id, Object starttime, Object endtime, int count, short len) throws Exception {
        DatagramHistorian.datagram_get_archived_named_type_values.Builder build = DatagramHistorian.datagram_get_archived_named_type_values.newBuilder();
        int beginDate = 0;
        int beginMs = 0;
        int endDate = 0;
        int endMs = 0;
        if (starttime.getClass().equals(Date.class)) {
            beginDate = DateUtil.getSecond((Date)starttime);
            beginMs = DateUtil.getMilSecond((Date)starttime);
            endDate = DateUtil.getSecond((Date)endtime);
            endMs = DateUtil.getMilSecond((Date)endtime);
        } else {
            beginDate = DateUtil.getSecond(((DateTimeNS)starttime).getDatetime());
            beginMs = ((DateTimeNS)starttime).getNanosecond();
            endDate = DateUtil.getSecond(((DateTimeNS)endtime).getDatetime());
            endMs = ((DateTimeNS)endtime).getNanosecond();
        }
        build.setId(id);
        build.setBeginDatetime(beginDate);
        build.setBeginMillisecond(beginMs);
        build.setEndDatetime(endDate);
        build.setEndMillisecond(endMs);
        build.setObjectLen(len);
        DatagramHistorian.datagram_get_archived_named_type_values _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_ARCHIVED_NAMED_TYPE_VALUES, 0, 0, count, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetArchivedNamedTypeValuesRespField(int count) {
        DatagramHistorian.datagram_get_archived_named_type_values_resp.Builder build = DatagramHistorian.datagram_get_archived_named_type_values_resp.newBuilder();
        DatagramHistorian.datagram_get_archived_named_type_values_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_ARCHIVED_NAMED_TYPE_VALUES, 0, 0, 0, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetArchivedCoorValuesFields(int count, int id, int beginDate, int beginMs, int endDate, int endMs) {
        DatagramHistorian.datagram_get_archived_coor_values.Builder build = DatagramHistorian.datagram_get_archived_coor_values.newBuilder();
        build.setId(id);
        build.setBeginDatetime(beginDate);
        build.setBeginMillisecond(beginMs);
        build.setEndDatetime(endDate);
        build.setEndMillisecond(endMs);
        DatagramHistorian.datagram_get_archived_coor_values _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_ARCHIVED_COOR_VALUES, 0, 0, count, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetArchivedCoorValuesRespFields(int[] datetimes, int[] ms, float[] x, float[] y, short[] qualities) {
        DatagramHistorian.datagram_get_archived_coor_values_resp.Builder build = DatagramHistorian.datagram_get_archived_coor_values_resp.newBuilder();
        DatagramHistorian.datagram_get_archived_coor_values_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_ARCHIVED_COOR_VALUES, 0, 0, 0, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgPutArchivedNamedTypeValuesFields(RtdbNamedTypeData[] rtdbNamedTypeDatas) throws Exception {
        ArrayList<Integer> listIds = new ArrayList<Integer>();
        ArrayList<Integer> listDatetime = new ArrayList<Integer>();
        ArrayList<Integer> listMs = new ArrayList<Integer>();
        ArrayList<ByteString> listObj = new ArrayList<ByteString>();
        ArrayList<Integer> listQualites = new ArrayList<Integer>();
        int dataLength = rtdbNamedTypeDatas.length;
        for (int i = 0; i < rtdbNamedTypeDatas.length; ++i) {
            listIds.add(rtdbNamedTypeDatas[i].getId());
            if (rtdbNamedTypeDatas[i].getDatetime().getClass().equals(Date.class)) {
                listDatetime.add(DateUtil.getSecond((Date)rtdbNamedTypeDatas[i].getDatetime()));
                listMs.add(Integer.valueOf(DateUtil.getMilSecond((Date)rtdbNamedTypeDatas[i].getDatetime())));
            } else if (rtdbNamedTypeDatas[i].getDatetime().getClass().equals(DateTimeNS.class)) {
                listDatetime.add(DateUtil.getSecond(((DateTimeNS)rtdbNamedTypeDatas[i].getDatetime()).getDatetime()));
                listMs.add(((DateTimeNS)rtdbNamedTypeDatas[i].getDatetime()).getNanosecond());
            }
            listQualites.add(Integer.valueOf(rtdbNamedTypeDatas[i].getQuality().getNum()));
            listObj.add(ByteString.copyFrom(rtdbNamedTypeDatas[i].getValue()));
        }
        DatagramHistorian.datagram_put_archived_named_type_values.Builder build = DatagramHistorian.datagram_put_archived_named_type_values.newBuilder();
        build.addAllIds(listIds);
        build.addAllDatetimes(listDatetime);
        build.addAllMilliseconds(listMs);
        build.addAllObjects(listObj);
        build.addAllQualities(listQualites);
        DatagramHistorian.datagram_put_archived_named_type_values _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_PUT_ARCHIVED_NAMED_TYPE_VALUES, 0, 0, dataLength, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgPutArchivedNamedTypeValuesRespFields() {
        DatagramHistorian.datagram_put_archived_named_type_values_resp.Builder build = DatagramHistorian.datagram_put_archived_named_type_values_resp.newBuilder();
        DatagramHistorian.datagram_put_archived_named_type_values_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_PUT_ARCHIVED_NAMED_TYPE_VALUES, 0, 0, 0, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgPutArchivedDatetimeValuesFields(int count, int[] ids, int[] datetimes, int[] ms, double[] values, long[] states, short[] qualities) {
        ArrayList<Integer> listIds = new ArrayList<Integer>(count);
        ArrayList<Integer> listDatetime = new ArrayList<Integer>(count);
        ArrayList<Integer> listMs = new ArrayList<Integer>(count);
        ArrayList<Double> listValues = new ArrayList<Double>(count);
        ArrayList<Long> listStates = new ArrayList<Long>(count);
        ArrayList<Integer> listQualites = new ArrayList<Integer>(count);
        for (int i = 0; i < count; ++i) {
            listIds.add(ids[i]);
            listDatetime.add(datetimes[i]);
            listMs.add(ms[i]);
            listValues.add(values[i]);
            listStates.add(states[i]);
            listQualites.add(Integer.valueOf(qualities[i]));
        }
        DatagramHistorian.datagram_put_archived_datetime_values.Builder build = DatagramHistorian.datagram_put_archived_datetime_values.newBuilder();
        build.addAllIds(listIds);
        build.addAllDatetimes(listDatetime);
        build.addAllMilliseconds(listMs);
        build.addAllValues(listValues);
        build.addAllStates(listStates);
        build.addAllQualities(listQualites);
        DatagramHistorian.datagram_put_archived_datetime_values _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_PUT_ARCHIVED_DATETIME_VALUES, 1, 0, count, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgPutArchivedDatetimeValuesRespFields(int count, int[] errors) {
        DatagramHistorian.datagram_put_archived_datetime_values_resp.Builder build = DatagramHistorian.datagram_put_archived_datetime_values_resp.newBuilder();
        build.addAllErrors(new ArrayList(count));
        DatagramHistorian.datagram_put_archived_datetime_values_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_PUT_ARCHIVED_DATETIME_VALUES, 0, 0, count, 0, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetSingleDatetimeValueRESPFields(int ret, int datetime, int ms, int value, int state, int quality, int type) {
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_SINGLE_DATETIME_VALUE, 0, 0, 0, 1, 0);
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetSingleDatetimeValueFields(int id, Object date, int mode) throws ParseException {
        DatagramHistorian.datagram_get_single_datetime_value.Builder builder = DatagramHistorian.datagram_get_single_datetime_value.newBuilder();
        builder.setId(id);
        builder.setMode(mode);
        if (date.getClass().equals(Date.class)) {
            builder.setDatetime(DateUtil.getSecond((Date)date));
            builder.setMillisecond(DateUtil.getMilSecond((Date)date));
        } else {
            builder.setDatetime(DateUtil.getSecond(((DateTimeNS)date).getDatetime()));
            builder.setMillisecond(((DateTimeNS)date).getNanosecond());
        }
        DatagramHistorian.datagram_get_single_datetime_value _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_SINGLE_DATETIME_VALUE, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetSingleNamedTypeValueField(int id, int mode, int datetimes, int ms, short len) {
        DatagramHistorian.datagram_get_single_named_type_value.Builder builder = DatagramHistorian.datagram_get_single_named_type_value.newBuilder();
        builder.setId(id);
        builder.setMode(mode);
        builder.setDatetime(datetimes);
        builder.setMillisecond(ms);
        DatagramHistorian.datagram_get_single_named_type_value _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_SINGLE_NAMED_TYPE_VALUE, 0, 0, len, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetSingleNamedTypeValueRespField() {
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_SINGLE_NAMED_TYPE_VALUE, 0, 0, 0, 1, 0);
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetArchivedDatetimeValuesFields(int count, int id, int datetime1, int ms1, int datetime2, int ms2) {
        DatagramHistorian.datagram_get_archived_datetime_values.Builder sendBuilder = DatagramHistorian.datagram_get_archived_datetime_values.newBuilder();
        sendBuilder.setId(id);
        sendBuilder.setBeginDatetime(datetime1);
        sendBuilder.setBeginMillisecond(ms1);
        sendBuilder.setEndDatetime(datetime2);
        sendBuilder.setEndMillisecond(ms2);
        DatagramHistorian.datagram_get_archived_datetime_values _sendPacket = sendBuilder.build();
        byte[] bts = _sendPacket.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_ARCHIVED_DATETIME_VALUES, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetArchivedDatetimeValuesRespFields(int[] datetimes, int[] ms, double[] values, long[] states, short[] qualities) {
        DatagramHistorian.datagram_get_archived_datetime_values_resp.Builder receiveBuilder = DatagramHistorian.datagram_get_archived_datetime_values_resp.newBuilder();
        ArrayList msList = new ArrayList();
        ArrayList datetimesList = new ArrayList();
        ArrayList valuesList = new ArrayList();
        ArrayList statesList = new ArrayList();
        ArrayList quantitiesList = new ArrayList();
        receiveBuilder.addAllDatetimes(datetimesList);
        receiveBuilder.addAllMilliseconds(msList);
        receiveBuilder.addAllValues(valuesList);
        receiveBuilder.addAllStates(statesList);
        receiveBuilder.addAllQualities(quantitiesList);
        receiveBuilder.setType(0);
        DatagramHistorian.datagram_get_archived_datetime_values_resp _receivePacket = receiveBuilder.build();
        byte[] receiveBts = _receivePacket.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_ARCHIVED_DATETIME_VALUES, 0, 0, 0, 0, receiveBts.length);
        this.msgAddBytes(fields, receiveBts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetSingleCoorValueFields(int id, int model, int datetimes, int ms) {
        DatagramHistorian.datagram_get_single_coor_value.Builder build = DatagramHistorian.datagram_get_single_coor_value.newBuilder();
        build.setId(id);
        build.setMode(model);
        build.setDatetime(datetimes);
        build.setMillisecond(ms);
        DatagramHistorian.datagram_get_single_coor_value _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_SINGLE_COOR_VALUE, 0, 0, 0, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetSingleCoorValueRespFields() {
        DatagramHistorian.datagram_get_single_coor_value_resp.Builder build = DatagramHistorian.datagram_get_single_coor_value_resp.newBuilder();
        DatagramHistorian.datagram_get_single_coor_value_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_SINGLE_COOR_VALUE, 0, 0, 0, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgPutSingleNamedTypeValueField(int id, int len, int datetimes, int ms, byte[] obj, short quality) {
        DatagramHistorian.datagram_put_single_named_type_value.Builder builder = DatagramHistorian.datagram_put_single_named_type_value.newBuilder();
        builder.setId(id);
        builder.setDatetime(datetimes);
        builder.setMillisecond(ms);
        builder.setObject(ByteString.copyFrom(obj));
        builder.setQuality(quality);
        DatagramHistorian.datagram_put_single_named_type_value _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_PUT_SINGLE_NAMED_TYPE_VALUE, 0, 0, len, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetUpdateValuePorpFields(int id, int datetime, short ms, double value, long state, short quality) {
        DatagramHistorian.datagram_update_value.Builder builder = DatagramHistorian.datagram_update_value.newBuilder();
        builder.setId(id);
        builder.setDatetime(datetime);
        builder.setQuality(quality);
        builder.setMillisecond(ms);
        builder.setState(state);
        builder.setValue(value);
        DatagramHistorian.datagram_update_value build = builder.build();
        byte[] bs = build.toByteArray();
        List<RtdbField> fields = this.getMsgHeader(RtdbMsgID.MSG_UPDATE_VALUE, 0, 0, 0, 1);
        this.msgAddBytes(fields, bs, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgUpdateValueFields(int id, int datetime, int ms, double value, long state, short quality) {
        DatagramHistorian.datagram_update_value.Builder builder = DatagramHistorian.datagram_update_value.newBuilder();
        builder.setId(id);
        builder.setDatetime(datetime);
        builder.setQuality(quality);
        builder.setMillisecond(ms);
        builder.setState(state);
        builder.setValue(value);
        DatagramHistorian.datagram_update_value build = builder.build();
        byte[] bs = build.toByteArray();
        List<RtdbField> fields = this.getMsgHeader(RtdbMsgID.MSG_UPDATE_VALUE, 0, 0, 0, 1);
        this.msgAddBytes(fields, bs, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgUpdateCoorValueFields(int id, int datetime, int ms, float x, float y, short quality) {
        DatagramHistorian.datagram_update_coor_value.Builder builder = DatagramHistorian.datagram_update_coor_value.newBuilder();
        builder.setId(id);
        builder.setDatetime(datetime);
        builder.setMillisecond(ms);
        builder.setQuality(quality);
        builder.setXValue(x);
        builder.setYValue(y);
        DatagramHistorian.datagram_update_coor_value build = builder.build();
        byte[] bs = build.toByteArray();
        List<RtdbField> fields = this.getMsgHeader(RtdbMsgID.MSG_UPDATE_COOR_VALUE, 0, 0, 0, 1);
        this.msgAddBytes(fields, bs, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgUpdateCoorValueRespFields() {
        List<RtdbField> fields = this.getMsgHeader(RtdbMsgID.MSG_UPDATE_COOR_VALUE, 0, 0, 0, 1);
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetRemoveValuePorpField(int id, Date date) throws ParseException {
        DatagramHistorian.datagram_remove_value.Builder builder = DatagramHistorian.datagram_remove_value.newBuilder();
        builder.setId(id);
        builder.setDatetime(DateUtil.getSecond(date));
        builder.setMillisecond(DateUtil.getMilSecond(date));
        DatagramHistorian.datagram_remove_value build = builder.build();
        byte[] bt = build.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_REMOVE_VALUE, 0, 0, 0, 1, bt.length);
        this.msgAddBytes(fields, bt, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetRemoveValueRespPorpField() {
        List<RtdbField> fields = this.msgCommonRespFields(RtdbMsgID.MSG_REMOVE_VALUE, 0, 0);
        return fields;
    }

    @Override
    public List<RtdbField> msgUpdateValueRespFields() {
        List<RtdbField> fields = this.msgCommonRespFields(RtdbMsgID.MSG_UPDATE_VALUE, 0, 0);
        return fields;
    }

    @Override
    public List<RtdbField> msgRemoveValuesFields(int id, int date1_temp, int ms1_temp, int date2_temp, int ms2_temp) {
        DatagramHistorian.datagram_remove_values.Builder builder = DatagramHistorian.datagram_remove_values.newBuilder();
        builder.setId(id);
        builder.setBeginDatetime(date1_temp);
        builder.setBeginMillisecond(ms1_temp);
        builder.setEndDatetime(date2_temp);
        builder.setEndMillisecond(ms2_temp);
        DatagramHistorian.datagram_remove_values build = builder.build();
        byte[] bs = build.toByteArray();
        List<RtdbField> fields = this.getMsgHeader(RtdbMsgID.MSG_REMOVE_VALUES, 0, 0, 0, 1);
        this.msgAddBytes(fields, bs, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgRemoveValuesRespFields(int count) {
        List<RtdbField> fields = this.msgCommonRespFields(RtdbMsgID.MSG_REMOVE_VALUES, 0, 0);
        return fields;
    }

    @Override
    public List<RtdbField> msgPutSingleCoorValueFields(int id, int datetime, int ms, float x, float y, short quality) {
        DatagramHistorian.datagram_put_single_coor_value.Builder builder = DatagramHistorian.datagram_put_single_coor_value.newBuilder();
        builder.setId(id);
        builder.setDatetime(datetime);
        builder.setMillisecond(ms);
        builder.setQuality(quality);
        builder.setXValue(x);
        builder.setYValue(y);
        DatagramHistorian.datagram_put_single_coor_value build = builder.build();
        byte[] bs = build.toByteArray();
        List<RtdbField> fields = this.getMsgHeader(RtdbMsgID.MSG_PUT_SINGLE_COOR_VALUE, 1, 0, 0, 1);
        this.msgAddBytes(fields, bs, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgPutSingleCoorValueRespFields() {
        List<RtdbField> fields = this.msgCommonRespFields(RtdbMsgID.MSG_PUT_SINGLE_COOR_VALUE, 0, 0);
        return fields;
    }

    @Override
    public List<RtdbField> msgPutSingleBlobValueFields(short len, int id, int datetime, int ms, byte[] blob, short quality) {
        DatagramHistorian.datagram_put_single_blob_value.Builder builder = DatagramHistorian.datagram_put_single_blob_value.newBuilder();
        builder.setId(id);
        builder.setDatetime(datetime);
        builder.setMillisecond(ms);
        ByteString from = ByteString.copyFrom(blob);
        builder.setBlob(from);
        builder.setLen(blob.length);
        builder.setQuality(quality);
        DatagramHistorian.datagram_put_single_blob_value build = builder.build();
        byte[] bs = build.toByteArray();
        List<RtdbField> fields = this.getMsgHeader(RtdbMsgID.MSG_PUT_SINGLE_BLOB_VALUE, 1, 0, len, 1);
        this.msgAddBytes(fields, bs, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgPutSingleBlobValueRespFields() {
        List<RtdbField> fields = this.msgCommonRespFields(RtdbMsgID.MSG_PUT_SINGLE_BLOB_VALUE, 0, 0);
        return fields;
    }

    @Override
    public List<RtdbField> msgPutArchivedCoorValuesFields(int count, int[] ids, int[] datetimes, int[] ms, float[] x, float[] y, short[] qualities) {
        DatagramHistorian.datagram_put_archived_coor_values.Builder builder = DatagramHistorian.datagram_put_archived_coor_values.newBuilder();
        for (int i = 0; i < count; ++i) {
            builder.addIds(ids[i]);
            builder.addDatetimes(datetimes[i]);
            builder.addMilliseconds(ms[i]);
            builder.addXValues(x[i]);
            builder.addYValues(y[i]);
            builder.addQualities(qualities[i]);
        }
        DatagramHistorian.datagram_put_archived_coor_values build = builder.build();
        byte[] bs = build.toByteArray();
        List<RtdbField> fields = this.getMsgHeader(RtdbMsgID.MSG_PUT_ARCHIVED_COOR_VALUES, 1, 0, count, count);
        this.msgAddBytes(fields, bs, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgPutArchivedCoorValuesRespFields(int[] errors) {
        List<RtdbField> fields = this.getMsgHeader(RtdbMsgID.MSG_PUT_ARCHIVED_COOR_VALUES, 0, 0, 0, 0);
        this.msgAddIntArray(fields, errors, "errors");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgPutSingleNamedTypeRepoValueField() {
        List<RtdbField> fields = this.msgCommonFields(RtdbMsgID.MSG_PUT_SINGLE_NAMED_TYPE_VALUE, 0);
        return fields;
    }

    @Override
    public List<RtdbField> msgArchivedValuesRealCountRespFields(int i, int j) {
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_ARCHIVED_VALUES_REAL_COUNT, 0, 0, 0, 1, 0);
        this.msgAddBytes(field, new byte[]{0}, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgArchivedValuesCountRespFields(int i, int j) {
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_ARCHIVED_VALUES_COUNT, 0, 0, 0, 1, 0);
        this.msgAddBytes(field, new byte[]{0}, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }
}

