/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.api.msg;

import com.rtdb.api.enums.RtdbMsgID;
import com.rtdb.api.enums.RtdbPrivGroup;
import com.rtdb.api.impl.adapter.ServerAdapter;
import com.rtdb.api.model.Login;
import com.rtdb.api.model.NamedDataTypeField;
import com.rtdb.api.model.RtdbCalcPoint;
import com.rtdb.api.model.RtdbField;
import com.rtdb.api.model.RtdbScanPoint;
import com.rtdb.api.util.Crc32Util;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class ServerProtocol21
extends ServerAdapter {
    private static ServerProtocol21 serverProtocol;

    private ServerProtocol21() {
    }

    public static final ServerProtocol21 getInstance() {
        if (serverProtocol == null) {
            serverProtocol = new ServerProtocol21();
        }
        return serverProtocol;
    }

    @Override
    public List<RtdbField> msgAddAuthFields(int addr, int mask, RtdbPrivGroup priv, String desc) throws UnsupportedEncodingException {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_ADD_AUTHORIZATION, 3, 0, 0, 1));
        this.msgAddInt(list, addr, "address");
        this.msgAddInt(list, mask, "mask");
        this.msgAddInt(list, priv.getNum(), "priv");
        this.msgAddString(list, desc, "len", "desc");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgAddAuthRespFields(int ret) {
        return this.msgCommonRespFields1(RtdbMsgID.MSG_ADD_AUTHORIZATION, 0, ret);
    }

    @Override
    public List<RtdbField> msgAddBlacklistFields(int addr, int mask, String desc) throws UnsupportedEncodingException {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_ADD_BLACKLIST, 0, 0, 0, 1));
        this.msgAddInt(list, addr, "addr");
        this.msgAddInt(list, mask, "mask");
        this.msgAddString(list, desc, "len", "desc");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgAddBlacklistRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_ADD_BLACKLIST, 0, ret);
    }

    @Override
    public List<RtdbField> msgAddUserFields(String user, int pwd, RtdbPrivGroup priv) throws UnsupportedEncodingException {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_ADD_USER, 1, 0, 0, 1));
        this.msgAddInt(list, pwd, "password");
        this.msgAddInt(list, priv.getNum(), "priv");
        this.msgAddString(list, user, "len", "user");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgAddUserRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_ADD_USER, 0, ret);
    }

    @Override
    public List<RtdbField> msgChangeMyPwdFields(int oldPwd, int newPwd) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_CHANGE_MY_PASSWORD, 1, 0, 0, 1));
        this.msgAddInt(list, oldPwd, "old password");
        this.msgAddInt(list, newPwd, "new password");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgChangeMyPwdRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_CHANGE_MY_PASSWORD, 0, ret);
    }

    @Override
    public List<RtdbField> msgChangePrivFields(String user, RtdbPrivGroup priv) throws UnsupportedEncodingException {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_CHANGE_PRIV, 1, 0, 0, 1));
        this.msgAddInt(list, priv.getNum(), "priv");
        this.msgAddString(list, user, "len", "user");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgChangePrivRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_CHANGE_PRIV, 0, ret);
    }

    @Override
    public List<RtdbField> msgChangePwdFields(String user, int password) throws UnsupportedEncodingException {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_CHANGE_PASSWORD, 2, 0, 0, 1));
        this.msgAddInt(list, password, "password");
        this.msgAddString(list, user, "len", "user");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgChangePwdRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_CHANGE_PASSWORD, 0, ret);
    }

    @Override
    public List<RtdbField> msgClosePathFields() {
        return this.msgCommonFields(RtdbMsgID.MSG_CLOSE_PATH, 0);
    }

    @Override
    public List<RtdbField> msgClosePathRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_CLOSE_PATH, 0, ret);
    }

    @Override
    public List<RtdbField> msgConnectCountFields() {
        return this.msgCommonFields(RtdbMsgID.MSG_CONNECT_COUNT, 0);
    }

    @Override
    public List<RtdbField> msgConnectCountRespFields(int ret, int count) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_CONNECT_COUNT, 0, ret, count, 1));
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetAuthsFields(int count) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_AUTHORIZATIONS, 0, 0, count, 1));
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetAuthsRespFields(int ret, int count, int[] addrs, int[] masks, int[] privs, short[] lens, String[] descs) throws UnsupportedEncodingException {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_AUTHORIZATIONS, 3, 0, count, count));
        this.msgAddIntArray(list, addrs, "addresses");
        this.msgAddIntArray(list, masks, "masks");
        this.msgAddIntArray(list, privs, "privs");
        this.msgAddStringArray(list, descs, "lens", "descs");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetBlacklistFields(int count) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_BLACKLIST, 0, 0, count, 1));
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetBlacklistRespFields(int ret, int count, int[] addrs, int[] masks, short[] lens, String[] descs) throws UnsupportedEncodingException {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_BLACKLIST, 0, ret, count, count));
        this.msgAddIntArray(list, addrs, "addresses");
        this.msgAddIntArray(list, masks, "masks");
        this.msgAddStringArray(list, descs, "lens", "descs");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetConnectInfoFields(int socket) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_CONNECTION_INFO, 0, 0, 0, 1));
        this.msgAddInt(list, socket, "socket");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetConnectInfoRespFields(int ret, int ip, short port, int job, int job_time, int conn_time, String client, String process, String user) throws UnsupportedEncodingException {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_CONNECTION_INFO, 2, ret, 0, 1));
        this.msgAddInt(list, ip, "ip");
        this.msgAddShort(list, port, "port");
        this.msgAddInt(list, job, "job");
        this.msgAddInt(list, job_time, "job_time");
        this.msgAddInt(list, conn_time, "connect_time");
        this.msgAddString(list, client, "len1", "client");
        this.msgAddString(list, process, "len2", "process");
        this.msgAddString(list, user, "len3", "user");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetConnectsFields(int count) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_CONNECTIONS, 0, 0, count, 1));
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetConnectsRespFields(int count, int ids, int[] sockets) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_CONNECTIONS, 0, count, count, ids));
        this.msgAddIntArray(list, sockets, "sockets");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetDBInfoIntFields(int type) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_DB_INFO_INT, 0, 0, 0, 1));
        this.msgAddInt(list, type, "type");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetDBInfoIntRespFields(int ret, int value) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_DB_INFO_INT, 0, ret, 0, 1));
        this.msgAddInt(list, value, "value");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetDBInfoStrFields(int size, int type) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_DB_INFO_STR, 1, 0, size, 1));
        this.msgAddInt(list, type, "type");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetDBInfoStrRespFields(int ret, String str) throws UnsupportedEncodingException {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_DB_INFO_STR, 1, ret, 0, 1));
        this.msgAddString(list, str, "len", "str");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetDriversFields() {
        return this.msgCommonFields(RtdbMsgID.MSG_GET_LOGICAL_DRIVERS, 0);
    }

    @Override
    public List<RtdbField> msgGetDriversRespFields(int ret, String drivers) throws UnsupportedEncodingException {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_LOGICAL_DRIVERS, 1, ret, 0, 1));
        this.msgAddString(list, drivers, "len", "drivers");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetFileSizeFields(String file) throws UnsupportedEncodingException {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_FILE_SIZE, 1, 0, 0, 1));
        this.msgAddString(list, file, "len", "file");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetFileSizeRespFields(int ret, long filesize) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_FILE_SIZE, 0, ret, 0, 1));
        this.msgAddLong(list, filesize, "file size");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetTimeoutFields(int socket) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_TIMEOUT, 0, 0, 0, 1));
        this.msgAddInt(list, socket, "socket");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetTimeOutRespFields(int ret, int timeout) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_TIMEOUT, 0, ret, 0, 1));
        this.msgAddInt(list, timeout, "timeout");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetUsersFields(int count) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_USERS, 0, 0, count, 0));
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetUsersRespFields(int ret, int count, String[] users, int[] privs) throws UnsupportedEncodingException {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_USERS, 1, ret, count, count));
        this.msgAddIntArray(list, privs, "privs");
        this.msgAddStringArray(list, users, "lens", "users");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgHostTimeFields() {
        return this.msgCommonFields(RtdbMsgID.MSG_HOST_TIME, 0);
    }

    @Override
    public List<RtdbField> msgHostTimeRespFields(int ret, int datetime, int ms) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_HOST_TIME, 0, ret, 0, 1));
        this.msgAddInt(list, datetime, "datetime");
        this.msgAddInt(list, ms, "microsec");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgKillConnFields(int socket) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_KILL_CONNECTION, 0, 0, 0, 1));
        this.msgAddInt(list, socket, "socket");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgKillConnRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_KILL_CONNECTION, 0, ret);
    }

    @Override
    public List<RtdbField> msgLoginField(Login login) throws UnsupportedEncodingException {
        ArrayList<RtdbField> wFields = new ArrayList<RtdbField>();
        List<RtdbField> headerFields = this.getMsgHeader(RtdbMsgID.MSG_LOGIN, 1, 0, 0, 1);
        wFields.addAll(headerFields);
        this.msgAddInt(wFields, Crc32Util.getCRC32(login.getPassword().trim()), "password");
        String strUserName = login.getUsername().trim();
        this.msgAddString(wFields, strUserName, "len", "user");
        wFields.add(this.getMsgTail());
        return wFields;
    }

    @Override
    public List<RtdbField> msgLoginRespFields(int ret, int priv) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_LOGIN, 0, ret, 0, 1));
        this.msgAddInt(fields, priv, "priv");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgMakeDirFields(String dir) throws UnsupportedEncodingException {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_MKDIR, 1, 0, 0, 1));
        this.msgAddString(list, dir, "len", "dir");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgMakeDirRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_MKDIR, 0, ret);
    }

    @Override
    public List<RtdbField> msgOpenPathFields(String path) throws UnsupportedEncodingException {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_OPEN_PATH, 1, 0, 0, 1));
        this.msgAddString(list, path, "len", "path");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgOpenPathRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_OPEN_PATH, 0, ret);
    }

    @Override
    public List<RtdbField> msgReadFileFields(String file, int pos, int size) throws UnsupportedEncodingException {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_READ_FILE, 1, 0, 0, 1));
        this.msgAddLong(list, pos, "read pos");
        this.msgAddLong(list, size, "read size");
        this.msgAddString(list, file, "len", "file");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgReadFileRespFields(int ret, int len, byte[] content) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_READ_FILE, 1, ret, 0, 1));
        this.msgAddBytesLong(list, content, "len", "content");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgReadPathFields() {
        return this.msgCommonFields(RtdbMsgID.MSG_READ_PATH, 0);
    }

    @Override
    public List<RtdbField> msgReadPathRespFields(int ret, String path, int isdir, int at, int ct, int mt, long fieldsize) throws UnsupportedEncodingException {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_READ_PATH, 1, ret, 0, 1));
        this.msgAddInt(list, isdir, "isdir");
        this.msgAddInt(list, at, "at");
        this.msgAddInt(list, ct, "create");
        this.msgAddInt(list, mt, "modify");
        this.msgAddLong(list, fieldsize, "file size");
        this.msgAddString(list, path, "len", "path");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgRemoveAuthFields(int addr, int mask) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_REMOVE_AUTHORIZATION, 1, 0, 0, 1));
        this.msgAddInt(list, addr, "address");
        this.msgAddInt(list, mask, "mask");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgRemoveAuthRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_REMOVE_AUTHORIZATION, 0, ret);
    }

    @Override
    public List<RtdbField> msgRemoveBlacklistFields(int addr, int mask) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_REMOVE_BLACKLIST, 0, 0, 0, 1));
        this.msgAddInt(list, addr, "addr");
        this.msgAddInt(list, mask, "mask");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgRemoveBlacklistRespRields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_REMOVE_BLACKLIST, 0, ret);
    }

    @Override
    public List<RtdbField> msgRemoveUserFields(String user) throws UnsupportedEncodingException {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_REMOVE_USER, 1, 0, 0, 1));
        this.msgAddString(list, user, "len", "user");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgRemoveUserRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_REMOVE_USER, 0, ret);
    }

    @Override
    public List<RtdbField> msgSetDBInfoIntFields(int type, int value) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_SET_DB_INFO_INT, 0, 0, 0, 1));
        this.msgAddInt(list, type, "type");
        this.msgAddInt(list, value, "value");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgSetDBInfoIntRespFields(int ret) {
        return this.msgCommonRespFields1(RtdbMsgID.MSG_SET_DB_INFO_INT, 0, ret);
    }

    @Override
    public List<RtdbField> msgSetDBInfoStrFields(int type, String str) throws UnsupportedEncodingException {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_SET_DB_INFO_STR, 1, 0, 0, 1));
        this.msgAddInt(list, type, "type");
        this.msgAddString(list, str, "len", "str");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgSetDBInfoStrRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_SET_DB_INFO_STR, 0, ret);
    }

    @Override
    public List<RtdbField> msgSetTimeoutFields(int socket, int timeout) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_SET_TIMEOUT, 0, 0, 0, 1));
        this.msgAddInt(list, socket, "socket");
        this.msgAddInt(list, timeout, "timeout");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgSetTimeoutRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_SET_TIMEOUT, 0, ret);
    }

    @Override
    public List<RtdbField> msgSubscribeSnapshotsCallbackFields(int ret, int count, int[] ids, int[] datetimes, short[] ms, double[] values, long[] states, short[] qualities, int[] errors) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_SUBSCRIBE_SNAPSHOTS_CALLBACK, 1, ret, count, count));
        this.msgAddIntArray(list, ids, "ids");
        this.msgAddIntArray(list, datetimes, "datetimes");
        this.msgAddShortArray(list, ms, "ms");
        this.msgAddDoubleArray(list, values, "values");
        this.msgAddLongArray(list, states, "states");
        this.msgAddShortArray(list, qualities, "qualities");
        this.msgAddIntArray(list, errors, "errors");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgSubscribeTagsCallbackFields(int ret, int count, int[] ids, int what) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_SUBSCRIBE_TAGS_CALLBACK, 1, ret, count, count));
        this.msgAddInt(list, what, "reason");
        this.msgAddIntArray(list, ids, "ids");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgUpdateAuthFields(int addr, int mask, int newAddr, int newMask, RtdbPrivGroup priv, String desc) throws UnsupportedEncodingException {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_UPDATE_AUTHORIZATION, 1, 0, 0, 1));
        this.msgAddInt(list, addr, "address");
        this.msgAddInt(list, mask, "mark");
        this.msgAddInt(list, newAddr, "address_new");
        this.msgAddInt(list, newMask, "mask_new");
        this.msgAddInt(list, priv.getNum(), "priv");
        this.msgAddString(list, desc, "len", "desc");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgUpdateAuthRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_UPDATE_AUTHORIZATION, 0, ret);
    }

    @Override
    public List<RtdbField> msgUpdateBlacklistFields(int addr, int mask, int newAddr, int newMask, String desc) throws UnsupportedEncodingException {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_UPDATE_BLACKLIST, 0, 0, 0, 1));
        this.msgAddInt(list, addr, "addr");
        this.msgAddInt(list, mask, "mask");
        this.msgAddInt(list, newAddr, "address_new");
        this.msgAddInt(list, newMask, "mask_new");
        this.msgAddString(list, desc, "len", "desc");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgUpdateBlacklistRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_UPDATE_BLACKLIST, 0, ret);
    }

    @Override
    public List<RtdbField> msgConnectFields(String client, String process, String user) throws UnsupportedEncodingException {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        List<RtdbField> headerFields = this.getMsgHeader(RtdbMsgID.MSG_CONNECT, 0, 0, 0, 1);
        fields.addAll(headerFields);
        this.msgAddString(fields, client, "len1", "client");
        this.msgAddString(fields, process, "len2", "process");
        this.msgAddString(fields, user, "len3", "user");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgConnectRespFields(int ret, int authorized, int priv) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        List<RtdbField> headerFields = this.getMsgHeader(RtdbMsgID.MSG_CONNECT, 0, ret, 0, 1);
        fields.addAll(headerFields);
        this.msgAddShort(fields, (short)authorized, "authorized");
        this.msgAddInt(fields, priv, "priv");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetMaxBlobLenRespFields() {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_MAX_BLOB_LEN, 0, 0, 0, 1));
        this.msgAddInt(fields, 0, "len");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetMaxBlobLenFields() {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_MAX_BLOB_LEN, 0, 0, 0, 1));
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> calcSegmentFields(RtdbCalcPoint calc) throws UnsupportedEncodingException {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        if (calc != null) {
            this.msgAddString(list, calc.getEquation(), "len", "equation");
            this.msgAddShort(list, (short)calc.getTrigger().getNum(), "trigger");
            this.msgAddShort(list, (short)calc.getTimecopy().getNum(), "timecopy");
            this.msgAddInt(list, calc.getPeriod(), "period");
        } else {
            this.msgAddEmptyString(list, "len", "equation");
            this.msgAddEmptyPointer(list, 2, "trigger");
            this.msgAddEmptyPointer(list, 2, "timecopy");
            this.msgAddEmptyPointer(list, 3, "period");
        }
        return list;
    }

    @Override
    public List<RtdbField> namedDataTypeSegmentFields(NamedDataTypeField namedDataTypeField) throws UnsupportedEncodingException {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        if (namedDataTypeField != null) {
            this.msgAddString(list, namedDataTypeField.getFieldName(), "len1", "fieldName");
            this.msgAddInt(list, namedDataTypeField.getType().getNum(), "fieldType");
            this.msgAddInt(list, namedDataTypeField.getLength(), "fieldLength");
            this.msgAddString(list, namedDataTypeField.getDesc(), "len2", "fieldDesc");
        } else {
            this.msgAddEmptyString(list, "len1", "fieldName");
            this.msgAddEmptyString(list, "len2", "fieldDesc");
        }
        return list;
    }

    @Override
    public List<RtdbField> scanSegmentFields(RtdbScanPoint scan) throws UnsupportedEncodingException {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        if (scan != null) {
            this.msgAddString(list, scan.getSource(), "len1", "source");
            this.msgAddShort(list, scan.getScan(), "scan");
            this.msgAddString(list, scan.getInstrument(), "len2", "instrument");
            list.add(new RtdbField(3, 0L, 0.0, scan.getLocation(), 5, "locations"));
            list.add(new RtdbField(3, 0L, 0.0, scan.getUserints(), 2, "userints"));
            list.add(new RtdbField(5, 0L, 0.0, scan.getUserreals(), 2, "userreals"));
        } else {
            this.msgAddEmptyString(list, "len1", "source");
            this.msgAddEmptyPointer(list, 2, "scan");
            this.msgAddEmptyString(list, "len2", "instrument");
            this.msgAddEmptyPointer(list, 3, 5, "locations");
            this.msgAddEmptyPointer(list, 3, 2, "userints");
            this.msgAddEmptyPointer(list, 5, 2, "userreals");
        }
        return list;
    }
}

