/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.api.msg;

import com.google.protobuf.ByteString;
import com.rtdb.api.enums.RtdbMsgID;
import com.rtdb.api.impl.adapter.SnapshotAdapter;
import com.rtdb.api.model.DateTimeNS;
import com.rtdb.api.model.RtdbField;
import com.rtdb.api.model.RtdbNamedTypeData;
import com.rtdb.api.protocol.DatagramSnapshots;
import com.rtdb.api.util.DateUtil;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SnapshotProtocol30
extends SnapshotAdapter {
    private static SnapshotProtocol30 snapshotProtocol = null;

    private SnapshotProtocol30() {
    }

    public static synchronized SnapshotProtocol30 getInstance() {
        if (snapshotProtocol == null) {
            snapshotProtocol = new SnapshotProtocol30();
        }
        return snapshotProtocol;
    }

    @Override
    public List<RtdbField> msgGetSnapshotsFields(int count, int[] ids) {
        DatagramSnapshots.datagram_get_snapshots.Builder sendBuilder = DatagramSnapshots.datagram_get_snapshots.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length);
        if (ids != null && ids.length > 0) {
            listIds = new ArrayList(ids.length);
            for (int id : ids) {
                listIds.add(id);
            }
        }
        sendBuilder.addAllIds(listIds);
        DatagramSnapshots.datagram_get_snapshots _packet = sendBuilder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_SNAPSHOTS, 0, 0, count, 1, bts.length);
        this.msgAddBytes(field, bts, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetSnapshotsRespFields(int count, int[] ids, Date[] datetimes, double[] values, long[] states, short[] qualities, int[] errors) {
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_SNAPSHOTS, 0, 0, count, 1, 0);
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgPutSnapshotsFields(int count, int[] ids, int[] datetimes, int[] ms_temp, double[] values, long[] states, short[] qualities) {
        DatagramSnapshots.datagram_put_snapshots.Builder builder = DatagramSnapshots.datagram_put_snapshots.newBuilder();
        ArrayList<Integer> listId = new ArrayList<Integer>(ids.length > 0 ? ids.length : 10);
        ArrayList<Integer> listDatetime = new ArrayList<Integer>(datetimes.length > 0 ? datetimes.length : 10);
        ArrayList<Integer> listms = new ArrayList<Integer>(ms_temp.length > 0 ? ms_temp.length : 10);
        ArrayList<Double> listValues = new ArrayList<Double>(values.length > 0 ? values.length : 10);
        ArrayList<Long> listStates = new ArrayList<Long>(states.length > 0 ? states.length : 10);
        ArrayList<Integer> listQualitie = new ArrayList<Integer>(qualities.length > 0 ? qualities.length : 10);
        if (ids != null && ids.length > 0) {
            for (int id : ids) {
                listId.add(id);
            }
        }
        if (datetimes != null && datetimes.length > 0) {
            for (int dt : datetimes) {
                listDatetime.add(dt);
            }
        }
        if (ms_temp != null && ms_temp.length > 0) {
            for (int ms : ms_temp) {
                listms.add(ms);
            }
        }
        if (values != null && values.length > 0) {
            for (double vl : values) {
                listValues.add(vl);
            }
        }
        if (states != null && states.length > 0) {
            for (long st : states) {
                listStates.add(st);
            }
        }
        if (qualities != null && qualities.length > 0) {
            for (short qa : qualities) {
                listQualitie.add(Integer.valueOf(qa));
            }
        }
        builder.addAllIds(listId);
        builder.addAllDatetimes(listDatetime);
        builder.addAllMs(listms);
        builder.addAllValues(listValues);
        builder.addAllStates(listStates);
        builder.addAllQualities(listQualitie);
        DatagramSnapshots.datagram_put_snapshots datagram_put_snapshots2 = builder.build();
        byte[] myByte = datagram_put_snapshots2.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_PUT_SNAPSHOTS, 0, 0, count, 1, myByte.length);
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgPutSnapshotsRespFields(int count, int[] errors) {
        ArrayList<Integer> resperrors = new ArrayList<Integer>(errors.length > 0 ? errors.length : 10);
        if (errors != null && errors.length > 0) {
            for (int error : errors) {
                resperrors.add(error);
            }
        }
        DatagramSnapshots.datagram_put_snapshots_resp.Builder respBuilder = DatagramSnapshots.datagram_put_snapshots_resp.newBuilder();
        respBuilder.addAllErrors(resperrors);
        DatagramSnapshots.datagram_put_snapshots_resp _packet = respBuilder.build();
        byte[] respBytes = _packet.toByteArray();
        for (int i = 0; i < errors.length; ++i) {
            errors[i] = _packet.getErrors(i);
        }
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_PUT_SNAPSHOTS, 0, 0, count, 1, respBytes.length);
        this.msgAddBytes(fields, respBytes, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgFixSnapshotsFields(int count, int[] ids, int[] datetimes, int[] ms, double[] values, long[] states, short[] qualities) {
        DatagramSnapshots.datagram_fix_snapshots.Builder build = DatagramSnapshots.datagram_fix_snapshots.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length > 0 ? ids.length : 10);
        ArrayList<Integer> listDatetime = new ArrayList<Integer>(datetimes.length > 0 ? datetimes.length : 10);
        ArrayList<Integer> listMs = new ArrayList<Integer>(ms.length > 0 ? ms.length : 10);
        ArrayList<Double> listValues = new ArrayList<Double>(values.length > 0 ? values.length : 10);
        ArrayList<Long> listStates = new ArrayList<Long>(states.length > 0 ? states.length : 10);
        ArrayList<Integer> listQualites = new ArrayList<Integer>(qualities.length > 0 ? qualities.length : 10);
        if (ids != null && ids.length > 0) {
            for (int id : ids) {
                listIds.add(id);
            }
        }
        if (datetimes != null && datetimes.length > 0) {
            for (int dt : datetimes) {
                listDatetime.add(dt);
            }
        }
        if (ms != null && ms.length > 0) {
            for (int m : ms) {
                listMs.add(m);
            }
        }
        if (values != null && values.length > 0) {
            for (double vl : values) {
                listValues.add(vl);
            }
        }
        if (states != null && states.length > 0) {
            for (long st : states) {
                listStates.add(st);
            }
        }
        if (qualities != null && qualities.length > 0) {
            for (short qa : qualities) {
                listQualites.add(Integer.valueOf(qa));
            }
        }
        build.addAllIds(listIds);
        build.addAllDatetimes(listDatetime);
        build.addAllMs(listMs);
        build.addAllValues(listValues);
        build.addAllStates(listStates);
        build.addAllQualities(listQualites);
        DatagramSnapshots.datagram_fix_snapshots datagram_fix_snapshots2 = build.build();
        byte[] myByte = datagram_fix_snapshots2.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_FIX_SNAPSHOTS, 0, 0, count, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgFixSnapshotsRespFields(int ret, int count, int size, int[] errors) {
        DatagramSnapshots.datagram_fix_snapshots_resp.Builder build = DatagramSnapshots.datagram_fix_snapshots_resp.newBuilder();
        ArrayList<Integer> listErrors = new ArrayList<Integer>(errors.length > 0 ? errors.length : 10);
        if (errors != null && errors.length > 0) {
            for (int er : errors) {
                listErrors.add(er);
            }
        }
        build.addAllErrors(listErrors);
        DatagramSnapshots.datagram_fix_snapshots_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_FIX_SNAPSHOTS, 0, ret, count, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetCoorSnapshotsFields(int count, int[] ids) {
        DatagramSnapshots.datagram_get_coor_snapshots.Builder build = DatagramSnapshots.datagram_get_coor_snapshots.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length > 0 ? ids.length : 10);
        if (ids != null && ids.length > 0) {
            for (int id : ids) {
                listIds.add(id);
            }
        }
        build.addAllIds(listIds);
        DatagramSnapshots.datagram_get_coor_snapshots _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_COOR_SNAPSHOTS, 0, 0, count, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetCoorSnapshotsRespFields(int ret, int count, int[] datetimes, int[] ms, float[] x, float[] y, short[] qualities, int[] errors) {
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_COOR_SNAPSHOTS, 0, 0, 0, 1, 0);
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgPutCoorSnapshotsFields(int count, int[] ids, int[] datetimes, int[] ms, float[] x, float[] y, short[] qualities) {
        DatagramSnapshots.datagram_put_coor_snapshots.Builder build = DatagramSnapshots.datagram_put_coor_snapshots.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length > 0 ? ids.length : 10);
        ArrayList<Integer> listDatetime = new ArrayList<Integer>(datetimes.length > 0 ? datetimes.length : 10);
        ArrayList<Integer> listMs = new ArrayList<Integer>(ms.length > 0 ? ms.length : 10);
        ArrayList<Integer> listQualities = new ArrayList<Integer>(qualities.length > 0 ? qualities.length : 10);
        ArrayList<Float> listX = new ArrayList<Float>(x.length > 0 ? x.length : 10);
        ArrayList<Float> listY = new ArrayList<Float>(y.length > 0 ? y.length : 10);
        if (ids != null && ids.length > 0) {
            for (int id : ids) {
                listIds.add(id);
            }
        }
        if (datetimes != null && datetimes.length > 0) {
            for (int dt : datetimes) {
                listDatetime.add(dt);
            }
        }
        if (ms != null && ms.length > 0) {
            for (int m : ms) {
                listMs.add(m);
            }
        }
        if (x != null && x.length > 0) {
            for (float x1 : x) {
                listX.add(Float.valueOf(x1));
            }
        }
        if (y != null && y.length > 0) {
            for (float y1 : y) {
                listY.add(Float.valueOf(y1));
            }
        }
        if (qualities != null && qualities.length > 0) {
            for (short qa : qualities) {
                listQualities.add(Integer.valueOf(qa));
            }
        }
        build.addAllIds(listIds);
        build.addAllDatetimes(listDatetime);
        build.addAllMs(listMs);
        build.addAllX(listX);
        build.addAllY(listY);
        build.addAllQualities(listQualities);
        DatagramSnapshots.datagram_put_coor_snapshots datagram_put_coor_snapshots2 = build.build();
        byte[] myByte = datagram_put_coor_snapshots2.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_PUT_COOR_SNAPSHOTS, 0, 0, count, 1, myByte.length);
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgPutCoorSnapshotsRespFields(int ret, int count, int size, int[] errors) {
        DatagramSnapshots.datagram_put_coor_snapshots_resp.Builder build = DatagramSnapshots.datagram_put_coor_snapshots_resp.newBuilder();
        ArrayList<Integer> listErrors = new ArrayList<Integer>(errors.length > 0 ? errors.length : 10);
        if (errors != null && errors.length > 0) {
            for (int er : errors) {
                listErrors.add(er);
            }
        }
        build.addAllErrors(listErrors);
        DatagramSnapshots.datagram_put_coor_snapshots_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_PUT_COOR_SNAPSHOTS, 0, ret, count, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgFixCoorSnapshotsFields(int count, int[] ids, int[] datetimes, int[] ms, float[] x, float[] y, short[] qualities) {
        DatagramSnapshots.datagram_fix_coor_snapshots.Builder build = DatagramSnapshots.datagram_fix_coor_snapshots.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length > 0 ? ids.length : 10);
        ArrayList<Integer> listDatetime = new ArrayList<Integer>(datetimes.length > 0 ? datetimes.length : 10);
        ArrayList<Integer> listMs = new ArrayList<Integer>(ms.length > 0 ? ms.length : 10);
        ArrayList<Integer> listQualities = new ArrayList<Integer>(qualities.length > 0 ? qualities.length : 10);
        ArrayList<Float> listX = new ArrayList<Float>(x.length > 0 ? x.length : 10);
        ArrayList<Float> listY = new ArrayList<Float>(y.length > 0 ? y.length : 10);
        if (ids != null && ids.length > 0) {
            for (int id : ids) {
                listIds.add(id);
            }
        }
        if (datetimes != null && datetimes.length > 0) {
            for (int dt : datetimes) {
                listDatetime.add(dt);
            }
        }
        if (ms != null && ms.length > 0) {
            for (int m : ms) {
                listMs.add(m);
            }
        }
        if (x != null && x.length > 0) {
            for (float x1 : x) {
                listX.add(Float.valueOf(x1));
            }
        }
        if (y != null && y.length > 0) {
            for (float y1 : y) {
                listY.add(Float.valueOf(y1));
            }
        }
        if (qualities != null && qualities.length > 0) {
            for (short qa : qualities) {
                listQualities.add(Integer.valueOf(qa));
            }
        }
        build.addAllIds(listIds);
        build.addAllDatetimes(listDatetime);
        build.addAllMs(listMs);
        build.addAllX(listX);
        build.addAllY(listY);
        build.addAllQualities(listQualities);
        DatagramSnapshots.datagram_fix_coor_snapshots datagram_fix_coor_snapshots2 = build.build();
        byte[] myByte = datagram_fix_coor_snapshots2.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_FIX_COOR_SNAPSHOTS, 0, 0, count, count, myByte.length);
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgFixCoorSnapshotsRespFields(int ret, int count, int size, int[] errors) {
        DatagramSnapshots.datagram_fix_coor_snapshots_resp.Builder builder = DatagramSnapshots.datagram_fix_coor_snapshots_resp.newBuilder();
        ArrayList<Integer> listErrors = new ArrayList<Integer>();
        if (errors != null && errors.length > 0) {
            for (int er : errors) {
                listErrors.add(er);
            }
        }
        builder.addAllErrors(listErrors);
        DatagramSnapshots.datagram_fix_coor_snapshots_resp _packet = builder.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_FIX_COOR_SNAPSHOTS, 0, ret, count, size, myByte.length);
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetBlobSnapshotFields(int id, int count) {
        DatagramSnapshots.datagram_get_blob_snapshot.Builder builder = DatagramSnapshots.datagram_get_blob_snapshot.newBuilder();
        builder.setId(id);
        DatagramSnapshots.datagram_get_blob_snapshot myBuilder = builder.build();
        byte[] myBytes = myBuilder.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_BLOB_SNAPSHOT, 0, 0, 1, count, myBytes.length);
        this.msgAddBytes(fields, myBytes, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetBlobSnapshotRespFields(int ret, int datetime, short ms, short len, byte[] blob, short quality) {
        DatagramSnapshots.datagram_get_blob_snapshot_resp.Builder builder = DatagramSnapshots.datagram_get_blob_snapshot_resp.newBuilder();
        builder.setDatetime(datetime);
        builder.setMs(ms);
        builder.setLen(len);
        builder.setBlob(ByteString.copyFrom(blob));
        builder.setQuality(quality);
        DatagramSnapshots.datagram_get_blob_snapshot_resp _package = builder.build();
        byte[] myBytes = _package.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_BLOB_SNAPSHOT, 0, ret, 1, 1, myBytes.length);
        this.msgAddBytes(fields, myBytes, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetBolbSnapshotsFields(int count, int[] ids, short[] lens) {
        DatagramSnapshots.datagram_get_blob_snapshots.Builder builder = DatagramSnapshots.datagram_get_blob_snapshots.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length > 0 ? ids.length : 10);
        ArrayList<Integer> listLens = new ArrayList<Integer>(lens.length > 0 ? lens.length : 10);
        if (ids != null && ids.length > 0) {
            for (int id : ids) {
                listIds.add(id);
            }
        }
        if (lens != null && lens.length > 0) {
            for (short len : lens) {
                listLens.add(Integer.valueOf(len));
            }
        }
        builder.addAllIds(listIds);
        builder.addAllLens(listLens);
        DatagramSnapshots.datagram_get_blob_snapshots datagram_get_blob_snapshots2 = builder.build();
        byte[] myBytes = datagram_get_blob_snapshots2.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_BLOB_SNAPSHOTS, 0, 0, count, 1, myBytes.length);
        this.msgAddBytes(fields, myBytes, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetBlobSnapshotsRespFields(int ret, int count, int size, int[] datetimes, int[] ms, short[] lens, byte[][] blobs, short[] qualities, int[] errors) {
        DatagramSnapshots.datagram_get_blob_snapshots_resp.Builder builder = DatagramSnapshots.datagram_get_blob_snapshots_resp.newBuilder();
        DatagramSnapshots.datagram_get_blob_snapshots_resp build = builder.build();
        byte[] byteArray = build.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_BLOB_SNAPSHOTS, 0, 0, 0, 1, 0);
        this.msgAddBytes(fields, byteArray, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgPutBlobSnapshotFields(int id, int datetime, int ms, short len, byte[] blob, short quality) {
        DatagramSnapshots.datagram_put_blob_snapshot.Builder build = DatagramSnapshots.datagram_put_blob_snapshot.newBuilder();
        build.setId(id);
        build.setDatetime(datetime);
        build.setMs(ms);
        build.setLen(len);
        int dim = 1;
        if (blob != null && blob.length > 0) {
            ByteString by = ByteString.copyFrom(blob);
            build.setBlob(by);
            dim = blob.length;
        } else {
            build.setBlob(null);
        }
        build.setQuality(quality);
        DatagramSnapshots.datagram_put_blob_snapshot _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_PUT_BLOB_SNAPSHOT, 1, 0, len, dim, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgPutBlobSnapshotRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_PUT_BLOB_SNAPSHOT, 0, ret);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<RtdbField> msgPutBlobSnapshotsFields(boolean onsend, int totalCount, int count, int[] ids, int[] datetimes, int[] ms, short[] lens, byte[][] blobs, short[] qualities) {
        void var17_27;
        DatagramSnapshots.datagram_put_blob_snapshots.Builder build = DatagramSnapshots.datagram_put_blob_snapshots.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length > 0 ? ids.length : 10);
        ArrayList<Integer> listDatetime = new ArrayList<Integer>(datetimes.length > 0 ? datetimes.length : 10);
        ArrayList<Integer> listMs = new ArrayList<Integer>(ms.length > 0 ? ms.length : 10);
        ArrayList<Integer> listQualites = new ArrayList<Integer>(qualities.length > 0 ? qualities.length : 10);
        ArrayList<Integer> listLens = new ArrayList<Integer>(lens.length > 0 ? lens.length : 10);
        ArrayList<ByteString> listByteString = new ArrayList<ByteString>(blobs.length > 0 ? blobs.length : 10);
        if (ids != null && ids.length > 0) {
            for (int id : ids) {
                listIds.add(id);
            }
        }
        if (datetimes != null && datetimes.length > 0) {
            for (int dt : datetimes) {
                listDatetime.add(dt);
            }
        }
        if (ms != null && ms.length > 0) {
            for (int m : ms) {
                listMs.add(m);
            }
        }
        if (lens != null && lens.length > 0) {
            for (short le : lens) {
                listLens.add(Integer.valueOf(le));
            }
        }
        if (qualities != null && qualities.length > 0) {
            for (int qa : qualities) {
                listQualites.add(qa);
            }
        }
        boolean bl = false;
        if (blobs != null && blobs.length > 0) {
            for (byte[] bls : blobs) {
                if (bls == null || bls.length <= 0) continue;
                listByteString.add(ByteString.copyFrom(bls));
                var17_27 += bls.length;
            }
        }
        build.addAllIds(listIds);
        build.addAllDatetimes(listDatetime);
        build.addAllMs(listMs);
        build.addAllLens(listLens);
        build.addAllBlobs(listByteString);
        build.addAllQualities(listQualites);
        DatagramSnapshots.datagram_put_blob_snapshots _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_PUT_BLOB_SNAPSHOTS, 0, 0, count, var17_27 == false ? 1 : var17_27, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgPutBlobSnapshotsRespFields(int ret, int count, int size, int[] errors) {
        DatagramSnapshots.datagram_put_blob_snapshots_resp.Builder build = DatagramSnapshots.datagram_put_blob_snapshots_resp.newBuilder();
        ArrayList<Integer> listErrors = new ArrayList<Integer>(errors.length > 0 ? errors.length : 10);
        if (errors != null && errors.length > 0) {
            for (int er : errors) {
                listErrors.add(er);
            }
        }
        build.addAllErrors(listErrors);
        DatagramSnapshots.datagram_put_blob_snapshots_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_PUT_BLOB_SNAPSHOTS, 0, 0, count, 1, myByte.length);
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public synchronized List<RtdbField> msgSubscribeSnapshotsFields(int count, int[] ids) {
        DatagramSnapshots.datagram_subscribe_snapshots.Builder build = DatagramSnapshots.datagram_subscribe_snapshots.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length > 0 ? ids.length : 10);
        if (ids != null && ids.length > 0) {
            for (int id : ids) {
                listIds.add(id);
            }
        }
        build.addAllIds(listIds);
        DatagramSnapshots.datagram_subscribe_snapshots _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_SUBSCRIBE_SNAPSHOTS, 0, 0, count, 1, myByte.length);
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public synchronized List<RtdbField> msgSubscribeSnapshotsRespFields(int ret, int count, int size, int[] errors) {
        DatagramSnapshots.datagram_subscribe_snapshots_resp.Builder build = DatagramSnapshots.datagram_subscribe_snapshots_resp.newBuilder();
        ArrayList<Integer> listErrors = new ArrayList<Integer>(errors.length > 0 ? errors.length : 10);
        if (errors != null && errors.length > 0) {
            for (int er : errors) {
                listErrors.add(er);
            }
        }
        build.addAllErrors(listErrors);
        DatagramSnapshots.datagram_subscribe_snapshots_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_SUBSCRIBE_SNAPSHOTS, 0, ret, count, 1, myByte.length);
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgCancelSnapshotsSubscribeFields() {
        return this.msgCommonFields(RtdbMsgID.MSG_CANCEL_SUBSCRIBE_SNAPSHOTS, 0);
    }

    @Override
    public List<RtdbField> msgGetDateTimeSnapshotsFields(int[] ids, int count) {
        DatagramSnapshots.datagram_get_datetime_snapshots.Builder builder = DatagramSnapshots.datagram_get_datetime_snapshots.newBuilder();
        ArrayList<Integer> listIds = null;
        if (ids != null && ids.length > 0) {
            listIds = new ArrayList<Integer>(ids.length);
            for (int id : ids) {
                listIds.add(id);
            }
        }
        builder.addAllIds(listIds);
        DatagramSnapshots.datagram_get_datetime_snapshots mybuilder = builder.build();
        byte[] bytes = mybuilder.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_DATETIME_SNAPSHOTS, 0, 0, count, 1, bytes.length);
        this.msgAddBytes(fields, bytes, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetDateTimeSnapshotsRespFields(int count, int[] dateTimes, int[] ms, double[] values, long[] states, short[] qualities, int[] errors, int[] types) {
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_DATETIME_SNAPSHOTS, 0, 0, count, 1, 0);
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgPutDateTimeSnapsHotsFields(int[] ids, int[] datetimes, int[] ms, double[] values, long[] states, short[] qualities) {
        int count = ids.length;
        DatagramSnapshots.datagram_fix_snapshots.Builder build = DatagramSnapshots.datagram_fix_snapshots.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length > 0 ? ids.length : 10);
        ArrayList<Integer> listDatetime = new ArrayList<Integer>(datetimes.length > 0 ? datetimes.length : 10);
        ArrayList<Integer> listMs = new ArrayList<Integer>(ms.length > 0 ? ms.length : 10);
        ArrayList<Double> listValues = new ArrayList<Double>(values.length > 0 ? values.length : 10);
        ArrayList<Long> listStates = new ArrayList<Long>(states.length > 0 ? states.length : 10);
        ArrayList<Integer> listQualites = new ArrayList<Integer>(qualities.length > 0 ? qualities.length : 10);
        if (ids != null && ids.length > 0) {
            for (int id : ids) {
                listIds.add(id);
            }
        }
        if (datetimes != null && datetimes.length > 0) {
            for (int dt : datetimes) {
                listDatetime.add(dt);
            }
        }
        if (ms != null && ms.length > 0) {
            for (int m : ms) {
                listMs.add(m);
            }
        }
        if (values != null && values.length > 0) {
            for (double vl : values) {
                listValues.add(vl);
            }
        }
        if (states != null && states.length > 0) {
            for (long st : states) {
                listStates.add(st);
            }
        }
        if (qualities != null && qualities.length > 0) {
            for (short qa : qualities) {
                listQualites.add(Integer.valueOf(qa));
            }
        }
        build.addAllIds(listIds);
        build.addAllDatetimes(listDatetime);
        build.addAllMs(listMs);
        build.addAllValues(listValues);
        build.addAllStates(listStates);
        build.addAllQualities(listQualites);
        DatagramSnapshots.datagram_fix_snapshots datagram_fix_snapshots2 = build.build();
        byte[] myByte = datagram_fix_snapshots2.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_PUT_DATETIME_SNAPSHOTS, 0, 0, count, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgPutDateTimeSnapsHotsRespFields(int[] errors) {
        int count = errors.length;
        DatagramSnapshots.datagram_put_datetime_snapshots_resp.Builder build = DatagramSnapshots.datagram_put_datetime_snapshots_resp.newBuilder();
        ArrayList<Integer> listErrors = new ArrayList<Integer>(errors.length > 0 ? errors.length : 10);
        if (errors != null && errors.length > 0) {
            for (int er : errors) {
                listErrors.add(er);
            }
        }
        build.addAllErrors(listErrors);
        DatagramSnapshots.datagram_put_datetime_snapshots_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_PUT_DATETIME_SNAPSHOTS, 0, 0, count, 1, myByte.length);
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetNamedTypeSnapshotFields(int id, short len) {
        DatagramSnapshots.datagram_get_named_type_snapshot.Builder build = DatagramSnapshots.datagram_get_named_type_snapshot.newBuilder();
        build.setId(id);
        DatagramSnapshots.datagram_get_named_type_snapshot _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_NAMED_TYPE_SNAPSHOT, 0, 0, 1, len, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetNamedTypeSnapshotRespFields(short len) {
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_NAMED_TYPE_SNAPSHOT, 0, 0, 0, 0, 0);
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetNamedTypeSnapshotsFields(int[] ids, short[] lengths) {
        int count = ids.length;
        DatagramSnapshots.datagram_get_named_type_snapshots.Builder build = DatagramSnapshots.datagram_get_named_type_snapshots.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length > 0 ? ids.length : 10);
        ArrayList<Integer> listLens = new ArrayList<Integer>(lengths.length > 0 ? lengths.length : 10);
        if (ids != null && ids.length > 0) {
            for (int id : ids) {
                listIds.add(id);
            }
        }
        if (lengths != null && lengths.length > 0) {
            for (short le : lengths) {
                listLens.add(Integer.valueOf(le));
            }
        }
        build.addAllIds(listIds);
        build.addAllLens(listLens);
        DatagramSnapshots.datagram_get_named_type_snapshots datagram_get_named_type_snapshots2 = build.build();
        byte[] myByte = datagram_get_named_type_snapshots2.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_NAMED_TYPE_SNAPSHOTS, 0, 0, count, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgGetNamedTypeSnapshotsRespFields() {
        DatagramSnapshots.datagram_get_named_type_snapshots_resp.Builder build = DatagramSnapshots.datagram_get_named_type_snapshots_resp.newBuilder();
        DatagramSnapshots.datagram_get_named_type_snapshots_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_GET_NAMED_TYPE_SNAPSHOTS, 0, 0, 0, 0, 0);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgPutNamedTypeSnapshotFields(int id, int datetime, int ms, short length, byte[] bytes, short quality) {
        DatagramSnapshots.datagram_put_named_type_snapshot.Builder build = DatagramSnapshots.datagram_put_named_type_snapshot.newBuilder();
        build.setId(id);
        build.setDatetime(datetime);
        build.setMs(ms);
        build.setLen(length);
        build.setObject(ByteString.copyFrom(bytes));
        build.setQuality(quality);
        DatagramSnapshots.datagram_put_named_type_snapshot _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_PUT_NAMED_TYPE_SNAPSHOT, 0, 0, 1, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgPutNamedTypeSnapshotRespFields() {
        DatagramSnapshots.datagram_put_named_type_snapshot_resp.Builder build = DatagramSnapshots.datagram_put_named_type_snapshot_resp.newBuilder();
        DatagramSnapshots.datagram_put_named_type_snapshot_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_PUT_NAMED_TYPE_SNAPSHOT, 0, 0, 1, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgPutNamedTypeSnapshotsFields(List<RtdbNamedTypeData> list) throws ParseException {
        int count = list.size();
        int[] ids = new int[count];
        int[] datetimes = new int[count];
        int[] ms = new int[count];
        short[] lens = new short[count];
        byte[][] objects = new byte[count][];
        short[] qualities = new short[count];
        for (int i = 0; i < count; ++i) {
            RtdbNamedTypeData model = list.get(i);
            ids[i] = model.getId();
            Object date = model.getDatetime();
            if (date.getClass().equals(Date.class)) {
                datetimes[i] = DateUtil.getSecond((Date)date);
                ms[i] = DateUtil.getMilSecond((Date)date);
            } else if (date.getClass().equals(DateTimeNS.class)) {
                datetimes[i] = DateUtil.getSecond(((DateTimeNS)date).getDatetime());
                ms[i] = ((DateTimeNS)date).getNanosecond();
            }
            byte[] bytes = model.getValue();
            lens[i] = (short)bytes.length;
            objects[i] = bytes;
            qualities[i] = model.getQuality().getNum();
        }
        DatagramSnapshots.datagram_put_named_type_snapshots.Builder build = DatagramSnapshots.datagram_put_named_type_snapshots.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(count);
        ArrayList<Integer> listDatetime = new ArrayList<Integer>(count);
        ArrayList<Integer> listMs = new ArrayList<Integer>(count);
        ArrayList<Integer> listLens = new ArrayList<Integer>(count);
        ArrayList<Integer> listQualites = new ArrayList<Integer>(count);
        ArrayList<ByteString> listBytes = new ArrayList<ByteString>(count);
        if (ids != null && ids.length > 0) {
            for (int id : ids) {
                listIds.add(id);
            }
        }
        if (datetimes != null && datetimes.length > 0) {
            for (int dt : datetimes) {
                listDatetime.add(dt);
            }
        }
        if (ms != null && ms.length > 0) {
            for (int m : ms) {
                listMs.add(m);
            }
        }
        if (lens != null && lens.length > 0) {
            for (short le : lens) {
                listLens.add(Integer.valueOf(le));
            }
        }
        if (qualities != null && qualities.length > 0) {
            for (short qa : qualities) {
                listQualites.add(Integer.valueOf(qa));
            }
        }
        if (objects != null && objects.length > 0) {
            for (byte[] bt : objects) {
                if (bt == null || bt.length <= 0) continue;
                listBytes.add(ByteString.copyFrom(bt));
            }
        }
        build.addAllIds(listIds);
        build.addAllDatetimes(listDatetime);
        build.addAllMs(listMs);
        build.addAllLens(listLens);
        build.addAllObjects(listBytes);
        build.addAllQualities(listQualites);
        DatagramSnapshots.datagram_put_named_type_snapshots datagram_put_named_type_snapshots2 = build.build();
        byte[] myByte = datagram_put_named_type_snapshots2.toByteArray();
        List<RtdbField> field = this.getMsgHeader2(RtdbMsgID.MSG_PUT_NAMED_TYPE_SNAPSHOTS, 0, 0, count, 1, myByte.length);
        this.msgAddBytes(field, myByte, "len", "buf_data");
        field.add(this.getMsgTail());
        return field;
    }

    @Override
    public List<RtdbField> msgPutNamedTypeSnapshotsRespFields(int[] errors) {
        DatagramSnapshots.datagram_put_named_type_snapshots_resp.Builder build = DatagramSnapshots.datagram_put_named_type_snapshots_resp.newBuilder();
        ArrayList<Integer> listErrors = new ArrayList<Integer>(errors.length > 0 ? errors.length : 10);
        if (errors != null && errors.length > 0) {
            for (int er : errors) {
                listErrors.add(er);
            }
        }
        build.addAllErrors(listErrors);
        DatagramSnapshots.datagram_put_named_type_snapshots_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_PUT_NAMED_TYPE_SNAPSHOTS, 0, 0, 1, 1, myByte.length);
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }
}

