/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.api.util;

import com.rtdb.api.util.BytesConvertUtil;
import java.io.UnsupportedEncodingException;

public class BytesConvert {
    public static byte[] intToBytes(long n) {
        return BytesConvertUtil.intToBytes(n);
    }

    public static byte[] longToBytes(long n) {
        return BytesConvertUtil.longToBytes(n);
    }

    public static void longToBytes(long n, byte[] array, int offset) {
        array[7 + offset] = (byte)(n & 0xFFL);
        array[6 + offset] = (byte)(n >> 8 & 0xFFL);
        array[5 + offset] = (byte)(n >> 16 & 0xFFL);
        array[4 + offset] = (byte)(n >> 24 & 0xFFL);
        array[3 + offset] = (byte)(n >> 32 & 0xFFL);
        array[2 + offset] = (byte)(n >> 40 & 0xFFL);
        array[1 + offset] = (byte)(n >> 48 & 0xFFL);
        array[offset] = (byte)(n >> 56 & 0xFFL);
    }

    public static long bytesToLong(byte[] array) {
        return ((long)array[0] & 0xFFL) << 56 | ((long)array[1] & 0xFFL) << 48 | ((long)array[2] & 0xFFL) << 40 | ((long)array[3] & 0xFFL) << 32 | ((long)array[4] & 0xFFL) << 24 | ((long)array[5] & 0xFFL) << 16 | ((long)array[6] & 0xFFL) << 8 | ((long)array[7] & 0xFFL) << 0;
    }

    public static long bytesToLong(byte[] array, int offset) {
        return ((long)array[offset + 7] & 0xFFL) << 56 | ((long)array[offset + 6] & 0xFFL) << 48 | ((long)array[offset + 5] & 0xFFL) << 40 | ((long)array[offset + 4] & 0xFFL) << 32 | ((long)array[offset + 3] & 0xFFL) << 24 | ((long)array[offset + 2] & 0xFFL) << 16 | ((long)array[offset + 1] & 0xFFL) << 8 | ((long)array[offset + 0] & 0xFFL) << 0;
    }

    public static byte[] uintToBytes(long n) {
        byte[] array = new byte[4];
        array[3] = (byte)(n & 0xFFL);
        array[2] = (byte)(n >> 8 & 0xFFL);
        array[1] = (byte)(n >> 16 & 0xFFL);
        array[0] = (byte)(n >> 24 & 0xFFL);
        return array;
    }

    public static void uintToBytes(long n, byte[] array, int offset) {
        array[3 + offset] = (byte)(n & 0xFFL);
        array[2 + offset] = (byte)(n >> 8 & 0xFFL);
        array[1 + offset] = (byte)(n >> 16 & 0xFFL);
        array[offset] = (byte)(n >> 24 & 0xFFL);
    }

    public static long bytesToUint(byte[] array) {
        return (long)((array[0] & 0xFF) << 24) | (long)((array[1] & 0xFF) << 16) | (long)((array[2] & 0xFF) << 8) | (long)(array[3] & 0xFF);
    }

    public static long bytesToUint(byte[] array, int offset) {
        return (long)((array[offset] & 0xFF) << 24) | (long)((array[offset + 1] & 0xFF) << 16) | (long)((array[offset + 2] & 0xFF) << 8) | (long)(array[offset + 3] & 0xFF);
    }

    public static byte[] intToBytes(int n) {
        byte[] array = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
        return array;
    }

    public static void intToBytes(int n, byte[] array, int offset) {
        array[3 + offset] = (byte)(n & 0xFF);
        array[2 + offset] = (byte)(n >> 8 & 0xFF);
        array[1 + offset] = (byte)(n >> 16 & 0xFF);
        array[offset] = (byte)(n >> 24 & 0xFF);
    }

    public static int bytesToInt(byte[] array) {
        byte[] a = new byte[4];
        int i = a.length - 1;
        int j = array.length - 1;
        while (i >= 0) {
            a[i] = j >= 0 ? array[j] : (byte)0;
            --i;
            --j;
        }
        int v0 = (a[0] & 0xFF) << 24;
        int v1 = (a[1] & 0xFF) << 16;
        int v2 = (a[2] & 0xFF) << 8;
        int v3 = a[3] & 0xFF;
        return v0 + v1 + v2 + v3;
    }

    public static int bytesToInt(byte[] array, int offset) {
        return (array[offset + 3] & 0xFF) << 24 | (array[offset + 2] & 0xFF) << 16 | (array[offset + 1] & 0xFF) << 8 | array[offset] & 0xFF;
    }

    public static short bytesToShort(byte[] array) {
        return (short)((array[1] & 0xFF) << 8 | array[0] & 0xFF);
    }

    public static short bytesToShort(byte[] array, int offset) {
        return (short)((array[offset + 1] & 0xFF) << 8 | array[offset] & 0xFF);
    }

    public static byte[] shortToBytes(short n) {
        byte[] array = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF)};
        return array;
    }

    public static byte[] fillBytes(int n) {
        byte[] array = new byte[n];
        return array;
    }

    public static void shortToBytes(short n, byte[] array, int offset) {
        array[offset + 1] = (byte)(n & 0xFF);
        array[offset] = (byte)(n >> 8 & 0xFF);
    }

    public static byte[] ushortToBytes(int n) {
        byte[] array = new byte[2];
        array[1] = (byte)(n & 0xFF);
        array[0] = (byte)(n >> 8 & 0xFF);
        return array;
    }

    public static void shortToBytes(int n, byte[] array, int offset) {
        array[offset + 1] = (byte)(n & 0xFF);
        array[offset] = (byte)(n >> 8 & 0xFF);
    }

    public static int bytesToUshort(byte[] array) {
        return (array[0] & 0xFF) << 8 | array[1] & 0xFF;
    }

    public static int bytesToUshort(byte[] array, int offset) {
        return (array[offset] & 0xFF) << 8 | array[offset + 1] & 0xFF;
    }

    public static byte[] charToBytes(char ch, int index) throws UnsupportedEncodingException {
        String str = new String(new char[]{ch});
        return str.getBytes("GBK");
    }

    public static byte[] charArrayToBytes(char[] chars, int index) throws UnsupportedEncodingException {
        String str = new String(chars);
        return str.getBytes("GBK");
    }

    public static char bytesToChar(byte[] array, int index) throws UnsupportedEncodingException {
        String str = new String(array, "GBK");
        return str.toCharArray()[0];
    }

    public static void bytesToBoolean(byte[] bytes, Boolean[] bools) throws UnsupportedEncodingException {
        for (int i = 0; i < bytes.length; ++i) {
            bools[i] = bytes[i] == 1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
    }

    public static byte[] booleanToBytes(boolean b) {
        byte[] array = new byte[]{b ? (byte)1 : 0};
        return array;
    }

    public static char[] bytesToCharArray(byte[] array, int index) throws UnsupportedEncodingException {
        String str = new String(array, "GBK");
        return str.toCharArray();
    }

    public static byte[] floatToBytes(float x, int index) {
        byte[] array = new byte[4];
        int l = Float.floatToIntBits(x);
        for (int i = 0; i < 4; ++i) {
            array[index + i] = new Integer(l).byteValue();
            l >>= 8;
        }
        return array;
    }

    public static float bytesToFloat(byte[] array, int index) {
        int l = array[index];
        l &= 0xFF;
        l |= array[index + 1] << 8;
        l &= 0xFFFF;
        l |= array[index + 2] << 16;
        l &= 0xFFFFFF;
        return Float.intBitsToFloat(l |= array[index + 3] << 24);
    }

    public static byte[] doubleToBytes(double x, int index) {
        byte[] array = new byte[8];
        long l = Double.doubleToLongBits(x);
        for (int i = 0; i < 8; ++i) {
            array[index + i] = new Long(l).byteValue();
            l >>= 8;
        }
        return array;
    }

    public static double bytesToDouble(byte[] array, int index) {
        long l = array[index];
        l &= 0xFFL;
        l |= (long)array[index + 1] << 8;
        l &= 0xFFFFL;
        l |= (long)array[index + 2] << 16;
        l &= 0xFFFFFFL;
        l |= (long)array[index + 3] << 24;
        l &= 0xFFFFFFFFL;
        l |= (long)array[index + 4] << 32;
        l &= 0xFFFFFFFFFFL;
        l |= (long)array[index + 5] << 40;
        l &= 0xFFFFFFFFFFFFL;
        l |= (long)array[index + 6] << 48;
        l &= 0xFFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(l |= (long)array[index + 7] << 56);
    }
}

