package com.beagle.base.bean.vo.resp;

import com.beagle.base.common.contant.CodeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
/**
 * @author wuwanli
 */
@Data
@ApiModel
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class Response<T> extends BaseResponse {
    /**
     * 封装的返回对象
     */
    @ApiModelProperty("返回对象")
    private T data;

    public Response(T data) {
        this.setCode(CodeEnum.SUCCESS.getCode());
        this.setDesc(CodeEnum.SUCCESS.getDesc());
        this.data = data;
    }

    public Response(CodeEnum codeEnum) {
        this.setCode(codeEnum.getCode());
        this.setDesc(codeEnum.getCode());
    }
}
