package com.beagle.base.controller;

import com.beagle.base.bean.vo.*;
import com.beagle.base.bean.vo.resp.Response;
import com.beagle.base.service.CacheService;
import com.beagle.base.service.HistorianService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.rtdb.model.DoubleData;
import com.rtdb.model.FullPoint;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

@Api(tags = "缓存接口")
@RestController
@RequestMapping("/v1/cache")
public class CacheController {
    @Resource
    private CacheService cacheService;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "从缓存中通过tag获取id")
    @PostMapping("/base/byTag")
    public Response<Integer> getBaseIdByTag(@RequestBody @ApiParam(value = "入参") @Validated BaseCacheByTagParam param) {
        return new Response<>(cacheService.getBaseIdByTag(param));
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "从缓存中通过id获取point")
    @PostMapping("/base/byId")
    public Response<BasePointVO> getBasePointById(@RequestBody @ApiParam(value = "入参") @Validated BaseCacheByIdParam param) {
        return new Response<>(cacheService.getBasePointById(param));
    }
}
