package com.beagle.base.controller;

import com.beagle.base.bean.vo.*;
import com.beagle.base.bean.vo.resp.Response;
import com.beagle.base.service.SnapshotService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.rtdb.model.BlobData;
import com.rtdb.model.CoorData;
import com.rtdb.model.DoubleData;
import com.rtdb.model.IntData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 数据库字段加密、防篡改接口
 *
 * @author lzz
 */
@Api(tags = "快照服务接口方法实现")
@RestController
@RequestMapping("/v1/snapshot")
public class SnapshotController {
    @Resource
    private SnapshotService snapshotService;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "批量获取标签点类型为双精度浮点型的快照值(纳秒标签点)")
    @PostMapping("/getDoubleSnapshots")
    public Response<List<DoubleData>> getDoubleSnapshots(@RequestBody @ApiParam(value = "入参") @Validated SnapshotDoubleParam param) {
        return new Response<>(snapshotService.getDoubleSnapshots(param));
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "批量读取开关量、模拟量快照数值")
    @PostMapping("/getIntSnapshots")
    public Response<List<IntData>> getIntSnapshots(@RequestBody @ApiParam(value = "入参") @Validated SnapshotIntParam param) {
        return new Response<>(snapshotService.getIntSnapshots(param));
    }

    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "批量获取标签点类型为Blob/String型的快照值")
    @PostMapping("/getBlobSnapshots")
    public Response<List<BlobData>> getBlobSnapshots(@RequestBody @ApiParam(value = "入参") @Validated SnapshotBlobParam param) {
        return new Response<>(snapshotService.getBlobSnapshots(param));
    }

    @ApiOperationSupport(order = 4)
    @ApiOperation(value = "批量获取标签点类型为坐标类型的快照值")
    @PostMapping("/getCoorSnapshots")
    public Response<List<CoorData>> getCoorSnapshots(@RequestBody @ApiParam(value = "入参") @Validated SnapshotCoorParam param) {
        return new Response<>(snapshotService.getCoorSnapshots(param));
    }

}
