/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.api.impl;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.rtdb.api.callbackInter.NamedTypeCallbackProc;
import com.rtdb.api.callbackInter.RBNamedTypeCreate;
import com.rtdb.api.callbackInter.RBTagsChange;
import com.rtdb.api.callbackInter.RBTagsChangeEx;
import com.rtdb.api.callbackInter.RSDataChange;
import com.rtdb.api.callbackInter.RSDataChangeEx;
import com.rtdb.api.callbackInter.SnapsCallbackProc;
import com.rtdb.api.callbackInter.SnapsCallbackProcEx;
import com.rtdb.api.callbackInter.TagsCallbackProc;
import com.rtdb.api.callbackInter.TagsCallbackProcEx;
import com.rtdb.api.common.RtdbErrorParse;
import com.rtdb.api.enums.IsReConnection;
import com.rtdb.api.enums.RTDBTimeCopy;
import com.rtdb.api.enums.RTDBTrigger;
import com.rtdb.api.enums.RtdbDbParamIndex;
import com.rtdb.api.enums.RtdbError;
import com.rtdb.api.enums.RtdbGlobalEnum;
import com.rtdb.api.enums.RtdbMsgID;
import com.rtdb.api.enums.RtdbPrivGroup;
import com.rtdb.api.enums.RtdbTagChangeReason;
import com.rtdb.api.enums.RtdbType;
import com.rtdb.api.exception.CrcErrorException;
import com.rtdb.api.exception.DecodePacketErrorException;
import com.rtdb.api.exception.EncodePacketErrorException;
import com.rtdb.api.exception.InvalidHeaderException;
import com.rtdb.api.exception.InvalidMarkException;
import com.rtdb.api.exception.InvalidParameterException;
import com.rtdb.api.exception.InvalidTimeFormatException;
import com.rtdb.api.exception.NoAuthorityException;
import com.rtdb.api.exception.RtdbExecuteErrorException;
import com.rtdb.api.exception.UnexpectedMethodException;
import com.rtdb.api.impl.Rtdb;
import com.rtdb.api.inter.IServer;
import com.rtdb.api.inter.msg.ServerMessage;
import com.rtdb.api.model.CallbackProcArgs;
import com.rtdb.api.model.FieldSize;
import com.rtdb.api.model.Login;
import com.rtdb.api.model.MemoryStream;
import com.rtdb.api.model.NamedDataTypeField;
import com.rtdb.api.model.RtdbBasePoint;
import com.rtdb.api.model.RtdbCalcPoint;
import com.rtdb.api.model.RtdbData;
import com.rtdb.api.model.RtdbField;
import com.rtdb.api.model.RtdbHostConnectInfo;
import com.rtdb.api.model.RtdbScanPoint;
import com.rtdb.api.model.Rtdb_Path;
import com.rtdb.api.model.SocketAddr;
import com.rtdb.api.msg.ServerProtocol21;
import com.rtdb.api.msg.ServerProtocol30;
import com.rtdb.api.protocol.DatagramBase;
import com.rtdb.api.protocol.DatagramServer;
import com.rtdb.api.protocol.DatagramSnapshots;
import com.rtdb.api.util.BytesConvertUtil;
import com.rtdb.api.util.CodeUtils;
import com.rtdb.api.util.ConfigUtil;
import com.rtdb.api.util.Crc32Util;
import com.rtdb.api.util.DateUtil;
import com.rtdb.api.util.IPUtil;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RtdbServerImpl
extends Rtdb
implements IServer {
    private CallbackProcArgs callbackArgs;
    private BufferedInputStream dis;
    private DataOutputStream dos;
    private boolean isLogined = false;
    private Login login;
    private RtdbMsgID method;
    private Socket socket;
    private SocketAddr socketAddr;
    private Thread thread;
    private static ServerMessage protol;
    private static final String version = "3";
    int connValue = 0;
    AtomicInteger lock = new AtomicInteger(0);
    IsReConnection isReconn;
    private static Log log;
    private int connectDelayTime = 50;
    private long reConnectTimeOut;

    public RtdbServerImpl(SocketAddr socketAddr, Login login) {
        this.socketAddr = socketAddr;
        this.login = login;
        this.reConnectTimeOut = ConfigUtil.getLong("rtdb.connect.retry.timeout", 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAuthorization(String addr, String mask, RtdbPrivGroup priv, String desc) throws Exception {
        if (addr == null || mask == null || priv == null || desc == null || desc.length() > 511) {
            throw new InvalidParameterException();
        }
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_ADD_AUTHORIZATION, this.getLogin())) {
                throw new NoAuthorityException();
            }
            byte[] addrByte16 = IPUtil.ipOrMaskToByte16(addr);
            byte[] maskByte16 = IPUtil.ipOrMaskToByte16(mask);
            List<RtdbField> fields = protol.msgAddAuthFields(ByteString.copyFrom(addrByte16), ByteString.copyFrom(maskByte16), priv, desc);
            this.sendPacket(fields, false);
            List<RtdbField> rFields = protol.msgAddAuthRespFields(0);
            this.receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBlacklist(String addr, String mask, String desc) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (addr == null || mask == null || desc == null) {
            throw new InvalidParameterException();
        }
        desc = this.subString(desc, 512);
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_ADD_BLACKLIST, this.getLogin())) {
                throw new NoAuthorityException();
            }
            byte[] addrBytes16 = IPUtil.ipOrMaskToByte16(addr);
            byte[] maskBytes16 = IPUtil.ipOrMaskToByte16(mask);
            List<RtdbField> fields = protol.msgAddBlacklistFields(ByteString.copyFrom(addrBytes16), ByteString.copyFrom(maskBytes16), desc);
            this.sendPacket(fields, false);
            List<RtdbField> rFields = protol.msgAddBlacklistRespFields(0);
            this.receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addUser(String user, String pwd, RtdbPrivGroup priv) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (user == null || pwd == null) {
            throw new InvalidParameterException();
        }
        user = this.subString(user, 19);
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_ADD_USER, this.getLogin())) {
                throw new NoAuthorityException();
            }
            int crcPwd = Crc32Util.getCRC32(pwd);
            List<RtdbField> fields = protol.msgAddUserFields(user, crcPwd, priv);
            this.sendPacket(fields, false);
            List<RtdbField> rFields = protol.msgAddUserRespFields(0);
            this.receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
        }
    }

    @Override
    public void cancelSubscribe() {
        if (this.thread != null && !this.thread.isInterrupted()) {
            this.thread.interrupt();
        }
        if (null != this.callbackArgs) {
            this.callbackArgs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeMyPassword(String oldPwd, String newPwd) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (oldPwd == null || newPwd == null) {
            throw new InvalidParameterException();
        }
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_CHANGE_MY_PASSWORD, this.getLogin())) {
                throw new NoAuthorityException();
            }
            int oPwd = Crc32Util.getCRC32(oldPwd);
            int nPwd = Crc32Util.getCRC32(newPwd);
            List<RtdbField> fields = protol.msgChangeMyPwdFields(oPwd, nPwd);
            this.sendPacket(fields, false);
            List<RtdbField> rFields = protol.msgChangeMyPwdRespFields(0);
            this.receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changePassword(String user, String password) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (user == null || password == null) {
            throw new InvalidParameterException();
        }
        if (user.getBytes("ASCII").length > 19) {
            user = new String(user.getBytes("ASCII"), 0, 19);
        }
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_CHANGE_PASSWORD, this.getLogin())) {
                throw new NoAuthorityException();
            }
            int pwd = Crc32Util.getCRC32(password);
            List<RtdbField> fields = protol.msgChangePwdFields(user, pwd);
            this.sendPacket(fields, false);
            List<RtdbField> rFields = protol.msgChangePwdRespFields(0);
            this.receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changePriv(String user, RtdbPrivGroup priv) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (user == null) {
            throw new InvalidParameterException();
        }
        user = this.subString(user, 19);
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_CHANGE_PRIV, this.getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = protol.msgChangePrivFields(user, priv);
            this.sendPacket(fields, false);
            List<RtdbField> rFields = protol.msgChangePrivRespFields(0);
            this.receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
        }
    }

    @Override
    public void close() {
        block6: {
            try {
                if (null != this.socket) {
                    this.socket.close();
                }
                if (null != this.dis) {
                    this.dis.close();
                }
                if (null != this.dos) {
                    this.dos.close();
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block6;
                log.error("\u934f\u62bd\u68f4\u93c1\u7248\u5d41\u6434\u64b3\u5f42\u9422\u71bc\u654a\u7487\ufffd...", e);
            }
        }
        this.socket = null;
        this.dis = null;
        this.dos = null;
        this.isLogined = false;
        if (this.thread != null && !this.thread.isInterrupted()) {
            this.cancelSubscribe();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closePath() throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_CLOSE_PATH, this.getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = protol.msgClosePathFields();
            this.sendPacket(fields, false);
            List<RtdbField> rFields = protol.msgClosePathRespFields(0);
            this.receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
        }
    }

    @Override
    public void connect() throws IOException, InvalidParameterException, InvalidMarkException, ParseException, EncodePacketErrorException, DecodePacketErrorException, UnexpectedMethodException, InvalidHeaderException, InterruptedException, CrcErrorException, RtdbExecuteErrorException {
        if (this.socket != null && this.dos != null && this.dis != null) {
            return;
        }
        String ip = this.socketAddr.getHostName();
        int port = this.socketAddr.getPort();
        if (ip.isEmpty() || port == 0) {
            throw new InvalidParameterException();
        }
        if (null == this.socket) {
            this.socket = new Socket();
            this.socket.setKeepAlive(true);
        }
        InetSocketAddress serverAddress = new InetSocketAddress(ip, port);
        this.socket.setSoTimeout(this.connValue);
        if (!this.socket.isConnected() || this.socket.isClosed()) {
            this.socket.connect(serverAddress);
        }
        if (log.isDebugEnabled()) {
            log.debug("\u5bb8\u8336\u7e5b\u93ba\ufffd!");
        }
        this.socket.setKeepAlive(true);
        int bufferSize = 655360;
        this.socket.setReceiveBufferSize(bufferSize);
        this.socket.setSendBufferSize(bufferSize);
        this.socket.setTcpNoDelay(true);
        this.socket.setSoLinger(true, 2);
        this.dos = new DataOutputStream(this.socket.getOutputStream());
        this.dis = new BufferedInputStream(this.socket.getInputStream());
        this.sendConnectPacket();
    }

    @Override
    public void reConnect() throws InterruptedException, DecodePacketErrorException, InvalidMarkException, IOException, InvalidParameterException, EncodePacketErrorException, ParseException, UnexpectedMethodException, InvalidHeaderException, CrcErrorException, RtdbExecuteErrorException {
        this.close();
        this.connect();
        this.login();
    }

    @Override
    public void setOption(IsReConnection conn, int value) {
        switch (conn) {
            case RECONNECTION: {
                this.isReconn = IsReConnection.RECONNECTION;
                this.connValue = value;
            }
            case NOCONNECTION: {
                this.isReconn = IsReConnection.NOCONNECTION;
                this.connValue = value;
                break;
            }
        }
    }

    @Override
    public void setReconnection(boolean _isReconnection) {
        this.isReconn = _isReconnection ? IsReConnection.RECONNECTION : IsReConnection.NOCONNECTION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbPrivGroup getPriv() throws NoAuthorityException, Exception {
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_GET_PRIV, this.getLogin())) {
                throw new NoAuthorityException();
            }
            return RtdbPrivGroup.parse(this.login.getPriv());
        }
    }

    @Override
    public void copyFields(List<RtdbField> dstFields, List<RtdbField> srcFields, boolean onlyHeader) {
        RtdbField field = null;
        for (int i = 0; i < srcFields.size(); ++i) {
            field = srcFields.get(i);
            dstFields.set(i, field);
            if (onlyHeader && i == RtdbGlobalEnum.FIELD_HCRC.getNum()) break;
        }
    }

    private void decodeBaseType(MemoryStream stream, RtdbField field) throws UnsupportedEncodingException, DecodePacketErrorException {
        switch (field.getType()) {
            case 1: {
                field.setIvalue(stream.readByte());
                break;
            }
            case 0: {
                field.setIvalue(stream.readChar());
                break;
            }
            case 2: {
                field.setIvalue(stream.readShort());
                break;
            }
            case 3: {
                field.setIvalue(stream.readInt());
                break;
            }
            case 4: {
                field.setIvalue(stream.readLong());
                break;
            }
            case 5: {
                field.setFvalue(stream.readFloat());
                break;
            }
            case 6: {
                field.setFvalue(stream.readDouble());
                break;
            }
            default: {
                throw new DecodePacketErrorException();
            }
        }
    }

    private RtdbError decodeBaseTypeArray(MemoryStream input, RtdbField field, int count) throws UnsupportedEncodingException {
        switch (field.getType()) {
            case 0: {
                field.setData(input.readString(count));
                break;
            }
            case 1: {
                input.readBytes(field.getData(), count);
                break;
            }
            case 2: {
                input.readShortArray(field.getData(), count);
                break;
            }
            case 3: {
                input.readIntArray(field.getData(), count);
                break;
            }
            case 4: {
                input.readLongArray(field.getData(), count);
                break;
            }
            case 5: {
                input.readFloatArray(field.getData(), count);
                break;
            }
            case 6: {
                input.readDoubleArray(field.getData(), count);
                break;
            }
            default: {
                return RtdbError.GoE_DECODE_PACKET_ERROR;
            }
        }
        return RtdbError.GoE_OK;
    }

    private void decodeBaseTypeArrays(MemoryStream input, RtdbField field, int[] counts) throws UnsupportedEncodingException, DecodePacketErrorException {
        switch (field.getType()) {
            case 0: {
                String[] tempStrs = (String[])field.getData();
                for (int i = 0; i < counts.length; ++i) {
                    tempStrs[i] = input.readString(counts[i]);
                }
                break;
            }
            case 1: {
                byte[][] tempBuffer = (byte[][])field.getData();
                for (int i = 0; i < counts.length; ++i) {
                    tempBuffer[i] = input.readBytes(counts[i]);
                }
                break;
            }
            case 2: {
                short[][] buffer = (short[][])field.getData();
                for (int i = 0; i < counts.length; ++i) {
                    buffer[i] = input.readShortArray(counts[i]);
                }
                break;
            }
            case 3: {
                int[][] intBuffer = (int[][])field.getData();
                for (int i = 0; i < counts.length; ++i) {
                    intBuffer[i] = input.readIntArray(counts[i]);
                }
                break;
            }
            case 4: {
                long[][] longBuffer = (long[][])field.getData();
                for (int i = 0; i < counts.length; ++i) {
                    longBuffer[i] = input.readLongArray(counts[i]);
                }
                break;
            }
            case 5: {
                float[][] floatBuffer = (float[][])field.getData();
                for (int i = 0; i < counts.length; ++i) {
                    floatBuffer[i] = input.readFloatArray(counts[i]);
                }
                break;
            }
            case 6: {
                double[][] doubleBuffer = (double[][])field.getData();
                for (int i = 0; i < counts.length; ++i) {
                    doubleBuffer[i] = input.readDoubleArray(counts[i]);
                }
                break;
            }
            default: {
                throw new DecodePacketErrorException();
            }
        }
    }

    private synchronized void decodePacketBody(byte[] buffer, int length, List<RtdbField> fields, boolean compareCrc) throws IOException, InvalidMarkException, DecodePacketErrorException, ParseException {
        long crc = 0L;
        int baseAddr = 0;
        int bufferIndex = 0;
        MemoryStream stream = new MemoryStream(buffer);
        int dimension = 0;
        long fieldDim = fields.get(RtdbGlobalEnum.FIELD_DIM.getNum()).getIvalue();
        if (fieldDim >= 0L) {
            dimension = (int)fieldDim;
        }
        RtdbField p = null;
        for (int n = RtdbGlobalEnum.FIELD_BMARK.getNum(); n < fields.size(); ++n) {
            p = fields.get(n);
            if (n == fields.size() - 1) {
                bufferIndex = stream.getBufferIndex();
                crc = Crc32Util.getCRC32(buffer, baseAddr, bufferIndex, 0);
            }
            if (p.getData() == null) {
                this.decodeBaseType(stream, p);
            } else {
                int count = 0;
                if (p.getCount() > 0) {
                    RtdbError ret;
                    count = dimension * p.getCount();
                    if (p.getData() != null && count > 0 && (ret = this.decodeBaseTypeArray(stream, p, count)) != RtdbError.GoE_OK && !p.getData().equals(-1431655766)) {
                        this.decodeSegment(stream, p.getType(), p.getData(), count, p.getIvalue() == -4L);
                    }
                } else {
                    RtdbField prev = fields.get(n - 1);
                    if (prev.getType() != 2 && prev.getType() != 3) {
                        throw new DecodePacketErrorException();
                    }
                    switch (p.getCount()) {
                        case -1: {
                            if (prev.getData() != null) {
                                throw new DecodePacketErrorException();
                            }
                            count = (int)prev.getIvalue();
                            if (p.getData().equals(-1431655766) || count <= 0) break;
                            this.decodeBaseTypeArray(stream, p, count);
                            break;
                        }
                        case -2: {
                            if (prev.getData() == null || prev.getData().equals(-1431655766)) {
                                throw new DecodePacketErrorException();
                            }
                            int sum = 0;
                            int len = 0;
                            for (int i = 0; i < prev.getCount() * dimension; ++i) {
                                len = prev.getType() == 2 ? ((short[])prev.getData())[i] : ((int[])prev.getData())[i];
                                sum += len;
                            }
                            count = dimension * sum;
                            if (p.getData().equals(-1431655766)) break;
                            this.decodeBaseTypeArray(stream, p, count);
                            break;
                        }
                        case -3: {
                            if (prev.getData() == null || prev.getData().equals(-1431655766)) {
                                throw new DecodePacketErrorException();
                            }
                            int sum = 0;
                            int len = 0;
                            int[] ivec = new int[prev.getCount() * dimension];
                            for (int i = 0; i < prev.getCount() * dimension; ++i) {
                                len = prev.getType() == 2 ? ((short[])prev.getData())[i] : ((int[])prev.getData())[i];
                                ivec[i] = len;
                                sum += len;
                            }
                            count = dimension * sum;
                            if (p.getData().equals(-1431655766)) break;
                            this.decodeBaseTypeArrays(stream, p, ivec);
                            break;
                        }
                        default: {
                            throw new DecodePacketErrorException();
                        }
                    }
                }
                if (p.getData().equals(-1431655766)) {
                    int size = 0;
                    switch (p.getType()) {
                        case 0: 
                        case 1: {
                            size = 1;
                            break;
                        }
                        case 2: {
                            size = 2;
                            break;
                        }
                        case 3: 
                        case 5: {
                            size = 4;
                            break;
                        }
                        case 4: 
                        case 6: {
                            size = 8;
                            break;
                        }
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: {
                            this.skipSegment(stream, count);
                            size = 0;
                            break;
                        }
                        default: {
                            throw new DecodePacketErrorException();
                        }
                    }
                    if (count * size > 0) {
                        stream.skip(count * size);
                    }
                }
            }
            if (n == RtdbGlobalEnum.FIELD_BMARK.getNum()) {
                if (p.getIvalue() == -858993460L || p.getIvalue() == 0x33333333L) continue;
                throw new InvalidMarkException();
            }
            if (n != fields.size() - 1) continue;
            if (!compareCrc || crc == p.getIvalue()) break;
            log.error("CrcErrorException: \u93b6\u30e6\u6783CRC\u93cd\uffe0\u7359\u95bf\u6b12\ue1e4");
            break;
        }
    }

    private void decodePacketHeader(byte[] buffers, int length, List<RtdbField> commonFields, boolean compareCrc) throws IOException, InvalidHeaderException, DecodePacketErrorException, CrcErrorException {
        byte[] buffer = new byte[buffers.length];
        for (int i = 0; i < buffers.length; ++i) {
            buffer[i] = buffers[i];
        }
        long crc = 0L;
        int baseAddr = 0;
        int bufferIndex = 0;
        MemoryStream stream = new MemoryStream(buffer);
        for (int n = 0; n < commonFields.size(); ++n) {
            RtdbField p = commonFields.get(n);
            if (n == RtdbGlobalEnum.FIELD_HCRC.getNum()) {
                bufferIndex = stream.getBufferIndex();
                crc = Crc32Util.getCRC32(buffer, baseAddr, bufferIndex, 0);
            }
            if (p.getData() == null) {
                this.decodeBaseType(stream, p);
            }
            if (n == RtdbGlobalEnum.FIELD_HMARK.getNum()) {
                if (p.getIvalue() == -1431655766L || p.getIvalue() == 0x55555555L) continue;
                throw new InvalidHeaderException();
            }
            if (n != RtdbGlobalEnum.FIELD_HCRC.getNum()) continue;
            if (!compareCrc || crc == p.getIvalue()) break;
            throw new CrcErrorException();
        }
    }

    private void decodeSegment(MemoryStream input, int type, Object data, int count, boolean ptrArray) throws UnsupportedEncodingException, DecodePacketErrorException, ParseException {
        switch (type) {
            case 7: {
                for (int i = 0; i < count; ++i) {
                    RtdbBasePoint base = null;
                    if (!data.equals(-1431655766)) {
                        base = ptrArray ? ((RtdbBasePoint[])data)[i] : (RtdbBasePoint)data;
                    }
                    List<RtdbField> baseFields = this.baseISegmentFields(base);
                    this.decodeSegment(input, baseFields);
                    this.fieldsToBaseSegmentI(baseFields, base);
                }
                break;
            }
            case 8: {
                for (int i = 0; i < count; ++i) {
                    RtdbBasePoint base = null;
                    if (!data.equals(-1431655766)) {
                        base = ptrArray ? ((RtdbBasePoint[])data)[i] : (RtdbBasePoint)data;
                    }
                    List<RtdbField> baseFields = this.baseUSegmentFields(base);
                    this.decodeSegment(input, baseFields);
                    this.fieldsToBaseSegmentU(baseFields, base);
                }
                break;
            }
            case 9: {
                for (int i = 0; i < count; ++i) {
                    RtdbBasePoint base = null;
                    if (!data.equals(-1431655766)) {
                        base = ptrArray ? ((RtdbBasePoint[])data)[i] : (RtdbBasePoint)data;
                    }
                    List<RtdbField> baseFields = this.baseGSegmentFields(base);
                    this.decodeSegment(input, baseFields);
                    this.fieldsToBaseSegmentG(baseFields, base);
                }
                break;
            }
            case 10: {
                for (int i = 0; i < count; ++i) {
                    RtdbScanPoint scan = null;
                    if (!data.equals(-1431655766)) {
                        scan = ptrArray ? ((RtdbScanPoint[])data)[i] : (RtdbScanPoint)data;
                    }
                    List<RtdbField> scanFields = protol.scanSegmentFields(scan);
                    this.decodeSegment(input, scanFields);
                    this.fieldsToScanPoint(scanFields, scan);
                }
                break;
            }
            case 11: {
                for (int i = 0; i < count; ++i) {
                    RtdbCalcPoint calc = null;
                    if (!data.equals(-1431655766)) {
                        calc = ptrArray ? ((RtdbCalcPoint[])data)[i] : (RtdbCalcPoint)data;
                    }
                    List<RtdbField> calcFields = protol.calcSegmentFields(calc);
                    this.decodeSegment(input, calcFields);
                    this.fieldsToCalcPoint(calcFields, calc);
                }
                break;
            }
            default: {
                throw new DecodePacketErrorException();
            }
        }
    }

    private void decodeSegment(MemoryStream input, List<RtdbField> segment) throws UnsupportedEncodingException, DecodePacketErrorException {
        RtdbField field;
        if (input.readShort() == 0) {
            return;
        }
        block3: for (int i = 0; i < segment.size() && (field = segment.get(i)).getType() >= 0; ++i) {
            if (field.getData() == null) {
                this.decodeBaseType(input, field);
                continue;
            }
            if (field.getData().equals(-1431655766)) {
                throw new DecodePacketErrorException();
            }
            if (field.getCount() >= 0) {
                int count = field.getCount();
                if (count <= 0) continue;
                this.decodeBaseTypeArray(input, field, count);
                continue;
            }
            RtdbField prevField = segment.get(i - 1);
            if (prevField.getType() != 2 && prevField.getType() != 3) {
                throw new DecodePacketErrorException();
            }
            int count = 0;
            switch (field.getCount()) {
                case -1: {
                    if (prevField.getData() != null) {
                        throw new DecodePacketErrorException();
                    }
                    count = (int)prevField.getIvalue();
                    if (count <= 0) continue block3;
                    this.decodeBaseTypeArray(input, field, count);
                    continue block3;
                }
                default: {
                    throw new DecodePacketErrorException();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() throws NoAuthorityException, IOException, Exception {
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_DISCONNECT, this.getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = this.msgCommonFields(RtdbMsgID.MSG_DISCONNECT, 0);
            FieldSize fieldSize = this.getFieldsSize(fields);
            fields.get(RtdbGlobalEnum.FIELD_BSIZE.getNum()).setIvalue(fieldSize.getBodySize());
            MemoryStream curStream = this.encodePacketToStream(fields);
            this.encodePacketSendStream(curStream);
            this.cancelSubscribe();
            this.close();
        }
    }

    private void encodeBaseType(MemoryStream output, RtdbField field) throws UnsupportedEncodingException, EncodePacketErrorException {
        switch (field.getType()) {
            case 1: {
                output.writeByte((byte)field.getIvalue());
                break;
            }
            case 0: {
                output.writeChar((char)field.getIvalue());
                break;
            }
            case 2: {
                output.writeShort((short)field.getIvalue());
                break;
            }
            case 3: {
                output.writeInt((int)field.getIvalue());
                break;
            }
            case 4: {
                output.writeLong(field.getIvalue());
                break;
            }
            case 5: {
                output.writeFloat((float)field.getFvalue());
                break;
            }
            case 6: {
                output.writeDouble(field.getFvalue());
                break;
            }
            default: {
                throw new EncodePacketErrorException();
            }
        }
    }

    private RtdbError encodeBaseTypeArray(MemoryStream output, RtdbField field) throws IOException {
        switch (field.getType()) {
            case 1: {
                byte[] bytes = (byte[])field.getData();
                output.writeBytes(bytes);
                break;
            }
            case 0: {
                output.writeString((String)field.getData());
                break;
            }
            case 2: {
                output.writeShortArray((short[])field.getData());
                break;
            }
            case 3: {
                output.writeIntArray((int[])field.getData());
                break;
            }
            case 4: {
                output.writeLongArray((long[])field.getData());
                break;
            }
            case 5: {
                output.writeFloatArray((float[])field.getData());
                break;
            }
            case 6: {
                output.writeDoubleArray((double[])field.getData());
                break;
            }
            default: {
                return RtdbError.GoE_ENCODE_PACKET_ERROR;
            }
        }
        return RtdbError.GoE_OK;
    }

    private RtdbError encodeBaseTypeArray(MemoryStream output, RtdbField field, int count) throws IOException {
        switch (field.getType()) {
            case 1: {
                byte[] bytes = (byte[])field.getData();
                output.writeBytes(bytes);
                break;
            }
            case 0: {
                output.writeString((String)field.getData(), count);
                break;
            }
            case 2: {
                output.writeShortArray((short[])field.getData());
                break;
            }
            case 3: {
                output.writeIntArray((int[])field.getData());
                break;
            }
            case 4: {
                output.writeLongArray((long[])field.getData());
                break;
            }
            case 5: {
                output.writeFloatArray((float[])field.getData());
                break;
            }
            case 6: {
                output.writeDoubleArray((double[])field.getData());
                break;
            }
            default: {
                return RtdbError.GoE_ENCODE_PACKET_ERROR;
            }
        }
        return RtdbError.GoE_OK;
    }

    private void encodeBaseTypeArrays(MemoryStream output, RtdbField field) throws IOException, EncodePacketErrorException {
        switch (field.getType()) {
            case 1: {
                byte[][] byteBuffer;
                for (byte[] array : byteBuffer = (byte[][])field.getData()) {
                    output.writeBytes(array);
                }
                break;
            }
            case 0: {
                String[] strBuffer;
                for (String array : strBuffer = (String[])field.getData()) {
                    output.writeString(array);
                }
                break;
            }
            case 2: {
                short[][] shortBuffer;
                for (short[] array : shortBuffer = (short[][])field.getData()) {
                    output.writeShortArray(array);
                }
                break;
            }
            case 3: {
                int[][] intBuffer;
                for (int[] array : intBuffer = (int[][])field.getData()) {
                    output.writeIntArray(array);
                }
                break;
            }
            case 4: {
                long[][] longBuffer;
                for (long[] array : longBuffer = (long[][])field.getData()) {
                    output.writeLongArray(array);
                }
                break;
            }
            case 5: {
                float[][] floatBuffer;
                for (float[] array : floatBuffer = (float[][])field.getData()) {
                    output.writeFloatArray(array);
                }
                break;
            }
            case 6: {
                double[][] doubleBuffer;
                for (double[] array : doubleBuffer = (double[][])field.getData()) {
                    output.writeDoubleArray(array);
                }
                break;
            }
            default: {
                throw new EncodePacketErrorException();
            }
        }
    }

    private synchronized MemoryStream encodePacketToStream(List<RtdbField> fields) throws EncodePacketErrorException, IOException, ParseException {
        int baseAddr = 0;
        int n = 0;
        MemoryStream stream = new MemoryStream();
        int dimension = 0;
        long ivalue = fields.get(RtdbGlobalEnum.FIELD_DIM.getNum()).getIvalue();
        if (ivalue >= 0L) {
            dimension = (int)ivalue;
        }
        for (n = 0; n < fields.size(); ++n) {
            block20: {
                int count;
                RtdbField field;
                block21: {
                    block19: {
                        field = fields.get(n);
                        if (n == RtdbGlobalEnum.FIELD_HCRC.getNum()) {
                            byte[] buffer = stream.toByteArray();
                            int length = buffer.length;
                            if (length > 0) {
                                field.setIvalue(Crc32Util.getCRC32(buffer, 0, length, 0));
                            }
                        } else if (n == fields.size() - 1) {
                            byte[] buffer = stream.toByteArray();
                            int length = buffer.length;
                            field.setIvalue(Crc32Util.getCRC32(buffer, baseAddr, length, 0));
                        }
                        if (field.getData() != null) break block19;
                        this.encodeBaseType(stream, field);
                        break block20;
                    }
                    count = 0;
                    if (field.getCount() >= 0) {
                        count = version.equals(version) ? field.getCount() : dimension * field.getCount();
                    }
                    if (count <= 0) break block21;
                    RtdbError ret = this.encodeBaseTypeArray(stream, field, count);
                    if (ret.equals(RtdbError.GoE_OK)) break block20;
                    switch (field.getType()) {
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: {
                            this.encodeSegment(stream, field.getType(), field.getData(), count, field.getIvalue() == -4L);
                            break block20;
                        }
                        default: {
                            throw new EncodePacketErrorException();
                        }
                    }
                }
                RtdbField prevField = fields.get(n - 1);
                if (prevField.getType() != 2 && prevField.getType() != 3) {
                    throw new EncodePacketErrorException();
                }
                switch (field.getCount()) {
                    case -1: {
                        if (prevField.getData() != null) {
                            throw new EncodePacketErrorException();
                        }
                        count = (int)prevField.getIvalue();
                        if (count <= 0) break;
                        this.encodeBaseTypeArray(stream, field, count);
                        break;
                    }
                    case -2: {
                        if (prevField.getData() == null) {
                            throw new EncodePacketErrorException();
                        }
                        this.encodeBaseTypeArray(stream, field);
                        break;
                    }
                    case -3: {
                        if (prevField.getData() == null) {
                            throw new EncodePacketErrorException();
                        }
                        this.encodeBaseTypeArrays(stream, field);
                        break;
                    }
                    default: {
                        throw new EncodePacketErrorException();
                    }
                }
            }
            if (n != RtdbGlobalEnum.FIELD_HCRC.getNum()) continue;
            baseAddr = stream.size();
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void encodePacketSendStream(MemoryStream stream) throws IOException, UnexpectedMethodException, EncodePacketErrorException, InvalidMarkException, InterruptedException, InvalidHeaderException, DecodePacketErrorException, CrcErrorException, InvalidParameterException, ParseException, RtdbExecuteErrorException {
        try {
            Boolean isWriteSuccess = false;
            long startTime = System.currentTimeMillis();
            do {
                if ((isWriteSuccess = stream.writeTo(this.dos)).booleanValue()) continue;
                if (log.isDebugEnabled()) {
                    log.debug("\u6769\u70b4\u5e34\u5bb8\u832c\u7ca1\u93c2\ue15e\u7d11\u951b\u5c7e\ue11c\u9366\u3124\u8d1f\u93ae\u3125\u57b1\u5be4\u9e3f\u7e5b\u93ba\ufffd......");
                }
                this.reConnect();
                if (!log.isDebugEnabled()) continue;
                log.debug("\u6769\u70b4\u5e34\u93b4\u612c\u59db......");
            } while (!isWriteSuccess.booleanValue() && System.currentTimeMillis() - startTime < this.reConnectTimeOut);
        }
        finally {
            stream.close();
        }
    }

    private void encodeSegment(MemoryStream output, int type, Object data, int count, boolean ptrArray) throws IOException, EncodePacketErrorException, ParseException {
        switch (type) {
            case 7: {
                for (int i = 0; i < count; ++i) {
                    RtdbBasePoint base = null;
                    base = ptrArray ? ((RtdbBasePoint[])data)[i] : (RtdbBasePoint)data;
                    if (base != null) {
                        List<RtdbField> baseFields = this.baseISegmentFields(base);
                        this.encodeSegment(output, baseFields);
                        continue;
                    }
                    output.writeShort((short)0);
                }
                break;
            }
            case 8: {
                for (int i = 0; i < count; ++i) {
                    RtdbBasePoint base = null;
                    base = ptrArray ? ((RtdbBasePoint[])data)[i] : (RtdbBasePoint)data;
                    if (base != null) {
                        List<RtdbField> baseFields = this.baseUSegmentFields(base);
                        this.encodeSegment(output, baseFields);
                        continue;
                    }
                    output.writeShort((short)0);
                }
                break;
            }
            case 9: {
                for (int i = 0; i < count; ++i) {
                    RtdbBasePoint base = null;
                    base = ptrArray ? ((RtdbBasePoint[])data)[i] : (RtdbBasePoint)data;
                    if (base != null) {
                        List<RtdbField> baseFields = this.baseGSegmentFields(base);
                        this.encodeSegment(output, baseFields);
                        continue;
                    }
                    output.writeShort((short)0);
                }
                break;
            }
            case 10: {
                for (int i = 0; i < count; ++i) {
                    RtdbScanPoint scan = null;
                    scan = ptrArray ? ((RtdbScanPoint[])data)[i] : (RtdbScanPoint)data;
                    if (scan != null) {
                        List<RtdbField> scanFields = protol.scanSegmentFields(scan);
                        this.encodeSegment(output, scanFields);
                        continue;
                    }
                    output.writeShort((short)0);
                }
                break;
            }
            case 11: {
                for (int i = 0; i < count; ++i) {
                    RtdbCalcPoint calc = null;
                    calc = ptrArray ? ((RtdbCalcPoint[])data)[i] : (RtdbCalcPoint)data;
                    if (calc != null) {
                        List<RtdbField> calcFields = protol.calcSegmentFields(calc);
                        this.encodeSegment(output, calcFields);
                        continue;
                    }
                    output.writeShort((short)0);
                }
                break;
            }
            case 12: {
                for (int i = 0; i < count; ++i) {
                    NamedDataTypeField namedDataTypeField = null;
                    namedDataTypeField = ptrArray ? ((NamedDataTypeField[])data)[i] : (NamedDataTypeField)data;
                    if (namedDataTypeField != null) {
                        List<RtdbField> namedFields = protol.namedDataTypeSegmentFields(namedDataTypeField);
                        this.encodeSegment(output, namedFields);
                        continue;
                    }
                    output.writeShort((short)0);
                }
                break;
            }
            default: {
                throw new EncodePacketErrorException();
            }
        }
    }

    public void encodeSegment(MemoryStream output, List<RtdbField> fields) throws IOException, EncodePacketErrorException {
        int size = this.getSegmentSize(fields);
        output.writeShort((short)(size - 2));
        block3: for (int i = 0; i < fields.size(); ++i) {
            RtdbField field = fields.get(i);
            if (field.getData() == null) {
                this.encodeBaseType(output, field);
                continue;
            }
            if (field.getData().equals(-1431655766)) {
                throw new EncodePacketErrorException();
            }
            if (field.getCount() >= 0) {
                int count = field.getCount();
                if (count <= 0) continue;
                this.encodeBaseTypeArray(output, field);
                continue;
            }
            RtdbField prevField = fields.get(i - 1);
            if (prevField.getType() != 2 && prevField.getType() != 3) {
                throw new EncodePacketErrorException();
            }
            switch (field.getCount()) {
                case -1: {
                    if (prevField.getData() != null) {
                        throw new EncodePacketErrorException();
                    }
                    this.encodeBaseTypeArray(output, field);
                    continue block3;
                }
                default: {
                    throw new EncodePacketErrorException();
                }
            }
        }
    }

    private void fieldsToCalcPoint(List<RtdbField> fields, RtdbCalcPoint calc) {
        if (calc == null) {
            return;
        }
        int index = 1;
        calc.setEquation((String)fields.get(index).getData());
        calc.setTrigger(RTDBTrigger.parse((int)fields.get(++index).getIvalue()));
        calc.setTimecopy(RTDBTimeCopy.parse((int)fields.get(++index).getIvalue()));
        calc.setPeriod((int)fields.get(++index).getIvalue());
    }

    private void fieldsToScanPoint(List<RtdbField> fields, RtdbScanPoint scan) {
        if (scan == null) {
            return;
        }
        int index = 1;
        scan.setSource((String)fields.get(index).getData());
        scan.setScan((byte)fields.get(++index).getIvalue());
        scan.setInstrument((String)fields.get(index += 2).getData());
        scan.setLocation((int[])fields.get(++index).getData());
        scan.setUserints((int[])fields.get(++index).getData());
        scan.setUserreals((float[])fields.get(++index).getData());
    }

    @Override
    public String formatMessage(RtdbError error) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        return error.toString();
    }

    @Override
    public String formatTimespan(int timeSpan) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException {
        if (timeSpan <= 0) {
            throw new InvalidParameterException();
        }
        int y = 0;
        int m = 0;
        int d = 0;
        int h = 0;
        int n = 0;
        int s = 0;
        y = timeSpan / 31536000;
        m = (timeSpan %= 31536000) / 2592000;
        d = (timeSpan %= 2592000) / 86400;
        h = (timeSpan %= 86400) / 3600;
        n = (timeSpan %= 3600) / 60;
        s = timeSpan %= 60;
        String result = "";
        if (y != 0) {
            result = result + y + "y";
        }
        if (m != 0) {
            result = result + m + "m";
        }
        if (d != 0) {
            result = result + d + "d";
        }
        if (h != 0) {
            result = result + h + "h";
        }
        if (n != 0) {
            result = result + n + "n";
        }
        if (s != 0) {
            result = result + s + "s";
        }
        if (result.length() <= 0) {
            result = "0s";
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAuthorizations(String[] addrs, String[] masks, RtdbPrivGroup[] privs, String[] descs, int count) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (addrs == null || masks == null || privs == null || descs == null || count <= 0) {
            throw new InvalidParameterException();
        }
        if (count >= 100) {
            count = 100;
        }
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_GET_AUTHORIZATIONS, this.getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = protol.msgGetAuthsFields(count);
            this.sendPacket(fields, false);
            int[] intAddrs = new int[count];
            int[] intMasks = new int[count];
            int[] intPrivs = new int[count];
            short[] intCount = new short[count];
            List<RtdbField> rFields = protol.msgGetAuthsRespFields(0, 0, intAddrs, intMasks, intPrivs, intCount, descs);
            this.receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK && ret != RtdbError.GoE_FALSE) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
            count = this.getCount(rFields);
            if (version.equals(version)) {
                DatagramServer.datagram_get_authorization_ipv6_resp.Builder builder = DatagramServer.datagram_get_authorization_ipv6_resp.newBuilder();
                RtdbField p = rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builder.mergeFrom(buf, 4, buf.length - 8);
                count = builder.getAddressesCount();
                if (count >= 0) {
                    for (int i = 0; i < count; ++i) {
                        String[] strArr = IPUtil.getIpOrMaskFromByte16(builder.getAddresses(i), builder.getMasks(i));
                        addrs[i] = strArr[0];
                        masks[i] = strArr[1];
                        descs[i] = new String(builder.getDescriptions(i).toByteArray(), "GBK");
                        privs[i] = RtdbPrivGroup.parse(builder.getPrivileges(i));
                    }
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    addrs[i] = IPUtil.intToIp1(intAddrs[i]);
                    masks[i] = IPUtil.intToIp1(intMasks[i]);
                    privs[i] = RtdbPrivGroup.parse(intPrivs[i]);
                }
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBlacklists(String[] addrs, String[] masks, String[] descs, int count) throws UnexpectedMethodException, InvalidParameterException, NoAuthorityException, Exception {
        if (addrs == null || masks == null || descs == null || count <= 0) {
            throw new InvalidParameterException();
        }
        if (count >= 100) {
            count = 100;
        }
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_GET_USERS, this.getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = protol.msgGetBlacklistFields(count);
            this.sendPacket(fields, false);
            int[] intAddrs = new int[count];
            int[] intMasks = new int[count];
            short[] intCount = new short[count];
            List<RtdbField> rFields = protol.msgGetBlacklistRespFields(0, 0, intAddrs, intMasks, intCount, descs);
            this.receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK && ret != RtdbError.GoE_FALSE) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
            count = this.getCount(rFields);
            if (version.equals(version)) {
                DatagramServer.datagram_get_blacklist_ipv6_resp.Builder builder = DatagramServer.datagram_get_blacklist_ipv6_resp.newBuilder();
                RtdbField p = rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builder.mergeFrom(buf, 4, buf.length - 8);
                for (int i = 0; i < builder.getAddressList().size(); ++i) {
                    String[] strArr = IPUtil.getIpOrMaskFromByte16(builder.getAddress(i), builder.getMasks(i));
                    addrs[i] = strArr[0];
                    masks[i] = strArr[1];
                }
                int ds = builder.getDescriptionCount();
                if (ds > 0) {
                    for (int i = 0; i < ds; ++i) {
                        byte[] bt = builder.getDescription(i).toByteArray();
                        descs[i] = new String(bt, "GBK");
                    }
                }
            } else {
                for (int i = 0; i < count; ++i) {
                    addrs[i] = IPUtil.intToIp1(intAddrs[i]);
                    masks[i] = IPUtil.intToIp1(intMasks[i]);
                }
            }
            return count;
        }
    }

    @Override
    public synchronized int getOWNconnect() throws Exception {
        List<RtdbField> wFields = protol.msgGetOWNConnectFields();
        this.sendPacket(wFields, false);
        List<RtdbField> rFields = protol.msgGetOWNConnectRespFields();
        this.receivePacket(rFields, true);
        int handle = (int)rFields.get(RtdbGlobalEnum.FIELD_CNT.getNum()).getIvalue();
        return handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<RtdbHostConnectInfo> getConnectInfos() throws IOException, EncodePacketErrorException, Exception {
        if (!this.apiPre(this, RtdbMsgID.MSG_GET_CONNECTION_INFO_IPV6, this.getLogin())) {
            throw new NoAuthorityException();
        }
        int[] sockets = this.getConnections();
        ArrayList<RtdbHostConnectInfo> list = new ArrayList<RtdbHostConnectInfo>(500);
        for (int socket : sockets) {
            List<RtdbField> fields = protol.msgGetConnectInfoFields(socket);
            RtdbHostConnectInfo info = new RtdbHostConnectInfo();
            List<RtdbField> rFields = protol.msgGetConnectInfoRespFields(0, 0, (short)0, 0, 0, 0, info.getClient(), info.getProcess(), info.getUser());
            RtdbServerImpl rtdbServerImpl = this;
            synchronized (rtdbServerImpl) {
                this.sendPacket(fields, false);
                this.receivePacket(rFields, false);
            }
            long longRet = rFields.get(RtdbGlobalEnum.FIELD_RET.getNum()).getIvalue();
            RtdbError ret = RtdbErrorParse.getRtdbError(longRet);
            if (ret.equals(RtdbError.GoE_OK)) {
                if (version.equals(version)) {
                    DatagramServer.datagram_get_connection_info_ipv6_resp.Builder builder = DatagramServer.datagram_get_connection_info_ipv6_resp.newBuilder();
                    RtdbField p = rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                    byte[] buf = (byte[])p.getData();
                    builder.mergeFrom(buf, 4, buf.length - 8);
                    int ip = builder.getIpAddress();
                    String strIp = null;
                    if (ip != 0) {
                        strIp = IPUtil.intToIp(ip);
                    } else if (builder.getIpv6Address().size() > 0) {
                        strIp = IPUtil.getIpFromByte16(builder.getIpv6Address());
                    }
                    info.setIpaddr(strIp);
                    info.setPort(builder.getPort());
                    info.setJob(this.getJobMessage(builder.getJob()));
                    info.setJob_time(DateUtil.getDate(builder.getJobTime(), 0));
                    info.setConnect_time(DateUtil.getDate(builder.getConnectTime(), 0));
                    info.setClient(builder.getClient().toStringUtf8());
                    info.setProcess(new String(builder.getProccess().toByteArray(), "GBK"));
                    info.setUser(new String(CodeUtils.DecodeStringFromBytes(builder.getUser().toByteArray())));
                } else {
                    info.setIpaddr(IPUtil.intToIp((int)rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum()).getIvalue()));
                    info.setPort((int)rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum() + 1).getIvalue());
                    info.setJob(this.getJobMessage((int)rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum() + 2).getIvalue()));
                    info.setJob_time(DateUtil.getDate((int)rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum() + 3).getIvalue(), 0));
                    info.setConnect_time(DateUtil.getDate((int)rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum() + 4).getIvalue(), 0));
                    info.setClient((String)rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum() + 6).getData());
                    info.setProcess((String)rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum() + 8).getData());
                    info.setUser((String)rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum() + 10).getData());
                }
            } else {
                throw new Exception(ret.getErrmsg());
            }
            list.add(info);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getConnectionCount() throws IOException, EncodePacketErrorException, Exception {
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_CONNECT_COUNT, this.getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = protol.msgConnectCountFields();
            this.sendPacket(fields, false);
            List<RtdbField> rFields = protol.msgConnectCountRespFields(0, 0);
            this.receivePacket(rFields, false);
            int count = 0;
            RtdbError ret = this.getRet(rFields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.getErrmsg());
            }
            count = this.getCount(rFields);
            ret.setObj(count);
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RtdbHostConnectInfo getConnectionInfo(int socket) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (socket == 0) {
            throw new InvalidParameterException();
        }
        RtdbHostConnectInfo info = null;
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_GET_CONNECTION_INFO_IPV6, this.getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = protol.msgGetConnectInfoFields(socket);
            this.sendPacket(fields, false);
            List<RtdbField> rFields = protol.msgGetConnectInfoRespFields(0, 0, (short)0, 0, 0, 0, "", "", "");
            this.receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
            if (version.equals(version)) {
                info = new RtdbHostConnectInfo();
                DatagramServer.datagram_get_connection_info_ipv6_resp.Builder builder = DatagramServer.datagram_get_connection_info_ipv6_resp.newBuilder();
                RtdbField p = rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builder.mergeFrom(buf, 4, buf.length - 8);
                if (builder.getIpAddress() != 0) {
                    info.setIpaddr(IPUtil.intToIp(builder.getIpAddress()));
                } else {
                    info.setIpaddr(IPUtil.getIpFromByte16(builder.getIpv6Address()));
                }
                info.setPort(builder.getPort());
                info.setJob(this.getJobMessage(builder.getJob()));
                info.setJob_time(DateUtil.getDate(builder.getJobTime(), 0));
                info.setConnect_time(DateUtil.getDate(builder.getConnectTime(), 0));
                info.setClient(builder.getClient().toStringUtf8());
                info.setProcess(builder.getProccess().toStringUtf8());
                info.setUser(CodeUtils.DecodeStringFromBytes(builder.getUser().toByteArray()));
            } else {
                info = new RtdbHostConnectInfo();
                info.setIpaddr(IPUtil.intToIp((int)rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum()).getIvalue()));
                info.setPort((int)rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum() + 1).getIvalue());
                info.setJob(this.getJobMessage((int)rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum() + 2).getIvalue()));
                info.setJob_time(DateUtil.getDate((int)rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum() + 3).getIvalue(), 0));
                info.setConnect_time(DateUtil.getDate((int)rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum() + 4).getIvalue(), 0));
                info.setClient((String)rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum() + 6).getData());
                info.setProcess((String)rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum() + 8).getData());
                info.setUser((String)rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum() + 10).getData());
            }
            return info;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getConnections() throws IOException, EncodePacketErrorException, Exception {
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_GET_CONNECTIONS, this.getLogin())) {
                throw new NoAuthorityException();
            }
            int count = this.getConnectionCount();
            List<RtdbField> fields = protol.msgGetConnectsFields(count);
            this.sendPacket(fields, false);
            int[] sockets = new int[count];
            List<RtdbField> rFields = protol.msgGetConnectsRespFields(0, 0, sockets);
            this.receivePacket(rFields, false);
            RtdbError ret = this.getRet(rFields);
            if (!ret.equals(RtdbError.GoE_OK)) {
                throw new Exception(ret.getErrmsg());
            }
            count = this.getCount(rFields);
            ret.setObj(count);
            if (version.equals(version)) {
                DatagramServer.datagram_get_connections_resp.Builder builder = DatagramServer.datagram_get_connections_resp.newBuilder();
                RtdbField p = rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builder.mergeFrom(buf, 4, buf.length - 8);
                List<Integer> socketsList = builder.getSocketsList();
                for (int i = 0; i < socketsList.size(); ++i) {
                    sockets[i] = socketsList.get(i);
                }
            }
            return sockets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getConnections(int count) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (count <= 0) {
            throw new InvalidParameterException();
        }
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_GET_CONNECTIONS, this.getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = protol.msgGetConnectsFields(count);
            this.sendPacket(fields, false);
            int[] sockets = new int[count];
            List<RtdbField> rFields = protol.msgGetConnectsRespFields(0, 0, sockets);
            this.receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
            if (version.equals(version)) {
                DatagramServer.datagram_get_connections_resp.Builder builder = DatagramServer.datagram_get_connections_resp.newBuilder();
                RtdbField p = rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builder.mergeFrom(buf, 4, buf.length - 8);
                List<Integer> socketsList = builder.getSocketsList();
                if (socketsList.size() > 0) {
                    for (int i = 0; i < socketsList.size(); ++i) {
                        sockets[i] = socketsList.get(i);
                    }
                }
            }
            return sockets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDbInfo1(int index, int size) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        String str = "";
        if (size == 0 || index < RtdbDbParamIndex.RTDB_PARAM_STR_FIRST.getNum() || index > RtdbDbParamIndex.RTDB_PARAM_STR_LAST.getNum()) {
            throw new InvalidParameterException();
        }
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_GET_DB_INFO_STR, this.getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = protol.msgGetDBInfoStrFields(size, index);
            this.sendPacket(fields, false);
            List<RtdbField> rFields = protol.msgGetDBInfoStrRespFields(0, str);
            this.receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
            if (version.equals(version)) {
                DatagramServer.datagram_get_db_info_str_resp.Builder builder = DatagramServer.datagram_get_db_info_str_resp.newBuilder();
                RtdbField p = rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builder.mergeFrom(buf, 4, buf.length - 8);
                ByteString dbInfoStr = builder.getStringParam();
                str = dbInfoStr.toStringUtf8();
            } else {
                int field_str = 17;
                str = (String)rFields.get(field_str).getData();
            }
            return str;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getDbInfo2(int index) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (index < RtdbDbParamIndex.RTDB_PARAM_INT_FIRST.getNum() || index > RtdbDbParamIndex.RTDB_PARAM_INT_LAST.getNum()) {
            throw new InvalidParameterException();
        }
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_GET_DB_INFO_INT, this.getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = protol.msgGetDBInfoIntFields(index);
            this.sendPacket(fields, false);
            List<RtdbField> rFields = protol.msgGetDBInfoIntRespFields(0, 0);
            this.receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
            int value = 0;
            if (version.equals(version)) {
                DatagramServer.datagram_get_db_info_int_resp.Builder builder = DatagramServer.datagram_get_db_info_int_resp.newBuilder();
                RtdbField p = rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builder.mergeFrom(buf, 4, buf.length - 8);
                value = builder.getValue();
            } else {
                int field_str = 16;
                value = (int)rFields.get(field_str).getIvalue();
            }
            return value;
        }
    }

    private FieldSize getFieldsSize(List<RtdbField> fields) throws UnsupportedEncodingException, ParseException {
        FieldSize fieldSize = new FieldSize();
        int totalSize = 0;
        int headerSize = 0;
        int bodySize = 0;
        int dimension = 0;
        long ivalue = fields.get(RtdbGlobalEnum.FIELD_DIM.getNum()).getIvalue();
        if (ivalue >= 0L) {
            dimension = (int)ivalue;
        }
        for (int i = 0; i < fields.size(); ++i) {
            RtdbField field = fields.get(i);
            int size = 0;
            switch (field.getType()) {
                case 0: 
                case 1: {
                    size = 1;
                    break;
                }
                case 2: {
                    size = 2;
                    break;
                }
                case 3: 
                case 5: {
                    size = 4;
                    break;
                }
                case 4: 
                case 6: {
                    size = 8;
                    break;
                }
            }
            if (field.getData() != null) {
                int j;
                if (field.getCount() >= 0) {
                    switch (field.getType()) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            if (version.equals("2")) {
                                size *= field.getCount() * dimension;
                                break;
                            }
                            if (version.equals(version)) {
                                size *= field.getCount();
                                break;
                            }
                        }
                        case 7: 
                        case 8: 
                        case 9: {
                            if (field.getData().equals(-1431655766)) {
                                size = 2;
                                break;
                            }
                            int sum = 0;
                            RtdbBasePoint base = null;
                            for (j = 0; j < field.getCount() * dimension; ++j) {
                                base = field.getIvalue() == -4L ? ((RtdbBasePoint[])field.getData())[j] : (RtdbBasePoint)field.getData();
                                if (base == null) {
                                    sum += 2;
                                    continue;
                                }
                                sum += this.getSegmentSize(field.getType(), base);
                            }
                            size = sum;
                            break;
                        }
                        case 10: {
                            if (field.getData().equals(-1431655766)) {
                                size = 2;
                                break;
                            }
                            int sum = 0;
                            RtdbScanPoint scan = null;
                            for (j = 0; j < field.getCount() * dimension; ++j) {
                                scan = field.getIvalue() == -4L ? ((RtdbScanPoint[])field.getData())[j] : (RtdbScanPoint)field.getData();
                                if (scan == null) {
                                    sum += 2;
                                    continue;
                                }
                                sum += this.getSegmentSize(field.getType(), scan);
                            }
                            size = sum;
                            break;
                        }
                        case 11: {
                            if (field.getData().equals(-1431655766)) {
                                size = 2;
                                break;
                            }
                            int sum = 0;
                            RtdbCalcPoint calc = null;
                            for (j = 0; j < field.getCount() * dimension; ++j) {
                                calc = field.getIvalue() == -4L ? ((RtdbCalcPoint[])field.getData())[j] : (RtdbCalcPoint)field.getData();
                                if (calc == null) {
                                    sum += 2;
                                    continue;
                                }
                                sum += this.getSegmentSize(field.getType(), calc);
                            }
                            size = sum;
                            break;
                        }
                        case 12: {
                            if (field.getData().equals(-1431655766)) {
                                size = 2;
                                break;
                            }
                            int sum = 0;
                            NamedDataTypeField namedTF = null;
                            for (j = 0; j < field.getCount() * dimension; ++j) {
                                namedTF = field.getIvalue() == -4L ? ((NamedDataTypeField[])field.getData())[j] : (NamedDataTypeField)field.getData();
                                if (namedTF == null) {
                                    sum += 2;
                                    continue;
                                }
                                sum += this.getSegmentSize(field.getType(), namedTF);
                            }
                            size = sum;
                        }
                    }
                } else {
                    RtdbField preField = fields.get(i - 1);
                    if (preField.getData() == null) {
                        size *= (int)preField.getIvalue();
                    } else {
                        int sum = 0;
                        switch (preField.getType()) {
                            case 2: {
                                for (j = 0; j < preField.getCount() * dimension; ++j) {
                                    sum += ((short[])preField.getData())[j];
                                }
                                break;
                            }
                            case 3: {
                                for (j = 0; j < preField.getCount() * dimension; ++j) {
                                    sum += ((int[])preField.getData())[j];
                                }
                                break;
                            }
                        }
                        size *= sum;
                    }
                }
            }
            totalSize += size;
            if (i <= RtdbGlobalEnum.FIELD_HCRC.getNum()) {
                headerSize += size;
                continue;
            }
            bodySize += size;
        }
        fieldSize.setBodySize(bodySize);
        fieldSize.setHeaderSize(headerSize);
        fieldSize.setTotalSize(totalSize);
        return fieldSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFileSize(String file) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (file == null || file == "") {
            throw new InvalidParameterException();
        }
        file = this.subString(file, 2047);
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_GET_FILE_SIZE, this.getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = protol.msgGetFileSizeFields(file);
            this.sendPacket(fields, false);
            List<RtdbField> rFields = protol.msgGetFileSizeRespFields(0, 0L);
            this.receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
            long size = 0L;
            if (version.equals(version)) {
                DatagramServer.datagram_get_file_size_resp.Builder builder = DatagramServer.datagram_get_file_size_resp.newBuilder();
                RtdbField p = rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builder.mergeFrom(buf, 4, buf.length - 8);
                size = builder.getFileSize();
            } else {
                int field_filesize = 16;
                size = rFields.get(field_filesize).getIvalue();
            }
            return size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getHostTime() throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_HOST_TIME, this.getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = protol.msgHostTimeFields();
            this.sendPacket(fields, false);
            List<RtdbField> rFields = protol.msgHostTimeRespFields(0, 0, 0);
            this.receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
            int datetime = 0;
            if (version.equals(version)) {
                RtdbField p = rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                DatagramServer.datagram_host_time_resp.Builder builder = DatagramServer.datagram_host_time_resp.newBuilder();
                byte[] buf = (byte[])p.getData();
                builder.mergeFrom(buf, 4, buf.length - 8);
                datetime = builder.getMillseconds();
            } else {
                int field_datetime = 16;
                datetime = (int)rFields.get(field_datetime).getIvalue();
            }
            return DateUtil.getDate(datetime, 0);
        }
    }

    @Override
    public String getJobMessage(int jobId) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        return RtdbMsgID.getByNum(jobId).getMsg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLogicalDrivers() throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        String drivers = "";
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_GET_LOGICAL_DRIVERS, this.getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = protol.msgGetDriversFields();
            this.sendPacket(fields, false);
            List<RtdbField> rFields = protol.msgGetDriversRespFields(0, drivers);
            this.receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
            if (version.equals(version)) {
                DatagramServer.datagram_get_logical_drivers_resp.Builder builder = DatagramServer.datagram_get_logical_drivers_resp.newBuilder();
                RtdbField p = rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builder.mergeFrom(buf, 4, buf.length - 8);
                drivers = builder.getDriverNames().toStringUtf8();
            } else {
                int field_drivers = 17;
                drivers = (String)rFields.get(field_drivers).getData();
            }
            return drivers;
        }
    }

    @Override
    public Login getLogin() {
        return this.login;
    }

    @Override
    public RtdbMsgID getMethod() {
        return this.method;
    }

    private int getSegmentSize(int type, Object data) throws UnsupportedEncodingException, ParseException {
        int size = 0;
        if (data.equals(-1431655766)) {
            data = null;
        }
        switch (type) {
            case 7: {
                if (data != null) {
                    RtdbBasePoint base = (RtdbBasePoint)data;
                    List<RtdbField> baseFields = this.baseISegmentFields(base);
                    size = this.getSegmentSize(baseFields);
                    break;
                }
                size = 2;
                break;
            }
            case 8: {
                if (data != null) {
                    RtdbBasePoint base = (RtdbBasePoint)data;
                    List<RtdbField> baseFields = this.baseUSegmentFields(base);
                    size = this.getSegmentSize(baseFields);
                    break;
                }
                size = 2;
                break;
            }
            case 9: {
                if (data != null) {
                    RtdbBasePoint base = (RtdbBasePoint)data;
                    List<RtdbField> baseFields = this.baseGSegmentFields(base);
                    size = this.getSegmentSize(baseFields);
                    break;
                }
                size = 2;
                break;
            }
            case 10: {
                if (data != null) {
                    RtdbScanPoint scan = (RtdbScanPoint)data;
                    List<RtdbField> scanFields = protol.scanSegmentFields(scan);
                    size = this.getSegmentSize(scanFields);
                    break;
                }
                size = 2;
                break;
            }
            case 11: {
                if (data != null) {
                    RtdbCalcPoint calc = (RtdbCalcPoint)data;
                    List<RtdbField> calcFields = protol.calcSegmentFields(calc);
                    size = this.getSegmentSize(calcFields);
                    break;
                }
                size = 2;
                break;
            }
            case 12: {
                if (data != null) {
                    NamedDataTypeField namedDataTypeField = (NamedDataTypeField)data;
                    List<RtdbField> namedFields = protol.namedDataTypeSegmentFields(namedDataTypeField);
                    size = this.getSegmentSize(namedFields);
                    break;
                }
                size = 2;
                break;
            }
        }
        return size;
    }

    private int getSegmentSize(List<RtdbField> fields) {
        int size = 0;
        int total = 2;
        for (int i = 0; i < fields.size(); ++i) {
            RtdbField p = fields.get(i);
            switch (p.getType()) {
                case 0: 
                case 1: {
                    size = 1;
                    break;
                }
                case 2: {
                    size = 2;
                    break;
                }
                case 3: 
                case 5: {
                    size = 4;
                    break;
                }
                case 4: 
                case 6: {
                    size = 8;
                    break;
                }
            }
            if (p.getData() != null) {
                if (p.getCount() >= 0) {
                    size *= p.getCount();
                } else if (p.getCount() == -1) {
                    RtdbField prev = fields.get(i - 1);
                    size = (int)((long)size * prev.getIvalue());
                }
            }
            total += size;
        }
        return total;
    }

    public Socket getSocket() {
        return this.socket;
    }

    @Override
    public Thread getThread() {
        return this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTimeout(int socket) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (socket == 0) {
            throw new InvalidParameterException();
        }
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_GET_TIMEOUT, this.getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = protol.msgGetTimeoutFields(socket);
            this.sendPacket(fields, false);
            List<RtdbField> rFields = protol.msgGetTimeOutRespFields(0, 0);
            this.receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
            int timeout = 0;
            if (version.equals(version)) {
                timeout = (int)rFields.get(RtdbGlobalEnum.FIELD_INT1.getNum()).getIvalue();
            } else {
                int field_timeout = 16;
                timeout = (int)rFields.get(field_timeout).getIvalue();
            }
            return timeout;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getUsers(int count, String[] users, RtdbPrivGroup[] privs) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (count <= 0 || users == null || privs == null) {
            throw new InvalidParameterException();
        }
        if (count >= 100) {
            count = 100;
        }
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_GET_USERS, this.getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = protol.msgGetUsersFields(count);
            this.sendPacket(fields, false);
            int[] intPrivs = new int[count];
            List<RtdbField> rFields = protol.msgGetUsersRespFields(0, 0, users, intPrivs);
            this.receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
            if (version.equals(version)) {
                DatagramServer.datagram_get_users_resp.Builder builder = DatagramServer.datagram_get_users_resp.newBuilder();
                RtdbField p = rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builder.mergeFrom(buf, 4, buf.length - 8);
                if (builder.getUserInfosCount() >= 0) {
                    List<ByteString> listUsers = builder.getUserInfosList();
                    for (int i = 0; i < listUsers.size(); ++i) {
                        byte[] cs = listUsers.get(i).toByteArray();
                        String userName = CodeUtils.decodeByte(cs, cs.length);
                        users[i] = userName.trim();
                        privs[i] = RtdbPrivGroup.parse(CodeUtils.decodeByte(cs));
                    }
                }
            } else {
                for (int i = 0; i < intPrivs.length; ++i) {
                    privs[i] = RtdbPrivGroup.parse(intPrivs[i]);
                }
            }
        }
    }

    @Override
    public boolean isSnapThreadRun() {
        return null != this.thread && !this.thread.isInterrupted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killConnection(int socket) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (socket == 0) {
            throw new InvalidParameterException();
        }
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_KILL_CONNECTION, this.getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = protol.msgKillConnFields(socket);
            this.sendPacket(fields, false);
            List<RtdbField> rFields = protol.msgKillConnRespFields(0);
            this.receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
        }
    }

    @Override
    public void login() throws IOException, EncodePacketErrorException, UnexpectedMethodException, ParseException, DecodePacketErrorException, InvalidMarkException, InterruptedException, InvalidParameterException, InvalidHeaderException, CrcErrorException, RtdbExecuteErrorException {
        if (this.isLogined) {
            return;
        }
        this.sendLoginPacket(this.login);
        this.isLogined = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mkDir(String dir) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (dir == null || dir == "") {
            throw new InvalidParameterException();
        }
        dir = this.subString(dir, 2047);
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_MKDIR, this.getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = protol.msgMakeDirFields(dir);
            this.sendPacket(fields, false);
            List<RtdbField> rFields = protol.msgMakeDirRespFields(0);
            this.receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openPath(String dir) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (dir == null || dir == "") {
            throw new InvalidParameterException();
        }
        dir = this.subString(dir, 2047);
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_OPEN_PATH, this.getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = protol.msgOpenPathFields(dir);
            this.sendPacket(fields, false);
            List<RtdbField> rFields = protol.msgOpenPathRespFields(0);
            this.receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
        }
    }

    @Override
    public Date parseTime(String str) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, InvalidTimeFormatException, Exception {
        String stroff = "";
        if (str == null) {
            throw new InvalidParameterException();
        }
        str = str.trim();
        for (char c : str.toCharArray()) {
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c - 42 == 0 || c - 43 == 0 || c - 45 == 0 || c - 32 == 0 || c - 58 == 0) continue;
            throw new InvalidTimeFormatException();
        }
        String[] basekeywords = new String[]{"*", "td", "yd", "tm", "mon", "tue", "wed", "thu", "fri", "sat", "sun"};
        long base = 0L;
        long offset = 0L;
        long offsetms = 0L;
        long result = 0L;
        if (str.charAt(0) == '*' || str.charAt(0) >= 'a' && str.charAt(0) <= 'z') {
            str.replaceAll(" ", "");
            String sign = "";
            for (char c : str.toCharArray()) {
                sign = c + "";
                if (c - 43 != 0 && c - 45 != 0) continue;
                String[] strs = str.split("\\" + sign);
                str = strs[0];
                stroff = strs[1];
                break;
            }
            Date date = new Date();
            int year = date.getYear();
            int month = date.getMonth();
            int day = date.getDate();
            Date today = new Date(year, month, day, 0, 0, 0);
            base = today.getTime();
            if (str.equals(basekeywords[0])) {
                base = date.getTime();
            } else if (str.equals(basekeywords[1])) {
                base = today.getTime();
            } else if (str.equals(basekeywords[2])) {
                base -= 86400000L;
            } else if (str.equals(basekeywords[3])) {
                base += 86400000L;
            } else if (str.equals(basekeywords[4])) {
                base += (long)((1 - (today.getDay() == 0 ? 7 : today.getDay())) * 86400 * 1000);
            } else if (str.equals(basekeywords[5])) {
                base += (long)((2 - (today.getDay() == 0 ? 7 : today.getDay())) * 86400 * 1000);
            } else if (str.equals(basekeywords[6])) {
                base += (long)((3 - (today.getDay() == 0 ? 7 : today.getDay())) * 86400 * 1000);
            } else if (str.equals(basekeywords[7])) {
                base += (long)((4 - (today.getDay() == 0 ? 7 : today.getDay())) * 86400 * 1000);
            } else if (str.equals(basekeywords[8])) {
                base += (long)((5 - (today.getDay() == 0 ? 7 : today.getDay())) * 86400 * 1000);
            } else if (str.equals(basekeywords[9])) {
                base += (long)((6 - (today.getDay() == 0 ? 7 : today.getDay())) * 86400 * 1000);
            } else if (str.equals(basekeywords[10])) {
                base += (long)((7 - (today.getDay() == 0 ? 7 : today.getDay())) * 86400 * 1000);
            } else {
                throw new InvalidTimeFormatException();
            }
            result = base;
            if (stroff != "") {
                int index_ms;
                String stroffms = "";
                int index_s = stroff.indexOf(115);
                if (index_s != -1) {
                    String[] strms = stroff.split("s");
                    if (strms[0] == null || strms[0].equals("")) {
                        throw new InvalidTimeFormatException();
                    }
                    stroff = strms[0] + "s";
                    stroffms = strms[1];
                }
                offset = this.parseTimespan(stroff);
                if (stroffms != "" && (index_ms = stroffms.indexOf(109)) != -1) {
                    String[] strsms = stroffms.split("m");
                    if (strsms[0] == null || strsms[0].equals("")) {
                        throw new InvalidTimeFormatException();
                    }
                    stroffms = strsms[0];
                    offsetms = Integer.parseInt(stroffms);
                }
            }
            if (sign.equals("+")) {
                result += offset * 1000L + offsetms;
            }
            if (sign.equals("-")) {
                result -= offset * 1000L + offsetms;
            }
        } else if (str.charAt(0) >= '1' && str.charAt(0) <= '9') {
            int index = 0;
            Date temp = null;
            if (str.lastIndexOf(43) > 8) {
                index = str.lastIndexOf(43);
                if (index + 1 == str.length()) {
                    throw new InvalidTimeFormatException();
                }
                String baseStr = str.substring(0, index);
                temp = DateUtil.stringToDate(baseStr);
                String offsetStr = str.substring(index + 1);
                offset = this.parseTimespan(offsetStr);
            } else if (str.lastIndexOf(45) > 8) {
                index = str.lastIndexOf(45);
                if (index + 1 == str.length()) {
                    throw new InvalidTimeFormatException();
                }
                String baseStr = str.substring(0, index);
                temp = DateUtil.stringToDate(baseStr);
                String offsetStr = str.substring(index + 1);
                offset = this.parseTimespan(offsetStr);
            } else {
                temp = DateUtil.stringToDate(str);
                return temp;
            }
            result = (long)(DateUtil.getSecond(temp) * 1000) + offset;
        } else {
            throw new InvalidTimeFormatException();
        }
        return new Date(result);
    }

    @Override
    public int parseTimespan(String str) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, InvalidTimeFormatException {
        int index_s;
        int index_min;
        int index_h;
        int index_d;
        int index_m;
        if (str == null) {
            throw new InvalidParameterException();
        }
        String strTemp = str;
        str = str.replaceAll(" ", "");
        str = str.replaceAll("\\+", "");
        str = str.replaceAll("-", "");
        String format = "ymdhns0123456789";
        int index = -1;
        for (char c : str.toCharArray()) {
            index = format.indexOf(c);
            if (index != -1) continue;
            throw new InvalidTimeFormatException();
        }
        int n = 0;
        int index_y = strTemp.indexOf(121);
        if (index_y != -1) {
            String[] strs = str.split("y");
            if (strs[0] == null || strs[0].equals("")) {
                throw new InvalidTimeFormatException();
            }
            int year = Integer.parseInt(strs[0]);
            n += year * 365 * 86400;
            if (index_y == strTemp.length() - 1) {
                return n;
            }
            str = strs[1];
        }
        if ((index_m = strTemp.indexOf(109)) != -1) {
            String[] strs = str.split("m");
            if (strs[0] == null || strs[0].equals("")) {
                throw new InvalidTimeFormatException();
            }
            int m = Integer.parseInt(strs[0]);
            n += m * 30 * 86400;
            if (index_m == strTemp.length() - 1) {
                return n;
            }
            str = strs[1];
        }
        if ((index_d = strTemp.indexOf(100)) != -1) {
            String[] strs = str.split("d");
            if (strs[0] == null || strs[0].equals("")) {
                throw new InvalidTimeFormatException();
            }
            int d = Integer.parseInt(strs[0]);
            n += d * 86400;
            if (index_d == strTemp.length() - 1) {
                return n;
            }
            str = strs[1];
        }
        if ((index_h = strTemp.indexOf(104)) != -1) {
            String[] strs = str.split("h");
            if (strs[0] == null || strs[0].equals("")) {
                throw new InvalidTimeFormatException();
            }
            int h = Integer.parseInt(strs[0]);
            n += h * 3600;
            if (index_h == strTemp.length() - 1) {
                return n;
            }
            str = strs[1];
        }
        if ((index_min = strTemp.indexOf(110)) != -1) {
            String[] strs = str.split("n");
            if (strs[0] == null || strs[0].equals("")) {
                throw new InvalidTimeFormatException();
            }
            int min = Integer.parseInt(strs[0]);
            n += min * 60;
            if (index_min == strTemp.length() - 1) {
                return n;
            }
            str = strs[1];
        }
        if ((index_s = strTemp.indexOf(115)) != -1) {
            String[] strs = str.split("s");
            if (strs[0] == null || strs[0].equals("")) {
                throw new InvalidTimeFormatException();
            }
            int s = Integer.parseInt(strs[0]);
            n += s;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readFile(String filePath, int pos, int size) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (filePath == null || filePath == "" || size == 0) {
            throw new InvalidParameterException();
        }
        byte[] content = new byte[size];
        filePath = this.subString(filePath, 2047);
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_READ_FILE, this.getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = protol.msgReadFileFields(filePath, pos, size);
            this.sendPacket(fields, false);
            List<RtdbField> rFields = protol.msgReadFileRespFields(0, 0, content);
            this.receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
            if (version.equals(version)) {
                DatagramServer.datagram_read_file_resp.Builder builder = DatagramServer.datagram_read_file_resp.newBuilder();
                RtdbField p = rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builder.mergeFrom(buf, 4, buf.length - 8);
                content = builder.getReadContents().toByteArray();
            }
            return content;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Rtdb_Path readPath() throws Exception {
        String path = "";
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_READ_PATH, this.getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = protol.msgReadPathFields();
            this.sendPacket(fields, false);
            List<RtdbField> rFields = protol.msgReadPathRespFields(0, path, 0, 0, 0, 0, 0L);
            this.receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
            if (ret == RtdbError.GoE_BATCH_END) {
                throw new Exception(ret.toString());
            }
            Rtdb_Path Info = null;
            if (version.equals(version)) {
                DatagramServer.datagram_read_path_resp.Builder builder = DatagramServer.datagram_read_path_resp.newBuilder();
                RtdbField p = rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builder.mergeFrom(buf, 4, buf.length - 8);
                short isDir = (short)builder.getIsDir();
                int atime = builder.getAccessTime();
                int ctime = builder.getCreateTime();
                int mtime = builder.getMofidyTime();
                long size = builder.getFileSize();
                path = builder.getReadPath().toString("GBK").trim();
                Info = new Rtdb_Path(path, isDir, atime, ctime, mtime, size);
            } else {
                int field_isdir = 16;
                short isDir = (short)rFields.get(field_isdir).getIvalue();
                int field_access = 17;
                int atime = (int)rFields.get(field_access).getIvalue();
                int field_create = 18;
                int ctime = (int)rFields.get(field_create).getIvalue();
                int field_modify = 19;
                int mtime = (int)rFields.get(field_modify).getIvalue();
                int field_size = 20;
                long size = rFields.get(field_size).getIvalue();
                int field_path = 22;
                path = (String)rFields.get(field_path).getData();
                Info = new Rtdb_Path(path, isDir, atime, ctime, mtime, size);
            }
            return Info;
        }
    }

    @Override
    public void receivePacket(List<RtdbField> fields) throws IOException, UnexpectedMethodException, InterruptedException, ParseException, InvalidHeaderException, InvalidMarkException, InvalidParameterException, EncodePacketErrorException, DecodePacketErrorException, CrcErrorException {
        this.receivePacket(fields, false);
    }

    @Override
    public void receivePacket(List<RtdbField> fields, boolean reconn) throws IOException, UnexpectedMethodException, EncodePacketErrorException, InvalidMarkException, InvalidHeaderException, DecodePacketErrorException, InvalidParameterException, ParseException, InterruptedException, CrcErrorException {
        this.receivePacketPriv(fields, true, false);
    }

    private void receivePacketPriv(List<RtdbField> fields, boolean reconn, boolean isConnFlag) throws IOException, UnexpectedMethodException, InvalidMarkException, DecodePacketErrorException, ParseException, InvalidHeaderException, InterruptedException, InvalidParameterException, EncodePacketErrorException, CrcErrorException {
        FieldSize fieldSize = this.getFieldsSize(fields);
        byte[] buffer = new byte[fieldSize.getHeaderSize()];
        int length = 0;
        long startTime = System.currentTimeMillis();
        do {
            try {
                length = this.dis.read(buffer);
                if (log.isDebugEnabled()) {
                    log.debug("buffer length=" + length + "; \u7487\u8bf2\u5f47\u9470\u6941\u6902: " + (System.currentTimeMillis() - startTime) + "ms");
                }
                if (length > 0) continue;
                if (log.isDebugEnabled()) {
                    log.debug("\u6769\u70b4\u5e34\u93c2\ue15e\u7d11\u951b\u5c7e\ue11c\u9366\u3125\u76be\u7487\u66df\u67ca\u9428\u52ee\u7e5b\u93ba\ufffd......");
                }
                this.reConnect();
                if (log.isDebugEnabled()) {
                    log.debug("\u6769\u70b4\u5e34\u93b4\u612c\u59db......");
                }
                fieldSize = this.getFieldsSize(fields);
                buffer = new byte[fieldSize.getHeaderSize()];
                length = this.dis.read(buffer);
            }
            catch (RtdbExecuteErrorException | IOException e) {
                log.error("error:", e);
            }
        } while (length <= 0 && System.currentTimeMillis() - startTime < this.reConnectTimeOut);
        if (log.isDebugEnabled()) {
            log.debug("\u93ba\u30e6\u6579\u93b6\u30e6\u6783\u9470\u6941\u6902: " + (System.currentTimeMillis() - startTime) + " ms");
        }
        List<RtdbField> commonFields = this.msgCommonFields(RtdbMsgID.MSG_COMMON, 0);
        this.decodePacketHeader(buffer, length, commonFields, true);
        boolean parse = true;
        int body = (int)commonFields.get(RtdbGlobalEnum.FIELD_BSIZE.getNum()).getIvalue();
        int method_got = (int)commonFields.get(RtdbGlobalEnum.FIELD_METHOD.getNum()).getIvalue();
        int method_expected = (int)fields.get(RtdbGlobalEnum.FIELD_METHOD.getNum()).getIvalue();
        buffer = new byte[body];
        int offset = 0;
        int receiveBufferSize = 1024;
        int readBytes = 0;
        while (buffer.length - offset > 0) {
            if (buffer.length - offset < receiveBufferSize) {
                receiveBufferSize = buffer.length - offset;
            }
            if ((readBytes = this.dis.read(buffer, offset, receiveBufferSize)) > 0) {
                offset += readBytes;
                continue;
            }
            log.info("\u6769\u70b4\u5e34\u93c2\ue15e\u7d11\u951b\u5c7e\ue11c\u9366\u3125\u76be\u7487\u66e2\u5678\u93c2\u7248\u5e34\u93c0\u8235\u59e4\u93c2\ufffd......");
            this.receivePacketPriv(fields, true, isConnFlag);
        }
        if (method_got == method_expected) {
            this.copyFields(fields, commonFields, true);
        } else if (method_got == RtdbMsgID.MSG_COMMON.getNum()) {
            long retValue = commonFields.get(RtdbGlobalEnum.FIELD_RET.getNum()).getIvalue();
            if (retValue != 0L) {
                RtdbError ret;
                if (log.isDebugEnabled()) {
                    log.debug("retValue: " + retValue);
                }
                if (null != (ret = RtdbErrorParse.getRtdbError(retValue))) {
                    throw new IOException(ret.getErrmsg() + "->error:0x" + Integer.toHexString(ret.getErrcode()));
                }
            }
            parse = false;
        } else {
            if (log.isDebugEnabled()) {
                log.debug("\u93ba\u30e6\u6579\u93b6\u30e6\u6783\u5a11\u581f\u4f05 method \u7f02\u6827\u5f7f: " + method_got + "  throw UnexpectedMethodException.");
            }
            throw new UnexpectedMethodException();
        }
        length = body;
        if (parse) {
            if (!version.equals(version)) {
                this.decodePacketBody(buffer, length, fields, true);
            } else {
                this.decodePacketBody1(buffer, length, fields, true);
            }
        }
    }

    @Override
    public synchronized void receivePacketBody(List<RtdbField> fields) throws IOException, InvalidMarkException, DecodePacketErrorException, CrcErrorException, ParseException {
        int bodyLength = (int)fields.get(RtdbGlobalEnum.FIELD_BSIZE.getNum()).getIvalue();
        byte[] buffer = new byte[bodyLength];
        int nTotalLen = buffer.length;
        int nReadLen = 0;
        for (int nidx = 0; nidx < nTotalLen && (nReadLen = this.dis.read(buffer, nidx, nTotalLen - nidx)) > 0; nidx += nReadLen) {
        }
        if (!version.equals(version)) {
            this.decodePacketBody(buffer, bodyLength, fields, true);
        } else {
            this.decodePacketBody1(buffer, bodyLength, fields, true);
        }
    }

    private void decodePacketBody1(byte[] buffer, int body, List<RtdbField> fields, boolean compareCrc) throws CrcErrorException {
        int crc = 0;
        crc = (int)Crc32Util.getCRC32(buffer, 0, buffer.length - 4, 0);
        int dest_crc = BytesConvertUtil.bytesToInt(buffer, buffer.length - 4);
        if (compareCrc && crc != dest_crc) {
            throw new CrcErrorException();
        }
        RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
        p.setData(buffer);
    }

    @Override
    public synchronized void receivePacketHeader(List<RtdbField> fields) throws IOException, CrcErrorException, InvalidHeaderException, DecodePacketErrorException, UnexpectedMethodException, Exception {
        long retValue;
        boolean isConnected;
        long start;
        int length;
        byte[] buffer;
        block12: {
            FieldSize fieldSize = this.getFieldsSize(fields);
            buffer = new byte[fieldSize.getHeaderSize()];
            length = 0;
            start = System.currentTimeMillis();
            isConnected = true;
            try {
                length = this.dis.read(buffer);
            }
            catch (IOException e) {
                if (!(e instanceof SocketException)) break block12;
                isConnected = false;
            }
        }
        while (!isConnected && System.currentTimeMillis() - start < this.reConnectTimeOut) {
            try {
                length = this.dis.read(buffer);
                isConnected = true;
            }
            catch (IOException e) {
                block13: {
                    if (!(e instanceof SocketException)) continue;
                    try {
                        if (null != this.socket) {
                            this.socket.close();
                        }
                        if (null != this.dis) {
                            this.dis.close();
                        }
                        if (null != this.dos) {
                            this.dos.close();
                        }
                    }
                    catch (Exception ex) {
                        if (!log.isDebugEnabled()) break block13;
                        log.error("\u934f\u62bd\u68f4\u93c1\u7248\u5d41\u6434\u64b3\u5f42\u9422\u71bc\u654a\u7487\ufffd...", ex);
                    }
                }
                this.connect();
            }
        }
        if (length == -1) {
            return;
        }
        List<RtdbField> commonFields = this.msgCommonFields(RtdbMsgID.MSG_COMMON, 0);
        this.decodePacketHeader(buffer, length, commonFields, true);
        int method_got = (int)commonFields.get(RtdbGlobalEnum.FIELD_METHOD.getNum()).getIvalue();
        if (method_got == RtdbMsgID.MSG_COMMON.getNum() && (retValue = commonFields.get(RtdbGlobalEnum.FIELD_RET.getNum()).getIvalue()) != 0L) {
            RtdbError ret = RtdbErrorParse.getRtdbError(retValue);
            throw new IOException(ret.getErrmsg());
        }
        this.copyFields(fields, commonFields, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAuthorization(String addr, String mask) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (addr == null || mask == null) {
            throw new InvalidParameterException();
        }
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_REMOVE_AUTHORIZATION, this.getLogin())) {
                throw new NoAuthorityException();
            }
            byte[] addrBytes16 = IPUtil.ipOrMaskToByte16(addr);
            byte[] maskBytes16 = IPUtil.ipOrMaskToByte16(mask);
            List<RtdbField> fields = protol.msgRemoveAuthFields(ByteString.copyFrom(addrBytes16), ByteString.copyFrom(maskBytes16));
            this.sendPacket(fields, false);
            List<RtdbField> rFields = protol.msgRemoveAuthRespFields(0);
            this.receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBlacklist(String addr, String mask) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (addr == null || mask == null) {
            throw new InvalidParameterException();
        }
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_REMOVE_BLACKLIST, this.getLogin())) {
                throw new NoAuthorityException();
            }
            byte[] addrBytes16 = IPUtil.ipOrMaskToByte16(addr);
            byte[] maskBytes16 = IPUtil.ipOrMaskToByte16(mask);
            List<RtdbField> fields = protol.msgRemoveBlacklistFields(ByteString.copyFrom(addrBytes16), ByteString.copyFrom(maskBytes16));
            this.sendPacket(fields, false);
            List<RtdbField> rFields = protol.msgRemoveBlacklistRespRields(0);
            this.receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUser(String user) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (user == null) {
            throw new InvalidParameterException();
        }
        user = this.subString(user, 19);
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_REMOVE_USER, this.getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = protol.msgRemoveUserFields(user);
            this.sendPacket(fields, false);
            List<RtdbField> rFields = protol.msgRemoveUserRespFields(0);
            this.receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendConnectPacket() throws IOException, ParseException, DecodePacketErrorException, InvalidMarkException, UnexpectedMethodException, EncodePacketErrorException, InterruptedException, InvalidParameterException, InvalidHeaderException, CrcErrorException, RtdbExecuteErrorException {
        String client = this.socket.getLocalAddress().getHostName();
        String process = "RtdbApi4Java";
        List<RtdbField> wFields = protol.msgConnectFields(client, process, this.login.getUsername());
        List<RtdbField> rFields = protol.msgConnectRespFields(0, 0, 0);
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            FieldSize fieldSize = this.getFieldsSize(wFields);
            wFields.get(RtdbGlobalEnum.FIELD_BSIZE.getNum()).setIvalue(fieldSize.getBodySize());
            MemoryStream curStream = this.encodePacketToStream(wFields);
            this.encodePacketSendStream(curStream);
            this.receivePacketPriv(rFields, false, true);
        }
        RtdbError ret = RtdbErrorParse.getRtdbError(rFields.get(RtdbGlobalEnum.FIELD_RET.getNum()).getIvalue());
        if (!ret.equals(RtdbError.GoE_OK)) {
            throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendLoginPacket(Login login) throws IOException, ParseException, EncodePacketErrorException, InvalidMarkException, UnexpectedMethodException, DecodePacketErrorException, InterruptedException, InvalidParameterException, InvalidHeaderException, CrcErrorException, RtdbExecuteErrorException {
        List<RtdbField> wFields = protol.msgLoginField(login);
        List<RtdbField> rFields = protol.msgLoginRespFields(0, 0);
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            FieldSize fieldSize = this.getFieldsSize(wFields);
            wFields.get(RtdbGlobalEnum.FIELD_BSIZE.getNum()).setIvalue(fieldSize.getBodySize());
            MemoryStream curStream = this.encodePacketToStream(wFields);
            this.encodePacketSendStream(curStream);
            this.receivePacketPriv(rFields, false, true);
        }
        long ret = rFields.get(RtdbGlobalEnum.FIELD_RET.getNum()).getIvalue();
        if (ret != 0L) {
            RtdbError retError = RtdbErrorParse.getRtdbError(ret);
            throw new IOException(retError.getErrmsg());
        }
        if (version.equals(version)) {
            DatagramServer.datagram_send_login_packet_resp.Builder builder = DatagramServer.datagram_send_login_packet_resp.newBuilder();
            RtdbField p = rFields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
            byte[] buf = (byte[])p.getData();
            builder.mergeFrom(buf, 4, buf.length - 8);
            int fieldPrivbuf = builder.getPrivilege();
            login.setPriv(fieldPrivbuf);
        } else {
            int fieldPriv = RtdbGlobalEnum.FIELD_NEXT.getNum();
            login.setPriv((int)rFields.get(fieldPriv).getIvalue());
        }
        this.login.setPassword(login.getPassword());
        this.login.setUsername(login.getUsername());
    }

    @Override
    public synchronized void sendPacket(List<RtdbField> fields, boolean reconn) throws Exception {
        FieldSize fieldSize = this.getFieldsSize(fields);
        fields.get(RtdbGlobalEnum.FIELD_BSIZE.getNum()).setIvalue(fieldSize.getBodySize());
        MemoryStream curStream = this.encodePacketToStream(fields);
        this.encodePacketSendStream(curStream);
    }

    public void setCallbackArgs(CallbackProcArgs callbackArgs) {
        this.callbackArgs = callbackArgs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long setDbInfo1(int index, String str) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (str == null || str == "" || index < RtdbDbParamIndex.RTDB_PARAM_STR_FIRST.getNum() || index > RtdbDbParamIndex.RTDB_PARAM_STR_LAST.getNum()) {
            throw new InvalidParameterException();
        }
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_SET_DB_INFO_STR, this.getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = protol.msgSetDBInfoStrFields(index, str);
            this.sendPacket(fields, false);
            List<RtdbField> rFields = protol.msgSetDBInfoStrRespFields(0);
            this.receivePacket(rFields, true);
            long ivalue = rFields.get(RtdbGlobalEnum.FIELD_RET.getNum()).getIvalue();
            return ivalue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long setDbInfo2(int index, int value) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (index < RtdbDbParamIndex.RTDB_PARAM_INT_FIRST.getNum() || index > RtdbDbParamIndex.RTDB_PARAM_INT_LAST.getNum()) {
            throw new InvalidParameterException();
        }
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_SET_DB_INFO_INT, this.getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = protol.msgSetDBInfoIntFields(index, value);
            this.sendPacket(fields, false);
            List<RtdbField> rFields = protol.msgSetDBInfoIntRespFields(0);
            this.receivePacket(rFields, true);
            long ivalue = rFields.get(RtdbGlobalEnum.FIELD_RET.getNum()).getIvalue();
            return ivalue;
        }
    }

    public void setLogin(Login login) {
        this.login = login;
    }

    @Override
    public void setMethod(RtdbMsgID method) {
        this.method = method;
    }

    public void setSocket(Socket socket) {
        this.socket = socket;
    }

    @Override
    public void setThread(Thread thread) {
        this.thread = thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimeout(int timeout) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (this.socket == null) {
            throw new InvalidParameterException();
        }
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_SET_TIMEOUT, this.getLogin())) {
                throw new NoAuthorityException();
            }
            int owNconnect = this.getOWNconnect();
            List<RtdbField> fields = protol.msgSetTimeoutFields(owNconnect, timeout);
            this.sendPacket(fields, false);
            List<RtdbField> rFields = protol.msgSetTimeoutRespFields(0);
            this.receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
        }
    }

    private void skipSegment(MemoryStream input, int count) {
        short value = 0;
        for (int i = 0; i < count; ++i) {
            value = input.readShort();
            if (value <= 0) continue;
            input.skip(value);
        }
    }

    @Override
    public void snapsCallback(RSDataChange callback) {
        this.setMethod(RtdbMsgID.MSG_SUBSCRIBE_SNAPSHOTS_CALLBACK);
        boolean canExit = false;
        while (this.getThread() != null && !canExit && !this.getThread().isInterrupted()) {
            try {
                int count = 0;
                int[] ids = null;
                int[] datetimes = null;
                short[] ms = null;
                double[] values = null;
                long[] states = null;
                short[] qualities = null;
                int[] errors = null;
                List<RtdbField> fields = protol.msgSubscribeSnapshotsCallbackFields(0, count, ids, datetimes, ms, values, states, qualities, errors);
                this.receivePacketHeader(fields);
                RtdbError ret = this.getRet(fields);
                if (ret != RtdbError.GoE_OK) continue;
                int method = (int)fields.get(RtdbGlobalEnum.FIELD_METHOD.getNum()).getIvalue();
                if (method == RtdbMsgID.MSG_CANCEL_SUBSCRIBE_SNAPSHOTS.getNum()) {
                    List<RtdbField> sfields = this.msgCommonFields(RtdbMsgID.MSG_CANCEL_SUBSCRIBE_SNAPSHOTS, 0);
                    this.copyFields(sfields, fields, true);
                    this.receivePacketBody(sfields);
                    canExit = true;
                    break;
                }
                if (version.equals(version)) {
                    this.receivePacketBody(fields);
                    count = this.getCount(fields);
                    if (count == 0) continue;
                    RtdbData[] rtdbDatas = new RtdbData[count];
                    DatagramSnapshots.datagram_subscribe_snapshots_callback.Builder builder = DatagramSnapshots.datagram_subscribe_snapshots_callback.newBuilder();
                    RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                    byte[] buf = (byte[])p.getData();
                    builder.mergeFrom(buf, 4, buf.length - 8);
                    long temp_state = 0L;
                    for (int i = 0; i < rtdbDatas.length; ++i) {
                        RtdbData data = new RtdbData();
                        data.setId(builder.getIds(i));
                        data.setDate(DateUtil.getDate(builder.getDatetimes(i), (short)builder.getMs(i)));
                        temp_state = builder.getStates(i);
                        RtdbType dataType = RtdbType.parse(builder.getDescriptorForType().getIndex());
                        data.setRtdbType(dataType);
                        data.setState(temp_state);
                        if (temp_state != 0L) {
                            data.setValue(temp_state);
                        } else {
                            data.setValue(builder.getValues(i));
                        }
                        data.setQuality((short)builder.getQualities(i));
                        data.setError(builder.getErrors(i));
                        rtdbDatas[i] = data;
                    }
                    callback.run(rtdbDatas, null);
                    continue;
                }
                count = this.getCount(fields);
                if (count <= 0) continue;
                ids = new int[count];
                datetimes = new int[count];
                ms = new short[count];
                values = new double[count];
                states = new long[count];
                qualities = new short[count];
                errors = new int[count];
                int fields_ids = 16;
                int fields_dt = 17;
                int fields_ms = 18;
                int fields_vals = 19;
                int fields_stas = 20;
                int fields_qs = 21;
                int fields_errs = 22;
                fields.get(fields_ids).setData(ids);
                fields.get(fields_dt).setData(datetimes);
                fields.get(fields_ms).setData(ms);
                fields.get(fields_vals).setData(values);
                fields.get(fields_stas).setData(states);
                fields.get(fields_qs).setData(qualities);
                fields.get(fields_errs).setData(errors);
                this.receivePacketBody(fields);
                ret = this.getRet(fields);
                if (ret != RtdbError.GoE_OK && ret != RtdbError.GoE_FALSE) continue;
                count = this.getCount(fields);
                RtdbData[] rtdbDatas = new RtdbData[count];
                for (int i = 0; i < rtdbDatas.length; ++i) {
                    RtdbData data;
                    rtdbDatas[i] = data = new RtdbData();
                    data.setId(ids[i]);
                    data.setDate(DateUtil.getDate(datetimes[i], ms[i]));
                    if (states[i] != 0L) {
                        data.setValue(states[i]);
                    } else {
                        data.setValue(values[i]);
                    }
                    if (null == data.getValue()) {
                        data.setValue(0);
                    }
                    data.setQuality(qualities[i]);
                    data.setError(errors[i]);
                }
                callback.run(rtdbDatas, null);
            }
            catch (Exception e) {
                if (e instanceof SocketException || e instanceof IOException || e instanceof ConnectException || e instanceof InvalidHeaderException) {
                    callback.run(null, e);
                }
                log.error(e);
            }
        }
        this.unlock();
    }

    @Override
    public void snapsCallbackEx(Object param, RSDataChangeEx callback) {
        this.setMethod(RtdbMsgID.MSG_SUBSCRIBE_SNAPSHOTS_CALLBACK);
        boolean canExit = false;
        while (this.getThread() != null && !canExit && !this.getThread().isInterrupted()) {
            try {
                int count = 0;
                int[] ids = null;
                int[] datetimes = null;
                short[] ms = null;
                double[] values = null;
                long[] states = null;
                short[] qualities = null;
                int[] errors = null;
                List<RtdbField> fields = protol.msgSubscribeSnapshotsCallbackFields(0, count, ids, datetimes, ms, values, states, qualities, errors);
                this.receivePacketHeader(fields);
                RtdbError ret = this.getRet(fields);
                if (ret != RtdbError.GoE_OK) {
                    log.error("receivePacketHeader error: " + (Object)((Object)ret));
                    continue;
                }
                int method = (int)fields.get(RtdbGlobalEnum.FIELD_METHOD.getNum()).getIvalue();
                if (method == RtdbMsgID.MSG_CANCEL_SUBSCRIBE_SNAPSHOTS.getNum()) {
                    List<RtdbField> sfields = this.msgCommonFields(RtdbMsgID.MSG_CANCEL_SUBSCRIBE_SNAPSHOTS, 0);
                    this.copyFields(sfields, fields, true);
                    this.receivePacketBody(sfields);
                    canExit = true;
                    break;
                }
                if (version.equals(version)) {
                    this.receivePacketBody(fields);
                    ret = this.getRet(fields);
                    if (ret != RtdbError.GoE_OK && ret == RtdbError.GoE_FALSE) continue;
                    count = this.getCount(fields);
                    RtdbData[] rtdbDatas = new RtdbData[count];
                    DatagramSnapshots.datagram_subscribe_snapshots_callback.Builder builder = DatagramSnapshots.datagram_subscribe_snapshots_callback.newBuilder();
                    byte[] buf = (byte[])fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum()).getData();
                    try {
                        builder.mergeFrom(buf, 4, buf.length - 8);
                    }
                    catch (InvalidProtocolBufferException e) {
                        continue;
                    }
                    long temp_state = 0L;
                    for (int i = 0; i < rtdbDatas.length; ++i) {
                        RtdbData data = new RtdbData();
                        data.setId(builder.getIds(i));
                        data.setDate(DateUtil.getDate(builder.getDatetimes(i), (short)builder.getMs(i)));
                        temp_state = builder.getStates(i);
                        if (temp_state != 0L) {
                            data.setValue(temp_state);
                        } else {
                            data.setValue(builder.getValues(i));
                        }
                        data.setQuality((short)builder.getQualities(i));
                        data.setError(builder.getErrors(i));
                        rtdbDatas[i] = data;
                    }
                    callback.run(param, rtdbDatas, null);
                    continue;
                }
                count = this.getCount(fields);
                if (count <= 0) continue;
                ids = new int[count];
                datetimes = new int[count];
                ms = new short[count];
                values = new double[count];
                states = new long[count];
                qualities = new short[count];
                errors = new int[count];
                int fields_ids = 16;
                int fields_dt = 17;
                int fields_ms = 18;
                int fields_vals = 19;
                int fields_stas = 20;
                int fields_qs = 21;
                int fields_errs = 22;
                fields.get(fields_ids).setData(ids);
                fields.get(fields_dt).setData(datetimes);
                fields.get(fields_ms).setData(ms);
                fields.get(fields_vals).setData(values);
                fields.get(fields_stas).setData(states);
                fields.get(fields_qs).setData(qualities);
                fields.get(fields_errs).setData(errors);
                this.receivePacketBody(fields);
                ret = this.getRet(fields);
                if (ret != RtdbError.GoE_OK && ret != RtdbError.GoE_FALSE) continue;
                count = this.getCount(fields);
                RtdbData[] rtdbDatas = new RtdbData[count];
                for (int i = 0; i < rtdbDatas.length; ++i) {
                    RtdbData data;
                    rtdbDatas[i] = data = new RtdbData();
                    data.setId(ids[i]);
                    data.setDate(DateUtil.getDate(datetimes[i], ms[i]));
                    if (states[i] != 0L) {
                        data.setValue(states[i]);
                    } else {
                        data.setValue(values[i]);
                    }
                    if (null == data.getValue()) {
                        data.setValue(0);
                    }
                    data.setQuality(qualities[i]);
                    data.setError(errors[i]);
                }
                callback.run(param, rtdbDatas, null);
            }
            catch (Exception e) {
                if (e instanceof SocketException || e instanceof IOException || e instanceof ConnectException || e instanceof InvalidHeaderException) {
                    callback.run(param, null, e);
                }
                log.error(e);
            }
        }
        this.unlock();
    }

    @Override
    public void subscribeSnaps(RSDataChange callback) {
        this.callbackArgs = new CallbackProcArgs();
        this.callbackArgs.setRtdbServer(this);
        this.callbackArgs.setSnapCallback(callback);
        SnapsCallbackProc snapsCallbackProc = new SnapsCallbackProc(this.callbackArgs);
        Thread tempThread = new Thread(snapsCallbackProc);
        this.setThread(tempThread);
        this.thread.setDaemon(false);
        this.thread.start();
    }

    @Override
    public void subscribeSnapsEx(Object param, RSDataChangeEx callback) {
        this.callbackArgs = new CallbackProcArgs();
        this.callbackArgs.setRtdbServer(this);
        this.callbackArgs.setSnapCallbackEx(callback);
        SnapsCallbackProcEx snapsCallbackProc = new SnapsCallbackProcEx(this.callbackArgs, param);
        Thread tempThread = new Thread(snapsCallbackProc);
        this.setThread(tempThread);
        this.thread.setDaemon(false);
        this.thread.start();
    }

    @Override
    public void subscribeTags(RBTagsChange callback) {
        CallbackProcArgs args = new CallbackProcArgs();
        args.setRtdbServer(this);
        args.setTagCallback(callback);
        TagsCallbackProc tagsCallbackProc = new TagsCallbackProc(args);
        Thread thread = new Thread(tagsCallbackProc);
        this.setThread(thread);
        thread.setDaemon(false);
        thread.start();
    }

    @Override
    public void subscribeTagsEx(Object param, RBTagsChangeEx callback) {
        CallbackProcArgs args = new CallbackProcArgs();
        args.setRtdbServer(this);
        args.setTagCallbackEx(callback);
        TagsCallbackProcEx tagsCallbackProc = new TagsCallbackProcEx(args, param);
        Thread thread = new Thread(tagsCallbackProc);
        this.setThread(thread);
        thread.setDaemon(false);
        thread.start();
    }

    @Override
    public void tagsCallback(RBTagsChange callback) throws IOException, InvalidMarkException, DecodePacketErrorException, CrcErrorException, Exception {
        this.setMethod(RtdbMsgID.MSG_SUBSCRIBE_TAGS_CALLBACK);
        boolean canExit = false;
        while (this.getThread() != null && !canExit && !this.getThread().isInterrupted()) {
            int count = 0;
            int[] ids = null;
            List<RtdbField> fields = protol.msgSubscribeTagsCallbackFields(0, 0, ids, 0);
            this.receivePacketHeader(fields);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
            int method = (int)fields.get(RtdbGlobalEnum.FIELD_METHOD.getNum()).getIvalue();
            if (method == RtdbMsgID.MSG_CANCEL_SUBSCRIBE_TAGS.getNum()) {
                List<RtdbField> sfields = this.msgCommonFields(RtdbMsgID.MSG_CANCEL_SUBSCRIBE_TAGS, 0);
                this.copyFields(sfields, fields, true);
                this.receivePacketBody(sfields);
                canExit = true;
                break;
            }
            count = this.getCount(fields);
            if (count <= 0) continue;
            ids = new int[count];
            int field_what = RtdbGlobalEnum.FIELD_NEXT.getNum();
            int field_ids = field_what + 1;
            fields.get(field_ids).setData(ids);
            this.receivePacketBody(fields);
            ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
            if (this.getThread() == null) continue;
            if (version.equals(version)) {
                DatagramBase.datagram_subscribe_tags_callback.Builder builder = DatagramBase.datagram_subscribe_tags_callback.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builder.mergeFrom(buf, 4, buf.length - 8);
                int reason_ = builder.getReason();
                List<Integer> idsList = builder.getIdsList();
                ids = new int[idsList.size()];
                for (int i = 0; i < idsList.size(); ++i) {
                    ids[i] = idsList.get(i);
                }
                callback.run(ids, RtdbTagChangeReason.parse(reason_));
                continue;
            }
            int what = (int)fields.get(field_what).getIvalue();
            callback.run(ids, RtdbTagChangeReason.parse(what));
        }
        this.unlock();
    }

    @Override
    public void tagsCallbackEx(Object param, RBTagsChangeEx callback) throws IOException, InvalidMarkException, DecodePacketErrorException, CrcErrorException, Exception {
        this.setMethod(RtdbMsgID.MSG_SUBSCRIBE_TAGS_CALLBACK);
        boolean canExit = false;
        while (this.getThread() != null && !canExit && !this.getThread().isInterrupted()) {
            int count = 0;
            int[] ids = null;
            List<RtdbField> fields = protol.msgSubscribeTagsCallbackFields(0, 0, ids, 0);
            this.receivePacketHeader(fields);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
            int method = (int)fields.get(RtdbGlobalEnum.FIELD_METHOD.getNum()).getIvalue();
            if (method == RtdbMsgID.MSG_CANCEL_SUBSCRIBE_TAGS.getNum()) {
                List<RtdbField> sfields = this.msgCommonFields(RtdbMsgID.MSG_CANCEL_SUBSCRIBE_TAGS, 0);
                this.copyFields(sfields, fields, true);
                this.receivePacketBody(sfields);
                canExit = true;
                break;
            }
            count = this.getCount(fields);
            if (count <= 0) continue;
            ids = new int[count];
            int field_what = RtdbGlobalEnum.FIELD_NEXT.getNum();
            int field_ids = field_what + 1;
            fields.get(field_ids).setData(ids);
            this.receivePacketBody(fields);
            ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
            if (this.getThread() == null) continue;
            if (version.equals(version)) {
                DatagramBase.datagram_subscribe_tags_callback.Builder builder = DatagramBase.datagram_subscribe_tags_callback.newBuilder();
                RtdbField p = fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum());
                byte[] buf = (byte[])p.getData();
                builder.mergeFrom(buf, 4, buf.length - 8);
                int reason_ = builder.getReason();
                List<Integer> idsList = builder.getIdsList();
                ids = new int[idsList.size()];
                for (int i = 0; i < idsList.size(); ++i) {
                    ids[i] = idsList.get(i);
                }
                callback.run(param, ids, RtdbTagChangeReason.parse(reason_));
                continue;
            }
            int what = (int)fields.get(field_what).getIvalue();
            callback.run(param, ids, RtdbTagChangeReason.parse(what));
        }
        this.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAuthorization(String addr, String mask, String newAddr, String newMask, RtdbPrivGroup priv, String desc) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (addr == null || mask == null || newAddr == null || newMask == null || priv == null || desc == null) {
            throw new InvalidParameterException();
        }
        desc = this.subString(desc, 512);
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_UPDATE_AUTHORIZATION, this.getLogin())) {
                throw new NoAuthorityException();
            }
            byte[] addrBytes16 = IPUtil.ipOrMaskToByte16(addr);
            byte[] maskBytes16 = IPUtil.ipOrMaskToByte16(mask);
            byte[] addrNewBytes16 = IPUtil.ipOrMaskToByte16(newAddr);
            byte[] maskNewBytes16 = IPUtil.ipOrMaskToByte16(newMask);
            List<RtdbField> fields = protol.msgUpdateAuthFields(ByteString.copyFrom(addrBytes16), ByteString.copyFrom(maskBytes16), ByteString.copyFrom(addrNewBytes16), ByteString.copyFrom(maskNewBytes16), priv, desc);
            this.sendPacket(fields, false);
            List<RtdbField> rFields = protol.msgUpdateAuthRespFields(0);
            this.receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBlacklist(String addr, String mask, String newAddr, String newMask, String desc) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (addr == null || mask == null || newAddr == null || newMask == null || desc == null) {
            throw new InvalidParameterException();
        }
        desc = this.subString(desc, 512);
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_UPDATE_BLACKLIST, this.getLogin())) {
                throw new NoAuthorityException();
            }
            byte[] addrBytes16 = IPUtil.ipOrMaskToByte16(addr);
            byte[] maskBytes16 = IPUtil.ipOrMaskToByte16(mask);
            byte[] addrNewBytes16 = IPUtil.ipOrMaskToByte16(newAddr);
            byte[] maskNewBytes16 = IPUtil.ipOrMaskToByte16(newMask);
            List<RtdbField> fields = protol.msgUpdateBlacklistFields(ByteString.copyFrom(addrBytes16), ByteString.copyFrom(maskBytes16), ByteString.copyFrom(addrNewBytes16), ByteString.copyFrom(maskNewBytes16), desc);
            this.sendPacket(fields, false);
            List<RtdbField> rFields = protol.msgUpdateBlacklistRespFields(0);
            this.receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
        }
    }

    @Override
    public boolean judgeConnectStatus(int socket) throws InvalidParameterException, IOException, EncodePacketErrorException, Exception {
        if (socket <= 0) {
            throw new InvalidParameterException();
        }
        RtdbHostConnectInfo info = this.getConnectionInfo(socket);
        return null != info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxBlobLen() throws NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_GET_MAX_BLOB_LEN, this.getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> fields = protol.msgGetMaxBlobLenFields();
            this.sendPacket(fields, false);
            fields = protol.msgGetMaxBlobLenRespFields();
            this.receivePacket(fields, true);
            RtdbError ret = this.getRet(fields);
            if (ret != RtdbError.GoE_OK) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
            if (version.equals("2")) {
                int len = (int)fields.get(RtdbGlobalEnum.FIELD_NEXT.getNum()).getIvalue();
                return len;
            }
            int len = (int)fields.get(RtdbGlobalEnum.FIELD_CNT.getNum()).getIvalue();
            return len;
        }
    }

    @Override
    public boolean isOpen() {
        try {
            return !this.socket.isClosed();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public List<String> formatQuality(int count, int[] qualities) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (count == 0 || qualities.length == 0) {
            throw new InvalidParameterException();
        }
        ArrayList<String> definitions = new ArrayList<String>(qualities.length);
        int c_count = count;
        String[] first = new String[]{"Bad", "Uncertain", "N/A", "Good"};
        String[] second_one = new String[]{"Non-specific", "Configuration Error", "Not Connected", "Device failure", "Sensor failure", "Last known value", "Comm failure", "Out of Service", "Waiting for Initial Data", "N/A"};
        String[] second_two = new String[]{"Non-specific", "Last Usable Value", "N/A", "Sensor Not Accurate", "Engineering Units Exceeded", "Sub-Normal", "N/A"};
        String[] second_three = new String[]{"Non-specific", "N/A", "Local Override", "N/A"};
        String[] third = new String[]{"Not Limited", "Low Limited", "High Limited", "Constant"};
        for (int i = 0; i < c_count; ++i) {
            String pointer_de;
            int len_first = -1;
            int len_second_1 = -1;
            int len_second_2 = -1;
            int len_second_3 = -1;
            int len_thrid = -1;
            if ((qualities[i] & Short.MAX_VALUE) >= 256 && (qualities[i] & Short.MAX_VALUE) < 512) {
                int opc_qua = 0 == (qualities[i] & Short.MAX_VALUE) ? 192 : qualities[i] & 0xFF;
                block0 : switch (0xC0 & opc_qua) {
                    case 0: {
                        len_first = 0;
                        switch (opc_qua & 0xFC) {
                            case 0: {
                                len_second_1 = 0;
                                break block0;
                            }
                            case 4: {
                                len_second_1 = 1;
                                break block0;
                            }
                            case 8: {
                                len_second_1 = 2;
                                break block0;
                            }
                            case 12: {
                                len_second_1 = 3;
                                break block0;
                            }
                            case 16: {
                                len_second_1 = 4;
                                break block0;
                            }
                            case 20: {
                                len_second_1 = 5;
                                break block0;
                            }
                            case 24: {
                                len_second_1 = 6;
                                break block0;
                            }
                            case 28: {
                                len_second_1 = 7;
                                break block0;
                            }
                            case 32: {
                                len_second_1 = 8;
                                break block0;
                            }
                        }
                        len_second_1 = 9;
                        break;
                    }
                    case 64: {
                        len_first = 1;
                        switch (opc_qua & 0xFC) {
                            case 64: {
                                len_second_2 = 0;
                                break block0;
                            }
                            case 68: {
                                len_second_2 = 1;
                                break block0;
                            }
                            case 80: {
                                len_second_2 = 3;
                                break block0;
                            }
                            case 84: {
                                len_second_2 = 4;
                                break block0;
                            }
                            case 88: {
                                len_second_2 = 5;
                                break block0;
                            }
                        }
                        len_second_2 = 6;
                        break;
                    }
                    case 128: {
                        len_first = 2;
                        break;
                    }
                    case 192: {
                        len_first = 3;
                        switch (opc_qua & 0xFC) {
                            case 192: {
                                len_second_3 = 0;
                                break block0;
                            }
                            case 216: {
                                len_second_3 = 2;
                                break block0;
                            }
                        }
                        len_second_3 = 3;
                        break;
                    }
                }
                switch (opc_qua & 3) {
                    case 0: {
                        len_thrid = 0;
                        break;
                    }
                    case 1: {
                        len_thrid = 1;
                        break;
                    }
                    case 2: {
                        len_thrid = 2;
                        break;
                    }
                    case 3: {
                        len_thrid = 3;
                        break;
                    }
                }
                pointer_de = "OPC:";
                pointer_de = len_first >= 0 && len_first < 4 ? pointer_de + first[len_first] : pointer_de + "N/A";
                if (len_second_1 >= 0 && len_second_1 < 10) {
                    pointer_de = pointer_de + ",";
                    pointer_de = pointer_de + second_one[len_second_1];
                } else if (len_second_2 >= 0 && len_second_2 < 7) {
                    pointer_de = pointer_de + ",";
                    pointer_de = pointer_de + second_two[len_second_2];
                } else if (len_second_3 >= 0 && len_second_3 < 4) {
                    pointer_de = pointer_de + ",";
                    pointer_de = pointer_de + second_three[len_second_3];
                } else {
                    pointer_de = pointer_de + ",";
                    pointer_de = pointer_de + "N/A";
                }
                if (len_thrid >= 0 && len_thrid < 4) {
                    pointer_de = pointer_de + ",";
                    pointer_de = pointer_de + third[len_thrid];
                } else {
                    pointer_de = pointer_de + ",";
                    pointer_de = pointer_de + "N/A";
                }
                definitions.add(pointer_de);
                continue;
            }
            if ((qualities[i] & Short.MAX_VALUE) < 256 && (qualities[i] & Short.MAX_VALUE) >= 0) {
                pointer_de = "DB:";
                switch (qualities[i] & Short.MAX_VALUE) {
                    case 0: {
                        pointer_de = pointer_de + "GOOD";
                        break;
                    }
                    case 1: {
                        pointer_de = pointer_de + "NODATA";
                        break;
                    }
                    case 2: {
                        pointer_de = pointer_de + "CREATED";
                        break;
                    }
                    case 3: {
                        pointer_de = pointer_de + "SHUTDOWN";
                        break;
                    }
                    case 4: {
                        pointer_de = pointer_de + "CALCOFF";
                        break;
                    }
                    case 5: {
                        pointer_de = pointer_de + "BAD";
                        break;
                    }
                    case 6: {
                        pointer_de = pointer_de + "DIVBYZERO";
                        break;
                    }
                    case 7: {
                        pointer_de = pointer_de + "REMOVED";
                        break;
                    }
                    default: {
                        pointer_de = pointer_de + "N/A";
                    }
                }
                definitions.add(pointer_de);
                continue;
            }
            if ((qualities[i] & Short.MAX_VALUE) < 512) continue;
            pointer_de = "User:N/A";
            definitions.add(pointer_de);
        }
        return definitions;
    }

    @Override
    public String getApiVersion() {
        return version;
    }

    @Override
    public void namedTypeCallback(RBNamedTypeCreate callback) throws IOException, CrcErrorException, InvalidHeaderException, DecodePacketErrorException, UnexpectedMethodException, Exception {
        this.setMethod(RtdbMsgID.MSG_SUBSCRIBE_NAMED_TYPE_CREATE_CALLBACK);
        while (this.getThread() != null && !this.getThread().isInterrupted()) {
            RtdbError ret;
            String name = "";
            NamedDataTypeField[] fds = null;
            List<RtdbField> fields = protol.msgSubscribeNamedTypeCreateCallBackFields(0, name, 0, fds);
            this.receivePacketHeader(fields);
            int count = this.getCount(fields);
            if (count < 0 || (ret = this.getRet(fields)) == RtdbError.GoE_OK) continue;
            throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
        }
    }

    @Override
    public void namedTypeCreateSubscribe(RBNamedTypeCreate callback) {
        CallbackProcArgs args = new CallbackProcArgs();
        args.setRtdbServer(this);
        args.setCreateNamedTypeCallback(callback);
        NamedTypeCallbackProc namedTypeCallbackProc = new NamedTypeCallbackProc(args);
        Thread thread = new Thread(namedTypeCallbackProc);
        this.setThread(thread);
        thread.setDaemon(false);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lockUser(String user, boolean lock) throws NoAuthorityException, Exception {
        if (!version.equals(version)) {
            throw new Exception("\u59dd\u3086\u669f\u93b9\ue1bc\u7c31\u9417\u581f\u6e70\u6d93\u5d86\u656e\u93b8\u4f79\ue11d\u93c2\u89c4\u7876");
        }
        boolean falg = false;
        if (user == null || user.equals("")) {
            throw new InvalidParameterException();
        }
        String userTrim = user.trim();
        user = this.subString(userTrim, 19);
        RtdbServerImpl rtdbServerImpl = this;
        synchronized (rtdbServerImpl) {
            if (!this.apiPre(this, RtdbMsgID.MSG_LOCK_USER, this.getLogin())) {
                throw new NoAuthorityException();
            }
            List<RtdbField> wfield = protol.msgChangeUSerStata(user, lock);
            this.sendPacket(wfield, false);
            List<RtdbField> rFields = protol.msgChangeUSerStataRespFields(0);
            this.receivePacket(rFields, true);
            RtdbError ret = this.getRet(rFields);
            if (ret != RtdbError.GoE_OK) {
                throw new RtdbExecuteErrorException(Integer.toHexString(ret.getErrcode()), ret.getErrmsg());
            }
            falg = true;
        }
        return falg;
    }

    @Override
    public int getLock() {
        return this.lock.get();
    }

    @Override
    public void lock() {
        this.lock.incrementAndGet();
    }

    @Override
    public void unlock() {
        if (this.lock.get() > 0) {
            this.lock.decrementAndGet();
        }
    }

    static {
        log = LogFactory.getLog(RtdbServerImpl.class);
        protol = version.equals(version) ? ServerProtocol30.getInstance() : ServerProtocol21.getInstance();
    }
}

