/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.api.inter;

import com.rtdb.api.enums.HisMode;
import com.rtdb.api.enums.RtdbType;
import com.rtdb.api.exception.DataTypeNotMatchException;
import com.rtdb.api.exception.EncodePacketErrorException;
import com.rtdb.api.exception.InvalidParameterException;
import com.rtdb.api.exception.NoAuthorityException;
import com.rtdb.api.exception.UnexpectedMethodException;
import com.rtdb.api.model.RtdbBlobData;
import com.rtdb.api.model.RtdbCoorData;
import com.rtdb.api.model.RtdbData;
import com.rtdb.api.model.RtdbDatetimeData;
import com.rtdb.api.model.RtdbNamedTypeData;
import com.rtdb.api.model.RtdbSummaryData;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;

public interface IHistorian {
    public int getArchivedValuesCount(int var1, Object var2, Object var3) throws IOException, ParseException, EncodePacketErrorException, UnexpectedMethodException, Exception;

    public RtdbData getSingleValue(int var1, RtdbType var2, Object var3, HisMode var4) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception;

    public RtdbCoorData getSingleCoorValue(int var1, Object var2, HisMode var3) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception;

    public RtdbBlobData getSingleBlobValue(int var1, Object var2, HisMode var3, short var4) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception;

    public RtdbData[] getArchivedValues(int var1, int var2, RtdbType var3, Object var4, Object var5) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception;

    public RtdbData[] getArchivedValuesBackward(int var1, int var2, RtdbType var3, Object var4, Object var5) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception;

    public RtdbCoorData[] getArchivedCoorValues(int var1, int var2, Object var3, Object var4) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception;

    public RtdbCoorData[] getArchivedCoorValuesBackward(int var1, int var2, Object var3, Object var4) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception;

    public int getArchivedValuesBatchCount(int var1, Object var2, Object var3) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception;

    public RtdbData[] getNextArchivedValues(int var1, int var2, RtdbType var3) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception;

    public RtdbData[] getTimedValues(int var1, RtdbType var2, int var3, Object[] var4) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception;

    public RtdbCoorData[] getTimedCoorValues(int var1, Object[] var2) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception;

    public RtdbSummaryData getSummary(int var1, Object var2, Object var3) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception;

    public RtdbSummaryData[] getSummaryInBatches(int var1, int var2, long var3, Object var5, Object var6) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception;

    public RtdbData[] getPlotValues(int var1, RtdbType var2, int var3, int var4, Object var5, Object var6) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception;

    public int getCrossSectionValues(RtdbData[] var1, HisMode var2, RtdbType var3) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception;

    public RtdbData[] getArchivedValuesFilt(int var1, RtdbType var2, String var3, int var4, Object var5, Object var6) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception;

    public RtdbSummaryData getSummaryFilt(int var1, String var2, Object var3, Object var4) throws InvalidParameterException, NoAuthorityException, ParseException, UnsupportedEncodingException, IOException, EncodePacketErrorException, Exception;

    public RtdbSummaryData[] getSummaryFiltInBatches(int var1, String var2, int var3, long var4, Object var6, Object var7) throws InvalidParameterException, NoAuthorityException, UnsupportedEncodingException, ParseException, IOException, EncodePacketErrorException, Exception;

    public int updateValue(int var1, RtdbType var2, RtdbData var3) throws ParseException, InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception;

    public int updateCoorValue(int var1, RtdbCoorData var2) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception;

    public int removeValue(int var1, Date var2) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, UnexpectedMethodException, Exception;

    public int removeValues(int var1, Object var2, Object var3) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception;

    public int putSingleValue(RtdbData var1, RtdbType var2) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception;

    public int putSingleCoorValue(RtdbCoorData var1) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception;

    public int putSingleBlobValue(RtdbBlobData var1) throws ParseException, InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception;

    public int putArchivedValues(RtdbData[] var1) throws UnknownHostException, IOException, DataTypeNotMatchException, InvalidParameterException, NoAuthorityException, ParseException, UnknownHostException, IOException, DataTypeNotMatchException, EncodePacketErrorException, Exception;

    public int putArchivedCoorValues(RtdbCoorData[] var1) throws ParseException, InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception;

    public int flushArchivedValues(int var1) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception;

    public RtdbData[] getIntervalValues(int var1, RtdbType var2, long var3, int var5, Object var6) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception;

    public RtdbData[] getInterpoValues(int var1, RtdbType var2, int var3, Object var4, Object var5) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception;

    public int getArchivedBlobValues(int var1, int var2, Object var3, Object var4, byte[][] var5, Date[] var6, int[] var7, short[] var8, short[] var9) throws InvalidParameterException, NoAuthorityException, ParseException, Exception;

    public RtdbDatetimeData getSingleDatetimeValue(int var1, Object var2, HisMode var3) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception;

    public int putSingleDatetimeValue(RtdbDatetimeData var1) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception;

    public RtdbDatetimeData[] getArchivedDatetimeValues(int var1, Object var2, Object var3, int var4) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception;

    public int putArchivedDatetimeValues(RtdbDatetimeData[] var1) throws InvalidParameterException, NoAuthorityException, ParseException, Exception;

    public int archivedValuesRealCount(int var1, Object var2, Object var3) throws NoAuthorityException, Exception;

    public RtdbSummaryData getSummaryEx(int var1, Date var2, Date var3) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception;

    public RtdbSummaryData getSummaryFiltEx(int var1, String var2, Date var3, Date var4) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception;

    public List<RtdbData> getNextArchivedValues(int var1, int var2) throws InvalidParameterException, NoAuthorityException, Exception;

    public List<RtdbData> getNextArchivedValues_ns(int var1, int var2) throws InvalidParameterException, NoAuthorityException, Exception;

    public int getArchivedValuesInBatch(int var1, Object var2, Object var3) throws NoAuthorityException, Exception;

    public RtdbData[] getTimedValues(int var1, int var2, Object[] var3) throws NoAuthorityException, Exception;

    public RtdbData[] getPlotValues(int var1, int var2, int var3, Object var4, Object var5) throws NoAuthorityException, Exception;

    public List<RtdbData> getCrossSectionValues(int[] var1, HisMode var2, int var3, Object var4) throws NoAuthorityException, Exception;

    public List<RtdbData> getArchivedValuesFilt(int var1, String var2, int var3, Object var4, Object var5) throws InvalidParameterException, NoAuthorityException, Exception;

    public List<RtdbData> getArchivedValues(int var1, int var2, Object var3, Object var4) throws NoAuthorityException, Exception;

    public RtdbNamedTypeData getSingleNamedTypeValue(int var1, Object var2, HisMode var3, short var4) throws NoAuthorityException, Exception;

    public int putSingleNamedTypeValue(RtdbNamedTypeData var1) throws NoAuthorityException, Exception;

    public RtdbNamedTypeData[] getArchivedNamedTypeValues(int var1, Object var2, Object var3, int var4, short var5) throws NoAuthorityException, Exception;

    public int putArchivedNamedTypeValues(RtdbNamedTypeData[] var1) throws NoAuthorityException, Exception;

    public int archivedValuesCount(int var1, Object var2, Object var3) throws NoAuthorityException, Exception;

    public int updateValue(RtdbData var1) throws NoAuthorityException, Exception;

    public int putArchivedBlobValues(int var1, int[] var2, Object[] var3, byte[][] var4, short[] var5, int[] var6) throws InvalidParameterException, NoAuthorityException, Exception;
}

