/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.api.model;

import com.rtdb.api.model.MemoryStream;
import com.rtdb.api.util.BytesConvert;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class RtdbScanPoint
implements Serializable {
    private static final long serialVersionUID = 2352760070848323177L;
    int id;
    String source = "";
    byte scan;
    String instrument = "";
    int[] location = new int[5];
    int[] userints = new int[2];
    float[] userreals = new float[2];
    byte[] padding = new byte[164];

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public byte getScan() {
        return this.scan;
    }

    public void setScan(byte scan) {
        this.scan = scan;
    }

    public String getInstrument() {
        return this.instrument;
    }

    public void setInstrument(String instrument) {
        this.instrument = instrument;
    }

    public int[] getLocation() {
        return this.location;
    }

    public void setLocation(int[] location) {
        this.location = location;
    }

    public int[] getUserints() {
        return this.userints;
    }

    public void setUserints(int[] userints) {
        this.userints = userints;
    }

    public float[] getUserreals() {
        return this.userreals;
    }

    public void setUserreals(float[] userreals) {
        this.userreals = userreals;
    }

    public byte[] getPadding() {
        return this.padding;
    }

    public void setPadding(byte[] padding) {
        this.padding = padding;
    }

    public static RtdbScanPoint bytesToScanPoint(byte[] bytes) throws UnsupportedEncodingException {
        RtdbScanPoint scan = new RtdbScanPoint();
        MemoryStream stream = new MemoryStream(bytes);
        if (bytes.length <= 0) {
            return null;
        }
        scan.setId(stream.readInt());
        scan.setSource(stream.readString(256));
        scan.setScan(stream.readByte());
        scan.setInstrument(stream.readString(51));
        scan.setLocation(stream.readIntArray(5));
        scan.setUserints(stream.readIntArray(2));
        scan.setUserreals(stream.readFloatArray(2));
        return scan;
    }

    public static byte[] scanPointToByte(RtdbScanPoint point) throws UnsupportedEncodingException, IOException {
        MemoryStream stream = new MemoryStream();
        if (point != null) {
            stream.writeInt(point.getId());
            String source2 = point.getSource();
            stream.writeBytes(source2.getBytes());
            int nums = 255 - source2.getBytes().length + 1;
            stream.writeBytes(BytesConvert.fillBytes(nums));
            byte num = point.getScan();
            byte b = num;
            stream.writeByte(b);
            String instrument2 = point.getInstrument();
            stream.writeString(instrument2);
            int Instrument = 50 - instrument2.length();
            stream.writeBytes(BytesConvert.fillBytes(Instrument));
            int[] location2 = point.getLocation();
            int[] ar = new int[5];
            try {
                System.arraycopy(location2, 0, ar, 0, location2.length);
            }
            catch (IndexOutOfBoundsException i) {
                throw new IndexOutOfBoundsException("\u7481\u60e7\ue62c\u6d63\u5d85\u6f43\u7481\u5267\u7586\u93c8\u590e\ue1e4\u951b\ufffd1-5\u6d93\ue047\ue195\u6fb6\u56e6\u7d85\u9367\ufffd\u951b\ufffd");
            }
            stream.writeIntArray(ar);
            int[] userints2 = point.getUserints();
            int[] ar1 = new int[2];
            try {
                System.arraycopy(userints2, 0, ar1, 0, userints2.length);
            }
            catch (IndexOutOfBoundsException i) {
                throw new IndexOutOfBoundsException("\u9477\ue044\u757e\u6d94\u590b\u66a3\u93c1\u62cc\ue195\u7f03\ue1bd\u6e41\u7487\ue224\u7d191-2\u6d93\ue043\u7d85\u9367\ufffd\u951b\ufffd");
            }
            stream.writeIntArray(ar1);
            float[] userrels = point.getUserreals();
            float[] ar2 = new float[2];
            try {
                System.arraycopy(userrels, 0, ar2, 0, userrels.length);
            }
            catch (IndexOutOfBoundsException i) {
                throw new IndexOutOfBoundsException("\u9477\ue044\u757e\u6d94\u590b\u8bde\u9410\u89c4\u669f\u7481\u5267\u7586\u93c8\u590e\ue1e4\u951b\ufffd1-2\u6d93\ue043\u7d85\u9367\ufffd\u951b\ufffd");
            }
            stream.writeFloatArray(ar2);
        }
        byte[] bytes = stream.toByteArray();
        return bytes;
    }
}

