/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.api.util;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtil {
    public static Date stringToDate(String strDate, String pattern) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        return df.parse(strDate);
    }

    public static Date stringToDate(String strDate) throws ParseException {
        SimpleDateFormat df = null;
        Date date = null;
        try {
            df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            date = df.parse(strDate);
        }
        catch (ParseException e) {
            df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            date = df.parse(strDate);
        }
        return date;
    }

    public static String dateToString(Date date, String pattern) {
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        return df.format(date);
    }

    public static String dateToString(Date date) {
        String pattern = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat df = new SimpleDateFormat(pattern);
        return df.format(date);
    }

    public static int getGMTSecond(Date date) throws ParseException {
        return (int)(DateUtil.getGMTDateTime(date).getTime() / 1000L);
    }

    public static int getSecond(Date date) throws ParseException {
        return (int)(date.getTime() / 1000L);
    }

    public static Date getGMTDateTime(Date date) {
        DateFormat dateFormat = DateFormat.getDateInstance();
        int offset = dateFormat.getTimeZone().getOffset(date.getTime());
        date = new Date(date.getTime() - (long)offset);
        return date;
    }

    public static short getMilSecond(Date datetime) throws ParseException {
        return (short)(datetime.getTime() % 1000L);
    }

    public static int[] getGMTSecond(Date[] datetimes) throws ParseException {
        int count = datetimes.length;
        int[] datetime_temp = new int[count];
        for (int i = 0; i < count; ++i) {
            datetime_temp[i] = (int)(DateUtil.getGMTDateTime(datetimes[i]).getTime() / 1000L);
        }
        return datetime_temp;
    }

    public static int[] getSecond(Date[] datetimes) throws ParseException {
        int count = datetimes.length;
        int[] datetime_temp = new int[count];
        for (int i = 0; i < count; ++i) {
            datetime_temp[i] = (int)(datetimes[i].getTime() / 1000L);
        }
        return datetime_temp;
    }

    public static int[] getMilSecond(Date[] datetimes) throws ParseException {
        int count = datetimes.length;
        int[] datetime_temp = new int[count];
        for (int i = 0; i < count; ++i) {
            datetime_temp[i] = (short)(datetimes[i].getTime() % 1000L);
        }
        return datetime_temp;
    }

    public static void getDate(Date[] datetimes, int[] datetimes_seconds, int[] mil_seconds) throws ParseException {
        long temp = 0L;
        int count = datetimes.length;
        for (int i = 0; i < count; ++i) {
            temp = (long)datetimes_seconds[i] * 1000L;
            datetimes[i] = new Date(temp + (long)mil_seconds[i]);
        }
    }

    public static void getDate(Date[] datetimes, int[] datetimes_seconds) throws ParseException {
        long temp = 0L;
        int count = datetimes.length;
        for (int i = 0; i < count; ++i) {
            temp = (long)datetimes_seconds[i] * 1000L;
            datetimes[i] = new Date(temp + 0L);
        }
    }

    public static void getDate(String[] datetimes, int[] datetimes_seconds) throws ParseException {
        if (datetimes.length <= 0) {
            return;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int offset = format.getTimeZone().getOffset(new Date().getTime()) / 1000;
        Date dateConst = format.parse("1970-1-1 0:0:0");
        for (int i = 0; i < datetimes.length; ++i) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(dateConst);
            calendar.add(13, datetimes_seconds[i] + offset);
            datetimes[i] = format.format(calendar.getTime());
        }
    }

    public static Date getDate(int datetime_second, int mil_second) {
        long temp = (long)datetime_second * 1000L + (long)mil_second;
        return new Date(temp);
    }

    public static String TimeStampDate(int timestampstring) {
        Long timestamp = (long)timestampstring * 1000L;
        String date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(timestamp));
        return date;
    }

    public static String getGMTTime(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SS");
        String strDate = format.format(date.getTime());
        return strDate;
    }

    public static String getGMTTime(Long millis) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SS");
        String strDate = format.format(millis);
        return strDate;
    }
}

