/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.service.impl;

import com.rtdb.api.enums.HisMode;
import com.rtdb.api.enums.RTDBClass;
import com.rtdb.api.enums.RtdbType;
import com.rtdb.api.exception.DataTypeNotMatchException;
import com.rtdb.api.exception.EncodePacketErrorException;
import com.rtdb.api.exception.InvalidParameterException;
import com.rtdb.api.exception.NoAuthorityException;
import com.rtdb.api.exception.UnexpectedMethodException;
import com.rtdb.api.impl.RtdbBaseImpl;
import com.rtdb.api.impl.RtdbHistorianImpl;
import com.rtdb.api.inter.IBase;
import com.rtdb.api.inter.IHistorian;
import com.rtdb.api.model.DateTimeNS;
import com.rtdb.api.model.RtdbBlobData;
import com.rtdb.api.model.RtdbCoorData;
import com.rtdb.api.model.RtdbData;
import com.rtdb.api.model.RtdbDatetimeData;
import com.rtdb.api.model.RtdbNamedTypeData;
import com.rtdb.api.model.RtdbSummaryData;
import com.rtdb.api.util.BytesConvertUtil;
import com.rtdb.api.util.DateUtil;
import com.rtdb.enums.Quality;
import com.rtdb.enums.RtdbHisMode;
import com.rtdb.model.BlobData;
import com.rtdb.model.CoorData;
import com.rtdb.model.DatetimeData;
import com.rtdb.model.DoubleData;
import com.rtdb.model.IntData;
import com.rtdb.model.NamedTypeData;
import com.rtdb.model.StringData;
import com.rtdb.model.SummaryEntity;
import com.rtdb.service.impl.ServerImpl;
import com.rtdb.service.inter.Historian;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class HistorianImpl
implements Historian {
    private ServerImpl server;
    private IHistorian gh;
    private IBase bs;
    private int unValidateYear = 1970;

    public HistorianImpl(ServerImpl server) throws UnknownHostException, IOException, Exception {
        this.server = server;
        this.gh = new RtdbHistorianImpl(server);
        this.bs = new RtdbBaseImpl(server);
    }

    @Override
    public void close() throws IOException, InterruptedException {
        this.server.close();
    }

    @Override
    public int getArchivedValuesCount(int id, Object startTime, Object endTime) throws IOException, ParseException, EncodePacketErrorException, UnexpectedMethodException, Exception {
        return this.gh.getArchivedValuesCount(id, startTime, endTime);
    }

    @Override
    public List<IntData> getIntArchivedValues(int id, int count, Object startTime, Object endTime) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        ArrayList<IntData> list = new ArrayList<IntData>(count);
        RtdbData[] data = this.gh.getArchivedValues(id, count, RtdbType.RTDB_INT32, startTime, endTime);
        IntData intData = null;
        Calendar cld = Calendar.getInstance();
        for (int i = 0; i < data.length; ++i) {
            cld.setTime(data[i].getDate());
            if (this.unValidateYear == cld.get(1)) continue;
            intData = new IntData();
            intData.setId(data[i].getId());
            intData.setValue(((Long)data[i].getValue()).longValue());
            intData.setDateTime(data[i].getDate());
            intData.setQuality(data[i].getQuality());
            intData.setNanosecond(data[i].getNanosecond());
            list.add(intData);
        }
        return list;
    }

    @Override
    public List<DoubleData> getDoubleArchivedValues(int id, int count, Object startTime, Object endTime) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        ArrayList<DoubleData> list = null;
        RtdbData[] data = this.gh.getArchivedValues(id, count, RtdbType.RTDB_REAL64, startTime, endTime);
        DoubleData doubleData = null;
        Calendar cld = Calendar.getInstance();
        if (data.length > 0) {
            list = new ArrayList<DoubleData>(count);
        }
        for (int i = 0; i < data.length; ++i) {
            cld.setTime(data[i].getDate());
            if (this.unValidateYear == cld.get(1)) continue;
            doubleData = new DoubleData();
            doubleData.setId(id);
            doubleData.setValue((Double)data[i].getValue());
            doubleData.setDateTime(data[i].getDate());
            doubleData.setQuality(data[i].getQuality());
            doubleData.setNanosecond(data[i].getNanosecond());
            list.add(doubleData);
        }
        return list;
    }

    @Override
    public List<CoorData> getCoorArchivedValues(int id, int count, Object startTime, Object endTime) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        ArrayList<CoorData> list = new ArrayList<CoorData>(count);
        RtdbCoorData[] data = this.gh.getArchivedCoorValues(id, count, startTime, endTime);
        CoorData coorData = null;
        Calendar cld = Calendar.getInstance();
        for (int i = 0; i < data.length; ++i) {
            cld.setTime(data[i].getDate());
            if (this.unValidateYear == cld.get(1)) continue;
            coorData = new CoorData();
            coorData.setId(id);
            coorData.setX(data[i].getX());
            coorData.setY(data[i].getY());
            coorData.setDateTime(data[i].getDate());
            coorData.setQuality(data[i].getQuality().getNum());
            coorData.setNanosecond(data[i].getNanosecond());
            list.add(coorData);
        }
        return list;
    }

    @Override
    public IntData getIntSingleValue(int id, Object dateTime, RtdbHisMode rtdbHisMode) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        RtdbData data = this.gh.getSingleValue(id, RtdbType.RTDB_INT32, dateTime, HisMode.parse(rtdbHisMode.getNum()));
        return new IntData(data.getDate(), (Long)data.getValue(), data.getQuality(), data.getError(), data.getNanosecond());
    }

    @Override
    public DoubleData getFloatSingleValue(int id, Object dateTime, RtdbHisMode rtdbHisMode) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        RtdbData data = this.gh.getSingleValue(id, RtdbType.RTDB_REAL64, dateTime, HisMode.parse(rtdbHisMode.getNum()));
        DoubleData doubleData = new DoubleData();
        doubleData.setDateTime(data.getDate());
        doubleData.setId(id);
        doubleData.setQuality(data.getQuality());
        doubleData.setError(data.getError());
        doubleData.setValue((Double)data.getValue());
        doubleData.setNanosecond(data.getNanosecond());
        return doubleData;
    }

    @Override
    public BlobData getBlobSingleValue(int id, Object dateTime, RtdbHisMode rtdbHisMode) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        RtdbBlobData data = this.gh.getSingleBlobValue(id, dateTime, HisMode.parse(rtdbHisMode.getNum()), (short)4096);
        BlobData blobData = new BlobData();
        blobData.setId(id);
        blobData.setLen(data.getLen());
        blobData.setBlob(data.getBlob());
        blobData.setDatetime(data.getDatetime());
        blobData.setQuality(Quality.getQuality(data.getQuality().getNum()));
        blobData.setNanosecond(data.getNanosecond());
        return blobData;
    }

    @Override
    public List<IntData> getIntNextArchivedValues(int id, int count) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        ArrayList<IntData> list = new ArrayList<IntData>(count);
        RtdbData[] data = this.gh.getNextArchivedValues(id, count, RtdbType.RTDB_INT64);
        IntData intData = null;
        for (RtdbData rtdbData : data) {
            intData = new IntData();
            intData.setId(id);
            intData.setValue(((Long)rtdbData.getValue()).longValue());
            intData.setDateTime(rtdbData.getDate());
            intData.setQuality(rtdbData.getQuality());
            intData.setNanosecond(rtdbData.getNanosecond());
            list.add(intData);
        }
        return list;
    }

    @Override
    public int getArchivedValuesInBatch(int id, Object datetime1, Object datetime2) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        return this.gh.getArchivedValuesInBatch(id, datetime1, datetime2);
    }

    @Override
    public List<RtdbData> getNextArchivedValues(int id, int count) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        return this.gh.getNextArchivedValues(id, count);
    }

    @Override
    public List<RtdbData> getNextArchivedValues_ns(int id, int count) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        return this.gh.getNextArchivedValues_ns(id, count);
    }

    @Override
    public List<DoubleData> getFloatNextArchivedValues(int id, int count) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        RtdbData[] data = this.gh.getNextArchivedValues(id, count, RtdbType.RTDB_REAL64);
        ArrayList<DoubleData> list = new ArrayList<DoubleData>(count > 0 ? count : 10);
        DoubleData doubleData = null;
        for (RtdbData rtdbData : data) {
            doubleData = new DoubleData();
            doubleData.setId(id);
            doubleData.setValue((Double)rtdbData.getValue());
            doubleData.setDateTime(rtdbData.getDate());
            doubleData.setQuality(rtdbData.getQuality());
            doubleData.setNanosecond(rtdbData.getNanosecond());
            list.add(doubleData);
        }
        return list;
    }

    @Override
    public List<IntData> getIntTimedValues(int id, int count, Object[] datetimes) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        ArrayList<IntData> list = new ArrayList<IntData>(count);
        RtdbData[] data = this.gh.getTimedValues(id, RtdbType.RTDB_INT64, count, datetimes);
        IntData intData = null;
        for (int i = 0; i < data.length; ++i) {
            intData = new IntData();
            intData.setId(id);
            Object value = data[i].getState();
            intData.setValue(((Long)value).longValue());
            intData.setDateTime(data[i].getDate());
            intData.setQuality(data[i].getQuality());
            intData.setNanosecond(data[i].getNanosecond());
            long state = (Long)data[i].getState();
            intData.setState(state);
            list.add(intData);
        }
        return list;
    }

    @Override
    public List<DoubleData> getFloatTimedValues(int id, int count, Object[] datetimes) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        ArrayList<DoubleData> list = new ArrayList<DoubleData>(count);
        RtdbData[] data = this.gh.getTimedValues(id, RtdbType.RTDB_REAL64, count, datetimes);
        DoubleData doubleData = null;
        for (int i = 0; i < data.length; ++i) {
            doubleData = new DoubleData();
            doubleData.setId(id);
            doubleData.setValue((Double)data[i].getValue());
            doubleData.setDateTime(data[i].getDate());
            doubleData.setQuality(data[i].getQuality());
            doubleData.setNanosecond(data[i].getNanosecond());
            list.add(doubleData);
        }
        return list;
    }

    @Override
    public RtdbData[] getTimedValues(int id, Object[] datetimes) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        int count = datetimes.length;
        return this.gh.getTimedValues(id, count, datetimes);
    }

    @Override
    public List<CoorData> getCoorTimedValues(int id, int count, Object[] datetimes) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        ArrayList<CoorData> list = new ArrayList<CoorData>(count);
        RtdbCoorData[] data = this.gh.getTimedCoorValues(id, datetimes);
        CoorData coorData = null;
        for (int i = 0; i < data.length; ++i) {
            coorData = new CoorData();
            coorData.setId(id);
            coorData.setX(data[i].getX());
            coorData.setY(data[i].getY());
            if (datetimes[i].getClass().equals(Date.class)) {
                coorData.setDateTime((Date)datetimes[i]);
            } else if (datetimes[i].getClass().equals(DateTimeNS.class)) {
                coorData.setDateTime(((DateTimeNS)datetimes[i]).getDatetime());
            }
            coorData.setQuality(data[i].getQuality().getNum());
            coorData.setNanosecond(data[i].getNanosecond());
            list.add(coorData);
        }
        return list;
    }

    @Override
    public CoorData getCoorSingleValue(int id, Object dateTime, RtdbHisMode rtdbHisMode) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        RtdbCoorData data = this.gh.getSingleCoorValue(id, dateTime, HisMode.parse(rtdbHisMode.getNum()));
        CoorData coorData = new CoorData();
        coorData.setId(id);
        coorData.setX(data.getX());
        coorData.setY(data.getY());
        coorData.setDateTime(data.getDate());
        coorData.setQuality(data.getQuality().getNum());
        coorData.setNanosecond(data.getNanosecond());
        return coorData;
    }

    @Override
    public List<IntData> getIntInterpoValues(int id, int count, Object startTime, Object endTime) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        ArrayList<IntData> list = new ArrayList<IntData>(count);
        RtdbData[] data = this.gh.getInterpoValues(id, RtdbType.RTDB_INT32, count, startTime, endTime);
        IntData intData = null;
        for (int i = 0; i < data.length; ++i) {
            intData = new IntData();
            intData.setId(id);
            intData.setValue(((Long)data[i].getValue()).longValue());
            intData.setDateTime(data[i].getDate());
            intData.setQuality(data[i].getQuality());
            intData.setNanosecond(data[i].getNanosecond());
            list.add(intData);
        }
        return list;
    }

    @Override
    public List<DoubleData> getFloatInterpoValues(int id, int count, Object startTime, Object endTime) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        ArrayList<DoubleData> list = new ArrayList<DoubleData>(count);
        RtdbData[] data = this.gh.getInterpoValues(id, RtdbType.RTDB_REAL64, count, startTime, endTime);
        DoubleData doubleData = null;
        for (int i = 0; i < data.length; ++i) {
            doubleData = new DoubleData();
            doubleData.setId(id);
            doubleData.setValue((Double)data[i].getValue());
            doubleData.setDateTime(data[i].getDate());
            doubleData.setQuality(data[i].getQuality());
            doubleData.setNanosecond(data[i].getNanosecond());
            list.add(doubleData);
        }
        return list;
    }

    @Override
    public List<IntData> getIntIntervalValues(int id, long interval, int count, Object dateTime) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        ArrayList<IntData> list = new ArrayList<IntData>(count);
        RtdbData[] data = this.gh.getIntervalValues(id, RtdbType.RTDB_INT32, interval, count, dateTime);
        IntData intData = null;
        for (int i = 0; i < data.length; ++i) {
            intData = new IntData();
            intData.setId(id);
            intData.setValue(((Long)data[i].getValue()).longValue());
            intData.setDateTime(data[i].getDate());
            intData.setQuality(data[i].getQuality());
            intData.setNanosecond(data[i].getNanosecond());
            list.add(intData);
        }
        return list;
    }

    @Override
    public List<DoubleData> getFloatIntervalValues(int id, long interval, int count, Object dateTime) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        ArrayList<DoubleData> list = new ArrayList<DoubleData>(count);
        RtdbData[] data = this.gh.getIntervalValues(id, RtdbType.RTDB_REAL64, interval, count, dateTime);
        DoubleData doubleData = null;
        for (int i = 0; i < data.length; ++i) {
            doubleData = new DoubleData();
            doubleData.setId(id);
            doubleData.setValue((Double)data[i].getValue());
            doubleData.setDateTime(data[i].getDate());
            doubleData.setQuality(data[i].getQuality());
            doubleData.setNanosecond(data[i].getNanosecond());
            list.add(doubleData);
        }
        return list;
    }

    @Override
    public SummaryEntity getNumberSummaryEx(int id, Object startTime, Object endTime) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        SummaryEntity se = new SummaryEntity();
        RtdbSummaryData data = this.gh.getSummary(id, startTime, endTime);
        se.setMaxValueTime(data.getMaxValueTime());
        se.setMinValueTime(data.getMinValueTime());
        se.setMaxValue(data.getMaxValue());
        se.setMinValue(data.getMinValue());
        se.setTotalValue(data.getTotalValue());
        se.setCalcAvg(data.getCalcAvg());
        se.setPowerAvg(data.getPowerAvg());
        se.setCount(data.getCount());
        se.setMaxValueNanosecond(data.getMaxValueNanosecond());
        se.setMinValueNanosecond(data.getMinValueNanosecond());
        return se;
    }

    @Override
    public SummaryEntity getNumberSummary(int id, Object startTime, Object endTime) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        SummaryEntity se = new SummaryEntity();
        RtdbSummaryData data = this.gh.getSummary(id, startTime, endTime);
        se.setMaxValueTime(data.getMaxValueTime());
        se.setMinValueTime(data.getMinValueTime());
        se.setMaxValue(data.getMaxValue());
        se.setMinValue(data.getMinValue());
        se.setTotalValue(data.getTotalValue());
        se.setCalcAvg(data.getCalcAvg());
        se.setPowerAvg(data.getPowerAvg());
        se.setMaxValueNanosecond(data.getMaxValueNanosecond());
        se.setMinValueNanosecond(data.getMinValueNanosecond());
        return se;
    }

    @Override
    public List<SummaryEntity> getNumberSummaryInBatches(int id, int count, long interval, Object startTime, Object endTime) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        ArrayList<SummaryEntity> list = new ArrayList<SummaryEntity>(count);
        RtdbSummaryData[] data = this.gh.getSummaryInBatches(id, count, interval, startTime, endTime);
        SummaryEntity se = null;
        for (int i = 0; i < data.length; ++i) {
            se = new SummaryEntity();
            se.setMaxValueTime(data[i].getMaxValueTime());
            se.setMinValueTime(data[i].getMinValueTime());
            se.setMaxValue(data[i].getMaxValue());
            se.setMinValue(data[i].getMinValue());
            se.setTotalValue(data[i].getTotalValue());
            se.setCalcAvg(data[i].getCalcAvg());
            se.setPowerAvg(data[i].getPowerAvg());
            se.setErrors(data[i].getErrors());
            se.setMaxValueNanosecond(data[i].getMaxValueNanosecond());
            se.setMinValueNanosecond(data[i].getMinValueNanosecond());
            list.add(se);
        }
        return list;
    }

    @Override
    public List<IntData> getIntPlotValues(int id, int interval, int count, Object startTime, Object endTime) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        ArrayList<IntData> list = new ArrayList<IntData>(count);
        RtdbData[] data = this.gh.getPlotValues(id, RtdbType.RTDB_INT32, interval, count, startTime, endTime);
        IntData intData = null;
        for (int i = 0; i < data.length; ++i) {
            intData = new IntData();
            intData.setId(id);
            intData.setValue(((Long)data[i].getValue()).longValue());
            intData.setDateTime(data[i].getDate());
            intData.setQuality(data[i].getQuality());
            intData.setNanosecond(data[i].getNanosecond());
            list.add(intData);
        }
        return list;
    }

    @Override
    public List<DoubleData> getFloatPlotValues(int id, int interval, int count, Object startTime, Object endTime) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        ArrayList<DoubleData> list = new ArrayList<DoubleData>(count > 0 ? count : 10);
        RtdbData[] data = this.gh.getPlotValues(id, RtdbType.RTDB_REAL64, interval, count, startTime, endTime);
        DoubleData doubleData = null;
        for (int i = 0; i < data.length; ++i) {
            doubleData = new DoubleData();
            doubleData.setId(id);
            doubleData.setValue((Double)data[i].getValue());
            doubleData.setDateTime(data[i].getDate());
            doubleData.setQuality(data[i].getQuality());
            doubleData.setNanosecond(data[i].getNanosecond());
            list.add(doubleData);
        }
        return list;
    }

    @Override
    public RtdbData[] getPlotValues(int id, int interval, int count, Object startTime, Object endTime) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        return this.gh.getPlotValues(id, interval, count, startTime, endTime);
    }

    @Override
    public List<IntData> getIntCrossSectionValues(int[] ids, Object[] dateTimes, RtdbHisMode mode) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        ArrayList<IntData> list = new ArrayList<IntData>(ids.length);
        RtdbData[] dataArr = new RtdbData[ids.length];
        for (int i = 0; i < dateTimes.length; ++i) {
            RtdbData data = new RtdbData();
            data.setId(ids[i]);
            data.setDate(dateTimes[i]);
            dataArr[i] = data;
        }
        this.gh.getCrossSectionValues(dataArr, HisMode.parse(mode.getNum()), RtdbType.RTDB_INT32);
        IntData intData = null;
        for (int i = 0; i < dataArr.length; ++i) {
            intData = new IntData();
            intData.setId(ids[i]);
            intData.setValue(((Long)dataArr[i].getValue()).longValue());
            intData.setDateTime(dataArr[i].getDate());
            intData.setQuality(dataArr[i].getQuality());
            intData.setError(dataArr[i].getError());
            intData.setNanosecond(dataArr[i].getNanosecond());
            list.add(intData);
        }
        return list;
    }

    @Override
    public List<RtdbData> getCrossSectionValues(int[] ids, Object dateTime, RtdbHisMode mode) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        int count = ids.length;
        return this.gh.getCrossSectionValues(ids, HisMode.parse(mode.getNum()), count, dateTime);
    }

    @Override
    public List<DoubleData> getFloatCrossSectionValues(int[] ids, Object[] dateTimes, RtdbHisMode mode) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        ArrayList<DoubleData> list = new ArrayList<DoubleData>(ids.length);
        RtdbData[] dataArr = new RtdbData[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            RtdbData data = new RtdbData();
            data.setId(ids[i]);
            data.setDate(dateTimes[i]);
            dataArr[i] = data;
        }
        this.gh.getCrossSectionValues(dataArr, HisMode.parse(mode.getNum()), RtdbType.RTDB_REAL64);
        DoubleData doubleData = null;
        for (int i = 0; i < dataArr.length; ++i) {
            doubleData = new DoubleData();
            doubleData.setId(dataArr[i].getId());
            doubleData.setValue((Double)dataArr[i].getValue());
            doubleData.setDateTime(dataArr[i].getDate());
            doubleData.setQuality(dataArr[i].getQuality());
            doubleData.setError(dataArr[i].getError());
            doubleData.setNanosecond(dataArr[i].getNanosecond());
            list.add(doubleData);
        }
        return list;
    }

    @Override
    public List<IntData> getArchivedIntValuesFilt(int id, String filter, int count, Object startTime, Object endTime) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        ArrayList<IntData> list = new ArrayList<IntData>(count);
        RtdbData[] data = this.gh.getArchivedValuesFilt(id, RtdbType.RTDB_INT32, filter, count, startTime, endTime);
        IntData intData = null;
        for (int i = 0; i < data.length; ++i) {
            intData = new IntData();
            intData.setId(id);
            intData.setValue(((Long)data[i].getValue()).longValue());
            intData.setDateTime(data[i].getDate());
            intData.setQuality(data[i].getQuality());
            intData.setError(data[i].getError());
            intData.setNanosecond(data[i].getNanosecond());
            list.add(intData);
        }
        return list;
    }

    @Override
    public List<RtdbData> getArchivedValuesFilt(int id, String filter, int count, Object startTime, Object endTime) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        return this.gh.getArchivedValuesFilt(id, filter, count, startTime, endTime);
    }

    @Override
    public List<DoubleData> getFloatArchivedValuesFilt(int id, String filter, int count, Object startTime, Object endTime) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        ArrayList<DoubleData> list = new ArrayList<DoubleData>(count);
        RtdbData[] data = this.gh.getArchivedValuesFilt(id, RtdbType.RTDB_REAL64, filter, count, startTime, endTime);
        DoubleData doubleData = null;
        for (int i = 0; i < data.length; ++i) {
            doubleData = new DoubleData();
            doubleData.setId(id);
            doubleData.setValue((Double)data[i].getValue());
            doubleData.setDateTime(data[i].getDate());
            doubleData.setQuality(data[i].getQuality());
            doubleData.setNanosecond(data[i].getNanosecond());
            list.add(doubleData);
        }
        return list;
    }

    @Override
    public SummaryEntity getNumberSummaryFitEx(int id, String filter, Object startTime, Object endTime) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        SummaryEntity se = new SummaryEntity();
        RtdbSummaryData data = this.gh.getSummaryFilt(id, filter, startTime, endTime);
        se.setMaxValueTime(data.getMaxValueTime());
        se.setMinValueTime(data.getMinValueTime());
        se.setMaxValue(data.getMaxValue());
        se.setMinValue(data.getMinValue());
        se.setTotalValue(data.getTotalValue());
        se.setCalcAvg(data.getCalcAvg());
        se.setPowerAvg(data.getPowerAvg());
        se.setMaxValueNanosecond(data.getMaxValueNanosecond());
        se.setMinValueNanosecond(data.getMinValueNanosecond());
        return se;
    }

    @Override
    public SummaryEntity getNumberSummaryFit(int id, String filter, Object startTime, Object endTime) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        SummaryEntity se = new SummaryEntity();
        RtdbSummaryData data = this.gh.getSummaryFilt(id, filter, startTime, endTime);
        se.setMaxValueTime(data.getMaxValueTime());
        se.setMinValueTime(data.getMinValueTime());
        se.setMaxValue(data.getMaxValue());
        se.setMinValue(data.getMinValue());
        se.setTotalValue(data.getTotalValue());
        se.setCalcAvg(data.getCalcAvg());
        se.setPowerAvg(data.getPowerAvg());
        se.setMaxValueNanosecond(data.getMaxValueNanosecond());
        se.setMinValueNanosecond(data.getMinValueNanosecond());
        return se;
    }

    @Override
    public List<SummaryEntity> getNumberSummaryFiltInBatches(int id, String filter, int count, long interval, Object startTime, Object endTime) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        ArrayList<SummaryEntity> list = new ArrayList<SummaryEntity>(count);
        RtdbSummaryData[] data = this.gh.getSummaryFiltInBatches(id, filter, count, interval, startTime, endTime);
        SummaryEntity se = null;
        for (int i = 0; i < data.length; ++i) {
            se = new SummaryEntity();
            se.setMaxValueTime(data[i].getMaxValueTime());
            se.setMinValueTime(data[i].getMinValueTime());
            se.setMaxValue(data[i].getMaxValue());
            se.setMinValue(data[i].getMinValue());
            se.setTotalValue(data[i].getTotalValue());
            se.setCalcAvg(data[i].getCalcAvg());
            se.setPowerAvg(data[i].getPowerAvg());
            se.setMaxValueNanosecond(data[i].getMaxValueNanosecond());
            se.setMinValueNanosecond(data[i].getMinValueNanosecond());
            list.add(se);
        }
        return list;
    }

    @Override
    public boolean putIntSingleValue(IntData intData) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        RtdbData data = new RtdbData();
        data.setId(intData.getId());
        data.setValue(intData.getValue());
        data.setDate(intData.dateTimeObj());
        data.setQuality(intData.getQuality());
        data.setState(intData.getState());
        return this.gh.putSingleValue(data, RtdbType.RTDB_INT32) == 1;
    }

    @Override
    public int putSingleCoorValue(RtdbCoorData rtdbCoorData) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        return this.gh.putSingleCoorValue(rtdbCoorData);
    }

    @Override
    public int putSingleBlobValue(RtdbBlobData rtdbRtdbBlobData) throws ParseException, InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        return this.gh.putSingleBlobValue(rtdbRtdbBlobData);
    }

    @Override
    public boolean putFloatSingleValue(DoubleData doubleData) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        RtdbData data = new RtdbData();
        data.setId(doubleData.getId());
        data.setValue(doubleData.getValue());
        data.setDate(doubleData.dateTimeObj());
        short quality = doubleData.getQuality();
        data.setQuality(quality);
        int result = this.gh.putSingleValue(data, RtdbType.RTDB_REAL64);
        return result == 1;
    }

    @Override
    public List<IntData> getIntArchivedValuesBackward(int id, int count, Object startTime, Object endTime) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        List<IntData> result = this.getIntArchivedValues(id, count, startTime, endTime);
        if (null != result && result.size() > 0) {
            Collections.sort(result, new Comparator<IntData>(){

                @Override
                public int compare(IntData o1, IntData o2) {
                    if (o1.getDateTime().getTime() - o2.getDateTime().getTime() > 0L) {
                        return -1;
                    }
                    if (o1.getDateTime().getTime() - o2.getDateTime().getTime() == 0L) {
                        return 0;
                    }
                    return 1;
                }
            });
        }
        return result;
    }

    @Override
    public List<DoubleData> getDoubleArchivedValuesBackward(int id, int count, Object startTime, Object endTime) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        List<DoubleData> result = this.getDoubleArchivedValues(id, count, startTime, endTime);
        if (null != result && result.size() > 0) {
            Collections.sort(result, new Comparator<DoubleData>(){

                @Override
                public int compare(DoubleData o1, DoubleData o2) {
                    if (o1.getDateTime().getTime() - o2.getDateTime().getTime() > 0L) {
                        return -1;
                    }
                    if (o1.getDateTime().getTime() - o2.getDateTime().getTime() == 0L) {
                        return 0;
                    }
                    return 1;
                }
            });
        }
        return result;
    }

    @Override
    public List<CoorData> getCoorArchivedValuesBackward(int id, int count, Object startTime, Object endTime) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        List<CoorData> result = this.getCoorArchivedValues(id, count, startTime, endTime);
        if (null != result && result.size() > 0) {
            Collections.sort(result, new Comparator<CoorData>(){

                @Override
                public int compare(CoorData o1, CoorData o2) {
                    if (o1.getDateTime().getTime() - o2.getDateTime().getTime() > 0L) {
                        return -1;
                    }
                    if (o1.getDateTime().getTime() - o2.getDateTime().getTime() == 0L) {
                        return 0;
                    }
                    return 1;
                }
            });
        }
        return result;
    }

    @Override
    public int putArchivedValues(RtdbData[] rtdbDatas) throws UnknownHostException, IOException, DataTypeNotMatchException, InvalidParameterException, NoAuthorityException, ParseException, EncodePacketErrorException, Exception {
        int count = this.gh.putArchivedValues(rtdbDatas);
        return count;
    }

    @Override
    public int putArchivedCoorValues(RtdbCoorData[] rtdbCoordatas) throws ParseException, InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        return this.gh.putArchivedCoorValues(rtdbCoordatas);
    }

    @Override
    public int flushArchivedValues(int id) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        return this.gh.flushArchivedValues(id);
    }

    @Override
    public List<RtdbData> getArchivedValues(int id, int count, Object startTime, Object endTime) throws NoAuthorityException, Exception {
        List<RtdbData> archivedValues = this.gh.getArchivedValues(id, count, startTime, endTime);
        ArrayList<RtdbData> list = new ArrayList<RtdbData>(count > 0 ? count : 10);
        Calendar cld = Calendar.getInstance();
        for (RtdbData hisVal : archivedValues) {
            cld.setTime(hisVal.getDate());
            if (this.unValidateYear == cld.get(1)) continue;
            RtdbData is = new RtdbData();
            is.setId(hisVal.getId());
            is.setQuality(hisVal.getQuality());
            is.setValue(hisVal.getValue());
            is.setState(hisVal.getState());
            is.setDate(hisVal.getDate());
            is.setNanosecond(hisVal.getNanosecond());
            list.add(is);
        }
        return list;
    }

    @Override
    public List<BlobData> getArchivedBlobValues(int id, int count, Object startTime, Object endTime) throws Exception {
        byte[][] blobs = new byte[count][];
        short[] lens = new short[count];
        short[] qualities = new short[count];
        Date[] dateTimes = new Date[count];
        int[] nanosecond = new int[count];
        int resultCount = this.gh.getArchivedBlobValues(id, count, startTime, endTime, blobs, dateTimes, nanosecond, lens, qualities);
        ArrayList<BlobData> newDatas = null;
        if (resultCount > 0) {
            newDatas = new ArrayList<BlobData>(resultCount);
            BlobData newData = null;
            for (int i = 0; i < resultCount; ++i) {
                newData = new BlobData();
                newData.setId(id);
                newData.setBlob(blobs[i]);
                newData.setDatetime(dateTimes[i]);
                newData.setLen(lens[i]);
                newData.setQuality(Quality.getQuality(qualities[i]));
                newData.setNanosecond(nanosecond[i]);
                newDatas.add(newData);
            }
        }
        return newDatas;
    }

    @Override
    public int putArchivedBlobValues(List<BlobData> blobDataList) throws InvalidParameterException, NoAuthorityException, RuntimeException, Exception {
        int count = blobDataList.size();
        int[] ids = new int[count];
        Object[] dateTimes = new Object[count];
        byte[][] blobs = new byte[count][];
        short[] qualities = new short[count];
        int[] errors = new int[count];
        for (int i = 0; i < count; ++i) {
            ids[i] = blobDataList.get(i).getId();
            dateTimes[i] = blobDataList.get(i).datetimeObj();
            blobs[i] = blobDataList.get(i).getBlob();
            qualities[i] = blobDataList.get(i).getQuality().getNum();
        }
        int sucCount = this.gh.putArchivedBlobValues(count, ids, dateTimes, blobs, qualities, errors);
        for (int i = 0; i < blobDataList.size(); ++i) {
            blobDataList.get(i).setError(errors[i]);
            blobDataList.get(i).setId(ids[i]);
        }
        return sucCount;
    }

    @Override
    public DatetimeData getSingleDatetimeValue(int id, Object dateTime, HisMode rtdbHisMode) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        RtdbDatetimeData data = this.gh.getSingleDatetimeValue(id, dateTime, rtdbHisMode);
        return new DatetimeData(data.getId(), data.getDate(), data.getValue(), data.getQuality().getNum(), data.getError(), DateUtil.getMilSecond((Date)data.getDate()), data.getNanosecond());
    }

    @Override
    public boolean putSingleDatetimeValue(DatetimeData datetimeData) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (!datetimeData.dateTimeObj().getClass().equals(Date.class) && !datetimeData.dateTimeObj().getClass().equals(DateTimeNS.class)) {
            throw new InvalidParameterException();
        }
        RtdbDatetimeData rtdbDatetimeData = new RtdbDatetimeData();
        rtdbDatetimeData.setId(datetimeData.getId());
        rtdbDatetimeData.setValue(datetimeData.getValue());
        rtdbDatetimeData.setQuality(datetimeData.getQuality());
        if (datetimeData.dateTimeObj().getClass().equals(Date.class)) {
            rtdbDatetimeData.setDate((Date)datetimeData.dateTimeObj());
            rtdbDatetimeData.setMs(datetimeData.getMs());
        } else if (datetimeData.dateTimeObj().getClass().equals(DateTimeNS.class)) {
            rtdbDatetimeData.setDate(((DateTimeNS)datetimeData.dateTimeObj()).getDatetime());
            rtdbDatetimeData.setMs(((DateTimeNS)datetimeData.dateTimeObj()).getNanosecond());
        }
        int count = this.gh.putSingleDatetimeValue(rtdbDatetimeData);
        return count > 0;
    }

    @Override
    public List<DatetimeData> getArchivedDatetimeValues(int id, Object startTime, Object endTime, int count) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        ArrayList<DatetimeData> list = new ArrayList<DatetimeData>(count);
        RtdbDatetimeData[] datas = this.gh.getArchivedDatetimeValues(id, startTime, endTime, count);
        Calendar cld = Calendar.getInstance();
        for (int i = 0; i < datas.length; ++i) {
            Date dt = (Date)datas[i].getDate();
            if (null != dt) {
                cld.setTime((Date)datas[i].getDate());
                if (this.unValidateYear == cld.get(1)) continue;
            }
            DatetimeData data = new DatetimeData();
            data.setId(id);
            data.setValue(datas[i].getValue());
            data.setDateTime(datas[i].getDate());
            data.setQuality(datas[i].getQuality().getNum());
            data.setMs(DateUtil.getMilSecond((Date)datas[i].getDate()));
            data.setError(datas[i].getError());
            data.setNanosecond(datas[i].getNanosecond());
            list.add(data);
        }
        return list;
    }

    @Override
    public NamedTypeData getSingleNamedTypeValue(int id, Object dateTime, HisMode rtdbHisMode, short len) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        RtdbNamedTypeData rtdbNamedTypeData = this.gh.getSingleNamedTypeValue(id, dateTime, rtdbHisMode, len);
        NamedTypeData data = new NamedTypeData();
        data.setId(rtdbNamedTypeData.getId());
        data.setValue(rtdbNamedTypeData.getValue());
        data.setDatetime(rtdbNamedTypeData.getDatetime());
        data.setQuality(rtdbNamedTypeData.getQuality().getNum());
        data.setLen(len);
        data.setNanosecond(rtdbNamedTypeData.getNanosecond());
        return data;
    }

    @Override
    public boolean putSingleNamedTypeValue(NamedTypeData namedTypeData) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (namedTypeData == null || namedTypeData.datetimeObj() == null) {
            throw new InvalidParameterException();
        }
        RtdbNamedTypeData data = new RtdbNamedTypeData();
        data.setId(namedTypeData.getId());
        data.setDatetime(namedTypeData.datetimeObj());
        if (namedTypeData.datetimeObj().getClass().equals(Date.class)) {
            data.setNanosecond(0);
        } else if (namedTypeData.datetimeObj().getClass().equals(DateTimeNS.class)) {
            data.setNanosecond(((DateTimeNS)namedTypeData.datetimeObj()).getNanosecond());
        } else {
            throw new InvalidParameterException();
        }
        data.setValue(namedTypeData.getValue());
        data.setQuality(namedTypeData.getQuality().getNum());
        int count = this.gh.putSingleNamedTypeValue(data);
        return count > 0;
    }

    @Override
    public int putArchivedDatetimeValues(List<DatetimeData> datetimeDataList) throws InvalidParameterException, NoAuthorityException, ParseException, Exception {
        if (datetimeDataList == null || datetimeDataList.size() <= 0) {
            throw new InvalidParameterException();
        }
        RtdbDatetimeData[] rtdbDatetimeDataCollection = new RtdbDatetimeData[datetimeDataList.size()];
        for (int i = 0; i < datetimeDataList.size(); ++i) {
            RtdbDatetimeData rtdbDatetimeData = new RtdbDatetimeData();
            rtdbDatetimeData.setId(datetimeDataList.get(i).getId());
            rtdbDatetimeData.setValue(datetimeDataList.get(i).getValue());
            rtdbDatetimeData.setQuality(datetimeDataList.get(i).getQuality());
            rtdbDatetimeData.setError(datetimeDataList.get(i).getError());
            if (datetimeDataList.get(i).dateTimeObj().getClass().equals(Date.class)) {
                rtdbDatetimeData.setDate((Date)datetimeDataList.get(i).dateTimeObj());
                rtdbDatetimeData.setMs(datetimeDataList.get(i).getMs());
            } else if (datetimeDataList.get(i).dateTimeObj().getClass().equals(DateTimeNS.class)) {
                rtdbDatetimeData.setDate(((DateTimeNS)datetimeDataList.get(i).dateTimeObj()).getDatetime());
                rtdbDatetimeData.setMs(((DateTimeNS)datetimeDataList.get(i).dateTimeObj()).getNanosecond());
            } else {
                throw new InvalidParameterException();
            }
            rtdbDatetimeDataCollection[i] = rtdbDatetimeData;
        }
        int count = this.gh.putArchivedDatetimeValues(rtdbDatetimeDataCollection);
        for (int i = 0; i < rtdbDatetimeDataCollection.length; ++i) {
            datetimeDataList.get(i).setId(rtdbDatetimeDataCollection[i].getId());
            datetimeDataList.get(i).setError(rtdbDatetimeDataCollection[i].getError());
        }
        return count;
    }

    @Override
    public List<NamedTypeData> getArchivedNamedTypeValues(int id, Object startTime, Object endTime, int count, short len) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        ArrayList<NamedTypeData> list = new ArrayList<NamedTypeData>(count);
        RtdbNamedTypeData[] datas = this.gh.getArchivedNamedTypeValues(id, startTime, endTime, count, len);
        Calendar cld = Calendar.getInstance();
        for (int i = 0; i < datas.length; ++i) {
            Date dt = (Date)datas[i].getDatetime();
            if (null != dt) {
                cld.setTime(dt);
                if (this.unValidateYear == cld.get(1)) continue;
                NamedTypeData namedTypeData = new NamedTypeData();
            }
            NamedTypeData data = new NamedTypeData();
            data.setId(datas[i].getId());
            data.setValue(datas[i].getValue());
            data.setQuality(datas[i].getQuality().getNum());
            data.setDatetime(datas[i].getDatetime());
            data.setNanosecond(datas[i].getNanosecond());
            list.add(data);
        }
        return list;
    }

    @Override
    public int putArchivedNamedTypeValues(List<NamedTypeData> namedTypeDataList) throws InvalidParameterException, NoAuthorityException, ParseException, Exception {
        RtdbNamedTypeData[] rtdbNamedTypeDataArray = new RtdbNamedTypeData[namedTypeDataList.size()];
        for (int i = 0; i < namedTypeDataList.size(); ++i) {
            RtdbNamedTypeData rtdbNamedTypeData = new RtdbNamedTypeData();
            rtdbNamedTypeData.setId(namedTypeDataList.get(i).getId());
            rtdbNamedTypeData.setDatetime(namedTypeDataList.get(i).datetimeObj());
            rtdbNamedTypeData.setValue(namedTypeDataList.get(i).getValue());
            rtdbNamedTypeData.setQuality(namedTypeDataList.get(i).getQuality().getNum());
            if (namedTypeDataList.get(i).datetimeObj().getClass().equals(Date.class)) {
                rtdbNamedTypeData.setNanosecond(0);
            } else if (namedTypeDataList.get(i).datetimeObj().getClass().equals(DateTimeNS.class)) {
                rtdbNamedTypeData.setNanosecond(((DateTimeNS)namedTypeDataList.get(i).datetimeObj()).getNanosecond());
            } else {
                throw new InvalidParameterException();
            }
            rtdbNamedTypeDataArray[i] = rtdbNamedTypeData;
        }
        return this.gh.putArchivedNamedTypeValues(rtdbNamedTypeDataArray);
    }

    @Override
    public List<StringData> getArchivedStringValues(int id, int count, Object dateStart, Object dateEnd) throws InvalidParameterException, NoAuthorityException, ParseException, Exception {
        byte[][] blobs = new byte[count][];
        short[] lens = new short[count];
        short[] qualities = new short[count];
        Date[] dateTimes = new Date[count];
        int[] nanosecond = new int[count];
        int resultCount = this.gh.getArchivedBlobValues(id, count, dateStart, dateEnd, blobs, dateTimes, nanosecond, lens, qualities);
        ArrayList<StringData> newDatas = null;
        if (resultCount > 0) {
            newDatas = new ArrayList<StringData>(resultCount);
            Calendar cld = Calendar.getInstance();
            for (int i = 0; i < resultCount; ++i) {
                cld.setTime(dateTimes[i]);
                if (this.unValidateYear == cld.get(1)) continue;
                StringData newData = new StringData();
                newData.setId(id);
                newData.setDatetime(dateTimes[i]);
                newData.setQuality(Quality.getQuality(qualities[i]));
                newData.setValue(String.valueOf(BytesConvertUtil.bytesToCharArray(blobs[i], 0)));
                newData.setNanosecond(nanosecond[i]);
                newDatas.add(newData);
            }
        }
        return newDatas;
    }

    @Override
    public int getArchivedValuesCount(String tagName, Object dateStart, Object dateEnd) throws IOException, ParseException, EncodePacketErrorException, UnexpectedMethodException, Exception {
        if (tagName == null || tagName.isEmpty()) {
            return 0;
        }
        int[] ids = this.getIdsByTagNames(new String[]{tagName});
        if (ids[0] > 0) {
            return this.getArchivedValuesCount(ids[0], dateStart, dateEnd);
        }
        return 0;
    }

    @Override
    public List<IntData> getIntArchivedValues(String tagName, int count, Object dateStart, Object dateEnd) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (tagName == null || tagName.isEmpty()) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(new String[]{tagName});
        if (ids[0] > 0) {
            return this.getIntArchivedValues(ids[0], count, dateStart, dateEnd);
        }
        return null;
    }

    @Override
    public List<DoubleData> getDoubleArchivedValues(String tagName, int count, Object dateStart, Object dateEnd) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (tagName == null || tagName.isEmpty()) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(new String[]{tagName});
        if (ids[0] > 0) {
            return this.getDoubleArchivedValues(ids[0], count, dateStart, dateEnd);
        }
        return null;
    }

    @Override
    public List<CoorData> getCoorArchivedValues(String tagName, int count, Object startTime, Object endTime) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (tagName == null || tagName.isEmpty()) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(new String[]{tagName});
        if (ids[0] > 0) {
            return this.getCoorArchivedValues(ids[0], count, startTime, endTime);
        }
        return null;
    }

    @Override
    public IntData getIntSingleValue(String tagName, Object dateTime, RtdbHisMode rtdbHisMode) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (tagName == null || tagName.isEmpty()) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(new String[]{tagName});
        if (ids[0] > 0) {
            return this.getIntSingleValue(ids[0], dateTime, rtdbHisMode);
        }
        return null;
    }

    @Override
    public DoubleData getFloatSingleValue(String tagName, Object dateTime, RtdbHisMode rtdbHisMode) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (tagName == null || tagName.isEmpty()) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(new String[]{tagName});
        if (ids[0] > 0) {
            return this.getFloatSingleValue(ids[0], dateTime, rtdbHisMode);
        }
        return null;
    }

    @Override
    public BlobData getBlobSingleValue(String tagName, Object dateTime, RtdbHisMode rtdbHisMode) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (tagName == null || tagName.isEmpty()) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(new String[]{tagName});
        if (ids[0] > 0) {
            return this.getBlobSingleValue(ids[0], dateTime, rtdbHisMode);
        }
        return null;
    }

    @Override
    public List<IntData> getIntNextArchivedValues(String tagName, int count) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (tagName == null || tagName.isEmpty()) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(new String[]{tagName});
        if (ids[0] > 0) {
            return this.getIntNextArchivedValues(ids[0], count);
        }
        return null;
    }

    @Override
    public List<DoubleData> getFloatNextArchivedValues(String tagName, int count) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (tagName == null || tagName.isEmpty()) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(new String[]{tagName});
        if (ids[0] > 0) {
            return this.getFloatNextArchivedValues(ids[0], count);
        }
        return null;
    }

    @Override
    public List<IntData> getIntTimedValues(String tagName, int count, Object[] datetimes) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (tagName == null || tagName.isEmpty()) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(new String[]{tagName});
        if (ids[0] > 0) {
            return this.getIntTimedValues(ids[0], count, datetimes);
        }
        return null;
    }

    @Override
    public List<DoubleData> getFloatTimedValues(String tagName, int count, Object[] datetimes) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (tagName == null || tagName.isEmpty()) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(new String[]{tagName});
        if (ids[0] > 0) {
            return this.getFloatTimedValues(ids[0], count, datetimes);
        }
        return null;
    }

    @Override
    public List<CoorData> getCoorTimedValues(String tagName, int count, Object[] datetimes) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (tagName == null || tagName.isEmpty()) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(new String[]{tagName});
        if (ids[0] > 0) {
            return this.getCoorTimedValues(ids[0], count, datetimes);
        }
        return null;
    }

    @Override
    public List<IntData> getIntInterpoValues(String tagName, int count, Object startTime, Object endTime) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (tagName == null || tagName.isEmpty()) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(new String[]{tagName});
        if (ids[0] > 0) {
            return this.getIntInterpoValues(ids[0], count, startTime, endTime);
        }
        return null;
    }

    @Override
    public List<DoubleData> getFloatInterpoValues(String tagName, int count, Object startTime, Object endTime) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (tagName == null || tagName.isEmpty()) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(new String[]{tagName});
        if (ids[0] > 0) {
            return this.getFloatInterpoValues(ids[0], count, startTime, endTime);
        }
        return null;
    }

    @Override
    public List<IntData> getIntIntervalValues(String tagName, long interval, int count, Object dateTime) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (tagName == null || tagName.isEmpty()) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(new String[]{tagName});
        if (ids[0] > 0) {
            return this.getIntIntervalValues(ids[0], interval, count, dateTime);
        }
        return null;
    }

    @Override
    public List<DoubleData> getFloatIntervalValues(String tagName, long interval, int count, Object dateTime) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (tagName == null || tagName.isEmpty()) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(new String[]{tagName});
        if (ids[0] > 0) {
            return this.getFloatIntervalValues(ids[0], interval, count, dateTime);
        }
        return null;
    }

    @Override
    public SummaryEntity getNumberSummary(String tagName, Object startTime, Object endTime) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (tagName == null || tagName.isEmpty()) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(new String[]{tagName});
        if (ids[0] > 0) {
            return this.getNumberSummary(ids[0], startTime, endTime);
        }
        return null;
    }

    @Override
    public List<SummaryEntity> getNumberSummaryInBatches(String tagName, int count, long interval, Object startTime, Object endTime) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        if (tagName == null || tagName.isEmpty()) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(new String[]{tagName});
        if (ids[0] > 0) {
            return this.getNumberSummaryInBatches(ids[0], count, interval, startTime, endTime);
        }
        return null;
    }

    @Override
    public RtdbCoorData getSingleCoorValue(int id, Object dateTime, HisMode mode) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        RtdbCoorData coorData = this.gh.getSingleCoorValue(id, dateTime, mode);
        return coorData;
    }

    @Override
    public List<IntData> getIntPlotValues(String tagName, int interval, int count, Object dateStart, Object dateEnd) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        if (tagName == null || tagName.isEmpty()) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(new String[]{tagName});
        if (ids[0] > 0) {
            return this.getIntPlotValues(ids[0], interval, count, dateStart, dateEnd);
        }
        return null;
    }

    @Override
    public List<DoubleData> getFloatPlotValues(String tagName, int interval, int count, Object startTime, Object endTime) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        if (tagName == null || tagName.isEmpty()) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(new String[]{tagName});
        if (ids[0] > 0) {
            return this.getFloatPlotValues(ids[0], interval, count, startTime, endTime);
        }
        return null;
    }

    @Override
    public List<IntData> getIntCrossSectionValues(String[] tagNames, Object[] dateTime, RtdbHisMode mode) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        if (tagNames == null || tagNames.length == 0) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(tagNames);
        return this.getIntCrossSectionValues(ids, dateTime, mode);
    }

    @Override
    public List<DoubleData> getFloatCrossSectionValues(String[] tagNames, Object[] dateTime, RtdbHisMode mode) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        if (tagNames == null || tagNames.length == 0) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(tagNames);
        return this.getFloatCrossSectionValues(ids, dateTime, mode);
    }

    @Override
    public List<IntData> getArchivedIntValuesFilt(String tagName, String filter, int count, Object startTime, Object endTime) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (tagName == null || tagName.isEmpty()) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(new String[]{tagName});
        if (ids[0] > 0) {
            return this.getArchivedIntValuesFilt(ids[0], filter, count, startTime, endTime);
        }
        return null;
    }

    @Override
    public List<DoubleData> getFloatArchivedValuesFilt(String tagName, String filter, int count, Object startTime, Object endTime) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (tagName == null || tagName.isEmpty()) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(new String[]{tagName});
        if (ids[0] > 0) {
            return this.getFloatArchivedValuesFilt(ids[0], filter, count, startTime, endTime);
        }
        return null;
    }

    @Override
    public SummaryEntity getNumberSummaryFit(String tagName, String filter, Object startTime, Object endTime) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (tagName == null || tagName.isEmpty()) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(new String[]{tagName});
        if (ids[0] > 0) {
            return this.getNumberSummaryFit(ids[0], filter, startTime, endTime);
        }
        return null;
    }

    @Override
    public List<SummaryEntity> getNumberSummaryFiltInBatches(String tagName, String filter, int count, long interval, Object startTime, Object endTime) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, ParseException, Exception {
        if (tagName == null || tagName.isEmpty()) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(new String[]{tagName});
        if (ids[0] > 0) {
            return this.getNumberSummaryFiltInBatches(ids[0], filter, count, interval, startTime, endTime);
        }
        return null;
    }

    @Override
    public List<IntData> getIntArchivedValuesBackward(String tagName, int count, Object startTime, Object endTime) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        List<IntData> result = this.getIntArchivedValues(tagName, count, startTime, endTime);
        if (null != result && result.size() > 0) {
            Collections.sort(result, new Comparator<IntData>(){

                @Override
                public int compare(IntData o1, IntData o2) {
                    if (o1.getDateTime().getTime() - o2.getDateTime().getTime() > 0L) {
                        return -1;
                    }
                    if (o1.getDateTime().getTime() - o2.getDateTime().getTime() == 0L) {
                        return 0;
                    }
                    return 1;
                }
            });
        }
        return result;
    }

    @Override
    public List<DoubleData> getDoubleArchivedValuesBackward(String tagName, int count, Object dateStart, Object dateEnd) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        List<DoubleData> result = this.getDoubleArchivedValues(tagName, count, dateStart, dateEnd);
        if (null != result && result.size() > 0) {
            Collections.sort(result, new Comparator<DoubleData>(){

                @Override
                public int compare(DoubleData o1, DoubleData o2) {
                    if (o1.getDateTime().getTime() - o2.getDateTime().getTime() > 0L) {
                        return -1;
                    }
                    if (o1.getDateTime().getTime() - o2.getDateTime().getTime() == 0L) {
                        return 0;
                    }
                    return 1;
                }
            });
        }
        return result;
    }

    @Override
    public List<CoorData> getCoorArchivedValuesBackward(String tagName, int count, Object startTime, Object endTime) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        List<CoorData> result = this.getCoorArchivedValues(tagName, count, startTime, endTime);
        if (null != result && result.size() > 0) {
            Collections.sort(result, new Comparator<CoorData>(){

                @Override
                public int compare(CoorData o1, CoorData o2) {
                    if (o1.getDateTime().getTime() - o2.getDateTime().getTime() > 0L) {
                        return -1;
                    }
                    if (o1.getDateTime().getTime() - o2.getDateTime().getTime() == 0L) {
                        return 0;
                    }
                    return 1;
                }
            });
        }
        return result;
    }

    @Override
    public int flushArchivedValues(String tagName) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (tagName == null || tagName.isEmpty()) {
            return 0;
        }
        int[] ids = this.getIdsByTagNames(new String[]{tagName});
        if (ids[0] > 0) {
            return this.flushArchivedValues(ids[0]);
        }
        return 0;
    }

    @Override
    public List<BlobData> getArchivedBlobValues(String tagName, int count, Object dateStart, Object dateEnd) throws Exception {
        if (tagName == null || tagName.isEmpty()) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(new String[]{tagName});
        if (ids[0] > 0) {
            return this.getArchivedBlobValues(ids[0], count, dateStart, dateEnd);
        }
        return null;
    }

    @Override
    public DatetimeData getSingleDatetimeValue(String tagName, Object dateTime, HisMode rtdbHisMode) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (tagName == null || tagName.isEmpty()) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(new String[]{tagName});
        if (ids[0] > 0) {
            return this.getSingleDatetimeValue(ids[0], dateTime, rtdbHisMode);
        }
        return null;
    }

    @Override
    public List<DatetimeData> getArchivedDatetimeValues(String tagName, Object startTime, Object endTime, int count) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        if (tagName == null || tagName.isEmpty()) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(new String[]{tagName});
        if (ids[0] > 0) {
            return this.getArchivedDatetimeValues(ids[0], startTime, endTime, count);
        }
        return null;
    }

    @Override
    public List<StringData> getArchivedStringValues(String tagName, int count, Object startTime, Object endTime) throws InvalidParameterException, NoAuthorityException, ParseException, Exception {
        if (tagName == null || tagName.isEmpty()) {
            return null;
        }
        int[] ids = this.getIdsByTagNames(new String[]{tagName});
        if (ids[0] > 0) {
            return this.getArchivedStringValues(ids[0], count, startTime, endTime);
        }
        return null;
    }

    private int[] getIdsByTagNames(String[] tableTags) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        int count = tableTags.length;
        int[] ids = new int[count];
        RtdbType[] types = new RtdbType[count];
        RTDBClass[] classof = new RTDBClass[count];
        boolean[] useMs = new boolean[count];
        this.bs.findPoints(count, tableTags, ids, types, classof, useMs);
        return ids;
    }

    @Override
    public int removeValue(int id, Date dateTime) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, UnexpectedMethodException, Exception {
        return this.gh.removeValue(id, dateTime);
    }

    @Override
    public int removeValues(int id, Object startTime, Object endTime) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        return this.gh.removeValues(id, startTime, endTime);
    }

    @Override
    public int archivedValuesRealCount(int id, Object startTime, Object endTime) throws NoAuthorityException, Exception {
        return this.gh.archivedValuesRealCount(id, startTime, endTime);
    }

    @Override
    public int archivedValuesCount(int id, Object startTime, Object endTime) throws NoAuthorityException, Exception {
        return this.gh.archivedValuesCount(id, startTime, endTime);
    }

    @Override
    public int updateValue(int id, RtdbType dataType, RtdbData data) throws ParseException, InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        return this.gh.updateValue(id, dataType, data);
    }

    @Override
    public int updateValue(RtdbData rtdbData) throws ParseException, InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        return this.gh.updateValue(rtdbData);
    }

    @Override
    public int updateCoorValue(int id, RtdbCoorData rtdbCoorData) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        return this.gh.updateCoorValue(id, rtdbCoorData);
    }

    @Override
    public int getArchivedValuesBatchCount(int id, Object datetime1, Object datetime2) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        return this.gh.getArchivedValuesBatchCount(id, datetime1, datetime2);
    }
}

