package com.beagle.base.bean.vo.resp;

import com.beagle.base.common.contant.CodeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;

/**
 * @author wuwanli
 */
@Data
@ToString
@ApiModel
public class BaseResponse implements Serializable {
    /**
     * 返回码
     */
    @ApiModelProperty("返回码")
    private String code;
    /**
     * 返回描述
     */
    @ApiModelProperty("返回描述")
    private String desc;

    public static BaseResponse success() {
        BaseResponse baseResponse = new BaseResponse();
        baseResponse.setCode(CodeEnum.SUCCESS.getCode());
        baseResponse.setDesc(CodeEnum.SUCCESS.getDesc());
        return baseResponse;
    }

    public static BaseResponse fail() {
        BaseResponse baseResponse = new BaseResponse();
        baseResponse.setCode(CodeEnum.UNKNOWN.getCode());
        baseResponse.setDesc(CodeEnum.UNKNOWN.getDesc());
        return baseResponse;
    }

    public static BaseResponse fail(CodeEnum codeEnum) {
        BaseResponse baseResponse = new BaseResponse();
        baseResponse.setCode(codeEnum.getCode());
        baseResponse.setDesc(codeEnum.getDesc());
        return baseResponse;
    }

    public static BaseResponse fail(String code, String desc) {
        BaseResponse baseResponse = new BaseResponse();
        baseResponse.setCode(code);
        baseResponse.setDesc(desc);
        return baseResponse;
    }

    public static BaseResponse fail(String desc) {
        BaseResponse baseResponse = new BaseResponse();
        baseResponse.setCode(CodeEnum.UNKNOWN.getCode());
        baseResponse.setDesc(desc);
        return baseResponse;
    }
}
