/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.api.model;

import com.rtdb.api.util.BytesConvertUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class MemoryStream {
    private int bufferIndex = 0;
    private byte[] buffer = null;
    private ByteArrayOutputStream stream = null;

    public int getBufferIndex() {
        return this.bufferIndex;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public MemoryStream(byte[] buffer) {
        this.buffer = buffer;
    }

    public MemoryStream() {
        this.stream = new ByteArrayOutputStream();
    }

    public void skip(int length) {
        this.bufferIndex += length;
    }

    public char readChar() throws UnsupportedEncodingException {
        char c = BytesConvertUtil.bytesToChar(this.buffer, this.bufferIndex);
        ++this.bufferIndex;
        return c;
    }

    public byte readByte() {
        byte b = this.buffer[this.bufferIndex];
        ++this.bufferIndex;
        return b;
    }

    public short readShort() {
        short s = BytesConvertUtil.bytesToShort(this.buffer, this.bufferIndex);
        this.bufferIndex += 2;
        return s;
    }

    public int readInt() {
        int i = BytesConvertUtil.bytesToInt(this.buffer, this.bufferIndex);
        this.bufferIndex += 4;
        return i;
    }

    public long readLong() {
        long i = BytesConvertUtil.bytesToLong(this.buffer, this.bufferIndex);
        this.bufferIndex += 8;
        return i;
    }

    public float readFloat() {
        float f = BytesConvertUtil.bytesToFloat(this.buffer, this.bufferIndex);
        this.bufferIndex += 4;
        return f;
    }

    public double readDouble() {
        double d = BytesConvertUtil.bytesToDouble(this.buffer, this.bufferIndex);
        this.bufferIndex += 8;
        return d;
    }

    public String readString(int length) throws UnsupportedEncodingException {
        String str = new String(this.buffer, this.bufferIndex, length - 1, "GBK");
        this.bufferIndex += length;
        return str;
    }

    public byte[] readBytes(int length) {
        byte[] bytes = new byte[length];
        System.arraycopy(this.buffer, this.bufferIndex, bytes, 0, length);
        this.bufferIndex += length;
        return bytes;
    }

    public short[] readShortArray(int length) {
        short[] array = new short[length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readShort();
        }
        return array;
    }

    public int[] readIntArray(int length) {
        int[] array = new int[length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readInt();
        }
        return array;
    }

    public long[] readLongArray(int length) {
        long[] array = new long[length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readLong();
        }
        return array;
    }

    public float[] readFloatArray(int length) {
        float[] array = new float[length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readFloat();
        }
        return array;
    }

    public double[] readDoubleArray(int length) {
        double[] array = new double[length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.readDouble();
        }
        return array;
    }

    public void readBytes(Object data, int count) {
        byte[] bytes = (byte[])data;
        int tempCount = count < bytes.length ? count : bytes.length;
        System.arraycopy(this.buffer, this.bufferIndex, bytes, 0, tempCount);
        this.bufferIndex += count;
    }

    public void readShortArray(Object data, int count) {
        short[] array = (short[])data;
        for (int i = 0; i < count; ++i) {
            if (i >= array.length) {
                this.readShort();
                continue;
            }
            array[i] = this.readShort();
        }
    }

    public void readIntArray(Object data, int count) {
        int[] array = (int[])data;
        for (int i = 0; i < count; ++i) {
            if (i >= array.length) {
                this.readInt();
                continue;
            }
            array[i] = this.readInt();
        }
    }

    public void readLongArray(Object data, int count) {
        long[] array = (long[])data;
        for (int i = 0; i < count; ++i) {
            if (i >= array.length) {
                this.readLong();
                continue;
            }
            array[i] = this.readLong();
        }
    }

    public void readFloatArray(Object data, int count) {
        float[] array = (float[])data;
        for (int i = 0; i < count; ++i) {
            if (i >= array.length) {
                this.readFloat();
                continue;
            }
            array[i] = this.readFloat();
        }
    }

    public void readDoubleArray(Object data, int count) {
        double[] array = (double[])data;
        for (int i = 0; i < count; ++i) {
            if (i >= array.length) {
                this.readDouble();
                continue;
            }
            array[i] = this.readDouble();
        }
    }

    public byte[] toByteArray() {
        if (this.stream != null) {
            return this.stream.toByteArray();
        }
        byte[] bytes = new byte[this.bufferIndex];
        System.arraycopy(this.buffer, 0, bytes, 0, this.bufferIndex);
        return bytes;
    }

    public void writeByte(byte value) {
        this.stream.write(value);
    }

    public void writeChar(char value) throws UnsupportedEncodingException {
        this.stream.write(BytesConvertUtil.charToBytes(value, 0), 0, 1);
    }

    public void writeShort(short value) {
        this.stream.write(BytesConvertUtil.shortToBytes(value), 0, 2);
    }

    public void writeInt(int value) {
        this.stream.write(BytesConvertUtil.intToBytes(value), 0, 4);
    }

    public void writeLong(long value) {
        this.stream.write(BytesConvertUtil.longToBytes(value), 0, 8);
    }

    public void writeFloat(float value) {
        this.stream.write(BytesConvertUtil.floatToBytes(value, 0), 0, 4);
    }

    public void writeDouble(double value) {
        this.stream.write(BytesConvertUtil.doubleToBytes(value, 0), 0, 8);
    }

    public void writeBytes(byte[] value) throws IOException {
        this.stream.write(value);
    }

    public void writeShortArray(short[] array) {
        for (short value : array) {
            this.writeShort(value);
        }
    }

    public void writeIntArray(int[] array) {
        for (int value : array) {
            this.writeInt(value);
        }
    }

    public void writeLongArray(long[] array) {
        for (long value : array) {
            this.writeLong(value);
        }
    }

    public void writeFloatArray(float[] array) {
        for (float value : array) {
            this.writeFloat(value);
        }
    }

    public void writeDoubleArray(double[] array) {
        for (double value : array) {
            this.writeDouble(value);
        }
    }

    public void writeString(String str) throws UnsupportedEncodingException, IOException {
        this.stream.write(str.getBytes("GBK"));
        this.stream.write(0);
    }

    public void writeString(String str, long count) throws UnsupportedEncodingException, IOException {
        int strLength = str.getBytes("gbk").length;
        if ((long)strLength < count) {
            this.stream.write(str.getBytes("GBK"));
            int i = 0;
            while ((long)i < count - (long)strLength) {
                this.stream.write(0);
                ++i;
            }
        } else {
            this.stream.write(str.getBytes("GBK"));
        }
    }

    public int size() {
        return this.stream.size();
    }

    public Boolean writeTo(OutputStream outStream) throws IOException {
        try {
            this.stream.writeTo(outStream);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void close() throws IOException {
        if (null != this.stream) {
            this.stream.flush();
            this.stream.close();
        }
    }
}

