/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.api.msg;

import com.google.protobuf.ByteString;
import com.rtdb.api.enums.RtdbMsgID;
import com.rtdb.api.enums.RtdbSearchSort;
import com.rtdb.api.enums.RtdbTagFieldIndex;
import com.rtdb.api.enums.RtdbType;
import com.rtdb.api.impl.adapter.BaseAdapter;
import com.rtdb.api.model.NamedDataTypeField;
import com.rtdb.api.model.RtdbBasePoint;
import com.rtdb.api.model.RtdbCalcPoint;
import com.rtdb.api.model.RtdbField;
import com.rtdb.api.model.RtdbMaxCalcPoint;
import com.rtdb.api.model.RtdbMinCalcPoint;
import com.rtdb.api.model.RtdbScanPoint;
import com.rtdb.api.protocol.DatagramBase;
import com.rtdb.api.protocol.DatagramBaseLoad;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BaseProtocol30
extends BaseAdapter {
    private static BaseProtocol30 baseProtocol = null;

    private BaseProtocol30() {
    }

    public static synchronized BaseProtocol30 getInstance() {
        if (baseProtocol == null) {
            baseProtocol = new BaseProtocol30();
        }
        return baseProtocol;
    }

    @Override
    public List<RtdbField> msgGetNamedTypesCountFields() {
        return this.msgCommonFields(RtdbMsgID.MSG_GET_NAMED_TYPES_COUNT, 0);
    }

    @Override
    public List<RtdbField> msgGetNamedTypesCountRespFields() {
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_NAMED_TYPES_COUNT, 3, 0, 0, 1, 0);
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgSearchExFields(String tag, String table, String desc, String unit, String src, String instr, String typeMask, int classof, int timeMask, int othermask, String otherMaskValue, RtdbSearchSort sort, int count) throws UnsupportedEncodingException {
        DatagramBase.datagram_search_ex.Builder builder = DatagramBase.datagram_search_ex.newBuilder();
        ByteString tagbts = ByteString.copyFromUtf8(tag);
        ByteString tablebts = ByteString.copyFromUtf8(table);
        ByteString descbts = ByteString.copyFromUtf8(desc);
        ByteString unitbts = ByteString.copyFromUtf8(unit);
        ByteString srcbts = ByteString.copyFromUtf8(src);
        ByteString instrbts = ByteString.copyFromUtf8(instr);
        ByteString typeMaskbts = ByteString.copyFromUtf8(typeMask);
        ByteString otherMaskValuebts = ByteString.copyFromUtf8(otherMaskValue);
        builder.setTag(tagbts);
        builder.setLen1(tag.length());
        builder.setTable(tablebts);
        builder.setLen2(table.length());
        builder.setDesc(descbts);
        builder.setLen3(desc.length());
        builder.setUnit(unitbts);
        builder.setLen4(unit.length());
        builder.setSource(srcbts);
        builder.setLen5(src.length());
        builder.setInstrument(instrbts);
        builder.setLen6(instr.length());
        builder.setType(typeMaskbts);
        builder.setLen7(typeMask.length());
        builder.setClassof(classof);
        builder.setTimeunit(timeMask);
        builder.setOther(othermask);
        builder.setOthervalue(otherMaskValuebts);
        builder.setSort(sort.getNum());
        DatagramBase.datagram_search_ex _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_SEARCH_EX, 1, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgSearchExRespFields(int ret, int count, int[] ids) {
        DatagramBase.datagram_search_ex_resp.Builder builder = DatagramBase.datagram_search_ex_resp.newBuilder();
        DatagramBase.datagram_search_ex_resp _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_SEARCH_EX, 1, ret, count, 1, 0);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgSearchPointCountFields(String tag, String table, String desc, String unit, String src, String instr, String typeMask, int classof, int timeMask, int othermask, String otherMaskValue) throws UnsupportedEncodingException {
        DatagramBase.datagram_search_points_count.Builder builder = DatagramBase.datagram_search_points_count.newBuilder();
        byte[] ta = tag.getBytes();
        ByteString tags = ByteString.copyFrom(ta);
        builder.setTag(tags);
        builder.setLen1(tags.size());
        byte[] tab = table.getBytes();
        ByteString tables = ByteString.copyFrom(tab);
        builder.setTable(tables);
        builder.setLen2(tables.size());
        byte[] de = desc.getBytes();
        ByteString descs = ByteString.copyFrom(de);
        builder.setDesc(descs);
        builder.setLen3(descs.size());
        byte[] un = unit.getBytes();
        ByteString units = ByteString.copyFrom(un);
        builder.setUnit(units);
        builder.setLen4(units.size());
        byte[] sr = src.getBytes();
        ByteString srcs = ByteString.copyFrom(sr);
        builder.setSource(srcs);
        builder.setLen5(srcs.size());
        byte[] in = instr.getBytes();
        ByteString instrs = ByteString.copyFrom(in);
        builder.setInstrument(instrs);
        builder.setLen6(instrs.size());
        byte[] ty = typeMask.getBytes();
        ByteString typeMasks = ByteString.copyFrom(ty);
        builder.setType(typeMasks);
        builder.setLen7(typeMasks.size());
        byte[] ot = otherMaskValue.getBytes();
        ByteString otherMaskValues = ByteString.copyFrom(ot);
        builder.setOthervalue(otherMaskValues);
        builder.setLen8(otherMaskValues.size());
        builder.setClassof(classof);
        builder.setTimeunit(timeMask);
        builder.setOther(othermask);
        DatagramBase.datagram_search_points_count _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_SEARCH_POINTS_COUNT, 1, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgSearchPointCountRespFields() {
        DatagramBase.datagram_search_points_count_resp.Builder builderresp = DatagramBase.datagram_search_points_count_resp.newBuilder();
        DatagramBase.datagram_search_points_count_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_SEARCH_POINTS_COUNT, 1, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msginsertNamedTypePointFields(boolean onSend, RtdbBasePoint[] base, RtdbScanPoint[] scan, String name) throws Exception {
        DatagramBase.datagram_insert_named_type_point.Builder builder = DatagramBase.datagram_insert_named_type_point.newBuilder();
        if (base != null && base[0] != null) {
            ByteString b = ByteString.copyFrom(RtdbBasePoint.basePointToByte(base[0]));
            builder.setBase(b);
        }
        if (scan != null && scan[0] != null) {
            ByteString s = ByteString.copyFrom(RtdbScanPoint.scanPointToByte(scan[0]));
            builder.setScan(s);
        }
        if (name != null) {
            ByteString names = ByteString.copyFromUtf8(name);
            builder.setName(names);
            builder.setLen(names.size());
        }
        DatagramBase.datagram_insert_named_type_point _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_INSERT_NAMED_TYPE_POINT, 3, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msginsertNamedTypePointRespFields(int ret, int id) {
        DatagramBase.datagram_insert_named_type_point_resp.Builder builderresp = DatagramBase.datagram_insert_named_type_point_resp.newBuilder();
        builderresp.setId(id);
        DatagramBase.datagram_insert_named_type_point_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_INSERT_NAMED_TYPE_POINT, 3, ret, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetAllNamedTypesFields(int count) {
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_ALL_NAMED_TYPES, 3, 0, count, 1, 0);
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetAllNamedTypesRespFields(int ret, int[] fieldCounts, String[] names, int count) {
        DatagramBase.datagram_get_all_named_types_resp.Builder builderresp = DatagramBase.datagram_get_all_named_types_resp.newBuilder();
        ArrayList<Integer> fieldCountslist = new ArrayList<Integer>(fieldCounts.length);
        Iterator iterator = fieldCountslist.iterator();
        while (iterator.hasNext()) {
            int field = (Integer)iterator.next();
            fieldCountslist.add(field);
        }
        ArrayList<ByteString> nameslist = new ArrayList<ByteString>(names.length);
        for (ByteString name : nameslist) {
            nameslist.add(name);
        }
        builderresp.addAllFieldcounts(fieldCountslist);
        builderresp.addAllNames(nameslist);
        DatagramBase.datagram_get_all_named_types_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_ALL_NAMED_TYPES, 0, ret, count, count, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetNamedTypeFields(int count, String name) throws UnsupportedEncodingException {
        DatagramBase.datagram_get_named_type.Builder builder = DatagramBase.datagram_get_named_type.newBuilder();
        ByteString names = ByteString.copyFrom(name, "GBK");
        builder.setName(names);
        builder.setLen(names.size());
        DatagramBase.datagram_get_named_type _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_NAMED_TYPE, 3, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetNamedTypeRespFields(int count, String desc, NamedDataTypeField[] fdb) throws Exception {
        DatagramBase.datagram_get_named_type_resp.Builder builderresp = DatagramBase.datagram_get_named_type_resp.newBuilder();
        ByteString descs = ByteString.copyFrom(desc, "GBK");
        builderresp.setDesc(descs);
        builderresp.setLen(descs.size());
        for (int i = 0; i < fdb.length; ++i) {
            builderresp.addFields(ByteString.copyFrom(NamedDataTypeField.namedDataTypeFieldToByte(fdb[i])));
        }
        DatagramBase.datagram_get_named_type_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_NAMED_TYPE, 0, 0, count, 1, 0);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgRemoveNamedTypeFields(String name) throws UnsupportedEncodingException {
        DatagramBase.datagram_remove_named_type.Builder builder = DatagramBase.datagram_remove_named_type.newBuilder();
        ByteString names = ByteString.copyFromUtf8(name);
        builder.setName(names);
        builder.setLen(names.size());
        DatagramBase.datagram_remove_named_type _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_REMOVE_NAMED_TYPE, 3, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgRemoveNamedTypeRespFields() {
        DatagramBase.datagram_remove_named_type_resp.Builder builderresp = DatagramBase.datagram_remove_named_type_resp.newBuilder();
        DatagramBase.datagram_remove_named_type_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_REMOVE_NAMED_TYPE, 3, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgModifyNamedTypeFields(String name, String modifyName, String modifyDesc, String mfName, String mfDesc, int field_count) throws UnsupportedEncodingException {
        DatagramBase.datagram_modify_named_type.Builder builder = DatagramBase.datagram_modify_named_type.newBuilder();
        ByteString names = ByteString.copyFrom(name, "GBK");
        ByteString modifyNames = ByteString.copyFrom(modifyName, "GBK");
        ByteString modifyDescs = ByteString.copyFrom(modifyDesc, "GBK");
        ByteString mfNames = ByteString.copyFrom(mfName, "GBK");
        ByteString mfDescs = ByteString.copyFrom(mfDesc, "GBK");
        builder.setName(names);
        builder.setLen(names.size());
        builder.setModifyName(modifyNames);
        builder.setModifyDesc(modifyDescs);
        builder.addModifyFieldNames(mfNames);
        builder.addModifyFieldDescs(mfDescs);
        builder.setIsmodifyNamenull(false);
        builder.setIsmodifyFieldNamenull(false);
        builder.setIsmodifyDescnull(false);
        builder.setIsmodifyFieldDescnull(false);
        DatagramBase.datagram_modify_named_type _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_MODIFY_NAMED_TYPE, 1, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgModifyNamedTypeRespFields(int ret) {
        DatagramBase.datagram_modify_named_type_resp.Builder builderresp = DatagramBase.datagram_modify_named_type_resp.newBuilder();
        DatagramBase.datagram_modify_named_type_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_MODIFY_NAMED_TYPE, 1, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgQueryLoadMemoryFields() {
        return this.msgCommonFields(RtdbMsgID.MSG_QUERY_LOAD_MEMORY, 0);
    }

    @Override
    public List<RtdbField> msgQueryLoadMemoryRespFields() {
        int flag = 0;
        DatagramBase.datagram_query_load_memory_resp.Builder builderresp = DatagramBase.datagram_query_load_memory_resp.newBuilder();
        builderresp.setFlag(flag);
        DatagramBase.datagram_query_load_memory_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_QUERY_LOAD_MEMORY, 1, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgSetLoadMemoryFields(int flag) {
        DatagramBase.datagram_set_load_memory.Builder builder = DatagramBase.datagram_set_load_memory.newBuilder();
        builder.setFlag(flag);
        DatagramBase.datagram_set_load_memory _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_SET_LOAD_MEMORY, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgSetLoadMemoryRespFields(int flag) {
        DatagramBase.datagram_set_load_memory_resp.Builder builderresp = DatagramBase.datagram_set_load_memory_resp.newBuilder();
        builderresp.setFlag(flag);
        DatagramBase.datagram_set_load_memory_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_SET_LOAD_MEMORY, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgQueryNeedMemorySizeFields(int flag) {
        DatagramBase.datagram_query_need_memory_size.Builder builder = DatagramBase.datagram_query_need_memory_size.newBuilder();
        builder.setFlag(flag);
        DatagramBase.datagram_query_need_memory_size _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_QUERY_NEED_MEMORY_SIZE, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgQueryNeedMemorySizeRespFields(int size) {
        DatagramBase.datagram_query_need_memory_size_resp.Builder builderresp = DatagramBase.datagram_query_need_memory_size_resp.newBuilder();
        builderresp.setSize(size);
        DatagramBase.datagram_query_need_memory_size_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_QUERY_NEED_MEMORY_SIZE, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetNamedTypeNamesPropertyFields(int[] ids) {
        int count = ids.length;
        DatagramBase.datagram_get_named_type_names_property.Builder builder = DatagramBase.datagram_get_named_type_names_property.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length);
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBase.datagram_get_named_type_names_property _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_NAMED_TYPE_NAMES_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetNamedTypeNamesPropertyRespFields(int count) throws UnsupportedEncodingException {
        DatagramBase.datagram_get_named_type_names_property_resp.Builder builderresp = DatagramBase.datagram_get_named_type_names_property_resp.newBuilder();
        ArrayList names = new ArrayList(count);
        ArrayList fieldsCount = new ArrayList(count);
        ArrayList errors = new ArrayList(count);
        for (ByteString str : names) {
            builderresp.addLens(str.size());
            builderresp.addNames(str);
        }
        builderresp.addAllErrors(errors);
        builderresp.addAllFieldcounts(fieldsCount);
        DatagramBase.datagram_get_named_type_names_property_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_NAMED_TYPE_NAMES_PROP, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetRecycledNamedTypeNamesPropertyFields(int[] ids) {
        DatagramBase.datagram_get_recycled_named_type_names_property.Builder builder = DatagramBase.datagram_get_recycled_named_type_names_property.newBuilder();
        int count = ids.length;
        ArrayList<Integer> listIds = new ArrayList<Integer>();
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBase.datagram_get_recycled_named_type_names_property _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_RECYCLED_NAMED_TYPE_NAMES_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetRecycledNamedTypeNamesPropertyRespFields(int count) throws UnsupportedEncodingException {
        DatagramBase.datagram_get_recycled_named_type_names_property_resp.Builder builderresp = DatagramBase.datagram_get_recycled_named_type_names_property_resp.newBuilder();
        ArrayList names = new ArrayList(count);
        ArrayList fieldsCount = new ArrayList(count);
        ArrayList errors = new ArrayList(count);
        builderresp.addAllNames(names);
        builderresp.addAllLens(fieldsCount);
        builderresp.addAllErrors(errors);
        builderresp.addAllFieldcounts(fieldsCount);
        DatagramBase.datagram_get_recycled_named_type_names_property_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_RECYCLED_NAMED_TYPE_NAMES_PROP, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetNamedTypePointsCountFields(String name) throws UnsupportedEncodingException {
        DatagramBase.datagram_get_named_types_points_count.Builder builder = DatagramBase.datagram_get_named_types_points_count.newBuilder();
        ByteString names = ByteString.copyFromUtf8(name);
        builder.setName(names);
        builder.setLen(names.size());
        DatagramBase.datagram_get_named_types_points_count _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_NAMED_TYPES_POINTS_COUNT, 3, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetNamedTypePointsCountRespFields() throws UnsupportedEncodingException {
        DatagramBase.datagram_get_named_types_points_count_resp.Builder builderresp = DatagramBase.datagram_get_named_types_points_count_resp.newBuilder();
        DatagramBase.datagram_get_named_types_points_count_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_NAMED_TYPES_POINTS_COUNT, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetBaseTypePointsCountFields(short type) {
        DatagramBase.datagram_get_base_type_points_count.Builder builder = DatagramBase.datagram_get_base_type_points_count.newBuilder();
        short types = type;
        builder.setType(types);
        DatagramBase.datagram_get_base_type_points_count _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_BASE_TYPE_POINTS_COUNT, 3, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetBaseTypePointsCountRespFields() {
        DatagramBase.datagram_get_base_type_points_count_resp.Builder builderresp = DatagramBase.datagram_get_base_type_points_count_resp.newBuilder();
        DatagramBase.datagram_get_base_type_points_count_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_BASE_TYPE_POINTS_COUNT, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgAppendTableFields(String name, String desc, int type) throws UnsupportedEncodingException {
        DatagramBase.datagram_append_table.Builder builder = DatagramBase.datagram_append_table.newBuilder();
        byte[] names = name.getBytes("GBK");
        byte[] descs = desc.getBytes("GBK");
        ByteString copyName = ByteString.copyFrom(names);
        ByteString copyDesc = ByteString.copyFrom(descs);
        builder.setType(type);
        builder.setName(copyName);
        builder.setLen1(copyName.size());
        builder.setDesc(copyDesc);
        builder.setLen2(copyDesc.size());
        DatagramBase.datagram_append_table _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_APPEND_TABLE, 1, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgAppendTableRespFields(int ret, int id) throws UnsupportedEncodingException {
        DatagramBase.datagram_append_table_resp.Builder builderresp = DatagramBase.datagram_append_table_resp.newBuilder();
        builderresp.setTabid(id);
        DatagramBase.datagram_append_table_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_APPEND_TABLE, 1, ret, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgTablesCountFields() {
        return this.msgCommonFields(RtdbMsgID.MSG_TABLES_COUNT, 0);
    }

    @Override
    public List<RtdbField> msgTablesCountRespFields(int ret, int count) {
        DatagramBase.datagram_tables_count_resp.Builder builder = DatagramBase.datagram_tables_count_resp.newBuilder();
        DatagramBase.datagram_tables_count_resp _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_TABLES_COUNT, 0, ret, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetTablesFields(int count) {
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_TABLES, 0, 0, count, 1, 0);
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetTablesRespFields(int ret, int count, int[] ids) {
        DatagramBase.datagram_get_tables_resp.Builder builderresp = DatagramBase.datagram_get_tables_resp.newBuilder();
        ArrayList idslist = new ArrayList(ids.length);
        builderresp.addAllTabids(idslist);
        DatagramBase.datagram_get_tables_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_TABLES, 0, ret, count, count, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetTableSizeByIdFields(int id) {
        DatagramBase.datagram_get_table_size_by_id.Builder builder = DatagramBase.datagram_get_table_size_by_id.newBuilder();
        builder.setTabid(id);
        DatagramBase.datagram_get_table_size_by_id _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_TABLE_SIZE_BY_ID, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetTableRealSizeByIdFields(int id) {
        DatagramBase.datagram_get_table_real_size_by_id.Builder builder = DatagramBase.datagram_get_table_real_size_by_id.newBuilder();
        builder.setTabid(id);
        DatagramBase.datagram_get_table_real_size_by_id _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_TABLE_REAL_SIZE_BY_ID, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetTableRealSizeByIdRespFields(int ret, int size) {
        DatagramBase.datagram_get_table_real_size_by_id_resp.Builder builderresp = DatagramBase.datagram_get_table_real_size_by_id_resp.newBuilder();
        builderresp.setTabsize(size);
        DatagramBase.datagram_get_table_real_size_by_id_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_TABLE_REAL_SIZE_BY_ID, 0, ret, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetTableSizeByIdRespFields(int ret, int size) {
        DatagramBase.datagram_get_table_size_by_id_resp.Builder builderresp = DatagramBase.datagram_get_table_size_by_id_resp.newBuilder();
        builderresp.setTabsize(size);
        DatagramBase.datagram_get_table_size_by_id_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_TABLE_SIZE_BY_ID, 0, ret, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetTableSizeByNameFields(String name) throws UnsupportedEncodingException {
        DatagramBase.datagram_get_table_size_by_name.Builder builder = DatagramBase.datagram_get_table_size_by_name.newBuilder();
        ByteString names = ByteString.copyFrom(name.getBytes("gbk"));
        builder.setName(names);
        builder.setLen(names.size());
        DatagramBase.datagram_get_table_size_by_name _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_TABLE_SIZE_BY_NAME, 1, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetTableSizeByNameRespFields(int ret, int cnt) throws UnsupportedEncodingException {
        DatagramBase.datagram_get_table_size_by_name_resp.Builder builderresp = DatagramBase.datagram_get_table_size_by_name_resp.newBuilder();
        DatagramBase.datagram_get_table_size_by_name_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_TABLE_SIZE_BY_NAME, 1, ret, cnt, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetTablePropByIdFields(int id) {
        DatagramBase.datagram_get_table_property_by_id.Builder builder = DatagramBase.datagram_get_table_property_by_id.newBuilder();
        builder.setTabid(id);
        DatagramBase.datagram_get_table_property_by_id _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_TABLE_PROP_BY_ID, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetTablePropByIdRespFields(int ret, String name, String desc, int type) throws UnsupportedEncodingException {
        DatagramBase.datagram_get_table_property_by_id_resp.Builder builderresp = DatagramBase.datagram_get_table_property_by_id_resp.newBuilder();
        ByteString names = ByteString.copyFromUtf8(name);
        ByteString descs = ByteString.copyFromUtf8(desc);
        builderresp.setName(names);
        builderresp.setDesc(descs);
        builderresp.setType(type);
        builderresp.setLen1(names.size());
        builderresp.setLen1(descs.size());
        DatagramBase.datagram_get_table_property_by_id_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_TABLE_PROP_BY_ID, 0, ret, 0, 0, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetTablePropByNameFields(String name) throws UnsupportedEncodingException {
        DatagramBase.datagram_get_table_property_by_name.Builder builder = DatagramBase.datagram_get_table_property_by_name.newBuilder();
        ByteString names = ByteString.copyFromUtf8(name);
        builder.setName(names);
        builder.setLen(names.size());
        DatagramBase.datagram_get_table_property_by_name _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_TABLE_PROP_BY_NAME, 1, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetTablePropByNameRespFields(int ret, int id, int type, String desc) throws UnsupportedEncodingException {
        DatagramBase.datagram_get_table_property_by_name_resp.Builder builderresp = DatagramBase.datagram_get_table_property_by_name_resp.newBuilder();
        ByteString descs = ByteString.copyFromUtf8(desc);
        builderresp.setTabid(id);
        builderresp.setTabid(type);
        builderresp.setDesc(descs);
        builderresp.setLen(descs.size());
        DatagramBase.datagram_get_table_property_by_name_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_TABLE_PROP_BY_NAME, 1, ret, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgInsertPointFields(boolean onsend, RtdbBasePoint[] base, RtdbScanPoint[] scan, RtdbCalcPoint[] calc) throws Exception {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>(500);
        DatagramBase.datagram_insert_point.Builder builder = DatagramBase.datagram_insert_point.newBuilder();
        if (base != null && base[0] != null) {
            ByteString b = ByteString.copyFrom(RtdbBasePoint.basePointToByte(base[0]));
            builder.setBase(b);
        }
        if (scan != null && scan[0] != null) {
            ByteString s = ByteString.copyFrom(RtdbScanPoint.scanPointToByte(scan[0]));
            builder.setScan(s);
        }
        if (calc != null && calc[0] != null) {
            ByteString c = ByteString.copyFrom(RtdbCalcPoint.calcPointToByte(calc[0]));
            builder.setCalc(c);
        }
        DatagramBase.datagram_insert_point _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_INSERT_POINT, 3, 0, 1, 1, bts.length);
        list.addAll(fields);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgInsertMinPointFields(boolean onsend, RtdbBasePoint[] basePtr, RtdbScanPoint[] scanPtr, RtdbMinCalcPoint[] calcPtr) throws Exception {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        DatagramBase.datagram_insert_min_point.Builder builder = DatagramBase.datagram_insert_min_point.newBuilder();
        if (basePtr != null && basePtr[0] != null) {
            ByteString b = ByteString.copyFrom(RtdbBasePoint.basePointToByte(basePtr[0]));
            builder.setBase(b);
        }
        if (scanPtr != null && scanPtr[0] != null) {
            ByteString s = ByteString.copyFrom(RtdbScanPoint.scanPointToByte(scanPtr[0]));
            builder.setScan(s);
        }
        if (calcPtr != null && calcPtr[0] != null) {
            ByteString c = ByteString.copyFrom(RtdbMinCalcPoint.calcMinPointToByte(calcPtr[0]));
            builder.setCalc(c);
        }
        DatagramBase.datagram_insert_min_point _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_INSERT_MIN_POINT, 3, 0, 1, 1, bts.length);
        list.addAll(fields);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgInsetMinPointRespFields(int ret, int id) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        DatagramBase.datagram_insert_min_point_resp.Builder builder = DatagramBase.datagram_insert_min_point_resp.newBuilder();
        builder.setId(id);
        DatagramBase.datagram_insert_min_point_resp _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_INSERT_MIN_POINT, 0, ret, 0, 1, bts.length);
        list.addAll(fields);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgInsertMaxPointFields(boolean onsend, RtdbBasePoint[] basePtr, RtdbScanPoint[] scanPtr, RtdbMaxCalcPoint[] calc) throws Exception {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        DatagramBase.datagram_insert_max_point.Builder builder = DatagramBase.datagram_insert_max_point.newBuilder();
        if (basePtr != null && basePtr[0] != null) {
            ByteString b = ByteString.copyFrom(RtdbBasePoint.basePointToByte(basePtr[0]));
            builder.setBase(b);
        }
        if (scanPtr != null && scanPtr[0] != null) {
            ByteString s = ByteString.copyFrom(RtdbScanPoint.scanPointToByte(scanPtr[0]));
            builder.setScan(s);
        }
        if (calc != null && calc[0] != null) {
            ByteString c = ByteString.copyFrom(RtdbMaxCalcPoint.calcMaxPointToByte(calc[0]));
            builder.setCalc(c);
        }
        DatagramBase.datagram_insert_max_point _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_INSERT_MAX_POINT, 3, 0, 1, 1, bts.length);
        list.addAll(fields);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgInsetMaxPointRespFields(int ret, int id) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        DatagramBase.datagram_insert_max_point_resp.Builder builder = DatagramBase.datagram_insert_max_point_resp.newBuilder();
        builder.setId(id);
        DatagramBase.datagram_insert_max_point_resp _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_INSERT_MAX_POINT, 0, ret, 0, 1, bts.length);
        list.addAll(fields);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgInsertPointRespFields(int ret, int id) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        DatagramBase.datagram_insert_point_resp.Builder builder = DatagramBase.datagram_insert_point_resp.newBuilder();
        builder.setId(id);
        DatagramBase.datagram_insert_point_resp _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_INSERT_POINT, 0, ret, 0, 1, bts.length);
        list.addAll(fields);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgInsertBasePointFields(String tag, RtdbType type, int table, boolean ms) throws UnsupportedEncodingException {
        DatagramBase.datagram_insert_base_point.Builder builder = DatagramBase.datagram_insert_base_point.newBuilder();
        ByteString tags = ByteString.copyFromUtf8(tag);
        builder.setTag(tags);
        builder.setType(type.getNum());
        builder.setLen(tags.size());
        builder.setMs((short)(ms ? 1 : 0));
        builder.setTabid(table);
        DatagramBase.datagram_insert_base_point _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_INSERT_BASE_POINT, 1, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgInsertBasePointRespFields(int ret, int id) throws UnsupportedEncodingException {
        DatagramBase.datagram_insert_base_point_resp.Builder builderresp = DatagramBase.datagram_insert_base_point_resp.newBuilder();
        builderresp.setId(id);
        DatagramBase.datagram_insert_base_point_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_INSERT_BASE_POINT, 0, ret, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgRemovePointByIdFields(int id) {
        DatagramBase.datagram_remove_point_by_id.Builder builder = DatagramBase.datagram_remove_point_by_id.newBuilder();
        builder.setId(id);
        DatagramBase.datagram_remove_point_by_id _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_REMOVE_POINT_BY_ID, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgRemovePointByIdRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_REMOVE_POINT_BY_ID, 0, ret);
    }

    @Override
    public List<RtdbField> msgRemovePointByNameFields(String name) throws UnsupportedEncodingException {
        DatagramBase.datagram_remove_point_by_name.Builder builder = DatagramBase.datagram_remove_point_by_name.newBuilder();
        ByteString names = ByteString.copyFromUtf8(name);
        builder.setName(names);
        builder.setLen(names.size());
        DatagramBase.datagram_remove_point_by_name _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_REMOVE_POINT_BY_NAME, 1, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgRemovePointByNameRespFields(int ret) throws UnsupportedEncodingException {
        return this.msgCommonRespFields(RtdbMsgID.MSG_REMOVE_POINT_BY_NAME, 0, ret);
    }

    @Override
    public List<RtdbField> msgGetPointsPropFields(int count, int[] ids) {
        DatagramBase.datagram_get_points_property.Builder builder = DatagramBase.datagram_get_points_property.newBuilder();
        ArrayList<Integer> idslist = new ArrayList<Integer>(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            idslist.add(ids[i]);
        }
        builder.addAllIds(idslist);
        DatagramBase.datagram_get_points_property _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_POINTS_PROP, 1, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetPointsPropRespFields(boolean onsend, int ret, int count, int size, RtdbBasePoint[] base, RtdbScanPoint[] scan, RtdbCalcPoint[] calc, int[] errors) throws Exception {
        DatagramBase.datagram_get_points_property_resp.Builder buider = DatagramBase.datagram_get_points_property_resp.newBuilder();
        DatagramBase.datagram_get_points_property_resp build = buider.build();
        byte[] bts = build.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_POINTS_PROP, 3, ret, count, size, 0);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetMaxPointsPropField(int count, int[] ids) {
        DatagramBase.datagram_get_max_points_property.Builder builder = DatagramBase.datagram_get_max_points_property.newBuilder();
        ArrayList<Integer> idslist = new ArrayList<Integer>(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            idslist.add(ids[i]);
        }
        builder.addAllIds(idslist);
        DatagramBase.datagram_get_max_points_property _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_MAX_POINTS_PROP, 1, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetMaxPointsPropRespField(boolean onsend, int ret, int count, int size, RtdbBasePoint[] base, RtdbScanPoint[] scan, RtdbMaxCalcPoint[] calc, int[] errors) throws Exception {
        DatagramBase.datagram_get_max_points_property_resp.Builder buider = DatagramBase.datagram_get_max_points_property_resp.newBuilder();
        DatagramBase.datagram_get_max_points_property_resp build = buider.build();
        byte[] bts = build.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_MAX_POINTS_PROP, 3, ret, count, size, 0);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgSearchFields(String tag, String table, String desc, String unit, String src, String instr, RtdbSearchSort sort, int count) throws UnsupportedEncodingException {
        DatagramBase.datagram_search.Builder builder = DatagramBase.datagram_search.newBuilder();
        byte[] tags = tag.getBytes();
        byte[] tables = table.getBytes();
        byte[] descs = desc.getBytes();
        byte[] units = unit.getBytes();
        byte[] srcs = src.getBytes();
        byte[] instrs = instr.getBytes();
        ByteString ctag = ByteString.copyFrom(tags);
        ByteString ctable = ByteString.copyFrom(tables);
        ByteString cdesc = ByteString.copyFrom(descs);
        ByteString cunit = ByteString.copyFrom(units);
        ByteString csrc = ByteString.copyFrom(srcs);
        ByteString cinstr = ByteString.copyFrom(instrs);
        builder.setTag(ctag);
        builder.setLen1(ctag.size());
        builder.setTable(ctable);
        builder.setLen2(ctable.size());
        builder.setDesc(cdesc);
        builder.setLen3(cdesc.size());
        builder.setUnit(cunit);
        builder.setLen4(cunit.size());
        builder.setSource(csrc);
        builder.setLen5(csrc.size());
        builder.setInstrument(cinstr);
        builder.setLen6(cinstr.size());
        builder.setSort(sort.getNum());
        DatagramBase.datagram_search _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_SEARCH, 1, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgSearchRespFields(int ret, int count, int[] ids) throws UnsupportedEncodingException {
        DatagramBase.datagram_search_resp.Builder builderresp = DatagramBase.datagram_search_resp.newBuilder();
        ArrayList<Integer> idslist = new ArrayList<Integer>(ids.length);
        for (int id : ids) {
            idslist.add(id);
        }
        builderresp.addAllIds(idslist);
        DatagramBase.datagram_search_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_SEARCH, 1, ret, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgSearchInBatchesFields(int start, String tag, String table, String desc, String unit, String src, String instr, RtdbSearchSort sort, int count) throws UnsupportedEncodingException {
        DatagramBase.datagram_search_in_batches.Builder builder = DatagramBase.datagram_search_in_batches.newBuilder();
        byte[] ta = tag.getBytes();
        byte[] tab = table.getBytes();
        byte[] de = desc.getBytes();
        byte[] un = unit.getBytes();
        byte[] sr = src.getBytes();
        byte[] in = instr.getBytes();
        ByteString tags = ByteString.copyFrom(ta);
        ByteString tables = ByteString.copyFrom(tab);
        ByteString descs = ByteString.copyFrom(de);
        ByteString units = ByteString.copyFrom(un);
        ByteString srcs = ByteString.copyFrom(sr);
        ByteString instrs = ByteString.copyFrom(in);
        builder.setStart(start);
        builder.setTag(tags);
        builder.setLen1(tags.size());
        builder.setTable(tables);
        builder.setLen2(tables.size());
        builder.setDesc(descs);
        builder.setLen3(descs.size());
        builder.setUnit(units);
        builder.setLen4(units.size());
        builder.setSource(srcs);
        builder.setLen5(srcs.size());
        builder.setInstrument(instrs);
        builder.setLen6(instrs.size());
        builder.setSort(sort.getNum());
        DatagramBase.datagram_search_in_batches _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_SEARCH_IN_BATCHES, 1, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgSearchInBatchesRespFields(int ret, int count, int[] ids) throws UnsupportedEncodingException {
        DatagramBase.datagram_search_in_batches_resp.Builder builderresp = DatagramBase.datagram_search_in_batches_resp.newBuilder();
        ArrayList idslist = new ArrayList(ids.length);
        builderresp.addAllIds(idslist);
        DatagramBase.datagram_search_in_batches_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_SEARCH_IN_BATCHES, 0, ret, count, count, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgSearchRecycledFields(String tag, String full, String desc, String unit, String src, String instr, RtdbSearchSort sort, int count) throws UnsupportedEncodingException {
        DatagramBase.datagram_search_recycled_points.Builder builder = DatagramBase.datagram_search_recycled_points.newBuilder();
        byte[] ta = tag.getBytes();
        byte[] fu = full.getBytes();
        byte[] de = desc.getBytes();
        byte[] un = unit.getBytes();
        byte[] in = instr.getBytes();
        byte[] sr = src.getBytes();
        ByteString tags = ByteString.copyFrom(ta);
        ByteString fulls = ByteString.copyFrom(fu);
        ByteString descs = ByteString.copyFrom(de);
        ByteString units = ByteString.copyFrom(un);
        ByteString instrs = ByteString.copyFrom(in);
        ByteString srcs = ByteString.copyFrom(sr);
        builder.setTag(tags);
        builder.setLen1(tags.size());
        builder.setFull(fulls);
        builder.setLen2(fulls.size());
        builder.setDesc(descs);
        builder.setLen3(descs.size());
        builder.setUnit(units);
        builder.setLen4(units.size());
        builder.setSource(srcs);
        builder.setLen5(srcs.size());
        builder.setInstrument(instrs);
        builder.setLen6(instrs.size());
        DatagramBase.datagram_search_recycled_points _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_SEARCH_RECYCLED, 1, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgSearchRecycledRespFields(int ret, int count, int[] ids) throws UnsupportedEncodingException {
        DatagramBase.datagram_search_recycled_points_resp.Builder builderresp = DatagramBase.datagram_search_recycled_points_resp.newBuilder();
        ArrayList idslist = new ArrayList(ids.length);
        builderresp.addAllIds(idslist);
        DatagramBase.datagram_search_recycled_points_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_SEARCH_RECYCLED, 0, ret, count, count, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgSearchRecycledInBatchesFields(int start, String tag, String full, String desc, String unit, String src, String instr, RtdbSearchSort sort, int count) throws UnsupportedEncodingException {
        DatagramBase.datagram_search_recycled_in_batches.Builder builder = DatagramBase.datagram_search_recycled_in_batches.newBuilder();
        byte[] ta = tag.getBytes();
        byte[] fu = full.getBytes();
        byte[] de = desc.getBytes();
        byte[] un = unit.getBytes();
        byte[] in = instr.getBytes();
        byte[] sr = src.getBytes();
        ByteString tags = ByteString.copyFrom(ta);
        ByteString fulls = ByteString.copyFrom(fu);
        ByteString descs = ByteString.copyFrom(de);
        ByteString units = ByteString.copyFrom(un);
        ByteString instrs = ByteString.copyFrom(in);
        ByteString srcs = ByteString.copyFrom(sr);
        builder.setStart(start);
        builder.setTag(tags);
        builder.setLen1(tags.size());
        builder.setFull(fulls);
        builder.setLen2(fulls.size());
        builder.setDesc(descs);
        builder.setLen3(descs.size());
        builder.setUnit(units);
        builder.setLen4(units.size());
        builder.setSource(srcs);
        builder.setLen5(srcs.size());
        builder.setInstrument(instrs);
        builder.setLen6(instrs.size());
        builder.setSort(sort.getNum());
        DatagramBase.datagram_search_recycled_in_batches _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_SEARCH_RECYCLED_IN_BATCHES, 1, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgSearchRecycledInBatchesRespFields(int ret, int count, int[] ids) throws UnsupportedEncodingException {
        DatagramBase.datagram_search_recycled_in_batches_resp.Builder builderresp = DatagramBase.datagram_search_recycled_in_batches_resp.newBuilder();
        ArrayList idslist = new ArrayList(ids.length);
        builderresp.addAllIds(idslist);
        DatagramBase.datagram_search_recycled_in_batches_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_SEARCH_RECYCLED_IN_BATCHES, 0, ret, count, count, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgRemoveTableByIdFields(int id) {
        DatagramBase.datagram_remove_table_by_id.Builder builder = DatagramBase.datagram_remove_table_by_id.newBuilder();
        builder.setId(id);
        DatagramBase.datagram_remove_table_by_id _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_REMOVE_TABLE_BY_ID, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgRemoveTableByIdRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_REMOVE_TABLE_BY_ID, 0, ret);
    }

    @Override
    public List<RtdbField> msgRemoveTableByNameFields(String name) throws UnsupportedEncodingException {
        DatagramBase.datagram_remove_table_by_name.Builder builder = DatagramBase.datagram_remove_table_by_name.newBuilder();
        byte[] bytes = name.getBytes();
        ByteString names = ByteString.copyFrom(bytes);
        builder.setName(names);
        builder.setLen(names.size());
        DatagramBase.datagram_remove_table_by_name _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_REMOVE_TABLE_BY_NAME, 1, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgRemoveTableByNameRespFields(int ret) throws UnsupportedEncodingException {
        DatagramBase.datagram_remove_table_by_name_resp.Builder builderresp = DatagramBase.datagram_remove_table_by_name_resp.newBuilder();
        DatagramBase.datagram_remove_table_by_name_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_REMOVE_TABLE_BY_NAME, 0, 0, 0, 0, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgUpdatePointPropFields(boolean onsend, RtdbBasePoint[] base, RtdbScanPoint[] scan, RtdbCalcPoint[] calc) throws Exception {
        DatagramBase.datagram_update_point_property.Builder builder = DatagramBase.datagram_update_point_property.newBuilder();
        if (base != null && base[0] != null) {
            ByteString b = ByteString.copyFrom(RtdbBasePoint.basePointToByte(base[0]));
            builder.setBase(b);
        }
        if (scan != null && scan[0] != null) {
            ByteString s = ByteString.copyFrom(RtdbScanPoint.scanPointToByte(scan[0]));
            builder.setScan(s);
        }
        if (calc != null && calc[0] != null) {
            ByteString c = ByteString.copyFrom(RtdbCalcPoint.calcPointToByte(calc[0]));
            builder.setCalc(c);
        }
        DatagramBase.datagram_update_point_property _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_UPDATE_POINT_PROP, 3, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgUpdatePointPropRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_UPDATE_POINT_PROP, 0, ret);
    }

    @Override
    public List<RtdbField> msgFindPointsFields(int count, String[] names) throws UnsupportedEncodingException {
        DatagramBase.datagram_find_points.Builder builder = DatagramBase.datagram_find_points.newBuilder();
        ArrayList<ByteString> nameslist = new ArrayList<ByteString>();
        ArrayList<Integer> lens = new ArrayList<Integer>();
        for (int i = 0; i < names.length; ++i) {
            ByteString str = ByteString.copyFrom(names[i] + "\u0000", "GBK");
            nameslist.add(str);
            lens.add(str.size());
        }
        builder.addAllLens(lens);
        builder.addAllNames(nameslist);
        DatagramBase.datagram_find_points _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_FIND_POINTS, 1, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgFindPointsRespFields(int ret, int count, int size, int[] ids, int[] types, int[] classofs, short[] ms) {
        DatagramBase.datagram_find_points_resp.Builder builderresp = DatagramBase.datagram_find_points_resp.newBuilder();
        DatagramBase.datagram_find_points_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_FIND_POINTS, 0, 0, 0, 0, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgSortPointsFields(int count, int[] ids, RtdbTagFieldIndex index, int flag) {
        DatagramBase.datagram_sort_points.Builder builder = DatagramBase.datagram_sort_points.newBuilder();
        for (int i = 0; i < ids.length; ++i) {
            builder.addIds(ids[i]);
        }
        builder.setIndex(index.getNum());
        builder.setFlag(flag);
        DatagramBase.datagram_sort_points _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_SORT_POINTS, 1, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgSortPointsRespFields(int ret, int count, int[] ids) {
        DatagramBase.datagram_sort_points_resp.Builder builderresp = DatagramBase.datagram_sort_points_resp.newBuilder();
        for (int i = 0; i < ids.length; ++i) {
            builderresp.addIds(ids[i]);
        }
        DatagramBase.datagram_sort_points_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_SORT_POINTS, 1, ret, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgUpdateTableNameFields(int id, String name) throws UnsupportedEncodingException {
        DatagramBase.datagram_update_table_name.Builder builder = DatagramBase.datagram_update_table_name.newBuilder();
        ByteString names = ByteString.copyFromUtf8(name);
        builder.setTabid(id);
        builder.setName(names);
        builder.setLen(names.size());
        DatagramBase.datagram_update_table_name _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_UPDATE_TABLE_NAME, 1, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgUpdateTableNameRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_UPDATE_TABLE_NAME, 0, ret);
    }

    @Override
    public List<RtdbField> msgUpdateTableDescByIdFields(int id, String desc) throws UnsupportedEncodingException {
        DatagramBase.datagram_update_table_desc_by_id.Builder builder = DatagramBase.datagram_update_table_desc_by_id.newBuilder();
        byte[] bytes = desc.getBytes();
        ByteString copyFrom = ByteString.copyFrom(bytes);
        builder.setTabid(id);
        builder.setDesc(copyFrom);
        builder.setLen(copyFrom.size());
        DatagramBase.datagram_update_table_desc_by_id _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_UPDATE_TABLE_DESC_BY_ID, 1, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgUpdateTableDescByIdRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_UPDATE_TABLE_DESC_BY_ID, 0, ret);
    }

    @Override
    public List<RtdbField> msgUpdateTableDescByNameFields(String name, String desc) throws UnsupportedEncodingException {
        DatagramBase.datagram_update_table_desc_by_name.Builder builder = DatagramBase.datagram_update_table_desc_by_name.newBuilder();
        byte[] names = name.getBytes();
        byte[] descs = desc.getBytes();
        ByteString copyName = ByteString.copyFrom(names);
        ByteString copyDesc = ByteString.copyFrom(descs);
        builder.setName(copyName);
        builder.setDesc(copyDesc);
        builder.setLen1(copyName.size());
        builder.setLen2(copyDesc.size());
        DatagramBase.datagram_update_table_desc_by_name _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_UPDATE_TABLE_DESC_BY_NAME, 1, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgUpdateTableDescByNameRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_UPDATE_TABLE_DESC_BY_NAME, 0, ret);
    }

    @Override
    public List<RtdbField> msgRecoverPointFields(int tabid, int tagid) {
        DatagramBase.datagram_recover_point.Builder builder = DatagramBase.datagram_recover_point.newBuilder();
        builder.setTabid(tabid);
        builder.setPointid(tagid);
        DatagramBase.datagram_recover_point _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_RECOVER_POINT, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgRecoverPointRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_RECOVER_POINT, 0, ret);
    }

    @Override
    public List<RtdbField> msgPurgePointFields(int id) {
        DatagramBase.datagram_purge_point.Builder builder = DatagramBase.datagram_purge_point.newBuilder();
        builder.setId(id);
        DatagramBase.datagram_purge_point _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_PURGE_POINT, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgPurgePointRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_PURGE_POINT, 0, ret);
    }

    @Override
    public List<RtdbField> msgGetRecycledPointsCountFields() {
        return this.msgCommonFields(RtdbMsgID.MSG_GET_RECYCLED_POINTS_COUNT, 0);
    }

    @Override
    public List<RtdbField> msgGetRecycledPointsCountRespFields(int ret, int count) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_GET_RECYCLED_POINTS_COUNT, 0, ret);
    }

    @Override
    public List<RtdbField> msgGetRecycledPointsFields(int count) {
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_RECYCLED_POINTS, 0, 0, count, 1, 0);
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetRecycledPointsRespFields(int ret, int count, int[] ids) {
        DatagramBase.datagram_get_recycled_points_resp.Builder builderresp = DatagramBase.datagram_get_recycled_points_resp.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>();
        for (int id : ids) {
            listIds.add(id);
        }
        builderresp.addAllIds(listIds);
        DatagramBase.datagram_get_recycled_points_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_RECYCLED_POINTS, 0, ret, count, count, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetRecycledPointPropFields(int id) {
        DatagramBase.datagram_get_recycled_point_property.Builder builder = DatagramBase.datagram_get_recycled_point_property.newBuilder();
        builder.setId(id);
        DatagramBase.datagram_get_recycled_point_property _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_RECYCLED_POINT_PROP, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetRecycledMaxPointPropFields(int id) {
        DatagramBase.datagram_get_recycled_max_point_property.Builder builder = DatagramBase.datagram_get_recycled_max_point_property.newBuilder();
        builder.setId(id);
        DatagramBase.datagram_get_recycled_max_point_property _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_RECYCLED_MAX_POINT_PROP, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetRecycledMaxPointPropRespFields(boolean onsend, int ret, RtdbBasePoint basePoint, RtdbScanPoint scanPoint, RtdbMaxCalcPoint calc) throws Exception {
        DatagramBase.datagram_get_recycled_max_point_property_resp.Builder builderresp = DatagramBase.datagram_get_recycled_max_point_property_resp.newBuilder();
        if (basePoint != null) {
            ByteString b = ByteString.copyFrom(RtdbBasePoint.basePointToByte(basePoint));
            builderresp.setBase(b);
        }
        if (scanPoint != null) {
            ByteString s = ByteString.copyFrom(RtdbScanPoint.scanPointToByte(scanPoint));
            builderresp.setScan(s);
        }
        if (calc != null) {
            ByteString c = ByteString.copyFrom(RtdbMaxCalcPoint.calcMaxPointToByte(calc));
            builderresp.setCalc(c);
        }
        DatagramBase.datagram_get_recycled_max_point_property_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_RECYCLED_MAX_POINT_PROP, 3, ret, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetRecycledPointPropRespFields(boolean onsend, int ret, RtdbBasePoint base, RtdbScanPoint scan, RtdbCalcPoint calc) throws Exception {
        DatagramBase.datagram_get_recycled_point_property_resp.Builder builderresp = DatagramBase.datagram_get_recycled_point_property_resp.newBuilder();
        if (base != null) {
            ByteString b = ByteString.copyFrom(RtdbBasePoint.basePointToByte(base));
            builderresp.setBase(b);
        }
        if (scan != null) {
            ByteString s = ByteString.copyFrom(RtdbScanPoint.scanPointToByte(scan));
            builderresp.setScan(s);
        }
        if (calc != null) {
            ByteString c = ByteString.copyFrom(RtdbCalcPoint.calcPointToByte(calc));
            builderresp.setCalc(c);
        }
        DatagramBase.datagram_get_recycled_point_property_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_RECYCLED_POINT_PROP, 3, ret, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgClearRecyclerFields() {
        return this.msgCommonFields(RtdbMsgID.MSG_CLEAR_RECYCLER, 0);
    }

    @Override
    public List<RtdbField> msgClearRecyclerRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_CLEAR_RECYCLER, 0, ret);
    }

    @Override
    public List<RtdbField> msgSubscribeTagsFields() {
        return this.msgCommonFields(RtdbMsgID.MSG_SUBSCRIBE_TAGS, 1);
    }

    @Override
    public List<RtdbField> msgSubscribeTagsRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_SUBSCRIBE_TAGS, 1, ret);
    }

    @Override
    public List<RtdbField> msgCancelSubscribeTagsFields() {
        return this.msgCommonFields(RtdbMsgID.MSG_CANCEL_SUBSCRIBE_TAGS, 0);
    }

    @Override
    public List<RtdbField> msgGetPeriodsPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_periods_prpperty.Builder builder = DatagramBaseLoad.datagram_get_periods_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length);
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_periods_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_PERIODS_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetPeriodsPropRespFields(int[] periods, int[] errors) {
        DatagramBaseLoad.datagram_get_periods_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_periods_prpperty_resp.newBuilder();
        ArrayList<Integer> listPeriod = new ArrayList<Integer>(periods.length);
        for (int period : periods) {
            listPeriod.add(period);
        }
        builderresp.addAllPeriods(listPeriod);
        ArrayList<Integer> listErrors = new ArrayList<Integer>(errors.length);
        for (int error : errors) {
            listErrors.add(error);
        }
        builderresp.addAllErrors(listErrors);
        DatagramBaseLoad.datagram_get_periods_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_PERIODS_PROP, 0, 0, periods.length, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetTimecopysPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_timecopys_prpperty.Builder builder = DatagramBaseLoad.datagram_get_timecopys_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length);
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_timecopys_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_TIMECOPYS_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetTimecopysPropRespFields(int ret, int count, int size, byte[] timecopys, int[] errors) {
        DatagramBaseLoad.datagram_get_timecopys_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_timecopys_prpperty_resp.newBuilder();
        ArrayList listPeriod = new ArrayList();
        builderresp.addAllTimecopys(listPeriod);
        ArrayList<Integer> listErrors = new ArrayList<Integer>(errors.length);
        for (int error : errors) {
            listErrors.add(error);
        }
        builderresp.addAllErrors(listErrors);
        DatagramBaseLoad.datagram_get_timecopys_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_TIMECOPYS_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetTriggersPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_triggers_prpperty.Builder builder = DatagramBaseLoad.datagram_get_triggers_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length);
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_triggers_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_TRIGGERS_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<RtdbField> msgGetTriggersPropRespFields(int ret, int count, int size, byte[] triggers, int[] errors) {
        DatagramBaseLoad.datagram_get_triggers_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_triggers_prpperty_resp.newBuilder();
        ArrayList<Integer> triggerslist = new ArrayList<Integer>();
        if (triggers.length != 0) {
            for (byte by : triggers) {
                triggerslist.add(Integer.valueOf(by));
            }
        }
        builderresp.addAllTriggers(triggerslist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            void var11_16;
            int[] nArray = errors;
            int n = nArray.length;
            boolean bl = false;
            while (var11_16 < n) {
                int er = nArray[var11_16];
                errorslist.add(er);
                ++var11_16;
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_triggers_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_GET_TRIGGERS_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetEquationsPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_equations_prpperty.Builder builder = DatagramBaseLoad.datagram_get_equations_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length);
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_equations_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_EQUATIONS_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetEquationsPropRespFields(int ret, int count, int size, short[] lens, String[] equations, int[] errors) throws UnsupportedEncodingException {
        DatagramBaseLoad.datagram_get_equations_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_equations_prpperty_resp.newBuilder();
        if (equations.length != 0) {
            for (int i = 0; i < equations.length; ++i) {
                if (equations[i] == null || equations[i].length() <= 0) continue;
                ByteString byteString = ByteString.copyFrom(equations[i], "GBK");
                builderresp.setEquations(i, byteString);
            }
        }
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            for (int er : errors) {
                errorslist.add(er);
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_equations_prpperty_resp datagram_get_equations_prpperty_resp2 = builderresp.build();
        byte[] bts = datagram_get_equations_prpperty_resp2.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_EQUATIONS_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetExcdevpercentsFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_excdevpercents_prpperty.Builder builder = DatagramBaseLoad.datagram_get_excdevpercents_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length);
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_excdevpercents_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_EXCDEVPERCENTS_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetExcdevpercentsRespFields(int ret, int count, int size, float[] excdevPercents, int[] errors) throws UnsupportedEncodingException {
        DatagramBaseLoad.datagram_get_excdevpercents_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_excdevpercents_prpperty_resp.newBuilder();
        ArrayList<Float> excdevPercentslist = new ArrayList<Float>();
        if (excdevPercents.length != 0) {
            for (float ex : excdevPercents) {
                excdevPercentslist.add(Float.valueOf(ex));
            }
        }
        builderresp.addAllExcdevpercents(excdevPercentslist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            for (int er : errors) {
                errorslist.add(er);
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_excdevpercents_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_EXCDEVPERCENTS_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetUserReal1sPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_userreal1s_prpperty.Builder builder = DatagramBaseLoad.datagram_get_userreal1s_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length);
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_userreal1s_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_USERREAL1S_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetUserReal1sPropRespFields(int ret, int count, int size, float[] userReal1s, int[] errors) {
        DatagramBaseLoad.datagram_get_userreal1s_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_userreal1s_prpperty_resp.newBuilder();
        ArrayList<Float> userReal1slist = new ArrayList<Float>();
        if (userReal1s.length != 0) {
            for (float user : userReal1s) {
                userReal1slist.add(Float.valueOf(user));
            }
        }
        builderresp.addAllUserreal1S(userReal1slist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            for (int er : errors) {
                errorslist.add(er);
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_userreal1s_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_USERREAL1S_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetUserReal2sPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_userreal2s_prpperty.Builder builder = DatagramBaseLoad.datagram_get_userreal2s_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length);
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_userreal2s_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_USERREAL2S_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetUserReal2sPropRespFields(int ret, int count, int size, float[] userReal2s, int[] errors) {
        DatagramBaseLoad.datagram_get_userreal2s_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_userreal2s_prpperty_resp.newBuilder();
        ArrayList<Float> userReal1slist = new ArrayList<Float>();
        if (userReal2s.length != 0) {
            for (float user : userReal2s) {
                userReal1slist.add(Float.valueOf(user));
            }
        }
        builderresp.addAllUserreal2S(userReal1slist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            for (int er : errors) {
                errorslist.add(er);
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_userreal2s_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_USERREAL2S_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetUserInt1sPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_userint1s_prpperty.Builder builder = DatagramBaseLoad.datagram_get_userint1s_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length);
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_userint1s_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_USERINT1S_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetUserInt1sPropRespFields(int ret, int count, int size, int[] userInt1s, int[] errors) {
        DatagramBaseLoad.datagram_get_userint1s_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_userint1s_prpperty_resp.newBuilder();
        ArrayList<Integer> userInt1slist = new ArrayList<Integer>();
        if (userInt1s.length != 0) {
            for (int user : userInt1s) {
                userInt1slist.add(user);
            }
        }
        builderresp.addAllUserint1S(userInt1slist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            for (int er : errors) {
                errorslist.add(er);
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_userint1s_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_USERINT1S_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetUserInt2sFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_userint2s_prpperty.Builder builder = DatagramBaseLoad.datagram_get_userint2s_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length);
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_userint2s_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_USERINT2S_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetUserInt2sPropRespFields(int ret, int count, int size, int[] userInt2s, int[] errors) {
        DatagramBaseLoad.datagram_get_userint2s_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_userint2s_prpperty_resp.newBuilder();
        ArrayList<Integer> userInt2slist = new ArrayList<Integer>();
        if (userInt2s.length != 0) {
            for (int user : userInt2s) {
                userInt2slist.add(user);
            }
        }
        builderresp.addAllUserint2S(userInt2slist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            for (int er : errors) {
                errorslist.add(er);
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_userint2s_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_USERINT2S_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetLocation1sPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_location1s_prpperty.Builder builder = DatagramBaseLoad.datagram_get_location1s_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length);
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_location1s_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_LOCATION1S_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetLocation1sPropRespFields(int ret, int count, int size, int[] locations, int[] errors) {
        DatagramBaseLoad.datagram_get_location1s_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_location1s_prpperty_resp.newBuilder();
        ArrayList<Integer> locationslist = new ArrayList<Integer>();
        if (locations.length != 0) {
            for (int er : locations) {
                locationslist.add(er);
            }
        }
        builderresp.addAllLocation1S(locationslist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            for (int er : errors) {
                errorslist.add(er);
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_location1s_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_LOCATION1S_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetLocation2sPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_location2s_prpperty.Builder builder = DatagramBaseLoad.datagram_get_location2s_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length);
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_location2s_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_LOCATION2S_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetLocation2sPropRespFields(int ret, int count, int size, int[] locations, int[] errors) {
        DatagramBaseLoad.datagram_get_location2s_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_location2s_prpperty_resp.newBuilder();
        ArrayList<Integer> locationslist = new ArrayList<Integer>();
        if (locations.length != 0) {
            for (int er : locations) {
                locationslist.add(er);
            }
        }
        builderresp.addAllLocation2S(locationslist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            for (int er : errors) {
                errorslist.add(er);
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_location2s_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_LOCATION2S_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetLocation3sPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_location3s_prpperty.Builder builder = DatagramBaseLoad.datagram_get_location3s_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length);
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_location3s_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_LOCATION3S_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetLocation3sPropRespFields(int ret, int count, int size, int[] locations, int[] errors) {
        DatagramBaseLoad.datagram_get_location3s_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_location3s_prpperty_resp.newBuilder();
        ArrayList<Integer> locationslist = new ArrayList<Integer>();
        if (locations.length != 0) {
            for (int er : locations) {
                locationslist.add(er);
            }
        }
        builderresp.addAllLocation3S(locationslist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            for (int er : errors) {
                errorslist.add(er);
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_location3s_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_LOCATION3S_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetLocation4sPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_location4s_prpperty.Builder builder = DatagramBaseLoad.datagram_get_location4s_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length);
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_location4s_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_LOCATION4S_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetLocation4sPropRespFields(int ret, int count, int size, int[] locations, int[] errors) {
        DatagramBaseLoad.datagram_get_location4s_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_location4s_prpperty_resp.newBuilder();
        ArrayList<Integer> locationslist = new ArrayList<Integer>();
        if (locations.length != 0) {
            for (int er : locations) {
                locationslist.add(er);
            }
        }
        builderresp.addAllLocation4S(locationslist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            for (int er : errors) {
                errorslist.add(er);
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_location4s_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_LOCATION4S_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetLocation5sPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_location5s_prpperty.Builder builder = DatagramBaseLoad.datagram_get_location5s_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length);
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_location5s_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_LOCATION5S_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetLocation5sPropRespFields(int ret, int count, int size, int[] locations, int[] errors) {
        DatagramBaseLoad.datagram_get_location5s_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_location5s_prpperty_resp.newBuilder();
        ArrayList<Integer> locationslist = new ArrayList<Integer>();
        if (locations.length != 0) {
            for (int er : locations) {
                locationslist.add(er);
            }
        }
        builderresp.addAllLocation5S(locationslist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            for (int er : errors) {
                errorslist.add(er);
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_location5s_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_LOCATION5S_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetScansPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_scans_prpperty.Builder builder = DatagramBaseLoad.datagram_get_scans_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length);
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_scans_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_SCANS_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<RtdbField> msgGetScansPropRespFields(int ret, int count, int size, byte[] scans, int[] errors) throws UnsupportedEncodingException {
        DatagramBaseLoad.datagram_get_scans_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_scans_prpperty_resp.newBuilder();
        ArrayList<Integer> scanslist = new ArrayList<Integer>();
        if (scans.length != 0) {
            for (byte by : scans) {
                scanslist.add(Integer.valueOf(by));
            }
        }
        builderresp.addAllScans(scanslist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            void var11_16;
            int[] nArray = errors;
            int n = nArray.length;
            boolean bl = false;
            while (var11_16 < n) {
                int er = nArray[var11_16];
                errorslist.add(er);
                ++var11_16;
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_scans_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_GET_SCANS_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetInstrumentsPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_instruments_prpperty.Builder builder = DatagramBaseLoad.datagram_get_instruments_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length);
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_instruments_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_INSTRUMENTS_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetInstrumentsPropRespFields(int ret, int count, int size, short[] lens, String[] instruments, int[] errors) throws UnsupportedEncodingException {
        DatagramBaseLoad.datagram_get_instruments_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_instruments_prpperty_resp.newBuilder();
        ArrayList<ByteString> instrumentslist = new ArrayList<ByteString>();
        if (instruments.length != 0) {
            for (String er : instruments) {
                if (er == null || er.length() <= 0) continue;
                instrumentslist.add(ByteString.copyFrom(er, "GBK"));
            }
        }
        builderresp.addAllInstruments(instrumentslist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            for (int er : errors) {
                errorslist.add(er);
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_instruments_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_INSTRUMENTS_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetSourcesPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_sources_prpperty.Builder builder = DatagramBaseLoad.datagram_get_sources_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length);
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_sources_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_SOURCES_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetSourcesPropRespFields(int ret, int count, int size, short[] lens, String[] sources, int[] errors) throws UnsupportedEncodingException {
        DatagramBaseLoad.datagram_get_sources_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_sources_prpperty_resp.newBuilder();
        ArrayList<ByteString> sourceslist = new ArrayList<ByteString>();
        if (sources.length != 0) {
            for (String er : sources) {
                if (er == null || er.length() <= 0) continue;
                sourceslist.add(ByteString.copyFrom(er, "GBK"));
            }
        }
        builderresp.addAllSources(sourceslist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            for (int er : errors) {
                errorslist.add(er);
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_sources_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_SOURCES_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetCompdevPercentsFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_compdevpercents_prpperty.Builder builder = DatagramBaseLoad.datagram_get_compdevpercents_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length);
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_compdevpercents_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_COMPDEVPERCENTS_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetCompdevPercentsPropRespFields(int ret, int count, int size, float[] compdevPercents, int[] errors) throws UnsupportedEncodingException {
        DatagramBaseLoad.datagram_get_compdevpercents_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_compdevpercents_prpperty_resp.newBuilder();
        ArrayList<Float> compdevPercentslist = new ArrayList<Float>();
        if (compdevPercents.length != 0) {
            for (float er : compdevPercents) {
                compdevPercentslist.add(Float.valueOf(er));
            }
        }
        builderresp.addAllCompdevpercents(compdevPercentslist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            for (int er : errors) {
                errorslist.add(er);
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_compdevpercents_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_COMPDEVPERCENTS_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetDigitsPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_digits_prpperty.Builder builder = DatagramBaseLoad.datagram_get_digits_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length);
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_digits_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_DIGITS_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<RtdbField> msgGetDigitsPropRespFields(int ret, int count, int size, short[] digits, int[] errors) throws UnsupportedEncodingException {
        DatagramBaseLoad.datagram_get_digits_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_digits_prpperty_resp.newBuilder();
        ArrayList<Integer> digitslist = new ArrayList<Integer>();
        if (digits.length != 0) {
            for (short s : digits) {
                digitslist.add(Integer.valueOf(s));
            }
        }
        builderresp.addAllDigits(digitslist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            void var11_16;
            int[] nArray = errors;
            int n = nArray.length;
            boolean bl = false;
            while (var11_16 < n) {
                int er = nArray[var11_16];
                errorslist.add(er);
                ++var11_16;
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_digits_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_GET_DIGITS_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetChangeDatesPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_changedates_prpperty.Builder builder = DatagramBaseLoad.datagram_get_changedates_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length);
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_changedates_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_CHANGEDATES_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetChangeDatesPropRespFields(int ret, int count, int size, int[] changeDates, int[] errors) throws UnsupportedEncodingException {
        DatagramBaseLoad.datagram_get_changedates_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_changedates_prpperty_resp.newBuilder();
        ArrayList<Integer> changeDateslist = new ArrayList<Integer>();
        if (changeDates.length != 0) {
            for (int er : changeDates) {
                changeDateslist.add(er);
            }
        }
        builderresp.addAllChangedates(changeDateslist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            for (int er : errors) {
                errorslist.add(er);
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_changedates_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_CHANGEDATES_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetTypicalsPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_typicals_prpperty.Builder builder = DatagramBaseLoad.datagram_get_typicals_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length);
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_typicals_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_TYPICALS_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetTypicalsPropRespFields(int ret, int count, int size, float[] typicals, int[] errors) throws UnsupportedEncodingException {
        DatagramBaseLoad.datagram_get_typicals_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_typicals_prpperty_resp.newBuilder();
        ArrayList<Float> typicalslist = new ArrayList<Float>();
        if (typicals.length != 0) {
            for (float er : typicals) {
                typicalslist.add(Float.valueOf(er));
            }
        }
        builderresp.addAllTypicals(typicalslist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            for (int er : errors) {
                errorslist.add(er);
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_typicals_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_TYPICALS_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetCreatedatesPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_createdates_prpperty.Builder builder = DatagramBaseLoad.datagram_get_createdates_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length);
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_createdates_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_CREATEDATES_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetCreateDatesPropRespFields(int ret, int count, int size, int[] createDates, int[] errors) throws UnsupportedEncodingException {
        DatagramBaseLoad.datagram_get_createdates_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_createdates_prpperty_resp.newBuilder();
        ArrayList<Integer> createDateslist = new ArrayList<Integer>();
        if (createDates.length != 0) {
            for (int er : createDates) {
                createDateslist.add(er);
            }
        }
        builderresp.addAllCreatedates(createDateslist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            for (int er : errors) {
                errorslist.add(er);
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_createdates_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_CREATEDATES_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetHighlimitsPropLimits(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_highlimits_prpperty.Builder builder = DatagramBaseLoad.datagram_get_highlimits_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length);
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_highlimits_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_HIGHLIMITS_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetHighLimitsRespFields(int ret, int count, int size, float[] highlimits, int[] errors) throws UnsupportedEncodingException {
        DatagramBaseLoad.datagram_get_highlimits_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_highlimits_prpperty_resp.newBuilder();
        ArrayList<Float> highlimitslist = new ArrayList<Float>();
        if (highlimits.length != 0) {
            for (float er : highlimits) {
                highlimitslist.add(Float.valueOf(er));
            }
        }
        builderresp.addAllHighlimits(highlimitslist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            for (int er : errors) {
                errorslist.add(er);
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_highlimits_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_HIGHLIMITS_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetLowLimitsPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_lowlimits_prpperty.Builder builder = DatagramBaseLoad.datagram_get_lowlimits_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length);
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_lowlimits_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_LOWLIMITS_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetLowLimitsPropRespFields(int ret, int count, int size, float[] lowlimits, int[] errors) throws UnsupportedEncodingException {
        DatagramBaseLoad.datagram_get_lowlimits_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_lowlimits_prpperty_resp.newBuilder();
        ArrayList<Float> lowlimitslist = new ArrayList<Float>();
        if (lowlimits.length != 0) {
            for (float er : lowlimits) {
                lowlimitslist.add(Float.valueOf(er));
            }
        }
        builderresp.addAllLowlimits(lowlimitslist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            for (int er : errors) {
                errorslist.add(er);
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_lowlimits_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_LOWLIMITS_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetCreatorsPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_creators_prpperty.Builder builder = DatagramBaseLoad.datagram_get_creators_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length);
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_creators_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_CREATORS_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetCreatorsPropRespFields(int ret, int count, int size, short[] lens, String[] creators, int[] errors) throws UnsupportedEncodingException {
        DatagramBaseLoad.datagram_get_creators_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_creators_prpperty_resp.newBuilder();
        ArrayList<ByteString> creatorslist = new ArrayList<ByteString>();
        if (creators.length != 0) {
            for (String er : creators) {
                if (er == null || er.length() <= 0) continue;
                creatorslist.add(ByteString.copyFrom(er, "GBK"));
            }
        }
        builderresp.addAllCreators(creatorslist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            for (int er : errors) {
                errorslist.add(er);
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_creators_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_CREATORS_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetChangersPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_changers_prpperty.Builder builder = DatagramBaseLoad.datagram_get_changers_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>();
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_changers_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_CHANGERS_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetChangersPropRespFields(int ret, int count, int size, short[] lens, String[] changers, int[] errors) throws UnsupportedEncodingException {
        DatagramBaseLoad.datagram_get_changers_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_changers_prpperty_resp.newBuilder();
        ArrayList<ByteString> listchangers = new ArrayList<ByteString>();
        for (String changer : changers) {
            if (changer == null || changer.length() <= 0) continue;
            listchangers.add(ByteString.copyFrom(changer, "GBK"));
        }
        builderresp.addAllChangers(listchangers);
        ArrayList<Integer> listErrors = new ArrayList<Integer>();
        for (int error : errors) {
            listErrors.add(error);
        }
        builderresp.addAllErrors(listErrors);
        DatagramBaseLoad.datagram_get_changers_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_CHANGERS_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetUnitsPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_units_prpperty.Builder builder = DatagramBaseLoad.datagram_get_units_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>();
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_units_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_UNITS_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetUnitsPropRespFields(int ret, int count, int size, short[] lens, String[] units, int[] errors) throws UnsupportedEncodingException {
        DatagramBaseLoad.datagram_get_units_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_units_prpperty_resp.newBuilder();
        ArrayList<ByteString> unitslist = new ArrayList<ByteString>();
        if (units.length != 0) {
            for (String er : units) {
                if (er == null || er.length() <= 0) continue;
                unitslist.add(ByteString.copyFrom(er, "GBK"));
            }
        }
        builderresp.addAllUnits(unitslist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            for (int er : errors) {
                errorslist.add(er);
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_units_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_UNITS_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetDescsPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_descs_prpperty.Builder builder = DatagramBaseLoad.datagram_get_descs_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>();
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_descs_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_DESCS_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetDescsPropRespFields(int ret, int count, int size, short[] lens, String[] descs, int[] errors) throws UnsupportedEncodingException {
        DatagramBaseLoad.datagram_get_descs_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_descs_prpperty_resp.newBuilder();
        ArrayList<ByteString> descslist = new ArrayList<ByteString>();
        if (descs.length != 0) {
            for (String er : descs) {
                if (er == null || er.length() <= 0) continue;
                descslist.add(ByteString.copyFrom(er, "GBK"));
            }
        }
        builderresp.addAllDescs(descslist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            for (int er : errors) {
                errorslist.add(er);
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_descs_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_DESCS_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetTableDotTagsPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_dot_tags_prpperty.Builder builder = DatagramBaseLoad.datagram_get_dot_tags_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>();
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_dot_tags_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_TABLE_DOT_TAGS_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetTableDotTagsPropRespFields(int ret, int count, int size, short[] lens, String[] tableDotTags, int[] errors) throws UnsupportedEncodingException {
        DatagramBaseLoad.datagram_get_dot_tags_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_dot_tags_prpperty_resp.newBuilder();
        ArrayList<ByteString> tableDotTagslist = new ArrayList<ByteString>();
        if (tableDotTags.length != 0) {
            for (String er : tableDotTags) {
                if (er == null || er.length() <= 0) continue;
                tableDotTagslist.add(ByteString.copyFrom(er, "GBK"));
            }
        }
        builderresp.addAllDotTags(tableDotTagslist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            for (int er : errors) {
                errorslist.add(er);
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_dot_tags_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_TABLE_DOT_TAGS_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetArchivesPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_archives_prpperty.Builder builder = DatagramBaseLoad.datagram_get_archives_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>();
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_archives_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_ARCHIVES_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<RtdbField> msgGetArchivesPropRespFields(int ret, int count, int size, byte[] archives, int[] errors) throws UnsupportedEncodingException {
        DatagramBaseLoad.datagram_get_archives_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_archives_prpperty_resp.newBuilder();
        ArrayList<Integer> archiveslist = new ArrayList<Integer>();
        if (archives.length != 0) {
            for (byte by : archives) {
                archiveslist.add(Integer.valueOf(by));
            }
        }
        builderresp.addAllArchives(archiveslist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            void var11_16;
            int[] nArray = errors;
            int n = nArray.length;
            boolean bl = false;
            while (var11_16 < n) {
                int er = nArray[var11_16];
                errorslist.add(er);
                ++var11_16;
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_archives_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_GET_ARCHIVES_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetShutDownsPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_shutdowns_prpperty.Builder builder = DatagramBaseLoad.datagram_get_shutdowns_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>();
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_shutdowns_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_SHUTDOWNS_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<RtdbField> msgGetShutDownsPropRespFields(int ret, int count, int size, byte[] shutdowns, int[] errors) throws UnsupportedEncodingException {
        DatagramBaseLoad.datagram_get_shutdowns_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_shutdowns_prpperty_resp.newBuilder();
        ArrayList<Integer> shutdownslist = new ArrayList<Integer>();
        if (shutdowns.length != 0) {
            for (byte by : shutdowns) {
                shutdownslist.add(Integer.valueOf(by));
            }
        }
        builderresp.addAllShutdowns(shutdownslist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            void var11_16;
            int[] nArray = errors;
            int n = nArray.length;
            boolean bl = false;
            while (var11_16 < n) {
                int er = nArray[var11_16];
                errorslist.add(er);
                ++var11_16;
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_shutdowns_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_GET_SHUTDOWNS_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetStepsPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_steps_prpperty.Builder builder = DatagramBaseLoad.datagram_get_steps_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>();
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_steps_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_STEPS_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<RtdbField> msgGetStepsPropRespFields(int ret, int count, int size, byte[] steps, int[] errors) throws UnsupportedEncodingException {
        DatagramBaseLoad.datagram_get_steps_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_steps_prpperty_resp.newBuilder();
        ArrayList<Integer> stepslist = new ArrayList<Integer>();
        if (steps.length != 0) {
            for (byte by : steps) {
                stepslist.add(Integer.valueOf(by));
            }
        }
        builderresp.addAllSteps(stepslist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            void var11_16;
            int[] nArray = errors;
            int n = nArray.length;
            boolean bl = false;
            while (var11_16 < n) {
                int er = nArray[var11_16];
                errorslist.add(er);
                ++var11_16;
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_steps_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_GET_STEPS_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetCompressPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_compress_prpperty.Builder builder = DatagramBaseLoad.datagram_get_compress_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>();
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_compress_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_COMPRESS_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<RtdbField> msgGetCompressPropRespFields(int ret, int count, int size, byte[] compresses, int[] errors) throws UnsupportedEncodingException {
        DatagramBaseLoad.datagram_get_compress_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_compress_prpperty_resp.newBuilder();
        ArrayList<Integer> compresseslist = new ArrayList<Integer>();
        if (compresses.length != 0) {
            for (byte by : compresses) {
                compresseslist.add(Integer.valueOf(by));
            }
        }
        builderresp.addAllCompress(compresseslist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            void var11_16;
            int[] nArray = errors;
            int n = nArray.length;
            boolean bl = false;
            while (var11_16 < n) {
                int er = nArray[var11_16];
                errorslist.add(er);
                ++var11_16;
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_compress_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_GET_COMPRESS_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetMirrorsPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_mirrors_prpperty.Builder builder = DatagramBaseLoad.datagram_get_mirrors_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>();
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_mirrors_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_MIRRORS_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<RtdbField> msgGetMirrorsPropRespFields(int ret, int count, int size, byte[] mirrors, int[] errors) throws UnsupportedEncodingException {
        DatagramBaseLoad.datagram_get_mirrors_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_mirrors_prpperty_resp.newBuilder();
        ArrayList<Integer> mirrorslist = new ArrayList<Integer>();
        if (mirrors.length != 0) {
            for (byte by : mirrors) {
                mirrorslist.add(Integer.valueOf(by));
            }
        }
        builderresp.addAllMirrors(mirrorslist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            void var11_16;
            int[] nArray = errors;
            int n = nArray.length;
            boolean bl = false;
            while (var11_16 < n) {
                int er = nArray[var11_16];
                errorslist.add(er);
                ++var11_16;
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_mirrors_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_GET_MIRRORS_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetSummarysPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_summarys_prpperty.Builder builder = DatagramBaseLoad.datagram_get_summarys_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>();
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_summarys_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_SUMMARYS_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<RtdbField> msgGetSummaysPropRespFields(int ret, int count, int size, byte[] summarys, int[] errors) throws UnsupportedEncodingException {
        DatagramBaseLoad.datagram_get_summarys_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_summarys_prpperty_resp.newBuilder();
        ArrayList<Integer> summaryslist = new ArrayList<Integer>();
        if (summarys.length != 0) {
            for (byte by : summarys) {
                summaryslist.add(Integer.valueOf(by));
            }
        }
        builderresp.addAllSummarys(summaryslist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            void var11_16;
            int[] nArray = errors;
            int n = nArray.length;
            boolean bl = false;
            while (var11_16 < n) {
                int er = nArray[var11_16];
                errorslist.add(er);
                ++var11_16;
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_summarys_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_GET_SUMMARYS_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetTablesPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_tables_prpperty.Builder builder = DatagramBaseLoad.datagram_get_tables_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>();
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_tables_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_TABLES_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<RtdbField> msgGetTablesPropRespFields(int ret, int count, int size, short[] tablesIds, int[] errors) throws UnsupportedEncodingException {
        DatagramBaseLoad.datagram_get_tables_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_tables_prpperty_resp.newBuilder();
        ArrayList<Integer> tablesIdslist = new ArrayList<Integer>();
        if (tablesIds.length != 0) {
            for (short s : tablesIds) {
                tablesIdslist.add(Integer.valueOf(s));
            }
        }
        builderresp.addAllTables(tablesIdslist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            void var11_16;
            int[] nArray = errors;
            int n = nArray.length;
            boolean bl = false;
            while (var11_16 < n) {
                int er = nArray[var11_16];
                errorslist.add(er);
                ++var11_16;
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_tables_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_GET_TABLES_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetClassofsPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_classofs_prpperty.Builder builder = DatagramBaseLoad.datagram_get_classofs_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>();
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_classofs_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_CLASSOFS_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<RtdbField> msgGetClassofsPropRespFields(int ret, int count, int size, byte[] classofs, int[] errors) throws UnsupportedEncodingException {
        DatagramBaseLoad.datagram_get_classofs_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_classofs_prpperty_resp.newBuilder();
        ArrayList<Integer> classofslist = new ArrayList<Integer>();
        if (classofs.length != 0) {
            for (byte by : classofs) {
                classofslist.add(Integer.valueOf(by));
            }
        }
        builderresp.addAllClassofs(classofslist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            void var11_16;
            int[] nArray = errors;
            int n = nArray.length;
            boolean bl = false;
            while (var11_16 < n) {
                int er = nArray[var11_16];
                errorslist.add(er);
                ++var11_16;
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_classofs_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_GET_CLASSOFS_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetExcminsPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_excmins_prpperty.Builder builder = DatagramBaseLoad.datagram_get_excmins_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>();
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_excmins_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_EXCMINS_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetExcminsPropRespFields(int ret, int count, int size, int[] excmins, int[] errors) throws UnsupportedEncodingException {
        DatagramBaseLoad.datagram_get_excmins_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_excmins_prpperty_resp.newBuilder();
        ArrayList<Integer> excminslist = new ArrayList<Integer>();
        if (excmins.length != 0) {
            for (int er : excmins) {
                excminslist.add(er);
            }
        }
        builderresp.addAllExcmins(excminslist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            for (int er : errors) {
                errorslist.add(er);
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_excmins_prpperty_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_EXCMINS_PROP, 0, ret, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgSubscribeNamedTypeRemoveCallBackFields(int ret, String name) throws UnsupportedEncodingException {
        DatagramBase.datagram_subscribe_named_type_remove_callback.Builder builderresp = DatagramBase.datagram_subscribe_named_type_remove_callback.newBuilder();
        DatagramBase.datagram_subscribe_named_type_remove_callback _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_SUBSCRIBE_NAMED_TYPE_REMOVE_CALLBACK, 4, ret, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgCreateNamedTypeFields(String name, String desc, int count, NamedDataTypeField[] fds) throws UnsupportedEncodingException, Exception {
        DatagramBase.datagram_create_named_type.Builder builder = DatagramBase.datagram_create_named_type.newBuilder();
        ByteString names = ByteString.copyFrom(name, "GBK");
        ByteString descs = ByteString.copyFrom(desc, "GBK");
        builder.setName(names);
        builder.setLen1(names.size());
        builder.setDesc(descs);
        builder.setLen2(descs.size());
        ArrayList<ByteString> bsFdsList = new ArrayList<ByteString>();
        for (int i = 0; i < fds.length; ++i) {
            ByteString fd = ByteString.copyFrom(NamedDataTypeField.namedDataTypeFieldToByte(fds[i]));
            bsFdsList.add(fd);
        }
        builder.addAllFields(bsFdsList);
        DatagramBase.datagram_create_named_type _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_CREATE_NAMED_TYPE, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgCreateNamedTypeRespFields(int ret, int count) throws UnsupportedEncodingException {
        DatagramBase.datagram_create_named_type_resp.Builder builderresp = DatagramBase.datagram_create_named_type_resp.newBuilder();
        DatagramBase.datagram_create_named_type_resp _packet = builderresp.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_CREATE_NAMED_TYPE, 0, ret, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetEquationByFileName(String filename) throws UnsupportedEncodingException {
        DatagramBase.datagram_get_equation_by_file_name.Builder build = DatagramBase.datagram_get_equation_by_file_name.newBuilder();
        ByteString names = ByteString.copyFrom(filename, "GBK");
        build.setFilename(names);
        build.setLen(names.size());
        DatagramBase.datagram_get_equation_by_file_name _packet = build.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_EQUATION_BY_FILE_NAME, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetEquationByFileNameResp(String filename) {
        DatagramBase.datagram_get_equation_by_file_name_resp.Builder builder = DatagramBase.datagram_get_equation_by_file_name_resp.newBuilder();
        DatagramBase.datagram_get_equation_by_file_name_resp build = builder.build();
        byte[] byteArray = build.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_EQUATION_BY_FILE_NAME, 0, 0, 0, 1, byteArray.length);
        this.msgAddBytes(fields, byteArray, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetEquationById(int id) {
        DatagramBase.datagram_get_equation_by_id.Builder builder = DatagramBase.datagram_get_equation_by_id.newBuilder();
        builder.setId(id);
        DatagramBase.datagram_get_equation_by_id _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_EQUATION_BY_ID, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetEquationByIdResp(int id) {
        DatagramBase.datagram_get_equation_by_id_resp.Builder builder = DatagramBase.datagram_get_equation_by_id_resp.newBuilder();
        DatagramBase.datagram_get_equation_by_id_resp _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_EQUATION_BY_ID, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetTagsPropFields(int[] ids, int count) {
        DatagramBaseLoad.datagram_get_tags_prpperty.Builder builder = DatagramBaseLoad.datagram_get_tags_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>();
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_tags_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_TAGS_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetTagsPropRespFields(int count, short[] lens, String[] tags, int[] errors) throws UnsupportedEncodingException {
        DatagramBaseLoad.datagram_get_tags_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_tags_prpperty_resp.newBuilder();
        ArrayList<ByteString> listtags = new ArrayList<ByteString>();
        for (String tag : tags) {
            if (tag == null || tag.length() <= 0) continue;
            listtags.add(ByteString.copyFrom(tag, "GBK"));
        }
        builderresp.addAllTags(listtags);
        ArrayList<Integer> listErrors = new ArrayList<Integer>();
        for (int error : errors) {
            listErrors.add(error);
        }
        builderresp.addAllErrors(listErrors);
        DatagramBaseLoad.datagram_get_tags_prpperty_resp _packets = builderresp.build();
        byte[] btss = _packets.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_TAGS_PROP, 0, 0, count, 1, btss.length);
        this.msgAddBytes(fields, btss, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetMsPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_ms_prpperty.Builder builder = DatagramBaseLoad.datagram_get_ms_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length);
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_ms_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_MS_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<RtdbField> msgGetMsPropRespFields(int count, byte[] ms, int[] errors) {
        DatagramBaseLoad.datagram_get_ms_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_ms_prpperty_resp.newBuilder();
        ArrayList<Integer> mslist = new ArrayList<Integer>();
        if (ms.length != 0) {
            for (byte by : ms) {
                mslist.add(Integer.valueOf(by));
            }
        }
        builderresp.addAllMiiliseconds(mslist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            void var9_14;
            int[] nArray = errors;
            int n = nArray.length;
            boolean bl = false;
            while (var9_14 < n) {
                int er = nArray[var9_14];
                errorslist.add(er);
                ++var9_14;
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_ms_prpperty_resp _packets = builderresp.build();
        byte[] btss = _packets.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_GET_MS_PROP, 0, 0, count, 1, btss.length);
        this.msgAddBytes(list, btss, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetTypesPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_types_prpperty.Builder builder = DatagramBaseLoad.datagram_get_types_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length);
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_types_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_TYPES_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetTypesPropRespFields(int count, int[] types, int[] errors) {
        DatagramBaseLoad.datagram_get_types_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_types_prpperty_resp.newBuilder();
        ArrayList<Integer> typeslist = new ArrayList<Integer>();
        if (types.length != 0) {
            for (int er : types) {
                typeslist.add(er);
            }
        }
        builderresp.addAllTypes(typeslist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            for (int er : errors) {
                errorslist.add(er);
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_types_prpperty_resp _packets = builderresp.build();
        byte[] btss = _packets.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_TYPES_PROP, 0, 0, count, 1, btss.length);
        this.msgAddBytes(fields, btss, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetCompdevsPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_compdevs_prpperty.Builder builder = DatagramBaseLoad.datagram_get_compdevs_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length);
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_compdevs_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_COMPDEVS_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetCompdevsPropRespFields(int count, float[] compdevs, int[] errors) {
        DatagramBaseLoad.datagram_get_compdevs_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_compdevs_prpperty_resp.newBuilder();
        ArrayList compdevslist = new ArrayList();
        builderresp.addAllCompdevs(compdevslist);
        ArrayList errorslist = new ArrayList();
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_compdevs_prpperty_resp _packets = builderresp.build();
        byte[] btss = _packets.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_COMPDEVS_PROP, 0, 0, count, 1, btss.length);
        this.msgAddBytes(fields, btss, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetCompmaxsPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_compmaxs_prpperty.Builder builder = DatagramBaseLoad.datagram_get_compmaxs_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length);
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_compmaxs_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_COMPMAXS_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetCompmaxsPropRespFields(int count, int[] compmaxs, int[] errors) {
        DatagramBaseLoad.datagram_get_compmaxs_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_compmaxs_prpperty_resp.newBuilder();
        ArrayList compmaxslist = new ArrayList();
        builderresp.addAllCompmaxs(compmaxslist);
        DatagramBaseLoad.datagram_get_compmaxs_prpperty_resp _packets = builderresp.build();
        byte[] btss = _packets.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_COMPMAXS_PROP, 0, 0, count, 1, btss.length);
        this.msgAddBytes(fields, btss, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetCompminsPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_compmins_prpperty.Builder builder = DatagramBaseLoad.datagram_get_compmins_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>(ids.length);
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_compmins_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_COMPMINS_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetCompminsPropRespFields(int count, int[] compmins, int[] errors) {
        DatagramBaseLoad.datagram_get_compmins_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_compmins_prpperty_resp.newBuilder();
        ArrayList compminslist = new ArrayList();
        builderresp.addAllCompmins(compminslist);
        ArrayList<Integer> errorslist = new ArrayList<Integer>();
        if (errors.length != 0) {
            for (int er : errors) {
                errorslist.add(er);
            }
        }
        builderresp.addAllErrors(errorslist);
        DatagramBaseLoad.datagram_get_compmins_prpperty_resp _packets = builderresp.build();
        byte[] btss = _packets.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_COMPMINS_PROP, 0, 0, count, 1, btss.length);
        this.msgAddBytes(fields, btss, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetExcdevsPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_excdevs_prpperty.Builder builder = DatagramBaseLoad.datagram_get_excdevs_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>();
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_excdevs_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_EXCDEVS_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetExcdevsPropRespFields(int count, float[] excdevs, int[] errors) {
        DatagramBaseLoad.datagram_get_excdevs_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_excdevs_prpperty_resp.newBuilder();
        ArrayList listPeriod = new ArrayList();
        builderresp.addAllExcdevs(listPeriod);
        ArrayList<Integer> listErrors = new ArrayList<Integer>();
        for (int error : errors) {
            listErrors.add(error);
        }
        builderresp.addAllErrors(listErrors);
        DatagramBaseLoad.datagram_get_excdevs_prpperty_resp _packets = builderresp.build();
        byte[] btss = _packets.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_EXCDEVS_PROP, 0, 0, count, 1, btss.length);
        this.msgAddBytes(fields, btss, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetExcmaxsPropFields(int count, int[] ids) {
        DatagramBaseLoad.datagram_get_excmaxs_prpperty.Builder builder = DatagramBaseLoad.datagram_get_excmaxs_prpperty.newBuilder();
        ArrayList<Integer> listIds = new ArrayList<Integer>();
        for (int id : ids) {
            listIds.add(id);
        }
        builder.addAllIds(listIds);
        DatagramBaseLoad.datagram_get_excmaxs_prpperty _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_EXCMAXS_PROP, 0, 0, count, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetExcmaxsPropRespFields(int count, int[] excmaxs, int[] errors) {
        DatagramBaseLoad.datagram_get_excmaxs_prpperty_resp.Builder builderresp = DatagramBaseLoad.datagram_get_excmaxs_prpperty_resp.newBuilder();
        ArrayList listPeriod = new ArrayList();
        builderresp.addAllExcmaxs(listPeriod);
        ArrayList<Integer> listErrors = new ArrayList<Integer>();
        for (int error : errors) {
            listErrors.add(error);
        }
        builderresp.addAllErrors(listErrors);
        DatagramBaseLoad.datagram_get_excmaxs_prpperty_resp _packets = builderresp.build();
        byte[] btss = _packets.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_EXCMAXS_PROP, 0, 0, count, 1, btss.length);
        this.msgAddBytes(fields, btss, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }
}

