/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.api.msg;

import com.google.protobuf.ByteString;
import com.rtdb.api.enums.RtdbMsgID;
import com.rtdb.api.enums.RtdbPrivGroup;
import com.rtdb.api.impl.adapter.ServerAdapter;
import com.rtdb.api.model.Login;
import com.rtdb.api.model.NamedDataTypeField;
import com.rtdb.api.model.RtdbCalcPoint;
import com.rtdb.api.model.RtdbField;
import com.rtdb.api.model.RtdbScanPoint;
import com.rtdb.api.protocol.DatagramBase;
import com.rtdb.api.protocol.DatagramServer;
import com.rtdb.api.protocol.DatagramSnapshots;
import com.rtdb.api.util.CodeUtils;
import com.rtdb.api.util.Crc32Util;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class ServerProtocol30
extends ServerAdapter {
    private static ServerProtocol30 serverProtocol = null;

    private ServerProtocol30() {
    }

    public static synchronized ServerProtocol30 getInstance() {
        if (serverProtocol == null) {
            serverProtocol = new ServerProtocol30();
        }
        return serverProtocol;
    }

    @Override
    public List<RtdbField> msgLoginField(Login login) throws UnsupportedEncodingException {
        DatagramServer.datagram_send_login_packet.Builder builder = DatagramServer.datagram_send_login_packet.newBuilder();
        byte[] encodeString = CodeUtils.encodeString(login.getUsername());
        int crc32 = Crc32Util.getCRC32(login.getPassword());
        builder.setPassword(crc32);
        builder.setUserName(ByteString.copyFrom(encodeString));
        DatagramServer.datagram_send_login_packet _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> wFields = this.getMsgHeader2(RtdbMsgID.MSG_LOGIN, 1, 0, 0, 1, bts.length);
        this.msgAddBytes(wFields, bts, "len", "buf_data");
        wFields.add(this.getMsgTail());
        return wFields;
    }

    @Override
    public List<RtdbField> msgLoginRespFields(int ret, int priv) {
        DatagramServer.datagram_send_login_packet_resp.Builder builder = DatagramServer.datagram_send_login_packet_resp.newBuilder();
        builder.setPrivilege(priv);
        DatagramServer.datagram_send_login_packet_resp _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_LOGIN, 0, ret, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgMakeDirFields(String dir) throws UnsupportedEncodingException {
        DatagramServer.datagram_mkdir.Builder builder = DatagramServer.datagram_mkdir.newBuilder();
        ByteString bsDir = ByteString.copyFrom(dir, "GBK");
        builder.setDirictory(bsDir);
        DatagramServer.datagram_mkdir _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_MKDIR, 1, 0, 0, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgMakeDirRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_MKDIR, 0, ret);
    }

    @Override
    public List<RtdbField> msgOpenPathFields(String path) throws UnsupportedEncodingException {
        DatagramServer.datagram_open_path.Builder builder = DatagramServer.datagram_open_path.newBuilder();
        ByteString bsPath = ByteString.copyFrom(path, "GBK");
        builder.setOpenDir(bsPath);
        DatagramServer.datagram_open_path _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_OPEN_PATH, 1, 0, 0, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgOpenPathRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_OPEN_PATH, 0, ret);
    }

    @Override
    public List<RtdbField> msgReadFileFields(String file, int pos, int size) throws UnsupportedEncodingException {
        DatagramServer.datagram_read_file.Builder builder = DatagramServer.datagram_read_file.newBuilder();
        builder.setBeginPostion(pos);
        ByteString fileName = ByteString.copyFrom(file, "GBK");
        builder.setFileName(fileName);
        builder.setReadBytesSize(size);
        DatagramServer.datagram_read_file _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_READ_FILE, 1, 0, size, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgReadFileRespFields(int ret, int len, byte[] content) {
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_READ_FILE, 1, ret, len, 1, 0);
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgReadPathFields() {
        return this.msgCommonFields(RtdbMsgID.MSG_READ_PATH, 0);
    }

    @Override
    public List<RtdbField> msgReadPathRespFields(int ret, String path, int isdir, int at, int ct, int mt, long fieldsize) {
        DatagramServer.datagram_read_path_resp.Builder builder = DatagramServer.datagram_read_path_resp.newBuilder();
        DatagramServer.datagram_read_path_resp build = builder.build();
        byte[] bt = build.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_READ_PATH, 1, ret, 0, 1, 0);
        this.msgAddBytes(list, bt, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgRemoveAuthFields(int addr, int mask) {
        DatagramServer.datagram_remove_authorization.Builder builder = DatagramServer.datagram_remove_authorization.newBuilder();
        builder.setAddress(addr);
        builder.setMask(mask);
        DatagramServer.datagram_remove_authorization _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_REMOVE_AUTHORIZATION, 1, 0, 0, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgRemoveAuthFields(ByteString addr, ByteString mask) {
        DatagramServer.datagram_remove_authorization_ipv6.Builder builder = DatagramServer.datagram_remove_authorization_ipv6.newBuilder();
        builder.setAddress(addr);
        builder.setMask(mask);
        DatagramServer.datagram_remove_authorization_ipv6 _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_REMOVE_AUTHORIZATION, 1, 0, 0, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgRemoveAuthRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_REMOVE_AUTHORIZATION, 0, ret);
    }

    @Override
    public List<RtdbField> msgRemoveBlacklistFields(int addr, int mask) {
        DatagramServer.datagram_remove_blacklist.Builder builder = DatagramServer.datagram_remove_blacklist.newBuilder();
        builder.setAddress(addr);
        builder.setMask(mask);
        DatagramServer.datagram_remove_blacklist _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_REMOVE_BLACKLIST, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgRemoveBlacklistFields(ByteString addr, ByteString mask) {
        DatagramServer.datagram_remove_blacklist_ipv6.Builder builder = DatagramServer.datagram_remove_blacklist_ipv6.newBuilder();
        builder.setAddress(addr);
        builder.setMask(mask);
        DatagramServer.datagram_remove_blacklist_ipv6 _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_REMOVE_BLACKLIST, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgRemoveBlacklistRespRields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_REMOVE_BLACKLIST, 0, ret);
    }

    @Override
    public List<RtdbField> msgRemoveUserFields(String user) throws UnsupportedEncodingException {
        DatagramServer.datagram_remove_user.Builder builder = DatagramServer.datagram_remove_user.newBuilder();
        byte[] encodeString = CodeUtils.encodeString(user);
        builder.setUserName(ByteString.copyFrom(encodeString));
        DatagramServer.datagram_remove_user _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_REMOVE_USER, 1, 0, 0, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgRemoveUserRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_REMOVE_USER, 0, ret);
    }

    @Override
    public List<RtdbField> msgSetDBInfoIntFields(int type, int value) {
        DatagramServer.datagram_set_db_info_int.Builder builder = DatagramServer.datagram_set_db_info_int.newBuilder();
        builder.setIndex(type);
        builder.setValue(value);
        DatagramServer.datagram_set_db_info_int _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_SET_DB_INFO_INT, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgSetDBInfoIntRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_SET_DB_INFO_INT, 0, ret);
    }

    @Override
    public List<RtdbField> msgSetDBInfoStrFields(int type, String str) throws UnsupportedEncodingException {
        DatagramServer.datagram_set_db_info_str.Builder builder = DatagramServer.datagram_set_db_info_str.newBuilder();
        builder.setIndex(type);
        ByteString bsStr = ByteString.copyFromUtf8(str);
        builder.setStringParam(bsStr);
        DatagramServer.datagram_set_db_info_str _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_SET_DB_INFO_STR, 1, 0, 0, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgSetDBInfoStrRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_SET_DB_INFO_STR, 0, ret);
    }

    @Override
    public List<RtdbField> msgSetTimeoutFields(int socket, int timeout) {
        DatagramServer.datagram_set_timeout.Builder builder = DatagramServer.datagram_set_timeout.newBuilder();
        builder.setSocket(socket);
        builder.setTimeout(timeout);
        DatagramServer.datagram_set_timeout _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_SET_TIMEOUT, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgSetTimeoutRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_SET_TIMEOUT, 0, ret);
    }

    @Override
    public synchronized List<RtdbField> msgSubscribeSnapshotsCallbackFields(int ret, int count, int[] ids, int[] datetimes, short[] ms, double[] values, long[] states, short[] qualities, int[] errors) {
        DatagramSnapshots.datagram_subscribe_snapshots_callback.Builder builder = DatagramSnapshots.datagram_subscribe_snapshots_callback.newBuilder();
        DatagramSnapshots.datagram_subscribe_snapshots_callback build = builder.build();
        byte[] bts = build.toByteArray();
        List<RtdbField> list = this.getMsgHeader(RtdbMsgID.MSG_SUBSCRIBE_SNAPSHOTS_CALLBACK, 0, 0, 0, 0);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgSubscribeTagsCallbackFields(int ret, int count, int[] ids, int what) {
        List<RtdbField> list = this.getMsgHeader(RtdbMsgID.MSG_SUBSCRIBE_TAGS_CALLBACK, 1, ret, count, count);
        this.msgAddInt(list, what, "reason");
        this.msgAddIntArray(list, ids, "ids");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgUpdateAuthFields(int addr, int mask, int newAddr, int newMask, RtdbPrivGroup priv, String desc) throws UnsupportedEncodingException {
        DatagramServer.datagram_update_authorization.Builder builder = DatagramServer.datagram_update_authorization.newBuilder();
        builder.setOldAddress(addr);
        builder.setOldMask(mask);
        builder.setNewAddress(newAddr);
        builder.setNewMask(newMask);
        builder.setPrivilege(priv.getNum());
        ByteString bsDesc = ByteString.copyFrom(desc, "GBK");
        builder.setDescription(bsDesc);
        DatagramServer.datagram_update_authorization _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_UPDATE_AUTHORIZATION, 1, 0, 0, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgUpdateAuthFields(ByteString addr, ByteString mask, ByteString newAddr, ByteString newMask, RtdbPrivGroup priv, String desc) throws UnsupportedEncodingException {
        DatagramServer.datagram_update_authorization_ipv6.Builder builder = DatagramServer.datagram_update_authorization_ipv6.newBuilder();
        builder.setOldAddress(addr);
        builder.setOldMask(mask);
        builder.setNewAddress(newAddr);
        builder.setNewMask(newMask);
        builder.setPrivilege(priv.getNum());
        ByteString bsDesc = ByteString.copyFrom(desc, "GBK");
        builder.setDescription(bsDesc);
        DatagramServer.datagram_update_authorization_ipv6 _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_UPDATE_AUTHORIZATION, 1, 0, 0, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgUpdateAuthRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_UPDATE_AUTHORIZATION, 0, ret);
    }

    @Override
    public List<RtdbField> msgUpdateBlacklistFields(int addr, int mask, int newAddr, int newMask, String desc) throws UnsupportedEncodingException {
        DatagramServer.datagram_update_blacklist.Builder builder = DatagramServer.datagram_update_blacklist.newBuilder();
        builder.setOldAddress(addr);
        builder.setOldMask(mask);
        builder.setNewAddress(newAddr);
        builder.setNewMask(newMask);
        byte[] encodeString = CodeUtils.encodeString(desc);
        ByteString bsDesc = ByteString.copyFrom(encodeString);
        builder.setDescription(bsDesc);
        DatagramServer.datagram_update_blacklist _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_UPDATE_BLACKLIST, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgUpdateBlacklistFields(ByteString addr, ByteString mask, ByteString newAddr, ByteString newMask, String desc) throws UnsupportedEncodingException {
        DatagramServer.datagram_update_blacklist_ipv6.Builder builder = DatagramServer.datagram_update_blacklist_ipv6.newBuilder();
        builder.setOldAddress(addr);
        builder.setOldMask(mask);
        builder.setNewAddress(newAddr);
        builder.setNewMask(newMask);
        byte[] encodeString = CodeUtils.encodeString(desc);
        ByteString bsDesc = ByteString.copyFrom(encodeString);
        builder.setDescription(bsDesc);
        DatagramServer.datagram_update_blacklist_ipv6 _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_UPDATE_BLACKLIST, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgUpdateBlacklistRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_UPDATE_BLACKLIST, 0, ret);
    }

    @Override
    public List<RtdbField> scanSegmentFields(RtdbScanPoint scan) throws UnsupportedEncodingException {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>(30);
        if (scan != null) {
            this.msgAddString(list, scan.getSource(), "len1", "source");
            this.msgAddShort(list, scan.getScan(), "scan");
            this.msgAddString(list, scan.getInstrument(), "len2", "instrument");
            list.add(new RtdbField(3, 0L, 0.0, scan.getLocation(), 5, "locations"));
            list.add(new RtdbField(3, 0L, 0.0, scan.getUserints(), 2, "userints"));
            list.add(new RtdbField(5, 0L, 0.0, scan.getUserreals(), 2, "userreals"));
        } else {
            this.msgAddEmptyString(list, "len1", "source");
            this.msgAddEmptyPointer(list, 2, "scan");
            this.msgAddEmptyString(list, "len2", "instrument");
            this.msgAddEmptyPointer(list, 3, 5, "locations");
            this.msgAddEmptyPointer(list, 3, 2, "userints");
            this.msgAddEmptyPointer(list, 5, 2, "userreals");
        }
        return list;
    }

    @Override
    public List<RtdbField> namedTypeSegmentFields(NamedDataTypeField namedField) throws UnsupportedEncodingException {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>(30);
        if (namedField != null) {
            this.msgAddString(list, namedField.getFieldName(), "len1", "fieldName");
            this.msgAddInt(list, namedField.getType().ordinal(), "fieldType");
            this.msgAddInt(list, namedField.getLength(), "fieldLength");
            this.msgAddString(list, namedField.getDesc(), "len2", "fieldDesc");
        } else {
            this.msgAddEmptyString(list, "len1", "fieldName");
            this.msgAddEmptyString(list, "len2", "fieldDesc");
        }
        return list;
    }

    @Override
    public List<RtdbField> calcSegmentFields(RtdbCalcPoint calc) throws UnsupportedEncodingException {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>(30);
        if (calc != null) {
            this.msgAddString(list, calc.getEquation(), "len", "equation");
            this.msgAddShort(list, (short)calc.getTrigger().getNum(), "trigger");
            this.msgAddShort(list, (short)calc.getTimecopy().getNum(), "timecopy");
            this.msgAddInt(list, calc.getPeriod(), "period");
        } else {
            this.msgAddEmptyString(list, "len", "equation");
            this.msgAddEmptyPointer(list, 2, "trigger");
            this.msgAddEmptyPointer(list, 2, "timecopy");
            this.msgAddEmptyPointer(list, 3, "period");
        }
        return list;
    }

    @Override
    public List<RtdbField> namedDataTypeSegmentFields(NamedDataTypeField namedDataTypeField) throws UnsupportedEncodingException {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>(30);
        if (namedDataTypeField != null) {
            this.msgAddString(list, namedDataTypeField.getFieldName(), "len1", "fieldName");
            this.msgAddInt(list, namedDataTypeField.getType().getNum(), "fieldType");
            this.msgAddInt(list, namedDataTypeField.getLength(), "fieldLength");
            this.msgAddString(list, namedDataTypeField.getDesc(), "len2", "fieldDesc");
        } else {
            this.msgAddEmptyString(list, "len1", "fieldName");
            this.msgAddEmptyString(list, "len2", "fieldDesc");
        }
        return list;
    }

    @Override
    public List<RtdbField> msgAddUserFields(String user, int pwd, RtdbPrivGroup priv) throws UnsupportedEncodingException {
        DatagramServer.datagram_add_user.Builder builder = DatagramServer.datagram_add_user.newBuilder();
        builder.setPassword(pwd);
        builder.setPrivilege(priv.getNum());
        byte[] bytes = CodeUtils.encodeString(user);
        builder.setUserName(ByteString.copyFrom(bytes));
        DatagramServer.datagram_add_user _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_ADD_USER, 1, 0, 0, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgChangeUSerStata(String user, boolean lock) throws UnsupportedEncodingException {
        DatagramServer.datagram_lock_user.Builder builder = DatagramServer.datagram_lock_user.newBuilder();
        byte[] encodeString = CodeUtils.encodeString(user);
        builder.setUserName(ByteString.copyFrom(encodeString));
        builder.setBLock(lock);
        DatagramServer.datagram_lock_user lockUser = builder.build();
        byte[] bs = lockUser.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_LOCK_USER, 1, 0, 0, 1, bs.length);
        this.msgAddBytes(list, bs, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgAddUserRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_ADD_USER, 0, ret);
    }

    @Override
    public List<RtdbField> msgChangeUSerStataRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_LOCK_USER, 0, ret);
    }

    @Override
    public List<RtdbField> msgChangeMyPwdFields(int oldPwd, int newPwd) {
        DatagramServer.datagram_change_my_password.Builder builder = DatagramServer.datagram_change_my_password.newBuilder();
        builder.setOldPassword(oldPwd);
        builder.setNewPassword(newPwd);
        DatagramServer.datagram_change_my_password _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_CHANGE_MY_PASSWORD, 1, 0, 0, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgChangeMyPwdRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_CHANGE_MY_PASSWORD, 0, ret);
    }

    @Override
    public List<RtdbField> msgChangePrivFields(String user, RtdbPrivGroup priv) throws UnsupportedEncodingException {
        DatagramServer.datagram_change_priv.Builder builder = DatagramServer.datagram_change_priv.newBuilder();
        builder.setPrivilege(priv.getNum());
        byte[] encodeString = CodeUtils.encodeString(user);
        ByteString bsUser = ByteString.copyFrom(encodeString);
        builder.setUserName(bsUser);
        DatagramServer.datagram_change_priv _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_CHANGE_PRIV, 1, 0, 0, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgChangePrivRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_CHANGE_PRIV, 0, ret);
    }

    @Override
    public List<RtdbField> msgChangePwdFields(String user, int password) throws UnsupportedEncodingException {
        DatagramServer.datagram_change_password.Builder builder = DatagramServer.datagram_change_password.newBuilder();
        byte[] encodeString = CodeUtils.encodeString(user);
        ByteString bsUser = ByteString.copyFrom(encodeString);
        builder.setPassword(password);
        builder.setUserName(bsUser);
        DatagramServer.datagram_change_password _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_CHANGE_PASSWORD, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgChangePwdRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_CHANGE_PASSWORD, 0, ret);
    }

    @Override
    public List<RtdbField> msgClosePathFields() {
        return this.msgCommonFields(RtdbMsgID.MSG_CLOSE_PATH, 0);
    }

    @Override
    public List<RtdbField> msgClosePathRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_CLOSE_PATH, 0, ret);
    }

    @Override
    public List<RtdbField> msgConnectCountFields() {
        return this.msgCommonFields(RtdbMsgID.MSG_CONNECT_COUNT, 0);
    }

    @Override
    public List<RtdbField> msgConnectCountRespFields(int ret, int count) {
        List<RtdbField> list = this.getMsgHeader(RtdbMsgID.MSG_CONNECT_COUNT, 0, ret, count, 1);
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgConnectFields(String client, String process, String user) throws UnsupportedEncodingException {
        DatagramServer.datagram_send_connect_packet.Builder builder = DatagramServer.datagram_send_connect_packet.newBuilder();
        builder.setClient(ByteString.copyFrom(client, "GBK"));
        builder.setProccess(ByteString.copyFrom(process, "GBK"));
        builder.setUserName(ByteString.copyFrom(user, "GBK"));
        DatagramServer.datagram_send_connect_packet _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_CONNECT, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgConnectRespFields(int ret, int authorized, int priv) {
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_CONNECT, 0, ret, 0, 1, 0);
        this.msgAddBytes(fields, null, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetOWNConnectFields() {
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_OWN_CONNECTION, 0, 0, 0, 1, 0);
        this.msgAddBytes(fields, null, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetOWNConnectRespFields() {
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_OWN_CONNECTION, 0, 0, 0, 1, 0);
        this.msgAddBytes(fields, null, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetAuthsFields(int count) {
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_GET_AUTHORIZATIONS, 0, 0, count, 1, 0);
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetAuthsRespFields(int ret, int count, int[] addrs, int[] masks, int[] privs, short[] lens, String[] descs) {
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_GET_AUTHORIZATIONS, 3, 0, count, count, 0);
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetBlacklistFields(int count) {
        List<RtdbField> list = this.getMsgHeader(RtdbMsgID.MSG_GET_BLACKLIST, 0, 0, count, 1);
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetBlacklistRespFields(int ret, int count, int[] addrs, int[] masks, short[] lens, String[] descs) {
        byte[] bts = new byte[count];
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_BLACKLIST, 0, ret, count, count, 0);
        this.msgAddBytes(fields, bts, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetConnectInfoFields(int socket) {
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_GET_CONNECTION_INFO_IPV6, 0, 0, socket, 1, 0);
        this.msgAddInt(list, socket, "socket");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetConnectInfoRespFields(int ret, int ip, short port, int job, int job_time, int conn_time, String client, String process, String user) throws UnsupportedEncodingException {
        DatagramServer.datagram_get_connection_info_ipv6_resp.Builder builder = DatagramServer.datagram_get_connection_info_ipv6_resp.newBuilder();
        builder.setIpAddress(ip);
        builder.setPort(port);
        builder.setJob(job);
        builder.setJobTime(job_time);
        builder.setConnectTime(conn_time);
        ByteString bsClient = ByteString.copyFromUtf8(client);
        builder.setClient(bsClient);
        ByteString bsProcess = ByteString.copyFromUtf8(process);
        builder.setProccess(bsProcess);
        ByteString bsUser = ByteString.copyFromUtf8(user);
        builder.setUser(bsUser);
        builder.setIpv6Address(ByteString.copyFrom(new byte[16]));
        DatagramServer.datagram_get_connection_info_ipv6_resp _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_GET_CONNECTION_INFO_IPV6, 2, 0, 0, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetConnectsFields(int count) {
        List<RtdbField> list = this.getMsgHeader(RtdbMsgID.MSG_GET_CONNECTIONS, 0, 0, count, 1);
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetConnectsRespFields(int count, int ids, int[] sockets) {
        DatagramServer.datagram_get_connections_resp.Builder builder = DatagramServer.datagram_get_connections_resp.newBuilder();
        ArrayList<Integer> listSockets = new ArrayList<Integer>(sockets.length);
        for (int i = 0; i < sockets.length; ++i) {
            listSockets.add(sockets[i]);
        }
        builder.addAllSockets(listSockets);
        DatagramServer.datagram_get_connections_resp _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_GET_CONNECTIONS, 0, 0, 0, 0, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetDBInfoIntFields(int type) {
        DatagramServer.datagram_get_db_info_int.Builder builder = DatagramServer.datagram_get_db_info_int.newBuilder();
        builder.setIndex(type);
        DatagramServer.datagram_get_db_info_int _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_GET_DB_INFO_INT, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetDBInfoIntRespFields(int ret, int value) {
        DatagramServer.datagram_get_db_info_int_resp.Builder builder = DatagramServer.datagram_get_db_info_int_resp.newBuilder();
        builder.setValue(value);
        DatagramServer.datagram_get_db_info_int_resp _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_GET_DB_INFO_INT, 0, ret, 0, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetDBInfoStrFields(int size, int type) {
        DatagramServer.datagram_get_db_info_str.Builder builder = DatagramServer.datagram_get_db_info_str.newBuilder();
        builder.setIndex(type);
        builder.setBufferSize(size);
        DatagramServer.datagram_get_db_info_str _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_GET_DB_INFO_STR, 1, 0, size, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetDBInfoStrRespFields(int ret, String str) throws UnsupportedEncodingException {
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_GET_DB_INFO_STR, 1, ret, 0, 1, 0);
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetDriversFields() {
        return this.msgCommonFields(RtdbMsgID.MSG_GET_LOGICAL_DRIVERS, 0);
    }

    @Override
    public List<RtdbField> msgGetDriversRespFields(int ret, String drivers) throws UnsupportedEncodingException {
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_GET_LOGICAL_DRIVERS, 1, ret, 0, 1, 0);
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetFileSizeFields(String file) throws UnsupportedEncodingException {
        DatagramServer.datagram_get_file_size.Builder builder = DatagramServer.datagram_get_file_size.newBuilder();
        ByteString bsFIleName = ByteString.copyFrom(file, "GBK");
        builder.setFileName(bsFIleName);
        DatagramServer.datagram_get_file_size _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_GET_FILE_SIZE, 1, 0, 0, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetFileSizeRespFields(int ret, long filesize) {
        DatagramServer.datagram_get_file_size_resp.Builder builder = DatagramServer.datagram_get_file_size_resp.newBuilder();
        DatagramServer.datagram_get_file_size_resp build = builder.build();
        byte[] bts = build.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_GET_FILE_SIZE, 1, ret, 0, 1, 0);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetMaxBlobLenFields() {
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_MAX_BLOB_LEN, 0, 0, 0, 1, 0);
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetMaxBlobLenRespFields() {
        List<RtdbField> fields = this.getMsgHeader2(RtdbMsgID.MSG_GET_MAX_BLOB_LEN, 0, 0, 0, 1, 0);
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetTimeoutFields(int socket) {
        DatagramServer.datagram_get_timeout.Builder builder = DatagramServer.datagram_get_timeout.newBuilder();
        builder.setSocket(socket);
        DatagramServer.datagram_get_timeout _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_GET_TIMEOUT, 0, 0, 1, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetTimeOutRespFields(int ret, int count) {
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_GET_TIMEOUT, 0, ret, count, 1, 0);
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetUsersFields(int count) {
        List<RtdbField> list = this.getMsgHeader(RtdbMsgID.MSG_GET_USERS, 0, 0, count, 0);
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetUsersRespFields(int ret, int count, String[] users, int[] privs) {
        byte[] bts = new byte[count];
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_GET_USERS, 1, ret, count, count, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgHostTimeFields() {
        return this.msgCommonFields(RtdbMsgID.MSG_HOST_TIME, 0);
    }

    @Override
    public List<RtdbField> msgHostTimeRespFields(int ret, int datatime, int ms) {
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_HOST_TIME, 0, ret, 0, 1, 0);
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgKillConnFields(int socket) {
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_KILL_CONNECTION, 0, 0, 0, 1, 1);
        this.msgAddInt(list, socket, "socket");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgKillConnRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_KILL_CONNECTION, 0, ret);
    }

    @Override
    public List<RtdbField> msgAddAuthFields(int addr, int mask, RtdbPrivGroup priv, String desc) throws UnsupportedEncodingException {
        DatagramServer.datagram_add_authorization.Builder builder = DatagramServer.datagram_add_authorization.newBuilder();
        builder.setAddress(addr);
        builder.setMask(mask);
        builder.setPrivilege(priv.getNum());
        ByteString bsDesc = ByteString.copyFrom(desc, "GBK");
        builder.setDescription(bsDesc);
        DatagramServer.datagram_add_authorization _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_ADD_AUTHORIZATION, 3, 0, 0, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgAddAuthFields(ByteString addr, ByteString mask, RtdbPrivGroup priv, String desc) throws UnsupportedEncodingException {
        DatagramServer.datagram_add_authorization_ipv6.Builder builder = DatagramServer.datagram_add_authorization_ipv6.newBuilder();
        builder.setAddress(addr);
        builder.setMask(mask);
        builder.setPrivilege(priv.getNum());
        ByteString bsDesc = ByteString.copyFrom(desc, "GBK");
        builder.setDescription(bsDesc);
        DatagramServer.datagram_add_authorization_ipv6 _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_ADD_AUTHORIZATION, 3, 0, 0, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgAddAuthRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_ADD_AUTHORIZATION, 0, ret);
    }

    @Override
    public List<RtdbField> msgAddBlacklistFields(int addr, int mask, String desc) throws UnsupportedEncodingException {
        DatagramServer.datagram_add_blacklist.Builder builder = DatagramServer.datagram_add_blacklist.newBuilder();
        builder.setAddress(addr);
        builder.setMask(mask);
        ByteString bsDesc = ByteString.copyFrom(desc, "GBK");
        builder.setDescription(bsDesc);
        DatagramServer.datagram_add_blacklist _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_ADD_BLACKLIST, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgAddBlacklistFields(ByteString addr, ByteString mask, String desc) throws UnsupportedEncodingException {
        DatagramServer.datagram_add_blacklist_ipv6.Builder builder = DatagramServer.datagram_add_blacklist_ipv6.newBuilder();
        builder.setAddress(addr);
        builder.setMask(mask);
        ByteString bsDesc = ByteString.copyFrom(desc, "GBK");
        builder.setDescription(bsDesc);
        DatagramServer.datagram_add_blacklist_ipv6 _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_ADD_BLACKLIST, 0, 0, 0, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgAddBlacklistRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_ADD_BLACKLIST, 0, ret);
    }

    @Override
    public List<RtdbField> msgSubscribeNamedTypeCreateCallBackFields(int ret, String name, int count, NamedDataTypeField[] fds) {
        DatagramBase.datagram_subscribe_named_type_create_callback.Builder builder = DatagramBase.datagram_subscribe_named_type_create_callback.newBuilder();
        DatagramBase.datagram_subscribe_named_type_create_callback _packet = builder.build();
        byte[] bts = _packet.toByteArray();
        List<RtdbField> list = this.getMsgHeader2(RtdbMsgID.MSG_SUBSCRIBE_NAMED_TYPE_CREATE_CALLBACK, 4, ret, count, 1, bts.length);
        this.msgAddBytes(list, bts, "len", "buf_data");
        list.add(this.getMsgTail());
        return list;
    }
}

