/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.service.impl;

import com.rtdb.api.callbackInter.RBTagsChange;
import com.rtdb.api.callbackInter.RBTagsChangeEx;
import com.rtdb.api.enums.Location;
import com.rtdb.api.enums.RTDBClass;
import com.rtdb.api.enums.RtdbSearchSort;
import com.rtdb.api.enums.RtdbTagFieldIndex;
import com.rtdb.api.enums.RtdbType;
import com.rtdb.api.enums.TagLoadMemoryFlag;
import com.rtdb.api.enums.UserIntValue;
import com.rtdb.api.enums.UserRealValue;
import com.rtdb.api.exception.EncodePacketErrorException;
import com.rtdb.api.exception.NoAuthorityException;
import com.rtdb.api.exception.UnexpectedMethodException;
import com.rtdb.api.impl.RtdbBaseImpl;
import com.rtdb.api.inter.IBase;
import com.rtdb.api.model.NamedDataTypeField;
import com.rtdb.api.model.NamedType;
import com.rtdb.api.model.NamedTypeNameToFieldsCount;
import com.rtdb.api.model.NamedTypeNameToFieldsCountBase;
import com.rtdb.api.model.NamedTypePoint;
import com.rtdb.api.model.RtdbBasePoint;
import com.rtdb.api.model.RtdbCalcPoint;
import com.rtdb.api.model.RtdbFullPoint;
import com.rtdb.api.model.RtdbMaxCalcPoint;
import com.rtdb.api.model.RtdbMinCalcPoint;
import com.rtdb.api.model.RtdbScanPoint;
import com.rtdb.api.model.RtdbTable;
import com.rtdb.enums.DataSort;
import com.rtdb.enums.TagSortFlag;
import com.rtdb.enums.TagType;
import com.rtdb.enums.ValueType;
import com.rtdb.model.BasePoint;
import com.rtdb.model.Entity;
import com.rtdb.model.Equation;
import com.rtdb.model.FullPoint;
import com.rtdb.model.MinPoint;
import com.rtdb.model.PointType;
import com.rtdb.model.SearchCondition;
import com.rtdb.model.SearchConditionTotal;
import com.rtdb.model.Table;
import com.rtdb.service.impl.ServerImpl;
import com.rtdb.service.inter.Base;
import com.rtdb.until.RTDBConvert;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BaseImpl
implements Base {
    private ServerImpl server;
    private IBase base;
    private Log log = LogFactory.getLog(BaseImpl.class);

    public BaseImpl(ServerImpl server) throws UnknownHostException, IOException, Exception {
        this.server = server;
        this.base = new RtdbBaseImpl(server);
    }

    @Override
    public void close() throws IOException, InterruptedException {
        this.server.close();
    }

    @Override
    public int appendTable(String tableName, String tableDesc) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        RtdbTable table = this.base.appendTable(new RtdbTable(0, 0, tableName, tableDesc));
        return table.getId();
    }

    @Override
    public int getTableCount() throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        return this.base.getTablesCount();
    }

    @Override
    public int[] getTableIds() throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        int count = this.getTableCount();
        int[] ids = new int[count];
        this.base.getTables(ids);
        return ids;
    }

    @Override
    public int getTableSizeById(int id) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        return this.base.getTableSizeById(id);
    }

    @Override
    public int getTableRealSizeById(int id) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        return this.base.getTableRealSizeById(id);
    }

    @Override
    public int getTableSizeByName(String name) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        return this.base.getTableSizeByName(name);
    }

    @Override
    public Table getTablePropertiesById(int id) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        RtdbTable gt = this.base.getTablePropertyById(id);
        Table table = new Table();
        BeanUtils.copyProperties(table, gt);
        return table;
    }

    @Override
    public Table getTablePropertiesByName(String name) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        RtdbTable gt = this.base.getTablePropertyByName(name);
        Table table = new Table();
        BeanUtils.copyProperties(table, gt);
        return table;
    }

    @Override
    public boolean insertPoint(FullPoint fullPoint) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        BasePoint bp = fullPoint.getBasePoint();
        if (bp.getType().getNum() == ValueType.RTDB_NamedTypeT.getNum()) {
            throw new DatatypeConfigurationException("Unsupported tag_type ! -->  \" ValueType.RTDB_NamedTypeT \"");
        }
        RtdbBasePoint basePoint = RTDBConvert.convertToRtBasePoint(bp);
        RtdbScanPoint rtdbScanPoint = RTDBConvert.convertToRtScanPoint(fullPoint.getScanPoint());
        RtdbCalcPoint rtdbCalcPoint = RTDBConvert.convertToRtCalcPoint(fullPoint.getCalcPoint());
        this.base.insertPoint(basePoint, rtdbScanPoint, rtdbCalcPoint);
        return basePoint.getId() > 0;
    }

    @Override
    public int insertPointReturnId(FullPoint fullPoint) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        BasePoint bp = fullPoint.getBasePoint();
        if (bp.getType().getNum() == ValueType.RTDB_NamedTypeT.getNum()) {
            throw new DatatypeConfigurationException("Unsupported tag_type ! -->  \" ValueType.RTDB_NamedTypeT \"");
        }
        RtdbBasePoint basePoint = RTDBConvert.convertToRtBasePoint(bp);
        RtdbScanPoint rtdbScanPoint = RTDBConvert.convertToRtScanPoint(fullPoint.getScanPoint());
        RtdbCalcPoint rtdbCalcPoint = RTDBConvert.convertToRtCalcPoint(fullPoint.getCalcPoint());
        this.base.insertPoint(basePoint, rtdbScanPoint, rtdbCalcPoint);
        if (basePoint.getId() > 0) {
            return basePoint.getId();
        }
        return 0;
    }

    @Override
    public boolean insertMaxPoint(FullPoint fullPoint) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        BasePoint bp = fullPoint.getBasePoint();
        if (bp.getType().getNum() == ValueType.RTDB_NamedTypeT.getNum()) {
            throw new DatatypeConfigurationException("Unsupported tag_type ! -->  \" ValueType.RTDB_NamedTypeT \"");
        }
        RtdbBasePoint basePoint = RTDBConvert.convertToRtBasePoint(bp);
        RtdbScanPoint rtdbScanPoint = RTDBConvert.convertToRtScanPoint(fullPoint.getScanPoint());
        RtdbMaxCalcPoint maxcalcPoint = RTDBConvert.convertToRtMaxCalcPoint(fullPoint.getMaxCalcPoint());
        this.base.insertMaxPoint(basePoint, rtdbScanPoint, maxcalcPoint);
        return basePoint.getId() > 0;
    }

    @Override
    @Deprecated
    public int InsertMinPoint(MinPoint minPoint) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        return this.base.insertBasePoint(minPoint.getTagName(), ValueType.parseToRtdbType(minPoint.getValueType().getNum()), minPoint.getTableId(), minPoint.getUseMs() == 1);
    }

    @Override
    public int insertMinPoint(MinPoint minPoint) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        return this.base.insertBasePoint(minPoint.getTagName(), ValueType.parseToRtdbType(minPoint.getValueType().getNum()), minPoint.getTableId(), minPoint.getUseMs() == 1);
    }

    @Override
    public boolean removePointById(int id) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        this.base.removePointById(id);
        return true;
    }

    @Override
    public boolean removePointByName(String name) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        this.base.removePointByName(name);
        return true;
    }

    @Override
    public Entity<FullPoint> getPointsProperties(int[] ids) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        int length = ids.length;
        RtdbBasePoint[] basePoint = new RtdbBasePoint[length];
        RtdbScanPoint[] scanPoint = new RtdbScanPoint[length];
        RtdbCalcPoint[] calcPoint = new RtdbCalcPoint[length];
        for (int i = 0; i < ids.length; ++i) {
            basePoint[i] = new RtdbBasePoint();
            scanPoint[i] = new RtdbScanPoint();
            calcPoint[i] = new RtdbCalcPoint();
            basePoint[i].setId(ids[i]);
        }
        int[] errors = new int[length];
        this.base.getPointsProperty(length, basePoint, scanPoint, calcPoint, errors);
        Entity<FullPoint> entity = new Entity<FullPoint>();
        ArrayList<FullPoint> list = new ArrayList<FullPoint>(length);
        FullPoint fullPoint = null;
        String[] nameStrings = this.getTableTagNames(ids);
        for (int i = 0; i < length; ++i) {
            basePoint[i].setTable_dot_tag(nameStrings[i]);
            fullPoint = new FullPoint();
            fullPoint.setBasePoint(RTDBConvert.convertToBasePoint(basePoint[i]));
            fullPoint.setScanPoint(RTDBConvert.convertToScanPoint(scanPoint[i]));
            fullPoint.setCalcPoint(RTDBConvert.convertToCalcPoint(calcPoint[i]));
            fullPoint.setError(errors[i]);
            list.add(fullPoint);
        }
        entity.setList(list);
        entity.setSucCount(length);
        return entity;
    }

    @Override
    public Entity<FullPoint> getMaxPointProperty(int[] ids) throws Exception {
        int length = ids.length;
        RtdbBasePoint[] basePoint = new RtdbBasePoint[length];
        RtdbScanPoint[] scanPoint = new RtdbScanPoint[length];
        RtdbMaxCalcPoint[] calcPoint = new RtdbMaxCalcPoint[length];
        for (int i = 0; i < ids.length; ++i) {
            basePoint[i] = new RtdbBasePoint();
            scanPoint[i] = new RtdbScanPoint();
            calcPoint[i] = new RtdbMaxCalcPoint();
            basePoint[i].setId(ids[i]);
        }
        int[] errors = new int[length];
        this.base.getMaxPointProperty(length, basePoint, scanPoint, calcPoint, errors);
        Entity<FullPoint> entity = new Entity<FullPoint>();
        ArrayList<FullPoint> list = new ArrayList<FullPoint>(length);
        FullPoint fullPoint = null;
        String[] nameStrings = this.getTableTagNames(ids);
        for (int i = 0; i < length; ++i) {
            basePoint[i].setTable_dot_tag(nameStrings[i]);
            fullPoint = new FullPoint();
            fullPoint.setBasePoint(RTDBConvert.convertToBasePoint(basePoint[i]));
            fullPoint.setScanPoint(RTDBConvert.convertToScanPoint(scanPoint[i]));
            fullPoint.setMaxCalcPoint(RTDBConvert.convertToMaxCalcPoint(calcPoint[i]));
            fullPoint.setError(errors[i]);
            list.add(fullPoint);
        }
        entity.setList(list);
        entity.setSucCount(length);
        return entity;
    }

    @Override
    public Entity<MinPoint> getPointsProperties(String[] tagName) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (null != tagName && tagName.length > 0) {
            for (int i = 0; i < tagName.length; ++i) {
                if (tagName[i].indexOf(".") >= 0) continue;
                throw new Exception("\u6807\u7b7e\u70b9\u540d\u79f0\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u6b63\u786e\u683c\u5f0f\uff1a \u8868\u540d\u3002\u6807\u7b7e\u70b9\u540d");
            }
        }
        Entity<MinPoint> entity = new Entity<MinPoint>();
        ArrayList<MinPoint> list = new ArrayList<MinPoint>(tagName.length);
        int length = tagName.length;
        int[] ids = new int[length];
        RtdbType[] types = new RtdbType[length];
        RTDBClass[] classof = new RTDBClass[length];
        boolean[] useMs = new boolean[length];
        int resultCount = this.base.findPoints(length, tagName, ids, types, classof, useMs);
        if (resultCount <= 0) {
            entity.setSucCount(0);
            entity.setList(list);
            return entity;
        }
        MinPoint minPoint = null;
        String[] descs = this.base.getDescs(ids);
        for (int i = 0; i < length; ++i) {
            if (ids[i] <= 0) continue;
            minPoint = new MinPoint();
            String tag = tagName[i];
            minPoint.setTagName(tag);
            String[] fields = tag.split("\\.");
            String tableName = fields[0];
            minPoint.setId(ids[i]);
            minPoint.setTableId(this.base.getTablePropertyByName(tableName).getId());
            minPoint.setTagType(TagType.parse(classof[i].getNum()));
            minPoint.setValueType(ValueType.parse(types[i].getNum()));
            minPoint.setUseMs(useMs[i] ? 0 : 1);
            minPoint.setDesc(descs[i]);
            list.add(minPoint);
        }
        entity.setList(list);
        entity.setSucCount(list.size());
        return entity;
    }

    @Override
    public int[] search(SearchCondition condition, int count, DataSort sort) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        int[] ids = new int[count];
        int resultCount = this.base.search(condition.getTagmask(), condition.getTablemask(), condition.getSource(), condition.getUnit(), condition.getDesc(), condition.getInstrument(), RtdbSearchSort.parse(sort.getNum()), ids, count);
        int[] resultIds = new int[resultCount];
        if (resultCount > 0) {
            System.arraycopy(ids, 0, resultIds, 0, resultCount);
        }
        return resultIds;
    }

    @Override
    public Entity<Integer> searchInBatches(int start, SearchCondition condition, int count, DataSort sort) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        int[] ids = new int[count];
        int dataCount = this.base.searchInBatches(start, condition.getTagmask(), condition.getTablemask(), condition.getSource(), condition.getUnit(), condition.getDesc(), condition.getInstrument(), RtdbSearchSort.parse(sort.getNum()), ids, count);
        ArrayList<Integer> list = new ArrayList<Integer>(dataCount > 0 ? dataCount : 10);
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < dataCount; ++i) {
            list.add(ids[i]);
        }
        Entity<Integer> entity = new Entity<Integer>();
        entity.setList(list);
        entity.setSucCount(dataCount);
        entity.setRetInfo(dataCount == ids.length ? sb.append("\u64cd\u4f5c\u5b8c\u5168\u6210\u529f\uff01") : sb.append("\u64cd\u4f5c\u90e8\u5206\u6210\u529f\uff01"));
        return entity;
    }

    @Override
    public boolean removeTableById(int id) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        this.base.removeTableById(id);
        return true;
    }

    @Override
    public boolean removeTableByName(String tableName) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        Thread.sleep(1000L);
        this.base.removeTableByName(tableName);
        return true;
    }

    @Override
    public boolean updatePointProperty(FullPoint fullPoint) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        this.base.updatePointProperty(RTDBConvert.convertToRtBasePoint(fullPoint.getBasePoint()), RTDBConvert.convertToRtScanPoint(fullPoint.getScanPoint()), RTDBConvert.convertToRtCalcPoint(fullPoint.getCalcPoint()));
        return true;
    }

    @Override
    public List<MinPoint> findPoints(String[] tableTags) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        int count = tableTags.length;
        int[] ids = new int[count];
        RtdbType[] types = new RtdbType[count];
        RTDBClass[] classof = new RTDBClass[count];
        boolean[] useMs = new boolean[count];
        int num = this.base.findPoints(count, tableTags, ids, types, classof, useMs);
        ArrayList<MinPoint> list = new ArrayList<MinPoint>(count > 0 ? count : 10);
        MinPoint minPoint = null;
        if (0 != num) {
            for (int i = 0; i < count; ++i) {
                if (ids[i] <= 0) continue;
                minPoint = new MinPoint();
                minPoint.setId(ids[i]);
                minPoint.setTagName(tableTags[i]);
                minPoint.setValueType(ValueType.parse(types[i].getNum()));
                minPoint.setTagType(TagType.parse(classof[i].getNum()));
                minPoint.setUseMs(useMs[i] ? 1 : 0);
                list.add(minPoint);
            }
        } else {
            for (int i = 0; i < count; ++i) {
                if (ids[i] <= 0) continue;
                minPoint = new MinPoint();
                minPoint.setId(ids[i]);
                minPoint.setTagName(tableTags[i]);
                minPoint.setUseMs(useMs[i] ? 1 : 0);
                list.add(minPoint);
            }
        }
        return list;
    }

    @Override
    public void sortPoints(int[] ids, RtdbTagFieldIndex index, TagSortFlag flag) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        this.base.sortPoints(ids.length, ids, index, flag.getNum());
    }

    @Override
    public boolean updateTableName(int tableId, String tableName) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        this.base.updateTableName(tableId, tableName);
        return true;
    }

    @Override
    public boolean updateTableDescById(int tableId, String desc) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        this.base.updateTableDescById(tableId, desc);
        return true;
    }

    @Override
    public boolean updateTableDescByName(String tableName, String desc) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        this.base.updateTableDescByName(tableName, desc);
        return true;
    }

    @Override
    public boolean recoverPoint(int tableId, int pointId) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        this.base.recoverPoint(tableId, pointId);
        return true;
    }

    @Override
    public boolean purgePoint(int pointId) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        this.base.purgePoint(pointId);
        return true;
    }

    @Override
    public int getRecycledPointsCount() throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        return this.base.getRecycledPointsCount();
    }

    @Override
    public Entity<Integer> getRecycledPoints(int count) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        int[] ids = new int[count];
        ArrayList<Integer> list = new ArrayList<Integer>((count = this.base.getRecycledPoints(ids, count)) > 0 ? count : 10);
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < count; ++i) {
            list.add(ids[i]);
        }
        Entity<Integer> entity = new Entity<Integer>();
        entity.setList(list);
        entity.setSucCount(count);
        entity.setRetInfo(count == ids.length ? sb.append("\u64cd\u4f5c\u5b8c\u5168\u6210\u529f\uff01") : sb.append("\u64cd\u4f5c\u90e8\u5206\u6210\u529f\uff01"));
        return entity;
    }

    @Override
    public Entity<Integer> searchRecycledPoints(SearchCondition condition, DataSort sort, int count) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        int[] ids = new int[count];
        count = this.base.searchRecycledPoints(condition.getTagmask(), condition.getTablemask(), condition.getSource(), condition.getUnit(), condition.getDesc(), condition.getInstrument(), RtdbSearchSort.parse(sort.getNum()), ids, count);
        ArrayList<Integer> list = new ArrayList<Integer>(count > 0 ? count : 10);
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < count; ++i) {
            list.add(ids[i]);
        }
        Entity<Integer> entity = new Entity<Integer>();
        entity.setList(list);
        entity.setSucCount(count);
        entity.setRetInfo(count == ids.length ? sb.append("\u64cd\u4f5c\u5b8c\u5168\u6210\u529f\uff01") : sb.append("\u64cd\u4f5c\u90e8\u5206\u6210\u529f\uff01"));
        return entity;
    }

    @Override
    public Entity<Integer> searchRecycledPointsInBatches(int start, SearchCondition condition, DataSort sort, int count) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        int[] ids = new int[count];
        count = this.base.searchRecycledPointsInBatches(start, condition.getTagmask(), condition.getTablemask(), condition.getSource(), condition.getUnit(), condition.getDesc(), condition.getInstrument(), RtdbSearchSort.parse(sort.getNum()), ids, count);
        ArrayList<Integer> list = new ArrayList<Integer>(count > 0 ? count : 10);
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < count; ++i) {
            list.add(ids[i]);
        }
        Entity<Integer> entity = new Entity<Integer>();
        entity.setList(list);
        entity.setSucCount(count);
        entity.setRetInfo(count == ids.length ? sb.append("\u64cd\u4f5c\u5b8c\u5168\u6210\u529f\uff01") : sb.append("\u64cd\u4f5c\u90e8\u5206\u6210\u529f\uff01"));
        return entity;
    }

    @Override
    public FullPoint getRecycledPointProperty(int id) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        RtdbBasePoint basePoint = new RtdbBasePoint();
        RtdbScanPoint scanPoint = new RtdbScanPoint();
        RtdbCalcPoint calcPoint = new RtdbCalcPoint();
        basePoint.setId(id);
        basePoint.setClassof(RTDBClass.RTDB_BASE);
        RtdbFullPoint rp = this.base.getRecycledPointProperty(basePoint, scanPoint, calcPoint);
        FullPoint fullPoint = new FullPoint();
        fullPoint.setBasePoint(RTDBConvert.convertToBasePoint(rp.getBasePoint()));
        fullPoint.setScanPoint(RTDBConvert.convertToScanPoint(rp.getScanPoint()));
        fullPoint.setCalcPoint(RTDBConvert.convertToCalcPoint(rp.getCalcPoint()));
        return fullPoint;
    }

    @Override
    public RtdbFullPoint getRecycledMaxPointProperty(int id) throws NoAuthorityException, Exception {
        RtdbFullPoint f = new RtdbFullPoint();
        RtdbFullPoint fullpoint = this.base.getRecycledMaxPointProperty(id, f);
        return fullpoint;
    }

    @Override
    public boolean clearRecycler() throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        this.base.clearRecycler();
        return true;
    }

    @Override
    public void subscribeTags(RBTagsChange callback) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        this.base.subscribeTags(callback);
    }

    @Override
    public void subscribeTagsEx(Object param, RBTagsChangeEx callback) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        this.base.subscribeTagsEx(param, callback);
    }

    @Override
    public boolean cancelSubscribeTags() throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        this.base.cancelSubscribeTags();
        return true;
    }

    @Override
    public int getNamedTypesCount() throws Exception {
        return this.base.getNamedTypesCount();
    }

    @Override
    public int[] search(SearchConditionTotal condition, int count, DataSort sort) throws Exception {
        int classofMask = condition.get_PointType() == null ? PointType.Every.getNum() : condition.get_PointType().getNum();
        return this.base.search(condition.getTagmask(), condition.getTablemask(), condition.getSource(), condition.getUnit(), condition.getDesc(), condition.getInstrument(), condition.get_ValueTypeString(), classofMask, condition.get_TimeAccuracy(), condition.get_SearchCondition().ordinal(), condition.getSearchMaskValue(), RtdbSearchSort.parse(sort.getNum()), count);
    }

    @Override
    public int searchPointCount(SearchConditionTotal condition, DataSort sort) throws Exception {
        int classofMask = condition.get_PointType() == null ? PointType.Every.getNum() : condition.get_PointType().getNum();
        return this.base.searchPointCount(condition.getTagmask(), condition.getTablemask(), condition.getSource(), condition.getUnit(), condition.getDesc(), condition.getInstrument(), condition.get_ValueTypeString(), classofMask, condition.get_TimeAccuracy(), condition.get_SearchCondition().ordinal(), condition.getSearchMaskValue(), RtdbSearchSort.parse(sort.getNum()));
    }

    @Override
    public int insertNamedTypePoint(NamedTypePoint point) throws NoAuthorityException, Exception {
        if (point == null || point.getBasePoint().getTag() == "" || point.getBasePoint().getTable() <= 0) {
            return 0;
        }
        return this.base.insertNamedTypePoint(point);
    }

    @Override
    public String[] getAllNamedTypes() throws Exception {
        return this.base.getAllNamedTypes();
    }

    @Override
    public List<NamedTypeNameToFieldsCountBase> getAllNamedTypesAndFieldsCount() throws NoAuthorityException, Exception {
        return this.base.getAllNamedTypesAndFieldsCount();
    }

    @Override
    public NamedType getNamedType(String name) throws NoAuthorityException, Exception {
        if (name == null || name.length() <= 0) {
            return null;
        }
        return this.base.getNamedType(name);
    }

    @Override
    public boolean removeNamedType(String name) throws NoAuthorityException, Exception {
        if (name == null || name.length() <= 0) {
            return false;
        }
        return this.base.removeNamedType(name);
    }

    @Override
    public TagLoadMemoryFlag[] queryLoadMemory() throws NoAuthorityException, Exception {
        return this.base.queryLoadMemory();
    }

    @Override
    public int setLoadMemory(TagLoadMemoryFlag[] loadMemoryFlag) throws NoAuthorityException, Exception {
        if (loadMemoryFlag == null || loadMemoryFlag.length <= 0) {
            return 0;
        }
        return this.base.setLoadMemory(loadMemoryFlag);
    }

    @Override
    public long queryNeedMemorySize(TagLoadMemoryFlag[] loadMemoryFlag) throws NoAuthorityException, Exception {
        if (loadMemoryFlag == null || loadMemoryFlag.length <= 0) {
            return 0L;
        }
        return this.base.queryNeedMemorySize(loadMemoryFlag);
    }

    @Override
    public List<NamedTypeNameToFieldsCount> getNamedTypeNamesProperty(int[] ids) throws NoAuthorityException, Exception {
        if (ids == null || ids.length <= 0) {
            return null;
        }
        return this.base.getNamedTypeNamesProperty(ids);
    }

    @Override
    public List<NamedTypeNameToFieldsCount> getRecycledNamedTypeNamesProperty(int[] ids) throws NoAuthorityException, Exception {
        if (ids == null || ids.length <= 0) {
            return null;
        }
        return this.base.getRecycledNamedTypeNamesProperty(ids);
    }

    @Override
    @Deprecated
    public int GetBaseTypePointsCount(RtdbType dateType) throws NoAuthorityException, Exception {
        return this.base.getBaseTypePointsCount(dateType);
    }

    @Override
    public int getBaseTypePointsCount(RtdbType dateType) throws NoAuthorityException, Exception {
        return this.base.getBaseTypePointsCount(dateType);
    }

    @Override
    public boolean modifyNamedType(String name, String modifyName, String modifyDesc, String[] modifyFieldName, String[] modifyFieldDesc) throws NoAuthorityException, Exception {
        if (name == null || name.length() <= 0) {
            return false;
        }
        return this.base.modifyNamedType(name, modifyName, modifyDesc, modifyFieldName, modifyFieldDesc);
    }

    @Override
    public String[] getTags(int[] ids) throws Exception {
        return this.base.getTags(ids);
    }

    @Override
    public boolean[] getMs(int[] ids) throws Exception {
        byte[] bytes = this.base.getMs(ids);
        boolean[] result = new boolean[bytes.length];
        byte by = 1;
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = by == bytes[i];
        }
        return result;
    }

    @Override
    public RtdbType[] getTypes(int[] ids) throws Exception {
        int[] errors = new int[ids.length];
        int[] ints = this.base.getTypes(ids, errors);
        RtdbType[] types = new RtdbType[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            types[i] = RtdbType.parse(ints[i]);
        }
        return types;
    }

    @Override
    public RtdbType[] getTypes(int[] ids, int[] errors) throws Exception {
        int[] ints = this.base.getTypes(ids, errors);
        RtdbType[] types = new RtdbType[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            types[i] = RtdbType.parse(ints[i]);
        }
        return types;
    }

    @Override
    public float[] getCompdevs(int[] ids) throws Exception {
        return this.base.getCompdevs(ids);
    }

    @Override
    public int[] getCompmaxs(int[] ids, int[] errors) throws Exception {
        return this.base.getCompmaxs(ids, errors);
    }

    @Override
    public int[] getCompmins(int[] ids) throws Exception {
        return this.base.getCompmins(ids);
    }

    @Override
    public float[] getExcdevs(int[] ids) throws Exception {
        return this.base.getExcdevs(ids);
    }

    @Override
    public int[] getExcmaxs(int[] ids) throws Exception {
        return this.base.getExcmaxs(ids);
    }

    @Override
    public int[] getPeriodsProperties(int[] ids) throws Exception {
        return this.base.getPeriodsProperties(ids);
    }

    @Override
    public int[] getTimecopysProperties(int[] ids) throws Exception {
        byte[] timecopys = this.base.getTimecopysProperties(ids);
        int[] timecopy = new int[timecopys.length];
        for (int i = 0; i < timecopys.length; ++i) {
            timecopy[i] = timecopys[i];
        }
        return timecopy;
    }

    @Override
    public int[] getTriggersProperties(int[] ids) throws Exception {
        byte[] tiggers = this.base.getTriggersProperties(ids);
        int[] trigger = new int[tiggers.length];
        block6: for (int i = 0; i < tiggers.length; ++i) {
            trigger[i] = tiggers[i];
            switch (trigger[i]) {
                case 0: {
                    if (!this.log.isDebugEnabled()) continue block6;
                    this.log.debug("\u65e0\u4e8b\u4ef6\u89e6\u53d1");
                    continue block6;
                }
                case 1: {
                    if (!this.log.isDebugEnabled()) continue block6;
                    this.log.debug("\u4e8b\u4ef6\u89e6\u53d1");
                    continue block6;
                }
                case 2: {
                    if (!this.log.isDebugEnabled()) continue block6;
                    this.log.debug("\u5468\u671f\u89e6\u53d1");
                    continue block6;
                }
                case 3: {
                    if (!this.log.isDebugEnabled()) continue block6;
                    this.log.debug("\u5b9a\u65f6\u89e6\u53d1");
                    continue block6;
                }
                default: {
                    if (!this.log.isDebugEnabled()) continue block6;
                    this.log.debug("\u6ca1\u6709\u89e6\u53d1\u4e8b\u4ef6");
                }
            }
        }
        return trigger;
    }

    @Override
    public List<Equation> getEquationsProperties(int[] ids) throws Exception {
        int[] errors = new int[ids.length];
        String[] equations = this.base.getEquationsProperties(ids, errors);
        ArrayList<Equation> list = new ArrayList<Equation>(ids.length);
        for (int i = 0; i < equations.length; ++i) {
            Equation e = new Equation();
            e.setId(ids[i]);
            e.setEquation(equations[i]);
            e.setError(errors[i]);
            list.add(e);
        }
        return list;
    }

    @Override
    public float[] getExcdevpercentsProperties(int[] ids) throws Exception {
        return this.base.getExcdevpercentsProperties(ids);
    }

    @Override
    public float[] getUserRealProperties(int[] ids, UserRealValue userRealValues) throws Exception {
        return this.base.getUserRealProperties(ids, userRealValues);
    }

    @Override
    public int[] getUserInts(int[] ids, UserIntValue userIntValue) throws Exception {
        return this.base.getUserInts(ids, userIntValue);
    }

    @Override
    public int[] getLocationsProperties(int[] ids, Location location) throws Exception {
        return this.base.getLocationsProperties(ids, location);
    }

    @Override
    public String[] getInstrumentsProperties(int[] ids) throws Exception {
        return this.base.getInstrumentsProperties(ids);
    }

    @Override
    public Boolean[] getIsScans(int[] ids) throws Exception {
        return this.base.getIsScans(ids);
    }

    @Override
    public String[] getSources(int[] ids) throws Exception {
        return this.base.getSources(ids);
    }

    @Override
    public short[] getDigits(int[] ids) throws Exception {
        return this.base.getDigits(ids);
    }

    @Override
    public String[] getCreateDates(int[] ids) throws Exception {
        return this.base.getCreateDates(ids);
    }

    @Override
    public String[] getChangeDates(int[] ids) throws Exception {
        return this.base.getChangeDates(ids);
    }

    @Override
    public float[] getTypicals(int[] ids) throws UnexpectedMethodException, Exception {
        return this.base.getTypicals(ids);
    }

    @Override
    public float[] getHighLimits(int[] ids) throws Exception {
        return this.base.getHighLimits(ids);
    }

    @Override
    public float[] getLowLimits(int[] ids) throws Exception {
        return this.base.getLowLimits(ids);
    }

    @Override
    public String[] getCreators(int[] ids) throws Exception {
        return this.base.getCreators(ids);
    }

    @Override
    public String[] getChangers(int[] ids) throws Exception {
        return this.base.getChangers(ids);
    }

    @Override
    public String[] getUnits(int[] ids) throws Exception {
        return this.base.getUnits(ids);
    }

    @Override
    public String[] getDescs(int[] ids) throws Exception {
        return this.base.getDescs(ids);
    }

    @Override
    public String[] getTableTagNames(int[] ids) throws Exception {
        return this.base.getTableTagNames(ids);
    }

    @Override
    public Boolean[] getArchives(int[] ids) throws Exception {
        return this.base.getArchives(ids);
    }

    @Override
    public Boolean[] getShutDowns(int[] ids) throws IOException, UnexpectedMethodException, Exception {
        return this.base.getShutDowns(ids);
    }

    @Override
    public Boolean[] getSteps(int[] ids) throws UnsupportedEncodingException, IOException, ParseException, UnexpectedMethodException, Exception {
        return this.base.getSteps(ids);
    }

    @Override
    public Boolean[] getMirrors(int[] ids) throws UnsupportedEncodingException, IOException, ParseException, UnexpectedMethodException, Exception {
        return this.base.getMirrors(ids);
    }

    @Override
    public Boolean[] getSummarys(int[] ids) throws UnsupportedEncodingException, IOException, ParseException, UnexpectedMethodException, Exception {
        return this.base.getSummarys(ids);
    }

    @Override
    public short[] getTablesIds(int[] ids) throws UnsupportedEncodingException, IOException, ParseException, UnexpectedMethodException, Exception {
        return this.base.getTablesIds(ids);
    }

    @Override
    public int[] getClassofs(int[] ids) throws UnsupportedEncodingException, IOException, ParseException, UnexpectedMethodException, Exception {
        int[] errors = new int[ids.length];
        byte[] classofs = this.base.getClassofs(ids, errors);
        int[] classof = new int[classofs.length];
        for (int i = 0; i < classofs.length; ++i) {
            classof[i] = classofs[i];
        }
        return classof;
    }

    @Override
    public int[] getExcMins(int[] ids) throws UnsupportedEncodingException, IOException, ParseException, UnexpectedMethodException, Exception {
        return this.base.getExcMins(ids);
    }

    @Override
    public boolean createNamedType(String createName, String createDesc, NamedDataTypeField[] fds) throws Exception {
        return this.base.createNamedType(createName, createDesc, fds);
    }

    @Override
    public float[] getCompdevpercentsProperties(int[] ids) throws Exception {
        return this.base.getCompdevpercentsProperties(ids);
    }

    @Override
    public String getEquationsByFileName(String filename) throws Exception {
        return this.base.getEquationsByFileName(filename);
    }

    @Override
    public String getEquationById(int id) throws Exception {
        return this.base.getEquationById(id);
    }

    @Override
    public boolean insertMinPoint(FullPoint fullPoint) throws UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        BasePoint bp = fullPoint.getBasePoint();
        if (bp.getType().getNum() == ValueType.RTDB_NamedTypeT.getNum()) {
            throw new DatatypeConfigurationException("Unsupported tag_type ! -->  \" ValueType.RTDB_NamedTypeT \"");
        }
        RtdbBasePoint basePoint = RTDBConvert.convertToRtBasePoint(bp);
        RtdbScanPoint rtdbScanPoint = RTDBConvert.convertToRtScanPoint(fullPoint.getScanPoint());
        RtdbMinCalcPoint mincalcPoint = RTDBConvert.convertToRtMinCalcPoint(fullPoint.getMinCalcPoint());
        this.base.insertMinPoint(basePoint, rtdbScanPoint, mincalcPoint);
        return basePoint.getId() > 0;
    }

    @Override
    public int getNamedTypePointsCount(String name) throws NoAuthorityException, Exception {
        if (name == null || name.length() <= 0) {
            return 0;
        }
        return this.base.getNamedTypePointsCount(name);
    }
}

