/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.service.impl;

import com.rtdb.api.enums.RtdbGraphFlag;
import com.rtdb.api.exception.EncodePacketErrorException;
import com.rtdb.api.exception.InvalidParameterException;
import com.rtdb.api.exception.NoAuthorityException;
import com.rtdb.api.impl.RtdbEquationImpl;
import com.rtdb.api.inter.IEquation;
import com.rtdb.api.model.RtdbGraphData;
import com.rtdb.enums.ComputerFlag;
import com.rtdb.model.ComputerEntity;
import com.rtdb.model.Entity;
import com.rtdb.model.ErrorParse;
import com.rtdb.service.impl.ServerImpl;
import com.rtdb.service.inter.Equation;
import java.io.IOException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;

public class EquationImpl
implements Equation {
    private ServerImpl server;
    private IEquation ge;

    public EquationImpl(ServerImpl server) throws UnknownHostException, IOException, Exception {
        this.server = server;
        this.ge = new RtdbEquationImpl(this.server);
    }

    @Override
    public void close() throws IOException, InterruptedException {
        this.server.close();
    }

    @Override
    public Entity<ComputerEntity> computeHistory(int[] ids, ComputerFlag flag, Date beginTime, Date endTime) throws InvalidParameterException, NoAuthorityException, ParseException, IOException, EncodePacketErrorException, Exception {
        int count = ids.length;
        int[] errors = new int[count];
        int[] ids_bk = new int[count];
        System.arraycopy(ids, 0, ids_bk, 0, count);
        short sflag = (short)flag.getFlag();
        StringBuffer sb = new StringBuffer();
        this.ge.ComputeHistory(count, sflag, beginTime, endTime, ids, errors);
        Entity<ComputerEntity> entity = new Entity<ComputerEntity>();
        ComputerEntity ce = null;
        for (int i = 0; i < errors.length; ++i) {
            ce = new ComputerEntity();
            if (errors[i] != 0) {
                sb.append("\u6807\u7b7e\u70b9id\u4e3a" + ids_bk[i] + "\u64cd\u4f5c\u5931\u8d25-->" + ErrorParse.getRtdbError(errors[i]).getErrmsg() + "\r\n");
            }
            ce.setError((short)errors[i]);
        }
        entity.setSucCount(count);
        entity.setRetInfo(sb);
        return entity;
    }

    @Override
    public int getEquationGraphCount(int id, RtdbGraphFlag flag) throws InvalidParameterException, NoAuthorityException, Exception {
        return this.ge.getEquationGraphCount(id, flag);
    }

    @Override
    public List<RtdbGraphData> getEquationGraphDatas(int id, RtdbGraphFlag rtdbGraphAll) throws NoAuthorityException, Exception {
        return this.ge.getEquationGraphDatas(id, rtdbGraphAll);
    }
}

