/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.service.impl;

import com.rtdb.api.enums.IsReConnection;
import com.rtdb.api.enums.RtdbError;
import com.rtdb.api.enums.RtdbMsgID;
import com.rtdb.api.enums.RtdbPrivGroup;
import com.rtdb.api.exception.EncodePacketErrorException;
import com.rtdb.api.exception.InvalidParameterException;
import com.rtdb.api.exception.InvalidTimeFormatException;
import com.rtdb.api.exception.NoAuthorityException;
import com.rtdb.api.exception.UnexpectedMethodException;
import com.rtdb.api.impl.RtdbServerImpl;
import com.rtdb.api.inter.IServer;
import com.rtdb.api.inter.IServerable;
import com.rtdb.api.model.Login;
import com.rtdb.api.model.RtdbField;
import com.rtdb.api.model.RtdbHostConnectInfo;
import com.rtdb.api.model.Rtdb_Path;
import com.rtdb.api.model.SocketAddr;
import com.rtdb.enums.PrivGroup;
import com.rtdb.enums.RtdbDbParamIndex;
import com.rtdb.model.AuthorizationInfo;
import com.rtdb.model.BlackListInfo;
import com.rtdb.model.Entity;
import com.rtdb.model.HostConnectInfo;
import com.rtdb.model.JobMessage;
import com.rtdb.model.UsersInfo;
import com.rtdb.service.impl.ServerImplPool;
import com.rtdb.service.inter.Server;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;

public class ServerImpl
implements Server,
IServerable {
    private ServerImplPool pool;
    private IServer rtdbServer = null;
    protected boolean isRemoveFromPool = false;
    private int serverHandleId = -1;

    public ServerImpl(IServer impl, ServerImplPool pool) {
        this.rtdbServer = impl;
        this.pool = pool;
    }

    public ServerImpl(String ip, int port, String userName, String passWord) throws UnknownHostException, IOException, Exception {
        SocketAddr socketAddr = new SocketAddr(ip, port);
        this.rtdbServer = new RtdbServerImpl(socketAddr, new Login(userName, passWord));
        this.pool = null;
        this.open();
    }

    @Override
    public IServer getConnection() {
        return this.rtdbServer;
    }

    public void setConnection(IServer impl) {
        this.rtdbServer = impl;
    }

    public boolean isEmpty() {
        return this.rtdbServer == null;
    }

    @Override
    public Login getLogin() {
        return this.rtdbServer.getLogin();
    }

    @Override
    public void login() throws IOException, EncodePacketErrorException, UnexpectedMethodException, Exception {
        this.rtdbServer.login();
    }

    @Override
    public void connect() throws UnknownHostException, IOException, Exception {
        this.rtdbServer.connect();
    }

    public void open() throws UnknownHostException, IOException, Exception {
        this.rtdbServer.connect();
        this.rtdbServer.login();
    }

    public void sendBlobDatas(List<RtdbField> fields) throws IOException, EncodePacketErrorException, ParseException, Exception {
        this.rtdbServer.sendPacket(fields, true);
    }

    public void recevePacket(List<RtdbField> fields) throws IOException, UnexpectedMethodException, Exception {
        this.rtdbServer.receivePacket(fields);
    }

    @Override
    public boolean isOpen() throws Exception {
        return this.rtdbServer.isOpen();
    }

    @Override
    public void setTimeOut(int timeOut) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        this.rtdbServer.setTimeout(timeOut);
    }

    @Override
    public int getTimeOut(int socket) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        return this.rtdbServer.getTimeout(socket);
    }

    @Override
    public void disconnect() throws NoAuthorityException, IOException, Exception {
        this.rtdbServer.disconnect();
    }

    @Override
    @Deprecated
    public PrivGroup GetPriv() throws NoAuthorityException, Exception {
        return PrivGroup.parse(this.rtdbServer.getPriv().getNum());
    }

    @Override
    public PrivGroup getPriv() {
        Login login = this.rtdbServer.getLogin();
        if (null != this.rtdbServer.getLogin()) {
            return PrivGroup.parse(login.getPriv());
        }
        return PrivGroup.NO;
    }

    @Override
    public void close() throws InterruptedException {
        if (this.isRemoveFromPool) {
            this.pool.removeServerImplFromPool(this);
            return;
        }
        if (this.pool != null) {
            this.pool.releaseServerImpl(this);
        } else if (this.rtdbServer != null) {
            this.rtdbServer.close();
            this.rtdbServer = null;
        }
    }

    @Override
    public int getConnectionCount() throws IOException, EncodePacketErrorException, Exception {
        return this.rtdbServer.getConnectionCount();
    }

    @Override
    public int[] getConnections(int count) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        return this.rtdbServer.getConnections(count);
    }

    @Override
    public HostConnectInfo getConnectionInfo(int socket) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        HostConnectInfo gci = null;
        RtdbHostConnectInfo info = this.rtdbServer.getConnectionInfo(socket);
        if (null != info) {
            gci = new HostConnectInfo();
            BeanUtils.copyProperties(gci, info);
        }
        return gci;
    }

    @Override
    public List<HostConnectInfo> getConnectInfos() throws IOException, EncodePacketErrorException, Exception {
        ArrayList<HostConnectInfo> list = new ArrayList<HostConnectInfo>(500);
        HostConnectInfo hci = null;
        for (RtdbHostConnectInfo info : this.rtdbServer.getConnectInfos()) {
            hci = new HostConnectInfo();
            BeanUtils.copyProperties(hci, info);
            list.add(hci);
        }
        return list;
    }

    @Override
    public boolean changePassword(String user, String pwd) throws InvalidParameterException, UnsupportedEncodingException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        this.rtdbServer.changePassword(user, pwd);
        return true;
    }

    @Override
    public boolean changeMyPassword(String oldPwd, String newPwd) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        this.rtdbServer.changeMyPassword(oldPwd, newPwd);
        return true;
    }

    @Override
    public boolean changePriv(String user, PrivGroup priv) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        this.rtdbServer.changePriv(user, RtdbPrivGroup.parse(priv.getNum()));
        return true;
    }

    @Override
    public boolean addUser(String user, String pwd, PrivGroup priv) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        this.rtdbServer.addUser(user, pwd, RtdbPrivGroup.parse(priv.getNum()));
        return true;
    }

    @Override
    public boolean removeUser(String user) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        this.rtdbServer.removeUser(user);
        return true;
    }

    @Override
    public Entity<UsersInfo> getUsers(int count) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        String[] users = new String[count];
        RtdbPrivGroup[] privs = new RtdbPrivGroup[count];
        this.rtdbServer.getUsers(count, users, privs);
        Entity<UsersInfo> ents = new Entity<UsersInfo>();
        ArrayList<UsersInfo> list = new ArrayList<UsersInfo>(count);
        if (privs != null & privs.length > 0) {
            for (int i = 0; i < privs.length; ++i) {
                if (users[i] == null) continue;
                UsersInfo info = new UsersInfo();
                info.setUser(users[i]);
                info.setPriv(PrivGroup.parse(privs[i].getNum()));
                list.add(info);
            }
            ents.setSucCount(list.size());
            ents.setList(list);
        }
        return ents;
    }

    @Override
    public boolean addBlacklist(BlackListInfo black) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (black == null) {
            return false;
        }
        this.rtdbServer.addBlacklist(black.getAddr(), black.getMask(), black.getDesc());
        return true;
    }

    @Override
    public boolean updateBlacklist(String oldAddr, String oldMask, BlackListInfo newBlack) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (newBlack == null) {
            return false;
        }
        this.rtdbServer.updateBlacklist(oldAddr, oldMask, newBlack.getAddr(), newBlack.getMask(), newBlack.getDesc());
        return true;
    }

    @Override
    public boolean removeBlacklist(String addr, String mask) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        this.rtdbServer.removeBlacklist(addr, mask);
        return true;
    }

    @Override
    public Entity<BlackListInfo> getBlacklists(int count) throws NoAuthorityException, IOException, EncodePacketErrorException, UnexpectedMethodException, Exception {
        String[] addrs = new String[count];
        String[] masks = new String[count];
        String[] descs = new String[count];
        count = this.rtdbServer.getBlacklists(addrs, masks, descs, count);
        ArrayList<BlackListInfo> list = null;
        Entity<BlackListInfo> ents = null;
        BlackListInfo black = null;
        if (count > 0) {
            list = new ArrayList<BlackListInfo>(count);
            ents = new Entity<BlackListInfo>();
            for (int i = 0; i < count; ++i) {
                black = new BlackListInfo();
                black.setAddr(addrs[i]);
                black.setMask(masks[i]);
                black.setDesc(descs[i]);
                list.add(black);
            }
            ents.setSucCount(count);
            ents.setList(list);
        }
        return ents;
    }

    @Override
    public boolean addAuthorization(String addr, String mask, PrivGroup priv, String desc) throws NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        this.rtdbServer.addAuthorization(addr, mask, RtdbPrivGroup.parse(priv.getNum()), desc);
        return true;
    }

    @Override
    public boolean updateAuthorization(String oldAddr, String oldMask, AuthorizationInfo authoriza) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        this.rtdbServer.updateAuthorization(oldAddr, oldMask, authoriza.getIpAddr(), authoriza.getMask(), RtdbPrivGroup.parse(authoriza.getPriv().getNum()), authoriza.getDesc());
        return true;
    }

    @Override
    public boolean removeAuthorization(String addr, String mask) throws NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        this.rtdbServer.removeAuthorization(addr, mask);
        return true;
    }

    @Override
    public Entity<AuthorizationInfo> getAuthorizations(int count) throws NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        String[] addrs = new String[count];
        String[] masks = new String[count];
        String[] descs = new String[count];
        RtdbPrivGroup[] privs = new RtdbPrivGroup[count];
        AuthorizationInfo authoriza = null;
        Entity<AuthorizationInfo> ents = new Entity<AuthorizationInfo>();
        ArrayList<AuthorizationInfo> list = null;
        if ((count = this.rtdbServer.getAuthorizations(addrs, masks, privs, descs, count)) > 0) {
            list = new ArrayList<AuthorizationInfo>(count);
            for (int i = 0; i < count; ++i) {
                if (addrs == null) continue;
                authoriza = new AuthorizationInfo();
                authoriza.setIpAddr(addrs[i]);
                authoriza.setMask(masks[i]);
                authoriza.setPriv(PrivGroup.parse(privs[i].getNum()));
                authoriza.setDesc(descs[i]);
                list.add(authoriza);
            }
            ents.setSucCount(list.size());
            ents.setList(list);
        }
        return ents;
    }

    @Override
    public Date getHostTime() throws IOException, EncodePacketErrorException, Exception {
        return this.rtdbServer.getHostTime();
    }

    @Override
    public JobMessage getJobMessage(int jobId) throws NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (jobId <= 0) {
            return null;
        }
        String desc = this.rtdbServer.getJobMessage(jobId);
        String jobName = RtdbMsgID.getByNum(jobId).name();
        JobMessage job = new JobMessage();
        job.setJobDesc(desc);
        job.setJobId(jobId);
        job.setJobName(jobName);
        return job;
    }

    @Override
    public boolean KillConnection(int socket) throws IOException, EncodePacketErrorException, Exception {
        if (socket > 0) {
            this.rtdbServer.killConnection(socket);
            return true;
        }
        return false;
    }

    @Override
    public String getDbInfo1(RtdbDbParamIndex index, int size) throws NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (index != null) {
            int num = index.getNum();
            return this.rtdbServer.getDbInfo1(num, size);
        }
        return "\u4e0d\u5b58\u5728";
    }

    @Override
    public int getDbInfo2(RtdbDbParamIndex index) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        if (index != null) {
            int e = index.getNum();
            return this.rtdbServer.getDbInfo2(e);
        }
        return 0;
    }

    @Override
    public String getLogicalDrivers() throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        return this.rtdbServer.getLogicalDrivers();
    }

    @Override
    public boolean openPath(String dir) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        dir = dir.replace("\\", "/");
        this.rtdbServer.openPath(dir);
        return true;
    }

    @Override
    public Rtdb_Path readPath() throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        Rtdb_Path filePath = this.rtdbServer.readPath();
        return filePath;
    }

    @Override
    public boolean mkDir(String dir) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        dir = dir.replace("\\", "/");
        this.rtdbServer.mkDir(dir);
        return true;
    }

    @Override
    public boolean closePath() throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        this.rtdbServer.closePath();
        return true;
    }

    @Override
    public long getFileSize(String file) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        file = file.replace("\\", "/");
        return this.rtdbServer.getFileSize(file);
    }

    @Override
    public String readFile(String filePath, int pos, int size) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        byte[] byts = new byte[size];
        filePath = filePath.replace("\\", "/");
        byts = this.rtdbServer.readFile(filePath, pos, size);
        String fileStr = new String(byts, "gbk");
        return fileStr;
    }

    @Override
    public int getMaxBlobLen() throws Exception {
        return this.rtdbServer.getMaxBlobLen();
    }

    @Override
    public void reConnection(IsReConnection conn, int value) throws Exception {
        this.rtdbServer.setOption(conn, value);
    }

    @Override
    public long setDbInfo1(RtdbDbParamIndex index, String str) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        long res = 0L;
        if (index != null) {
            int num = index.getNum();
            res = this.rtdbServer.setDbInfo1(num, str);
        }
        return res;
    }

    @Override
    public long setDbInfo2(RtdbDbParamIndex index, int value) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        int num = index.getNum();
        return this.rtdbServer.setDbInfo2(num, value);
    }

    @Override
    public String getApiVersion() {
        return this.rtdbServer.getApiVersion();
    }

    @Override
    public boolean lockUser(String user, boolean flag) throws NoAuthorityException, Exception {
        return this.rtdbServer.lockUser(user, flag);
    }

    @Override
    public int parseTimespan(String str) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        return this.rtdbServer.parseTimespan(str);
    }

    @Override
    public Date parseTime(String str) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, InvalidTimeFormatException, Exception {
        return this.rtdbServer.parseTime(str);
    }

    @Override
    public String formatMessage(RtdbError error) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        return this.rtdbServer.formatMessage(error);
    }

    @Override
    public List<String> formatQuality(int count, int[] qualities) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        return this.rtdbServer.formatQuality(count, qualities);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean judgeConnectStatus() {
        try {
            if (this.serverHandleId == -1) {
                ServerImpl serverImpl = this;
                synchronized (serverImpl) {
                    this.serverHandleId = this.rtdbServer.getOWNconnect();
                }
            }
            return this.rtdbServer.judgeConnectStatus(this.serverHandleId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void setReconnection(boolean _isReconnection) {
        this.rtdbServer.setReconnection(_isReconnection);
    }

    @Override
    public String formatTimespan(int timeSpan) throws InvalidParameterException, NoAuthorityException, IOException, EncodePacketErrorException, Exception {
        return this.rtdbServer.formatTimespan(timeSpan);
    }
}

