package com.beagle.base.bean.vo.resp;

import com.beagle.base.common.contant.CodeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * @author wuwanli
 */
@Data
@ApiModel
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
public class ExtResponse<T> extends ExtBaseResponse {
    /**
     * 封装的返回对象
     */
    @ApiModelProperty("返回对象")
    private T data;

    public ExtResponse(T data) {
        this.setCode(CodeEnum.SUCCESS.getCode());
        this.setMsg(CodeEnum.SUCCESS.getDesc());
        this.data = data;
    }

    public ExtResponse(CodeEnum codeEnum) {
        this.setCode(codeEnum.getCode());
        this.setMsg(codeEnum.getCode());
    }
}
