package com.beagle.base.common.config;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;
/**
 * @author wuwanli
 */
@EnableSwagger2
@Configuration
public class Knife4jConfiguration {
    @Bean(value = "defaultApi2")
    public Docket defaultApi2() {
        return new Docket(DocumentationType.SWAGGER_2)
            .apiInfo(new ApiInfoBuilder().description("APIs").termsOfServiceUrl("http://localhost:8080/base")
                .version("1.0").build())
            // 分组名称
            .groupName("base").select()
            // 这里指定Controller扫描包路径
            .apis(RequestHandlerSelectors.basePackage("com.beagle.base.controller")).paths(PathSelectors.any()).build();
    }
}
