package com.beagle.base.controller;

import com.beagle.base.bean.vo.HistorianDoubleArchivedValuesParam;
import com.beagle.base.bean.vo.HistorianFloatArchivedValuesFiltParam;
import com.beagle.base.bean.vo.HistorianFloatInterpoValuesParam;
import com.beagle.base.bean.vo.HistorianFloatIntervalValuesParam;
import com.beagle.base.bean.vo.resp.Response;
import com.beagle.base.service.HistorianService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.rtdb.model.DoubleData;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Nonnull;
import javax.annotation.Resource;
import javax.validation.constraints.NotBlank;
import java.util.List;
import java.util.Map;

/**
 * 数据库字段加密、防篡改接口
 *
 * @author lzz
 */
@Api(tags = "历史服务接口实现类")
@RestController
@RequestMapping("/v1/historian")
public class HistorianController {
    @Resource
    private HistorianService historianService;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "读取单个标签点某个时刻之后一定数量的等间隔内插值替换的历史数值")
    @PostMapping("/getFloatIntervalValues")
    public Response<List<DoubleData>> getFloatIntervalValues(@RequestBody @ApiParam(value = "入参") @Validated HistorianFloatIntervalValuesParam param) {
        return new Response<>(historianService.getFloatIntervalValues(param));
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "获取单个浮点类型标签点一段时间内等间隔历史插值")
    @PostMapping("/getFloatInterpoValues")
    public Response<List<DoubleData>> getFloatInterpoValues(@RequestBody @ApiParam(value = "入参") @Validated HistorianFloatInterpoValuesParam param) {
        return new Response<>(historianService.getFloatInterpoValues(param));
    }

    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "读取单个浮点类型标签点在一段时间内经复杂条件筛选后的历史储存值")
    @PostMapping("/getFloatArchivedValuesFilt")
    public Response<List<DoubleData>> getFloatArchivedValuesFilt(@RequestBody @ApiParam(value = "入参") @Validated HistorianFloatArchivedValuesFiltParam param) {
        return new Response<>(historianService.getFloatArchivedValuesFilt(param));
    }

    @ApiOperationSupport(order = 4)
    @ApiOperation(value = "读取单个浮点类型标签点一段时间内的储存数据")
    @PostMapping("/getDoubleArchivedValues")
    public Response<List<DoubleData>> getDoubleArchivedValues(@RequestBody @ApiParam(value = "入参") @Validated HistorianDoubleArchivedValuesParam param) {
        return new Response<>(historianService.getDoubleArchivedValues(param));
    }
}
