/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.api.model;

import com.rtdb.api.enums.RTDBTimeCopy;
import com.rtdb.api.enums.RTDBTrigger;
import com.rtdb.api.model.MemoryStream;
import com.rtdb.api.util.BytesConvert;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class RtdbMaxCalcPoint {
    int id;
    String equation = "";
    RTDBTrigger trigger = RTDBTrigger.RTDB_NULL_TRIGGER;
    RTDBTimeCopy timecopy = RTDBTimeCopy.RTDB_CALC_TIME;
    int period;
    int padding = 2036;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getEquation() {
        return this.equation;
    }

    public void setEquation(String equation) {
        this.equation = equation;
    }

    public RTDBTrigger getTrigger() {
        return this.trigger;
    }

    public void setTrigger(RTDBTrigger trigger) {
        this.trigger = trigger;
    }

    public RTDBTimeCopy getTimecopy() {
        return this.timecopy;
    }

    public void setTimecopy(RTDBTimeCopy timecopy) {
        this.timecopy = timecopy;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public int getPadding() {
        return this.padding;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public static RtdbMaxCalcPoint bytesToMaxCalcPoint(byte[] bytes) throws UnsupportedEncodingException {
        RtdbMaxCalcPoint calc = new RtdbMaxCalcPoint();
        MemoryStream stream = new MemoryStream(bytes);
        if (bytes.length <= 0) {
            return null;
        }
        calc.setId(stream.readInt());
        String readString = stream.readString(2036);
        int idx = readString.indexOf("\u0000");
        String equation = readString.substring(0, idx);
        calc.setEquation(equation);
        calc.setPadding(stream.readInt());
        calc.setTrigger(RTDBTrigger.parse(stream.readByte()));
        calc.setTimecopy(RTDBTimeCopy.parse(stream.readByte()));
        calc.setPeriod(stream.readInt());
        return calc;
    }

    public static byte[] calcMaxPointToByte(RtdbMaxCalcPoint point) throws IOException {
        MemoryStream stream = new MemoryStream();
        if (point != null) {
            stream.writeInt(point.getId());
            String eq = point.getEquation();
            stream.writeBytes(eq.getBytes());
            int nums = 63488 - eq.length();
            stream.writeBytes(BytesConvert.fillBytes(nums));
            int num = point.getTrigger().getNum();
            byte b = (byte)num;
            stream.writeByte(b);
            int num2 = point.getTimecopy().getNum();
            byte b2 = (byte)num2;
            stream.writeByte(b2);
            byte[] fillBytes = BytesConvert.fillBytes(2);
            stream.writeBytes(fillBytes);
            int ped = point.getPeriod();
            byte[] intToBytes = BytesConvert.intToBytes(ped);
            stream.writeBytes(intToBytes);
            int padding2 = point.getPadding();
            byte[] intToBytes2 = new byte[padding2];
            stream.writeBytes(intToBytes2);
        }
        byte[] bytes = stream.toByteArray();
        return bytes;
    }
}

