/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.api.msg;

import com.google.protobuf.ByteString;
import com.rtdb.api.enums.RtdbMsgID;
import com.rtdb.api.exception.NoAuthorityException;
import com.rtdb.api.impl.adapter.ArchivedAdapter;
import com.rtdb.api.model.RtdbField;
import com.rtdb.api.protocol.DatagramArchive;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class ArchivesProtocol30
extends ArchivedAdapter {
    private static ArchivesProtocol30 archivesProtocol = null;

    private ArchivesProtocol30() {
    }

    public static synchronized ArchivesProtocol30 getInstance() {
        if (archivesProtocol == null) {
            archivesProtocol = new ArchivesProtocol30();
        }
        return archivesProtocol;
    }

    @Override
    public List<RtdbField> msgArchivesCountFields() {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        byte[] myByte = new byte[1];
        fields.addAll(this.getMsgHeader2(RtdbMsgID.MSG_GET_ARCHIVES_COUNT, 0, 0, 0, 1, myByte.length));
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgArchivesStatusFields() {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        byte[] myByte = new byte[1];
        int count = 0;
        fields.addAll(this.getMsgHeader2(RtdbMsgID.MSG_GET_ARCHIVES_STATUS, 0, 0, count, 0, myByte.length));
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetArchivesRespFields(int count) throws UnsupportedEncodingException {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        DatagramArchive.datagram_get_archives_resp.Builder build = DatagramArchive.datagram_get_archives_resp.newBuilder();
        ArrayList<Integer> listS = new ArrayList<Integer>();
        ArrayList<ByteString> listP = new ArrayList<ByteString>();
        ArrayList<ByteString> listF = new ArrayList<ByteString>();
        for (int j = 0; j < count; ++j) {
            listS.add(0);
            listP.add(ByteString.copyFrom("", "GBK"));
            listF.add(ByteString.copyFrom("", "GBK"));
        }
        build.addAllStates(listS);
        build.addAllPaths(listP);
        build.addAllFiles(listF);
        DatagramArchive.datagram_get_archives_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        fields.addAll(this.getMsgHeader2(RtdbMsgID.MSG_GET_ARCHIVES, 0, 0, count, 1, 0));
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetArchivesFields(int count) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader2(RtdbMsgID.MSG_GET_ARCHIVES, 0, 0, count, 1, 0));
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgArchivesCountRespFields(int ret, int count) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        byte[] myByte = new byte[1];
        fields.addAll(this.getMsgHeader2(RtdbMsgID.MSG_GET_ARCHIVES_COUNT, ret, 0, count, 1, myByte.length));
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgCreateArchiveFields(String path, String file, int size) throws UnsupportedEncodingException {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        DatagramArchive.datagram_create_archive.Builder build = DatagramArchive.datagram_create_archive.newBuilder();
        build.setPath(ByteString.copyFrom(path, "GBK"));
        build.setFileName(ByteString.copyFrom(file, "GBK"));
        DatagramArchive.datagram_create_archive _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        fields.addAll(this.getMsgHeader2(RtdbMsgID.MSG_CREATE_ARCHIVE, 0, 0, size, 1, myByte.length));
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgCreateArchiveRespFields(int ret) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        byte[] myByte = new byte[1];
        fields.addAll(this.getMsgHeader2(RtdbMsgID.MSG_CREATE_ARCHIVE, 0, ret, 0, 1, 0));
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetArchivesPerfDataRespFields(int counts) throws UnsupportedEncodingException {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        DatagramArchive.datagram_get_archives_perf_data_resp.Builder build = DatagramArchive.datagram_get_archives_perf_data_resp.newBuilder();
        DatagramArchive.datagram_get_archives_perf_data_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        fields.addAll(this.getMsgHeader2(RtdbMsgID.MSG_GET_ARCHIVES_PERF_DATA, 0, 0, counts, 1, 0));
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetArchivesPerfDataFields(String[] paths, String[] files, int count) throws NoAuthorityException, Exception {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        DatagramArchive.datagram_get_archives_perf_data.Builder build = DatagramArchive.datagram_get_archives_perf_data.newBuilder();
        ArrayList<ByteString> fileByteString = new ArrayList<ByteString>();
        ArrayList<ByteString> pathByteString = new ArrayList<ByteString>();
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = paths[i].replace("\\", "/");
            ByteString f = ByteString.copyFrom(files[i], "GBK");
            ByteString p = ByteString.copyFrom(paths[i], "GBK");
            fileByteString.add(f);
            pathByteString.add(p);
        }
        build.addAllFiles(fileByteString);
        build.addAllPaths(pathByteString);
        DatagramArchive.datagram_get_archives_perf_data _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        fields.addAll(this.getMsgHeader2(RtdbMsgID.MSG_GET_ARCHIVES_PERF_DATA, 1, 0, count, 1, myByte.length));
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgCreateRangedArchiveFields(int begin, int end, String path, String file, int size) throws UnsupportedEncodingException {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        DatagramArchive.datagram_create_ranged_archive.Builder build = DatagramArchive.datagram_create_ranged_archive.newBuilder();
        build.setBeginDatetime(begin);
        build.setEndDatetime(end);
        build.setPath(ByteString.copyFrom(path, "GBK"));
        build.setFileName(ByteString.copyFrom(file, "GBK"));
        DatagramArchive.datagram_create_ranged_archive _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        fields.addAll(this.getMsgHeader2(RtdbMsgID.MSG_CREATE_RANGED_ARCHIVE, 0, 0, size, 1, myByte.length));
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgCreateRangedArchiveRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_CREATE_RANGED_ARCHIVE, 0, ret);
    }

    @Override
    public List<RtdbField> msgAppendArchiveFields(String path, String file, int state) throws UnsupportedEncodingException {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        DatagramArchive.datagram_append_archive.Builder build = DatagramArchive.datagram_append_archive.newBuilder();
        build.setFileState(state);
        build.setPath(ByteString.copyFrom(path, "GBK"));
        build.setFileName(ByteString.copyFrom(file, "GBK"));
        DatagramArchive.datagram_append_archive _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        fields.addAll(this.getMsgHeader2(RtdbMsgID.MSG_APPEND_ARCHIVE, 0, 0, 1, 1, myByte.length));
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgAppendArchiveRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_APPEND_ARCHIVE, 0, ret);
    }

    @Override
    public List<RtdbField> msgRemoveArchiveFields(String path, String file) throws UnsupportedEncodingException {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        DatagramArchive.datagram_remove_archive.Builder build = DatagramArchive.datagram_remove_archive.newBuilder();
        build.setPath(ByteString.copyFrom(path, "GBK"));
        build.setFileName(ByteString.copyFrom(file, "GBK"));
        DatagramArchive.datagram_remove_archive _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        fields.addAll(this.getMsgHeader2(RtdbMsgID.MSG_REMOVE_ARCHIVE, 0, 0, 1, 1, myByte.length));
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgRemoveArchiveRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_REMOVE_ARCHIVE, 0, ret);
    }

    @Override
    public List<RtdbField> msgShiftActivedFields() throws UnsupportedEncodingException {
        return this.msgCommonFields(RtdbMsgID.MSG_SHIFT_ACTIVED, 0);
    }

    @Override
    public List<RtdbField> msgShiftActivedRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_SHIFT_ACTIVED, 0, ret);
    }

    @Override
    public List<RtdbField> msgReactiveArchiveFields(String path, String file) throws UnsupportedEncodingException {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        DatagramArchive.datagram_reactive_archive.Builder build = DatagramArchive.datagram_reactive_archive.newBuilder();
        build.setFileName(ByteString.copyFromUtf8(file));
        build.setPath(ByteString.copyFromUtf8(path));
        DatagramArchive.datagram_reactive_archive _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        fields.addAll(this.getMsgHeader2(RtdbMsgID.MSG_REACTIVE_ARCHIVE, 1, 0, 0, 1, myByte.length));
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgReactiveArchiveRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_REACTIVE_ARCHIVE, 0, ret);
    }

    @Override
    public List<RtdbField> msgGetFirstArchiveFields() throws UnsupportedEncodingException {
        return this.msgCommonFields(RtdbMsgID.MSG_GET_FIRST_ARCHIVE, 0);
    }

    @Override
    public List<RtdbField> msgGetFirstArchiveRespFields(int ret, String path, String file, int state) throws UnsupportedEncodingException {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        DatagramArchive.datagram_get_first_archive_resp.Builder build = DatagramArchive.datagram_get_first_archive_resp.newBuilder();
        build.setFileState(state);
        build.setPath(ByteString.copyFrom(path, "GBK"));
        build.setFileName(ByteString.copyFrom(file, "GBK"));
        DatagramArchive.datagram_get_first_archive_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        fields.addAll(this.getMsgHeader2(RtdbMsgID.MSG_GET_FIRST_ARCHIVE, ret, 0, 1, 1, myByte.length));
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetNextArchiveFields(String path, String file) throws UnsupportedEncodingException {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        DatagramArchive.datagram_get_next_archive.Builder build = DatagramArchive.datagram_get_next_archive.newBuilder();
        build.setPath(ByteString.copyFrom(path, "GBK"));
        build.setFileName(ByteString.copyFrom(file, "GBK"));
        DatagramArchive.datagram_get_next_archive _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        fields.addAll(this.getMsgHeader2(RtdbMsgID.MSG_GET_NEXT_ARCHIVE, 1, 0, 0, 1, myByte.length));
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetNextArchiveRespFields(int ret, String path, String file, int state) throws UnsupportedEncodingException {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        DatagramArchive.datagram_get_next_archive_resp.Builder build = DatagramArchive.datagram_get_next_archive_resp.newBuilder();
        build.setFileState(state);
        build.setPath(ByteString.copyFrom(path, "GBK"));
        build.setFileName(ByteString.copyFrom(file, "GBK"));
        DatagramArchive.datagram_get_next_archive_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        fields.addAll(this.getMsgHeader2(RtdbMsgID.MSG_GET_NEXT_ARCHIVE, 1, 0, 0, 1, myByte.length));
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetArchiveInfoFields(String path, String file, int file_id) throws UnsupportedEncodingException {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        DatagramArchive.datagram_get_archive_info.Builder build = DatagramArchive.datagram_get_archive_info.newBuilder();
        build.setAttachedFileId(file_id);
        build.setPath(ByteString.copyFrom(path, "GBK"));
        build.setFileName(ByteString.copyFrom(file, "GBK"));
        DatagramArchive.datagram_get_archive_info _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        fields.addAll(this.getMsgHeader2(RtdbMsgID.MSG_GET_ARCHIVE_INFO, 1, 0, 0, 1, myByte.length));
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetArchiveInfoRespFields(String filename, byte[] ids) throws UnsupportedEncodingException {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        DatagramArchive.datagram_get_archive_info_resp.Builder build = DatagramArchive.datagram_get_archive_info_resp.newBuilder();
        build.setArchivedInfo(ByteString.copyFrom(ids));
        DatagramArchive.datagram_get_archive_info_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        fields.addAll(this.getMsgHeader2(RtdbMsgID.MSG_GET_ARCHIVE_INFO, 1, 0, 0, 1, myByte.length));
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetArchivesInfoFields(String[] path, String[] file) throws UnsupportedEncodingException {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        DatagramArchive.datagram_get_archives_info.Builder build = DatagramArchive.datagram_get_archives_info.newBuilder();
        for (int i = 0; i < path.length; ++i) {
            ByteString f = ByteString.copyFrom(file[i], "GBK");
            ByteString p = ByteString.copyFrom(path[i], "GBK");
            build.addFiles(f);
            build.addPaths(p);
        }
        DatagramArchive.datagram_get_archives_info _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        fields.addAll(this.getMsgHeader2(RtdbMsgID.MSG_GET_ARCHIVES_INFO, 1, 0, path.length, 1, myByte.length));
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetArchivesInfoRespFields() throws UnsupportedEncodingException {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        DatagramArchive.datagram_get_archives_info_resp.Builder build = DatagramArchive.datagram_get_archives_info_resp.newBuilder();
        DatagramArchive.datagram_get_archives_info_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        fields.addAll(this.getMsgHeader2(RtdbMsgID.MSG_GET_ARCHIVES_INFO, 1, 0, 0, 1, myByte.length));
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgUpdateArchiveFields(int RatedCapacity, int ExCapacity, short AutoMerge, short AutoArrange, String path, String file) throws UnsupportedEncodingException {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        DatagramArchive.datagram_update_archive.Builder build = DatagramArchive.datagram_update_archive.newBuilder();
        build.setRatedCapacity(RatedCapacity);
        build.setAttachedCapacity(ExCapacity);
        build.setAutoMergeAttaches(AutoMerge);
        build.setAutoArragne(AutoArrange);
        build.setPath(ByteString.copyFrom(path, "GBK"));
        build.setFileName(ByteString.copyFrom(file, "GBK"));
        DatagramArchive.datagram_update_archive _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        fields.addAll(this.getMsgHeader2(RtdbMsgID.MSG_UPDATE_ARCHIVE, 1, 0, 0, 1, myByte.length));
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgUpdateArchiveRespFields(int ret) throws UnsupportedEncodingException {
        return this.msgCommonRespFields(RtdbMsgID.MSG_UPDATE_ARCHIVE, 0, ret);
    }

    @Override
    public List<RtdbField> msgMergeArchiveFields(String path, String file) throws UnsupportedEncodingException {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        DatagramArchive.datagram_merge_archive.Builder build = DatagramArchive.datagram_merge_archive.newBuilder();
        build.setPath(ByteString.copyFrom(path, "GBK"));
        build.setFileName(ByteString.copyFrom(file, "GBK"));
        DatagramArchive.datagram_merge_archive _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        fields.addAll(this.getMsgHeader2(RtdbMsgID.MSG_MERGE_ARCHIVE, 1, 0, 0, 1, myByte.length));
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgMergeArchiveRespFields(int ret) throws UnsupportedEncodingException {
        return this.msgCommonRespFields(RtdbMsgID.MSG_MERGE_ARCHIVE, 0, ret);
    }

    @Override
    public List<RtdbField> msgReindexArchiveFields(String path, String file) throws UnsupportedEncodingException {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        DatagramArchive.datagram_reindex_archive.Builder build = DatagramArchive.datagram_reindex_archive.newBuilder();
        build.setPath(ByteString.copyFrom(path, "GBK"));
        build.setFileName(ByteString.copyFrom(file, "GBK"));
        DatagramArchive.datagram_reindex_archive _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        fields.addAll(this.getMsgHeader2(RtdbMsgID.MSG_REINDEX_ARCHIVE, 1, 0, 0, 1, myByte.length));
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgReindexArchiveRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_REINDEX_ARCHIVE, 0, ret);
    }

    @Override
    public List<RtdbField> msgConvertIndexFields(String path, String file) throws UnsupportedEncodingException {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        DatagramArchive.datagram_convert_index.Builder build = DatagramArchive.datagram_convert_index.newBuilder();
        build.setPath(ByteString.copyFrom(path, "GBK"));
        build.setFileName(ByteString.copyFrom(file, "GBK"));
        DatagramArchive.datagram_convert_index _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        fields.addAll(this.getMsgHeader2(RtdbMsgID.MSG_CONVERT_INDEX, 1, 0, 0, 1, myByte.length));
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgConvertIndexRespFields(int ret) {
        return this.msgCommonRespFields(RtdbMsgID.MSG_CONVERT_INDEX, 0, ret);
    }

    @Override
    public List<RtdbField> msgArrangeArchiveFields(String path, String file) throws UnsupportedEncodingException {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        DatagramArchive.datagram_arrange_archive.Builder build = DatagramArchive.datagram_arrange_archive.newBuilder();
        build.setPath(ByteString.copyFrom(path, "GBK"));
        build.setFileName(ByteString.copyFrom(file, "GBK"));
        DatagramArchive.datagram_arrange_archive _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        fields.addAll(this.getMsgHeader2(RtdbMsgID.MSG_ARRANGE_ARCHIVE, 1, 0, 0, 1, myByte.length));
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgArrangeArchiveRespFields(int ret) throws UnsupportedEncodingException {
        return this.msgCommonRespFields(RtdbMsgID.MSG_ARRANGE_ARCHIVE, 0, ret);
    }

    @Override
    public List<RtdbField> msgBackupArchiveFields(String path, String file, String dest) throws UnsupportedEncodingException {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        DatagramArchive.datagram_backup_archive.Builder build = DatagramArchive.datagram_backup_archive.newBuilder();
        build.setSrcPath(ByteString.copyFrom(path, "GBK"));
        build.setDestPath(ByteString.copyFrom(dest, "GBK"));
        build.setSrcFileName(ByteString.copyFrom(file, "GBK"));
        DatagramArchive.datagram_backup_archive _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        fields.addAll(this.getMsgHeader2(RtdbMsgID.MSG_BACKUP_ARCHIVE, 1, 0, 0, 1, myByte.length));
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgBackupArchiveRespFields(int ret) throws UnsupportedEncodingException {
        return this.msgCommonRespFields(RtdbMsgID.MSG_BACKUP_ARCHIVE, 0, ret);
    }

    @Override
    public List<RtdbField> msgCanceBigJobFields(int process) throws UnsupportedEncodingException {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        DatagramArchive.datagram_cancel_big_job.Builder build = DatagramArchive.datagram_cancel_big_job.newBuilder();
        build.setProccessId(process);
        DatagramArchive.datagram_cancel_big_job _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        fields.addAll(this.getMsgHeader2(RtdbMsgID.MSG_CANCEL_BIG_JOB, 1, 0, 0, 1, myByte.length));
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgQueryBigJobFields(int process) throws UnsupportedEncodingException {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        DatagramArchive.datagram_query_big_job.Builder build = DatagramArchive.datagram_query_big_job.newBuilder();
        build.setProccessId(process);
        DatagramArchive.datagram_query_big_job _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        fields.addAll(this.getMsgHeader2(RtdbMsgID.MSG_QUERY_BIG_JOB, 1, 0, 0, 1, myByte.length));
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgQueryBigJobRespFields(int ret, int job, int state, int endtime, float progress, String path, String file) throws UnsupportedEncodingException {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        DatagramArchive.datagram_query_big_job_resp.Builder build = DatagramArchive.datagram_query_big_job_resp.newBuilder();
        build.setJobId(job);
        build.setJobState(state);
        build.setJobFinishedTime(endtime);
        build.setJobProgress(progress);
        build.setPath(ByteString.copyFrom(path, "GBK"));
        build.setFileName(ByteString.copyFrom(file, "GBK"));
        DatagramArchive.datagram_query_big_job_resp _packet = build.build();
        byte[] myByte = _packet.toByteArray();
        fields.addAll(this.getMsgHeader2(RtdbMsgID.MSG_QUERY_BIG_JOB, 1, ret, 0, 1, myByte.length));
        this.msgAddBytes(fields, myByte, "len", "buf_data");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgMoveArchiveRespFields() throws UnsupportedEncodingException {
        ArrayList<RtdbField> fileds = new ArrayList<RtdbField>();
        DatagramArchive.datagram_move_archive.Builder builder = DatagramArchive.datagram_move_archive.newBuilder();
        DatagramArchive.datagram_move_archive build = builder.build();
        byte[] byteArray = build.toByteArray();
        fileds.addAll(this.getMsgHeader2(RtdbMsgID.MSG_MOVE_ARCHIVE, 0, 0, 1, 1, 0));
        this.msgAddBytes(fileds, byteArray, "len", "buf_data");
        fileds.add(this.getMsgTail());
        return fileds;
    }

    @Override
    public List<RtdbField> msgMoveArchiveFields(String fileName, String path, String dest) throws UnsupportedEncodingException {
        ArrayList<RtdbField> fileds = new ArrayList<RtdbField>();
        DatagramArchive.datagram_move_archive.Builder builder = DatagramArchive.datagram_move_archive.newBuilder();
        byte[] fileNameBytes = fileName.getBytes();
        byte[] pathBytes = path.getBytes();
        byte[] destBytes = dest.getBytes();
        builder.setSrcFileName(ByteString.copyFrom(fileNameBytes));
        builder.setSrcPath(ByteString.copyFrom(pathBytes));
        builder.setDestPath(ByteString.copyFrom(destBytes));
        DatagramArchive.datagram_move_archive build = builder.build();
        byte[] buf = build.toByteArray();
        fileds.addAll(this.getMsgHeader2(RtdbMsgID.MSG_MOVE_ARCHIVE, 0, 0, 1, 1, buf.length));
        this.msgAddBytes(fileds, buf, "len", "buf_data");
        fileds.add(this.getMsgTail());
        return fileds;
    }
}

