/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.api.msg;

import com.rtdb.api.enums.RtdbMsgID;
import com.rtdb.api.impl.adapter.HistorianAdapter;
import com.rtdb.api.model.DateTimeNS;
import com.rtdb.api.model.RtdbField;
import com.rtdb.api.util.DateUtil;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HistorianProtocol21
extends HistorianAdapter {
    private Log log = LogFactory.getLog(HistorianProtocol21.class);
    private static HistorianProtocol21 historianProtocol;

    private HistorianProtocol21() {
    }

    public static HistorianProtocol21 getInstance() {
        if (historianProtocol == null) {
            historianProtocol = new HistorianProtocol21();
        }
        return historianProtocol;
    }

    @Override
    public List<RtdbField> msgArchivedValuesCountFields(int id, Object beginTime, Object endTime) throws ParseException {
        int datetime1 = 0;
        int ms1 = 0;
        int datetime2 = 0;
        int ms2 = 0;
        if (beginTime != null) {
            if (beginTime.getClass().equals(Date.class)) {
                datetime1 = DateUtil.getSecond((Date)beginTime);
                ms1 = DateUtil.getMilSecond((Date)beginTime);
            } else {
                datetime1 = DateUtil.getSecond(((DateTimeNS)beginTime).getDatetime());
                ms1 = ((DateTimeNS)beginTime).getNanosecond();
            }
        }
        if (endTime != null) {
            if (endTime.getClass().equals(Date.class)) {
                datetime2 = DateUtil.getSecond((Date)endTime);
                ms2 = DateUtil.getMilSecond((Date)endTime);
            } else {
                datetime2 = DateUtil.getSecond(((DateTimeNS)endTime).getDatetime());
                ms2 = ((DateTimeNS)endTime).getNanosecond();
            }
        }
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_ARCHIVED_VALUES_COUNT, 0, 0, 0, 1));
        list.add(new RtdbField(3, id, 0.0, null, 1, "id"));
        list.add(new RtdbField(3, datetime1, 0.0, null, 1, "datetime1"));
        list.add(new RtdbField(2, ms1, 0.0, null, 1, "ms1"));
        list.add(new RtdbField(3, datetime2, 0.0, null, 1, "datetime2"));
        list.add(new RtdbField(2, ms2, 0.0, null, 1, "ms2"));
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgArchivedValuesCountRespFields(int ret, int count) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_ARCHIVED_VALUES_COUNT, 0, ret, count, 1));
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetSingleValueRespFields(int ret, int datetime, int ms, int value, int state, int quality) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_SINGLE_VALUE, 0, ret, 0, 1));
        list.add(new RtdbField(3, datetime, 0.0, null, 1, "datetime"));
        list.add(new RtdbField(2, ms, 0.0, null, 1, "ms"));
        list.add(new RtdbField(6, value, 0.0, null, 1, "value"));
        list.add(new RtdbField(4, state, 0.0, null, 1, "state"));
        list.add(new RtdbField(2, quality, 0.0, null, 1, "quality"));
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetSingleValueFields(int id, Object date, int mode) throws ParseException {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        int datetime = 0;
        int ms = 0;
        if (date.getClass().equals(Date.class)) {
            datetime = DateUtil.getSecond((Date)date);
            ms = DateUtil.getMilSecond((Date)date);
        } else {
            datetime = DateUtil.getSecond(((DateTimeNS)date).getDatetime());
            ms = ((DateTimeNS)date).getNanosecond();
        }
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_SINGLE_VALUE, 0, 0, 0, 1));
        list.add(new RtdbField(3, id, 0.0, null, 1, "id"));
        list.add(new RtdbField(3, mode, 0.0, null, 1, "mode"));
        list.add(new RtdbField(3, datetime, 0.0, null, 1, "datetime"));
        list.add(new RtdbField(3, ms, 0.0, null, 1, "ms"));
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetSingleDatetimeValueFields(int id, Object date, int mode) throws ParseException {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        int datetime = 0;
        int ms = 0;
        if (date.getClass().equals(Date.class)) {
            datetime = DateUtil.getSecond((Date)date);
            ms = DateUtil.getMilSecond((Date)date);
        } else {
            datetime = DateUtil.getSecond(((DateTimeNS)date).getDatetime());
            ms = ((DateTimeNS)date).getNanosecond();
        }
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_SINGLE_DATETIME_VALUE, 0, 0, 0, 1));
        list.add(new RtdbField(3, id, 0.0, null, 1, "id"));
        list.add(new RtdbField(3, mode, 0.0, null, 1, "mode"));
        list.add(new RtdbField(3, datetime, 0.0, null, 1, "datetime"));
        list.add(new RtdbField(3, ms, 0.0, null, 1, "ms"));
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetSingleDatetimeValueRESPFields(int ret, int datetime, int ms, int value, int state, int quality, int type) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_SINGLE_DATETIME_VALUE, 0, ret, 0, 1));
        list.add(new RtdbField(3, datetime, 0.0, null, 1, "datetime"));
        list.add(new RtdbField(2, ms, 0.0, null, 1, "ms"));
        list.add(new RtdbField(6, value, 0.0, null, 1, "value"));
        list.add(new RtdbField(4, state, 0.0, null, 1, "state"));
        list.add(new RtdbField(2, quality, 0.0, null, 1, "quality"));
        list.add(new RtdbField(3, type, 0.0, null, 1, "type"));
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgPutSingleDatetimeValueFields(int id, Date date, int ms, long state, short quality, long value) throws ParseException {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        int datetime = DateUtil.getSecond(date);
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_PUT_SINGLE_DATETIME_VALUE, 1, 0, 0, 1));
        this.msgAddInt(list, id, "id");
        this.msgAddInt(list, datetime, "datetime");
        this.msgAddInt(list, ms, "ms");
        this.msgAddDouble(list, value, "value");
        this.msgAddLong(list, state, "state");
        this.msgAddShort(list, quality, "quality");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgPutSingleDatetimeValueRespFilds() {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_PUT_SINGLE_DATETIME_VALUE, 0, 0, 0, 1));
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgPutBlobArchivedFields(int totalCount, int count, int[] ids, int[] datetimesVal, short[] msVal, byte[][] blobs, short[] qualities) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_PUT_ARCHIVED_BLOB_VALUES, 0, 0, totalCount, count));
        this.msgAddIntArray(list, ids, "ids");
        this.msgAddIntArray(list, datetimesVal, "datetimes");
        this.msgAddShortArray(list, msVal, "ms");
        this.msgAddBytesArray(list, blobs, "lens", "blobs");
        this.msgAddShortArray(list, qualities, "qualities");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgPutBlobArchivedRespFields(int ret, int count, int size, int[] errors) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_PUT_ARCHIVED_BLOB_VALUES, 0, ret, count, size));
        this.msgAddIntArray(list, errors, "errors");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgSummaryFields(int id, int datetime1, int ms1, int datetime2, int ms2) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_SUMMARY, 0, 0, 0, 1));
        this.msgAddInt(list, id, "id");
        this.msgAddInt(list, datetime1, "datetime1");
        this.msgAddInt(list, ms1, "ms1");
        this.msgAddInt(list, datetime2, "datetime2");
        this.msgAddInt(list, ms2, "ms2");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgSummaryRespFields(int ret, int datetime1, short ms1, int datetime2, short ms2, double max, double min, double total, double calc, double power) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_SUMMARY, 0, ret, 0, 1));
        this.msgAddInt(list, datetime1, "datetime1");
        this.msgAddShort(list, ms1, "ms1");
        this.msgAddInt(list, datetime2, "datetime2");
        this.msgAddShort(list, ms2, "ms2");
        this.msgAddDouble(list, max, "max");
        this.msgAddDouble(list, min, "min");
        this.msgAddDouble(list, total, "total");
        this.msgAddDouble(list, calc, "calc");
        this.msgAddDouble(list, power, "power");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgSummaryExFields(int id, int datetime1, short ms1, int datetime2, short ms2) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_SUMMARY_EX, 0, 0, 0, 1));
        this.msgAddInt(list, id, "id");
        this.msgAddInt(list, datetime1, "datetime1");
        this.msgAddShort(list, ms1, "ms1");
        this.msgAddInt(list, datetime2, "datetime2");
        this.msgAddShort(list, ms2, "ms2");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgSummaryExRespFields(int ret, int datetime1, short ms1, int datetime2, short ms2, double max, double min, double total, double calc, double power, long count) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_SUMMARY_EX, 0, ret, 0, 1));
        this.msgAddInt(list, datetime1, "datetime1");
        this.msgAddShort(list, ms1, "ms1");
        this.msgAddInt(list, datetime2, "datetime2");
        this.msgAddShort(list, ms2, "ms2");
        this.msgAddDouble(list, max, "max");
        this.msgAddDouble(list, min, "min");
        this.msgAddDouble(list, total, "total");
        this.msgAddDouble(list, calc, "calc");
        this.msgAddDouble(list, power, "power");
        this.msgAddLong(list, count, "count");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgSummaryInBatchField(int id, int count, long interval, int datetime1, int ms1, int datetime2, int ms2) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_SUMMARY_IN_BATCHES, 0, 0, count, 1));
        this.msgAddInt(list, id, "id");
        this.msgAddLong(list, interval, "interval");
        this.msgAddInt(list, datetime1, "datetime1");
        this.msgAddInt(list, ms1, "ms1");
        this.msgAddInt(list, datetime2, "datetime2");
        this.msgAddInt(list, ms2, "ms2");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgSummaryInBatchRespFields(int ret, int count, int[] datetime1, int[] ms1, int[] datetime2, int[] ms2, double[] max, double[] min, double[] total, double[] calc, double[] power, int[] errors) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_SUMMARY_IN_BATCHES, 0, ret, count, count));
        this.msgAddIntArray(list, datetime1, "datetime1");
        this.msgAddIntArray(list, ms1, "ms1");
        this.msgAddIntArray(list, datetime2, "datetime2");
        this.msgAddIntArray(list, ms2, "ms2");
        this.msgAddDoubleArray(list, max, "maxs");
        this.msgAddDoubleArray(list, min, "mins");
        this.msgAddDoubleArray(list, total, "totals");
        this.msgAddDoubleArray(list, calc, "calcs");
        this.msgAddDoubleArray(list, power, "powers");
        this.msgAddIntArray(list, errors, "errors");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetPlotValuesFields(int id, int interval, int count, int datetime1, int ms1, int datetime2, int ms2) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_PLOT_VALUES, 0, 0, count, 1));
        this.msgAddInt(list, id, "id");
        this.msgAddInt(list, interval, "interval");
        this.msgAddInt(list, datetime1, "datetime1");
        this.msgAddInt(list, ms1, "ms1");
        this.msgAddInt(list, datetime2, "datetime2");
        this.msgAddInt(list, ms2, "ms2");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetPlotValuesRespFields(int ret, int count, int[] datetimes, int[] ms, double[] values, long[] states, short[] qualities) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_PLOT_VALUES, 0, ret, count, count));
        this.msgAddIntArray(list, datetimes, "datetimes");
        this.msgAddIntArray(list, ms, "ms");
        this.msgAddDoubleArray(list, values, "values");
        this.msgAddLongArray(list, states, "states");
        this.msgAddShortArray(list, qualities, "qualities");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetCrossSectionValuesFields(int mode, int count, int[] ids, int[] datetimes, int[] ms) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_CROSS_SECTION_VALUES, 0, 0, count, count));
        this.msgAddInt(list, mode, "mode");
        this.msgAddIntArray(list, ids, "ids");
        this.msgAddIntArray(list, datetimes, "datetimes");
        this.msgAddIntArray(list, ms, "ms");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgGetCrossSectionValuesRespFields(int ret, int count, int[] datetimes, int[] ms, double[] values, long[] states, short[] qualities, int[] errors) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_CROSS_SECTION_VALUES, 1, ret, count, count));
        this.msgAddIntArray(list, datetimes, "datetimes");
        this.msgAddIntArray(list, ms, "ms");
        this.msgAddDoubleArray(list, values, "values");
        this.msgAddLongArray(list, states, "states");
        this.msgAddShortArray(list, qualities, "qualities");
        this.msgAddIntArray(list, errors, "errors");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgPutSingleValueRespFields() {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_PUT_SINGLE_VALUE, 0, 0, 0, 1));
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgPutSingleValueFields(int id, int datetime, int ms, double value, long state, short quality) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_PUT_SINGLE_VALUE, 1, 0, 0, 1));
        fields.add(new RtdbField(3, id, 0.0, null, 1, "id"));
        fields.add(new RtdbField(3, datetime, 0.0, null, 1, "datetime"));
        fields.add(new RtdbField(3, ms, 0.0, null, 1, "ms"));
        fields.add(new RtdbField(6, 0L, value, null, 1, "value"));
        fields.add(new RtdbField(4, state, 0.0, null, 1, "state"));
        fields.add(new RtdbField(2, quality, 0.0, null, 1, "quality"));
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetArchivedValuesRespFields(int counts, int[] datetimes, int[] ms, double[] values, long[] states, short[] qualities) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_ARCHIVED_VALUES, 0, 0, 0, 0));
        this.msgAddIntArray(fields, datetimes, "datetimes");
        this.msgAddIntArray(fields, ms, "ms");
        this.msgAddDoubleArray(fields, values, "values");
        this.msgAddLongArray(fields, states, "states");
        this.msgAddShortArray(fields, qualities, "qualities");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetArchivedValuesFields(int id, int count, int datetime1, int ms1, int datetime2, int ms2) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_ARCHIVED_VALUES, 0, 0, count, 1));
        this.msgAddInt(fields, id, "id");
        this.msgAddInt(fields, datetime1, "datetime1");
        this.msgAddInt(fields, ms1, "ms1");
        this.msgAddInt(fields, datetime2, "datetime2");
        this.msgAddInt(fields, ms2, "ms2");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetArchivedValuesBackwardRespFields(int[] datetimes, int[] ms, double[] values, long[] states, short[] qualities) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_ARCHIVED_VALUES_BACKWARD, 0, 0, 0, 0));
        this.msgAddIntArray(fields, datetimes, "datetimes");
        this.msgAddIntArray(fields, ms, "ms");
        this.msgAddDoubleArray(fields, values, "values");
        this.msgAddLongArray(fields, states, "states");
        this.msgAddShortArray(fields, qualities, "qualities");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetArchivedValuesBackwardFields(int count, int id, int datetime1, int ms1, int datetime2, int ms2) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_ARCHIVED_VALUES_BACKWARD, 0, 0, count, 1));
        this.msgAddInt(fields, id, "id");
        this.msgAddInt(fields, datetime1, "datetime1");
        this.msgAddShort(fields, (short)ms1, "ms1");
        this.msgAddInt(fields, datetime2, "datetime2");
        this.msgAddShort(fields, (short)ms2, "ms2");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetArchivedCoorValuesRespFields(int[] datetimes, int[] ms, float[] x, float[] y, short[] qualities) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_ARCHIVED_COOR_VALUES, 0, 0, 0, 0));
        this.msgAddIntArray(fields, datetimes, "datetimes");
        this.msgAddIntArray(fields, ms, "ms");
        this.msgAddFloatArray(fields, x, "x");
        this.msgAddFloatArray(fields, y, "y");
        this.msgAddShortArray(fields, qualities, "qualities");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetArchivedCoorValuesFields(int count, int id, int datetime1, int ms1, int datetime2, int ms2) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_ARCHIVED_COOR_VALUES, 0, 0, count, 1));
        this.msgAddInt(fields, id, "id");
        this.msgAddInt(fields, datetime1, "datetime1");
        this.msgAddInt(fields, ms1, "ms1");
        this.msgAddInt(fields, datetime2, "datetime2");
        this.msgAddInt(fields, ms2, "ms2");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetArchivedCoorValuesBackwardRespFields(int count, int[] datetimes, int[] ms, float[] x, float[] y, short[] qualities) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_ARCHIVED_COOR_VALUES_BACKWARD, 0, 0, count, 0));
        this.msgAddIntArray(fields, datetimes, "datetimes");
        this.msgAddIntArray(fields, ms, "ms");
        this.msgAddFloatArray(fields, x, "x");
        this.msgAddFloatArray(fields, y, "y");
        this.msgAddShortArray(fields, qualities, "qualities");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetArchivedCoorValuesBackwardFields(int count, int id, int datetime1, int ms1, int datetime2, int ms2) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_ARCHIVED_COOR_VALUES_BACKWARD, 0, 0, count, 0));
        this.msgAddInt(fields, id, "id");
        this.msgAddInt(fields, datetime1, "datetime1");
        this.msgAddInt(fields, ms1, "ms1");
        this.msgAddInt(fields, datetime2, "datetime2");
        this.msgAddInt(fields, ms2, "ms2");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetArchivedValuesBatchCountRespFields(int bath) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_ARCHIVED_VALUES_IN_BATCHES, 0, 0, 0, 1));
        this.msgAddInt(fields, 0, "batch");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetArchivedValuesBatchCountFields(int id, int datetime1, int ms1, int datetime2, int ms2) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_ARCHIVED_VALUES_IN_BATCHES, 0, 0, 0, 1));
        this.msgAddInt(fields, id, "id");
        this.msgAddInt(fields, datetime1, "datetime1");
        this.msgAddInt(fields, ms1, "ms1");
        this.msgAddInt(fields, datetime2, "datetime2");
        this.msgAddInt(fields, ms2, "ms2");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetNextArchivedValuesFields(int count, int id) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_NEXT_ARCHIVED_VALUES, 0, 0, count, 1));
        this.msgAddInt(fields, id, "id");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetNextArchivedValuesRespFields(int count, int[] datetimes, int[] ms, double[] values, long[] states, short[] qualities) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_NEXT_ARCHIVED_VALUES, 1, 0, 0, 0));
        this.msgAddIntArray(fields, datetimes, "datetimes");
        this.msgAddIntArray(fields, ms, "ms");
        this.msgAddDoubleArray(fields, values, "values");
        this.msgAddLongArray(fields, states, "states");
        this.msgAddShortArray(fields, qualities, "qualities");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetSingleCoorValueRespFields() {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_SINGLE_COOR_VALUE, 0, 0, 0, 1));
        this.msgAddInt(fields, 0, "datetime");
        this.msgAddShort(fields, (short)0, "ms");
        this.msgAddFloat(fields, 0.0f, "x");
        this.msgAddFloat(fields, 0.0f, "y");
        this.msgAddShort(fields, (short)0, "quality");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetSingleCoorValueFields(int id, int mode, int datetime, int ms) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_SINGLE_COOR_VALUE, 0, 0, 0, 1));
        this.msgAddInt(fields, id, "id");
        this.msgAddInt(fields, mode, "mode");
        this.msgAddInt(fields, datetime, "datetime");
        this.msgAddInt(fields, ms, "ms");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetSingleBlobValueRespFields(byte[] blob) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_SINGLE_BLOB_VALUE, 1, 0, 0, 1));
        this.msgAddInt(fields, 0, "datetime");
        this.msgAddShort(fields, (short)0, "ms");
        this.msgAddBytes1(fields, blob, "len", "blob");
        this.msgAddShort(fields, (short)0, "quality");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetSingleBlobValueFields(short len, int id, int mode, int datetime, int ms) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_SINGLE_BLOB_VALUE, 0, 0, len, 1));
        this.msgAddInt(fields, id, "id");
        this.msgAddInt(fields, mode, "mode");
        this.msgAddInt(fields, datetime, "datetime");
        this.msgAddInt(fields, ms, "ms");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetTimedValuesRespFields(double[] values, long[] states, short[] qualities) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_TIMED_VALUES, 0, 0, 0, 0));
        this.msgAddDoubleArray(fields, values, "values");
        this.msgAddLongArray(fields, states, "states");
        this.msgAddShortArray(fields, qualities, "qualities");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetTimedValuesFields(int count, int id, int[] datetime, int[] ms) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_TIMED_VALUES, 0, 0, count, count));
        this.msgAddInt(fields, id, "id");
        this.msgAddIntArray(fields, datetime, "datetimes");
        this.msgAddIntArray(fields, ms, "ms");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetTimedCoorValuesRespFields(int count, float[] x, float[] y, short[] qualities) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_TIMED_COOR_VALUES, 0, 0, count, 0));
        this.msgAddFloatArray(fields, x, "x");
        this.msgAddFloatArray(fields, y, "y");
        this.msgAddShortArray(fields, qualities, "qualities");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetTimedCoorValuesFields(int count, int id, int[] datetime, int[] ms) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_TIMED_COOR_VALUES, 0, 0, count, count));
        this.msgAddInt(fields, id, "id");
        this.msgAddIntArray(fields, datetime, "datetimes");
        this.msgAddIntArray(fields, ms, "ms");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetInterPoValuesRespFields(int[] datetimes, int[] ms, double[] values, long[] states, short[] qualities) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_INTERPO_VALUES, 0, 0, 0, 0));
        this.msgAddIntArray(fields, datetimes, "datetimes");
        this.msgAddIntArray(fields, ms, "ms");
        this.msgAddDoubleArray(fields, values, "values");
        this.msgAddLongArray(fields, states, "values");
        this.msgAddShortArray(fields, qualities, "qualities");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetInterPoValuesFields(int count, int id, int datetime1, int ms1, int datetime2, int ms2) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_INTERPO_VALUES, 0, 0, count, 1));
        this.msgAddInt(fields, id, "id");
        this.msgAddInt(fields, datetime1, "datetime1");
        this.msgAddInt(fields, ms1, "ms1");
        this.msgAddInt(fields, datetime2, "datetime2");
        this.msgAddInt(fields, ms2, "ms2");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetIntervalValuesRespFields(int count, int[] datetimes, int[] mss, double[] values, long[] states, short[] qualities) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_INTERVAL_VALUES, 0, 0, 0, 0));
        this.msgAddIntArray(fields, datetimes, "datetimes");
        this.msgAddIntArray(fields, mss, "ms");
        this.msgAddDoubleArray(fields, values, "values");
        this.msgAddLongArray(fields, states, "values");
        this.msgAddShortArray(fields, qualities, "qualities");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetIntervalValuesFields(int count, int id, long interval, int datetime, int ms) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_INTERVAL_VALUES, 0, 0, count, 1));
        this.msgAddInt(fields, id, "id");
        this.msgAddLong(fields, interval, "interval");
        this.msgAddInt(fields, datetime, "datetime");
        this.msgAddInt(fields, ms, "ms");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetArchivedValuesFiltRespFields(int count, int[] datetimes, int[] ms, double[] values, long[] states, short[] qualities) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_ARCHIVED_VALUES_FILT, 0, 0, 0, 0));
        this.msgAddIntArray(fields, datetimes, "datetimes");
        this.msgAddIntArray(fields, ms, "ms");
        this.msgAddDoubleArray(fields, values, "values");
        this.msgAddLongArray(fields, states, "states");
        this.msgAddShortArray(fields, qualities, "qualities");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetArchivedValuesFiltFields(int count, int id, int datetime1, int ms1, int datetime2, int ms2, String filter) throws UnsupportedEncodingException {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_ARCHIVED_VALUES_FILT, 1, 0, count, 1));
        this.msgAddInt(fields, id, "id");
        this.msgAddInt(fields, datetime1, "datetime1");
        this.msgAddInt(fields, ms1, "ms1");
        this.msgAddInt(fields, datetime2, "datetime2");
        this.msgAddInt(fields, ms2, "m2");
        this.msgAddString(fields, filter, "len", "filter");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetSummaryFiltRespFields() {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_SUMMARY_FILT, 0, 0, 0, 1));
        this.msgAddInt(fields, 0, "datetime1");
        this.msgAddShort(fields, (short)0, "ms1");
        this.msgAddInt(fields, 0, "datetime2");
        this.msgAddShort(fields, (short)0, "ms2");
        this.msgAddDouble(fields, 0.0, "max");
        this.msgAddDouble(fields, 0.0, "min");
        this.msgAddDouble(fields, 0.0, "total");
        this.msgAddDouble(fields, 0.0, "calc");
        this.msgAddDouble(fields, 0.0, "power");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetSummaryFiltFields(int id, int datetime1, int ms1, int datetime2, int ms2, String filter) throws UnsupportedEncodingException {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_SUMMARY_FILT, 1, 0, 0, 1));
        this.msgAddInt(fields, id, "id");
        this.msgAddInt(fields, datetime1, "datetime1");
        this.msgAddInt(fields, ms1, "ms1");
        this.msgAddInt(fields, datetime2, "datetime2");
        this.msgAddInt(fields, ms2, "m2");
        this.msgAddString(fields, filter, "len", "filter");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetSummaryFiltExRespFields() {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_SUMMARY_FILT_EX, 0, 0, 0, 1));
        this.msgAddInt(fields, 0, "datetime1");
        this.msgAddShort(fields, (short)0, "ms1");
        this.msgAddInt(fields, 0, "datetime2");
        this.msgAddShort(fields, (short)0, "ms2");
        this.msgAddDouble(fields, 0.0, "max");
        this.msgAddDouble(fields, 0.0, "min");
        this.msgAddDouble(fields, 0.0, "total");
        this.msgAddDouble(fields, 0.0, "calc");
        this.msgAddDouble(fields, 0.0, "power");
        this.msgAddLong(fields, 0L, "count");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetSummaryFiltExFields(int id, int datetime1, short ms1, int datetime2, short ms2, String filter) throws UnsupportedEncodingException {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_SUMMARY_FILT_EX, 1, 0, 0, 1));
        this.msgAddInt(fields, id, "id");
        this.msgAddInt(fields, datetime1, "datetime1");
        this.msgAddShort(fields, ms1, "ms1");
        this.msgAddInt(fields, datetime2, "datetime2");
        this.msgAddShort(fields, ms2, "m2");
        this.msgAddString(fields, filter, "len", "filter");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetSummaryFiltInBatchesRespFields(int count, int[] datetimes1, int[] ms1_ret, int[] datetimes2, int[] ms2_ret, double[] max_values, double[] min_values, double[] total_values, double[] calc_avgs, double[] power_avgs, int[] errors) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_SUMMARY_FILT_IN_BATCHES, 0, 0, 0, 0));
        this.msgAddIntArray(fields, datetimes1, "datetimes1");
        this.msgAddIntArray(fields, ms1_ret, "ms1");
        this.msgAddIntArray(fields, datetimes2, "datetimes2");
        this.msgAddIntArray(fields, ms2_ret, "ms2");
        this.msgAddDoubleArray(fields, max_values, "maxs");
        this.msgAddDoubleArray(fields, min_values, "mins");
        this.msgAddDoubleArray(fields, total_values, "totals");
        this.msgAddDoubleArray(fields, calc_avgs, "calcs");
        this.msgAddDoubleArray(fields, power_avgs, "powers");
        this.msgAddIntArray(fields, errors, "errors");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetSummaryFiltInBatchesFields(int count, int id, long interval, int datetime1, int ms1, int datetime2, int ms2, String filter) {
        ArrayList<RtdbField> fields;
        block2: {
            fields = null;
            try {
                fields = new ArrayList<RtdbField>();
                fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_SUMMARY_FILT_IN_BATCHES, 1, 0, count, 1));
                this.msgAddInt(fields, id, "id");
                this.msgAddLong(fields, interval, "interval");
                this.msgAddInt(fields, datetime1, "datetime1");
                this.msgAddInt(fields, ms1, "ms1");
                this.msgAddInt(fields, datetime2, "datetime2");
                this.msgAddInt(fields, ms2, "m2");
                this.msgAddString(fields, filter, "len", "filter");
                fields.add(this.getMsgTail());
            }
            catch (UnsupportedEncodingException e) {
                if (!this.log.isDebugEnabled()) break block2;
                this.log.error(e);
            }
        }
        return fields;
    }

    @Override
    public List<RtdbField> msgUpdateValueRespFields() {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.msgCommonRespFields(RtdbMsgID.MSG_UPDATE_VALUE, 0, 0));
        return fields;
    }

    @Override
    public List<RtdbField> msgUpdateValueFields(int id, int datetime, int ms, double value, long state, short quality) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_UPDATE_VALUE, 0, 0, 0, 1));
        this.msgAddInt(fields, id, "id");
        this.msgAddInt(fields, datetime, "datetime");
        this.msgAddInt(fields, ms, "ms");
        this.msgAddDouble(fields, value, "value");
        this.msgAddLong(fields, state, "state");
        this.msgAddShort(fields, quality, "quality");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgUpdateCoorValueRespFields() {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.msgCommonRespFields(RtdbMsgID.MSG_UPDATE_COOR_VALUE, 0, 0));
        return fields;
    }

    @Override
    public List<RtdbField> msgUpdateCoorValueFields(int id, int datetime, int ms, float x, float y, short quality) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_UPDATE_COOR_VALUE, 0, 0, 0, 1));
        this.msgAddInt(fields, id, "id");
        this.msgAddInt(fields, datetime, "datetime");
        this.msgAddInt(fields, ms, "ms");
        this.msgAddFloat(fields, x, "x");
        this.msgAddFloat(fields, y, "y");
        this.msgAddShort(fields, quality, "quality");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgRemoveValueRespFields() {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.msgCommonRespFields(RtdbMsgID.MSG_REMOVE_VALUE, 0, 0));
        return fields;
    }

    @Override
    public List<RtdbField> msgRemoveValueFields(int id, int datetime, short ms) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_REMOVE_VALUE, 0, 0, 0, 1));
        this.msgAddInt(fields, id, "id");
        this.msgAddInt(fields, datetime, "datetime");
        this.msgAddShort(fields, ms, "ms");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgRemoveValuesRespFields(int count) {
        ArrayList<RtdbField> rfields = new ArrayList<RtdbField>();
        rfields.addAll(this.getMsgHeader(RtdbMsgID.MSG_REMOVE_VALUES, 0, 0, 0, 1));
        rfields.add(new RtdbField(3, count, 0.0, null, 1, "count"));
        rfields.add(this.getMsgTail());
        return rfields;
    }

    @Override
    public List<RtdbField> msgRemoveValuesFields(int id, int date1_temp, int ms1_temp, int date2_temp, int ms2_temp) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_REMOVE_VALUES, 0, 0, 0, 1));
        this.msgAddInt(fields, id, "id");
        this.msgAddInt(fields, date1_temp, "datetime1");
        this.msgAddInt(fields, ms1_temp, "ms1");
        this.msgAddInt(fields, date2_temp, "datetime2");
        this.msgAddInt(fields, ms2_temp, "ms2");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgPutSingleCoorValueRespFields() {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.msgCommonRespFields(RtdbMsgID.MSG_PUT_SINGLE_COOR_VALUE, 0, 0));
        return fields;
    }

    @Override
    public List<RtdbField> msgPutSingleCoorValueFields(int id, int datetime, int ms, float x, float y, short quality) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_PUT_SINGLE_COOR_VALUE, 1, 0, 0, 1));
        this.msgAddInt(fields, id, "id");
        this.msgAddInt(fields, datetime, "datetime");
        this.msgAddInt(fields, ms, "ms");
        this.msgAddFloat(fields, x, "x");
        this.msgAddFloat(fields, y, "y");
        this.msgAddShort(fields, quality, "quality");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgPutSingleBlobValueRespFields() {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.msgCommonRespFields(RtdbMsgID.MSG_PUT_SINGLE_BLOB_VALUE, 0, 0));
        return fields;
    }

    @Override
    public List<RtdbField> msgPutSingleBlobValueFields(short len, int id, int datetime, int ms, byte[] blob, short quality) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_PUT_SINGLE_BLOB_VALUE, 1, 0, len, 1));
        this.msgAddInt(fields, id, "id");
        this.msgAddInt(fields, datetime, "datetime");
        this.msgAddInt(fields, ms, "ms");
        this.msgAddBytes1(fields, blob, "len", "blob");
        this.msgAddShort(fields, quality, "quality");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgPutArchivedValuesRespFields(int count, int[] errors) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_PUT_ARCHIVED_VALUES, 0, 0, 0, 0));
        this.msgAddIntArray(fields, errors, "errors");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgPutArchivedValuesFields(int count, int[] ids, int[] datetimes, int[] ms, double[] values, long[] states, short[] qualities) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_PUT_ARCHIVED_VALUES, 1, 0, count, count));
        this.msgAddIntArray(fields, ids, "ids");
        this.msgAddIntArray(fields, datetimes, "datetimes");
        this.msgAddIntArray(fields, ms, "ms");
        this.msgAddDoubleArray(fields, values, "values");
        this.msgAddLongArray(fields, states, "states");
        this.msgAddShortArray(fields, qualities, "qualities");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgPutArchivedCoorValuesRespFields(int[] errors) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_PUT_ARCHIVED_COOR_VALUES, 0, 0, 0, 0));
        this.msgAddIntArray(fields, errors, "errors");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgPutArchivedCoorValuesFields(int count, int[] ids, int[] datetimes, int[] ms, float[] x, float[] y, short[] qualities) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_PUT_ARCHIVED_COOR_VALUES, 1, 0, count, count));
        this.msgAddIntArray(fields, ids, "ids");
        this.msgAddIntArray(fields, datetimes, "datetimes");
        this.msgAddIntArray(fields, ms, "ms");
        this.msgAddFloatArray(fields, x, "values");
        this.msgAddFloatArray(fields, y, "states");
        this.msgAddShortArray(fields, qualities, "qualities");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgFlushArchivedValuesRespFields() {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_FLUSH_ARCHIVED_VALUES, 1, 0, 0, 1));
        this.msgAddInt(fields, 0, "count");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgFlushArchivedValuesFields(int id) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_FLUSH_ARCHIVED_VALUES, 0, 0, 0, 1));
        this.msgAddInt(fields, id, "id");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetArchivedBlobValuesRespFields(int count, byte[][] blobs, int[] datetimes, short[] ms, short[] qualities) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_ARCHIVED_BLOB_VALUES, 0, 0, 0, 0));
        this.msgAddIntArray(fields, datetimes, "datetimes");
        this.msgAddShortArray(fields, ms, "ms");
        this.msgAddBytesArray(fields, blobs, "lens", "blobs");
        this.msgAddShortArray(fields, qualities, "qualities");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetArchivedBlobValuesFields(int count, int id, int singleBlobCount, short[] lens, int datetime1, int ms1, int datetime2, int ms2) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_ARCHIVED_BLOB_VALUES, 0, 0, singleBlobCount * count, count));
        this.msgAddInt(fields, id, "id");
        this.msgAddInt(fields, datetime1, "datetime1");
        this.msgAddInt(fields, ms1, "ms1");
        this.msgAddInt(fields, datetime2, "datetime2");
        this.msgAddInt(fields, ms2, "ms2");
        for (int i = 0; i < lens.length; ++i) {
            lens[i] = (short)singleBlobCount;
        }
        this.msgAddShortArray(fields, lens, "lens");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetArchivedDatetimeValuesRespFields(int[] datetimes, int[] ms, double[] values, long[] states, short[] qualities) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_ARCHIVED_DATETIME_VALUES, 0, 0, 0, 0));
        this.msgAddIntArray(fields, datetimes, "datetimes");
        this.msgAddIntArray(fields, ms, "ms");
        this.msgAddDoubleArray(fields, values, "values");
        this.msgAddLongArray(fields, states, "states");
        this.msgAddShortArray(fields, qualities, "qualities");
        this.msgAddInt(fields, 0, "type");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgGetArchivedDatetimeValuesFields(int count, int id, int datetime1, int ms1, int datetime2, int ms2) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_GET_ARCHIVED_DATETIME_VALUES, 0, 0, count, 1));
        this.msgAddInt(fields, id, "id");
        this.msgAddInt(fields, datetime1, "datetime1");
        this.msgAddInt(fields, ms1, "ms1");
        this.msgAddInt(fields, datetime2, "datetime2");
        this.msgAddInt(fields, ms2, "ms2");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgPutArchivedDatetimeValuesRespFields(int count, int[] errors) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_PUT_ARCHIVED_DATETIME_VALUES, 0, 0, 0, 0));
        this.msgAddIntArray(fields, errors, "errors");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgPutArchivedDatetimeValuesFields(int count, int[] ids, int[] datetimes, int[] ms, double[] values, long[] states, short[] qualities) {
        ArrayList<RtdbField> fields = new ArrayList<RtdbField>();
        fields.addAll(this.getMsgHeader(RtdbMsgID.MSG_PUT_ARCHIVED_DATETIME_VALUES, 1, 0, count, count));
        this.msgAddIntArray(fields, ids, "ids");
        this.msgAddIntArray(fields, datetimes, "datetimes");
        this.msgAddIntArray(fields, ms, "ms");
        this.msgAddDoubleArray(fields, values, "values");
        this.msgAddLongArray(fields, states, "states");
        this.msgAddShortArray(fields, qualities, "qualities");
        fields.add(this.getMsgTail());
        return fields;
    }

    @Override
    public List<RtdbField> msgPutArchivedBlobValuesFields(int totalCount, int count, int[] ids, int[] datetimesVal, int[] msVal, byte[][] blobs, short[] qualities) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_PUT_ARCHIVED_BLOB_VALUES, 0, 0, totalCount, count));
        this.msgAddIntArray(list, ids, "ids");
        this.msgAddIntArray(list, datetimesVal, "datetimes");
        this.msgAddIntArray(list, msVal, "ms");
        this.msgAddBytesArray(list, blobs, "lens", "blobs");
        this.msgAddShortArray(list, qualities, "qualities");
        list.add(this.getMsgTail());
        return list;
    }

    @Override
    public List<RtdbField> msgPutArchivedBlobValuesRespFields(int ret, int count, int size, int[] errors) {
        ArrayList<RtdbField> list = new ArrayList<RtdbField>();
        list.addAll(this.getMsgHeader(RtdbMsgID.MSG_PUT_ARCHIVED_BLOB_VALUES, 0, ret, count, size));
        this.msgAddIntArray(list, errors, "errors");
        list.add(this.getMsgTail());
        return list;
    }
}

