/*
 * Decompiled with CFR 0.152.
 */
package com.rtdb.service.impl;

import com.rtdb.api.enums.RtdbArchiveState;
import com.rtdb.api.enums.RtdbProcessName;
import com.rtdb.api.exception.NoAuthorityException;
import com.rtdb.api.impl.RtdbArchivesImpl;
import com.rtdb.api.inter.IArchive;
import com.rtdb.api.model.RtdbArchiveData;
import com.rtdb.api.model.RtdbArchivePerfData;
import com.rtdb.api.model.RtdbBigJob;
import com.rtdb.api.model.RtdbHeaderPage;
import com.rtdb.enums.ArchiveState;
import com.rtdb.model.ArchiveEntity;
import com.rtdb.model.HeaderPage;
import com.rtdb.service.impl.ServerImpl;
import com.rtdb.service.inter.Archive;
import com.rtdb.until.RTDBConvert;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;

public class ArchiveImpl
implements Archive {
    private ServerImpl server;
    private IArchive ga;

    public ArchiveImpl(ServerImpl server) throws UnknownHostException, IOException, Exception {
        this.server = server;
        this.ga = new RtdbArchivesImpl(server);
    }

    @Override
    public void close() throws IOException, InterruptedException {
        this.server.close();
    }

    @Override
    public int getArchiveCount() throws NoAuthorityException, Exception {
        return this.ga.getArchivesCount();
    }

    @Override
    public boolean createArchive(String path, String fileName, int mb_size) throws NoAuthorityException, Exception {
        path = path.replace("\\", "/");
        this.ga.createArchive(path, fileName, mb_size);
        return true;
    }

    @Override
    public boolean createRangedArchive(String path, String fileName, int mb_size, Date startTime, Date endTime) throws NoAuthorityException, Exception {
        path = path.replace("\\", "/");
        this.ga.createRangedArchive(startTime, endTime, path, fileName, mb_size);
        return true;
    }

    @Override
    public boolean appendArchive(String path, String fileName, ArchiveState state) throws NoAuthorityException, Exception {
        path = path.replace("\\", "/");
        this.ga.appendArchive(path, fileName, RtdbArchiveState.parse(state.getNum()));
        return true;
    }

    @Override
    public boolean removeArchive(String path, String fileName) throws NoAuthorityException, Exception {
        path = path.replace("\\", "/");
        this.ga.removeArchive(path, fileName);
        return true;
    }

    @Override
    public boolean shiftActived() throws NoAuthorityException, Exception {
        boolean b = false;
        this.ga.shiftActived();
        b = true;
        return b;
    }

    @Override
    public boolean reactiveArchive(String path, String fileName) throws NoAuthorityException, Exception {
        boolean b = false;
        path = path.replace("\\", "/");
        this.ga.reactiveArchive(path, fileName);
        b = true;
        return b;
    }

    @Override
    public ArchiveEntity getFirstArchive() throws NoAuthorityException, Exception {
        RtdbArchiveData entity = this.ga.getFirstArchive();
        ArchiveEntity archive = new ArchiveEntity();
        archive.setFile(entity.getFile());
        archive.setPath(entity.getPath());
        archive.setState(ArchiveState.parse(entity.getState().getNum()));
        return archive;
    }

    @Override
    public ArchiveEntity getNextArchive(String path, String fileName) throws NoAuthorityException, Exception {
        ArchiveEntity archive = null;
        RtdbArchiveData entity = this.ga.getNextArchive(path, fileName);
        archive = new ArchiveEntity();
        archive.setFile(entity.getFile());
        archive.setPath(entity.getPath());
        archive.setState(ArchiveState.parse(entity.getState().getNum()));
        return archive;
    }

    @Override
    public HeaderPage getArchiveInfo(String path, String fileName, int file_id) throws NoAuthorityException, Exception {
        path = path.replace("\\", "/");
        RtdbHeaderPage page = this.ga.getArchiveInfo(path, fileName, file_id);
        HeaderPage headerPage = new HeaderPage();
        BeanUtils.copyProperties(headerPage, page);
        return headerPage;
    }

    @Override
    public RtdbHeaderPage[] getArchivesInfo(String[] path, String[] fileName) throws NoAuthorityException, Exception {
        RtdbHeaderPage[] page = this.ga.getArchivesInfo(path, fileName);
        return page;
    }

    @Override
    public boolean updateArchive(String path, String fileName, int RatedCapacity, int ExCapacity, boolean AutoMerge, boolean AutoArrange) throws NoAuthorityException, Exception {
        boolean b = false;
        int _autoMerge = 0;
        int _autoArrange = 0;
        if (AutoMerge) {
            _autoMerge = 1;
        }
        if (AutoArrange) {
            _autoArrange = 1;
        }
        this.ga.updateArchive(path, fileName, RatedCapacity, ExCapacity, _autoMerge, _autoArrange);
        b = true;
        return b;
    }

    @Override
    public boolean mergeArchive(String path, String fileName) throws NoAuthorityException, Exception {
        boolean b = false;
        this.ga.mergeArchive(path, fileName);
        b = true;
        return b;
    }

    @Override
    public boolean moveArchive(String fileName, String path, String dest) throws NoAuthorityException, Exception {
        boolean b = false;
        b = this.ga.moveArchive(fileName, path, dest);
        return b;
    }

    @Override
    public boolean backupArchive(String path, String fileName, String dest) throws Exception {
        path = path.replace("\\", "/");
        this.ga.backupArchive(path, fileName, dest);
        return true;
    }

    @Override
    public RtdbBigJob queryBigJob(RtdbProcessName process) throws NoAuthorityException, Exception {
        RtdbBigJob job = null;
        RtdbBigJob bigJob = this.ga.queryBigJob(process);
        job = RTDBConvert.convertToRtdbBigJob(bigJob);
        return job;
    }

    @Override
    public List<RtdbArchiveData> getArchives() throws NoAuthorityException, Exception {
        List<RtdbArchiveData> archives = this.ga.getArchives();
        return archives;
    }

    @Override
    public boolean convertIndex(String path, String file) throws NoAuthorityException, Exception {
        boolean b = false;
        String substring = file.substring(file.length() - 4, file.length());
        if (substring != null && substring.equals(".rdf")) {
            path = path.replace("\\", "/");
            b = this.ga.convertIndex(path, file);
        }
        return b;
    }

    @Override
    public boolean reindexArchive(String path, String file) throws NoAuthorityException, Exception {
        boolean b = false;
        String substring = file.substring(file.length() - 4, file.length());
        if (substring != null && substring.equals(".rdf")) {
            path = path.replace("\\", "/");
            return this.ga.reindexArchive(path, file);
        }
        return b;
    }

    @Override
    public boolean arrangeArchive(String path, String file) throws NoAuthorityException, Exception {
        path = path.replace("\\", "/");
        this.ga.arrangeArchive(path, file);
        return true;
    }

    @Override
    public long getArchivesStatus() throws NoAuthorityException, Exception {
        long archivesStatus = this.ga.getArchivesStatus();
        return archivesStatus;
    }

    @Override
    public List<RtdbArchivePerfData> getArchivesPerfData(String[] paths, String[] files) throws NoAuthorityException, Exception {
        return this.ga.getArchivesPerfData(paths, files);
    }

    @Override
    public boolean cancelBigJob(RtdbProcessName processName) throws NoAuthorityException, Exception {
        return this.ga.cancelBigJob(processName);
    }

    @Override
    public boolean ReindexArchive(String path, String fileName) throws NoAuthorityException, Exception {
        boolean b = false;
        this.ga.reindexArchive(path, fileName);
        b = true;
        return b;
    }
}

