package com.beagle.base.bean.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.util.Date;

@Data
public class HistorianFloatInterpoValuesParam {
    @NotNull(message = "id不能为空")
    private Integer id;
    @NotNull(message = "请求次数不能为空")
    private Integer count;

    //        Date dateStart = DateUtil.stringToDate("2017-11-16 18:05:55");
//        Date dateEnd = DateUtil.stringToDate("2017-11-16 20:00:55");
    //纳秒版本时间的传入方式
    //DateTimeNS dateStart = new DateTimeNS(dateDateUtil.stringToDate("2017-11-16 18:05:55"), 0);
    //DateTimeNS dateEnd = new DateTimeNS(DateUtil.stringToDate("2017-11-16 20:00:55"), 0);
    @NotNull(message = "请求开始时间不能为空")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date startTime;
    @NotNull(message = "请求结束时间不能为空")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date endTime;
}
