package com.beagle.base.common.contant;

import lombok.Getter;
/**
 * @author wuwanli
 */
public enum CodeEnum {
    /**
     * 处理成功
     */
    SUCCESS("200", "成功"),
    /**
     * 不支持 HTTP 方法
     */
    HTTP_METHOD_NOT_SUPPORTED("4000001", "不支持 HTTP 方法"),
    /**
     * 参数校验失败
     */
    ARGUMENT_VALID_ERROR("4000003", "参数校验失败"),
    /**
     * 参数类型错误
     */
    ARGUMENT_TYPE_ERROR("4000002", "参数类型错误"),
    /**
     * 必填参数为空
     */
    REQUIRED_PARAMETER_EMPTY("4001002", "必填参数为空"),
    /**
     * 未登录
     */
    NOT_LOGIN("4001003", "用户未登录"),
    /**
     * 处理成功
     */
    UNKNOWN("5000001", "系统异常"),

    /**
     * SQL改写规则不存在
     */
    SQL_REWRITE_NOT_EXITS("5000002", "SQL改写规则不存在"),
    /**
     * SQL转换规则不存在
     */
    SQL_CONVERT_NOT_EXITS("5000003", "SQL转换规则不存在"),
    /**
     * SQL转换规则不存在
     */
    SOUTH_DATABASE_NOT_EXITS("5000004", "南向数据库不存在"),
    /**
     * SQL转换规则不存在
     */
    NORTH_DATABASE_NOT_EXITS("5000005", "北向数据库不存在"),
    /**
     * 文件格式不正确
     */
    FORMAT_MISMATCH_EXITS("5000005", "文件格式不正确"),
    /**
     * 实例端点地址不存在
     */
    ENDPOINT_NOT_EXITS("5000006", "实例端点地址不存在"),
    /**
     * 数据库驱动地址为空
     */
    DRIVER_JAR_URL_NOT_EXITS("5000007", "数据库驱动地址为空"),
    INSTANCE_DATA_NOT_EXISTS("5000008", "实例规则管理数据为空"),

    INSTANCE_INDEX_DATA_NOT_EXISTS("5000009", "实例对应的es索引数据为空"),
    OVER_INDEX_OF_ES("5000010", "查询数据量过大, 建议缩小查询范围"),
    INSTANCE_NOT_AUTH("5000011", "实例未授权"),
    EXCEED_FILE_MAX("5000012", "单文件大小超过5M限制"),
    EXCEED_TOTAL_FILE_MAX("5000013", "总文件大小超过5M限制"),
    UPLOAD_FILE_NAME_EMPTY("5000014", "上传文件格式为空"),
    UPLOAD_FILE_NAME_ERROR("5000015", "上传文件格式错误"),
    EXCEPTION_OPEN_SEARCH("5000016", "OPENSEARCH服务异常"),
    UNAUTHORIZED_OPEN_SEARCH("5000017", "OPENSEARCH未授权"),
    CRYPT_CHECK_FAILED("5000018", "内容防篡改验证失败"),
    ;

    /**
     * 构造函数
     * 
     * @param code 响应码
     * @param desc 响应描述
     */
    CodeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Getter
    private final String code;
    @Getter
    private final String desc;

}