package com.beagle.base.common.util;

import cn.hutool.core.collection.CollUtil;
import com.beagle.base.BasePointsPropertiesNewParam;
import com.beagle.base.bean.vo.BasePointsPropertiesParam;
import com.beagle.base.bean.vo.BaseSearchParam;
import com.beagle.base.bean.vo.BaseSearchPointCountParam;
import com.beagle.base.bean.vo.BaseTableTagNamesParam;
import com.rtdb.model.Entity;
import com.rtdb.model.FullPoint;
import com.rtdb.model.MinPoint;

import java.util.ArrayList;
import java.util.List;

public class BaseUtil {

    public static int[] search(BaseSearchParam param) {
        int [] res = null;
        try {
            res = CommonUtil.getBaseImpl().search(param.getCondition(), param.getCount(), param.getSort());
            if (res != null) {
                return res;
            }
            return new int[]{};
        }catch (Exception e) {
            e.printStackTrace();
            return new int[]{};
        }
    }

    // 获取测点全属性
    public static List<FullPoint> getPointsProperties(BasePointsPropertiesParam param) {
        List<FullPoint> res = new ArrayList<>();
        try {
            Entity<FullPoint> entity = null;
            entity = CommonUtil.getBaseImpl().getPointsProperties(param.getIds());
            if (entity != null & CollUtil.isNotEmpty(entity.getList())) {
                res = entity.getList();
            }
            return  res;
        }catch (Exception e){
            e.printStackTrace();
            return res;
        }
    }

    public static Integer searchPointCount(BaseSearchPointCountParam param) {
        int res = 0;
        try {
            res = CommonUtil.getBaseImpl().searchPointCount(param.getCondition(), param.getSort());
        }catch (Exception e){
            e.printStackTrace();
            return res;
        }
        return res;
    }

    public static String[] getTableTagNames(BaseTableTagNamesParam param) {
        String [] res = null;
        try {
            res = CommonUtil.getBaseImpl().getTableTagNames(param.getIds());
        }catch (Exception e){
            e.printStackTrace();
            res = new String[0];
            return res;
        }
        return res;
    }

    public static List<MinPoint> getPointsPropertiesTags(BasePointsPropertiesNewParam param) {
        List<MinPoint> res = new ArrayList<>();;
        try {
            Entity<MinPoint> pointsProperties = CommonUtil.getBaseImpl().getPointsProperties(param.getTagName());
            if (pointsProperties != null && CollUtil.isNotEmpty(pointsProperties.getList())) {
                res = pointsProperties.getList();
            }
        }catch (Exception e){
            e.printStackTrace();
            return res;
        }
        return res;
    }
}
