package com.beagle.base.common.util;

import cn.hutool.core.collection.CollUtil;
import com.beagle.base.bean.vo.HistorianDoubleArchivedValuesParam;
import com.beagle.base.bean.vo.HistorianFloatArchivedValuesFiltParam;
import com.beagle.base.bean.vo.HistorianFloatInterpoValuesParam;
import com.beagle.base.bean.vo.HistorianFloatIntervalValuesParam;
import com.rtdb.model.DoubleData;

import java.util.ArrayList;
import java.util.List;

public class HistorianUtil {

    public static List<DoubleData> getFloatIntervalValues(HistorianFloatIntervalValuesParam param ) {
        List<DoubleData> res;
        try {
            res = CommonUtil.getHisImpl().getFloatIntervalValues(param.getId(), param.getInterval(), param.getCount(), param.getDateTime());
            if (CollUtil.isNotEmpty(res)) {
                return res;
            }
            return new ArrayList<>();
        }catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<>();
        }
    }


    public static List<DoubleData> getFloatInterpoValues(HistorianFloatInterpoValuesParam param) {
        List<DoubleData> res;
        try {
            res =  CommonUtil.getHisImpl().getFloatInterpoValues(param.getId(), param.getCount(), param.getStartTime(), param.getEndTime());
            if (CollUtil.isNotEmpty(res)) {
                return res;
            }
            return new ArrayList<>();
        }catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<>();
        }
    }

    public static List<DoubleData> getFloatArchivedValuesFilt(HistorianFloatArchivedValuesFiltParam param) {
        List<DoubleData> res;
        try {
            res =  CommonUtil.getHisImpl().getFloatArchivedValuesFilt(param.getId(), param.getFilter(), param.getCount(), param.getStartTime(), param.getEndTime());
            if (CollUtil.isNotEmpty(res)) {
                return res;
            }
            return new ArrayList<>();
        }catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<>();
        }
    }

    public static List<DoubleData> getDoubleArchivedValues(HistorianDoubleArchivedValuesParam param) {
        List<DoubleData> res;
        try {
            res = CommonUtil.getHisImpl().getDoubleArchivedValues(param.getId(),  param.getCount(), param.getStartTime(), param.getEndTime());
            if (CollUtil.isNotEmpty(res)) {
                return res;
            }
            return new ArrayList<>();
        }catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<>();
        }
    }
}
