package com.beagle.base.common.util;

import cn.hutool.core.collection.CollUtil;
import com.beagle.base.bean.vo.SnapshotBlobParam;
import com.beagle.base.bean.vo.SnapshotCoorParam;
import com.beagle.base.bean.vo.SnapshotDoubleParam;
import com.beagle.base.bean.vo.SnapshotIntParam;
import com.rtdb.model.*;

import java.util.ArrayList;
import java.util.List;

public class SnapshotUtil {

    public static List<DoubleData> getDoubleSnapshots(SnapshotDoubleParam param) {
        List<DoubleData> res = new ArrayList<>();
        try {
            Entity<DoubleData> d = CommonUtil.getSnapshotImpl().getDoubleSnapshots(param.getIds());
            if (d != null && CollUtil.isNotEmpty(d.getList())) {
                res = d.getList();
            }
            return res;
        }catch (Exception e) {
            e.printStackTrace();
            return res;
        }
    }

    public static List<IntData> getIntSnapshots(SnapshotIntParam param) {
        List<IntData> res = new ArrayList<>();
        try {
            Entity<IntData> intSnapshots = CommonUtil.getSnapshotImpl().getIntSnapshots(param.getIds());
            if (intSnapshots != null && CollUtil.isNotEmpty(intSnapshots.getList())) {
                res = intSnapshots.getList();
            }
            return res;
        }catch (Exception e) {
            e.printStackTrace();
            return res;
        }
    }

    public static List<BlobData> getBlobSnapshots(SnapshotBlobParam param) {
        List<BlobData> res = new ArrayList<>();
        try {
            Entity<BlobData> blobSnapshots = CommonUtil.getSnapshotImpl().getBlobSnapshots(param.getIds());
            if (blobSnapshots != null && CollUtil.isNotEmpty(blobSnapshots.getList())) {
                res = blobSnapshots.getList();
            }
            return res;
        }catch (Exception e) {
            e.printStackTrace();
            return res;
        }
    }

    public static List<CoorData> getCoorSnapshots(SnapshotCoorParam param) {
        List<CoorData> res = new ArrayList<>();
        try {
            Entity<CoorData> coorSnapshots = CommonUtil.getSnapshotImpl().getCoorSnapshots(param.getIds());
            if (coorSnapshots != null && CollUtil.isNotEmpty(coorSnapshots.getList())) {
                res = coorSnapshots.getList();
            }
            return res;
        }catch (Exception e) {
            e.printStackTrace();
            return res;
        }
    }
}
