package com.beagle.base.controller;

import com.beagle.base.BasePointsPropertiesNewParam;
import com.beagle.base.bean.vo.BasePointsPropertiesParam;
import com.beagle.base.bean.vo.BaseSearchParam;
import com.beagle.base.bean.vo.BaseSearchPointCountParam;
import com.beagle.base.bean.vo.BaseTableTagNamesParam;
import com.beagle.base.bean.vo.resp.Response;
import com.beagle.base.service.BaseService;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import com.rtdb.model.FullPoint;
import com.rtdb.model.MinPoint;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

/**
 * 数据库字段加密、防篡改接口
 *
 * @author lzz
 */
@Api(tags = "基本信息点服务实现类")
@RestController
@RequestMapping("/v1/base")
public class BaseController {
    @Resource
    private BaseService baseService;

    @ApiOperationSupport(order = 1)
    @ApiOperation(value = "在表中搜索符合条件的标签点，使用标签点名时支持通配符")
    @PostMapping("/search")
    public Response<int[]> search(@RequestBody @ApiParam(value = "入参") @Validated BaseSearchParam param) {
        return new Response<>(baseService.search(param));
    }

    @ApiOperationSupport(order = 2)
    @ApiOperation(value = "根据ids批量获取标签点属性")
    @PostMapping("/getPointsProperties")
    public Response<List<FullPoint>> getPointsProperties(@RequestBody @ApiParam(value = "入参") @Validated BasePointsPropertiesParam param) {
        return new Response<>(baseService.getPointsProperties(param));
    }

    @ApiOperationSupport(order = 3)
    @ApiOperation(value = "根据ids批量获取标签点属性")
    @PostMapping("/searchPointCount")
    public Response<Integer> searchPointCount(@RequestBody @ApiParam(value = "入参") @Validated BaseSearchPointCountParam param) {
        return new Response<>(baseService.searchPointCount(param));
    }
    @ApiOperationSupport(order = 4)
    @ApiOperation(value = "根据标签点ids获取测点全名称")
    @PostMapping("/getTableTagNames")
    public Response<String []> getTableTagNames(@RequestBody @ApiParam(value = "入参") @Validated BaseTableTagNamesParam param) {
        return new Response<>(baseService.getTableTagNames(param));
    }

    @ApiOperationSupport(order = 5)
    @ApiOperation(value = "根据标签点ids获取测点全名称")
    @PostMapping("/getPointsProperties/tags")
    public Response<List<MinPoint>> getPointsPropertiesTags(@RequestBody @ApiParam(value = "入参") @Validated BasePointsPropertiesNewParam param) {
        return new Response<>(baseService.getPointsPropertiesTags(param));
    }
}
