import com.alibaba.fastjson2.JSON;
import com.beagle.base.BasePointsPropertiesNewParam;
import com.beagle.base.bean.vo.BaseSearchPointCountParam;
import com.beagle.base.bean.vo.resp.Response;
import com.rtdb.api.enums.SearchMask;
import com.rtdb.enums.DataSort;
import com.rtdb.enums.Quality;
import com.rtdb.enums.TagType;
import com.rtdb.enums.ValueType;
import com.rtdb.model.*;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class Test {
    public static void main(String[] args) {
        testMinPoint();
    }
    private static void testDoubleData() {
        List<DoubleData> list = new ArrayList<>();
        DoubleData doubleData = new DoubleData();
        doubleData.setId(1);
        doubleData.setError(11);
        doubleData.setNanosecond(1111111);
        doubleData.setQuality(Short.parseShort("1"));
        doubleData.setValue(Double.parseDouble("12.3"));
        doubleData.setDateTime(Calendar.getInstance().getTime());
        list.add(doubleData);
        System.out.println(JSON.toJSONString(new Response<>(list)));
    }

    private static void testBlobData() {
        List<BlobData> list = new ArrayList<>();
        BlobData doubleData = new BlobData();
        doubleData.setId(1);
        doubleData.setError(11);
        doubleData.setNanosecond(1111111);
        doubleData.setQuality(Quality.BAD);
        doubleData.setBlob("测试".getBytes(StandardCharsets.UTF_8));
        doubleData.setDatetime(Calendar.getInstance().getTime());
        doubleData.setLen(1);
        list.add(doubleData);
        System.out.println(JSON.toJSONString(new Response<>(list)));
    }

    private static void testCoorData() {
        List<CoorData> list = new ArrayList<>();
        CoorData doubleData = new CoorData();
        doubleData.setId(1);
        doubleData.setError(11);
        doubleData.setNanosecond(1111111);
        doubleData.setQuality(Short.parseShort("1"));
        doubleData.setX(Float.parseFloat("1.2"));
        doubleData.setY(Float.parseFloat("1.4"));
        doubleData.setDateTime(Calendar.getInstance().getTime());
        list.add(doubleData);
        System.out.println(JSON.toJSONString(new Response<>(list)));
    }

    private static void testBaseSearchPointCountParam() {
        SearchConditionTotal searchConditionTotal = new SearchConditionTotal();
        searchConditionTotal.set_SearchCondition(SearchMask.SEARCH_ARCHIVE);
        searchConditionTotal.set_TimeAccuracy(1);
        searchConditionTotal.set_PointType(PointType.ALARM);
        searchConditionTotal.setSearchMaskValue("test");
        searchConditionTotal.set_ValueTypeString("test");
        BaseSearchPointCountParam baseSearchPointCountParam = new BaseSearchPointCountParam();
        baseSearchPointCountParam.setCondition(searchConditionTotal);
        baseSearchPointCountParam.setSort(DataSort.SORT_BY_ID);
        System.out.println(JSON.toJSONString(baseSearchPointCountParam));
    }


    private static void testSearchPointCount() {

        System.out.println(JSON.toJSONString(new Response<>(1)));
    }

    private static void testGetTableTagNames() {
        String[] tag = {"1"};
        System.out.println(JSON.toJSONString(new Response<>(tag)));
    }

    private static void testGetPointsProperties_tags() {
        String[] tag = {"1"};
        BasePointsPropertiesNewParam basePointsPropertiesNewParam = new BasePointsPropertiesNewParam();
        basePointsPropertiesNewParam.setTagName(tag);

        System.out.println(JSON.toJSONString(basePointsPropertiesNewParam));
    }

    public static void testMinPoint() {
        List<MinPoint> list = new ArrayList<>();
        MinPoint minPoint = new MinPoint();
        minPoint.setId(1);
        minPoint.setDesc("desc");
        minPoint.setTagName("tag name");
        minPoint.setTableId(1);
        minPoint.setTagType(TagType.ALARM);
        minPoint.setValueType(ValueType.RTDB_BLOB);
        minPoint.setUseMs(1);

        list.add(minPoint);
        System.out.println(JSON.toJSONString(new Response<>(list)));
    }
}
