#!/bin/bash

check_rcache_health() {
    if [[ -n "${RCACHE_PASSWORD}" ]]; then
        export RCACHECLI_AUTH="${RCACHE_PASSWORD}"
    fi
    if [[ "${TLS_MODE}" == "true" ]]; then
        rcache-cli --tls --cert "${RCACHE_TLS_CERT}" --key "${RCACHE_TLS_CERT_KEY}" --cacert "${RCACHE_TLS_CA_KEY}" -h "$(hostname)" ping
    else
        rcache-cli -h $(hostname) ping
    fi
}

check_rcache_health
