#!/bin/bash

rcache_server_mode() {
    if [[ "${SERVER_MODE}" == "master" ]]; then
        echo " server mode is master"
        if [[ -z "${RCACHE_PASSWORD}" ]]; then
             rcache-cli --cluster create "${MASTER_LIST}" --cluster-yes
        else
            rcache-cli --cluster create "${MASTER_LIST}" --cluster-yes -a "${RCACHE_PASSWORD}"
        fi
    elif [[ "${SERVER_MODE}" == "slave" ]]; then
        echo "rcache server mode is slave"
        if [[ -z "${RCACHE_PASSWORD}" ]]; then
            rcache-cli --cluster add-node "${SLAVE_IP}" "${MASTER_IP}" --cluster-slave
        else
            rcache-cli --cluster add-node "${SLAVE_IP}" "${MASTER_IP}" --cluster-slave -a "${RCACHE_PASSWORD}"
        fi
    else
        echo "rcache server mode is standalone"
    fi
}

rcache_server_mode
