@echo off
@REM
@REM Copyright (c) 2018-2022
@REM Beijing Baolande Software Corporation
@REM
@REM All Rights Reserved
@REM

setlocal

rem Guess BES_HOME if not defined
set "CURRENT_DIR=%cd%"
if not "%BES_HOME%" == "" goto validateBesHome
set "BES_HOME=%CURRENT_DIR%"
if exist "%BES_HOME%\bin\startserver.bat" goto rightBesHome
cd ..
set "BES_HOME=%cd%"
cd "%CURRENT_DIR%"

:validateBesHome
if not exist "%BES_HOME%\bin\setenv.bat" goto errorBesHome
if not exist "%BES_HOME%\bin\setpatchenv.bat" goto errorBesHome
goto rightBesHome

:errorBesHome
echo The BES_HOME environment variable is not defined correctly
echo This environment variable is needed to run this program
goto error

:rightBesHome

rem Copy BES_ROOT from BES_HOME if not defined
if not "%BES_ROOT%" == "" goto setBesRoot
set "BES_ROOT=%BES_HOME%"
:setBesRoot

rem Ensure that neither BES_HOME nor BES_ROOT contains a semi-colon
rem as this is used as the separator in the classpath and Java provides no
rem mechanism for escaping if the same character appears in the path. Check this
rem by replacing all occurrences of ';' with '' and checking that neither
rem BES_HOME nor BES_ROOT have changed
if "%BES_HOME%" == "%BES_HOME:;=%" goto besHomeNoSemicolon
echo Unable to start as BES_HOME contains a semicolon (;) character
goto error

:besHomeNoSemicolon

if "%BES_ROOT%" == "%BES_ROOT:;=%" goto besRootNoSemicolon
echo Unable to start as BES_ROOT contains a semicolon (;) character
goto error
:besRootNoSemicolon

set CLASSPATH=

call "%BES_HOME%\bin\setenv.bat"
call "%BES_HOME%\bin\setpatchenv.bat" bootstrap

set CLASSPATH=%CLASSPATH%;%BES_HOME%\lib\bootstrap\bes-common-util.jar
set CLASSPATH=%CLASSPATH%;%BES_HOME%\lib\bootstrap\bes-common-core.jar
set CLASSPATH=%CLASSPATH%;%BES_HOME%\lib\bootstrap\bes-config-provider.jar
set CLASSPATH=%CLASSPATH%;%BES_HOME%\lib\bootstrap\bes-gmssl.jar

if "%PATCH_CLASSPATH%" == "" goto digest
set CLASSPATH=%PATCH_CLASSPATH%;%CLASSPATH%

:digest
%JAVA% %JAVA_OPTS% -cp "%CLASSPATH%" -Dcom.bes.installRoot="%BES_HOME%" com.bes.enterprise.config.digest.DigestMain %*

endlocal

goto end

:error
exit /b 1

:end
exit /b 0
